/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.report.PDFReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SubReportUI;

public class PDFSubReport
extends PDFReport
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(PDFSubReport.class.getName());
    protected boolean checkVisibility = false;
    protected boolean finish = false;
    public Object LOCK = new Object();
    public int templateIndex;
    private boolean writePageFooter = false;
    float reportWidth;
    float shift;
    float offsetX;
    protected float pageTopY;
    protected PDFReport parent;
    protected ReportSection parentSection;
    protected float remainingSectionHeight;
    protected float myPageHeight;

    public PDFSubReport() {
    }

    public PDFSubReport(Report subreport, float x, float y, float reportWidth, float reportHeight, PDFReport parent) {
        this.report = subreport;
        this.parent = parent;
        this.leftMargin = parent.leftMargin;
        this.rightMargin = parent.rightMargin;
        this.topMargin = parent.topMargin;
        this.bottomMargin = parent.bottomMargin;
        this.reportGraphics = parent.reportGraphics;
        this.pageFooterHeight = parent.pageFooterHeight;
        if (reportHeight < 0.0f) {
            this.pageHeight = parent.pageHeight;
            float footerHeight = 0.0f;
            try {
                footerHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0f : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeightToPoints();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't set footer height", ex);
            }
            this.pageHeight -= footerHeight;
            this.pageFooterHeight += footerHeight;
        } else {
            this.checkVisibility = true;
            float actualPageHeight = parent.pageHeight + parent.pageFooterHeight + parent.topMargin;
            this.pageHeight = reportHeight < actualPageHeight ? reportHeight : actualPageHeight;
            this.bottomMargin = parent.pageHeight - this.pageHeight + parent.bottomMargin;
        }
        this.reportWidth = reportWidth;
        this.pageWidth = parent.pageWidth;
        this.elementXPos = 0.0f;
        this.elementYPos = y;
        this.offsetX = x;
        this.pageHeaderHeight = parent.pageHeaderHeight;
        this.currentPageNumber = parent.currentPageNumber;
        this.totalPageNumber = parent.totalPageNumber;
        this.currentSection = parent.currentSection;
        this.totalSections = parent.totalSections;
        this.fontMapping = parent.fontMapping;
        try {
            this.reportUI = new SubReportUI(subreport, QbUtil.pointsToInch(x), QbUtil.pointsToInch(y), QbUtil.pointsToInch(reportWidth), QbUtil.pointsToInch(reportHeight), parent.reportUI);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't create SubReport UI", ex);
        }
        this.checkTotalPageNumber = parent.checkTotalPageNumber;
        this.templateIndex = parent.getContentByteIndex(x);
        this.totalSections = parent.getTotalSections();
        this.templates = new PdfContentByte[this.totalSections - this.templateIndex];
        if (parent.checkFitGroupOnPage) {
            this.templates[0] = parent.templates[0].createTemplate(parent.document.getPageSize().width(), parent.document.getPageSize().height());
        } else {
            for (int i = 0; i < this.templates.length; ++i) {
                this.templates[i] = parent.templates[this.templateIndex + i];
            }
        }
        this.document = parent.document;
        this.language = parent.language;
        this.pageTopY = this.elementYPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ReportTable table;
            this.formatTable();
            Vector<ReportTable> vec = this.report.getReportTables();
            this.hTable = table = vec.elementAt(0);
            this.fTable = vec.elementAt(vec.size() - 1);
            if (this.report.getInitializeReportError() != null) {
                this.writeSection(ReportUI.createErrorSection(this.report.getActualPageWidth(), this.report.getActualPageHeight(), this.report.getInitializeReportError()), table);
            } else {
                this.initRepeatSection();
                this.writeSection(this.report.getPageHeader(), table);
                this.writePageFooter = true;
                this.writeSection(this.report.getReportHeader(), table);
                for (int i = 0; i < vec.size(); ++i) {
                    table = (ReportTable)vec.elementAt(i);
                    this.initRepeatSection();
                    this.setColumnWrap();
                    this.wrapInfo = new float[]{0.0f, this.elementYPos, this.elementYPos};
                    this.writeReportTable(table);
                    this.resetColumnWrap();
                }
                table = (ReportTable)vec.elementAt(vec.size() - 1);
                this.writeSection(this.report.getReportFooter(), table);
                this.writeSection(this.report.getPageFooter(), table, this.checkVisibility);
            }
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run PDFSubReport", ex);
            } else {
                LOGGER.log(Level.FINEST, "PDFSubReport - page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run PDFSubReport", err);
        }
        finally {
            this.finish = true;
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
            }
        }
    }

    protected boolean isFinished() {
        return this.finish;
    }

    @Override
    void setColumnWrap() {
        super.setColumnWrap(this.reportWidth);
    }

    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        this.pageBreak(section, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section, boolean isTOC) throws Exception {
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.writePageFooter) {
            this.writeSection(this.report.getPageFooter(), this.fTable, false);
        }
        ++this.currentPageNumber;
        ++this.pagebreaks;
        this.rowCount = 0;
        if (this.checkFitGroupOnPage) {
            throw new Exception("stop writing because of fit group on page");
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.elementXPos = 0.0f;
        this.writeSectionColor();
        if (this.writePageFooter) {
            this.writeSection(this.report.getPageHeader(), this.hTable);
        }
        this.writeRepeatSection(section);
    }

    @Override
    protected int getContentByteIndex(float x) {
        int index = (int)Math.floor(((double)(x + this.shift) + 0.001) / (double)this.pageWidth) - this.templateIndex;
        return index;
    }

    @Override
    protected void sectionBreak(float x, float requiredWidth) {
        if (Math.ceil((x + this.elementXPos + this.offsetX + requiredWidth) / this.pageWidth) != Math.ceil((x + this.elementXPos + this.offsetX) / this.pageWidth) && (x + this.elementXPos + this.offsetX) % this.pageWidth != 0.0f) {
            float temp = this.pageWidth - (x + this.elementXPos + this.offsetX) % this.pageWidth;
            this.elementXPos += temp;
            this.shift = Math.floor((x + this.elementXPos + this.offsetX) / this.pageWidth) == (double)(this.templateIndex + 1) ? temp : (this.shift += temp);
        }
        if (!this.inPageSection) {
            this.currentSection = (int)Math.floor((this.offsetX + x + this.elementXPos) / this.pageWidth) + 1;
        }
    }

    @Override
    protected float getX(ReportElement elt) {
        return elt.getXToPoints() + this.elementXPos + this.offsetX;
    }

    protected void writeTableDataElementPDFReport(ReportElement elt, ReportTable table, ReportTableElement panel) throws Exception, IOException, MalformedURLException {
        super.writeTableDataElement(elt, table, panel, 0);
    }

    @Override
    protected void writeTableDataElement(ReportElement elt, ReportTable table, ReportTableElement panel) throws Exception, IOException, MalformedURLException {
        if ((double)(elt.getXToPoints() + elt.getWidthToPoints()) > (double)this.reportWidth + 0.001) {
            return;
        }
        super.writeTableDataElement(elt, table, panel);
    }

    @Override
    protected void writeTableDataElement(ReportElement elt, ReportTable table, ReportTableElement panel, int row) throws Exception, IOException, MalformedURLException {
        if ((double)(elt.getXToPoints() + elt.getWidthToPoints()) > (double)this.reportWidth + 0.001) {
            return;
        }
        super.writeTableDataElement(elt, table, panel, row);
    }

    @Override
    protected void writeSectionBgColor(ReportElement section) {
        if (section.getBgColor() != null && !this.checkFitGroupOnPage) {
            int i;
            float lly = this.getY(section) - section.getHeightToPoints();
            float ury = this.getY(section);
            float minX = (this.offsetX + this.elementXPos) % this.pageWidth;
            int count = (int)Math.floor((this.offsetX + this.elementXPos) / this.pageWidth);
            float availableWidth = this.pageWidth - minX;
            float maxX = availableWidth > this.reportWidth ? this.reportWidth + minX : this.pageWidth;
            this.writeFilledRectangle(this.offsetX + this.elementXPos, lly, maxX += this.pageWidth * (float)count, ury, section.getBgColor());
            count = (int)Math.ceil((this.offsetX + this.reportWidth + this.shift) / this.pageWidth);
            for (i = this.templateIndex + 1; i < count - 1; ++i) {
                this.writeFilledRectangle(this.pageWidth * (float)i, lly, this.pageWidth * (float)(i + 1), ury, section.getBgColor());
            }
            if (count > 1) {
                this.writeFilledRectangle(this.pageWidth * (float)i, lly, this.pageWidth * (float)i + (this.offsetX + this.reportWidth + this.shift) % this.pageWidth, ury, section.getBgColor());
            }
        }
    }

    protected float writeRemainingSubReports(Vector remainingSubReports, Vector oneTime, Vector oneTimeY, ReportSection section, ReportTable tbl, ReportElement[] relts, float[] shifts) throws Exception {
        float bottomYOfSection = 0.0f;
        while (remainingSubReports != null && remainingSubReports.size() > 0 || oneTime != null && oneTime.size() > 0) {
            this.elementYPos += 1.0f;
            if (oneTime == null || this.elementYPos + this.pageFooterHeight + this.bottomMargin >= this.pageHeight) {
                this.pageBreak(section);
            }
            bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, relts, shifts);
        }
        return bottomYOfSection;
    }

    void setParentSection(ReportSection parentSection, float myPageHeight) {
        this.parentSection = parentSection;
        if (parentSection == null) {
            return;
        }
        this.remainingSectionHeight = parentSection.getHeightToPoints() - (myPageHeight - this.pageTopY);
        this.myPageHeight = myPageHeight;
    }

    void writeSectionColor() throws IOException {
        if (this.parentSection == null) {
            return;
        }
        float writeHeight = this.remainingSectionHeight;
        if (writeHeight > this.myPageHeight) {
            writeHeight = this.myPageHeight;
            this.remainingSectionHeight -= this.myPageHeight;
        } else {
            this.remainingSectionHeight = 0.0f;
        }
        if (writeHeight > 0.0f) {
            double d = this.parentSection.getHeight();
            this.parentSection.setHeight(QbUtil.pointsToInch(writeHeight));
            this.parent.writeSectionBgColor(this.parentSection);
            this.parentSection.setHeight(d);
        }
    }
}

