/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.output.pdf.PdfContentByte;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.PDFReport;
import quadbase.reportdesigner.report.PDFSubReport;

public class PDFTOCObject
extends PDFSubReport {
    private static final Logger LOGGER = Logger.getLogger(PDFTOCObject.class.getName());
    private TableOfContents toc;
    private ReportTable tbl;

    public PDFTOCObject(TableOfContents toc, ReportTable tbl, float x, float y, float reportWidth, float reportHeight, PDFReport parent) {
        this.report = parent.report;
        this.tbl = tbl;
        this.parent = parent;
        this.leftMargin = parent.getAbsoluteX(x);
        this.rightMargin = parent.rightMargin;
        this.topMargin = parent.topMargin;
        this.bottomMargin = parent.bottomMargin;
        this.reportGraphics = parent.reportGraphics;
        this.pageFooterHeight = parent.pageFooterHeight;
        if (reportHeight < 0.0f) {
            this.pageHeight = parent.pageHeight;
            float footerHeight = 0.0f;
            try {
                footerHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0f : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeightToPoints();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't set footer height", ex);
            }
            this.pageHeight -= footerHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
            this.bottomMargin = parent.pageHeight - this.pageHeight + parent.bottomMargin;
        }
        this.pageWidth = reportWidth;
        this.elementXPos = 0.0f;
        this.elementYPos = y;
        this.pageHeaderHeight = parent.pageHeaderHeight;
        this.currentPageNumber = parent.currentPageNumber;
        this.totalPageNumber = parent.totalPageNumber;
        this.currentSection = parent.currentSection;
        this.totalSections = parent.totalSections;
        this.fontMapping = parent.fontMapping;
        this.reportUI = parent.reportUI;
        this.checkTotalPageNumber = parent.checkTotalPageNumber;
        this.templates = new PdfContentByte[1];
        this.templateIndex = parent.getContentByteIndex(x);
        this.templates[0] = parent.checkFitGroupOnPage ? parent.templates[0].createTemplate(parent.document.getPageSize().width(), parent.document.getPageSize().height()) : parent.templates[this.templateIndex];
        this.document = parent.document;
        this.language = parent.language;
        if (reportHeight < 0.0f) {
            this.pageHeight = parent.pageHeight;
        }
        this.toc = toc;
        this.pageTopY = this.elementYPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            double lineSpace = 0.0;
            double miniSpacer = 0.2;
            float old_elementYPos = this.elementYPos;
            float old_elementXPos = this.elementXPos;
            this.elementYPos += this.toc.getYToPoints();
            for (int i = 0; i < this.toc.getBookmarks().size(); ++i) {
                Bookmark entry = this.toc.getBookmarks().elementAt(i);
                double indentWidth = this.toc.getIndentInInches(entry);
                ReportCell numberingElt = this.toc.getFormattedNumbering(entry);
                double numberingWidth = 0.1;
                if (numberingElt != null) {
                    numberingWidth = numberingElt.getWidth();
                }
                ReportCell pageNumberElt = this.toc.getFormattedPageNumber(entry);
                double pageNumberWidth = pageNumberElt.getWidth();
                double maxTitleWidth = this.toc.getWidth() - indentWidth - numberingWidth - miniSpacer - pageNumberWidth;
                ReportCell titleElt = this.toc.getFormattedTitle(entry, maxTitleWidth);
                double entryHeight = this.toc.getEntryHeight(entry, maxTitleWidth);
                LOGGER.finest("entryHeight= " + entryHeight);
                if (!this.toc.isResizeToFitContent() && this.elementYPos + QbUtil.toPoints(entryHeight) > old_elementYPos + this.toc.getHeightToPoints()) {
                    break;
                }
                this.pageBreak(QbUtil.toPoints(entryHeight), null, true);
                if (this.toc.getBgColor() != null) {
                    this.writeFilledRectangle(this.getX(titleElt), this.getY(titleElt) - titleElt.getHeightToPoints(), this.getX(titleElt) + this.toc.getWidthToPoints(), this.getY(titleElt), this.toc.getBgColor());
                }
                this.elementXPos += QbUtil.toPoints(indentWidth);
                if (this.toc.isShowNumbering()) {
                    if (numberingElt == null) {
                        numberingElt = new ReportGrid();
                        numberingElt.setWidth(0.04);
                        numberingElt.setHeight(0.04);
                        numberingElt.setBorderThickness(1);
                        numberingElt.setY(entryHeight / 2.0 - 0.04);
                        numberingElt.setBgColor(Color.darkGray);
                    }
                    LOGGER.finest("writeTableDataEle for TOC(xpos = " + this.elementYPos);
                    this.writeTableDataElement(numberingElt, this.tbl, this.tbl);
                    this.elementXPos += numberingElt.getWidthToPoints();
                }
                this.writeTableDataElement(titleElt, this.tbl, this.tbl);
                this.elementXPos += titleElt.getWidthToPoints();
                if (this.toc.isShowPageNumber()) {
                    if (this.toc.isShowSpacer()) {
                        double spacerWidth = QbUtil.pointsToInch(old_elementXPos) + this.toc.getWidth() - QbUtil.pointsToInch(this.elementXPos) - pageNumberWidth;
                        ReportCell line = this.toc.getSpacer(spacerWidth, entryHeight, entry);
                        this.writeTableDataElement(line, this.tbl, this.tbl);
                        this.elementXPos += line.getWidthToPoints();
                    }
                    this.toc.setCellHeight(pageNumberElt, entryHeight, entry);
                    this.writeTableDataElement(pageNumberElt, this.tbl, this.tbl);
                }
                this.elementXPos = old_elementXPos;
                this.elementYPos += QbUtil.toPoints(entryHeight + lineSpace);
            }
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run PDFTOCObject", ex);
            } else {
                LOGGER.log(Level.FINEST, "PDFTOCObject: page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run PDFTOCObject", err);
        }
        finally {
            this.finish = true;
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
            }
        }
    }

    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        this.pageBreak(section, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section, boolean isToc) throws Exception {
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        ++this.currentPageNumber;
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.writeSectionColor();
        this.elementXPos = 0.0f;
        this.pageTopY = this.elementYPos;
    }

    @Override
    protected void writeTableDataElement(ReportElement elt, ReportTable table, ReportTableElement panel) throws Exception, IOException, MalformedURLException {
        this.writeTableDataElementPDFReport(elt, table, panel);
    }
}

