/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.QbGraphics;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ImageMapNode;
import quadbase.reportdesigner.report.PageGraphics;
import quadbase.reportdesigner.report.PageReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SubReportUI;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.Dimension2D;

public class PageBufferGraphics
extends ReportGraphics {
    private static final Logger LOGGER = Logger.getLogger(PageBufferGraphics.class.getName());
    int totalSections;
    ByteArrayOutputStream[][] bstream;
    DataOutputStream[][] dsout;
    ByteArrayOutputStream fbout;
    DataOutputStream fdout;
    QbGraphics[][] qbGraphics;
    Vector[][] mapFiles;
    private boolean[] isBufferUsed;
    static int PAGE_VERSION = 2;
    static int LAST_VERSION = 1;
    int curPage = 0;
    String baseFile;
    ExportThread exportThread;
    PageReport pageReport;
    boolean done = false;
    long time = 0L;
    private int PAGEBUFFERSIZE = 20;
    private ReportUI parentReportUI = null;

    public PageBufferGraphics(ReportUI repUI, String baseFile, PageReport pageReport) {
        super(repUI, null);
        this.pageReport = pageReport;
        this.totalSections = this.reportUI.getTotalSections();
        if (repUI.report.containsZIndex()) {
            this.PAGEBUFFERSIZE = 50;
        }
        this.setCurrentPosition(repUI.report.getLeftMargin(), repUI.report.getTopMargin() + repUI.pageHeaderH);
        this.setDrawablePageSection(0.0, 0.0, repUI.pageSize.getWidth(), repUI.pageSize.getHeight());
        this.baseFile = baseFile;
        this.bstream = new ByteArrayOutputStream[this.PAGEBUFFERSIZE][this.totalSections];
        this.dsout = new DataOutputStream[this.PAGEBUFFERSIZE][this.totalSections];
        this.qbGraphics = new QbGraphics[this.PAGEBUFFERSIZE][this.totalSections];
        this.mapFiles = new Vector[this.PAGEBUFFERSIZE][this.totalSections];
        this.isBufferUsed = new boolean[this.PAGEBUFFERSIZE];
        this.exportThread = new ExportThread();
        this.exportThread.start();
        try {
            this.newPage();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't open new page", ex);
        }
        this.g = this.qbGraphics[0][0];
        this.textG = repUI.textGraphics;
    }

    private void newFile() throws IOException {
        if (this.curPage % 10 == 0) {
            if (this.fbout != null) {
                this.fdout.close();
                this.fbout.close();
                LOGGER.finest("Close1: " + PageBufferGraphics.getFileName(this.baseFile, this.curPage / 10 - 1, "page"));
                LOGGER.finest("Time: " + (double)(System.currentTimeMillis() - this.time) / 1000.0);
                this.exportThread.queue(this.fbout.toByteArray(), PageBufferGraphics.getFileName(this.baseFile, this.curPage / 10 - 1, "page"));
                if (this.done) {
                    this.exportThread.queue(this.writeLastPage(this.curPage), PageBufferGraphics.getFileName(this.baseFile, "LAST", "page"));
                }
            }
            this.time = System.currentTimeMillis();
            this.fbout = new ByteArrayOutputStream(1024);
            this.fdout = new DataOutputStream(this.fbout);
            this.fdout.writeInt(PAGE_VERSION);
        }
    }

    @Override
    void setReportUI(ReportUI rptUI) {
        LOGGER.finest("Set report UI");
        if (rptUI instanceof SubReportUI && this.parentReportUI == null) {
            this.parentReportUI = this.reportUI;
        }
        this.reportUI = rptUI;
    }

    @Override
    void resetReportUI() {
        LOGGER.finest("Reset report UI");
        if (this.parentReportUI == null) {
            return;
        }
        this.reportUI = this.parentReportUI;
        this.parentReportUI = null;
    }

    @Override
    void done() {
        while (this.isBufferUsed[1]) {
            ++this.curPage;
            LOGGER.finest("Done: print page: " + this.curPage);
            this.pageY = this.pageH + this.pageY;
            try {
                this.newPage();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't open new page", ex);
            }
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile() throws Exception {
        if (this.qbGraphics[0][0] == null) {
            return;
        }
        for (int i = 0; i < this.totalSections; ++i) {
            this.drawPageFooter(this.qbGraphics[0][i], this.mapFiles[0][i], this.curPage + 1, i + 1);
            this.qbGraphics[0][i].done();
            this.dsout[0][i].close();
            this.bstream[0][i].close();
            this.writePage(this.curPage + 1, i, this.bstream[0][i].toByteArray(), this.mapFiles[0][i]);
        }
        this.fdout.close();
        this.fbout.close();
        if (this.pageReport != null && this.pageReport.firstPage == null) {
            this.pageReport.firstPage = this.writeFirstPage(this.curPage + 1);
            if (this.pageReport.LOCK != null) {
                Object object = this.pageReport.LOCK;
                synchronized (object) {
                    this.pageReport.LOCK.notify();
                }
            }
            this.exportThread.queue(this.pageReport.firstPage, PageBufferGraphics.getFileName(this.baseFile, "FIRST", "page"));
        }
        LOGGER.finest("Close2: " + PageBufferGraphics.getFileName(this.baseFile, this.curPage / 10, "page"));
        LOGGER.finest("Time: " + (double)(System.currentTimeMillis() - this.time) / 1000.0);
        this.exportThread.queue(this.fbout.toByteArray(), PageBufferGraphics.getFileName(this.baseFile, this.curPage / 10, "page"));
        if (this.done) {
            this.exportThread.queue(this.writeLastPage(this.curPage + 1), PageBufferGraphics.getFileName(this.baseFile, "LAST", "page"));
        }
        this.exportThread.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newPage() throws Exception {
        if (this.qbGraphics[0][0] != null) {
            for (int i = 0; i < this.totalSections; ++i) {
                this.drawPageFooter(this.qbGraphics[0][i], this.mapFiles[0][i], this.curPage, i + 1);
                this.qbGraphics[0][i].done();
                this.dsout[0][i].close();
                this.bstream[0][i].close();
                this.writePage(this.curPage, i, this.bstream[0][i].toByteArray(), this.mapFiles[0][i]);
            }
            if (this.pageReport != null && this.pageReport.firstPage == null) {
                this.pageReport.firstPage = this.writeFirstPage(this.curPage);
                if (this.pageReport.LOCK != null) {
                    Object object = this.pageReport.LOCK;
                    synchronized (object) {
                        this.pageReport.LOCK.notify();
                    }
                }
                this.exportThread.queue(this.pageReport.firstPage, PageBufferGraphics.getFileName(this.baseFile, "FIRST", "page"));
            }
        }
        if (this.done) {
            LOGGER.finest("Last page");
            this.closeFile();
            this.qbGraphics[0][0] = null;
            return;
        }
        this.newFile();
        LOGGER.finest("New page");
        if (this.qbGraphics[0][0] == null) {
            this.initPages();
        } else {
            this.initLastBuffer();
        }
    }

    private void initPages() throws Exception {
        LOGGER.finest("Init all buffer");
        for (int i = 0; i < this.PAGEBUFFERSIZE; ++i) {
            for (int j = 0; j < this.totalSections; ++j) {
                this.bstream[i][j] = new ByteArrayOutputStream(1024);
                this.dsout[i][j] = new DataOutputStream(this.bstream[i][j]);
                this.qbGraphics[i][j] = new QbGraphics(this.reportUI.report.getPWidth(), this.reportUI.report.getPHeight(), this.dsout[i][j]);
                this.mapFiles[i][j] = new Vector();
                this.drawPageHeader(this.qbGraphics[i][j], this.mapFiles[i][j], i + 1, j + 1);
                this.isBufferUsed[i] = false;
            }
        }
    }

    private void initLastBuffer() throws Exception {
        LOGGER.finest("Init last buffer");
        for (int i = 1; i < this.PAGEBUFFERSIZE; ++i) {
            for (int j = 0; j < this.totalSections; ++j) {
                this.bstream[i - 1][j] = this.bstream[i][j];
                this.dsout[i - 1][j] = this.dsout[i][j];
                this.qbGraphics[i - 1][j] = this.qbGraphics[i][j];
                this.mapFiles[i - 1][j] = this.mapFiles[i][j];
            }
            this.isBufferUsed[i - 1] = this.isBufferUsed[i];
        }
        int lastPage = this.PAGEBUFFERSIZE - 1;
        for (int i = 0; i < this.totalSections; ++i) {
            this.bstream[lastPage][i] = new ByteArrayOutputStream(1024);
            this.dsout[lastPage][i] = new DataOutputStream(this.bstream[lastPage][i]);
            this.qbGraphics[lastPage][i] = new QbGraphics(this.reportUI.report.getPWidth(), this.reportUI.report.getPHeight(), this.dsout[lastPage][i]);
            this.mapFiles[lastPage][i] = new Vector();
            this.drawPageHeader(this.qbGraphics[lastPage][i], this.mapFiles[lastPage][i], this.curPage + lastPage + 1, i + 1);
            this.isBufferUsed[lastPage] = false;
        }
    }

    private void writePage(int page, int sec, byte[] rptData, Vector mapFile) throws Exception {
        this.writePage(this.fdout, page, sec, rptData, mapFile);
    }

    private byte[] writeFirstPage(int page) throws Exception {
        ByteArrayOutputStream ffbout = new ByteArrayOutputStream(1024);
        DataOutputStream ffdout = new DataOutputStream(ffbout);
        ffdout.writeInt(PAGE_VERSION);
        for (int i = 0; i < this.totalSections; ++i) {
            this.writePage(ffdout, page, i, this.bstream[0][i].toByteArray(), this.mapFiles[0][i]);
        }
        ffdout.close();
        ffbout.close();
        return ffbout.toByteArray();
    }

    private void writePage(DataOutputStream ffdout, int page, int sec, byte[] rptData, Vector mapFile) throws Exception {
        ffdout.writeInt(page);
        ffdout.writeInt(sec);
        ffdout.write(rptData, 0, rptData.length);
        int size = mapFile.size();
        ffdout.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ((ImageMapNode)mapFile.elementAt(i)).write(ffdout, true, this.reportUI.report);
        }
        ffdout.writeBoolean(this.done);
    }

    private byte[] writeLastPage(int lastPage) throws IOException {
        ByteArrayOutputStream bLast = new ByteArrayOutputStream(1024);
        DataOutputStream dLast = new DataOutputStream(bLast);
        dLast.writeInt(LAST_VERSION);
        dLast.writeInt(lastPage);
        LOGGER.finest("Last page: " + lastPage);
        dLast.close();
        bLast.close();
        return bLast.toByteArray();
    }

    private void drawPageHeader(QbGraphics graphics, Vector mapFile, int page, int section) throws Exception {
        if (this.parentReportUI != null && this.reportUI instanceof SubReportUI) {
            this.drawPageHeader(this.parentReportUI, graphics, mapFile, page, section);
        } else {
            this.drawPageHeader(this.reportUI, graphics, mapFile, page, section);
        }
    }

    private void drawPageHeader(ReportUI reportUI, QbGraphics graphics, Vector mapFile, int page, int section) throws Exception {
        Report report = reportUI.report;
        reportUI.setPageSection(section);
        int backupPage = reportUI.getPage();
        reportUI.setPage(page);
        reportUI.imageMap = mapFile;
        PageGraphics rpg = new PageGraphics(reportUI, graphics, report.getLeftMargin(), report.getTopMargin());
        rpg.drawPage(report.getSubFilesTable(), report.getPageWidth(), report.getPageHeight());
        Vector<ReportTable> vec = report.getReportTables();
        ReportTable table = vec.size() > 0 ? vec.elementAt(0) : null;
        double tmpMaxX = reportUI.maxX;
        double tmpCurY = reportUI.curY;
        reportUI.drawPageSection(rpg, report.getPageHeader(), table);
        reportUI.maxX = tmpMaxX;
        reportUI.curY = tmpCurY;
        reportUI.setPageSection(-1);
        reportUI.setPage(backupPage);
    }

    private void drawPageFooter(QbGraphics graphics, Vector mapFile, int page, int section) throws Exception {
        if (this.parentReportUI != null && this.reportUI instanceof SubReportUI) {
            this.drawPageFooter(this.parentReportUI, graphics, mapFile, page, section);
        } else {
            this.drawPageFooter(this.reportUI, graphics, mapFile, page, section);
        }
    }

    private void drawPageFooter(ReportUI reportUI, QbGraphics graphics, Vector mapFile, int page, int section) throws Exception {
        Report report = reportUI.report;
        reportUI.setPageSection(section);
        int backupPage = reportUI.getPage();
        reportUI.setPage(page);
        reportUI.imageMap = mapFile;
        PageGraphics rpg = new PageGraphics(reportUI, graphics, report.getLeftMargin(), report.getTopMargin());
        rpg.incCurY(reportUI.pageHeaderH);
        rpg.incCurY(this.pageH);
        Vector<ReportTable> vec = report.getReportTables();
        ReportTable table = vec.size() > 0 ? vec.elementAt(0) : null;
        double tmpMaxX = reportUI.maxX;
        double tmpCurY = reportUI.curY;
        reportUI.drawPageSection(rpg, report.getPageFooter(), table);
        reportUI.maxX = tmpMaxX;
        reportUI.curY = tmpCurY;
        reportUI.setPageSection(-1);
        reportUI.setPage(backupPage);
        if (ServerMessage.isEvalVersion()) {
            rpg.drawEvalStatement();
        }
    }

    @Override
    boolean isDrawEnabled(double y) {
        boolean newPage = false;
        int pageIndex = this.getPageIndex(y);
        this.reportUI.setPage(this.curPage + 1 + pageIndex);
        if (this.getPageIndex(y) >= this.PAGEBUFFERSIZE) {
            LOGGER.finest("Cur page: " + this.curPage);
            ++this.curPage;
            LOGGER.finest("Shift to: " + this.curPage);
            newPage = true;
            this.pageY = this.pageH + this.pageY;
            try {
                if (newPage) {
                    this.newPage();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't open new page", ex);
            }
        }
        return true;
    }

    private int getPageIndex(double y) {
        int pageIdx = 0;
        double tmpY = this.pageY;
        while (y >= this.pageH - 1.0E-4 + tmpY) {
            ++pageIdx;
            tmpY = this.pageH + tmpY;
        }
        return pageIdx;
    }

    @Override
    Dimension2D getDimension(double x, double y, double w, double h) {
        int endSec;
        if (this.chopOffTable(y, h)) {
            return null;
        }
        this.isDrawEnabled(y);
        int curSec = (int)Math.floor(x / this.pageW);
        if (this.reportUI instanceof SubReportUI && curSec != (endSec = (int)Math.floor((x + w) / (this.pageW + 0.001)))) {
            return null;
        }
        if (curSec >= this.qbGraphics[0].length) {
            return null;
        }
        this.pageX = this.pageW * (double)curSec;
        int curPageIdx = this.getPageIndex(y);
        this.isBufferUsed[curPageIdx] = true;
        this.g = this.qbGraphics[curPageIdx][curSec];
        this.reportUI.imageMap = this.mapFiles[curPageIdx][curSec];
        this.reportUI.setSection(curSec + 1);
        double wShift = x - this.pageX;
        double hShift = y % this.pageH;
        if (Math.abs(wShift - this.pageW) < 0.001) {
            wShift = 0.0;
        }
        if (Math.abs(hShift - this.pageH) < 0.001) {
            hShift = 0.0;
        }
        return new Dimension2D(wShift + this.curX, hShift + this.curY);
    }

    protected static String getFileName(String prefix, int fileNumber, String ext) {
        return prefix + "_" + fileNumber + "." + ext;
    }

    protected static String getFileName(String prefix, String key, String ext) {
        return prefix + "_" + key + "." + ext;
    }

    protected class ExportThread
    extends Thread {
        private boolean stop = false;
        private Vector<Object> content = new Vector();
        private Vector<Object> location = new Vector();
        private Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                this.export();
                if (this.stop) continue;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.export();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queue(Object c, Object l) {
            this.content.addElement(c);
            this.location.addElement(l);
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            this.stop = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        private void export() {
            while (this.content.size() > 0) {
                int i = 0;
                for (i = 0; i < this.content.size(); ++i) {
                    Object obj = this.content.elementAt(i);
                    if (obj != null) {
                        try {
                            byte[] barray = (byte[])obj;
                            new WriteDataFile().output(null, barray, (String)this.location.elementAt(i), PageBufferGraphics.this.pageReport.isPageViewer);
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.WARNING, "Failed to write element", ex);
                        }
                        if (PageBufferGraphics.this.pageReport.expListener != null) {
                            String fileName = (String)this.location.elementAt(i);
                            if (fileName.indexOf("FIRST") >= 0) {
                                PageBufferGraphics.this.pageReport.expListener.firstPageFinishedAction();
                            } else if (fileName.indexOf("LAST") >= 0) {
                                PageBufferGraphics.this.pageReport.expListener.endAction();
                            }
                        }
                    }
                    this.content.setElementAt(null, i);
                    this.location.setElementAt(null, i);
                }
                --i;
                while (i >= 0) {
                    this.content.removeElementAt(i);
                    this.location.removeElementAt(i);
                    --i;
                }
            }
        }
    }
}

