/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.Dimension2D;

public class PageGraphics
extends ReportGraphics {
    private static final Logger LOGGER = Logger.getLogger(PageGraphics.class.getName());
    private Color backgroundColor = Color.white;
    private ReportImage backgroundImage = null;
    private Vector<ReportElement> highlights;

    public PageGraphics(ReportUI repUI, Graphics g, double cX, double cY) {
        super(repUI, g, cX, cY, 0.0, 0.0, 0.0, 0.0);
        if (repUI.report.getBackgroundColor() != null) {
            this.backgroundColor = repUI.report.getBackgroundColor();
        }
        if (repUI.report.getBackgroundImage() != null) {
            this.backgroundImage = repUI.report.getBackgroundImage();
        }
    }

    @Override
    boolean isDrawEnabled(double y) {
        return true;
    }

    @Override
    Dimension2D getDimension(double x, double y, double w, double h) {
        if (this.drawingSubReport && x >= this.pageW) {
            return null;
        }
        if (this.drawingSubReport && this.chopOffTable(y, h)) {
            return null;
        }
        return new Dimension2D(x + this.curX, y + this.curY);
    }

    void drawPage(FileInMemTable subFilesTable, double pageWidth, double pageHeight) {
        if (this.g == null) {
            return;
        }
        this.setColor(this.backgroundColor);
        this.g.fillRect(0, 0, this.toPixel(pageWidth), this.toPixel(pageHeight));
        this.drawBackgroundImage(subFilesTable, pageWidth, pageHeight);
    }

    private void drawBackgroundImage(FileInMemTable subFilesTable, double pageWidth, double pageHeight) {
        if (this.backgroundImage == null) {
            return;
        }
        if (this.backgroundImage.getImageOption() == 1) {
            double w = this.backgroundImage.getWidth();
            double h = this.backgroundImage.getHeight();
            this.backgroundImage.setWidth(pageWidth);
            this.backgroundImage.setHeight(pageHeight);
            try {
                this.drawImage(subFilesTable, this.backgroundImage, new Dimension2D(0, 0));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to draw background image", ex);
            }
            this.backgroundImage.setWidth(w);
            this.backgroundImage.setHeight(h);
        } else if (this.backgroundImage.getImageOption() == 2) {
            double x = 0.0;
            for (double y = 0.0; y < pageHeight; y += this.backgroundImage.getHeight()) {
                for (x = 0.0; x < pageWidth; x += this.backgroundImage.getWidth()) {
                    try {
                        this.drawImage(subFilesTable, this.backgroundImage, new Dimension2D(x, y));
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to draw background image", ex);
                    }
                }
            }
        } else {
            double x = (pageWidth - this.backgroundImage.getWidth()) / 2.0;
            double y = (pageHeight - this.backgroundImage.getHeight()) / 2.0;
            try {
                this.drawImage(subFilesTable, this.backgroundImage, new Dimension2D(x, y));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to draw background image", ex);
            }
        }
    }

    public void setHighlights(Vector<ReportElement> v) {
        this.highlights = v;
    }

    @Override
    protected void drawCell(ReportElement cell, Dimension2D dim) throws Exception {
        Color bgColor = cell.getBgColor();
        Color textColor = cell.getFontColor();
        if (this.highlights != null) {
            for (ReportElement element : this.highlights) {
                ReportElement e = element;
                if (e == null || !e.getID().equals(cell.getID())) continue;
                cell.setBgColor(SystemColor.textHighlight);
                cell.setFontColor(SystemColor.textHighlightText);
            }
        }
        super.drawCell(cell, dim);
        cell.setBgColor(bgColor);
        cell.setFontColor(textColor);
    }
}

