/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.report.PageBufferGraphics;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.IExportThreadListener;

public class PageReport {
    private static final Logger LOGGER = Logger.getLogger(PageReport.class.getName());
    static final int VIEW_VERSION = 5;
    static final int PAGE_VERSION = 0;
    Report report;
    ReportUI reportUI;
    String baseFile;
    int totalSections;
    byte[] firstPage;
    Object LOCK = null;
    boolean returnFirstPage = false;
    IExportThreadListener expListener;
    public boolean isPageViewer = false;

    public PageReport(Report report) {
        this.report = report;
    }

    public boolean export(OutputStream outstream, String filename, String securityLevel, IExportThreadListener expListener) throws Exception {
        return this.export(outstream, filename, null, securityLevel, expListener);
    }

    private boolean export(OutputStream outstream, String filename, String reportFileName, String securityLevel, IExportThreadListener expListener) throws Exception {
        if (filename == null) {
            throw new Exception("In order to export to multiple pages, you have to specify the file name");
        }
        this.expListener = expListener;
        String originalFileName = Report.getFullName(filename, 14);
        this.baseFile = Report.getPrefixFileName(filename);
        if (reportFileName != null) {
            PageReport.delete(originalFileName);
            this.exportView(outstream, reportFileName, securityLevel);
        } else {
            this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), this.report.isPreCalculationRequired());
            this.reportUI.preCalcTotalSections();
            this.totalSections = this.reportUI.getTotalSections();
            PageReport.delete(originalFileName);
            this.exportView(outstream, securityLevel);
            PagesThread pagesThread = new PagesThread(this);
            try {
                pagesThread.start();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to start pagesThread", ex);
                throw ex;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exportPages(ReportUI reportUI, String baseFile) throws Exception {
        PageReport.deleteAllPages(baseFile);
        this.reportUI = reportUI;
        this.baseFile = baseFile;
        this.returnFirstPage = true;
        PagesThread pagesThread = new PagesThread(this);
        try {
            pagesThread.start();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to start pagesThread", ex);
            throw ex;
        }
        Object object = this.LOCK = new Object();
        synchronized (object) {
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.firstPage;
    }

    private void exportView(OutputStream outstream, String reportFileName, String securityLevel) throws Exception {
        DataOutputStream dsout = new DataOutputStream(outstream);
        dsout.writeInt(5);
        IOUtil.writeString(dsout, this.baseFile);
        if (securityLevel != null) {
            dsout.writeBoolean(true);
            IOUtil.writeString(dsout, securityLevel);
        } else {
            dsout.writeBoolean(false);
        }
        dsout.writeBoolean(true);
        IOUtil.writeString(dsout, reportFileName);
        dsout.close();
    }

    private void exportView(OutputStream outstream, String securityLevel) throws Exception {
        DataOutputStream dsout = new DataOutputStream(outstream);
        dsout.writeInt(5);
        IOUtil.writeString(dsout, this.baseFile);
        if (securityLevel != null) {
            dsout.writeBoolean(true);
            IOUtil.writeString(dsout, securityLevel);
        } else {
            dsout.writeBoolean(false);
        }
        dsout.writeBoolean(false);
        dsout.writeInt(this.report.getPWidth());
        dsout.writeInt(this.report.getPHeight());
        dsout.writeInt(this.totalSections);
        dsout.writeInt(this.report.getOrientation());
        Vector<ReportTable> vector = this.report.getReportTables();
        Vector<String> list = new Vector<String>();
        for (int k = 0; k < vector.size(); ++k) {
            ReportTable reporttable = vector.elementAt(k);
            for (int i1 = 0; i1 < reporttable.getColumnCount(); ++i1) {
                if (!reporttable.getColumn(i1).isVisible()) continue;
                ReportTable tbl = reporttable;
                while (tbl instanceof ReportTreeTable) {
                    tbl = ((ReportTreeTable)tbl).getSubTable().elementAt(0);
                }
                if (tbl.getColumn(i1).getDataCount() <= 0 || tbl.getColumn(i1).getData(0) instanceof ReportImage || tbl.getColumn(i1).getData(0) instanceof ReportDocument) continue;
                list.addElement(reporttable.getColumn(i1).getText());
            }
        }
        dsout.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            IOUtil.writeString(dsout, (String)list.elementAt(i));
        }
        dsout.writeBoolean(this.report.getReportType() == 0);
        dsout.close();
    }

    public static void delete(String filename) {
        String baseFile = Report.getPrefixFileName(filename);
        try {
            int i = 1;
            String tmp = PageReport.getFileName(baseFile, i++, "page");
            while (new FileInfo(tmp).exists()) {
                new DeleteFile(tmp).delete();
                tmp = PageReport.getFileName(baseFile, i++, "page");
            }
            tmp = PageReport.getFileName(baseFile, "LAST", "page");
            if (new FileInfo(tmp).exists()) {
                new DeleteFile(tmp).delete();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Cannot delete file", ex);
        }
    }

    public static void deleteAllPages(String baseFile) {
        try {
            int i = 0;
            String tmp = PageReport.getFileName(baseFile, i++, "page");
            while (new FileInfo(tmp).exists()) {
                new DeleteFile(tmp).delete();
                tmp = PageReport.getFileName(baseFile, i++, "page");
            }
            tmp = PageReport.getFileName(baseFile, "FIRST", "page");
            if (new FileInfo(tmp).exists()) {
                new DeleteFile(tmp).delete();
            }
            if (new FileInfo(tmp = PageReport.getFileName(baseFile, "LAST", "page")).exists()) {
                new DeleteFile(tmp).delete();
            }
            if (new FileInfo(tmp = baseFile + ".pak").exists()) {
                new DeleteFile(tmp).delete();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Cannot delete all pages", ex);
        }
    }

    private void exportPages() throws Exception {
        PageBufferGraphics pageGraphics = new PageBufferGraphics(this.reportUI, this.baseFile, this);
        this.reportUI.drawReport(pageGraphics);
        pageGraphics.closeFile();
    }

    protected static String getFileName(String prefix, int fileNumber, String ext) {
        return prefix + "_" + fileNumber + "." + ext;
    }

    protected static String getFileName(String prefix, String key, String ext) {
        return prefix + "_" + key + "." + ext;
    }

    public static void createAppletPage(String filename, boolean useSwing) throws Exception {
        boolean absolutePath = false;
        if (filename.startsWith("http://") || filename.startsWith("https://")) {
            absolutePath = false;
        } else {
            boolean bl = absolutePath = filename.startsWith("/") || filename.indexOf(":/") >= 0;
        }
        if (!absolutePath) {
            filename = IOUtil.extractHostPath(filename, ServerMessage.getApplet());
        }
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(20088);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, filename);
        dout.writeBoolean(absolutePath);
        dout.writeBoolean(useSwing);
        IConnection socket = null;
        try {
            try {
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to connect to server", ex);
                if (socket != null) {
                    socket.close();
                }
                throw new IOException("Failed to connect to server !");
            }
            DataInputStream din = new DataInputStream(socket.getInputStream());
            String errMessage = IOUtil2.getErrorString(din.readInt());
            String reason = IOUtil.readString(din, true);
            socket.close();
            if (errMessage != null) {
                throw new IOException(errMessage + "\n" + reason);
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.log(Level.FINEST, "Cannot read data", ex);
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw ex;
        }
    }

    protected class PagesThread
    extends Thread {
        PageReport pageReport;

        public PagesThread(PageReport pageReport) {
            this.pageReport = pageReport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.pageReport.exportPages();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot export pages", ex);
            }
            finally {
                if (this.pageReport.LOCK == null) {
                    return;
                }
                Object object = this.pageReport.LOCK;
                synchronized (object) {
                    this.pageReport.LOCK.notify();
                }
            }
        }
    }
}

