/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.formula.Formula;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.util.ICustomParameterDateFormat;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.IQueryParamValuesProvider;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class Parameter
extends Operand {
    private static final Logger LOGGER = Logger.getLogger(Parameter.class.getName());
    String name;
    boolean mapToColumn;
    int mapColIdx;
    Object defaultValue;
    Object value;
    Vector values;
    String promptText;
    Vector<String> formulaNames;
    boolean isMultiValueParam = false;
    boolean isQueryParamValuesProvider = false;
    Vector selectionChoices;
    String tableName;
    String columnName;
    boolean isCustomDateFormat = false;
    String customDateFormat = null;
    boolean shared;
    String sharedReportName;
    String sharedParamName;
    int referenceDegree;
    IQueryFileInfo queryFileInfo;
    Report report;
    String reportTitle;
    int sqlType = -1;
    Formula defaultValueVariable;
    Formula valueVariable;
    String sqlSelect;
    String defaultSql;
    boolean allOptionEnabled;
    String allOptionLabel;

    public Parameter() {
    }

    public Parameter(String name) {
        this.name = name;
        this.promptText = name;
    }

    public Parameter(String name, Object defaultValue, int datatype) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.datatype = datatype;
    }

    public Parameter(IQueryInParam param) {
        this.name = param.getParamName();
        this.mapToColumn = param.isMapToColumn();
        this.promptText = param.getPromptName();
        this.sqlType = param.getSqlType();
        this.datatype = Parameter.mapToOperandType(param.getSqlType());
        this.defaultValue = param.getDefaultValue();
        this.value = param.getValue();
        if (param instanceof IQueryMultiValueInParam) {
            this.isMultiValueParam = true;
            this.values = ((IQueryMultiValueInParam)param).getValues();
            if (this.values.size() == 1 && this.values.get(0) instanceof Vector) {
                this.values = (Vector)this.values.get(0);
            }
        }
        if (param instanceof IQueryParamValuesProvider) {
            this.isQueryParamValuesProvider = true;
            this.selectionChoices = ((IQueryParamValuesProvider)((Object)param)).getSelectionChoices();
        }
        if (param instanceof ICustomParameterDateFormat) {
            this.customDateFormat = ((ICustomParameterDateFormat)((Object)param)).getDateFormat();
            this.isCustomDateFormat = this.customDateFormat != null;
        }
        this.tableName = param.getTableName();
        this.columnName = param.getColumnName();
        this.defaultSql = param.getDefaultSql();
        if (param instanceof ReportUtil.CQueryInParam) {
            param = ((ReportUtil.CQueryInParam)param).getQueryInParam();
        }
        if (param instanceof QueryInParam) {
            QueryInParam qip = (QueryInParam)param;
            this.sqlSelect = qip.getSqlSelect();
            this.defaultSql = qip.getDefaultSql();
            this.allOptionEnabled = qip.isAllOptionEnabled();
            this.allOptionLabel = qip.getAllOptionLabel();
        } else if (param instanceof quadbase.datasource.util.QueryInParam) {
            quadbase.datasource.util.QueryInParam qip = (quadbase.datasource.util.QueryInParam)param;
            this.sqlSelect = qip.getSqlSelect();
            this.defaultSql = qip.getDefaultSql();
            this.allOptionEnabled = qip.isAllOptionEnabled();
            this.allOptionLabel = qip.getAllOptionLabel();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isMapToColumn() {
        return this.mapToColumn;
    }

    public void setMapToColumn(boolean state) {
        this.mapToColumn = state;
    }

    public int getMapColIdx() {
        return this.mapColIdx;
    }

    public void setMapColIdx(int idx) {
        this.mapColIdx = idx;
    }

    public String getPromptText() {
        return this.promptText;
    }

    public void setPromptText(String s) {
        this.promptText = s;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object value) {
        this.defaultValue = value;
    }

    public Vector<String> getFormulaNames() {
        return this.formulaNames;
    }

    public void setFormulaNames(Vector<String> names) {
        this.formulaNames = names;
    }

    public void removeFormula(String formulaName) {
        if (this.formulaNames == null || formulaName == null) {
            return;
        }
        for (int i = 0; i < this.formulaNames.size(); ++i) {
            if (!this.formulaNames.elementAt(i).equals(formulaName)) continue;
            this.formulaNames.remove(formulaName);
        }
    }

    public void addFormula(String formulaName) {
        if (formulaName == null) {
            return;
        }
        if (this.formulaNames == null) {
            this.formulaNames = new Vector();
        }
        this.formulaNames.addElement(formulaName);
    }

    public boolean isUsedBy(String formulaName) {
        if (this.formulaNames == null || formulaName == null) {
            return false;
        }
        for (int i = 0; i < this.formulaNames.size(); ++i) {
            if (!formulaName.equals(this.formulaNames.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public static Parameter clone(Parameter _param) {
        Parameter param = new Parameter(_param.getName());
        param.setMapToColumn(_param.isMapToColumn());
        param.setMapColIdx(_param.getMapColIdx());
        param.setDefaultValue(_param.getDefaultValue());
        param.setPromptText(_param.getPromptText());
        param.sqlType = _param.sqlType;
        param.setDatatype(_param.datatype);
        param.setValue(_param.value);
        param.setValues(_param.values);
        param.setMultiValueParam(_param.isMultiValueParam());
        param.setQueryParamValuesProvider(_param.isQueryParamValuesProvider());
        param.setSelectionChoices(_param.getSelectionChoices());
        param.setSqlSelect(_param.getSqlSelect());
        param.setTableName(_param.getTableName());
        param.setColumnName(_param.getColumnName());
        param.setFormulaNames(_param.formulaNames);
        param.setShared(_param.isShared());
        param.setSharedReportName(_param.getSharedReportName());
        param.setSharedParamName(_param.getSharedParamName());
        param.setReferenceDegree(_param.getReferenceDegree());
        param.setQueryFileInfo(_param.getQueryFileInfo());
        param.setReport(_param.getReport());
        return param;
    }

    public void copy(Parameter _param) {
        this.name = _param.getName();
        this.mapToColumn = _param.isMapToColumn();
        this.mapColIdx = _param.getMapColIdx();
        this.defaultValue = _param.getDefaultValue();
        this.promptText = _param.getPromptText();
        this.sqlType = _param.sqlType;
        this.datatype = _param.datatype;
        this.isCustomDateFormat = _param.isCustomDateFormat;
        this.customDateFormat = _param.customDateFormat;
        this.value = _param.value;
        this.values = _param.values;
        this.setMultiValueParam(_param.isMultiValueParam());
        this.setQueryParamValuesProvider(_param.isQueryParamValuesProvider());
        this.setSelectionChoices(_param.getSelectionChoices());
        this.setSqlSelect(_param.getSqlSelect());
        this.setTableName(_param.getTableName());
        this.setColumnName(_param.getColumnName());
        this.formulaNames = _param.formulaNames;
        this.setShared(_param.isShared());
        this.setSharedReportName(_param.getSharedReportName());
        this.setSharedParamName(_param.getSharedParamName());
        this.setReferenceDegree(_param.getReferenceDegree());
        this.setQueryFileInfo(_param.getQueryFileInfo());
        this.setReport(_param.getReport());
    }

    public void setValues(Vector values) {
        this.values = values;
    }

    public Vector getValues() {
        return this.values;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj) throws Exception {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, Vector preAggCol, Vector resultCol) throws Exception {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    private Object getValueForOperand() {
        if (this.isMultiValueParam && this.values != null) {
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < this.values.size(); ++i) {
                Object o = this.values.get(i);
                str.append(o);
                if (i >= this.values.size() - 1) continue;
                str.append(", ");
            }
            return str.toString();
        }
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.getValueForOperand();
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.getValueForOperand();
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        return this.getValueForOperand();
    }

    public String toString() {
        return this.name;
    }

    public void write(DataOutput out) throws IOException {
        this.write(out, false);
    }

    public void write(DataOutput out, boolean saveValue) throws IOException {
        IOUtil.writeStr(out, this.name);
        out.writeBoolean(this.mapToColumn);
        out.writeInt(this.mapColIdx);
        out.writeInt(this.datatype);
        if (saveValue) {
            IOUtil.writeStr(out, this.formatValue());
        } else {
            IOUtil.writeStr(out, this.formatDefaultValue());
        }
        IOUtil.writeStr(out, this.promptText);
        this.writeShareInfo(out);
    }

    public void read(DataInput in, int version) throws Exception {
        this.name = IOUtil.readStr(in);
        this.mapToColumn = in.readBoolean();
        this.mapColIdx = in.readInt();
        this.datatype = in.readInt();
        this.defaultValue = this.makeDefaultValueFromText(IOUtil.readStr(in));
        this.promptText = IOUtil.readStr(in);
        if (version >= 176) {
            this.readShareInfo(in, version);
        }
    }

    public void writeShareInfo(DataOutput out) throws IOException {
        out.writeBoolean(this.shared);
        IOUtil.writeStr(out, this.sharedReportName);
        IOUtil.writeStr(out, this.sharedParamName);
        out.writeInt(this.referenceDegree);
    }

    public void readShareInfo(DataInput in, int version) throws Exception {
        this.shared = in.readBoolean();
        this.sharedReportName = IOUtil.readStr(in);
        this.sharedParamName = IOUtil.readStr(in);
        this.referenceDegree = in.readInt();
    }

    public void writeXMLShareInfo(Writer out) throws Exception {
        out.write("<PARAMETER_SHAREINFO>\n");
        out.write("<PARAMETER_SHARED>" + this.shared + "</PARAMETER_SHARED>");
        out.write("<PARAMETER_SHAREDREPORTNAME>" + this.sharedReportName + "</PARAMETER_SHAREDREPORTNAME>");
        out.write("<PARAMETER_SHAREDPARAMNAME>" + this.sharedParamName + "</PARAMETER_SHAREDPARAMNAME>");
        out.write("<PARAMETER_REFERENCEDEGREE>" + this.referenceDegree + "</PARAMETER_REFERENCEDEGREE>");
        out.write("</PARAMETER_SHAREINFO>\n");
    }

    public void readXMLShareInfo(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_SHARED")) {
                this.shared = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_SHAREDREPORTNAME")) {
                this.sharedReportName = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_SHAREDPARAMNAME")) {
                this.sharedParamName = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("PARAMETER_REFERENCEDEGREE")) continue;
            this.referenceDegree = Integer.parseInt(LoadXMLReportHelper.readText(child));
        }
    }

    public void writeXML(Writer out) throws Exception {
        out.write("<PARAMETER>\n");
        if (this.getName() != null) {
            out.write("<PARAMETER_NAME>" + XMLUtil.encodeCDATA(this.getName()) + "</PARAMETER_NAME>\n");
        }
        out.write("<PARAMETER_MAPTOCOLUMN>" + this.isMapToColumn() + "</PARAMETER_MAPTOCOLUMN>\n");
        out.write("<PARAMETER_MAPCOLIDX>" + this.getMapColIdx() + "</PARAMETER_MAPCOLIDX>\n");
        out.write("<PARAMETER_DATATYPE>" + this.datatype + "</PARAMETER_DATATYPE>\n");
        if (this.getDefaultValue() != null) {
            out.write("<PARAMETER_DEFAULTVALUE>" + XMLUtil.encodeCDATA(this.formatDefaultValue()) + "</PARAMETER_DEFAULTVALUE>\n");
        }
        if (this.getPromptText() != null) {
            out.write("<PARAMETER_PROMPTTEXT>" + XMLUtil.encodeCDATA(this.getPromptText()) + "</PARAMETER_PROMPTTEXT>\n");
        }
        this.writeXMLShareInfo(out);
        out.write("</PARAMETER>\n");
    }

    public void readXML(Node node, int version) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_NAME")) {
                this.name = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_MAPTOCOLUMN")) {
                this.mapToColumn = LoadXMLReportHelper.parseBoolean(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_MAPCOLIDX")) {
                this.mapColIdx = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_DATATYPE")) {
                this.datatype = Integer.parseInt(LoadXMLReportHelper.readText(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_DEFAULTVALUE")) {
                this.defaultValue = this.makeDefaultValueFromText(LoadXMLReportHelper.readCDATA(child));
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("PARAMETER_PROMPTTEXT")) {
                this.promptText = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("PARAMETER_SHAREINFO")) continue;
            this.readXMLShareInfo(child, version);
        }
    }

    public Object makeDefaultValueFromText(String text) {
        if (text == null) {
            return null;
        }
        if (text.equals("") && this.datatype != 1) {
            return null;
        }
        try {
            switch (this.datatype) {
                case 0: {
                    return Double.valueOf(text);
                }
                case 1: {
                    return text;
                }
                case 2: {
                    return Boolean.valueOf(text);
                }
                case 3: {
                    return FormatUtil.createDate(text);
                }
                case 4: {
                    return FormatUtil.createTime(text);
                }
                case 5: {
                    return FormatUtil.createTimestamp(text);
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot make default value from text", e);
            return null;
        }
    }

    public Object getValueFromText(String text) {
        if (text == null) {
            return null;
        }
        if (text.equals("") && this.datatype != 1) {
            return null;
        }
        try {
            switch (this.datatype) {
                case 0: {
                    return Double.valueOf(text);
                }
                case 1: {
                    return text;
                }
                case 2: {
                    return Boolean.valueOf(text);
                }
                case 3: {
                    return FormatUtil.createDate2(text);
                }
                case 4: {
                    return FormatUtil.createTime(text);
                }
                case 5: {
                    return FormatUtil.createTimestamp2(text);
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot get value from text", e);
            return null;
        }
    }

    public String formatDefaultValue() {
        if (this.getDefaultValue() == null) {
            return null;
        }
        switch (this.datatype) {
            case 0: 
            case 1: 
            case 2: {
                return this.getDefaultValue().toString();
            }
            case 3: {
                return FormatUtil.getDateTimeText(null, null, "MM'/'dd'/'yyyy", (Date)this.getDefaultValue());
            }
            case 4: {
                return FormatUtil.getDateTimeText(null, null, "hh:mm:ss", (Date)this.getDefaultValue());
            }
            case 5: {
                return FormatUtil.getDateTimeText(null, null, "MM'/'dd'/'yyyy hh:mm:ss", (Date)this.getDefaultValue());
            }
        }
        return null;
    }

    public String formatValue() {
        if (this.getValue() == null) {
            return null;
        }
        switch (this.datatype) {
            case 0: 
            case 1: 
            case 2: {
                return this.getValue().toString();
            }
            case 3: {
                return FormatUtil.getDateTimeText(null, null, "MM'/'dd'/'yyyy", (Date)this.getValue());
            }
            case 4: {
                return FormatUtil.getDateTimeText(null, null, "hh:mm:ss", (Date)this.getValue());
            }
            case 5: {
                return FormatUtil.getDateTimeText(null, null, "MM'/'dd'/'yyyy hh:mm:ss", (Date)this.getValue());
            }
        }
        return null;
    }

    public boolean isInitialized() {
        return this.defaultValue != null;
    }

    public boolean isMultiValueParam() {
        return this.isMultiValueParam;
    }

    public void setMultiValueParam(boolean b) {
        this.isMultiValueParam = b;
    }

    public boolean isQueryParamValuesProvider() {
        return this.isQueryParamValuesProvider;
    }

    public void setQueryParamValuesProvider(boolean b) {
        this.isQueryParamValuesProvider = b;
    }

    public Vector getSelectionChoices() {
        return this.selectionChoices;
    }

    public void setSelectionChoices(Vector vec) {
        this.selectionChoices = vec;
    }

    public String getSqlSelect() {
        return this.sqlSelect;
    }

    public void setSqlSelect(String s) {
        this.sqlSelect = s;
    }

    public String getDefaultSql() {
        return this.defaultSql;
    }

    public void setDefaultSql(String s) {
        this.defaultSql = s;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tName) {
        this.tableName = tName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String tName) {
        this.columnName = tName;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean b) {
        this.shared = b;
    }

    public String getSharedReportName() {
        return this.sharedReportName;
    }

    public void setSharedReportName(String s) {
        this.sharedReportName = s;
    }

    public String getSharedParamName() {
        return this.sharedParamName;
    }

    public void setSharedParamName(String s) {
        this.sharedParamName = s;
    }

    public int getReferenceDegree() {
        return this.referenceDegree;
    }

    public void setReferenceDegree(int i) {
        this.referenceDegree = i;
    }

    public void incReferenceDegree() {
        ++this.referenceDegree;
    }

    public void decReferenceDegree() {
        --this.referenceDegree;
    }

    public boolean isShareReferenced() {
        return this.referenceDegree > 0;
    }

    public boolean isCustomDateFormat() {
        return this.isCustomDateFormat;
    }

    public String getDateFormat() {
        return this.customDateFormat;
    }

    public IQueryFileInfo getQueryFileInfo() {
        return this.queryFileInfo;
    }

    public void setQueryFileInfo(IQueryFileInfo qf) {
        this.queryFileInfo = qf;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report r) {
        this.report = r;
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public void setReportTitle(String s) {
        this.reportTitle = s;
    }

    public void setSQLType(int type) {
        this.sqlType = type;
    }

    @Override
    public int getSQLType() {
        int type = super.getSQLType();
        if (this.sqlType == -1) {
            return type;
        }
        return this.sqlType;
    }

    public Formula getDefaultValueVariable() {
        return this.defaultValueVariable;
    }

    public void setDefaultValueVariable(Formula formula) {
        this.defaultValueVariable = formula;
    }

    public Formula getValueVariable() {
        return this.valueVariable;
    }

    public void setValueVariable(Formula formula) {
        this.valueVariable = formula;
    }

    public boolean isAllOptionEnabled() {
        return this.allOptionEnabled;
    }

    public void setAllOptionEnabled(boolean isAllOptionEnabled) {
        this.allOptionEnabled = isAllOptionEnabled;
    }

    public String getAllOptionLabel() {
        return this.allOptionLabel;
    }

    public void setAllOptionLabel(String allOptionLabel) {
        this.allOptionLabel = allOptionLabel;
    }

    @Override
    public int getDatatype(Report report) {
        if (this.allOptionEnabled && this.value.equals(this.allOptionLabel)) {
            return 1;
        }
        return this.datatype;
    }
}

