/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Vector;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.Report;

public class PlotData {
    Report report;
    Vector element = new Vector();

    public PlotData(Report rpt) {
        this.report = rpt;
    }

    boolean isEmpty() {
        return this.element.size() == 0;
    }

    boolean isEmpty(int row) {
        if (row < 0 || row >= this.element.size()) {
            return true;
        }
        return this.element.elementAt(row) == null;
    }

    void add(int recNo) {
        Object[] elt = new Object[this.report.valColInfo.length];
        for (int i = 0; i < elt.length; ++i) {
            elt[i] = this.getObj(this.report.valColInfo[i].getMapping(), recNo);
        }
        this.element.addElement(elt);
    }

    private Object getObj(int col, int recNo) {
        return this.report.colData[col].getData(recNo);
    }

    private Object[] getValue(int row) {
        if (this.isEmpty(row)) {
            return null;
        }
        return (Object[])this.element.elementAt(row);
    }

    Object[] getColumnValue(int col) {
        Object[] obj = new Object[this.element.size()];
        for (int r = 0; r < this.element.size(); ++r) {
            obj[r] = this.getValue(r)[col];
        }
        return obj;
    }

    Object getValue(int row, int col) {
        Object[] elt = this.getValue(row);
        if (elt == null) {
            return null;
        }
        if (col < 0 || col >= elt.length) {
            return null;
        }
        return elt[col];
    }

    int countElement() {
        return this.element.size();
    }

    Object getComputedValue(int col) {
        return this.getComputedValue(this.report.valColInfo[col].getAggregation(), col);
    }

    Object getComputedValue(short aggregate, int col) {
        return Aggregation.getComputedValue(aggregate, this.getColumnValue(col));
    }
}

