/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.DataType;
import quadbase.reportdesigner.util.internal.IQueryProcInfo;

public class PreprocInfo
implements IQueryProcInfo {
    private static final Logger LOGGER = Logger.getLogger(PreprocInfo.class.getName());
    public int selectColType;
    public int selectColIndex;
    public int[] groupColIndex;
    public int[] aggrColIndex;
    public int[] aggrOp;
    public boolean isLinear;
    public boolean bRounded;
    public Object lBound;
    public Object uBound;
    public Number intervalNum;
    public int unit;
    public int lUnit;
    public int lInterval;
    public int uUnit;
    public int uInterval;

    public PreprocInfo(int sqlType) {
        this.selectColType = sqlType;
        this.selectColIndex = -1;
        this.groupColIndex = new int[]{-1, -1};
        this.aggrColIndex = new int[]{-1, -1, -1, -1, -1};
        this.aggrOp = new int[]{-1, -1, -1, -1, -1};
        this.isLinear = false;
        this.bRounded = false;
        this.intervalNum = 0.0;
        this.uUnit = -1;
        this.lUnit = -1;
        this.unit = -1;
    }

    public PreprocInfo(PreprocInfo t) {
        int i;
        this.selectColType = t.selectColType;
        this.selectColIndex = t.selectColIndex;
        this.groupColIndex = new int[2];
        for (i = 0; i < this.groupColIndex.length; ++i) {
            this.groupColIndex[i] = t.groupColIndex[i];
        }
        this.aggrColIndex = new int[5];
        for (i = 0; i < this.aggrColIndex.length; ++i) {
            this.aggrColIndex[i] = t.aggrColIndex[i];
        }
        this.aggrOp = new int[this.aggrColIndex.length];
        for (i = 0; i < this.aggrOp.length; ++i) {
            this.aggrOp[i] = t.aggrOp[i];
        }
        this.isLinear = t.isLinear;
        this.bRounded = t.bRounded;
        this.lBound = t.lBound;
        this.uBound = t.uBound;
        this.unit = t.unit;
        this.intervalNum = t.intervalNum;
        this.lUnit = t.lUnit;
        this.lInterval = t.lInterval;
        this.uUnit = t.uUnit;
        this.uInterval = t.uInterval;
    }

    public void writeAsStream(DataOutput dout) throws IOException {
        dout.writeInt(this.selectColType);
        dout.writeInt(this.selectColIndex);
        for (int element : this.groupColIndex) {
            dout.writeInt(element);
        }
        for (int element : this.aggrColIndex) {
            dout.writeInt(element);
        }
        for (int element : this.aggrOp) {
            dout.writeInt(element);
        }
        dout.writeBoolean(this.isLinear);
        int type = 4;
        if (this.lBound != null) {
            type = DataType.findType(this.lBound);
        } else if (this.uBound != null) {
            type = DataType.findType(this.uBound);
        }
        dout.writeInt(type);
        DataType.write(dout, this.lBound);
        DataType.write(dout, this.uBound);
        dout.writeBoolean(this.bRounded);
        if (this.bRounded) {
            dout.writeInt(this.unit);
            type = DataType.findType(this.intervalNum);
            dout.writeInt(type);
            DataType.write(dout, this.intervalNum);
        }
    }

    public void writeAsStream(DataOutput dout, boolean all) throws IOException {
        this.writeAsStream(dout);
        dout.writeInt(this.lUnit);
        dout.writeInt(this.lInterval);
        dout.writeInt(this.uUnit);
        dout.writeInt(this.uInterval);
    }

    public void readAsStream(DataInput din, int version) throws IOException {
        try {
            int i;
            this.selectColType = din.readInt();
            this.selectColIndex = din.readInt();
            for (i = 0; i < this.groupColIndex.length; ++i) {
                this.groupColIndex[i] = din.readInt();
            }
            for (i = 0; i < this.aggrColIndex.length; ++i) {
                this.aggrColIndex[i] = din.readInt();
            }
            for (i = 0; i < this.aggrOp.length; ++i) {
                this.aggrOp[i] = din.readInt();
            }
            this.isLinear = din.readBoolean();
            int type = din.readInt();
            this.lBound = DataType.read(din, type, version, true);
            this.uBound = DataType.read(din, type, version, true);
            this.bRounded = din.readBoolean();
            if (this.bRounded) {
                this.unit = din.readInt();
                type = din.readInt();
                this.intervalNum = (Number)DataType.read(din, type, version, true);
            }
        }
        catch (IOException ex0) {
            LOGGER.log(Level.FINEST, "PreprocInfo: Cannot read stream", ex0);
            throw ex0;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "PreprocInfo: Cannot read data as stream", ex);
        }
    }

    public void readAsStream(DataInput din, int version, boolean all) throws IOException {
        this.readAsStream(din, version);
        this.lUnit = din.readInt();
        this.lInterval = din.readInt();
        this.uUnit = din.readInt();
        this.uInterval = din.readInt();
    }

    int[] cutToSize(int[] array) {
        int j = 0;
        for (int element : array) {
            if (element < 0) continue;
            ++j;
        }
        int[] x = new int[j];
        j = 0;
        for (int element : array) {
            if (element < 0) continue;
            x[j++] = element;
        }
        return x;
    }

    @Override
    public int getSelectionColType() {
        return this.selectColType;
    }

    @Override
    public int getSelectionCol() {
        return this.selectColIndex;
    }

    @Override
    public Object getSelectionLBound() {
        return this.lBound;
    }

    @Override
    public Object getSelectionUBound() {
        return this.uBound;
    }

    @Override
    public boolean isRounded() {
        return this.bRounded;
    }

    @Override
    public boolean isLinearOutput() {
        return this.isLinear;
    }

    @Override
    public Number getRoundingIntervalSize() {
        return this.intervalNum;
    }

    @Override
    public int getRoundingIntervalUnit() {
        return this.unit;
    }

    @Override
    public int[] getGroupCols() {
        return this.cutToSize(this.groupColIndex);
    }

    @Override
    public int[] getAggrCols() {
        return this.cutToSize(this.aggrColIndex);
    }

    @Override
    public int[] getAggrOps() {
        return this.cutToSize(this.aggrOp);
    }

    @Override
    public void print() {
        LOGGER.finest("ColType:" + this.selectColType);
        LOGGER.finest("ColIndex :" + this.selectColIndex);
        LOGGER.finest("groupColIndex :");
        for (int element : this.groupColIndex) {
            LOGGER.finest(String.valueOf(element));
        }
        LOGGER.finest("aggrColIndex :");
        for (int element : this.aggrColIndex) {
            LOGGER.finest(String.valueOf(element));
        }
        LOGGER.finest("aggrOp: ");
        for (int element : this.aggrOp) {
            LOGGER.finest(String.valueOf(element));
        }
        LOGGER.finest("IsLinear :" + this.isLinear);
        LOGGER.finest("IsRounded :" + this.bRounded);
        LOGGER.finest("Bounds :" + this.lBound + "," + this.uBound);
        if (this.bRounded) {
            LOGGER.finest("Interval :" + this.intervalNum + " " + this.unit);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<< PreprocInfo >>\n");
        sb.append("selectColType\t= " + this.selectColType + "\n");
        sb.append("selectColIndex\t= " + this.selectColIndex + "\n");
        sb.append("groupColIndex\t= ");
        for (int element : this.groupColIndex) {
            sb.append(element).append(" ");
        }
        sb.append("\n");
        sb.append("aggrColIndex\t= ");
        for (int element : this.aggrColIndex) {
            sb.append(element).append(" ");
        }
        sb.append("\n");
        sb.append("aggrOp\t\t= ");
        for (int element : this.aggrOp) {
            sb.append(element).append(" ");
        }
        sb.append("\n");
        sb.append("isLinear\t= ").append(this.isLinear).append("\n");
        sb.append("bRounded\t= ").append(this.bRounded).append("\n");
        sb.append("lBound\t\t= ").append(this.lBound).append("\n");
        sb.append("uBound\t\t= ").append(this.uBound).append("\n");
        sb.append("intervalNum\t= ").append(this.intervalNum).append("\n");
        sb.append("unit\t\t= ").append(this.unit).append("\n");
        return sb.toString();
    }
}

