/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.output.Rectangle;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;

public class PrintReport
extends ReportUI {
    private static final Logger LOGGER = Logger.getLogger(PrintReport.class.getName());
    private int PIXEL_PER_INCH = -1;
    private PrintJob printJob;
    private ReportUI printUI;

    public PrintReport(ReportUI reportUI, Component component) throws Exception {
        this(reportUI.report, component);
    }

    public PrintReport(Report report, PrintJob printJob) throws Exception {
        super(report, printJob.getGraphics());
        this.printJob = printJob;
        this.resetFontTable();
    }

    public PrintReport(Report report, Component component) throws Exception {
        this(report, PrintReport.getPrintJob(component));
    }

    private PrintReport() {
    }

    @Override
    protected int toPixel(double inch) {
        if (this.PIXEL_PER_INCH < 0) {
            this.PIXEL_PER_INCH = this.printJob.getPageResolution();
        }
        return (int)Math.rint((double)this.PIXEL_PER_INCH * inch);
    }

    public void print() throws Exception {
        Frame frame = ServerMessage.getFrame();
        if (frame == null) {
            frame = new Frame();
        }
        for (int i = 1; i <= this.getTotalPages(); ++i) {
            for (int j = 1; j <= this.getTotalSections(); ++j) {
                Graphics page = i == 1 && j == 1 && this.textGraphics != null ? this.textGraphics : this.printJob.getGraphics();
                this.draw(page, i, j);
                page.dispose();
            }
        }
        this.printJob.end();
    }

    private static PrintJob getPrintJob(Component component) {
        Frame frame = ServerMessage.getFrame();
        if (frame == null) {
            frame = component instanceof Frame ? (Frame)component : new Frame();
        }
        return frame.getToolkit().getPrintJob(frame, "report", null);
    }

    public static void printUsingSwing(ReportUI reportUI) throws Exception {
        Class<?> objClass = Class.forName("quadbase.reportdesigner.report.PrintReportForSwing");
        Constructor<?> objCons = objClass.getConstructor(ReportUI.class);
        Object printSwing = objCons.newInstance(reportUI);
        Method objMethod = objClass.getMethod("print", new Class[0]);
        objMethod.invoke(printSwing, new Object[0]);
    }

    public static void printUsingSwing(ReportUI reportUI, int firstPage, int lastPage) throws Exception {
        Class<?> objClass = Class.forName("quadbase.reportdesigner.report.PrintReportForSwing");
        Constructor<?> objCons = objClass.getConstructor(ReportUI.class);
        Object printSwing = objCons.newInstance(reportUI);
        Method objMethod = objClass.getMethod("print", Boolean.class, Integer.class, Integer.class);
        objMethod.invoke(printSwing, Boolean.FALSE, firstPage, lastPage);
    }

    public static void printUsingSwing(ReportUI reportUI, int firstPage, int lastPage, String preferredPrinter, int numOfCopy) throws Exception {
        Class<?> objClass = Class.forName("quadbase.reportdesigner.report.PrintReportForSwing");
        Constructor<?> objCons = objClass.getConstructor(ReportUI.class);
        Object printSwing = objCons.newInstance(reportUI);
        Method objMethod = objClass.getMethod("print", Boolean.class, Integer.class, Integer.class, String.class, Integer.class);
        objMethod.invoke(printSwing, Boolean.FALSE, firstPage, lastPage, preferredPrinter, numOfCopy);
    }

    public static void printUsingSwing(ReportUI reportUI, int firstPage, int lastPage, Object printService, Object printRequestAttributeSet, int numOfCopy) throws Exception {
        Class<?> objClass = Class.forName("quadbase.reportdesigner.report.PrintReportForSwing");
        Constructor<?> objCons = objClass.getConstructor(ReportUI.class);
        Object printSwing = objCons.newInstance(reportUI);
        Method objMethod = objClass.getMethod("print", Boolean.class, Integer.class, Integer.class, Object.class, Object.class, Integer.class);
        objMethod.invoke(printSwing, Boolean.FALSE, firstPage, lastPage, printService, printRequestAttributeSet, numOfCopy);
    }

    public static void printUsingAwtPrint(Report report, boolean showPageDialog, boolean showPrintDialog, int firstPage, int lastPage) throws Exception {
        new PrintReport().printUsingAwtPrintHelper(report, showPageDialog, showPrintDialog, firstPage, lastPage);
    }

    private void printUsingAwtPrintHelper(Report report, boolean showPageDialog, boolean showPrintDialog, int firstPage, int lastPage) throws Exception {
        this.printUI = new ReportUI(report, IOUtil.getOffScreenGraphics(), true, false, true);
        this.printUI.resetFontTable();
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pageFormat = job.defaultPage();
        if (this.printUI.report.getOrientation() == 1) {
            pageFormat.setOrientation(0);
        }
        Paper paper = pageFormat.getPaper();
        Rectangle pageSize = ServerMessage.getPageSize();
        paper.setSize(pageSize.right(), pageSize.top());
        pageFormat.setPaper(paper);
        double max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight());
        pageFormat.setPaper(paper);
        if (showPageDialog) {
            pageFormat = job.pageDialog(pageFormat);
        }
        paper = pageFormat.getPaper();
        max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, max, max);
        pageFormat.setPaper(paper);
        Book bk = new Book();
        int totalPages = this.printUI.getTotalPages();
        int totalSections = this.printUI.getTotalSections();
        this.printUI.setPixelPerInch(72.0);
        if (firstPage > totalPages) {
            firstPage = totalPages;
        }
        if (lastPage == -1) {
            lastPage = totalPages;
        }
        for (int i = firstPage; i <= lastPage; ++i) {
            for (int j = 1; j <= totalSections; ++j) {
                bk.append(new PrintPage(i, j), pageFormat);
            }
        }
        job.setPageable(bk);
        if (!showPrintDialog || job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Print failed", ex);
            }
        }
    }

    private class PrintPage
    implements Printable {
        int page;
        int section;

        PrintPage(int page, int section) {
            this.page = page;
            this.section = section;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            try {
                PrintReport.this.printUI.draw(g, this.page, this.section);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed print a page", ex);
            }
            return 0;
        }
    }
}

