/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Graphics;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.output.Rectangle;
import quadbase.reportdesigner.PageViewer.swing.Report;
import quadbase.reportdesigner.PageViewer.swing.ReportInfo;
import quadbase.reportdesigner.report.PageReport;
import quadbase.reportdesigner.report.PrintUtil;
import quadbase.reportdesigner.report.ReportUI;

public class PrintReportForSwing {
    private static final Logger LOGGER = Logger.getLogger(PrintReportForSwing.class.getName());
    ReportUI printUI;
    boolean printingInit = false;
    static int fileCount = 0;
    ReportInfo reportInfo;
    Report pageReport;
    long abortTime = 2000L;

    public PrintReportForSwing(ReportUI reportUI) {
        this.printUI = (ReportUI)reportUI.clone();
        this.printUI.resetFontTable();
    }

    public void print() throws Exception {
        this.print(Boolean.TRUE, 1, -1, null, 1);
    }

    public void print(Boolean showDialog, Integer startPge, Integer lastPge) throws Exception {
        this.print(showDialog, startPge, lastPge, null, 1);
    }

    public void print(Boolean showDialog, Integer startPge, Integer lastPge, String preferredPrinter) throws Exception {
        this.print(showDialog, startPge, lastPge, preferredPrinter, 1);
    }

    public void print(Boolean showDialog, Integer startPge, Integer lastPge, String preferredPrinter, Integer numOfCopy) throws Exception {
        if (preferredPrinter != null && IOUtil.isJava14()) {
            this.print(showDialog, startPge, lastPge, PrintUtil.getPrintService(preferredPrinter), null, numOfCopy);
        } else {
            this.print(showDialog, startPge, lastPge, null, null, numOfCopy);
        }
    }

    public void print(Boolean showDialog, Integer startPge, Integer lastPge, Object printService, Object printRequestAttributeSet, Integer numOfCopy) throws Exception {
        PrintService ps = null;
        if (printService != null && !(printService instanceof PrintService)) {
            throw new IllegalArgumentException("printService is not an instance of javax.print.PrintService");
        }
        ps = (PrintService)printService;
        boolean promptDialog = showDialog;
        int startPage = startPge;
        int lastPage = lastPge;
        PrinterJob job = PrinterJob.getPrinterJob();
        try {
            if (ps != null) {
                job.setPrintService(ps);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot set print service", e);
        }
        PageFormat pageFormat = job.defaultPage();
        if (this.printUI.report.getOrientation() == 1) {
            pageFormat.setOrientation(0);
        }
        Paper paper = pageFormat.getPaper();
        Rectangle pageSize = ServerMessage.getPageSize();
        paper.setSize(pageSize.right(), pageSize.top());
        pageFormat.setPaper(paper);
        double max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight());
        pageFormat.setPaper(paper);
        if (promptDialog) {
            PageFormat newPageFormat = job.pageDialog(pageFormat);
            if (newPageFormat == pageFormat) {
                return;
            }
            pageFormat = newPageFormat;
        }
        paper = pageFormat.getPaper();
        max = pageFormat.getWidth();
        if (max < pageFormat.getHeight()) {
            max = pageFormat.getHeight();
        }
        paper.setImageableArea(0.0, 0.0, max, max);
        pageFormat.setPaper(paper);
        Book bk = new Book();
        int totalPages = this.printUI.getTotalPages();
        int totalSections = this.printUI.getTotalSections();
        this.abortTime = (long)(totalPages * totalSections) * this.abortTime;
        LOGGER.finest("Abort time: " + this.abortTime);
        if (startPage < 1) {
            startPage = 1;
        }
        if (lastPage < 1 || lastPage > totalPages) {
            lastPage = totalPages;
        }
        String baseFile = "PRINT_" + System.currentTimeMillis() + fileCount;
        if (ServerMessage.isServletServer()) {
            baseFile = ServerMessage.getPath(baseFile);
        }
        if (++fileCount > 200) {
            fileCount = 0;
        }
        this.reportInfo = new ReportInfo(baseFile, this.printUI.getTotalPages(), this.printUI.getTotalSections());
        int numOfCopy_CT = numOfCopy;
        if (numOfCopy_CT <= 0) {
            numOfCopy_CT = 1;
        }
        for (int i = startPage; i <= lastPage; ++i) {
            for (int j = 1; j <= totalSections; ++j) {
                for (int k = 0; k < numOfCopy_CT; ++k) {
                    bk.append(new PrintPage(i, j), pageFormat);
                }
            }
        }
        job.setPageable(bk);
        if (!promptDialog || job.printDialog()) {
            try {
                LOGGER.finest("Exporting: " + baseFile);
                new PageReport(this.printUI.report).exportPages(this.printUI, baseFile);
                this.pageReport = new Report(null, this.reportInfo, 1, 1);
                LOGGER.finest("Printing...");
                this.pageReport.setPrintingMode(true);
                if (printRequestAttributeSet != null && printRequestAttributeSet instanceof PrintRequestAttributeSet) {
                    job.print((PrintRequestAttributeSet)printRequestAttributeSet);
                } else {
                    job.print();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Print failed", ex);
            }
        }
        LOGGER.finest("Cleanup");
        PageReport.deleteAllPages(baseFile);
        LOGGER.finest("Done");
    }

    class PrintPage
    implements Printable {
        int page;
        int section;
        boolean abort = false;

        PrintPage(int page, int section) {
            this.page = page;
            this.section = section;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            if (this.abort) {
                return 1;
            }
            long startTime = System.currentTimeMillis();
            while (!PrintReportForSwing.this.reportInfo.isPageAvailable(this.page, this.section)) {
                if (System.currentTimeMillis() - startTime <= PrintReportForSwing.this.abortTime) continue;
                LOGGER.finest("Print job: abort");
                this.abort = true;
                return 1;
            }
            try {
                LOGGER.finest("Print page: " + this.page);
                Vector drawingCmd = PrintReportForSwing.this.reportInfo.getSelectedPage(this.page, this.section);
                LOGGER.finest("Vector size: " + drawingCmd.size());
                PrintReportForSwing.this.pageReport.draw(PrintReportForSwing.this.reportInfo, g, drawingCmd);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to print a page", ex);
            }
            return 0;
        }
    }
}

