/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.report.RTFReport;
import quadbase.reportdesigner.report.RTFSubReport;
import quadbase.reportdesigner.report.RTFUI;
import quadbase.reportdesigner.report.SubReportUI;
import quadbase.util.internal.PNGJimiEncoder;

public class RTFRTFObject
extends RTFSubReport {
    private static final Logger LOGGER = Logger.getLogger(RTFRTFObject.class.getName());
    private Vector lines = null;
    private ReportRTFObject rtfObject = null;
    private int currentColumnCount = 0;
    private int bottomY = 0;
    private boolean drawTop = true;
    private boolean drawBottom = false;
    private boolean started = false;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public RTFRTFObject(ReportRTFObject rtfObject, Vector l, int x, int y, int reportWidth, int reportHeight, RTFReport parent) {
        super(parent.report, x, y, reportWidth, reportHeight, parent);
        this.leftMargin = parent.getAbsoluteX(x, this.templateIndex);
        if (reportHeight < 0) {
            this.pageHeight = parent.pageHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
        }
        this.pageTopY = y;
        this.rtfObject = rtfObject;
        this.lines = l;
    }

    @Override
    protected SubReportUI createReportUI() throws Exception {
        return new RTFUI(this.rtfObject, this.lines, RTFRTFObject.toInch(this.offsetX), RTFRTFObject.toInch(this.elementYPos), RTFRTFObject.toInch(this.reportWidth), RTFRTFObject.toInch(this.reportHeight), this.parent.reportUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ByteArrayOutputStream rtfStream = new ByteArrayOutputStream();
            int textHeight = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                Object[] seg;
                int j;
                Vector segments = (Vector)this.lines.elementAt(i);
                int ascent = 0;
                int descent = 0;
                int maxFontSize = 0;
                for (j = 0; j < segments.size(); ++j) {
                    seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        int iHeight = (Integer)seg[2];
                        if (iHeight <= ascent) continue;
                        ascent = iHeight;
                        continue;
                    }
                    FontMetrics fontMetrics = QbUtil.getViewerFontMetrics((FontMetrics)seg[1], this.report.isAdjustFont());
                    if (fontMetrics.getMaxAscent() <= ascent) continue;
                    ascent = fontMetrics.getMaxAscent();
                    descent = fontMetrics.getMaxDescent();
                }
                if (this.pageHeight - this.elementYPos < this.pixelToTwips(ascent + descent + textHeight)) {
                    if (i > 0) {
                        this.writeRichText(rtfStream, this.pixelToTwips(textHeight));
                    }
                    this.elementYPos += this.pixelToTwips(textHeight);
                    this.pageBreak(null);
                    rtfStream.reset();
                    textHeight = 0;
                }
                textHeight = textHeight + ascent + descent;
                rtfStream.write(("\\sl" + this.mapLineHeight(ascent + descent, maxFontSize)).getBytes());
                for (j = 0; j < segments.size(); ++j) {
                    seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        if (IOUtil.isJimiIncluded()) {
                            PNGJimiEncoder.createPNGImage((Image)seg[0], bout, 0);
                            byte[] barray = bout.toByteArray();
                            String text = "{\\pict\\pngblip\\picscalex100\\picscaley100\\bin" + barray.length + " ";
                            rtfStream.write(text.getBytes());
                            rtfStream.write(barray);
                            rtfStream.write(125);
                        }
                        bout.close();
                        continue;
                    }
                    FontMetrics fontMetrics = (FontMetrics)seg[1];
                    String text = this.escapeTextForRTF((String)seg[0]);
                    Font font = fontMetrics.getFont();
                    String underline = "\\ul0";
                    if (((Boolean)seg[3]).booleanValue()) {
                        underline = "\\ul";
                    }
                    text = "\\f" + this.getFontIndex(font) + "\\fs" + RTFRTFObject.mapFontSize(QbUtil.resizeViewerFontRTF(font.getSize(), this.report.isAdjustFont())) + "\\cf" + this.getColorIndex((Color)seg[2]) + (font.isBold() ? "\\b" : "\\b0") + (font.isItalic() ? "\\i" : "\\i0") + underline + " " + text;
                    rtfStream.write(text.getBytes());
                }
                rtfStream.write("\\par\n".getBytes());
            }
            if (rtfStream.size() > 0) {
                this.writeRichText(rtfStream, this.pixelToTwips(textHeight));
            }
            this.elementYPos += this.pixelToTwips(textHeight);
            if (this.bottomY > this.elementYPos) {
                this.elementYPos = this.bottomY;
            }
            this.drawBottom = true;
            this.drawBorder();
            if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                int border = this.rtfObject.getBorderThickness() * 20;
                if (border > 75) {
                    border = 75;
                }
                this.elementYPos += this.rtfObject.getBorderThickness();
            }
            this.writeSectionColor();
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run RTFObject", ex);
            } else {
                LOGGER.log(Level.FINEST, "Sub-report page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run RTFObject", err);
        }
        finally {
            this.finish = true;
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
            }
        }
    }

    private void writeRichText(ByteArrayOutputStream rtfStream, int textHeight) throws Exception {
        this.started = true;
        int x = this.getAbsoluteX(0, 0);
        int y = this.getAbsoluteY(this.elementYPos);
        int w = this.reportWidth;
        int h = textHeight;
        if (this.checkVisibility) {
            h = RTFRTFObject.toTwips(this.rtfObject.getHeight());
        }
        x += RTFRTFObject.toTwips(this.rtfObject.getColumnWidth() + this.rtfObject.getColumnSpacing()) * this.currentColumnCount;
        String hAlign = "";
        if (this.rtfObject.getAlign() == 0) {
            hAlign = "\\qc";
        } else if (this.rtfObject.getAlign() == 2) {
            hAlign = "\\qr";
        }
        String text = "\\par\\pard\\absw" + w + "\\absh" + h + "\\phpg\\posx" + x + "\\pvpg\\posy" + y + hAlign;
        this.buffer.write(text.getBytes());
        this.buffer.write(rtfStream.toByteArray());
        this.buffer.write("\\pard\n".getBytes());
    }

    private int pixelToTwips(int pixel) {
        return RTFRTFObject.toTwips(QbUtil.toInch(pixel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.currentColumnCount < this.rtfObject.getActualColumnCount() - 1) {
            if (this.elementYPos > this.bottomY) {
                this.bottomY = this.elementYPos;
            }
            this.elementYPos = this.pageTopY;
            ++this.currentColumnCount;
            return;
        }
        if (this.bottomY > this.elementYPos) {
            this.elementYPos = this.bottomY;
        }
        this.drawBorder();
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        ++this.currentPageNumber;
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.currentColumnCount = 0;
        this.pageTopY = this.elementYPos;
        this.elementXPos = 0;
        this.writeSectionColor();
        this.bottomY = 0;
    }

    private void drawBorder() throws Exception {
        if (!this.started) {
            return;
        }
        int x = this.getAbsoluteX(0, 0);
        int y = this.getAbsoluteY(this.elementYPos) - (this.elementYPos - this.pageTopY);
        int w = this.reportWidth;
        int h = this.elementYPos - this.pageTopY;
        if (this.checkVisibility) {
            h = RTFRTFObject.toTwips(this.rtfObject.getHeight());
        }
        if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null || this.rtfObject.getBgColor() != null) {
            String border = "";
            if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                int b = this.rtfObject.getBorderThickness() * 20;
                if (b > 75) {
                    b = 75;
                }
                if (this.rtfObject.isBorderClosed() || this.drawTop && (this.drawBottom || this.checkVisibility)) {
                    border = "\\box\\brdrw" + b + "\\brdrcf" + this.getColorIndex(this.rtfObject.getBorderColor());
                    x += 25;
                    y -= b;
                    w -= 50;
                    h += b * 2;
                } else {
                    this.templates[0].write(("\\absw" + (b * 2 + 20) + "\\absh" + h + "\\phpg\\posx" + (x + 25) + "\\pvpg\\posy" + y + "\\brdrl\\brdrw" + b + "\\brdrcf" + this.getColorIndex(this.rtfObject.getBorderColor()) + "\\f0\\fs2\\par\\pard\n").getBytes());
                    this.templates[0].write(("\\absw" + (b * 2 + 20) + "\\absh" + h + "\\phpg\\posx" + (x + w + b + 25) + "\\pvpg\\posy" + y + "\\brdrl\\brdrw" + b + "\\brdrcf" + this.getColorIndex(this.rtfObject.getBorderColor()) + "\\f0\\fs2\\par\\pard\n").getBytes());
                    if (this.drawTop) {
                        this.templates[0].write(("\\absw" + (w + b * 2) + "\\absh" + (b * 2 + 20) + "\\phpg\\posx" + (x - b) + "\\pvpg\\posy" + (y - b) + "\\brdrt\\brdrw" + b + "\\brdrcf" + this.getColorIndex(this.rtfObject.getBorderColor()) + "\\f0\\fs2\\par\\pard\n").getBytes());
                    }
                    if (this.drawBottom || this.checkVisibility) {
                        this.templates[0].write(("\\absw" + (w + b * 2) + "\\absh" + (b * 2 + 20) + "\\phpg\\posx" + (x - b) + "\\pvpg\\posy" + (y + h) + "\\brdrt\\brdrw" + b + "\\brdrcf" + this.getColorIndex(this.rtfObject.getBorderColor()) + "\\f0\\fs2\\par\\pard\n").getBytes());
                    }
                }
            }
            if (border.equals("")) {
                --y;
            }
            String background = "";
            if (this.rtfObject.getBgColor() != null) {
                background = "\\shading10000\\cfpat" + this.getColorIndex(this.rtfObject.getBgColor());
            }
            String text = "\\absw" + w + "\\absh" + h + "\\phpg\\posx" + x + "\\pvpg\\posy" + y + border + background + "\\f0\\fs2\\par\\pard\n";
            this.templates[0].write(text.getBytes());
        }
        this.templates[0].write(this.buffer.toByteArray());
        this.buffer.reset();
        if (this.drawTop) {
            this.drawTop = false;
        }
    }
}

