/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.RTFRTFObject;
import quadbase.reportdesigner.report.RTFReportColumnar;
import quadbase.reportdesigner.report.RTFReportCrossTab;
import quadbase.reportdesigner.report.RTFReportMasterDetails;
import quadbase.reportdesigner.report.RTFReportSummary;
import quadbase.reportdesigner.report.RTFSubReport;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.internal.BarcodeUtil;
import quadbase.util.internal.PNGJimiEncoder;

public class RTFReport {
    private static final Logger LOGGER = Logger.getLogger(RTFReport.class.getName());
    private Color[] DEFAULT_COLORS = new Color[]{new Color(0, 0, 0), new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 0, 255), new Color(255, 0, 0), new Color(255, 255, 0), new Color(0, 0, 128), new Color(0, 128, 128), new Color(0, 128, 0), new Color(128, 0, 128), new Color(128, 0, 0), new Color(128, 128, 0), new Color(128, 128, 128), new Color(192, 192, 192), new Color(255, 255, 255)};
    public Color[] colorTbl = null;
    private String[][] fontTbl = new String[0][0];
    private String[][] FONT_TABLE = new String[][]{{"Times New Roman", "roman", "0", "2"}, {"Arial", "swiss", "0", "2"}, {"Courier New", "modern", "0", "1"}, {"Symbol", "roman", "2", "2"}, {"Wingdings", "nil", "2", "2"}, {"Tahoma", "swiss", "0", "2"}, {"Marlett", "nil", "2", "2"}, {"Lucida Console", "modern", "0", "1"}, {"Lucida Sans Unicode", "swiss", "0", "2"}, {"Verdana", "swiss", "0", "2"}, {"Arial Black", "swiss", "0", "2"}, {"Comic Sans MS", "script", "0", "2"}, {"Impact", "swiss", "0", "2"}, {"Georgia", "roman", "0", "2"}, {"Palatino Linotype", "roman", "0", "2"}, {"Trebuchet MS", "swiss", "0", "2"}, {"Webdings", "roman", "2", "2"}, {"Microsoft Sans Serif", "swiss", "0", "2"}, {"MS Mincho", "modern", "128", "1"}, {"MS PMincho", "roman", "128", "2"}, {"MS Gothic", "modern", "128", "1"}, {"MS PGothic", "swiss", "128", "2"}, {"MS UI Gothic", "swiss", "128", "2"}, {"MingLiU", "modern", "136", "1"}, {"PMingLiU", "roman", "136", "2"}, {"Haettenschweiler", "swiss", "0", "2"}, {"Arial Narrow", "swiss", "0", "2"}, {"Bookman Old Style", "roman", "0", "2"}, {"Garamond", "roman", "0", "2"}, {"Bookshelf Symbol 1", "swiss", "0", "2"}, {"Bookshelf Symbol 3", "roman", "2", "2"}, {"SimSun", "nil", "134", "2"}, {"NSimSun", "modern", "134", "1"}, {"SimHei", "nil", "134", "2"}, {"Times New Roman CE", "roman", "238", "2"}, {"Times New Roman Cyr", "roman", "204", "2"}, {"Times New Roman Greek", "roman", "161", "2"}, {"Times New Roman Tur", "roman", "162", "2"}, {"Times New Roman Baltic", "roman", "186", "2"}, {"Arial CE", "swiss", "238", "2"}, {"Arial Cyr", "swiss", "204", "2"}, {"Arial Greek", "swiss", "161", "2"}, {"Arial Tur", "swiss", "162", "2"}, {"Arial Baltic", "swiss", "186", "2"}, {"Courier New CE", "modern", "238", "1"}, {"Courier New Cyr", "modern", "204", "1"}, {"Courier New Greek", "modern", "161", "1"}, {"Courier New Tur", "modern", "162", "1"}, {"Courier New Baltic", "modern", "186", "1"}, {"Tahoma CE", "swiss", "238", "2"}, {"Tahoma Cyr", "swiss", "204", "2"}, {"Tahoma Greek", "swiss", "161", "2"}, {"Tahoma Tur", "swiss", "162", "2"}, {"Tahoma Baltic", "swiss", "186", "2"}, {"Lucida Console CE", "modern", "238", "1"}, {"Lucida Console Cyr", "modern", "204", "1"}, {"Lucida Console Greek", "modern", "161", "1"}, {"Lucida Console Tur", "modern", "162", "1"}, {"Lucida Sans Unicode CE", "swiss", "238", "2"}, {"Lucida Sans Unicode Cyr", "swiss", "204", "2"}, {"Lucida Sans Unicode Greek", "swiss", "161", "2"}, {"Lucida Sans Unicode Tur", "swiss", "162", "2"}, {"Verdana CE", "swiss", "238", "2"}, {"Verdana Cyr", "swiss", "204", "2"}, {"Verdana Greek", "swiss", "161", "2"}, {"Verdana Tur", "swiss", "162", "2"}, {"Verdana Baltic", "swiss", "186", "2"}, {"Arial Black CE", "swiss", "238", "2"}, {"Arial Black Cyr", "swiss", "204", "2"}, {"Arial Black Greek", "swiss", "161", "2"}, {"Arial Black Tur", "swiss", "162", "2"}, {"Arial Black Baltic", "swiss", "186", "2"}, {"Comic Sans MS CE", "script", "238", "2"}, {"Comic Sans MS Cyr", "script", "204", "2"}, {"Comic Sans MS Greek", "script", "161", "2"}, {"Comic Sans MS Tur", "script", "162", "2"}, {"Comic Sans MS Baltic", "script", "186", "2"}, {"Impact CE", "swiss", "238", "2"}, {"Impact Cyr", "swiss", "204", "2"}, {"Impact Greek", "swiss", "161", "2"}, {"Impact Tur", "swiss", "162", "2"}, {"Impact Baltic", "swiss", "186", "2"}, {"Georgia CE", "roman", "238", "2"}, {"Georgia Cyr", "roman", "204", "2"}, {"Georgia Greek", "roman", "161", "2"}, {"Georgia Tur", "roman", "162", "2"}, {"Georgia Baltic", "roman", "186", "2"}, {"Palatino Linotype CE", "roman", "238", "2"}, {"Palatino Linotype Cyr", "roman", "204", "2"}, {"Palatino Linotype Greek", "roman", "161", "2"}, {"Palatino Linotype Tur", "roman", "162", "2"}, {"Palatino Linotype Baltic", "roman", "186", "2"}, {"Trebuchet MS CE", "swiss", "238", "2"}, {"Trebuchet MS Tur", "swiss", "162", "2"}, {"Microsoft Sans Serif CE", "swiss", "238", "2"}, {"Microsoft Sans Serif Cyr", "swiss", "204", "2"}, {"Microsoft Sans Serif Greek", "swiss", "161", "2"}, {"Microsoft Sans Serif Tur", "swiss", "162", "2"}, {"Microsoft Sans Serif Baltic", "swiss", "186", "2"}, {"MS Mincho", "modern", "0", "1"}, {"MS Mincho CE", "modern", "238", "1"}, {"MS Mincho Cyr", "modern", "204", "1"}, {"MS Mincho Greek", "modern", "161", "1"}, {"MS Mincho Tur", "modern", "162", "1"}, {"MS Mincho Baltic", "modern", "186", "1"}, {"MS PMincho", "roman", "0", "2"}, {"MS PMincho CE", "roman", "238", "2"}, {"MS PMincho Cyr", "roman", "204", "2"}, {"MS PMincho Greek", "roman", "161", "2"}, {"MS PMincho Tur", "roman", "162", "2"}, {"MS PMincho Baltic", "roman", "186", "2"}, {"MS Gothic", "modern", "0", "1"}, {"MS Gothic CE", "modern", "238", "1"}, {"MS Gothic Cyr", "modern", "204", "1"}, {"MS Gothic Greek", "modern", "161", "1"}, {"MS Gothic Tur", "modern", "162", "1"}, {"MS Gothic Baltic", "modern", "186", "1"}, {"MS PGothic", "swiss", "0", "2"}, {"MS PGothic CE", "swiss", "238", "2"}, {"MS PGothic Cyr", "swiss", "204", "2"}, {"MS PGothic Greek", "swiss", "161", "2"}, {"MS PGothic Tur", "swiss", "162", "2"}, {"MS PGothic Baltic", "swiss", "186", "2"}, {"MS UI Gothic", "swiss", "0", "2"}, {"MS UI Gothic CE", "swiss", "238", "2"}, {"MS UI Gothic Cyr", "swiss", "204", "2"}, {"MS UI Gothic Greek", "swiss", "161", "2"}, {"MS UI Gothic Tur", "swiss", "162", "2"}, {"MS UI Gothic Baltic", "swiss", "186", "2"}, {"MingLiU", "modern", "0", "1"}, {"PMingLiU", "roman", "0", "2"}, {"Arial Narrow CE", "swiss", "238", "2"}, {"Arial Narrow Cyr", "swiss", "204", "2"}, {"Arial Narrow Greek", "swiss", "161", "2"}, {"Arial Narrow Tur", "swiss", "162", "2"}, {"Arial Narrow Baltic", "swiss", "186", "2"}, {"Bookman Old Style CE", "roman", "238", "2"}, {"Bookman Old Style Cyr", "roman", "204", "2"}, {"Bookman Old Style Greek", "roman", "161", "2"}, {"Bookman Old Style Tur", "roman", "162", "2"}, {"Bookman Old Style Baltic", "roman", "186", "2"}, {"Garamond CE", "roman", "238", "2"}, {"Garamond Cyr", "roman", "204", "2"}, {"Garamond Greek", "roman", "161", "2"}, {"Garamond Tur", "roman", "162", "2"}, {"Garamond Baltic", "roman", "186", "2"}, {"SimSun", "nil", "0", "2"}, {"NSimSun", "modern", "0", "1"}};
    protected Hashtable fontTableCache;
    protected int leftMargin = 0;
    protected int topMargin = 0;
    protected int bottomMargin = 0;
    protected int pageHeight = 0;
    protected int pageWidth = 0;
    protected int pageHeaderHeight = 0;
    protected int elementXPos = 0;
    protected int elementYPos = 0;
    protected Report report = null;
    private Vector sectionList = null;
    private Vector tableList = null;
    protected int currentPageNumber = 1;
    protected int totalPageNumber = 1;
    protected int currentSection = 1;
    protected int totalSections = 1;
    protected ReportTable hTable = null;
    protected ReportTable fTable = null;
    protected static final String evalText = "Evaluation copy by Quadbase Systems Inc.";
    protected static final String contactText = "Please contact sales@quadbase.com for purchasing information.";
    protected int columnWrapCount = 0;
    protected int columnWrapInitialRow = 0;
    protected int columnWrapDisplayRow = 0;
    protected int lastDrawCol = 0;
    protected int columnWrapWidth = 0;
    protected boolean doColumnWrap = false;
    int[] wrapInfo;
    int curMaxY;
    protected ReportUI reportUI = null;
    protected ReportGraphics reportGraphics = null;
    protected boolean checkTotalPageNumber = false;
    protected Vector treeStructure = null;
    protected Vector rowElements = null;
    protected Hashtable rows = null;
    protected int pagebreaks = 0;
    protected boolean checkFitGroupOnPage = false;
    protected boolean resetPageNumber = false;
    protected int pageCt = 1;
    protected Hashtable sectionTotalPagesTable = null;
    protected String treeCopy = "";
    protected boolean populateTable = true;
    protected int savedStartPage = 1;
    protected Vector sectionTotalPages = null;
    protected Vector sectionStartPage = null;
    protected Hashtable pageLookup = null;
    Object[] previousRowValue;
    boolean[] previousRowIsBGColor2;
    boolean calculated = false;
    protected ByteArrayOutputStream[] templates = null;
    protected ByteArrayOutputStream[] background_templates = null;
    protected PrintWriter[] writers = null;
    protected int[] background_offset = null;
    public static final String BACKGROUND_TEXTSTRING = " BACKGROUND ";
    public static final String COLORTABLE_TEXTSTRING = "*S#D%V$%)KME#COLORTABLE^HNBF#^(KG$^G#";
    private Graphics offScreenGraphics = null;
    boolean isWriteRepeatSection = false;
    boolean titleAdjusted = false;
    int rowCount;
    boolean skipFormatTable = false;

    public RTFReport() {
        this.getOffScreenGraphics();
        this.initFontTableCache();
    }

    public RTFReport(Report report) {
        this.report = report;
        this.init();
    }

    public RTFReport(Report report, boolean skipFormatTable) {
        this(report);
        this.skipFormatTable = skipFormatTable;
    }

    private void init() {
        this.leftMargin = RTFReport.toTwips(this.report.getLeftMargin());
        this.topMargin = RTFReport.toTwips(this.report.getTopMargin());
        this.bottomMargin = RTFReport.toTwips(this.report.getBottomMargin());
        this.elementYPos = 0;
        this.elementXPos = 0;
        this.pageWidth = RTFReport.toTwips(this.report.getActualPageWidth());
        this.currentPageNumber = 1;
        this.treeCopy = "";
        this.pageCt = 1;
        this.savedStartPage = 1;
        this.treeStructure = new Vector();
        this.isWriteRepeatSection = false;
        this.getOffScreenGraphics();
        this.initFontTableCache();
        this.rowCount = 0;
    }

    protected void initFontTableCache() {
        int i;
        if (this.report != null) {
            this.fontTbl = this.report.getRichTextFonts();
        }
        this.fontTableCache = new Hashtable(this.FONT_TABLE.length + this.fontTbl.length);
        for (i = 0; i < this.fontTbl.length; ++i) {
            this.fontTableCache.put(this.fontTbl[i][0], i);
        }
        for (i = 0; i < this.FONT_TABLE.length; ++i) {
            this.fontTableCache.put(this.FONT_TABLE[i][0], i + this.fontTbl.length);
        }
    }

    public void exportRTF(OutputStream outstream) throws Exception {
        LOGGER.finest("RTF: export");
        long totalTime = System.currentTimeMillis();
        this.reportUI = new ReportUI(this.report, this.getOffScreenGraphics(), false);
        this.reportUI.preCalcTotalSections();
        this.reportGraphics = this.reportUI.getReportGraphics();
        this.reportGraphics.setAdditionalOffset(3);
        this.totalSections = this.reportUI.getTotalSections();
        double pHeight = this.report.getActualPageHeight() - (this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight());
        this.pageHeight = RTFReport.toTwips(pHeight);
        long totalPagesTime = System.currentTimeMillis();
        this.checkTotalPageNumber = true;
        this.exportRTF();
        this.totalPageNumber = this.currentPageNumber;
        LOGGER.finest("Total sections: " + this.totalSections);
        LOGGER.finest("Total page number: " + this.currentPageNumber);
        this.populatePageLookupTable();
        LOGGER.finest("Cal total pages time: " + (double)(System.currentTimeMillis() - totalPagesTime) / 1000.0);
        LOGGER.finest("Total pages: " + this.totalPageNumber);
        this.init();
        this.checkTotalPageNumber = false;
        this.populateTable = false;
        this.exportRTF();
        outstream.write(this.templates[0].toByteArray());
        LOGGER.finest("Total time: " + (double)(System.currentTimeMillis() - totalTime) / 1000.0);
    }

    private void populatePageLookupTable() {
        if (this.sectionTotalPages == null || this.sectionStartPage == null) {
            return;
        }
        if (this.sectionTotalPages.size() != this.sectionStartPage.size()) {
            return;
        }
        if (this.sectionTotalPages.size() == 0) {
            return;
        }
        int count = this.sectionTotalPages.size();
        int lastSectionTotalPages = (Integer)this.sectionTotalPages.elementAt(count - 1);
        int lastSectionStartPage = (Integer)this.sectionStartPage.elementAt(count - 1);
        for (int i = count - 2; i >= 0; --i) {
            int nextSectionStartPage = (Integer)this.sectionStartPage.elementAt(i);
            if (nextSectionStartPage == lastSectionStartPage) {
                this.sectionTotalPages.setElementAt(lastSectionTotalPages, i);
            }
            lastSectionTotalPages = (Integer)this.sectionTotalPages.elementAt(i);
            lastSectionStartPage = (Integer)this.sectionStartPage.elementAt(i);
        }
        this.pageLookup = new Hashtable();
        int nextStartPage = (Integer)this.sectionStartPage.elementAt(0);
        int nextTotalPages = (Integer)this.sectionTotalPages.elementAt(0);
        for (int i = 1; i <= this.totalPageNumber; ++i) {
            if (i < nextStartPage) {
                this.pageLookup.put(i, new int[]{i, i});
                continue;
            }
            if (i != nextStartPage) continue;
            nextTotalPages = (Integer)this.sectionTotalPages.remove(0);
            nextStartPage = (Integer)this.sectionStartPage.remove(0);
            boolean flag = false;
            int j = 1;
            while (j <= nextTotalPages) {
                this.pageLookup.put(i, new int[]{j++, nextTotalPages});
                flag = true;
                ++i;
            }
            if (this.sectionTotalPages.size() > 0) {
                nextTotalPages = (Integer)this.sectionTotalPages.elementAt(0);
                nextStartPage = (Integer)this.sectionStartPage.elementAt(0);
            }
            if (!flag) continue;
            --i;
        }
    }

    protected void exportRTF() throws Exception {
        Vector<ReportTable> vec;
        int i;
        this.templates = new ByteArrayOutputStream[this.totalSections];
        this.writers = new PrintWriter[this.totalSections];
        for (i = 0; i < this.templates.length; ++i) {
            this.templates[i] = new ByteArrayOutputStream();
        }
        for (i = 0; i < this.writers.length; ++i) {
            this.writers[i] = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.templates[i], "ISO-8859-1"), true);
        }
        ReportTable table = null;
        this.colorTbl = this.report.isUsingAllColorsForRTF() ? this.report.getAllColors() : new Color[0];
        if (this.checkTotalPageNumber) {
            this.formatTable();
        }
        if ((vec = this.report.getReportTables()).size() <= 0) {
            throw new Exception("The report does not contain any table. Please check and try again later.");
        }
        table = vec.elementAt(0);
        this.hTable = vec.elementAt(0);
        this.fTable = vec.elementAt(vec.size() - 1);
        this.writeHeadTag();
        this.startToGetData(table);
        if (this.report.getInitializeReportError() != null) {
            this.writeSection(ReportUI.createErrorSection(this.report.getActualPageWidth(), this.report.getActualPageHeight(), this.report.getInitializeReportError()), table);
        } else {
            this.writePageSections(true);
            this.writeSection(this.report.getReportHeader(), table);
            for (int i2 = 0; i2 < vec.size(); ++i2) {
                table = vec.elementAt(i2);
                this.initRepeatSection();
                this.setColumnWrap();
                this.wrapInfo = new int[]{0, this.elementYPos, this.elementYPos};
                this.writeReportTable(table);
                if (this.doColumnWrap && this.elementYPos < this.curMaxY) {
                    this.elementYPos = this.curMaxY;
                }
                this.resetColumnWrap();
            }
            if (this instanceof RTFReportSummary) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((RTFReportSummary)this).footerAggCol, ((RTFReportSummary)this).footerResCol);
            } else if (this instanceof RTFReportColumnar) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((RTFReportColumnar)this).footerAggCol, ((RTFReportColumnar)this).footerResCol);
            } else if (this instanceof RTFReportCrossTab) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((RTFReportCrossTab)this).footerAggCol, ((RTFReportCrossTab)this).footerResCol);
            } else if (this instanceof RTFReportMasterDetails) {
                this.writeSection(this.report.getReportFooter(), this.fTable, ((RTFReportMasterDetails)this).footerAggCol, ((RTFReportMasterDetails)this).footerResCol);
            } else {
                this.writeSection(this.report.getReportFooter(), this.fTable);
            }
            this.elementYPos = this.pageHeight;
            this.writePageSections(false);
        }
        this.writeWaterMark();
        this.addAllTemplates();
        this.templates[0].write("}".getBytes());
        this.templates[0].flush();
        this.calculated = true;
    }

    private void writePageSections(boolean header) throws Exception {
        this.currentSection = 1;
        ByteArrayOutputStream first = this.templates[0];
        PrintWriter firstWriter = this.writers[0];
        int old_elementYPos = this.elementYPos;
        for (int i = 0; i < this.templates.length; ++i) {
            this.templates[0] = this.templates[i];
            this.writers[0] = this.writers[i];
            this.elementYPos = old_elementYPos;
            if (header) {
                if (!this.checkFitGroupOnPage) {
                    ReportImage image;
                    if (this.report.getBackgroundColor() != null) {
                        this.templates[i].write(new StringBuffer(200).append("\\absw").append(RTFReport.toTwips(this.report.getPageWidth() - 0.5)).append("\\absh").append(RTFReport.toTwips(this.report.getPageHeight() - 0.5)).append("\\phpg\\posx").append(RTFReport.toTwips(0.25)).append("\\pvpg\\posy").append(RTFReport.toTwips(0.25)).append("\\shading10000\\cfpat").append(this.getColorIndex(this.report.getBackgroundColor())).append("\\par\\pard\n").toString().getBytes());
                    }
                    if ((image = this.report.getBackgroundImage()) != null) {
                        double oldheight;
                        double oldwidth;
                        if (image.getImageOption() == 1) {
                            oldwidth = image.getWidth();
                            oldheight = image.getHeight();
                            image.setWidth(this.report.getPageWidth() - 0.5);
                            image.setHeight(this.report.getPageHeight() - 0.5);
                            this.writeReportImageHelper(image, RTFReport.toTwips(0.25), RTFReport.toTwips(0.25), this.templates[i]);
                            image.setWidth(oldwidth);
                            image.setHeight(oldheight);
                        } else if (image.getImageOption() == 2) {
                            double x = 0.0;
                            double y = 0.0;
                            while (y + image.getHeight() < this.report.getPageHeight()) {
                                x = 0.0;
                                while (x + image.getWidth() < this.report.getPageWidth()) {
                                    this.writeReportImageHelper(image, RTFReport.toTwips(x), RTFReport.toTwips(y), this.templates[i]);
                                    x += image.getWidth();
                                }
                                y += image.getHeight();
                            }
                        } else {
                            oldwidth = image.getWidth();
                            oldheight = image.getHeight();
                            if (image.getWidth() > this.report.getPageWidth() - 0.5 && image.getHeight() > this.report.getPageHeight() - 0.5) {
                                image.setWidth(this.report.getPageWidth() - 0.5);
                                image.setHeight(this.report.getPageHeight() - 0.5);
                            }
                            int x = RTFReport.toTwips((float)((this.report.getPageWidth() - image.getWidth()) / 2.0));
                            int y = RTFReport.toTwips((float)((this.report.getPageHeight() - image.getHeight()) / 2.0));
                            this.writeReportImageHelper(image, x, y, this.templates[i]);
                            image.setWidth(oldwidth);
                            image.setHeight(oldheight);
                        }
                    }
                }
                this.pageHeaderHeight = this.writeSection(this.report.getPageHeader(), this.hTable);
            } else {
                this.writeSection(this.report.getPageFooter(), this.fTable, false);
            }
            ++this.currentSection;
        }
        this.templates[0] = first;
        this.writers[0] = firstWriter;
        this.currentSection = 1;
    }

    protected void addAllTemplates() throws Exception {
        this.insertBackgroundTemplates();
        for (int i = 1; i < this.templates.length; ++i) {
            this.templates[0].write("\\pagebb\n".getBytes());
            this.templates[0].write(this.templates[i].toByteArray());
        }
    }

    private void insertBackgroundTemplates() throws Exception {
        if (this.background_templates != null) {
            for (int i = 0; i < this.templates.length; ++i) {
                if (this.background_offset[i] == this.templates[i].size()) {
                    this.templates[i].write(this.background_templates[i].toByteArray());
                    continue;
                }
                byte[] content = this.templates[i].toByteArray();
                this.templates[i].reset();
                this.templates[i].write(content, 0, this.background_offset[i]);
                this.templates[i].write(this.background_templates[i].toByteArray());
                this.templates[i].write(content, this.background_offset[i], content.length - this.background_offset[i]);
            }
        }
    }

    protected void resetAllTemplates() throws Exception {
        int i;
        for (i = 1; i < this.templates.length; ++i) {
            if (this.templates[i] != null) {
                this.templates[i].close();
            }
            this.templates[i].reset();
        }
        if (this.background_templates != null) {
            for (i = 0; i < this.background_templates.length; ++i) {
                this.background_templates[i].reset();
                this.background_offset[i] = this.templates[i].size();
            }
        }
    }

    protected void initRepeatSection() {
        this.sectionList = new Vector();
        this.tableList = new Vector();
    }

    void setColumnWrap() {
        this.setColumnWrap(this.pageWidth);
    }

    void setColumnWrap(int pWidth) {
        if (this.report.getReportType() != 0 && this.report.getReportType() != 4 && this.report.getReportType() != 1 || this.report.getColumnWrap() == null) {
            this.resetColumnWrap();
            return;
        }
        this.doColumnWrap = true;
        this.columnWrapWidth = RTFReport.toTwips(this.report.getColumnWrap().getX());
        this.columnWrapCount = this.report.getColumnWrap().getWrapCount();
        int maxWrapCount = (int)Math.floor(pWidth / this.columnWrapWidth) - 1;
        if (this.columnWrapCount < 0 || this.columnWrapCount > maxWrapCount) {
            this.columnWrapCount = maxWrapCount;
        }
        if (this.columnWrapCount < 0) {
            this.columnWrapCount = 0;
        }
    }

    void resetColumnWrap() {
        this.columnWrapWidth = 0;
        this.columnWrapCount = 0;
        this.doColumnWrap = false;
        this.resetColumnWrapTableUI();
    }

    void resetColumnWrapTableUI() {
        this.columnWrapInitialRow = 0;
        this.columnWrapDisplayRow = 0;
    }

    void formatTable() throws Exception {
        if (!this.skipFormatTable) {
            this.report.formatTable();
        }
    }

    protected int getCurrentPageNumber() {
        if (!this.resetPageNumber) {
            return this.currentPageNumber;
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.pageCt)) {
            int[] pages = (int[])this.pageLookup.get(this.pageCt);
            if (pages != null && pages.length == 2) {
                return pages[0];
            }
            return this.currentPageNumber;
        }
        return this.currentPageNumber;
    }

    protected int getTotalPageNumber() {
        if (!this.resetPageNumber) {
            return this.totalPageNumber;
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.pageCt)) {
            int[] pages = (int[])this.pageLookup.get(this.pageCt);
            if (pages != null && pages.length == 2) {
                return pages[1];
            }
            return this.currentPageNumber;
        }
        return this.currentPageNumber;
    }

    protected ReportSection resizeSection(ReportGraphics g, ReportSection _sec, ReportTable tbl) throws Exception {
        int i;
        Report temp_report = this.report;
        boolean shift = false;
        ReportSection sec = new ReportSection();
        boolean resize = false;
        boolean copied = false;
        if (this.treeStructure != null) {
            if (_sec.hasFormattedCell(this.treeStructure)) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                Hashtable<Integer, ReportCell> cellTable = sec.getFormattedCells(this.treeStructure);
                ReportCell[] cell = sec.getCells();
                for (int i2 = 0; i2 < cell.length; ++i2) {
                    ReportCell formattedCell;
                    if (!cellTable.containsKey(i2)) continue;
                    cell[i2] = formattedCell = cellTable.get(i2);
                }
                resize = true;
                shift = true;
            }
            if (_sec.hasSectionCells(this.treeStructure)) {
                Vector<ReportCell> sectionCells = _sec.getSectionCells(this.treeStructure);
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                if (sectionCells != null) {
                    for (int i3 = 0; i3 < sectionCells.size(); ++i3) {
                        sec.addData(sectionCells.elementAt(i3));
                    }
                }
                resize = true;
                shift = true;
            }
            if (_sec.getHeight(this.treeStructure) > 0.0) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                sec.setHeight(_sec.getHeight(this.treeStructure));
                resize = true;
                shift = true;
            }
        }
        for (i = 0; i < _sec.getCellCount() && !resize; ++i) {
            if (!_sec.getData(i).isVisible() || !_sec.getData(i).isResizeToFitContent()) continue;
            if (!copied) {
                sec.deepCopy(_sec);
            }
            copied = true;
            resize = true;
        }
        if (resize) {
            for (i = 0; i < sec.getCellCount(); ++i) {
                ReportGraphics temp_rg;
                double[] res;
                ReportCell element = sec.getData(i);
                if (!element.isResizeToFitContent()) continue;
                if (element instanceof SubReportObject || element instanceof TableOfContents || element instanceof ReportRTFObject) {
                    shift = true;
                }
                ReportCell cell = tbl.formatCell(element, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, temp_report);
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject || cell instanceof TableOfContents || cell instanceof SubReportObject) {
                    h = cell.getHeight();
                }
                if ((cell instanceof ReportRTFObject || cell instanceof SubReportObject) && (sec.getBgColor() != null || sec.hasExtendVertLineOrGrid()) && (res = (temp_rg = this.reportUI.getReportGraphics()).drawCell(this.report, tbl, null, cell, sec, 0.0, 0.0, 0)) != null && res.length > 0) {
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportSection.resizeVerticallyAndShift((ReportElement)element, sec, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = sec.getMinHeight();
            if (sec.getHeight() < minH) {
                if (sec.isResizeToFitContent()) {
                    double increase = ReportUI.getMaxIncreaseProportion(_sec, sec);
                    for (int i4 = 0; i4 < sec.getCellCount(); ++i4) {
                        if (sec.getData(i4) instanceof ReportLine && ((ReportLine)sec.getData(i4)).isVertical() && ((ReportLine)sec.getData(i4)).next() != null) {
                            sec.getData(i4).setHeight(sec.getMinHeight() - sec.getData(i4).getY());
                            continue;
                        }
                        if (!(sec.getData(i4) instanceof ReportCell) && !(sec.getData(i4) instanceof ReportGrid) && !(sec.getData(i4) instanceof ReportLine)) continue;
                        double h1 = _sec.getData(i4).getHeight() * increase;
                        double h2 = sec.getData(i4).getHeight();
                        sec.getData(i4).setHeight(h1 > h2 ? h1 : h2);
                    }
                    minH = sec.getMinHeight();
                }
                sec.setHeight(minH);
            }
            return sec;
        }
        for (i = 0; i < _sec.getCellCount(); ++i) {
            if (!(_sec.getData(i) instanceof ReportLine) || ((ReportLine)_sec.getData(i)).next() == null || !((ReportLine)_sec.getData(i)).isVertical()) continue;
            _sec.getData(i).setHeight(_sec.getHeight() - _sec.getData(i).getY());
        }
        return _sec;
    }

    protected ReportTable resizeTable(ReportGraphics g, ReportTable _tbl, int rowIndex) throws Exception {
        int i;
        boolean resize;
        ReportTable tbl;
        boolean shift;
        Report temp_report;
        block20: {
            int i2;
            FormattedRow row;
            FormattedRowKey key;
            temp_report = this.report;
            shift = false;
            tbl = new ReportTable();
            resize = false;
            this.rowElements = null;
            double rowHeight = 0.0;
            if (this.rows != null && this.rows.containsKey(key = this.treeStructure == null || this.treeStructure.size() == 0 ? new FormattedRowKey(rowIndex, null) : new FormattedRowKey(rowIndex, this.getTreeLevel())) && (row = (FormattedRow)this.rows.get(key)) != null) {
                rowHeight = row.getRowHeight();
                this.rowElements = row.getRowElements();
                for (int j = 0; j < _tbl.getColumnCount(); ++j) {
                    tbl.addColumn(new ReportColumn());
                }
                tbl.deepCopy(_tbl);
                tbl.setHeight(rowHeight);
                resize = true;
                shift = true;
            }
            if (this.calculated || this.checkFitGroupOnPage) break block20;
            if (this.previousRowValue == null) {
                this.previousRowValue = new Object[_tbl.getColumnCount()];
                this.previousRowIsBGColor2 = new boolean[_tbl.getColumnCount()];
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
                    this.previousRowIsBGColor2[i2] = false;
                }
            } else {
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    int[] index = _tbl.getColumn(i2).getDualColorColInfoIndex();
                    if (index == null) continue;
                    boolean different = false;
                    for (int j = 0; j < index.length; ++j) {
                        if ((this.previousRowValue[index[j]] != null || _tbl.getColumn(index[j]).getData(rowIndex) == null) && (this.previousRowValue[index[j]] == null || this.previousRowValue[index[j]].equals(_tbl.getColumn(index[j]).getData(rowIndex)) || "".equals(_tbl.getColumn(index[j]).getData(rowIndex)))) continue;
                        different = true;
                        break;
                    }
                    if (different) {
                        this.previousRowIsBGColor2[i2] = !this.previousRowIsBGColor2[i2];
                    }
                    _tbl.getColumn(i2).setIsBGColor2(rowIndex, this.previousRowIsBGColor2[i2]);
                }
            }
            for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
            }
        }
        for (i = 0; i < _tbl.getColumnCount() && !resize; ++i) {
            if (!_tbl.getColumn(i).isVisible() || !_tbl.getColumn(i).isResizeToFitContent()) continue;
            tbl.positionCopy(_tbl);
            resize = true;
        }
        if (resize) {
            for (i = 0; i < tbl.getColumnCount(); ++i) {
                if (!tbl.getColumn(i).isResizeToFitContent()) continue;
                ReportCell cell = tbl.formatCell(tbl.getColumn(i), rowIndex, temp_report);
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject && _tbl.getBgColor() != null) {
                    ReportGraphics temp_rg = this.reportUI.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, tbl, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportTable.resizeVerticallyAndShift((ReportElement)tbl.getColumn(i), tbl, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = tbl.getMinHeight();
            if (tbl.getHeight() < minH) {
                double increase = (minH - tbl.getHeight()) / tbl.getHeight() + 1.0;
                if (tbl.isResizeToFitContent()) {
                    int i3;
                    for (i3 = 0; i3 < tbl.getColumnCount(); ++i3) {
                        double h1 = _tbl.getColumn(i3).getHeight() * increase;
                        double h2 = tbl.getColumn(i3).getHeight();
                        tbl.getColumn(i3).setHeight(h1 > h2 ? h1 : h2);
                    }
                    for (i3 = 0; i3 < tbl.getImageCount(); ++i3) {
                        ReportImage image = tbl.getImage(i3);
                        if (!(image instanceof ReportGrid) || !(((ReportGrid)image).getHeight() >= 0.0)) continue;
                        image.setHeight(image.getHeight() * increase);
                    }
                    minH = tbl.getMinHeight();
                }
                for (int i4 = 0; i4 < tbl.getImageCount(); ++i4) {
                    ReportImage image = tbl.getImage(i4);
                    if (!(image instanceof ReportLine) || !((ReportLine)image).isVertical() || ((ReportLine)image).next() == null) continue;
                    image.setHeight(image.getHeight() * increase + 0.01);
                }
                tbl.setHeight(minH);
            }
            return tbl;
        }
        for (i = 0; i < _tbl.getImageCount(); ++i) {
            if (!(_tbl.getImage(i) instanceof ReportLine) || ((ReportLine)_tbl.getImage(i)).next() == null || !((ReportLine)_tbl.getImage(i)).isVertical()) continue;
            _tbl.getImage(i).setHeight(_tbl.getHeight() - _tbl.getImage(i).getY());
        }
        return _tbl;
    }

    protected int[] getTreeLevel() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int[] values = new int[this.treeStructure.size()];
            for (int i = 0; i < this.treeStructure.size(); ++i) {
                values[i] = (Integer)this.treeStructure.elementAt(i);
            }
            return values;
        }
        return null;
    }

    protected String getTreeStringKey() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            String str = "Tree_";
            int size = this.treeStructure.size();
            for (int i = 0; i < size - 1; ++i) {
                str = str + (Integer)this.treeStructure.elementAt(i) + "_";
            }
            str = str + this.treeStructure.elementAt(size - 1);
            return str;
        }
        return null;
    }

    protected int getCurrentSectionID() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int lastID = this.treeStructure.size();
            return (Integer)this.treeStructure.elementAt(lastID - 1);
        }
        return 0;
    }

    protected void writeRepeatSection(ReportSection section) throws Exception {
        this.isWriteRepeatSection = true;
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                ReportSection drawingSection = (ReportSection)this.sectionList.elementAt(i);
                if (drawingSection == section) {
                    return;
                }
                for (int j = 0; j < drawingSection.getSectionCount(); ++j) {
                    if (drawingSection.getSection(j) != section) continue;
                    return;
                }
                this.writeSection(drawingSection, (ReportTable)this.tableList.elementAt(i), true);
            }
        }
        this.isWriteRepeatSection = false;
    }

    protected void addRepeatSection(ReportSection section, ReportTable tbl) {
        this.sectionList.addElement(section);
        this.tableList.addElement(tbl);
    }

    protected void removeRepeatSection() {
        this.sectionList.removeElementAt(this.sectionList.size() - 1);
        this.tableList.removeElementAt(this.tableList.size() - 1);
    }

    protected boolean skipCell(ReportElement cell) {
        if (cell instanceof ColumnWrap) {
            return true;
        }
        if (!this.doColumnWrap) {
            return false;
        }
        return RTFReport.toTwips(cell.getX() + cell.getWidth()) > this.columnWrapWidth;
    }

    protected void pageBreak(ReportSection section) throws Exception {
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            if (this.columnWrapCount <= 0 || this.wrapInfo[0] >= this.columnWrapCount || this.elementYPos == this.wrapInfo[1]) {
                this.pageBreak2(section);
                this.wrapInfo[0] = 0;
                this.wrapInfo[1] = this.elementYPos;
            } else {
                this.wrapInfo[2] = this.elementYPos;
                this.elementYPos = this.wrapInfo[1];
                this.wrapInfo[0] = this.wrapInfo[0] + 1;
                this.rowCount = 0;
            }
        } else {
            this.pageBreak2(section);
        }
    }

    protected void pageBreak2(ReportSection section) throws Exception {
        this.elementXPos = 0;
        this.elementYPos = this.pageHeight;
        this.writePageSections(false);
        this.writeWaterMark();
        this.addAllTemplates();
        if (!this.checkFitGroupOnPage && this.pagebreaks == 0 || !this.checkFitGroupOnPage && this.pagebreaks > 0 && this.totalSections == 1) {
            this.templates[0].write("\\pagebb\n".getBytes());
        }
        ++this.currentPageNumber;
        ++this.pageCt;
        this.rowCount = 0;
        LOGGER.finest("Current page number: " + this.currentPageNumber);
        if (this.checkFitGroupOnPage) {
            ++this.pagebreaks;
        }
        if (section != null && section.isResetPageNumber()) {
            this.currentPageNumber = 1;
            this.savedStartPage = this.pageCt;
        }
        this.resetAllTemplates();
        this.elementXPos = 0;
        this.elementYPos = 0;
        this.writePageSections(true);
        this.writeRepeatSection(section);
    }

    protected void pageBreak(int requireHeight, ReportSection section) throws Exception {
        int availableHeight = this.pageHeight - this.elementYPos;
        if (availableHeight >= requireHeight) {
            return;
        }
        this.pageBreak(section);
    }

    protected void pageBreak(int requiredHeight, int rowIndex) throws Exception {
        int remain = this.pageHeight - this.elementYPos;
        if (remain >= requiredHeight) {
            return;
        }
        if (this.wrapInfo[0] >= this.columnWrapCount || this.elementYPos == this.wrapInfo[1]) {
            this.pageBreak(null);
            this.wrapInfo[0] = 0;
            this.wrapInfo[1] = this.elementYPos;
            this.wrapInfo[2] = this.elementYPos;
            this.columnWrapInitialRow = this.columnWrapDisplayRow + this.columnWrapInitialRow;
            this.columnWrapDisplayRow = 0;
            return;
        }
        this.wrapInfo[2] = this.elementYPos;
        this.elementYPos = this.wrapInfo[1];
        if (this.columnWrapDisplayRow == 0) {
            this.columnWrapDisplayRow = rowIndex - this.columnWrapInitialRow * (this.columnWrapCount + 1);
        }
        this.wrapInfo[0] = this.wrapInfo[0] + 1;
        this.rowCount = 0;
    }

    protected int writeSection(ReportSection orgSection, ReportTable tbl) throws Exception {
        return this.writeSection(orgSection, tbl, true);
    }

    protected int writeSection(ReportSection section, ReportTable tbl, boolean checkPageBreak) throws Exception {
        if (!this.titleAdjusted) {
            this.titleAdjusted = this.reportUI.adjustReportTitle(this.reportUI.getReportGraphics(), this.report.getReportHeader());
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report, section);
        }
        int height = this.writeSectionHelper(section, tbl, checkPageBreak);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            ReportSection child = section.getSection(i);
            child.setRepeatOnEveryPage(section.isRepeatOnEveryPage());
            this.writeSection(child, tbl, checkPageBreak);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
        return height;
    }

    protected boolean isFirstValue() {
        int[] intArray;
        for (int element : intArray = QbUtil.convertVectorToIntArray(this.treeStructure)) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    private boolean printOnNewPage(ReportSection section) {
        return section.isResetPageNumber() ? !(section.isPrintOnNewPage() && section.isSkipFirstValue() && this.isFirstValue() || section.isPrintOnNewPage() && section.isSkipFirstGroupValue() && this.getCurrentSectionID() == 0) : !(!section.isPrintOnNewPage() || section.isSkipFirstValue() && this.isFirstValue() || section.isSkipFirstGroupValue() && this.getCurrentSectionID() == 0);
    }

    protected int writeSectionHelper(ReportSection orgSection, ReportTable tbl, boolean checkPageBreak) throws Exception {
        if (orgSection == null || !orgSection.isVisible()) {
            return 0;
        }
        if (orgSection.isResetPageNumber()) {
            this.resetPageNumber = true;
            this.treeCopy = this.getTreeStringKey();
            if (this.sectionTotalPagesTable == null) {
                this.sectionTotalPagesTable = new Hashtable();
            }
            if (this.sectionTotalPages == null) {
                this.sectionTotalPages = new Vector();
            }
            if (this.sectionStartPage == null) {
                this.sectionStartPage = new Vector();
            }
        }
        if (this.hasNoData(orgSection)) {
            return 0;
        }
        boolean doColumnWrap_BAK = this.doColumnWrap;
        int totalDrawCol = this.columnWrapCount;
        boolean repeatTableHeader = false;
        if (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter() || orgSection == this.report.getReportHeader() || orgSection == this.report.getReportFooter() || orgSection.getID().startsWith("RPT_HDR") || orgSection.getID().startsWith("RPT_FTR")) {
            this.doColumnWrap = false;
            totalDrawCol = 0;
        } else if (orgSection.getID().equals("TBL0_HDR")) {
            repeatTableHeader = true;
            if (!this.checkTotalPageNumber && this.totalPageNumber == this.currentPageNumber) {
                totalDrawCol = this.lastDrawCol;
            }
        } else {
            totalDrawCol = 0;
        }
        if (!this.isWriteRepeatSection && this.printOnNewPage(orgSection)) {
            this.pageBreak(orgSection);
        }
        ReportSection cellArray = this.resizeSection(this.reportGraphics, orgSection, tbl);
        if (checkPageBreak) {
            this.pageBreak(RTFReport.toTwips(cellArray.getHeight()), orgSection);
        }
        this.writeSectionBgColor(cellArray);
        if (orgSection == cellArray) {
            cellArray = ReportUI.copySectionForSecuredInvisibleCols(cellArray, tbl, this.report.getPreviewSecurityLevel());
        }
        ReportElement[] cells = cellArray.sortCell(1, true);
        cells = (ReportCell[])ReportUI.takeAwaySecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel(), this.report.getReportType());
        if (this instanceof RTFSubReport) {
            this.reportUI.setCurX(RTFReport.toInch(this.elementXPos + ((RTFSubReport)this).offsetX));
        } else {
            this.reportUI.setCurX(RTFReport.toInch(this.elementXPos));
        }
        double[] temp = null;
        double[] tempRowShifts = null;
        if (this.report.isCrossTabFixedField()) {
            double oldX = this.reportUI.curX;
            cells = this.reportUI.splitCells(cells);
            cells = (ReportCell[])ReportElement.sortElement(cells, 1, true);
            Object[] objs = this.reportUI.calculateRowShifts(cells, tbl);
            this.reportUI.setCurX(oldX);
            cells = (ReportCell[])objs[0];
            tempRowShifts = (double[])objs[1];
            temp = this.reportUI.calculateShifts(cells, tbl);
        } else {
            tempRowShifts = temp = this.reportUI.calculateShifts(cells, tbl);
        }
        int[] shifts = new int[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            shifts[i] = RTFReport.toTwips(temp[i]);
        }
        int[] rowShifts = new int[tempRowShifts.length];
        for (int i = 0; i < tempRowShifts.length; ++i) {
            rowShifts[i] = RTFReport.toTwips(tempRowShifts[i]);
        }
        if (!(this instanceof RTFSubReport)) {
            this.writeSectionBgColor(cellArray);
        } else {
            ((RTFSubReport)this).shift = 0;
            for (int shift : shifts) {
                ((RTFSubReport)this).shift += shift;
            }
            this.writeSectionBgColor(cellArray);
            ((RTFSubReport)this).shift = 0;
        }
        int bottomY = this.elementYPos + RTFReport.toTwips(cellArray.getHeight());
        Vector<RTFSubReport> subReports = new Vector<RTFSubReport>();
        for (int curArea = 0; curArea <= totalDrawCol; ++curArea) {
            int i;
            int delta = 0;
            if (repeatTableHeader) {
                delta = curArea * this.columnWrapWidth;
            } else if (this.doColumnWrap && this.wrapInfo != null) {
                delta = this.wrapInfo[0] * this.columnWrapWidth;
            }
            for (i = 0; i < cells.length; ++i) {
                if (cells[i] instanceof TableOfContents) continue;
                this.elementXPos = 0;
                for (int l = 0; l < i; ++l) {
                    if (!this.reportUI.isWithIn(cells[i], cells[l])) continue;
                    this.incElementXPos(rowShifts[l]);
                }
                if (cells[i] instanceof SubReportObject) {
                    cells[i].setDrawX(RTFReport.toTwips(cells[i].getX()) + this.elementXPos);
                    this.incElementXPos(rowShifts[i]);
                    continue;
                }
                this.incElementXPos(rowShifts[i]);
                cells[i].setDrawX(RTFReport.toTwips(cells[i].getX()) + this.elementXPos);
            }
            cells = (ReportCell[])ReportElement.sortElement(cells, 2, true);
            for (i = 0; i < cells.length; ++i) {
                ReportCell cell;
                this.elementXPos = delta + (int)cells[i].getDrawX() - RTFReport.toTwips(cells[i].getX());
                if (this.skipCell(cells[i]) || (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) && RTFReport.toTwips(cells[i].getX() + cells[i].getWidth()) > this.pageWidth) continue;
                if (cells[i] instanceof ReportLine || cells[i] instanceof ReportGrid) {
                    if (cells[i] instanceof ReportLine && !((ReportLine)cells[i]).isVertical() && ((ReportLine)cells[i]).isMatchColumnWidths()) {
                        ((ReportLine)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                    }
                    if (cells[i] instanceof ReportGrid && ((ReportGrid)cells[i]).isMatchColumnWidths()) {
                        ((ReportGrid)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                    }
                    this.writeTableDataElement(tbl.formatCell((ReportCell)cells[i], this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report), tbl, cellArray);
                    continue;
                }
                if (cells[i] instanceof TableOfContents || (cell = tbl.formatCell((ReportCell)cells[i], this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report)) == null || !cell.isVisible()) continue;
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject) {
                    if (cellArray.isRepeatOnEveryPage() || orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) {
                        cell.setResizeToFitContent(false);
                    }
                    if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && !cell.isResizeToFitContent()) continue;
                    RTFSubReport rtfSub = null;
                    if (cell instanceof SubReportObject) {
                        rtfSub = this.writeSubReport((SubReportObject)cell, tbl, cellArray);
                    } else if (cell instanceof ReportRTFObject) {
                        rtfSub = this.writeRTFObject((ReportRTFObject)cell, tbl, cellArray);
                    }
                    if (rtfSub != null && rtfSub.isFinished()) {
                        if (rtfSub.elementYPos <= bottomY || !cell.isResizeToFitContent()) continue;
                        bottomY = rtfSub.elementYPos;
                        if (!(cell instanceof ReportRTFObject)) continue;
                        cellArray.setHeight(rtfSub.elementYPos);
                        continue;
                    }
                    if (rtfSub == null) continue;
                    subReports.insertElementAt(rtfSub, 0);
                    continue;
                }
                if (this.checkTotalPageNumber || this.checkFitGroupOnPage) continue;
                this.writeTableDataElement(cell, tbl, cellArray);
            }
        }
        this.doColumnWrap = doColumnWrap_BAK;
        if (subReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(subReports, orgSection);
        } else {
            this.elementYPos += RTFReport.toTwips(cellArray.getHeight());
            if (bottomY > this.elementYPos) {
                this.elementYPos = bottomY;
            }
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            this.curMaxY = bottomY < this.wrapInfo[2] ? this.wrapInfo[2] : bottomY;
            if (repeatTableHeader) {
                this.wrapInfo[1] = this.elementYPos;
            }
        }
        this.elementXPos = 0;
        return RTFReport.toTwips(cellArray.getHeight());
    }

    protected void writeReportTable(ReportTable tbl) throws Exception {
        this.writeReportTable(tbl, 0);
    }

    protected void writeReportTable(ReportTable tbl, int level) throws Exception {
        this.writeSection(tbl.getHeader(), tbl);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        if (this.treeStructure == null) {
            this.treeStructure = new Vector();
        }
        if (tbl instanceof ReportTreeTable) {
            ReportTreeTable sTbl = (ReportTreeTable)tbl;
            for (int i = 0; i < sTbl.countSubTable(); ++i) {
                int idx;
                this.treeStructure.addElement(i);
                int n = idx = sTbl.indexArray == null ? i : sTbl.indexArray[i];
                if (!(this.checkFitGroupOnPage || this.report.breakColIndex == null || this.report.breakColIndex.length <= level || this.report.colInfo[this.report.breakColIndex[level]].skipFirstValueForFitGroup() && i <= 0 || !this.report.colInfo[this.report.breakColIndex[level]].isFitGroupOnPage())) {
                    this.pagebreaks = 0;
                    int x = this.elementXPos;
                    int y = this.elementYPos;
                    this.checkFitGroupOnPage = true;
                    try {
                        if (!sTbl.getSubTable(idx).isAggregationTable()) {
                            this.writeReportTable(sTbl.getSubTable(idx), level + 1);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Failed to write report table", e);
                    }
                    this.checkFitGroupOnPage = false;
                    this.elementXPos = x;
                    this.elementYPos = y;
                    if (this.pagebreaks > 0) {
                        this.currentPageNumber -= this.pagebreaks;
                        this.pageCt -= this.pagebreaks;
                        this.pageBreak(null);
                        this.pagebreaks = 0;
                    }
                }
                if (sTbl.getSubTable(idx).isAggregationTable()) continue;
                this.writeReportTable(sTbl.getSubTable(idx), level + 1);
            }
        } else {
            this.writeCells(tbl);
        }
        this.writeSection(tbl.getFooter(), tbl);
        this.addSectionTotalPagesTableEntry();
        if (this.treeStructure.size() > 1) {
            this.treeStructure.removeElementAt(this.treeStructure.size() - 1);
        } else {
            this.treeStructure.removeAllElements();
        }
        this.addSectionTotalPagesTableEntry();
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    protected void addSectionTotalPagesTableEntry() {
        if (this.sectionTotalPagesTable != null && this.getTreeStringKey() != null && this.treeCopy.equals(this.getTreeStringKey()) && this.populateTable) {
            if (this.sectionTotalPagesTable.containsKey(this.getTreeStringKey())) {
                this.sectionTotalPages.removeElementAt(this.sectionTotalPages.size() - 1);
                this.sectionStartPage.removeElementAt(this.sectionStartPage.size() - 1);
            }
            this.sectionTotalPagesTable.put(this.getTreeStringKey(), this.currentPageNumber);
            this.sectionTotalPages.addElement(this.currentPageNumber);
            this.sectionStartPage.addElement(this.savedStartPage);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeCells(ReportTable tbl) throws Exception {
        int delta;
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        if (tbl.getScriptObj() != null) {
            bgColor = tbl.getBgColor();
            printOnNewPage = tbl.isPrintOnNewPage();
            visible = tbl.isVisible();
            tbl.getScriptObj().applyScript(tbl, 1, 1, 1, 1, this.report, tbl);
        }
        if (!tbl.isVisible()) {
            return;
        }
        int nRow = tbl.getRowCount();
        ReportImage[] chart = tbl.getSortedImages();
        SubReportObject[] subReports = tbl.getSortedSubReports();
        ReportRTFObject[] rtfObjects = tbl.getSortedRTFObjects();
        Vector remainingSubReports = new Vector();
        this.background_templates = new ByteArrayOutputStream[this.templates.length];
        this.background_offset = new int[this.templates.length];
        for (int i = 0; i < this.templates.length; ++i) {
            this.background_templates[i] = new ByteArrayOutputStream();
            this.background_offset[i] = this.templates[i].size();
        }
        ReportElement[] relts = tbl.getXSortedVisibleElements();
        if (this instanceof RTFSubReport) {
            this.reportUI.setCurX(RTFReport.toInch(this.elementXPos + ((RTFSubReport)this).offsetX));
        } else {
            this.reportUI.setCurX(RTFReport.toInch(this.elementXPos));
        }
        double[] temp = null;
        double[] tempRowShifts = null;
        if (this.report.isCrossTabFixedField()) {
            double oldX = this.reportUI.curX;
            Object[] objs = this.reportUI.calculateRowShiftsForColumns(relts, tbl);
            this.reportUI.setCurX(oldX);
            relts = (ReportElement[])objs[0];
            tempRowShifts = (double[])objs[1];
            temp = this.reportUI.calculateShifts(relts, tbl);
        } else {
            tempRowShifts = temp = this.reportUI.calculateShifts(relts, tbl);
        }
        int[] shifts = new int[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            shifts[i] = RTFReport.toTwips(temp[i]);
        }
        int[] rowShifts = new int[tempRowShifts.length];
        for (int i = 0; i < tempRowShifts.length; ++i) {
            rowShifts[i] = RTFReport.toTwips(tempRowShifts[i]);
        }
        Vector<ReportCell> oneTime = new Vector<ReportCell>();
        Vector<Integer> oneTimeY = new Vector<Integer>();
        for (int i = 0; i < chart.length; ++i) {
            if (chart[i] instanceof ReportLine || chart[i] instanceof ReportGrid || this.skipCell(chart[i])) continue;
            oneTime.insertElementAt(chart[i], 0);
            oneTimeY.insertElementAt(RTFReport.toTwips(chart[i].getY()), 0);
        }
        for (SubReportObject subReportObject : subReports) {
            oneTime.insertElementAt(subReportObject, 0);
            oneTimeY.insertElementAt(RTFReport.toTwips(subReportObject.getY()), 0);
        }
        for (ReportCell reportCell : rtfObjects) {
            oneTime.insertElementAt(reportCell, 0);
            oneTimeY.insertElementAt(RTFReport.toTwips(reportCell.getY()), 0);
        }
        int bottomYOfSection = 0;
        ReportSection mSection = tbl.getMasterSection();
        int wrapIndex = 0;
        if (this.wrapInfo != null) {
            wrapIndex = this.wrapInfo[0];
        }
        if (this.checkTotalPageNumber) {
            this.lastDrawCol = wrapIndex;
        }
        this.resetColumnWrapTableUI();
        ReportTable reportTable = tbl;
        this.rows = reportTable.getFormattedRows();
        double[] backupX = ReportUI.backupXPos(relts);
        relts = ReportUI.takeAwaySecuredInvisibleCols(relts, this.report.getPreviewSecurityLevel(), this.report.getReportType());
        this.elementXPos = delta = wrapIndex * this.columnWrapWidth;
        for (int j = 0; j < relts.length; ++j) {
            this.elementXPos = 0;
            for (int l = 0; l <= j; ++l) {
                if (!(relts[l].getY() <= relts[j].getY() && relts[l].getY() + relts[l].getHeight() > relts[j].getY()) && (!(relts[l].getY() >= relts[j].getY()) || !(relts[l].getY() < relts[j].getY() + relts[j].getHeight()))) continue;
                this.incElementXPos(rowShifts[l]);
            }
            relts[j].setDrawX(RTFReport.toTwips(relts[j].getX()) + this.elementXPos);
        }
        ReportUI.recoverXPos(relts, backupX);
        for (int i = 0; i < nRow; ++i) {
            int ii = i;
            boolean hasVisibleColumn = false;
            if (tbl.indexArray != null) {
                ii = tbl.indexArray[i];
            }
            this.elementXPos = delta;
            tbl = this.resizeTable(this.reportGraphics, reportTable, ii);
            chart = tbl.getSortedImages();
            if (this.rowElements == null && !tbl.hasVisibleElements() && (i > 0 || oneTime.size() == 0)) continue;
            ReportElement[] col = tbl.getSortedVisibleColumns();
            int tblH = RTFReport.toTwips(tbl.getHeight());
            if (!this.hasNoData(mSection) && i == 0) {
                tblH = RTFReport.toTwips((mSection = this.resizeSection(this.reportGraphics, mSection, tbl)).getHeight() + mSection.getY()) > tblH ? RTFReport.toTwips(mSection.getHeight() + mSection.getY()) : tblH;
            }
            int oldpageN = this.currentPageNumber;
            if (tbl.isPrintOnNewPage(this.rowCount)) {
                this.pageBreak(null);
            } else {
                this.pageBreak(tblH, ii);
            }
            ++this.rowCount;
            if (this.currentPageNumber > oldpageN || i == 0) {
                bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, relts, rowShifts);
            }
            if (!this.hasNoData(mSection) && i == 0) {
                this.elementXPos = 0;
                this.sectionBreak(RTFReport.toTwips(mSection.getX()), RTFReport.toTwips(mSection.getWidth()));
                this.writeMasterSection(mSection, tbl);
                if (bottomYOfSection < this.elementYPos + RTFReport.toTwips(mSection.getY()) + RTFReport.toTwips(mSection.getHeight())) {
                    bottomYOfSection = this.elementYPos + RTFReport.toTwips(mSection.getY()) + RTFReport.toTwips(mSection.getHeight());
                }
            }
            if (this.wrapInfo != null) {
                wrapIndex = this.wrapInfo[0];
            }
            this.elementXPos = delta = wrapIndex * this.columnWrapWidth;
            if (delta == 0) {
                if (!(this instanceof RTFSubReport)) {
                    this.writeSectionBgColor(tbl);
                } else {
                    ((RTFSubReport)this).shift = 0;
                    for (int shift : shifts) {
                        ((RTFSubReport)this).shift += shift;
                    }
                    this.writeSectionBgColor(tbl);
                    ((RTFSubReport)this).shift = 0;
                }
            }
            if (tbl == reportTable) {
                tbl = ReportUI.copySectionForSecuredInvisibleCols(tbl, this.report.getPreviewSecurityLevel());
            }
            col = tbl.getSortedVisibleColumns();
            col = (ReportColumn[])ReportUI.takeAwaySecuredInvisibleCols(col, this.report.getPreviewSecurityLevel(), this.report.getReportType());
            for (ReportElement relt : relts = tbl.getZSortedVisibleElements()) {
                ReportColumn rc;
                ReportImage img;
                if (relt instanceof ReportImage && !this.skipCell(img = (ReportImage)relt) && (img instanceof ReportLine || img instanceof ReportGrid)) {
                    ReportImage newImg = (ReportImage)tbl.formatCell(img, ii, this.getCurrentPageNumber(), 1, this.getTotalPageNumber(), 1, this.report, false);
                    this.elementXPos = delta + (int)newImg.getDrawX() - RTFReport.toTwips(newImg.getX());
                    if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
                        this.writeTableDataElement(newImg, tbl, tbl);
                    }
                }
                if (!(relt instanceof ReportColumn) || this.skipCell(rc = (ReportColumn)relt)) continue;
                ReportCell cell = tbl.formatCell(rc, ii, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, i - this.columnWrapDisplayRow * wrapIndex - this.columnWrapCount * this.columnWrapInitialRow, this.report);
                if (cell.isVisible()) {
                    hasVisibleColumn = true;
                }
                this.elementXPos = delta + (int)rc.getDrawX() - RTFReport.toTwips(rc.getX());
                if (this.checkTotalPageNumber || this.checkFitGroupOnPage) continue;
                this.writeTableDataElement(cell, tbl, tbl);
            }
            if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage && this.rowElements != null) {
                void var29_43;
                boolean bl = false;
                while (var29_43 < this.rowElements.size()) {
                    ReportCell elt = (ReportCell)this.rowElements.elementAt((int)var29_43);
                    this.writeTableDataElement(elt, tbl, tbl);
                    ++var29_43;
                }
            }
            if ((!tbl.hasVisibleElements() || !hasVisibleColumn) && this.rowElements == null) continue;
            this.elementYPos += RTFReport.toTwips(tbl.getHeight());
        }
        this.insertBackgroundTemplates();
        this.background_templates = null;
        this.background_offset = null;
        if (remainingSubReports.size() > 0 || oneTime.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(remainingSubReports, oneTime, oneTimeY, null, tbl, relts, rowShifts);
        } else if (this.elementYPos < bottomYOfSection) {
            this.elementYPos = bottomYOfSection;
        }
        if (this.doColumnWrap) {
            this.curMaxY = this.wrapInfo != null && this.elementYPos < this.wrapInfo[2] ? this.wrapInfo[2] : this.elementYPos;
        }
        this.elementXPos = 0;
        if (tbl.getScriptObj() != null) {
            tbl.setBgColor(bgColor);
            tbl.setPrintOnNewPage(printOnNewPage);
            tbl.setVisible(visible);
        }
    }

    protected void sectionBreak(int x, int requiredWidth) {
        if (Math.ceil((double)(x + this.elementXPos + requiredWidth) / (double)this.pageWidth) != Math.ceil((double)(x + this.elementXPos) / (double)this.pageWidth) && (x + this.elementXPos) % this.pageWidth != 0) {
            this.elementXPos = this.elementXPos + this.pageWidth - (x + this.elementXPos) % this.pageWidth;
        }
    }

    protected int getX(ReportElement elt) {
        return RTFReport.toTwips(elt.getX()) + this.elementXPos;
    }

    protected int getY(ReportElement elt) {
        return this.elementYPos + RTFReport.toTwips(elt.getY());
    }

    protected int getAbsoluteX(int pageX, int contentByteIndex) {
        if (contentByteIndex < 0 || contentByteIndex >= this.templates.length) {
            return pageX % this.pageWidth + this.leftMargin;
        }
        return pageX - this.pageWidth * contentByteIndex + this.leftMargin;
    }

    protected int getAbsoluteY(int pageY) {
        return pageY + this.topMargin;
    }

    protected int getTemplateIndex(int x) {
        int index = (int)Math.floor(x / this.pageWidth);
        if (index > 0 && index < this.templates.length) {
            return index;
        }
        return 0;
    }

    protected boolean isVisible(ReportElement elt) {
        return true;
    }

    protected void writeTableDataElement(ReportElement elt, ReportTable table, ReportTableElement panel) throws Exception {
        if (this.checkTotalPageNumber || this.checkFitGroupOnPage) {
            return;
        }
        if (!this.isVisible(elt) || !elt.isVisible()) {
            return;
        }
        if (elt instanceof ReportChartObject) {
            ReportCell[] cells = null;
            if (panel instanceof ReportSection) {
                cells = ((ReportSection)panel).getData();
            }
            this.writeReportChart((ReportChartObject)elt, table, cells);
        } else if (elt instanceof ReportLine) {
            this.writeReportLine((ReportLine)elt, panel);
        } else if (elt instanceof ReportGrid) {
            this.writeReportGrid((ReportGrid)elt, panel);
        } else if (elt instanceof ReportImage && !(elt instanceof ReportLine) && !(elt instanceof ReportGrid)) {
            this.writeReportImage((ReportImage)elt);
        } else {
            this.writeText(elt);
        }
    }

    private void writeReportChart(ReportChartObject chart, ReportTable table, ReportCell[] cells) {
        try {
            Report temp_report = this.report;
            byte[][] barray = ChartObject.export(10, temp_report, table, cells, chart, QbUtil.toPixel(chart.getWidth()), QbUtil.toPixel(chart.getHeight()), null, "");
            int w = RTFReport.toTwips(chart.getWidth());
            int h = RTFReport.toTwips(chart.getHeight());
            int x = this.getX(chart);
            int templateIndex = this.getTemplateIndex(x);
            x = this.getAbsoluteX(x, templateIndex);
            int y = this.getAbsoluteY(this.getY(chart));
            StringBuffer border = new StringBuffer(200);
            if (chart.getBorderThickness() > 0 && chart.getBorderColor() != null) {
                int b = chart.getBorderThickness() * 20;
                if (b > 75) {
                    b = 75;
                }
                border.append("\\box\\brdrs\\brdrw").append(b).append("\\brdrcf").append(this.getColorIndex(chart.getBorderColor()));
                x -= b;
                y -= b;
                w += b * 2;
                h += b * 2;
            }
            ByteArrayOutputStream writer = this.templates[templateIndex];
            writer.write(new StringBuffer(200).append("\\absw").append(w).append("\\absh").append(h).append("\\phpg\\posx").append(x).append("\\pvpg\\posy").append(y).append("\\f0\\fs2").append(" {\\pict").append(border.toString()).append("\\pngblip\\bin").append(barray[0].length).append(" ").toString().getBytes());
            writer.write(barray[0]);
            writer.write("}\\par\\pard\n".getBytes());
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.indexOf("Please include ExportLib.jar in your classpath") != -1) {
                LOGGER.log(Level.WARNING, "Please include ExportLib.jar in your classpath", e);
            }
            LOGGER.log(Level.FINE, "Failed to write chart", e);
        }
    }

    private void writeReportImage(ReportImage elt) {
        int x = this.getX(elt);
        int templateIndex = this.getTemplateIndex(x);
        x = this.getAbsoluteX(x, templateIndex);
        int y = this.getAbsoluteY(this.getY(elt));
        this.writeReportImageHelper(elt, x, y, this.templates[templateIndex]);
    }

    private void writeReportImageHelper(ReportImage elt, int x, int y, ByteArrayOutputStream writer) {
        try {
            byte[] barray = null;
            try {
                String ifilename = elt.isDBImage() ? elt.getRelativePath() : (elt.getImageURL().toString().startsWith("file:") ? elt.getImageURL().getFile() : elt.getImageURL().toString());
                if (ifilename != null) {
                    ifilename = QbUtil.fixUrlString(ifilename);
                }
                ReadDataFile rdf = new ReadDataFile();
                DataInputStream dis = rdf.getInputStream(null, ifilename);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                boolean notEOF = true;
                while (notEOF) {
                    try {
                        bout.write(dis.readByte());
                    }
                    catch (EOFException e) {
                        LOGGER.log(Level.FINEST, "Cannot read", e);
                        notEOF = false;
                    }
                }
                barray = bout.toByteArray();
                bout.close();
                dis.close();
            }
            catch (Exception ex) {
                if (elt.getBytes() != null) {
                    barray = elt.getBytes();
                }
                LOGGER.log(Level.FINE, "RTF Export: Image file not found", ex);
            }
            Image image = Toolkit.getDefaultToolkit().createImage(barray);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (!IOUtil.isJimiIncluded()) {
                throw new Exception("Please include ExportLib.jar in your classpath.");
            }
            PNGJimiEncoder.createPNGImage(image, bout, 0);
            bout.close();
            barray = bout.toByteArray();
            int heightRatio = 100;
            int widthRatio = 100;
            try {
                MediaTracker tracker = new MediaTracker(ServerMessage.getComponent());
                tracker.addImage(image, 0);
                tracker.waitForID(0);
                if (tracker.isErrorID(0)) {
                    throw new Exception("Failed to retrieve default size for image.");
                }
                widthRatio = (int)Math.rint((double)elt.getWidthOfElement() / (double)image.getWidth(null) * 100.0);
                heightRatio = (int)Math.rint((double)elt.getHeightOfElement() / (double)image.getHeight(null) * 100.0);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to set image", ex);
            }
            int w = RTFReport.toTwips(elt.getWidth());
            int h = RTFReport.toTwips(elt.getHeight());
            StringBuffer border = new StringBuffer(200);
            if (elt.getBorderThickness() > 0 && elt.getBorderColor() != null) {
                int b = elt.getBorderThickness() * 20;
                if (b > 75) {
                    b = 75;
                }
                border.append("\\box\\brdrs\\brdrw").append(b).append("\\brdrcf").append(this.getColorIndex(elt.getBorderColor()));
                x -= b;
                y -= b;
                w += b * 2;
                h += b * 2;
            }
            writer.write(new StringBuffer(200).append("\\absw").append(w).append("\\absh").append(h).append("\\phpg\\posx").append(x).append("\\pvpg\\posy").append(y).append("\\f0\\fs2").append(" {\\pict").append(border.toString()).append("\\pngblip\\picscalex").append(widthRatio).append("\\picscaley").append(heightRatio).append("\\bin").append(barray.length).append(" ").toString().getBytes());
            writer.write(barray);
            writer.write("}\\par\\pard ".getBytes());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to write report image", ex);
        }
    }

    private void writeReportLine(ReportLine line, ReportTableElement panel) throws Exception {
        if (line instanceof ColumnWrap || line.getBgColor() == null) {
            return;
        }
        if (RTFReport.toTwips(line.getX() + line.getWidth()) > this.pageWidth) {
            return;
        }
        int w = RTFReport.toTwips(line.getWidth());
        int h = RTFReport.toTwips(line.getHeight());
        int border = 0;
        String orientation = "\\brdrt";
        String thicknessFactor = "";
        String lineStyle = "\\brdrs";
        int x = this.getX(line);
        int templateIndex = this.getTemplateIndex(x);
        x = this.getAbsoluteX(x, templateIndex);
        int y = this.getAbsoluteY(this.getY(line));
        if (line.isVertical()) {
            if (line.getHeight() < 0.0) {
                h = RTFReport.toTwips(panel.getHeight());
                if (line.getHeadNode() == line) {
                    h = RTFReport.toTwips(panel.getHeight() - line.getY());
                }
            }
            orientation = "\\brdrl";
            border = RTFReport.toTwips(line.getWidth() - 0.02);
            if (border > 75) {
                border = 75;
            }
            w = border * 2 + 20;
            x = x + border + 25;
        } else {
            border = RTFReport.toTwips(line.getHeight() - 0.02);
            if (border > 75) {
                border = 75;
            }
            h = border * 2 + 20;
        }
        if (line.getLineStyle() == 2) {
            lineStyle = "\\brdrdb";
        } else if (line.getLineStyle() == 3) {
            lineStyle = "\\brdrdash";
        }
        ByteArrayOutputStream writer = this.templates[templateIndex];
        writer.write(new StringBuffer(200).append("\\absw").append(w).append("\\absh").append(h).append("\\phpg\\posx").append(x).append("\\pvpg\\posy").append(y).append(orientation).append(lineStyle).append(thicknessFactor).append("\\brdrw").append(border).append("\\brdrcf").append(this.getColorIndex(line.getBgColor())).append("\\f0\\fs2\\par\\pard\n").toString().getBytes());
    }

    private void writeReportGrid(ReportGrid grid, ReportTableElement panel) throws Exception {
        if (grid.getBorderColor() == null || grid.getBorderThickness() <= 0) {
            return;
        }
        int w = RTFReport.toTwips(grid.getWidth());
        int h = RTFReport.toTwips(grid.getHeight());
        int border = 0;
        String lineStyle = "\\brdrs";
        int x = this.getX(grid);
        int templateIndex = this.getTemplateIndex(x);
        x = this.getAbsoluteX(x, templateIndex);
        int y = this.getAbsoluteY(this.getY(grid));
        if (grid.getHeight() < 0.0) {
            h = RTFReport.toTwips(panel.getHeight());
            if (grid.getHeadNode() == grid) {
                h = RTFReport.toTwips(panel.getHeight() - grid.getY());
            }
        }
        if ((border = grid.getBorderThickness() * 20) > 75) {
            border = 75;
        }
        x += 25;
        y -= border;
        w -= 50;
        h += border * 2;
        if (grid.getGridStyle() == 2) {
            lineStyle = "\\brdrdb";
            y -= border * 2;
            h += border * 4;
        } else if (grid.getGridStyle() == 3) {
            lineStyle = "\\brdrdash";
        }
        ByteArrayOutputStream writer = this.templates[templateIndex];
        writer.write(new StringBuffer(200).append("\\absw").append(w).append("\\absh").append(h).append("\\phpg\\posx").append(x).append("\\pvpg\\posy").append(y).append("\\box").append(lineStyle).append("\\brdrw").append(border).append("\\brdrcf").append(this.getColorIndex(grid.getBorderColor())).append("\\f0\\fs2\\par\\pard\n").toString().getBytes());
    }

    protected void writeWaterMark() throws Exception {
        if (ServerMessage.isEvalVersion()) {
            int bottomY = RTFReport.toTwips(this.report.getPageHeight()) - this.bottomMargin - 400;
            if (bottomY < 0) {
                bottomY = 0;
            }
            int random1 = (int)Math.floor(Math.random() * (double)(this.DEFAULT_COLORS.length - 2)) + 1 + this.colorTbl.length;
            int random2 = (int)Math.floor(Math.random() * (double)(this.DEFAULT_COLORS.length - 2)) + 1 + this.colorTbl.length;
            for (ByteArrayOutputStream template : this.templates) {
                template.write(new StringBuffer(200).append("\\absw").append(this.pageWidth).append("\\absh400\\phpg\\posx").append(this.leftMargin).append("\\pvpg\\posy").append(this.topMargin).append("\\qc\\f1\\fs24\\cf").append(random1).append(" ").append(evalText).append("\\par\\pard\n").toString().getBytes());
                template.write(new StringBuffer(200).append("\\absw").append(this.pageWidth).append("\\absh400\\phpg\\posx").append(this.leftMargin).append("\\pvpg\\posy").append(bottomY).append("\\qc\\f1\\fs24\\cf").append(random2).append(" ").append(contactText).append("\\par\\pard\n").toString().getBytes());
            }
        }
    }

    private void writeText(ReportElement elt) throws Exception {
        String background = "";
        String border = "";
        if (elt.getBgColor() != null) {
            background = "\\shading10000\\cfpat" + this.getColorIndex(elt.getBgColor());
        }
        int topBorder = 0;
        int rightBorder = 0;
        int bottomBorder = 0;
        int leftBorder = 0;
        if (elt.hasBorder() && elt.getBorderColor() != null) {
            topBorder = this.computeTrueBorderThickness(elt, BorderSide.TOP);
            rightBorder = this.computeTrueBorderThickness(elt, BorderSide.RIGHT);
            bottomBorder = this.computeTrueBorderThickness(elt, BorderSide.BOTTOM);
            leftBorder = this.computeTrueBorderThickness(elt, BorderSide.LEFT);
            border = this.getBorderStr(elt, topBorder, rightBorder, bottomBorder, leftBorder) + "\\brdrcf" + this.getColorIndex(elt.getBorderColor());
        }
        if (!(((ReportCell)elt).getDataFormat() instanceof BarcodeFormat)) {
            String[] strList;
            String text = elt.getText();
            if (this.reportUI.report.getStringCustomizer() != null) {
                text = this.reportUI.report.getStringCustomizer().encodeString(text);
            }
            if (elt.getFontColor() == null) {
                text = "";
            }
            String hAlign = "";
            if (elt.getAlign() == 0) {
                hAlign = "\\qc";
            } else if (elt.getAlign() == 2) {
                hAlign = "\\qr";
            }
            int w = RTFReport.toTwips(elt.getWidth());
            int h = RTFReport.toTwips(elt.getHeight());
            int x = this.getX(elt);
            int templateIndex = this.getTemplateIndex(x);
            x = this.getAbsoluteX(x, templateIndex);
            int y = this.getAbsoluteY(this.getY(elt));
            if (elt.hasBorder()) {
                w -= rightBorder;
                x += leftBorder / 2;
            }
            Font font = elt.getRefFont();
            font = FontTable.newFont(font.getName(), font.getStyle(), QbUtil.resizeViewerFontRTF(font.getSize(), this.report.isAdjustFont()));
            FontMetrics fm = this.getOffScreenGraphics().getFontMetrics(font);
            int fontSize = RTFReport.mapFontSize(font.getSize());
            int charH = fm.getMaxAscent() + fm.getMaxDescent();
            int pixelHeight = elt.getHeightOfElement();
            String style = "";
            style = font.isBold() ? "\\b" : "\\b0";
            style = font.isItalic() ? style + "\\i" : style + "\\i0";
            String underline = "\\ul0";
            if (elt.isUnderline()) {
                underline = "\\ul";
            }
            int offset = 3;
            int pixelWidth = elt.getWidthOfElement();
            if (elt.getAlign() == 1) {
                pixelWidth -= offset;
            } else if (elt.getAlign() == 2) {
                pixelWidth -= offset;
            }
            if (pixelWidth < 1) {
                pixelWidth = 1;
            }
            if (elt.hasBorder()) {
                x += 25;
                y -= topBorder;
                w -= 50;
                h = h + topBorder + bottomBorder;
            }
            if ((strList = ReportGraphics.tokenizer(text, fm, pixelWidth, elt.isNoWrap())).length > 0) {
                this.writers[templateIndex].write(new StringBuffer(200).append("\\absw").append(w).append("\\absh").append(h).append("\\phpg\\posx").append(x).append("\\pvpg\\posy").append(y).append(background).append(border).append(hAlign).append("\\sl").append(this.mapLineHeight(charH, font.getSize())).append("\\f").append(this.getFontIndex(font)).append("\\fs").append(fontSize).append("\\cf").append(this.getColorIndex(elt.getFontColor())).append(style).append(underline + " ").toString());
                for (int i = 0; i < strList.length; ++i) {
                    if (i != 0 && charH * (i + 1) > pixelHeight) {
                        i = strList.length;
                        continue;
                    }
                    this.writers[templateIndex].write(this.escapeTextForRTF(strList[i]) + "\\par\n");
                }
                this.writers[templateIndex].write("\\pard\n");
                this.writers[templateIndex].flush();
            }
        } else {
            this.writeBarcode(elt);
        }
    }

    private String getBorderStr(ReportElement elt, int topBorder, int rightBorder, int bottomBorder, int leftBorder) {
        StringBuffer border = new StringBuffer();
        String colorStr = "\\brdrcf" + this.getColorIndex(elt.getBorderColor());
        border.append("\\box\\brdrt\\brdrs\\brdrw").append(topBorder).append(colorStr).append(" \\brdrb\\brdrs\\brdrw").append(bottomBorder).append(colorStr).append(" \\brdrl\\brdrs\\brdrw").append(leftBorder).append(colorStr).append(" \\brdrr\\brdrs\\brdrw").append(rightBorder).append(colorStr);
        return border.toString();
    }

    private int computeTrueBorderThickness(ReportElement elt, BorderSide borderSide) {
        int b;
        switch (borderSide) {
            case BOTTOM: {
                b = elt.getBottomBorder();
                break;
            }
            case RIGHT: {
                b = elt.getRightBorder();
                break;
            }
            case LEFT: {
                b = elt.getLeftBorder();
                break;
            }
            default: {
                b = elt.getTopBorder();
            }
        }
        if ((b *= 20) > 75) {
            b = 75;
        }
        return b;
    }

    protected void writeBarcode(ReportElement elt) throws Exception {
        if (elt.getText().equals("")) {
            return;
        }
        try {
            BufferedImage image = BarcodeUtil.createBarCodeImage(elt);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (!IOUtil.isJimiIncluded()) {
                throw new Exception("Please include ExportLib.jar in your classpath.");
            }
            PNGJimiEncoder.createPNGImage((Image)image, bout, 0);
            bout.close();
            byte[] barray = bout.toByteArray();
            int w = RTFReport.toTwips(elt.getWidth());
            int h = RTFReport.toTwips(elt.getHeight());
            int x = this.getX(elt);
            int templateIndex = this.getTemplateIndex(x);
            x = this.getAbsoluteX(x, templateIndex);
            int y = this.getAbsoluteY(this.getY(elt));
            StringBuffer border = new StringBuffer();
            if (elt.hasBorder() && elt.getBorderColor() != null) {
                int topBorder = this.computeTrueBorderThickness(elt, BorderSide.TOP);
                int rightBorder = this.computeTrueBorderThickness(elt, BorderSide.RIGHT);
                int bottomBorder = this.computeTrueBorderThickness(elt, BorderSide.BOTTOM);
                int leftBorder = this.computeTrueBorderThickness(elt, BorderSide.LEFT);
                border.append(this.getBorderStr(elt, topBorder, rightBorder, bottomBorder, leftBorder));
                x -= leftBorder;
                y -= topBorder;
                w = w + leftBorder + rightBorder;
                h = h + topBorder + bottomBorder;
            }
            ByteArrayOutputStream writer = this.templates[templateIndex];
            writer.write(new StringBuffer(200).append("\\absw").append(w).append("\\absh").append(h).append("\\phpg\\posx").append(x).append("\\pvpg\\posy").append(y).append("\\f0\\fs2").append(" {\\pict").append(border.toString()).append("\\pngblip\\bin").append(barray.length).append(" ").toString().getBytes());
            writer.write(barray);
            writer.write("}\\par\\pard\n".getBytes());
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to write barcode", ex);
            throw new Exception("An error ocurred while exporting barcode.");
        }
    }

    protected RTFSubReport writeSubReport(SubReportObject subReport, ReportTable tbl) {
        return this.writeSubReport(subReport, tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RTFSubReport writeSubReport(SubReportObject subReport, ReportTable tbl, ReportSection parentSection) {
        try {
            ReportElement securityLevel = subReport.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Report sreport = null;
            if (subReport.hasUsableReport()) {
                sreport = subReport.getSubReport().getReportInfo();
                if (sreport.getQueryParams().size() != 0) {
                    sreport = subReport.reloadReportWithParameters(sreport, this.report, tbl);
                } else if (sreport.dbInfo.getDriverName() != null) {
                    sreport = subReport.loadReport(this.report, tbl);
                } else {
                    try {
                        Report temp = ReloadReport.reloadData(new Report(sreport), false);
                        if (temp != null) {
                            sreport = temp;
                        }
                    }
                    catch (Exception ex) {
                        sreport.getReportTables().elementAt(0).setVisible(false);
                        subReport.setHeight(0.0);
                        this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                    }
                }
            } else {
                sreport = subReport.loadReport(this.report, tbl);
            }
            int pageH = -1;
            int pageW = -1;
            if (!subReport.isResizeToFitContent()) {
                pageH = RTFReport.toTwips(subReport.getHeight()) + this.getY(subReport);
            }
            if (!subReport.isResizeWidth() || !this.reportUI.isCalcTotalSections()) {
                pageW = RTFReport.toTwips(subReport.getWidth());
            }
            RTFSubReport rtfSub = new RTFSubReport(sreport, this.getX(subReport), this.getY(subReport), pageW, pageH, this);
            rtfSub.setParentSection(parentSection, this.pageHeight);
            Object object = rtfSub.LOCK;
            synchronized (object) {
                new Thread(rtfSub).start();
                try {
                    rtfSub.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.report.addTriggeredAlerts(sreport.getTriggeredAlerts(), sreport.getFileNameWithoutPath());
            return rtfSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot write sub-report", ex);
            return null;
        }
    }

    protected RTFSubReport writeRTFObject(ReportRTFObject rtfObject, ReportTable tbl) {
        return this.writeRTFObject(rtfObject, tbl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RTFSubReport writeRTFObject(ReportRTFObject rtfObject, ReportTable tbl, ReportSection parentSection) {
        try {
            ReportElement securityLevel = rtfObject.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Vector<Vector<Object[]>> lines = this.reportGraphics.breakRichText(rtfObject, this.report, tbl, QbUtil.toPixel(rtfObject.getColumnWidth()), false);
            int pageHeight = -1;
            if (!rtfObject.isResizeToFitContent()) {
                pageHeight = RTFReport.toTwips(rtfObject.getHeight()) + this.getY(rtfObject);
            }
            RTFRTFObject rtfSub = new RTFRTFObject(rtfObject, lines, this.getX(rtfObject), this.getY(rtfObject), RTFReport.toTwips(rtfObject.getWidth()), pageHeight, this);
            rtfSub.setParentSection(parentSection, this.pageHeight);
            Object object = rtfSub.LOCK;
            synchronized (object) {
                new Thread(rtfSub).start();
                try {
                    rtfSub.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return rtfSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write RTF object", ex);
            return null;
        }
    }

    protected void writeHeadTag() throws Exception {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            int i;
            this.templates[0].write(new StringBuffer(100).append("{\\rtf1\\ansi\\ansicpg1252").append("\\deff0\\deflang1033\\deflangfe1033").toString().getBytes());
            this.templates[0].write("{\\fonttbl".getBytes());
            StringBuffer buf = new StringBuffer(500);
            for (i = 0; i < this.fontTbl.length; ++i) {
                buf.append("{\\f").append(i).append("\\f").append(this.fontTbl[i][1]).append("\\fcharset").append(this.fontTbl[i][2]).append("\\fprq").append(this.fontTbl[i][3]).append(" ").append(this.fontTbl[i][0]).append(";}");
            }
            for (i = 0; i < this.FONT_TABLE.length; ++i) {
                buf.append("{\\f").append(i + this.fontTbl.length).append("\\f").append(this.FONT_TABLE[i][1]).append("\\fcharset").append(this.FONT_TABLE[i][2]).append("\\fprq").append(this.FONT_TABLE[i][3]).append(" ").append(this.FONT_TABLE[i][0]).append(";}");
            }
            this.templates[0].write(buf.toString().getBytes());
            this.templates[0].write("}".getBytes());
            this.templates[0].write("{\\colortbl".getBytes());
            buf = new StringBuffer(500);
            for (Color color : this.colorTbl) {
                buf.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
            }
            for (Color color : this.DEFAULT_COLORS) {
                buf.append("\\red").append(color.getRed()).append("\\green").append(color.getGreen()).append("\\blue").append(color.getBlue()).append(";");
            }
            buf.append("}");
            buf.append("\\viewkind1\\viewscale100\\uc1");
            buf.append("\\paperw").append(RTFReport.toTwips(this.report.getPageWidth()));
            buf.append("\\paperh").append(RTFReport.toTwips(this.report.getPageHeight()));
            buf.append("\\margl").append(RTFReport.toTwips(this.report.getLeftMargin()));
            buf.append("\\margr").append(RTFReport.toTwips(this.report.getRightMargin()));
            buf.append("\\margt").append(RTFReport.toTwips(this.report.getTopMargin()));
            buf.append("\\margb").append(RTFReport.toTwips(this.report.getBottomMargin()));
            if (this.report.getOrientation() == 1) {
                buf.append("\\landscape");
            }
            buf.append("\n");
            this.templates[0].write(buf.toString().getBytes());
        }
    }

    protected void writeSectionBgColor(ReportElement section) throws Exception {
        if (section.getBgColor() != null && !this.checkFitGroupOnPage) {
            ByteArrayOutputStream[] temp_templates = this.templates;
            int sectionHeight = RTFReport.toTwips(section.getHeight());
            if (sectionHeight > this.pageHeight) {
                sectionHeight = this.pageHeight;
            }
            for (ByteArrayOutputStream writer : temp_templates) {
                writer.write(new StringBuffer(200).append("\\absw").append(this.pageWidth).append("\\absh").append(sectionHeight).append("\\phpg\\posx").append(this.leftMargin).append("\\pvpg\\posy").append(this.getAbsoluteY(this.elementYPos) - 1).append("\\shading10000\\cfpat").append(this.getColorIndex(section.getBgColor())).append("\\f0\\fs2\\par\\pard\n").toString().getBytes());
            }
        }
    }

    protected boolean hasNoData(ReportSection section) {
        return section == null || section.hasNoDrawableData();
    }

    public static int toTwips(double inch) {
        return (int)Math.rint(inch * 72.0 * 20.0);
    }

    public static double toInch(int twips) {
        return (double)twips / 20.0 / 72.0;
    }

    protected int getFontIndex(Font font) {
        if (font == null) {
            return 1 + this.fontTbl.length;
        }
        if (font.getName().equalsIgnoreCase("Monospaced") || font.getName().equalsIgnoreCase("DialogInput")) {
            return 2 + this.fontTbl.length;
        }
        if (font.getName().equalsIgnoreCase("Serif")) {
            return 0 + this.fontTbl.length;
        }
        String fontname = font.getName();
        Integer cache = (Integer)this.fontTableCache.get(fontname);
        if (cache != null) {
            return cache;
        }
        return 1 + this.fontTbl.length;
    }

    private void writeMasterSection(ReportSection masterSection, ReportTable table) throws Exception {
        ReportCell[] cells;
        if (this.hasNoData(masterSection)) {
            return;
        }
        String background = "";
        StringBuffer border = new StringBuffer(200);
        if (masterSection.getBgColor() != null && !this.checkFitGroupOnPage) {
            background = "\\shading10000\\cfpat" + this.getColorIndex(masterSection.getBgColor());
        }
        if (masterSection.getBorderThickness() > 0 && masterSection.getBorderColor() != null && !this.checkFitGroupOnPage) {
            String thicknessFactor = "";
            int b = masterSection.getBorderThickness() * 20;
            if (b > 75) {
                b = b > 150 ? 75 : (b /= 2);
                thicknessFactor = "\\brdrth";
            }
            border.append("\\box\\brdrs\\brdrw").append(b).append(thicknessFactor).append("\\brdrcf").append(this.getColorIndex(masterSection.getBorderColor()));
        }
        int w = RTFReport.toTwips(masterSection.getWidth());
        int h = RTFReport.toTwips(masterSection.getHeight());
        int x = this.getX(masterSection);
        int templateIndex = this.getTemplateIndex(x);
        x = this.getAbsoluteX(x, templateIndex);
        int y = this.getAbsoluteY(this.getY(masterSection));
        if (!background.equals("") || !border.equals("")) {
            this.templates[templateIndex].write(new StringBuffer(200).append("\\absw").append(w).append("\\absh").append(h).append("\\phpg\\posx").append(x).append("\\pvpg\\posy").append(y).append(background).append(border.toString()).append("\\f0\\fs2\\par\\pard\n").toString().getBytes());
        }
        int old_elementXPos = this.elementXPos;
        int old_elementYPos = this.elementYPos;
        this.elementXPos = this.getX(masterSection);
        this.elementYPos = this.getY(masterSection);
        for (ReportCell cell : cells = masterSection.sortCell(1, true)) {
            if (cell instanceof ReportLine || cell instanceof ReportGrid || this.skipCell(cell) || !(cell.getX() + cell.getWidth() <= masterSection.getWidth()) || !(cell.getY() + cell.getHeight() <= masterSection.getHeight())) continue;
            ReportCell elt = table.formatCell(cell, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report);
            this.writeTableDataElement(elt, table, masterSection);
        }
        for (int i = 0; i < cells.length; ++i) {
            if (!(cells[i] instanceof ReportLine) && !(cells[i] instanceof ReportGrid) || this.skipCell(cells[i]) || !(cells[i].getX() + cells[i].getWidth() <= masterSection.getWidth()) || !(cells[i].getY() + cells[i].getHeight() <= masterSection.getHeight())) continue;
            ReportCell elt = table.formatCell(cells[i], this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report);
            this.writeTableDataElement(elt, table, masterSection);
        }
        this.elementXPos = old_elementXPos;
        this.elementYPos = old_elementYPos;
    }

    protected static int mapFontSize(int size) {
        return (int)Math.rint((double)size * 0.75) * 2;
    }

    protected int mapLineHeight(int pixelHeight, int fontSize) {
        if (fontSize < 15) {
            return (int)Math.rint((double)pixelHeight * 0.75) * 20;
        }
        return (int)Math.rint((double)pixelHeight * 0.72) * 20;
    }

    protected int writeRemainingSubReports(Vector remainingSubReports, ReportSection section) throws Exception {
        return this.writeRemainingSubReports(remainingSubReports, null, null, section, null, null, null);
    }

    protected int writeRemainingSubReports(Vector remainingSubReports, Vector oneTime, Vector oneTimeY, ReportSection section, ReportTable tbl) throws Exception {
        return this.writeRemainingSubReports(remainingSubReports, oneTime, oneTimeY, section, tbl, null, null);
    }

    protected int writeRemainingSubReports(Vector remainingSubReports, Vector oneTime, Vector oneTimeY, ReportSection section, ReportTable tbl, ReportElement[] relts, int[] shifts) throws Exception {
        int bottomYOfSection = 0;
        while (remainingSubReports != null && remainingSubReports.size() > 0 || oneTime != null && oneTime.size() > 0) {
            this.elementYPos += 20;
            this.pageBreak(section);
            bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, relts, shifts);
        }
        return bottomYOfSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int writeOnePageOfSubReports(Vector subReports) {
        int bottomY = 0;
        for (int i = subReports.size() - 1; i >= 0; --i) {
            RTFSubReport rtfSub = (RTFSubReport)subReports.elementAt(i);
            rtfSub.elementYPos = this.elementYPos;
            if (!this.checkFitGroupOnPage) {
                rtfSub.templates[0] = this.templates[rtfSub.templateIndex];
                rtfSub.writers[0] = this.writers[rtfSub.templateIndex];
            }
            Object object = rtfSub.LOCK;
            synchronized (object) {
                rtfSub.LOCK.notify();
                try {
                    rtfSub.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!rtfSub.isFinished()) continue;
            if (rtfSub.elementYPos > bottomY) {
                bottomY = rtfSub.elementYPos;
            }
            subReports.removeElementAt(i);
        }
        return bottomY;
    }

    protected int writeVisibleOneTimeElements(Vector oneTime, Vector oneTimeY, Vector remainingSubReports, ReportTable tbl, ReportElement[] relts, int[] shifts) throws Exception {
        int bottomYOfSection = 0;
        if (remainingSubReports != null && remainingSubReports.size() > 0) {
            bottomYOfSection = this.writeOnePageOfSubReports(remainingSubReports);
        }
        if (oneTime == null) {
            return bottomYOfSection;
        }
        int elementXPos_old = this.elementXPos;
        for (int i = 0; relts != null && i < relts.length; ++i) {
            ReportCell cell;
            int j = 0;
            for (j = oneTime.size() - 1; j >= 0 && !((ReportElement)oneTime.elementAt(j)).getID().equals(relts[i].getID()); --j) {
            }
            if (j == -1) continue;
            this.elementXPos = elementXPos_old;
            for (int l = 0; l < i; ++l) {
                if (!(relts[l].getY() <= relts[i].getY() && relts[l].getY() + relts[l].getHeight() > relts[i].getY()) && (!(relts[l].getY() >= relts[i].getY()) || !(relts[l].getY() < relts[i].getY() + relts[i].getHeight()))) continue;
                this.incElementXPos(shifts[l]);
            }
            if (!(relts[i] instanceof SubReportObject)) {
                this.incElementXPos(shifts[i]);
            }
            if (!(cell = tbl.formatCell((ReportCell)oneTime.elementAt(j), this.getCurrentPageNumber(), 1, this.getTotalPageNumber(), 1, this.report)).isVisible()) {
                oneTime.removeElementAt(j);
                oneTimeY.removeElementAt(j);
                return bottomYOfSection;
            }
            int yPos = (Integer)oneTimeY.elementAt(j);
            if (this.pageHeight - this.elementYPos >= yPos + RTFReport.toTwips(cell.getHeight())) {
                double oldY = cell.getY();
                if (this.skipCell(cell)) continue;
                cell.setY(RTFReport.toInch(yPos));
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject) {
                    if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage || cell.isResizeToFitContent()) {
                        RTFSubReport rtfSub = null;
                        if (cell instanceof SubReportObject) {
                            rtfSub = this.writeSubReport((SubReportObject)cell, tbl);
                            this.incElementXPos(shifts[i]);
                        } else {
                            rtfSub = this.writeRTFObject((ReportRTFObject)cell, tbl);
                        }
                        if (rtfSub != null && rtfSub.isFinished()) {
                            if (rtfSub.elementYPos > bottomYOfSection && cell.isResizeToFitContent()) {
                                bottomYOfSection = rtfSub.elementYPos;
                            }
                        } else if (rtfSub != null) {
                            remainingSubReports.insertElementAt(rtfSub, 0);
                        }
                    }
                } else if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
                    this.writeTableDataElement(cell, tbl, tbl);
                }
                cell.setY(oldY);
                if (bottomYOfSection < this.elementYPos + yPos + RTFReport.toTwips(cell.getHeight())) {
                    bottomYOfSection = this.elementYPos + yPos + RTFReport.toTwips(cell.getHeight());
                }
                oneTime.removeElementAt(j);
                oneTimeY.removeElementAt(j);
                continue;
            }
            if ((yPos -= this.pageHeight - this.elementYPos) < 0) {
                oneTimeY.setElementAt(0, j);
                continue;
            }
            oneTimeY.setElementAt(yPos, j);
        }
        return bottomYOfSection;
    }

    protected int getColorIndex(Color color) {
        if (color == null) {
            return 0;
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        for (int i = 0; i < this.colorTbl.length; ++i) {
            if (this.colorTbl[i].getRed() != red || this.colorTbl[i].getGreen() != green || this.colorTbl[i].getBlue() != blue) continue;
            return i;
        }
        return this.getDefaultColorIndex(color) + this.colorTbl.length;
    }

    private int getDefaultColorIndex(Color color) {
        int i;
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        if (r >= 160 && r < 208 && g >= 160 && g < 208 && b >= 160 && b < 208) {
            return 14;
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        if (r < 160 && g < 160 && b < 160) {
            if (r >= 108) {
                red = 128;
            }
            if (g >= 108) {
                green = 128;
            }
            if (b >= 180) {
                blue = 128;
            }
            for (i = 0; i < this.DEFAULT_COLORS.length; ++i) {
                if (this.DEFAULT_COLORS[i].getRed() != red || this.DEFAULT_COLORS[i].getGreen() != green || this.DEFAULT_COLORS[i].getBlue() != blue) continue;
                return i;
            }
        }
        if (r < 208 && g < 208 && b < 208) {
            if (r >= 160) {
                red = 128;
            }
            if (g >= 160) {
                green = 128;
            }
            if (b >= 160) {
                blue = 128;
            }
            for (i = 0; i < this.DEFAULT_COLORS.length; ++i) {
                if (this.DEFAULT_COLORS[i].getRed() != red || this.DEFAULT_COLORS[i].getGreen() != green || this.DEFAULT_COLORS[i].getBlue() != blue) continue;
                return i;
            }
        }
        if (r >= 208) {
            red = 255;
        }
        if (g >= 208) {
            green = 255;
        }
        if (b >= 208) {
            blue = 255;
        }
        for (i = 0; i < this.DEFAULT_COLORS.length; ++i) {
            if (this.DEFAULT_COLORS[i].getRed() != red || this.DEFAULT_COLORS[i].getGreen() != green || this.DEFAULT_COLORS[i].getBlue() != blue) continue;
            return i;
        }
        return 0;
    }

    private Graphics getOffScreenGraphics() {
        if (this.offScreenGraphics != null) {
            return this.offScreenGraphics;
        }
        return IOUtil.getOffScreenGraphics();
    }

    private void incElementXPos(int inc) {
        this.elementXPos += inc;
    }

    protected void writeSection(ReportSection section, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception {
        if (!this.titleAdjusted) {
            this.titleAdjusted = this.reportUI.adjustReportTitle(this.reportUI.getReportGraphics(), this.report.getReportHeader());
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, this.getCurrentPageNumber(), this.currentSection, this.getTotalPageNumber(), this.totalSections, this.report, section);
        }
        this.writeSectionHelper(section, tbl, preAggCol, resultCol);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            ReportSection child = section.getSection(i);
            child.setRepeatOnEveryPage(section.isRepeatOnEveryPage());
            this.writeSectionHelper(child, tbl, preAggCol, resultCol);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
    }

    protected void writeSectionHelper(ReportSection orgSection, ReportTable tbl, Vector preAggCol, Vector resultCol) throws Exception {
        if (orgSection == null || !orgSection.isVisible()) {
            return;
        }
        if (orgSection.isResetPageNumber()) {
            this.resetPageNumber = true;
        }
        if (!this.isWriteRepeatSection && this.printOnNewPage(orgSection)) {
            this.pageBreak(orgSection);
        }
        if (this.hasNoData(orgSection)) {
            return;
        }
        boolean doColumnWrap_BAK = this.doColumnWrap;
        int totalDrawCol = this.columnWrapCount;
        boolean repeatTableHeader = false;
        if (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter() || orgSection == this.report.getReportHeader() || orgSection == this.report.getReportFooter() || orgSection.getID().startsWith("RPT_HDR") || orgSection.getID().startsWith("RPT_FTR")) {
            this.doColumnWrap = false;
            totalDrawCol = 0;
        } else if (orgSection.getID().equals("TBL0_HDR")) {
            repeatTableHeader = true;
            if (!this.checkTotalPageNumber && this.totalPageNumber == this.currentPageNumber) {
                totalDrawCol = this.lastDrawCol;
            }
        } else {
            totalDrawCol = 0;
        }
        ReportSection cellArray = this.resizeSection(this.reportGraphics, orgSection, tbl);
        this.pageBreak(RTFReport.toTwips(cellArray.getHeight()), orgSection);
        ReportElement[] cells = cellArray.sortCell(1, true);
        if (this instanceof RTFSubReport) {
            this.reportUI.setCurX(RTFReport.toInch(this.elementXPos + ((RTFSubReport)this).offsetX));
        } else {
            this.reportUI.setCurX(RTFReport.toInch(this.elementXPos));
        }
        double[] temp = null;
        double[] tempRowShifts = null;
        if (this.report.isCrossTabFixedField()) {
            double oldX = this.reportUI.curX;
            cells = this.reportUI.splitCells(cells);
            cells = (ReportCell[])ReportElement.sortElement(cells, 1, true);
            Object[] objs = this.reportUI.calculateRowShifts(cells, tbl);
            this.reportUI.setCurX(oldX);
            cells = (ReportCell[])objs[0];
            tempRowShifts = (double[])objs[1];
            temp = this.reportUI.calculateShifts(cells, tbl);
        } else {
            tempRowShifts = temp = this.reportUI.calculateShifts(cells, tbl);
        }
        int[] shifts = new int[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            shifts[i] = RTFReport.toTwips(temp[i]);
        }
        int[] rowShifts = new int[tempRowShifts.length];
        for (int i = 0; i < tempRowShifts.length; ++i) {
            rowShifts[i] = RTFReport.toTwips(tempRowShifts[i]);
        }
        if (!(this instanceof RTFSubReport)) {
            this.writeSectionBgColor(cellArray);
        } else {
            ((RTFSubReport)this).shift = 0;
            for (int shift : shifts) {
                ((RTFSubReport)this).shift += shift;
            }
            this.writeSectionBgColor(cellArray);
            ((RTFSubReport)this).shift = 0;
        }
        int bottomY = this.elementYPos + RTFReport.toTwips(cellArray.getHeight());
        Vector<RTFSubReport> subReports = new Vector<RTFSubReport>();
        for (int curArea = 0; curArea <= totalDrawCol; ++curArea) {
            int i;
            int delta = 0;
            if (repeatTableHeader) {
                delta = curArea * this.columnWrapWidth;
            } else if (this.doColumnWrap && this.wrapInfo != null) {
                delta = this.wrapInfo[0] * this.columnWrapWidth;
            }
            for (i = 0; i < cells.length; ++i) {
                this.elementXPos = 0;
                for (int l = 0; l < i; ++l) {
                    if (!this.reportUI.isWithIn(cells[i], cells[l])) continue;
                    this.incElementXPos(rowShifts[l]);
                }
                if (cells[i] instanceof SubReportObject) {
                    cells[i].setDrawX(RTFReport.toTwips(cells[i].getX()) + this.elementXPos);
                    this.incElementXPos(rowShifts[i]);
                    continue;
                }
                this.incElementXPos(rowShifts[i]);
                cells[i].setDrawX(RTFReport.toTwips(cells[i].getX()) + this.elementXPos);
            }
            cells = (ReportCell[])ReportElement.sortElement(cells, 2, true);
            for (i = 0; i < cells.length; ++i) {
                ReportCell cell;
                this.elementXPos = delta + (int)cells[i].getDrawX() - RTFReport.toTwips(cells[i].getX());
                if (this.skipCell(cells[i]) || (orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) && RTFReport.toTwips(cells[i].getX() + cells[i].getWidth()) > this.pageWidth) continue;
                if (cells[i] instanceof ReportLine || cells[i] instanceof ReportGrid) {
                    if (cells[i] instanceof ReportLine && !((ReportLine)cells[i]).isVertical() && ((ReportLine)cells[i]).isMatchColumnWidths()) {
                        ((ReportLine)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                    }
                    if (cells[i] instanceof ReportGrid && ((ReportGrid)cells[i]).isMatchColumnWidths()) {
                        ((ReportGrid)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                    }
                    this.writeTableDataElement(tbl.formatCell((ReportCell)cells[i], this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report), tbl, cellArray);
                    continue;
                }
                if (cells[i] instanceof TableOfContents || (cell = tbl.formatCell((ReportCell)cells[i], this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report)) == null || !cell.isVisible()) continue;
                if (cell instanceof SubReportObject || cell instanceof ReportRTFObject) {
                    if (cellArray.isRepeatOnEveryPage() || orgSection == this.report.getPageHeader() || orgSection == this.report.getPageFooter()) {
                        cell.setResizeToFitContent(false);
                    }
                    if ((this.checkTotalPageNumber || this.checkFitGroupOnPage) && !cell.isResizeToFitContent()) continue;
                    RTFSubReport rtfSub = null;
                    if (cell instanceof SubReportObject) {
                        rtfSub = this.writeSubReport((SubReportObject)cell, tbl, cellArray);
                    } else if (cell instanceof ReportRTFObject) {
                        rtfSub = this.writeRTFObject((ReportRTFObject)cell, tbl, cellArray);
                    }
                    if (rtfSub != null && rtfSub.isFinished()) {
                        if (rtfSub.elementYPos <= bottomY || !cell.isResizeToFitContent()) continue;
                        bottomY = rtfSub.elementYPos;
                        continue;
                    }
                    if (rtfSub == null) continue;
                    subReports.insertElementAt(rtfSub, 0);
                    continue;
                }
                if (this.checkTotalPageNumber || this.checkFitGroupOnPage) continue;
                this.writeTableDataElement(tbl.formatCell((ReportCell)cells[i], -1, this.currentPageNumber, this.currentSection, this.totalPageNumber, this.totalSections, this.report, false, preAggCol, resultCol), tbl, cellArray);
            }
        }
        this.doColumnWrap = doColumnWrap_BAK;
        if (subReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(subReports, orgSection);
        } else {
            this.elementYPos += RTFReport.toTwips(cellArray.getHeight());
            if (bottomY > this.elementYPos) {
                this.elementYPos = bottomY;
            }
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            this.curMaxY = bottomY < this.wrapInfo[2] ? this.wrapInfo[2] : bottomY;
            if (repeatTableHeader) {
                this.wrapInfo[1] = this.elementYPos;
            }
        }
        this.elementXPos = 0;
    }

    public void startToGetData(ReportTable table) throws Exception {
    }

    protected String escapeTextForRTF(String str) {
        char[] chars;
        StringBuffer buf = new StringBuffer(str.length());
        block5: for (char c : chars = str.toCharArray()) {
            switch (c) {
                case '\\': {
                    buf.append("\\\\");
                    continue block5;
                }
                case '{': {
                    buf.append("\\{");
                    continue block5;
                }
                case '}': {
                    buf.append("\\}");
                    continue block5;
                }
                default: {
                    if (c <= '\u00ff') {
                        buf.append(c);
                        continue block5;
                    }
                    buf.append("\\u" + c + "?");
                }
            }
        }
        return buf.toString();
    }
}

