/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataBuffer;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.RTFReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;

public class RTFReportColumnar
extends RTFReport {
    private static final Logger LOGGER = Logger.getLogger(RTFReportColumnar.class.getName());
    Vector footerAggCol;
    Vector footerResCol;
    private ColDataBuffer colDataBuffer;
    int startIndex = 0;
    int displayRow = Report.getInputDataBlockSize();

    public RTFReportColumnar(Report report) throws Exception {
        super(report);
        LOGGER.finest("RTF report columnar");
    }

    @Override
    public void exportRTF(OutputStream outstream) throws Exception {
        this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
        try {
            this.reportUI.preCalcTotalSections();
            this.totalSections = this.reportUI.getTotalSections();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to get total section number", e);
        }
        this.reportGraphics = this.reportUI.getReportGraphics();
        double pHeight = this.report.getActualPageHeight() - (this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight());
        this.pageHeight = RTFReportColumnar.toTwips(pHeight);
        this.checkTotalPageNumber = false;
        this.exportRTF();
        outstream.write(this.templates[0].toByteArray());
        this.colDataBuffer.join();
    }

    @Override
    void formatTable() throws Exception {
    }

    private void formatTable(ReportTable tbl, int startIndex, int displayRow) throws Exception {
        while (!this.colDataBuffer.isDataReady(startIndex)) {
            Thread.sleep(100L);
        }
        ColData[] colData = this.colDataBuffer.getData(startIndex);
        this.colDataBuffer.clearDataBuffer(startIndex);
        for (int i = 0; i < this.report.colInfo.length; ++i) {
            int m = this.report.colInfo[i].getMapping();
            if (m >= 0) {
                tbl.getColumn(i).setDataSet(colData[m].getDataSet());
                continue;
            }
            Formula formulaObj = this.report.colInfo[i].getFormulaObj();
            if (formulaObj == null) continue;
            int rowCt = tbl.getRowCount();
            Object obj = null;
            for (int j = 0; j < rowCt; ++j) {
                obj = formulaObj.getValue(tbl, j, 1, 1, 1, 1, this.report, null, null, false, null, null, colData);
                tbl.getColumn(i).addData(obj);
            }
        }
    }

    @Override
    public void startToGetData(ReportTable tbl) throws Exception {
        this.colDataBuffer = new ColDataBuffer(this.report.dbInfo, this.report.originalIResultSet, this.startIndex, this.displayRow);
        this.colDataBuffer.start();
        this.formatTable(tbl, this.startIndex, this.displayRow);
    }

    @Override
    protected void writeReportTable(ReportTable tbl) throws Exception {
        this.writeSection(tbl.getHeader(), tbl);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        this.footerAggCol = new Vector();
        this.footerResCol = new Vector();
        Aggregation.getAggrColumn(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        Aggregation.getAggrColumn(this.report.getReportFooter(), tbl, this.footerAggCol, this.footerResCol);
        this.writeCells(tbl);
        this.writeSection(tbl.getFooter(), tbl, this.footerAggCol, this.footerResCol);
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeCells(ReportTable tbl) throws Exception {
        int n;
        void var12_20;
        if (!tbl.isVisible()) {
            return;
        }
        int nRow = 0;
        this.background_templates = new ByteArrayOutputStream[this.templates.length];
        this.background_offset = new int[this.templates.length];
        for (int i = 0; i < this.templates.length; ++i) {
            this.background_templates[i] = new ByteArrayOutputStream();
            this.background_offset[i] = this.templates[i].size();
        }
        ReportImage[] chart = tbl.getSortedImages();
        SubReportObject[] subReports = tbl.getSortedSubReports();
        ReportRTFObject[] rtfObjects = tbl.getSortedRTFObjects();
        Vector remainingSubReports = new Vector();
        Vector<ReportCell> oneTime = new Vector<ReportCell>();
        Vector<Number> oneTimeY = new Vector<Number>();
        for (int i = 0; i < chart.length; ++i) {
            if (chart[i] instanceof ReportLine || chart[i] instanceof ReportGrid || this.skipCell(chart[i])) continue;
            oneTime.insertElementAt(chart[i], 0);
            oneTimeY.insertElementAt(Float.valueOf(chart[i].getYPos()), 0);
        }
        for (SubReportObject subReportObject : subReports) {
            oneTime.insertElementAt(subReportObject, 0);
            oneTimeY.insertElementAt(Float.valueOf(subReportObject.getYPos()), 0);
        }
        for (ReportCell reportCell : rtfObjects) {
            oneTime.insertElementAt(reportCell, 0);
            oneTimeY.insertElementAt(RTFReportColumnar.toTwips(reportCell.getY()), 0);
        }
        ReportElement[] relts = tbl.getXSortedVisibleElements();
        double[] temp = this.reportUI.calculateShifts(relts, tbl);
        int[] shifts = new int[temp.length];
        boolean bl = false;
        while (var12_20 < temp.length) {
            shifts[var12_20] = RTFReportColumnar.toTwips(temp[var12_20]);
            ++var12_20;
        }
        boolean bl2 = false;
        int wrapIndex = 0;
        if (this.wrapInfo != null) {
            wrapIndex = this.wrapInfo[2];
        }
        this.resetColumnWrapTableUI();
        int rowIdx = 0;
        ReportTable orgTable = tbl;
        boolean firstTime = true;
        do {
            if (!firstTime) {
                this.formatTable(tbl, this.startIndex, this.displayRow);
            }
            firstTime = false;
            nRow = tbl.getRowCount();
            if (nRow <= 0) break;
            this.startIndex += nRow;
            for (int i = 0; i < nRow; ++i) {
                int delta;
                this.elementXPos = 0;
                tbl = this.resizeTable(this.reportGraphics, orgTable, i);
                chart = tbl.getSortedImages();
                ReportColumn[] col = tbl.getSortedVisibleColumns();
                ReportColumn[] originalCol = tbl.getVisibleColumnList();
                int tblH = RTFReportColumnar.toTwips(tbl.getHeight());
                int oldpageN = this.currentPageNumber;
                if (tbl.isPrintOnNewPage() && i != 0) {
                    this.pageBreak(null);
                } else {
                    this.pageBreak(tblH, rowIdx);
                }
                if (this.currentPageNumber > oldpageN || rowIdx == 0) {
                    n = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, relts, shifts);
                }
                if (this.wrapInfo != null) {
                    wrapIndex = this.wrapInfo[0];
                }
                this.elementXPos = delta = wrapIndex * this.columnWrapWidth;
                if (delta == 0) {
                    this.writeSectionBgColor(tbl);
                }
                if (!this.checkTotalPageNumber) {
                    for (int j = 0; j < col.length; ++j) {
                        if (this.skipCell(col[j])) continue;
                        ReportCell cell = tbl.formatCell(col[j], i, rowIdx - this.columnWrapDisplayRow * wrapIndex - this.columnWrapCount * this.columnWrapInitialRow, this.report);
                        this.sectionBreak(RTFReportColumnar.toTwips(cell.getX()), RTFReportColumnar.toTwips(cell.getWidth()));
                        this.writeTableDataElement(cell, tbl, tbl);
                        Aggregation.calculateAggregation(originalCol[j].getData(i), j, this.footerAggCol, this.footerResCol);
                    }
                    for (int k = 0; k < chart.length; ++k) {
                        ReportImage img;
                        if (this.skipCell(chart[k]) || !((img = chart[k]) instanceof ReportLine) && !(img instanceof ReportGrid)) continue;
                        this.writeTableDataElement(chart[k], tbl, tbl);
                    }
                }
                this.elementYPos += RTFReportColumnar.toTwips(tbl.getHeight());
                ++rowIdx;
            }
        } while (this.displayRow == nRow);
        if (remainingSubReports.size() > 0) {
            this.elementYPos = this.writeRemainingSubReports(remainingSubReports, oneTime, oneTimeY, null, tbl);
        } else if (this.elementYPos < n) {
            this.elementYPos = n;
        }
        if (this.doColumnWrap) {
            this.curMaxY = this.wrapInfo != null && this.elementYPos < this.wrapInfo[2] ? this.wrapInfo[2] : this.elementYPos;
        }
        this.elementXPos = 0;
    }
}

