/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.report.RTFReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SubReportUI;

public class RTFSubReport
extends RTFReport
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RTFSubReport.class.getName());
    protected boolean checkVisibility;
    protected boolean finish;
    public Object LOCK;
    public int templateIndex;
    private boolean writePageFooter;
    public int reportHeight;
    public int reportWidth;
    public int offsetX;
    public int shift;
    protected int pageTopY;
    protected RTFReport parent;
    protected ReportSection parentSection;
    protected int remainingSectionHeight;
    protected int myPageHeight;

    public RTFSubReport(Report subreport, int x, int y, int reportWidth, int reportHeight, RTFReport parent) {
        block15: {
            this.checkVisibility = false;
            this.finish = false;
            this.LOCK = new Object();
            this.writePageFooter = false;
            this.report = subreport;
            this.parent = parent;
            this.fontTableCache = parent.fontTableCache;
            this.leftMargin = parent.leftMargin;
            this.topMargin = parent.topMargin;
            this.bottomMargin = parent.bottomMargin;
            this.reportGraphics = parent.reportGraphics;
            this.colorTbl = parent.colorTbl;
            if (reportHeight < 0) {
                this.pageHeight = parent.pageHeight;
                int footerHeight = 0;
                try {
                    footerHeight = this.hasNoData(this.report.getPageFooter()) ? 0 : RTFSubReport.toTwips(this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Cannot set footer height", ex);
                }
                this.pageHeight -= footerHeight;
            } else {
                this.checkVisibility = true;
                this.pageHeight = reportHeight < parent.pageHeight ? reportHeight : parent.pageHeight;
                this.bottomMargin = parent.pageHeight - this.pageHeight + this.bottomMargin;
            }
            this.reportWidth = reportWidth;
            this.reportHeight = reportHeight;
            this.pageWidth = parent.pageWidth;
            this.elementXPos = 0;
            this.elementYPos = y;
            this.offsetX = x;
            this.pageHeaderHeight = parent.pageHeaderHeight;
            this.currentPageNumber = parent.currentPageNumber;
            this.totalPageNumber = parent.totalPageNumber;
            this.currentSection = parent.currentSection;
            try {
                this.reportUI = this.createReportUI();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to create sub-report UI", ex);
            }
            this.checkTotalPageNumber = parent.checkTotalPageNumber;
            this.templateIndex = parent.getTemplateIndex(x);
            this.totalSections = parent.totalSections;
            this.templates = new ByteArrayOutputStream[this.totalSections - this.templateIndex];
            this.writers = new PrintWriter[this.totalSections - this.templateIndex];
            if (parent.checkFitGroupOnPage) {
                this.templates[0] = new ByteArrayOutputStream();
            } else {
                for (int i = 0; i < this.templates.length; ++i) {
                    this.templates[i] = parent.templates[this.templateIndex + i];
                }
            }
            if (parent.checkFitGroupOnPage) {
                try {
                    if (this.report.getExportEncoding() != null) {
                        this.writers[0] = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.templates[0], this.report.getExportEncoding()), true);
                        break block15;
                    }
                    this.writers[0] = new PrintWriter(this.templates[0], true);
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.log(Level.WARNING, "Unsupported encoding", e);
                }
            } else {
                for (int i = 0; i < this.writers.length; ++i) {
                    this.writers[i] = parent.writers[this.templateIndex + i];
                }
            }
        }
        this.pageTopY = this.elementYPos;
    }

    protected SubReportUI createReportUI() throws Exception {
        return new SubReportUI(this.report, RTFSubReport.toInch(this.offsetX), RTFSubReport.toInch(this.elementYPos), RTFSubReport.toInch(this.reportWidth), RTFSubReport.toInch(this.reportHeight), this.parent.reportUI);
    }

    @Override
    protected void initFontTableCache() {
        if (this.parent == null) {
            return;
        }
        this.fontTableCache = this.parent.fontTableCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ReportTable table;
            this.formatTable();
            Vector<ReportTable> vec = this.report.getReportTables();
            this.hTable = table = vec.elementAt(0);
            this.fTable = vec.elementAt(vec.size() - 1);
            if (this.report.getInitializeReportError() != null) {
                this.writeSection(ReportUI.createErrorSection(this.report.getActualPageWidth(), this.report.getActualPageHeight(), this.report.getInitializeReportError()), table);
            } else {
                this.initRepeatSection();
                this.writeSection(this.report.getPageHeader(), table);
                this.writePageFooter = true;
                this.writeSection(this.report.getReportHeader(), table);
                for (int i = 0; i < vec.size(); ++i) {
                    table = (ReportTable)vec.elementAt(i);
                    this.initRepeatSection();
                    this.setColumnWrap();
                    this.wrapInfo = new int[]{0, this.elementYPos, this.elementYPos};
                    this.writeReportTable(table);
                    this.resetColumnWrap();
                }
                table = (ReportTable)vec.elementAt(vec.size() - 1);
                this.writeSection(this.report.getReportFooter(), table);
                this.writeSection(this.report.getPageFooter(), table, this.checkVisibility);
                this.writeSectionColor();
            }
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run RTFSubReport", ex);
            } else {
                LOGGER.log(Level.FINEST, "RTFSubReport: page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run RTFSubReport", err);
        }
        finally {
            this.finish = true;
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
            }
        }
    }

    protected boolean isFinished() {
        return this.finish;
    }

    @Override
    void setColumnWrap() {
        super.setColumnWrap(this.reportWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.writePageFooter) {
            this.writeSection(this.report.getPageFooter(), this.fTable, false);
        }
        ++this.currentPageNumber;
        ++this.pagebreaks;
        this.rowCount = 0;
        if (this.checkFitGroupOnPage) {
            throw new Exception("stop writing because of fit group on page");
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notify();
            try {
                this.LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.elementXPos = 0;
        this.writeSectionColor();
        if (this.writePageFooter) {
            this.writeSection(this.report.getPageHeader(), this.hTable);
        }
        this.writeRepeatSection(section);
    }

    @Override
    protected int getTemplateIndex(int x) {
        int index = (int)Math.floor(((double)(x + this.shift) + 0.001) / (double)this.pageWidth) - this.templateIndex;
        if (index > 0 && index < this.templates.length) {
            return index;
        }
        return 0;
    }

    @Override
    protected void sectionBreak(int x, int requiredWidth) {
        if (Math.ceil((x + this.elementXPos + this.offsetX + requiredWidth) / this.pageWidth) != Math.ceil((x + this.elementXPos + this.offsetX) / this.pageWidth) && (x + this.elementXPos + this.offsetX) % this.pageWidth != 0) {
            int temp = this.pageWidth - (x + this.elementXPos + this.offsetX) % this.pageWidth;
            this.elementXPos += temp;
            this.shift = Math.floor((x + this.elementXPos + this.offsetX) / this.pageWidth) == (double)(this.templateIndex + 1) ? temp : (this.shift += temp);
        }
        this.currentSection = (int)Math.floor((this.offsetX + x + this.elementXPos) / this.pageWidth) + 1;
    }

    @Override
    protected int getX(ReportElement elt) {
        return RTFSubReport.toTwips(elt.getX()) + this.elementXPos + this.offsetX;
    }

    @Override
    protected int getAbsoluteX(int pageX, int contentByteIndex) {
        if (contentByteIndex < 0 || contentByteIndex >= this.templates.length) {
            return pageX % this.pageWidth + this.leftMargin;
        }
        return pageX - this.pageWidth * (contentByteIndex + this.templateIndex) + this.leftMargin;
    }

    @Override
    protected void writeTableDataElement(ReportElement elt, ReportTable table, ReportTableElement panel) throws Exception, IOException, MalformedURLException {
        if (RTFSubReport.toTwips(elt.getX()) + RTFSubReport.toTwips(elt.getWidth()) > this.reportWidth) {
            return;
        }
        super.writeTableDataElement(elt, table, panel);
    }

    @Override
    protected void writeSectionBgColor(ReportElement section) throws Exception {
        if (section.getBgColor() != null && !this.checkFitGroupOnPage) {
            ByteArrayOutputStream[] temp_templates = this.templates;
            int minX = (this.offsetX + this.elementXPos) % this.pageWidth;
            int availableWidth = this.pageWidth - minX;
            int maxX = availableWidth > this.reportWidth ? this.reportWidth + minX : this.pageWidth;
            ByteArrayOutputStream writer = temp_templates[0];
            writer.write(new StringBuffer(200).append("\\absw").append(maxX).append("\\absh").append(RTFSubReport.toTwips(section.getHeight())).append("\\phpg\\posx").append(this.leftMargin).append("\\pvpg\\posy").append(this.getAbsoluteY(this.elementYPos) - 1).append("\\shading10000\\cfpat").append(this.getColorIndex(section.getBgColor())).append("\\f0\\fs2\\par\\pard\n").toString().getBytes());
            int count = (int)Math.ceil((double)(this.offsetX + this.reportWidth + this.shift) / (double)this.pageWidth) - this.templateIndex;
            for (int i = 1; i < count - 1; ++i) {
                writer = temp_templates[i];
                writer.write(new StringBuffer(200).append("\\absw").append(this.pageWidth).append("\\absh").append(RTFSubReport.toTwips(section.getHeight())).append("\\phpg\\posx").append(this.leftMargin).append("\\pvpg\\posy").append(this.getAbsoluteY(this.elementYPos) - 1).append("\\shading10000\\cfpat").append(this.getColorIndex(section.getBgColor())).append("\\f0\\fs2\\par\\pard\n").toString().getBytes());
            }
            maxX = (this.offsetX + this.reportWidth + this.shift) % this.pageWidth;
            if (count > 1) {
                writer = temp_templates[count - 1];
                writer.write(new StringBuffer(200).append("\\absw").append(maxX).append("\\absh").append(RTFSubReport.toTwips(section.getHeight())).append("\\phpg\\posx").append(this.leftMargin).append("\\pvpg\\posy").append(this.getAbsoluteY(this.elementYPos) - 1).append("\\shading10000\\cfpat").append(this.getColorIndex(section.getBgColor())).append("\\f0\\fs2\\par\\pard\n").toString().getBytes());
            }
        }
    }

    @Override
    protected int writeRemainingSubReports(Vector remainingSubReports, Vector oneTime, Vector oneTimeY, ReportSection section, ReportTable tbl, ReportElement[] relts, int[] shifts) throws Exception {
        int bottomYOfSection = 0;
        while (remainingSubReports != null && remainingSubReports.size() > 0 || oneTime != null && oneTime.size() > 0) {
            this.elementYPos += 20;
            if (oneTime == null || this.elementYPos + this.bottomMargin >= this.pageHeight) {
                this.pageBreak(section);
            }
            bottomYOfSection = this.writeVisibleOneTimeElements(oneTime, oneTimeY, remainingSubReports, tbl, relts, shifts);
        }
        return bottomYOfSection;
    }

    void setParentSection(ReportSection parentSection, int myPageHeight) {
        this.parentSection = parentSection;
        if (parentSection == null) {
            return;
        }
        this.remainingSectionHeight = RTFReport.toTwips(parentSection.getHeight()) - (this.topMargin + myPageHeight - this.pageTopY);
        this.myPageHeight = myPageHeight;
    }

    void writeSectionColor() throws Exception {
        if (this.parentSection == null) {
            return;
        }
        int writeHeight = this.remainingSectionHeight;
        if (writeHeight > this.myPageHeight) {
            writeHeight = this.myPageHeight;
            this.remainingSectionHeight -= this.myPageHeight;
        } else {
            this.remainingSectionHeight = 0;
        }
        if (writeHeight > 0) {
            double d = this.parentSection.getHeight();
            this.parentSection.setHeight(RTFReport.toInch(writeHeight + this.topMargin));
            this.parent.writeSectionBgColor(this.parentSection);
            this.parentSection.setHeight(d);
        }
    }
}

