/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Vector;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SubReportUI;
import quadbase.reportdesigner.util.Dimension2D;
import quadbase.reportdesigner.util.internal.ImageData;
import quadbase.reportdesigner.util.rtf.RTFUtil;
import quadbase.util.internal.PNGJimiEncoder;

public class RTFUI
extends SubReportUI {
    private Vector lines;
    private ReportRTFObject rtfObject = null;
    private boolean firstLine = true;
    private int currentColumnCount = 1;
    double pageTopY = 0.0;
    private double bottomY = 0.0;
    private double trueCurY = 0.0;
    private boolean isAdjustFont = true;

    public RTFUI(ReportRTFObject rtfobject, Vector l, double x, double y, double w, double pHeight, ReportUI reportUI) throws Exception {
        super(null, x, y, w, pHeight, reportUI);
        if (pHeight < 0.0) {
            this.pageHeight = reportUI.pageHeight;
            this.multiPage = true;
        } else {
            this.pageHeight = pHeight;
        }
        this.parentSectionList = reportUI.sectionList;
        this.parentTableList = reportUI.tableList;
        this.parentTreeStructure = reportUI.treeStructure;
        this.pageSize = new Dimension2D(w, this.pageHeight);
        this.isAdjustFont = reportUI.report.isAdjustFont();
        this.rtfObject = rtfobject;
        this.curX = x;
        this.offsetY = y;
        this.pageTopY = y;
        this.curY = y;
        this.lines = l;
    }

    @Override
    public void draw(ReportGraphics rGraphics) throws Exception {
        Dimension2D dim;
        boolean exactPageBreakAtY = false;
        this.currentColumnCount = 1;
        for (int i = 0; i < this.lines.size(); ++i) {
            Vector segments = (Vector)this.lines.elementAt(i);
            int ascent = 0;
            int descent = 0;
            for (int j = 0; j < segments.size(); ++j) {
                Object[] seg = (Object[])segments.elementAt(j);
                if (seg[0] != null && seg[0] instanceof Image) {
                    int iHeight = (Integer)seg[2];
                    if (iHeight <= ascent) continue;
                    ascent = iHeight;
                    continue;
                }
                FontMetrics fontMetrics = this.getViewerFontMetrics((FontMetrics)seg[1], rGraphics);
                if (fontMetrics.getMaxAscent() <= ascent) continue;
                ascent = fontMetrics.getMaxAscent();
                descent = fontMetrics.getMaxDescent();
            }
            this.trueCurY = this.curY;
            if (exactPageBreakAtY) {
                this.curY -= this.toInch(ascent + descent) / 2.0;
            }
            exactPageBreakAtY = this.pageBreak(rGraphics, this.toInch(ascent + descent), null);
            this.curY += this.toInch(ascent);
            Dimension2D dim2 = rGraphics.getDimension(this.curX, this.curY, 0.0, 0.0);
            if (dim2 != null) {
                int sx = this.toPixel(dim2.getWidth());
                int sy = this.toPixel(dim2.getHeight());
                if (this.multiPage && this.currentColumnCount == 1) {
                    if (this.rtfObject.getBgColor() != null) {
                        rGraphics.g.setColor(this.rtfObject.getBgColor());
                        rGraphics.g.fillRect(sx, sy - ascent, this.toPixel(this.pageSize.getWidth()), ascent + descent);
                    }
                    if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                        int k;
                        int border = this.rtfObject.getBorderThickness();
                        if (this.firstLine) {
                            for (k = 0; k < border; ++k) {
                                rGraphics.g.setColor(this.rtfObject.getBorderColor());
                                rGraphics.g.drawLine(sx - border, sy - ascent - k, sx + this.toPixel(this.pageSize.getWidth()) + border - 1, sy - ascent - k);
                            }
                        }
                        for (k = 1; k <= border; ++k) {
                            rGraphics.g.setColor(this.rtfObject.getBorderColor());
                            rGraphics.g.drawLine(sx - k, sy - ascent, sx - k, sy + descent);
                            rGraphics.g.drawLine(sx + this.toPixel(this.pageSize.getWidth()) + k - 1, sy - ascent, sx + this.toPixel(this.pageSize.getWidth()) + k - 1, sy + descent);
                        }
                    }
                } else if (this.multiPage && this.currentColumnCount > 1 && this.toPixel(this.bottomY) < this.toPixel(this.curY) + descent) {
                    Dimension2D dim22 = rGraphics.getDimension(this.curX, this.bottomY, 0.0, 0.0);
                    int sx2 = this.toPixel(dim22.getWidth());
                    int sy2 = this.toPixel(dim22.getHeight());
                    if (this.rtfObject.getBgColor() != null) {
                        rGraphics.g.setColor(this.rtfObject.getBgColor());
                        rGraphics.g.fillRect(sx2, sy2, this.toPixel(this.pageSize.getWidth()), this.toPixel(this.curY) + descent - this.toPixel(this.bottomY));
                    }
                    if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                        int border = this.rtfObject.getBorderThickness();
                        for (int k = 1; k <= border; ++k) {
                            rGraphics.g.setColor(this.rtfObject.getBorderColor());
                            rGraphics.g.drawLine(sx2 - k, sy2, sx2 - k, sy2 + this.toPixel(this.curY) + descent - this.toPixel(this.bottomY));
                            rGraphics.g.drawLine(sx2 + this.toPixel(this.pageSize.getWidth()) + k - 1, sy2, sx2 + this.toPixel(this.pageSize.getWidth()) + k - 1, sy2 + this.toPixel(this.curY) + descent - this.toPixel(this.bottomY));
                        }
                    }
                } else if (i == 0) {
                    if (this.rtfObject.getBgColor() != null) {
                        rGraphics.g.setColor(this.rtfObject.getBgColor());
                        rGraphics.g.fillRect(sx, sy - ascent, this.toPixel(this.pageSize.getWidth()), this.toPixel(this.pageHeight));
                    }
                    if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                        rGraphics.g.setColor(this.rtfObject.getBorderColor());
                        rGraphics.drawRect(sx, sy - ascent, this.toPixel(this.pageSize.getWidth()), this.toPixel(this.pageHeight), this.rtfObject.getBorderThickness());
                    }
                }
                sx += this.toPixel((this.rtfObject.getColumnWidth() + this.rtfObject.getColumnSpacing()) * (double)(this.currentColumnCount - 1));
                sx = RTFUtil.getXForSingleRow(this.report, rGraphics.g, sx, this.toPixel(this.rtfObject.getWidth()), segments, this.rtfObject.getAlign());
                if (rGraphics.g instanceof IQbGraphics) {
                    Object[] res = new Object[segments.size()];
                    for (int j = 0; j < segments.size(); ++j) {
                        Object[] seg = (Object[])segments.elementAt(j);
                        if (seg[0] != null && seg[0] instanceof Image) {
                            Object[] img = new Object[3];
                            img[1] = seg[1];
                            img[2] = seg[2];
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            if (IOUtil.isJimiIncluded()) {
                                PNGJimiEncoder.createPNGImage((Image)seg[0], bout, 0);
                                img[0] = bout.toByteArray();
                            }
                            bout.close();
                            res[j] = img;
                            continue;
                        }
                        Object[] str = new Object[]{seg[0], this.getViewerFontMetrics((FontMetrics)seg[1], rGraphics).getFont(), seg[2], seg[3]};
                        res[j] = str;
                    }
                    ((IQbGraphics)((Object)rGraphics.g)).drawSegment(res, sx, sy);
                } else {
                    for (int j = 0; j < segments.size(); ++j) {
                        Object[] seg = (Object[])segments.elementAt(j);
                        if (seg[0] != null && seg[0] instanceof Image) {
                            int iWidth = (Integer)seg[1];
                            int iHeight = (Integer)seg[2];
                            ImageData idata = new ImageData(new URL("http://temp"), 1);
                            idata.setImage((Image)seg[0]);
                            MediaTracker tracker = new MediaTracker(ServerMessage.getComponent());
                            tracker.addImage((Image)seg[0], 0);
                            tracker.waitForID(0);
                            if (!tracker.isErrorID(0)) {
                                idata.draw(rGraphics.g, sx, sy - iHeight, iWidth, iHeight, ServerMessage.getComponent());
                            }
                            sx += iWidth;
                            continue;
                        }
                        FontMetrics fontMetrics = this.getViewerFontMetrics((FontMetrics)seg[1], rGraphics);
                        String text = (String)seg[0];
                        rGraphics.g.setFont(fontMetrics.getFont());
                        rGraphics.g.setColor((Color)seg[2]);
                        rGraphics.g.drawString(text, sx, sy);
                        int textwidth = (int)fontMetrics.getStringBounds(text, rGraphics.g).getWidth();
                        if (((Boolean)seg[3]).booleanValue()) {
                            rGraphics.g.drawLine(sx, sy + 1, sx + textwidth, sy + 1);
                        }
                        sx += textwidth;
                    }
                }
            }
            this.firstLine = false;
            this.curY += this.toInch(descent);
        }
        if (this.bottomY > this.curY) {
            this.curY = this.bottomY;
        }
        if ((dim = rGraphics.getDimension(this.curX, this.curY, 0.0, 0.0)) != null && this.multiPage && this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
            int sx = this.toPixel(dim.getWidth());
            int sy = this.toPixel(dim.getHeight());
            int border = this.rtfObject.getBorderThickness();
            for (int k = 0; k < border; ++k) {
                rGraphics.g.setColor(this.rtfObject.getBorderColor());
                rGraphics.g.drawLine(sx - border, sy - k, sx + this.toPixel(this.pageSize.getWidth()) + border - 1, sy - k);
            }
        }
        if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
            this.curY += this.toInch(this.rtfObject.getBorderThickness());
        }
    }

    @Override
    protected double getDrawablePageHeight() {
        return this.pageHeight;
    }

    @Override
    protected void setPrintOnNewPage(ReportGraphics g, ReportSection section) throws Exception {
        this.setPrintOnNewPage(g, section, true);
    }

    @Override
    protected void setPrintOnNewPage(ReportGraphics g, ReportSection section, boolean performRoundingCheck) throws Exception {
        int k;
        int border;
        int sy;
        int sx;
        Dimension2D dim;
        double tmp = this.curY % this.pageSize.getHeight();
        if (tmp > this.pageSize.getHeight() - 0.001 || tmp < 0.001) {
            return;
        }
        if (this.currentColumnCount < this.rtfObject.getActualColumnCount()) {
            if (this.curY > this.bottomY) {
                this.bottomY = this.curY;
            }
            this.curY = this.pageTopY;
            ++this.currentColumnCount;
            return;
        }
        if (!this.multiPage) {
            if (this.curY < this.bottomY) {
                this.curY = this.bottomY;
            }
            if (this.curY < this.trueCurY) {
                this.curY = this.trueCurY;
            }
            throw new Exception("Rich text field page break. " + this.curY);
        }
        if (!this.firstLine && this.rtfObject.isBorderClosed() && (dim = g.getDimension(this.curX, this.trueCurY > this.bottomY ? this.trueCurY : this.bottomY, 0.0, 0.0)) != null) {
            sx = this.toPixel(dim.getWidth());
            sy = this.toPixel(dim.getHeight());
            if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                border = this.rtfObject.getBorderThickness();
                for (k = 0; k < border; ++k) {
                    g.g.setColor(this.rtfObject.getBorderColor());
                    g.g.drawLine(sx - border, sy + k, sx + this.toPixel(this.pageSize.getWidth()) + border - 1, sy + k);
                }
            }
        }
        if ((tmp = this.curY % this.pageSize.getHeight()) <= this.pageSize.getHeight() - 0.001 && tmp >= 0.001) {
            this.incCurY(this.pageSize.getHeight() - tmp);
        }
        this.pageTopY = this.curY;
        this.currentColumnCount = 1;
        if (this.parentSectionList != null && this.parentSectionList.size() > 0) {
            this.drawParentRepeatSection(g, section);
        }
        if (!this.firstLine && this.rtfObject.isBorderClosed() && (dim = g.getDimension(this.curX, this.curY, 0.0, 0.0)) != null) {
            sx = this.toPixel(dim.getWidth());
            sy = this.toPixel(dim.getHeight());
            if (this.rtfObject.getBorderThickness() > 0 && this.rtfObject.getBorderColor() != null) {
                border = this.rtfObject.getBorderThickness();
                for (k = 1; k <= border; ++k) {
                    g.g.setColor(this.rtfObject.getBorderColor());
                    g.g.drawLine(sx - border, sy - k, sx + this.toPixel(this.pageSize.getWidth()) + border - 1, sy - k);
                }
            }
        }
    }

    private FontMetrics getViewerFontMetrics(FontMetrics fm, ReportGraphics rGraphics) {
        Font font = fm.getFont();
        return rGraphics.textG.getFontMetrics(QbUtil.resizeViewerFont(font, this.isAdjustFont));
    }
}

