/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.applet.Applet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.pak.PakFile;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.internal.CastUtil;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.HttpsIO;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.FilterInfo;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.report.PreprocInfo;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.XMLQueryResultSet;

public class ReadDataFile {
    private static final Logger LOGGER = Logger.getLogger(ReadDataFile.class.getName());
    InputStream inputstream;

    public DataInputStream getInputStream(FileInMemTable subFilesTable, String filename) throws Exception {
        return this.getInputStream(subFilesTable, filename, false);
    }

    public DataInputStream getInputStream(FileInMemTable subFilesTable, String filename, boolean readOnly) throws Exception {
        return this.getInputStream(subFilesTable, filename, readOnly, false);
    }

    public DataInputStream getInputStream(FileInMemTable subFilesTable, String filename, boolean readOnly, boolean isPageViewer) throws Exception {
        DataInputStream din;
        block22: {
            LOGGER.finest("Read data file: getInputStream: " + filename + ", subFilesTable is not null: " + (subFilesTable != null));
            if (subFilesTable != null) {
                LOGGER.finest("Read: file in mem table size: " + subFilesTable.size());
            }
            if (subFilesTable != null) {
                this.inputstream = Report.getSubFileStream(subFilesTable, filename);
                if (this.inputstream != null) {
                    return new DataInputStream(this.inputstream);
                }
            }
            Applet applet = ServerMessage.getApplet();
            String urlfile = filename;
            filename = filename.replace('\\', '/');
            try {
                if (applet != null && filename.startsWith(IOUtil.getCodeBase(applet)) || applet == null && (filename.startsWith("http://") || filename.startsWith("file://") || filename.startsWith("jar:"))) {
                    urlfile = urlfile.replaceAll(" ", "%20").replaceAll("%2526", "%26");
                    try {
                        this.inputstream = new URL(urlfile).openConnection().getInputStream();
                        din = new DataInputStream(this.inputstream);
                        break block22;
                    }
                    catch (Exception ex) {
                        LOGGER.finest("Failed to get data input stream, trying to get it from server");
                        return ReadDataFile.getFromServer(filename, false, null, null, null, 20876, readOnly);
                    }
                }
                if (filename.toLowerCase().startsWith("https")) {
                    try {
                        din = new DataInputStream(HttpsIO.getHttpsInputStream(filename));
                        break block22;
                    }
                    catch (Exception ex) {
                        LOGGER.finest("Failed to get data input stream, trying to get it from server");
                        return ReadDataFile.getFromServer(filename, false, null, null, null, 20876, readOnly);
                    }
                }
                if (filename.toLowerCase().startsWith("zip:")) {
                    PakFile pakFile = new PakFile(filename);
                    this.inputstream = pakFile.getInputStream();
                    din = new DataInputStream(this.inputstream);
                    break block22;
                }
                if (!ServerMessage.useServer && (ServerMessage.isLoadBalancer || isPageViewer)) {
                    if (OrgUtil.isReportData(filename)) {
                        return new DataInputStream(new ByteArrayInputStream(OrgUtil.getReportData(filename)));
                    }
                    if (OrgUtil.isDashboardData(filename)) {
                        return new DataInputStream(new ByteArrayInputStream(OrgUtil.getDashboardData(filename)));
                    }
                    if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                        if (applet != null) {
                            this.inputstream = new URL(IOUtil.getCodeBase(applet) + filename).openStream();
                            din = new DataInputStream(this.inputstream);
                        } else {
                            this.inputstream = IOUtil.createFileInputStream(filename);
                            din = new DataInputStream(this.inputstream);
                        }
                    } else {
                        this.inputstream = new FileInputStream(filename);
                        din = new DataInputStream(this.inputstream);
                    }
                    break block22;
                }
                return ReadDataFile.getFromServer(filename, false, null, null, null, 20876, readOnly);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to load file", ex);
                if (this.inputstream != null) {
                    try {
                        this.inputstream.close();
                    }
                    catch (Exception ex2) {
                        LOGGER.finest("Cannot close input stream");
                    }
                }
                throw ex;
            }
        }
        return din;
    }

    IResultSet createXMLResultSet(String filename) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String urlfile = filename;
        if ((filename = filename.replace('\\', '/')).startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
            return this.createXMLResultSetInstance(new Class[]{String.class}, new Object[]{urlfile});
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    return this.createXMLResultSetInstance(new Class[]{String.class}, new Object[]{IOUtil.getCodeBase(applet) + filename});
                }
                return this.createXMLResultSetInstance(new Class[]{File.class}, new Object[]{IOUtil.createFile(filename)});
            }
            return this.createXMLResultSetInstance(new Class[]{File.class}, new Object[]{new File(filename)});
        }
        return this.createXMLResultSetInstance(new Class[]{InputStream.class}, new Object[]{this.getInputStream(null, filename)});
    }

    public IOLAPResultSet createMondrianResultSetInstance(String connectionString, String MDXQuery) throws Exception {
        Class[] argsClass = new Class[]{String.class, String.class};
        Object[] argsValue = new Object[]{connectionString, MDXQuery};
        Class<?> objClass = Class.forName("quadbase.common.OLAP.MondrianResultSet");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        return (IOLAPResultSet)objCons.newInstance(argsValue);
    }

    public IOLAPResultSet createXMLAResultSetInstance(String uri, String datasource, String catalog, String MDXQuery) throws Exception {
        Class[] argsClass = new Class[]{String.class, String.class, String.class, String.class};
        Object[] argsValue = new Object[]{uri, datasource, catalog, MDXQuery};
        Class<?> objClass = Class.forName("quadbase.common.OLAP.XMLAResultSet");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        return (IOLAPResultSet)objCons.newInstance(argsValue);
    }

    private IResultSet createXMLResultSetInstance(Class[] argsClass, Object[] argsValue) throws Exception {
        Class<?> objClass = Class.forName("quadbase.reportdesigner.util.XMLResultSet");
        Constructor<?> objCons = objClass.getConstructor(argsClass);
        return (IResultSet)objCons.newInstance(argsValue);
    }

    IResultSet createXMLQueryResultSet(XMLFileQueryInfo xmlInfo) throws Exception {
        Applet applet = ServerMessage.getApplet();
        String filename = xmlInfo.getFileName();
        byte[] data = xmlInfo.getData();
        if (data != null) {
            return new XMLQueryResultSet(new ByteArrayInputStream(data), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getInSet());
        }
        String urlfile = filename;
        if ((filename = filename.replace('\\', '/')).startsWith("http://") || filename.startsWith("https://") || filename.startsWith("file://")) {
            xmlInfo.setFileName(urlfile);
            return new XMLQueryResultSet(xmlInfo);
        }
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (!filename.startsWith("/") && filename.indexOf(58) < 0) {
                if (applet != null) {
                    xmlInfo.setFileName(IOUtil.getCodeBase(applet) + filename);
                    return new XMLQueryResultSet(xmlInfo);
                }
                return new XMLQueryResultSet(IOUtil.createFile(filename), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet());
            }
            xmlInfo.setFileName(filename);
            return new XMLQueryResultSet(xmlInfo);
        }
        return new XMLQueryResultSet(this.getInputStream(null, filename), xmlInfo.getFieldInfo(), xmlInfo.getCondition(), xmlInfo.getConditionInfo(), xmlInfo.getDTDName(), xmlInfo.isVerify(), xmlInfo.getInSet());
    }

    IResultSet getClassResultSet(String className) throws Exception {
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            Class<?> objClass = null;
            Constructor<?> objCons = null;
            Object resultSetClass = null;
            try {
                objClass = Class.forName(className);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Class not found: " + className, ex);
                throw new Exception(className + " not found!");
            }
            try {
                objCons = objClass.getConstructor(new Class[0]);
                resultSetClass = objCons.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot create class: " + className, ex);
                throw new Exception("Cannot create " + className + "!");
            }
            try {
                Method objMethod = objClass.getMethod("getResultSet", new Class[0]);
                Object obj = objMethod.invoke(resultSetClass, new Object[0]);
                if (obj instanceof IResultSet) {
                    return (IResultSet)obj;
                }
                return CastUtil.cast((quadbase.util.IResultSet)obj);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot get result set", ex);
                throw new Exception("Cannot execute getResultSet()!");
            }
        }
        DataInputStream din = ReadDataFile.getFromServer(className, false, null, null, null, 32415, false, 6);
        return ColData.getResultSet(DataFileInput.getColDataFromStream(din));
    }

    public void close() throws Exception {
        if (this.inputstream != null) {
            this.inputstream.close();
        }
    }

    private static DataInputStream getFromServer(String file, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int messageType, boolean readOnly) throws Exception {
        return ReadDataFile.getFromServer(file, isTransposed, transposeCol, filterInfo, procInfo, messageType, readOnly, 2);
    }

    private static DataInputStream getFromServer(String file, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int messageType, boolean readOnly, int dataType) throws Exception {
        return ReadDataFile.getFromServer(file, isTransposed, transposeCol, filterInfo, procInfo, messageType, readOnly, null, dataType, null);
    }

    static DataInputStream getFromServer(String file, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int messageType, boolean readOnly, XMLFileQueryInfo xmlInfo, int dataType, String encoding) throws Exception {
        byte[] indata;
        LOGGER.finest("Read data file: getFromServer: " + file);
        file = file.replace('\\', '/');
        if (messageType == 20876 && readOnly) {
            messageType = 28931;
        }
        IConnection socket = ServerMessage.createConnection();
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(messageType);
        if (messageType == 20876 || messageType == 25578) {
            dout.writeBoolean(false);
        }
        IOUtil.writeString(dout, file);
        if (messageType != 20876 && messageType != 28931 && messageType != 25578) {
            if (messageType == 32415 || messageType == 24327) {
                dout.writeBoolean(isTransposed);
                IOUtil.writeBooleans(dout, transposeCol);
                dout.writeBoolean(procInfo != null);
                if (procInfo != null) {
                    procInfo.writeAsStream(dout);
                }
                dout.writeInt(dataType);
                dout.writeBoolean(false);
                IOUtil.writeStr(dout, "");
                IOUtil.writeStr(dout, encoding);
                if (messageType == 24327) {
                    xmlInfo.write(dout);
                }
            } else if (messageType == 28816) {
                dout.writeBoolean(isTransposed);
                IOUtil.writeBooleans(dout, transposeCol);
                dout.writeBoolean(filterInfo != null);
                if (filterInfo != null) {
                    filterInfo.writeAsStream(dout);
                }
                dout.writeBoolean(procInfo != null);
                if (procInfo != null) {
                    procInfo.writeAsStream(dout);
                }
                dout.writeInt(dataType);
                IOUtil.writeStr(dout, encoding);
            }
        }
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to write data", ex);
            socket.close();
            throw ex;
        }
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
            try {
                if (readOnly) {
                    IOUtil.releaseFileLock(file);
                }
            }
            catch (Exception excep) {
                LOGGER.log(Level.FINEST, "Failed to release file lock", excep);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot get response from server", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Cannot get response from server", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
        return new DataInputStream(new ByteArrayInputStream(indata));
    }

    public static DataInput getFromServer(String className, boolean isTransposed, boolean[] transposeCol, FilterInfo filterInfo, PreprocInfo procInfo, int startIndex, int displayRow, QueryInParamSet paramSet) throws Exception {
        IConnection socket = null;
        try {
            socket = ServerMessage.createConnection();
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(1024);
            DataOutputStream out = new DataOutputStream(bstream);
            out.writeShort(25333);
            out.writeInt(2);
            IOUtil.writeString(out, className);
            out.writeBoolean(true);
            out.writeBoolean(isTransposed);
            IOUtil.writeBooleans(out, transposeCol);
            out.writeBoolean(filterInfo != null);
            if (filterInfo != null) {
                filterInfo.writeAsStream(out);
            }
            out.writeBoolean(procInfo != null);
            if (procInfo != null) {
                procInfo.writeAsStream(out);
            }
            out.writeInt(startIndex);
            out.writeInt(displayRow);
            out.writeBoolean(paramSet != null);
            if (paramSet != null) {
                paramSet.write(out);
            }
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int len = dstream.readInt();
            byte[] indata = new byte[len];
            dstream.readFully(indata, 0, len);
            dstream.close();
            socket.close();
            return new DataInputStream(new ByteArrayInputStream(indata));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to read data from server", ex);
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            try {
                LOGGER.log(Level.FINEST, "Failed to read data from server", err);
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
    }
}

