/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DBAccess;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.EJBAccess;
import quadbase.reportdesigner.report.ExcelAccess;
import quadbase.reportdesigner.report.OLAPAccess;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SOAPAccess;
import quadbase.reportdesigner.report.SalesForceAccess;
import quadbase.reportdesigner.report.TransformQuery;

public class ReloadReport {
    private static final Logger LOGGER = Logger.getLogger(ReloadReport.class.getName());

    public static ColData[] getOriginalColData(Report report, boolean useDBbuffer) {
        return ReloadReport.getOriginalColData(report, useDBbuffer, 0, -1);
    }

    public static ColData[] getOriginalColData(Report report, boolean useDBbuffer, int startIndex, int displayRow) {
        ColData[] colData;
        block30: {
            colData = null;
            try {
                if (report.sourceData == 2) {
                    colData = new DataFileInput().readProcessedData(report.sourceFile, report.isTransposed(), report.getTransposeColumn(), null);
                    break block30;
                }
                if (report.sourceData == 4) {
                    colData = new DataFileInput().readProcessedData(report.sourceFile, report.isTransposed(), report.getTransposeColumn(), null, 4);
                    break block30;
                }
                if (report.sourceData == 7) {
                    colData = new DataFileInput().readProcessedData(report.sourceFile, report.isTransposed(), report.getTransposeColumn(), null, null, 0, -1, report.getXMLFileQueryInfo(), 7);
                    break block30;
                }
                if (report.sourceData == 6) {
                    colData = report.sourceData == 6 && report.dbInfo != null && report.dbInfo instanceof QueryClassFileInfo ? new DataFileInput().readProcessedData(report.sourceFile, report.isTransposed(), report.getTransposeColumn(), null, null, startIndex, report.reportType == 2 ? -1 : displayRow, ((QueryFileInfo)report.dbInfo).getInSet()) : new DataFileInput().readProcessedData(report.sourceFile, report.isTransposed(), report.getTransposeColumn(), null, 6);
                    break block30;
                }
                if (report.sourceData == 9) {
                    throw new Exception(LanguageEncoder.getText("Cannot reload report with the old SOAP data source. Please update your datasource."));
                }
                if (report.sourceData == 12) {
                    colData = SOAPAccess.retrieveResult(report.soapInfo);
                    break block30;
                }
                if (report.sourceData == 11) {
                    colData = SalesForceAccess.getColData(report.sfQueryInfo);
                    break block30;
                }
                if (report.sourceData == 13) {
                    colData = ExcelAccess.getColData(report.excelInfo, report.isTransposed, report.transposeCol);
                    break block30;
                }
                if (report.sourceData == 10) {
                    OLAPAccess olapAccess = new OLAPAccess(report.olapRS, report.mondrianConnectionString, report.MDXQuery, report.xmlaURI, report.xmlaDataSource, report.xmlaCatalog);
                    colData = olapAccess.retrieveResult(report.reportType);
                    report.rowBreakAggrIncluded = olapAccess.isRowBreakAggrIncluded(report.rowBreakAggrIncluded);
                    report.colBreakAggrIncluded = olapAccess.isColBreakAggrIncluded(report.colBreakAggrIncluded);
                    break block30;
                }
                if (report.sourceData == 5) {
                    colData = EJBAccess.retrieveResult(report.jndiName, report.homeName, report.remoteName, report.selectedMethodName, report.selectedMethodParamVal, report.environment);
                    break block30;
                }
                if (report.sourceData == 1) {
                    Vector<QueryInParamSet> params = null;
                    if (!(report.isKeepDataSourceOrder() || report.reportType != 1 && report.reportType != 2 && report.reportType != 3 || report.isTransposed())) {
                        int j;
                        String originalQuery;
                        block31: {
                            originalQuery = report.dbInfo.getQuery();
                            report.dbInfo.setQuery(TransformQuery.transform(originalQuery, report.colInfo));
                            report.colDataSorted = false;
                            if (report.dbInfo instanceof QueryFileInfo) {
                                params = new Vector();
                                params.addElement(((QueryFileInfo)report.dbInfo).getInSet());
                            }
                            try {
                                colData = report.reportType == 2 ? DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, false, null, null, null, report.isForExportOnly()) : DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, false, null, null, null, startIndex, displayRow, report.isForExportOnly());
                                report.colDataSorted = true;
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINEST, "Failed to get data from database", ex);
                                if (!ex.getMessage().equals("No result set return !")) break block31;
                                for (ColData cdata : colData = report.colData) {
                                    for (j = cdata.getSize() - 1; j >= 0; --j) {
                                        cdata.removeData(j);
                                    }
                                }
                            }
                        }
                        report.dbInfo.setQuery(originalQuery);
                        if (report.colDataSorted) break block30;
                        try {
                            colData = DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, false, null, null, null, startIndex, displayRow, report.isForExportOnly());
                            break block30;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINEST, "Failed to get data from database", ex);
                            if (ex.getMessage().equals("No result set return !")) {
                                for (ColData cdata : colData = report.colData) {
                                    for (j = cdata.getSize() - 1; j >= 0; --j) {
                                        cdata.removeData(j);
                                    }
                                }
                                break block30;
                            }
                            throw ex;
                        }
                    }
                    if (report.dbInfo instanceof QueryFileInfo) {
                        params = new Vector<QueryInParamSet>();
                        params.addElement(((QueryFileInfo)report.dbInfo).getInSet());
                    }
                    try {
                        colData = DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, report.isTransposed(), report.getTransposeColumn(), null, null, startIndex, report.reportType == 2 ? -1 : displayRow, report.isForExportOnly());
                        break block30;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to get data from database", ex);
                        if (ex.getMessage().equals("No result set return !")) {
                            for (ColData cdata : colData = report.colData) {
                                for (int j = cdata.getSize() - 1; j >= 0; --j) {
                                    cdata.removeData(j);
                                }
                            }
                            break block30;
                        }
                        throw ex;
                    }
                }
                colData = report.sourceData == 3 ? ColData.getColData(report.sourceList, report.sourceType, report.doTranspose, report.transposeColList, report.isTransposed(), report.getTransposeColumn(), useDBbuffer) : report.originalColDataFromMemSource;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to get original column data", ex);
                throw new IllegalArgumentException("Failed to load data " + ex.getMessage());
            }
        }
        return colData;
    }

    public static Report reloadData(Report report, boolean useDBbuffer) throws Exception {
        return ReloadReport.reloadData(report, useDBbuffer, null, 0, -1);
    }

    public static Report reloadData(Report report, boolean useDBbuffer, Object[] parameters, int startIndex, int displayRow) throws Exception {
        return ReloadReport.reloadData(report, useDBbuffer, parameters, startIndex, displayRow, false);
    }

    public static Report reloadData(Report report, boolean useDBbuffer, Object[] parameters, int startIndex, int displayRow, boolean fromDesignerDesignMode) throws Exception {
        Report newreport = null;
        ColData[] colData = null;
        try {
            LOGGER.finer("Getting new report data started");
            long start = System.currentTimeMillis();
            if (report.sourceData == 2 || report.sourceData == 4 || report.sourceData == 7 || report.sourceData == 6) {
                if (report.sourceData == 6 && report.dbInfo != null && report.dbInfo instanceof QueryClassFileInfo) {
                    if (parameters != null) {
                        QueryInParam[] qip = ((QueryFileInfo)report.dbInfo).getInSet().getParameter();
                        for (int i = 0; i < qip.length; ++i) {
                            if (i >= parameters.length || parameters[i] == null) continue;
                            qip[i].setValue(parameters[i]);
                        }
                    }
                    colData = new DataFileInput().readProcessedData(report.sourceFile, report.isTransposed(), report.getTransposeColumn(), null, null, startIndex, report.reportType == 2 ? -1 : displayRow, ((QueryFileInfo)report.dbInfo).getInSet());
                } else {
                    try {
                        String sourceFile = report.sourceFile;
                        colData = new DataFileInput().readProcessedData(sourceFile, report.isTransposed(), report.getTransposeColumn(), null, null, startIndex, report.reportType == 2 ? -1 : displayRow, report.getXMLFileQueryInfo(), report.sourceData);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to load data", ex);
                        IOException ex2 = new IOException("Failed to load data " + ex.getMessage());
                        report.setInitializeReportError(IOUtil.getStackTrace(ex2));
                        throw ex2;
                    }
                }
            } else {
                if (report.sourceData == 5) {
                    try {
                        colData = EJBAccess.retrieveResult(report.jndiName, report.homeName, report.remoteName, report.selectedMethodName, report.selectedMethodParamVal, report.environment);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINEST, "Failed to load data from EJB", e);
                        IOException ex2 = new IOException("Failed to load data from EJB component " + e.getMessage());
                        report.setInitializeReportError(IOUtil.getStackTrace(ex2));
                        throw ex2;
                    }
                }
                if (report.sourceData == 10) {
                    OLAPAccess olapAccess = new OLAPAccess(report.olapRS, report.mondrianConnectionString, report.MDXQuery, report.xmlaURI, report.xmlaDataSource, report.xmlaCatalog);
                    colData = olapAccess.retrieveResult(report.reportType);
                    report.rowBreakAggrIncluded = olapAccess.isRowBreakAggrIncluded(report.rowBreakAggrIncluded);
                    report.colBreakAggrIncluded = olapAccess.isColBreakAggrIncluded(report.colBreakAggrIncluded);
                } else {
                    if (report.sourceData == 9) {
                        throw new Exception(LanguageEncoder.getText("Cannot reload report with the old SOAP data source. Please update your datasource."));
                    }
                    if (report.sourceData == 12) {
                        try {
                            colData = SOAPAccess.retrieveResult(report.soapInfo);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINEST, "Failed to load data from SOAP", e);
                            IOException ex2 = new IOException("Failed to load data from SOAP service\n" + e.getMessage());
                            report.setInitializeReportError(IOUtil.getStackTrace(ex2));
                            throw ex2;
                        }
                    }
                    if (report.sourceData == 11) {
                        try {
                            colData = SalesForceAccess.getColData(report.sfQueryInfo);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINEST, "Failed to load data from SalesForce", e);
                            IOException ex2 = new IOException("Failed to load data from SalesForce\n" + e.getMessage());
                            report.setInitializeReportError(IOUtil.getStackTrace(ex2));
                            throw ex2;
                        }
                    }
                    if (report.sourceData == 13) {
                        try {
                            colData = ExcelAccess.getColData(report.excelInfo, report.isTransposed, report.transposeCol);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINEST, "Failed to load data from Excel", e);
                            IOException ex2 = new IOException("Failed to load data from Excel\n" + e.getMessage());
                            report.setInitializeReportError(IOUtil.getStackTrace(ex2));
                            throw ex2;
                        }
                    }
                    if (report.sourceData == 1) {
                        Vector<QueryInParamSet> params = null;
                        if (!(report.isKeepDataSourceOrder() || report.reportType != 1 && report.reportType != 2 && report.reportType != 3 || report.isTransposed())) {
                            int j;
                            String originalQuery;
                            block56: {
                                originalQuery = report.dbInfo.getQuery();
                                report.dbInfo.setQuery(TransformQuery.transform(originalQuery, report.colInfo));
                                report.colDataSorted = false;
                                if (report.dbInfo instanceof QueryFileInfo) {
                                    if (parameters != null) {
                                        QueryInParam[] qip = ((QueryFileInfo)report.dbInfo).getInSet().getParameter();
                                        for (int i = 0; i < qip.length; ++i) {
                                            if (i >= parameters.length || parameters[i] == null) continue;
                                            qip[i].setValue(parameters[i]);
                                        }
                                    }
                                    params = new Vector();
                                    params.addElement(((QueryFileInfo)report.dbInfo).getInSet());
                                }
                                try {
                                    colData = report.reportType == 2 ? DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, false, null, null, null, startIndex, -1, report.isForExportOnly()) : DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, false, null, null, null, startIndex, displayRow, report.isForExportOnly());
                                    report.colDataSorted = true;
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.FINEST, "Failed to get data from database", ex);
                                    if (!ex.getMessage().equals("No result set return !")) break block56;
                                    for (ColData cdata : colData = report.colData) {
                                        for (j = cdata.getSize() - 1; j >= 0; --j) {
                                            cdata.removeData(j);
                                        }
                                    }
                                }
                            }
                            report.dbInfo.setQuery(originalQuery);
                            if (!report.colDataSorted) {
                                try {
                                    colData = DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, false, null, null, null, startIndex, displayRow, report.isForExportOnly());
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.FINEST, "Failed to get data from database", ex);
                                    if (ex.getMessage().equals("No result set return !")) {
                                        for (ColData cdata : colData = report.colData) {
                                            for (j = cdata.getSize() - 1; j >= 0; --j) {
                                                cdata.removeData(j);
                                            }
                                        }
                                    }
                                    report.setInitializeReportError(IOUtil.getStackTrace(ex));
                                    throw ex;
                                }
                            }
                        } else {
                            if (report.dbInfo instanceof QueryFileInfo) {
                                if (parameters != null) {
                                    QueryInParam[] qip = ((QueryFileInfo)report.dbInfo).getInSet().getParameter();
                                    for (int i = 0; i < qip.length; ++i) {
                                        if (i >= parameters.length || parameters[i] == null) continue;
                                        qip[i].setValue(parameters[i]);
                                    }
                                }
                                params = new Vector<QueryInParamSet>();
                                params.addElement(((QueryFileInfo)report.dbInfo).getInSet());
                            }
                            try {
                                QueryInParamSet inSet;
                                if (params != null && (inSet = (QueryInParamSet)params.elementAt(0)) != null) {
                                    QueryInParam[] inParam;
                                    for (QueryInParam element : inParam = inSet.getParameter()) {
                                        if (element instanceof QueryMultiValueInParam) {
                                            if (((QueryMultiValueInParam)element).getValues() != null) continue;
                                            Exception ex1 = new Exception("No result set return !");
                                            report.setInitializeReportError(IOUtil.getStackTrace(ex1));
                                            throw ex1;
                                        }
                                        if (element.getValue() != null) continue;
                                        Exception ex2 = new Exception("No result set return !");
                                        report.setInitializeReportError(IOUtil.getStackTrace(ex2));
                                        throw ex2;
                                    }
                                }
                                colData = DBAccess.retrieveResult(params, report.dbInfo, useDBbuffer, report.isTransposed(), report.getTransposeColumn(), null, null, startIndex, report.getReportType() == 2 ? -1 : displayRow, report.isForExportOnly());
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINEST, "Failed to get data from database", ex);
                                if ("No result set return !".equals(ex.getMessage())) {
                                    for (ColData cdata : colData = report.colData) {
                                        for (int j = cdata.getSize() - 1; j >= 0; --j) {
                                            cdata.removeData(j);
                                        }
                                    }
                                }
                                report.setInitializeReportError(IOUtil.getStackTrace(ex));
                                throw ex;
                            }
                        }
                    } else if (report.sourceData == 3) {
                        colData = ColData.getColData(report.sourceList, report.sourceType, report.doTranspose, report.transposeColList, false, null, useDBbuffer);
                        colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(colData), false, report.isTransposed(), report.getTransposeColumn(), null, null), startIndex, displayRow);
                    } else {
                        if (report.originalColDataFromMemSource == null) {
                            report.originalColDataFromMemSource = report.colData;
                        }
                        colData = ColData.getColData(DBAccess.processResultSet(ColData.getResultSet(report.originalColDataFromMemSource), false, report.isTransposed(), report.getTransposeColumn(), null, null));
                    }
                }
            }
            LOGGER.finer("Getting new report data finished in " + (System.currentTimeMillis() - start) + " ms");
            LOGGER.finer("Rebuilding report started");
            start = System.currentTimeMillis();
            newreport = ReloadReport.doReload(colData, report, fromDesignerDesignMode);
            LOGGER.finer("Rebuilding report finished in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to reload data", e);
            report.setInitializeReportError(IOUtil.getStackTrace(e));
            throw e;
        }
        return newreport;
    }

    private static Report doReload(ColData[] colData, Report report, boolean fromDesignerDesignMode) throws Exception {
        return report.setNewData(colData, report.colInfo, report.reportType, report.colDataSorted, fromDesignerDesignMode);
    }
}

