/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Chart;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.param.FormulaParam;
import quadbase.common.param.MergeParameters;
import quadbase.common.param.OrderedParameterSet;
import quadbase.common.param.Param;
import quadbase.common.param.ParameterPage;
import quadbase.common.param.Parameters;
import quadbase.common.param.QueryParam;
import quadbase.common.param.ReportParameterPage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.IAlertable;
import quadbase.common.util.IOLAPResultSet;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.ReplaceColumnInfo;
import quadbase.common.util.internal.CopyFile;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.DeleteFile;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.QbFileOutputStream;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.RenameFile;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.CBColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.designer.ReportStyle;
import quadbase.reportdesigner.designer.ReportStyle2;
import quadbase.reportdesigner.designer.ReportStyle4;
import quadbase.reportdesigner.report.CSVReport;
import quadbase.reportdesigner.report.CSVReportColumnar;
import quadbase.reportdesigner.report.CSVReportCrossTab;
import quadbase.reportdesigner.report.CSVReportMasterDetails;
import quadbase.reportdesigner.report.CSVReportSummary;
import quadbase.reportdesigner.report.CellAttrAssignStmt;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColumnarTable;
import quadbase.reportdesigner.report.CrossTabTable;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.DHTMLReportColumnar;
import quadbase.reportdesigner.report.DHTMLReportCrossTab;
import quadbase.reportdesigner.report.DHTMLReportMasterDetails;
import quadbase.reportdesigner.report.DHTMLReportSummary;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.ERStatement;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.IfStatement;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.LoadReportStyle;
import quadbase.reportdesigner.report.MailingLabelsTable;
import quadbase.reportdesigner.report.MasterDetailsTable;
import quadbase.reportdesigner.report.NewFormulaParser;
import quadbase.reportdesigner.report.PDFReport;
import quadbase.reportdesigner.report.PDFReportColumnar;
import quadbase.reportdesigner.report.PDFReportCrossTab;
import quadbase.reportdesigner.report.PDFReportMasterDetails;
import quadbase.reportdesigner.report.PDFReportSummary;
import quadbase.reportdesigner.report.PageReport;
import quadbase.reportdesigner.report.PaginationSettings;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.RTFReport;
import quadbase.reportdesigner.report.RTFReportColumnar;
import quadbase.reportdesigner.report.RTFReportCrossTab;
import quadbase.reportdesigner.report.RTFReportMasterDetails;
import quadbase.reportdesigner.report.RTFReportSummary;
import quadbase.reportdesigner.report.ReportAlertObject;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.report.SummaryTable;
import quadbase.reportdesigner.report.TransformQuery;
import quadbase.reportdesigner.report.WhileStatement;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.report.XMLReport;
import quadbase.reportdesigner.report.XMLReportPureData;
import quadbase.reportdesigner.report.XMLReportPureDataExport;
import quadbase.reportdesigner.report.excel.ExcelReport;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.ICustomDefinedFunctions;
import quadbase.reportdesigner.util.IDynamicImageURLGenerator;
import quadbase.reportdesigner.util.IDynamicReportKeyGenerator;
import quadbase.reportdesigner.util.IExportThreadListener;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.IHTMLLinksProvider;
import quadbase.reportdesigner.util.IQueryMultiValueInParam;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.IReportTypeConstants;
import quadbase.reportdesigner.util.IResultSet;
import quadbase.reportdesigner.util.IStringCustomizer;
import quadbase.reportdesigner.util.ISubReport;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.ReplaceColumnInfoList;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class Report
implements IReportTypeConstants,
IReport,
IAlertable {
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final String httpsProtocol = "https://";
    public static final String httpProtocol = "http://";
    public static final String MAIN_REPORT = "MAIN_REPORT";
    public static final String Main_Report = "Main_Report";
    private static final Logger LOGGER = Logger.getLogger(Report.class.getName());
    public static boolean applyChartPathToAllCharts = false;
    public static boolean Excel_fitCell = false;
    public static boolean Excel_streaming = false;
    public static boolean Excel_NonNumericFitCell = false;
    public static int Excel_window_size = 100;
    private static ICustomDefinedFunctions customFunctions = null;
    private static int inputDataBlockSize = 10000;
    private static Boolean staticExport = null;
    private static boolean useSubReportCache = true;
    private static ReplaceColumnInfoList replaceColInfoList = null;
    public int reportType = 0;
    public int topN;
    public boolean ascending = true;
    public boolean crossTabFreeForm = true;
    public ColInfo[] colInfo;
    public ColInfo[] breakColInfo;
    public int[] breakColIndex;
    public ColData[] colData;
    public int sourceData;
    public IOLAPResultSet olapRS;
    public String mondrianConnectionString = "";
    public String MDXQuery = "";
    public String xmlaURI = "";
    public String xmlaDataSource = "";
    public String xmlaCatalog = "";
    public boolean[] rowBreakAggrIncluded = null;
    public boolean[] colBreakAggrIncluded = null;
    public boolean isTransposed = false;
    public boolean[] transposeCol;
    public DBInfoBasic dbInfo;
    public Vector parameters;
    public String queryFilename;
    public String sourceFile;
    public String sourceFileEncoding = null;
    public String jndiName;
    public String homeName;
    public String remoteName;
    public String selectedMethodName;
    public Object[] selectedMethodParamVal;
    public Hashtable<String, String> environment;
    public SOAPQueryFileInfo soapInfo;
    public SalesForceQueryFileInfo sfQueryInfo;
    public ExcelFileInfo excelInfo;
    public XMLFileQueryInfo xmlFileQueryInfo;
    public String xmlCondition;
    public Object[] sourceList;
    public int[] sourceType;
    public boolean[] doTranspose;
    public Object[] transposeColList;
    public ColData[] originalColDataFromMemSource = null;
    public IResultSet originalIResultSet = null;
    public Object[] distColValue = null;
    public boolean colDataSorted;
    public int[] recIndex;
    public ReportCell labelSetting;
    public ReportChartObject chartSetting;
    public ReportImage imageSetting;
    public ReportLine lineSetting;
    public ReportGrid gridSetting;
    public ColumnHeader columnHeaderSetting;
    public ReportTitle titleSetting;
    public ReportCell stringFormulaSetting;
    public ReportCell logicFormulaSetting;
    public ReportCell numericFormulaSetting;
    public ReportCell timeFormulaSetting;
    public ReportColumn stringColumnSetting;
    public ReportColumn logicColumnSetting;
    public ReportColumn numericColumnSetting;
    public ReportColumn timeColumnSetting;
    public ReportColumn barcodeColumnSetting;
    public ReportCell[] formula = new ReportCell[4];
    public ReportColumn[] column = new ReportColumn[5];
    public String serverName = "127.0.0.1";
    public String protocol = "http://";
    public int servletRunnerPort = 8080;
    public DrillDownNode currentNode = null;
    public DrillDownNode parentNode = null;
    public DrillDownNode rootNode = null;
    public Vector<SubReportObject> subReports = null;
    public Report[] subReportArray = null;
    public boolean modified = false;
    public ColumnWrap columnWrap = null;
    public Vector<Formula> formulas = new Vector();
    public Vector<Script> scripts = new Vector();
    public boolean showFormulaNameSelected = false;
    public Vector<Parameter> formulaParameters = new Vector();
    public Vector<Parameter> queryParameters = new Vector();
    public Hashtable<String, Parameter[]> subQueryParamTable = null;
    public Hashtable<String, Parameter[]> subFormulaParamTable = null;
    public boolean hasTitle;
    public boolean hasLogo;
    public boolean hasPageNumber;
    public boolean hasDate;
    public String reportTitle;
    public String logofile;
    public int logoPos;
    public int pageNumberFormat;
    public int pageNumberPos;
    public int dateFormat;
    public int datePos;
    public int reportStyle = -1;
    public String customStyleFile = null;
    public Vector<GuideLine> vGuideLines = null;
    public Vector<GuideLine> hGuideLines = null;
    public boolean allowPreviewEdit = false;
    public boolean snapToGrid = true;
    public double gridStepSize = 0.1;
    public double cmGridStepSize = 0.25;
    public String registryID;
    public String dataSourceID;
    public String dataSourceLoc;
    public boolean saveAllData;
    public boolean autoDelete = true;
    public boolean showCellOutline = true;
    public Vector<String> exportedFiles = new Vector();
    public String domainPath = "";
    public boolean limitSubReportQueryExecution = false;
    public boolean isPrevParamPrompt = true;
    public SubReportObject subReportObject = null;
    public boolean useBackupData = false;
    public boolean drawBeforeDisplay = false;
    protected QueryFileInfo queryFileInfo;
    ColInfo[] valColInfo;
    int[] masterIndex;
    int[] breakColValueIndex;
    int originalSourceData;
    boolean isDynamicExport = false;
    int dynamicExportTimeout = -1;
    boolean isAdjustFont = true;
    Hashtable<String, String> fontMapping = new Hashtable();
    String HTMLTarget = "_top";
    private String name = "";
    private String initializeReportError = null;
    private ReportSection pageHeader = new ReportSection("PG_HDR");
    private ReportSection reportHeader = new ReportSection("RPT_HDR");
    private Vector<ReportTable> reportTables = new Vector();
    private ReportSection reportFooter = new ReportSection("RPT_FTR");
    private ReportSection pageFooter = new ReportSection("PG_FTR");
    private boolean sideBySideLayout = false;
    private boolean reOrderColumns = true;
    private boolean showRowAggregationGrandTotal = true;
    private boolean showColumnAggregation = true;
    private boolean columnAggregationInHeader = false;
    private boolean showRowAggregationSubtotal = true;
    private boolean rowAggregationGrandTotalOnLeft = false;
    private boolean rowAggregationSubtotalOnLeft = false;
    private boolean alignCrossTabColBkValHori = true;
    private int orientation = 0;
    private double pageWidth = 8.5;
    private double pageHeight = 11.0;
    private double leftMargin = 0.5;
    private double rightMargin = 0.5;
    private double topMargin = 0.5;
    private double bottomMargin = 0.5;
    private double dhtmlTopMargin = 0.0;
    private boolean dhtmlTopMarginRepeatOnEveryPage = false;
    private boolean doAggregation = false;
    private int columnBreakCount = 0;
    private int columnBreakValueCount = 0;
    private boolean keepDataSourceOrder = false;
    private TimeZone timeZone;
    private Locale locale;
    private String nullDataOption = "Null";
    private boolean isApplyBoundSelected = false;
    private boolean remakeTable = false;
    private boolean reformatTable = false;
    private boolean isHeadTagIncluded = true;
    private boolean isBackgroundTagIncluded = true;
    private boolean isHttpsDynamicExport = false;
    private String httpsServerName = "127.0.0.1";
    private int httpsServletRunnerPort = 8443;
    private boolean isDHTMLViewerUsed = false;
    private boolean isApplyTemplateForDHTMLViewer = false;
    private boolean forExportOnly = false;
    private boolean exportToMultiPages = false;
    private boolean exportToSingleWPagination = false;
    private boolean limitExcelCellSplit = false;
    private boolean isExpandAndCollapseEnabled = false;
    private boolean isDefaultToExpandAll = false;
    private boolean embeddedScriptWithInThePage = true;
    private int expandLevelTo = -1;
    private boolean isAnimationOnForExpandAndCollapse = false;
    private String expandAndCollapseScriptName = null;
    private boolean usingIE55DHTMLRendering = false;
    private boolean useStyleSheet = true;
    private String externalCSS = null;
    private String internalCSS = "style";
    private String exportEncoding = "UTF-8";
    private String htmlCharset = "UTF-8";
    private String rtfEncoding = null;
    private int totalHInPixelForDHTML = 0;
    private int totalWInPixelForDHTML = 0;
    private boolean centerDHTMLReport = false;
    private String htmlTitle = null;
    private boolean useAllColorsForRTF = true;
    private int exportDelim = -1;
    private int exportNewlineDelim = 3;
    private boolean isApplyExcelFormat = true;
    private IStringCustomizer stringCustomizer = null;
    private Vector<Report> drillDownReportVector = null;
    private String subReportPath = null;
    private IHTMLLinksProvider htmlLinksProvider = null;
    private IDynamicImageURLGenerator dynamicImageURLGenerator = null;
    private IDynamicReportKeyGenerator dynamicReportKeyGenerator = null;
    private String servletDirectory = "servlet/";
    private Hashtable<String, byte[]> drilldownReportHashTable = null;
    private int dbSourceType = -1;
    private byte[][] queryFileBytes = null;
    private Color backgroundColor = null;
    private ReportImage backgroundImage = null;
    private int paramPageLayout = 1;
    private boolean paramPageResetEnabled = true;
    private String[] paramPageExportFormats = null;
    private String extraFormContent = "";
    private boolean forDeploy = false;
    private String previewSecurityLevel = null;
    private Hashtable<String, QueryInParam[]> securityQueryParameterMap = null;
    private Hashtable<Object, Parameter> subParamToMappedParams;
    private Hashtable<String, Parameter> paramNameToObj;
    private boolean relativeUrlToServlets = false;
    private Connection drillDownConn;
    private String[] databaseInfo;
    private String[][] richTextFonts = new String[0][0];
    private int[] order_offset;
    private String backupQuery = null;
    private String replaceColumnInfoURI = null;
    private FileInMemTable subFilesTable = new FileInMemTable();
    private String filename = null;
    private boolean isCopy = false;
    private PaginationSettings paginationSettings;
    private String easyReportStyle;
    private Set<ReportAlertObject> triggeredAlerts = null;

    public Report() {
        LCKey.isValidER();
        this.initializeSettingElements();
    }

    public Report(String name) {
        LCKey.isValidER();
        this.name = name;
        ReportCell cell = new ReportCell(name);
        cell.setWidth(this.getActualPageWidth());
        cell.setFont(FontTable.newFont("Dialog", 1, QbUtil.getAdjustedFont(24, true)));
        this.reportHeader.addData(cell);
        this.initializeSettingElements();
    }

    public Report(Report _report) {
        this(false, _report);
    }

    public Report(boolean reUseTable, Report _report) {
        LCKey.isValidER();
        this.colData = _report.colData;
        this.colDataSorted = _report.colDataSorted;
        ColData.releaseDiskBuffer(this.colData);
        this.recIndex = _report.recIndex;
        this.reOrderColumns = _report.reOrderColumns;
        this.showRowAggregationGrandTotal = _report.showRowAggregationGrandTotal;
        this.showColumnAggregation = _report.showColumnAggregation;
        this.crossTabFreeForm = _report.crossTabFreeForm;
        this.columnAggregationInHeader = _report.columnAggregationInHeader;
        this.alignCrossTabColBkValHori = _report.alignCrossTabColBkValHori;
        this.showRowAggregationSubtotal = _report.showRowAggregationSubtotal;
        this.rowAggregationSubtotalOnLeft = _report.rowAggregationSubtotalOnLeft;
        if (reUseTable) {
            this.pageHeader = _report.pageHeader;
            this.reportHeader = _report.reportHeader;
            this.reportFooter = _report.reportFooter;
            this.pageFooter = _report.pageFooter;
            this.reportTables = _report.reportTables;
            this.colInfo = _report.colInfo;
            this.breakColInfo = _report.breakColInfo;
            this.breakColIndex = _report.breakColIndex;
            this.breakColValueIndex = _report.breakColValueIndex;
            this.valColInfo = _report.valColInfo;
            this.masterIndex = _report.masterIndex;
        } else {
            this.createTable(_report.reportType, _report.colInfo, false);
        }
        this.initializeSettingElements();
        this.deepCopy(_report, reUseTable);
    }

    public Report(Report _report, boolean createBackupReport) {
        LCKey.isValidER();
        this.colData = _report.colData;
        this.colDataSorted = _report.colDataSorted;
        ColData.releaseDiskBuffer(this.colData);
        this.recIndex = _report.recIndex;
        this.reOrderColumns = _report.reOrderColumns;
        this.showRowAggregationGrandTotal = _report.showRowAggregationGrandTotal;
        this.showColumnAggregation = _report.showColumnAggregation;
        this.crossTabFreeForm = _report.crossTabFreeForm;
        this.columnAggregationInHeader = _report.columnAggregationInHeader;
        this.alignCrossTabColBkValHori = _report.alignCrossTabColBkValHori;
        this.showRowAggregationSubtotal = _report.showRowAggregationSubtotal;
        this.rowAggregationSubtotalOnLeft = _report.rowAggregationSubtotalOnLeft;
        this.createTable(_report.reportType, _report.colInfo, false, createBackupReport, createBackupReport);
        this.initializeSettingElements();
        this.deepCopy(_report);
    }

    public Report(ColData[] colData) {
        this(colData, false, false);
    }

    public Report(ColData[] colData, boolean optimizeMemory) {
        this(colData, optimizeMemory, false);
    }

    public Report(ColData[] colData, boolean optimizeMemory, boolean multiPageExp) {
        LCKey.isValidER();
        this.exportToMultiPages = multiPageExp;
        this.forExportOnly = optimizeMemory;
        this.colData = colData;
        ColData.releaseDiskBuffer(colData);
        this.initializeSettingElements();
    }

    public static int getInputDataBlockSize() {
        return inputDataBlockSize;
    }

    public static void setInputDataBlockSize(int val) {
        inputDataBlockSize = val;
    }

    public static void setStaticExport(Boolean bol) {
        staticExport = bol;
    }

    public static ColInfo[] getNewColInfoSet(ColInfo[] colInfo, ColInfo newCol, int index) {
        boolean found = false;
        int idx = 0;
        String fname = null;
        if (newCol.getFormulaObj() != null) {
            fname = newCol.getFormulaObj().getName();
        }
        for (int i = 0; i < colInfo.length; ++i) {
            if (colInfo[i].getFormulaObj() == null || colInfo[i].getFormulaObj().getName() == null || !colInfo[i].getFormulaObj().getName().equals(fname)) continue;
            found = true;
            idx = i;
            break;
        }
        ColInfo[] newColInfo = null;
        if (found) {
            newColInfo = new ColInfo[colInfo.length];
            if (index < 0) {
                index = 0;
            }
            if (index > newColInfo.length - 1) {
                index = newColInfo.length - 1;
            }
            for (int i = 0; i < newColInfo.length; ++i) {
                newColInfo[i] = i != idx ? colInfo[i] : newCol;
            }
        } else {
            if (index > colInfo.length) {
                index = colInfo.length;
            }
            newColInfo = new ColInfo[colInfo.length + 1];
            int j = 0;
            for (int i = 0; i < newColInfo.length; ++i) {
                newColInfo[i] = index != i ? colInfo[j++] : newCol;
            }
        }
        return newColInfo;
    }

    public static ColInfo[] addFormulaColumn(ColInfo[] bColInfo, ColInfo[] fColInfo) {
        int i;
        Vector<ColInfo> source = new Vector<ColInfo>();
        Vector newCol = new Vector();
        Vector<ColInfo> formCol = new Vector<ColInfo>();
        Vector<ColInfo> nonFormCol = new Vector<ColInfo>();
        for (ColInfo element : bColInfo) {
            source.addElement(element);
        }
        for (ColInfo element : fColInfo) {
            if (element.getMapping() < 0) {
                formCol.addElement(element);
                continue;
            }
            nonFormCol.addElement(element);
        }
        while (source.size() > 0) {
            ColInfo sColInfo = (ColInfo)source.elementAt(0);
            if (sColInfo.getName() == null) {
                newCol.addElement(source.elementAt(0));
                source.removeElementAt(0);
                continue;
            }
            boolean added = false;
            for (int j = 0; j < nonFormCol.size() && !added; ++j) {
                ColInfo current = (ColInfo)nonFormCol.elementAt(j);
                if (!sColInfo.getName().equals(current.getName())) continue;
                newCol.addElement(source.elementAt(0));
                source.removeElementAt(0);
                nonFormCol.removeElementAt(j);
                added = true;
            }
            if (added) continue;
            newCol.addElement(source.elementAt(0));
            source.removeElementAt(0);
        }
        ColInfo[] newColInfo = new ColInfo[newCol.size()];
        for (i = 0; i < newColInfo.length; ++i) {
            newColInfo[i] = (ColInfo)newCol.elementAt(i);
        }
        for (i = 0; i < formCol.size(); ++i) {
            newColInfo = Report.getNewColInfoSet(newColInfo, (ColInfo)formCol.elementAt(i), newColInfo.length);
        }
        if (source.size() > 0) {
            int i2;
            ColInfo[] tempColInfo = new ColInfo[newColInfo.length + source.size()];
            for (i2 = 0; i2 < newColInfo.length; ++i2) {
                tempColInfo[i2] = newColInfo[i2];
            }
            for (i2 = 0; i2 < source.size(); ++i2) {
                tempColInfo[i2 + newColInfo.length] = (ColInfo)source.elementAt(i2);
            }
            newColInfo = tempColInfo;
        }
        return newColInfo;
    }

    public static ICustomDefinedFunctions getCustomDefinedFunctions() {
        return customFunctions;
    }

    public static void setCustomDefinedFunctions(ICustomDefinedFunctions f) {
        customFunctions = f;
    }

    public static String[] getExtension(int type) {
        switch (type) {
            case 10: 
            case 18: {
                return new String[]{"PAK", "QDR"};
            }
            case 15: {
                return new String[]{"RPT"};
            }
            case 1: {
                return new String[]{"RPT", "QRP"};
            }
            case 4: {
                return new String[]{"HTML", "HTM"};
            }
            case 2: {
                return new String[]{"PDF"};
            }
            case 3: {
                return new String[]{"CSV"};
            }
            case 9: {
                return new String[]{"XLS"};
            }
            case 17: {
                return new String[]{"XLSX"};
            }
            case 5: {
                return new String[]{"TXT"};
            }
            case 13: {
                return new String[]{"RTF"};
            }
            case 12: {
                return new String[]{"GIF"};
            }
            case 6: 
            case 7: 
            case 8: {
                return new String[]{"XML"};
            }
            case 14: {
                return new String[]{"VIEW"};
            }
        }
        return new String[]{"*"};
    }

    public static String getFullName(String fileName, int type) {
        String[] ext = Report.getExtension(type);
        if (type < 0 || ext[0].equals("*")) {
            return fileName;
        }
        for (String element : ext) {
            if (!fileName.toUpperCase().endsWith("." + element)) continue;
            return fileName;
        }
        return fileName + "." + ext[0].toLowerCase();
    }

    public static String getPrefixFileName(String name) {
        String path = name.replace('\\', '/');
        int lastDir = path.lastIndexOf(47);
        int index = name.lastIndexOf(46);
        if (index > 0 && index > lastDir) {
            return name.substring(0, index);
        }
        return name;
    }

    private static Parameter[][] getSubReportFormulaParams(IReport[] subReports) {
        if (subReports == null) {
            return null;
        }
        Parameter[][] result = new Parameter[subReports.length][];
        for (int i = 0; i < subReports.length; ++i) {
            Report subreport = (Report)subReports[i];
            if (subreport == null) continue;
            Vector<Parameter> formulaParams = subreport.getFormulaParameters();
            int size = 0;
            Parameter[] srParams = null;
            if (formulaParams != null) {
                Parameter param;
                for (Parameter parameter : formulaParams) {
                    param = parameter;
                    if (param.isShared()) continue;
                    ++size;
                }
                srParams = new Parameter[size];
                int j = 0;
                Enumeration<Parameter> e = formulaParams.elements();
                while (e.hasMoreElements()) {
                    param = e.nextElement();
                    if (!param.isShared()) {
                        srParams[j] = param;
                    }
                    ++j;
                }
            }
            result[i] = srParams;
        }
        return result;
    }

    private static Hashtable<String, Parameter> getSharedParams(Report subreport) {
        Parameter param;
        Hashtable<String, Parameter> result = new Hashtable<String, Parameter>();
        Vector<Parameter> queryParams = subreport.getQueryParameters();
        Vector<Parameter> formulaParams = subreport.getFormulaParameters();
        if (queryParams != null) {
            for (Parameter parameter : queryParams) {
                param = parameter;
                if (!param.isShared()) continue;
                result.put(param.getName(), param);
            }
        }
        if (formulaParams != null) {
            for (Parameter parameter : formulaParams) {
                param = parameter;
                if (!param.isShared()) continue;
                result.put(param.getName(), param);
            }
        }
        return result;
    }

    public static Report[] getSubReportArray(Vector<SubReportObject> subRpts, boolean useBackupData, FileInMemTable subFilesTable) {
        return Report.getSubReportArray(subRpts, useBackupData, subFilesTable, false, false);
    }

    public static Report[] getSubReportArray(Vector<SubReportObject> subRpts, boolean useBackupData, FileInMemTable subFilesTable, boolean loadNewOnly, boolean isPAK) {
        if (subRpts == null) {
            return null;
        }
        Report[] subRptArray = null;
        try {
            subRptArray = new Report[subRpts.size()];
            for (int i = 0; i < subRpts.size(); ++i) {
                SubReportObject sro = subRpts.elementAt(i);
                if (sro.getCachedSubReport() != null) {
                    subRptArray[i] = sro.getCachedSubReport().getReportInfo();
                    continue;
                }
                LoadReport lr = new LoadReport();
                lr.getSubReportParameter = true;
                lr.setBackupDataUsed(useBackupData);
                lr.setRelativeDomainPath(sro.getDomainPath());
                lr.setLoadNewOnly(loadNewOnly);
                lr.setSubFilesTable(subFilesTable);
                if (sro.getByteArray() == null) {
                    String fName = isPAK ? SaveReport.getPakFileName(sro.getFileName()) : sro.getFileName();
                    subRptArray[i] = lr.loadReportFromFile(fName);
                    continue;
                }
                subRptArray[i] = lr.loadReport(new DataInputStream(new ByteArrayInputStream(sro.getByteArray())), null);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to get sub-report array", ex);
        }
        return subRptArray;
    }

    private static Parameter getParameterFrom(Parameter[] params, IQueryInParam match) {
        for (Parameter param : params) {
            if (!param.getName().equals(match.getParamName())) continue;
            return param;
        }
        return null;
    }

    static void setValue(Parameter parameter, Object origParameter, String[] value) {
        int sqlType = parameter.getSQLType();
        if (origParameter instanceof IQueryInParam) {
            sqlType = ((IQueryInParam)origParameter).getSqlType();
        }
        if (parameter.isMultiValueParam()) {
            parameter.setValues(ReportUtil.getMultiValueObject(sqlType, value, null));
        } else if (value.length == 3) {
            if (value[2] == null || value[2].equals("")) {
                value[2] = "2003";
            }
            String date = value[0] + "/" + value[1] + "/" + value[2];
            parameter.setValue(ReportUtil.getValueObject(sqlType, date, "MM/dd/yyyy"));
        } else {
            parameter.setValue(ReportUtil.getValueObject(sqlType, value[0], null));
        }
    }

    private static Object[] toArray(Vector<Object> v) {
        if (v == null) {
            return null;
        }
        Object[] result = new Object[v.size()];
        int i = 0;
        Enumeration<Object> e = v.elements();
        while (e.hasMoreElements()) {
            result[i] = e.nextElement();
            ++i;
        }
        return result;
    }

    public static boolean useSubReportCache() {
        return useSubReportCache;
    }

    public static void setSubReportCache(boolean state) {
        useSubReportCache = state;
    }

    public static ByteArrayInputStream getSubFileStream(FileInMemTable subFilesTable, String fileName) {
        LOGGER.finest("getSubFileStream: " + fileName);
        byte[] obj = subFilesTable.get(fileName);
        if (obj == null) {
            return null;
        }
        return new ByteArrayInputStream(obj);
    }

    public static boolean replaceSubFile(FileInMemTable subFileTable, byte[] barray, String filename) {
        try {
            if (subFileTable != null) {
                LOGGER.finest("Replace sub file name: " + filename);
                byte[] obj = subFileTable.get(filename);
                if (obj != null) {
                    subFileTable.put(filename, barray);
                    return true;
                }
                subFileTable.put(filename, barray);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to replace sub-file", ex);
            return false;
        }
    }

    public static boolean fileExists(Report report, String filename) throws Exception {
        byte[] obj;
        if (report != null && (obj = report.getSubFilesTable().get(filename)) != null) {
            return true;
        }
        return new FileInfo(filename).exists();
    }

    public static boolean fileExists(FileInMemTable subFilesTable, String filename) throws Exception {
        boolean fileExistsInMemory = Report.fileExistsInMemoryTable(subFilesTable, filename);
        if (!fileExistsInMemory) {
            return new FileInfo(filename).exists();
        }
        return fileExistsInMemory;
    }

    public static boolean fileExistsInMemoryTable(FileInMemTable subFilesTable, String filename) {
        if (subFilesTable != null) {
            byte[] obj = subFilesTable.get(filename);
            return obj != null;
        }
        return false;
    }

    public static boolean copyFile(FileInMemTable tbl, String source, String destination) {
        if (tbl != null && tbl.isFileInMemEnabled()) {
            byte[] data = tbl.get(ServerMessage.getPath(source));
            return Report.replaceSubFile(tbl, data, ServerMessage.getPath(destination));
        }
        if (tbl != null) {
            byte[] data = tbl.get(ServerMessage.getPath(source));
            if (data != null) {
                try {
                    new WriteDataFile().output(tbl, data, destination);
                    return true;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Cannot write data file", ex);
                    return false;
                }
            }
            return CopyFile.copy(source, destination);
        }
        return CopyFile.copy(source, destination);
    }

    public static ReplaceColumnInfoList getReplaceColInfoList() {
        return replaceColInfoList;
    }

    public static void setReplaceColInfoList(ReplaceColumnInfoList list) {
        replaceColInfoList = list;
    }

    private static void extractAlertIds(Vector statements, HashSet<String> ids) {
        if (statements == null) {
            return;
        }
        for (ERStatement stmt : statements) {
            if (stmt instanceof CellAttrAssignStmt) {
                CellAttrAssignStmt cas = (CellAttrAssignStmt)stmt;
                if (!"ALERT".equalsIgnoreCase(cas.getCellAttr()) || cas.operandValues == null || cas.operandValues.size() <= 0 || ids.contains(cas.operandValues.get(0).toString())) continue;
                String tmp = cas.operandValues.get(0).toString().trim();
                if (tmp.startsWith("\"") || tmp.startsWith("'")) {
                    tmp = tmp.substring(1);
                }
                if (tmp.endsWith("\"") || tmp.endsWith("'")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                ids.add(tmp);
                continue;
            }
            if (stmt instanceof IfStatement) {
                IfStatement ifs = (IfStatement)stmt;
                Report.extractAlertIds(ifs.getThenStmts(), ids);
                Report.extractAlertIds(ifs.getElseStmts(), ids);
                continue;
            }
            if (!(stmt instanceof WhileStatement)) continue;
            WhileStatement whs = (WhileStatement)stmt;
            Report.extractAlertIds(whs.getDoStmts(), ids);
        }
    }

    public String[] getParamPageExportFormats() {
        return this.paramPageExportFormats;
    }

    public void setParamPageExportFormats(String[] formats) {
        this.paramPageExportFormats = formats;
    }

    public String getExtraFormContent() {
        return this.extraFormContent;
    }

    public void setExtraFormContent(String extra) {
        this.extraFormContent = extra;
    }

    public boolean isForDeploy() {
        return this.forDeploy;
    }

    public void setForDeploy(boolean state) {
        this.forDeploy = state;
    }

    public String getInitializeReportError() {
        return this.initializeReportError;
    }

    public void setInitializeReportError(String str) {
        this.initializeReportError = str;
    }

    public boolean isFreeFormCrossTab() {
        return this.isCrossTab() && this.crossTabFreeForm;
    }

    public boolean isCrossTab() {
        return this.reportType == 2;
    }

    public boolean isCrossTabFixedField() {
        return this.isCrossTab() && !this.crossTabFreeForm;
    }

    public boolean isColumnAggregationInHeader() {
        return this.isCrossTabFixedField() && this.columnAggregationInHeader;
    }

    public void setColumnAggregationInHeader(boolean columnAggregationInHeader) {
        this.columnAggregationInHeader = columnAggregationInHeader;
    }

    public boolean isReOrderColumns() {
        return this.isCrossTab() && this.reOrderColumns;
    }

    public boolean isShowRowAggregationGrandTotal() {
        return this.isCrossTab() && this.showRowAggregationGrandTotal;
    }

    public void setReOrderColumns(boolean ReOrderColumns) {
        this.reOrderColumns = ReOrderColumns;
    }

    public void setShowRowAggregationGrandTotal(boolean showRowAggregationGrandTotal) {
        this.showRowAggregationGrandTotal = showRowAggregationGrandTotal;
    }

    public boolean isShowColumnAggregation() {
        return this.reportType == 2 && this.showColumnAggregation;
    }

    public void setShowColumnAggregation(boolean showColumnAggregation) {
        this.showColumnAggregation = showColumnAggregation;
    }

    public boolean isRowAggregationSubtotalOnLeft() {
        return this.isCrossTabFixedField() && this.rowAggregationSubtotalOnLeft;
    }

    public void setRowAggregationSubtotalOnLeft(boolean rowAggregationSubtotalOnLeft) {
        this.rowAggregationSubtotalOnLeft = rowAggregationSubtotalOnLeft;
    }

    public boolean isRowAggregationGrandTotalOnLeft() {
        return this.isCrossTabFixedField() && this.rowAggregationGrandTotalOnLeft;
    }

    public void setRowAggregationGrandTotalOnLeft(boolean rowAggregationGrandTotalOnLeft) {
        this.rowAggregationGrandTotalOnLeft = rowAggregationGrandTotalOnLeft;
    }

    public boolean isShowRowAggregationSubtotal() {
        return this.reportType == 2 && this.showRowAggregationSubtotal;
    }

    public void setShowRowAggregationSubtotal(boolean showRowAggregationSubtotal) {
        this.showRowAggregationSubtotal = showRowAggregationSubtotal;
    }

    public boolean isAlignCrossTabColBkValHori() {
        return this.alignCrossTabColBkValHori;
    }

    public void setAlignCrossTabColBkValHori(boolean alignCrossTabColBkValHori) {
        this.alignCrossTabColBkValHori = alignCrossTabColBkValHori;
    }

    public void replaceColumns(ReplaceColumnInfoList colList) {
        if (this.dbInfo == null) {
            return;
        }
        Vector<ReplaceColumnInfo> colInfoList = colList.getReplaceColumnInfo(this.dbInfo.getDriverName(), this.dbInfo.getURLString());
        if (colInfoList.size() == 0) {
            return;
        }
        if (this.backupQuery == null) {
            this.backupQuery = this.dbInfo.getQuery();
        }
        String newQuery = this.backupQuery;
        for (int i = 0; i < colInfoList.size(); ++i) {
            ReplaceColumnInfo colInfo = colInfoList.elementAt(i);
            Vector<String[]> vec = colInfo.getColumnPair();
            if (vec.size() == 0) continue;
            newQuery = QueryParser.replaceColumns(newQuery, colInfo.getTableName(), vec);
        }
        if (newQuery.equals(this.backupQuery)) {
            this.backupQuery = null;
            this.replaceColumnInfoURI = null;
            return;
        }
        this.dbInfo.setQuery(newQuery);
        this.replaceColumnInfoURI = colList.getDocumentURL();
        LOGGER.finest("Replace sql column: Original query= " + this.backupQuery);
        LOGGER.finest("Replace sql column: New query= " + newQuery);
    }

    public String getBackupQuery() {
        return this.backupQuery;
    }

    public void setBackupQuery(String backupQ) {
        this.backupQuery = backupQ;
    }

    public String getReplaceColumnInfoURL() {
        return this.replaceColumnInfoURI;
    }

    public boolean isForExportOnly() {
        return this.forExportOnly;
    }

    public void setForExportOnly(boolean state) {
        this.forExportOnly = state;
    }

    public boolean getLimitExcelCellSplit() {
        return this.limitExcelCellSplit;
    }

    public void setLimitExcelCellSplit(boolean limitExcelCellSplit) {
        this.limitExcelCellSplit = limitExcelCellSplit;
    }

    public boolean isValidForExportOnly() {
        if (!this.isForExportOnly()) {
            return false;
        }
        if (this.sourceData != 1 && this.sourceData != 0) {
            return false;
        }
        if (this.dbInfo != null && this.dbInfo instanceof IQueryFileInfo) {
            return false;
        }
        if (this.getReportType() != 2) {
            return true;
        }
        if (this.sourceData == 0) {
            return this.distColValue != null && this.distColValue.length > 0;
        }
        String sqlstr = null;
        if (this.dbInfo != null) {
            sqlstr = this.dbInfo.getQuery();
        }
        return this.getReportType() != 2 || TransformQuery.isValidQuery(sqlstr, this.colInfo);
    }

    public boolean isUseStyleSheet() {
        return true;
    }

    public String getExternalStyleSheetName() {
        return this.externalCSS;
    }

    public void setExternalStyleSheetName(String css) {
        this.externalCSS = css;
    }

    public String getInternalStyleSheetName() {
        return this.internalCSS;
    }

    public void setInternalStyleSheetName(String css) {
        this.internalCSS = css;
    }

    public String getExportEncoding() {
        return this.exportEncoding;
    }

    public void setExportEncoding(String enc) {
        this.exportEncoding = enc;
    }

    public String getHTMLCharset() {
        return this.htmlCharset;
    }

    public void setHTMLCharset(String charset) {
        this.htmlCharset = charset;
    }

    public String getRTFEncoding() {
        return this.rtfEncoding;
    }

    public void setRTFEncoding(String enc) {
        this.rtfEncoding = enc;
    }

    public boolean isExportToMultiPages() {
        return this.exportToMultiPages;
    }

    public void setExportToMultiPages(boolean state) {
        this.exportToMultiPages = state;
    }

    @Deprecated
    public boolean isUsingIE55DHTMLRendering() {
        return false;
    }

    @Deprecated
    public void setUsingIE55DHTMLRendering(boolean state) {
        this.usingIE55DHTMLRendering = state;
    }

    public int getTotalHInPixelForDHTML() {
        return this.totalHInPixelForDHTML;
    }

    public void setTotalHInPixelForDHTML(int h) {
        this.totalHInPixelForDHTML = h;
    }

    public int getTotalWInPixelForDHTML() {
        return this.totalWInPixelForDHTML;
    }

    public void setTotalWInPixelForDHTML(int w) {
        this.totalWInPixelForDHTML = w;
    }

    public boolean isExpandAndCollapseEnabled() {
        return this.isExpandAndCollapseEnabled;
    }

    public void setExpandAndCollapseEnabled(boolean b) {
        this.isExpandAndCollapseEnabled = b;
    }

    public boolean isDefaultToExpandAll() {
        return this.isDefaultToExpandAll;
    }

    public void setDefaultToExpandAll(boolean b) {
        this.isDefaultToExpandAll = b;
    }

    public int getExpandGroupLevelTo() {
        return this.expandLevelTo;
    }

    public void setExpandGroupLevelTo(int level) {
        this.expandLevelTo = level;
    }

    public boolean isAnimationOnForExpandAndCollapse() {
        return this.isAnimationOnForExpandAndCollapse;
    }

    public void setAnimationOnForExpandAndCollapse(boolean b) {
        this.isAnimationOnForExpandAndCollapse = b;
    }

    public String getExpandAndCollapseScriptName() {
        return this.expandAndCollapseScriptName;
    }

    public void setExpandAndCollapseScriptName(String str) {
        this.expandAndCollapseScriptName = str;
    }

    public boolean isExpandAndCollapseSupported() {
        return !this.isExportToMultiPages() && !this.isExportToSingleWPagination() && (this.getReportType() == 1 || this.getReportType() == 2 || this.getReportType() == 3 && !this.isSideBySideLayout());
    }

    public boolean isEmbeddedScriptWithInThePage() {
        return this.embeddedScriptWithInThePage;
    }

    public void setEmbeddedScriptWithInThePage(boolean b) {
        this.embeddedScriptWithInThePage = b;
    }

    public boolean getCenterDHTMLReport() {
        return this.centerDHTMLReport;
    }

    public void setCenterDHTMLReport(boolean b) {
        this.centerDHTMLReport = b;
    }

    public boolean isExportToSingleWPagination() {
        return this.exportToSingleWPagination;
    }

    public void setExportToSingleWPagination(boolean state) {
        this.exportToSingleWPagination = state;
    }

    public String getHTMLTitle() {
        return this.htmlTitle;
    }

    public void setHTMLTitle(String title) {
        this.htmlTitle = title;
    }

    public boolean isUsingAllColorsForRTF() {
        return this.useAllColorsForRTF;
    }

    public void setUsingAllColorsForRTF(boolean b) {
        this.useAllColorsForRTF = b;
    }

    public int getExportDelimiter() {
        return this.exportDelim;
    }

    public void setExportDelimiter(int delim) {
        this.exportDelim = delim;
    }

    public int getExportNewlineDelimiter() {
        return this.exportNewlineDelim;
    }

    public void setExportNewlineDelimiter(int delim) {
        this.exportNewlineDelim = delim;
    }

    public boolean isApplyExcelFormat() {
        return this.isApplyExcelFormat;
    }

    public void setApplyExcelFormat(boolean state) {
        this.isApplyExcelFormat = state;
    }

    public Hashtable<String, String> getFontMapping() {
        return this.fontMapping;
    }

    public void setFontMapping(Hashtable<String, String> mapping) {
        this.fontMapping = mapping;
    }

    public String[][] getRichTextFonts() {
        return this.richTextFonts;
    }

    public void setRichTextFonts(String[][] fonts) {
        this.richTextFonts = fonts;
    }

    void adjustHeaderFormulas() {
        int length = this.colInfo.length;
        Vector<ReportColumn> columns = null;
        try {
            columns = this.getReportTables().elementAt(0).getColumns();
            if (this.reportType == 2) {
                length = columns.size();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get columns", ex);
        }
        this.reportHeader.adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
        this.pageHeader.adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable mTable;
            if (this.reportTables.elementAt(i) instanceof ReportMultiSectionTable) {
                int j;
                mTable = (ReportMultiSectionTable)this.reportTables.elementAt(i);
                mTable.getHeader().adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, true);
                mTable.getFooter().adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
                if (mTable.getMasterSection() != null) {
                    mTable.getMasterSection().adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
                }
                for (j = 0; j < ((ReportMultiSectionTable)mTable).countRowBreakHeader(); ++j) {
                    ((ReportMultiSectionTable)mTable).getRowBreakHeader(j).adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
                }
                for (j = 0; j < ((ReportMultiSectionTable)mTable).countRowBreakFooter(); ++j) {
                    ((ReportMultiSectionTable)mTable).getRowBreakFooter(j).adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
                }
                continue;
            }
            if (this.reportTables.elementAt(i) == null) continue;
            mTable = this.reportTables.elementAt(i);
            mTable.getHeader().adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, true);
            mTable.getFooter().adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
            if (mTable.getMasterSection() == null) continue;
            mTable.getMasterSection().adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
        }
        this.pageFooter.adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
        this.reportFooter.adjustHeaderFormulas(length, columns, this, this.columnHeaderSetting, false);
    }

    void adjustFooterFormulas() {
        int length = this.colInfo.length;
        Vector<ReportColumn> columns = null;
        try {
            if (this.reportType == 2) {
                length = this.getReportTables().elementAt(0).getColumnCount();
            }
            columns = this.getReportTables().elementAt(0).getColumns();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get columns", ex);
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable mTable;
            if (this.reportTables.elementAt(i) instanceof ReportMultiSectionTable) {
                mTable = (ReportMultiSectionTable)this.reportTables.elementAt(i);
                mTable.getFooter().adjustFooterFormulas(length, columns, this, this.formula, true);
                if (mTable.getMasterSection() != null) {
                    mTable.getMasterSection().adjustFooterFormulas(length, columns, this, this.formula, false);
                }
                for (int j = 0; j < ((ReportMultiSectionTable)mTable).countRowBreakFooter(); ++j) {
                    ((ReportMultiSectionTable)mTable).getRowBreakFooter(j).adjustFooterFormulas(length, columns, this, this.formula, false);
                }
                continue;
            }
            if (this.reportTables.elementAt(i) == null) continue;
            mTable = this.reportTables.elementAt(i);
            mTable.getFooter().adjustFooterFormulas(length, columns, this, this.formula, false);
            if (mTable.getMasterSection() == null) continue;
            mTable.getMasterSection().adjustFooterFormulas(length, columns, this, this.formula, false);
        }
        this.pageFooter.adjustFooterFormulas(length, columns, this, this.formula, false);
        this.reportFooter.adjustFooterFormulas(length, columns, this, this.formula, false);
    }

    String getSectionReferenceName(String secID) {
        for (int i = 0; i < this.reportTables.size(); ++i) {
            if (!(this.reportTables.elementAt(i) instanceof ReportMultiSectionTable)) continue;
            ReportMultiSectionTable mTable = (ReportMultiSectionTable)this.reportTables.elementAt(i);
            for (int j = 0; j < mTable.countRowBreakFooter(); ++j) {
                if (mTable.getRowBreakHeader(j).getID().equals(secID)) {
                    return this.getSectionReferenceName(j, true);
                }
                if (!mTable.getRowBreakFooter(j).getID().equals(secID)) continue;
                return this.getSectionReferenceName(j, false);
            }
        }
        return null;
    }

    private String getSectionReferenceName(int index, boolean isHeader) {
        int ct = 0;
        for (ColInfo element : this.colInfo) {
            if (!element.isRowBreak()) continue;
            if (ct == index) {
                return element.getName() + (isHeader ? "_HDR" : "_FTR");
            }
            ++ct;
        }
        return null;
    }

    public boolean hasScriptExp(String exp) {
        for (int i = 0; i < this.scripts.size(); ++i) {
            Script script = this.scripts.elementAt(i);
            if (script.getText().indexOf(exp) <= -1) continue;
            return true;
        }
        return false;
    }

    public boolean hasFormulaExp(String exp) {
        if (this.checkSectionFormulaExp(this.pageHeader, exp)) {
            return true;
        }
        if (this.checkSectionFormulaExp(this.reportHeader, exp)) {
            return true;
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            if (!this.checkTableFormulaExp(this.reportTables.elementAt(i), exp)) continue;
            return true;
        }
        if (this.checkSectionFormulaExp(this.reportFooter, exp)) {
            return true;
        }
        return this.checkSectionFormulaExp(this.pageFooter, exp);
    }

    private boolean checkSectionFormulaExp(ReportSection section, String exp) {
        int i;
        int cellCt = section.getCellCount();
        ReportCell[] cells = section.getData();
        for (i = 0; i < cellCt; ++i) {
            if (!this.checkReportCellFormulaExp(cells[i], exp)) continue;
            return true;
        }
        for (i = 0; i < section.getSectionCount(); ++i) {
            try {
                if (!this.checkSectionFormulaExp(section.getSection(i), exp)) continue;
                return true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to check section formula expression", ex);
            }
        }
        return false;
    }

    private boolean checkTableFormulaExp(ReportTable table, String exp) {
        if (this.checkSectionFormulaExp(table.getHeader(), exp)) {
            return true;
        }
        if (this.checkCellsFormulaExp(table, exp)) {
            return true;
        }
        return this.checkSectionFormulaExp(table.getFooter(), exp);
    }

    private boolean checkCellsFormulaExp(ReportTable table, String exp) {
        return table instanceof ReportTreeTable && this.checkTreeTableFormulaExp((ReportTreeTable)table, exp);
    }

    private boolean checkTreeTableFormulaExp(ReportTreeTable sTable, String exp) {
        for (int i = 0; i < sTable.countSubTable(); ++i) {
            ReportTable table = sTable.getSubTable(i);
            if (this.checkSectionFormulaExp(table.getHeader(), exp)) {
                return true;
            }
            if (this.checkCellsFormulaExp(table, exp)) {
                return true;
            }
            if (!this.checkSectionFormulaExp(table.getFooter(), exp)) continue;
            return true;
        }
        return false;
    }

    private boolean checkReportCellFormulaExp(ReportCell cell, String exp) {
        Script scriptObj;
        Object script;
        String formula = cell.getFormula();
        if (cell.getScriptObj() == null && cell.getScriptName() != null) {
            for (int j = 0; j < this.scripts.size(); ++j) {
                script = this.scripts.elementAt(j);
                if (!cell.getScriptName().equals(((Script)script).getName())) continue;
                cell.setScriptObj((Script)script);
                break;
            }
        }
        if ((scriptObj = cell.getScriptObj()) != null) {
            script = scriptObj.getText();
            boolean flag = false;
            if (script != null && !((String)script).equals("")) {
                boolean bl = flag = ((String)script).toUpperCase().indexOf(exp.toUpperCase()) != -1;
            }
            if (flag) {
                return true;
            }
        }
        if (formula != null) {
            return formula.toUpperCase().indexOf(exp.toUpperCase()) != -1;
        }
        return false;
    }

    private boolean isTotalPagesRequiredInScript() {
        for (int i = 0; i < this.scripts.size(); ++i) {
            String script = this.scripts.elementAt(i).getText().toUpperCase();
            if (script.indexOf("GETTOTALPAGES") < 0) continue;
            return true;
        }
        return false;
    }

    public ColData[] getColData() {
        return this.colData;
    }

    public boolean isValid() {
        if (this.colData != null) {
            for (int i = 0; i < this.colData.length; ++i) {
                if (this.colData[i].getDataSet().isValid()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private void initializeSettingElements() {
        this.labelSetting = new ReportCell("NEW LABEL");
        this.chartSetting = new ReportChartObject();
        this.imageSetting = new ReportImage();
        this.gridSetting = new ReportGrid();
        this.lineSetting = new ReportLine(false);
        this.columnHeaderSetting = new ColumnHeader();
        this.columnHeaderSetting.setDataFormat(FormatUtil.createFormat(7));
        this.titleSetting = new ReportTitle();
        this.titleSetting.setDataFormat(FormatUtil.createFormat(7));
        this.stringFormulaSetting = new ReportCell("NEW LABEL");
        this.stringFormulaSetting.setDataFormat(FormatUtil.createFormat(7));
        this.logicFormulaSetting = new ReportCell("NEW LABEL");
        this.logicFormulaSetting.setDataFormat(FormatUtil.createFormat(0));
        this.numericFormulaSetting = new ReportCell("NEW LABEL");
        this.numericFormulaSetting.setDataFormat(FormatUtil.createFormat(5));
        this.timeFormulaSetting = new ReportCell("NEW LABEL");
        this.timeFormulaSetting.setDataFormat(FormatUtil.createFormat(10));
        this.stringColumnSetting = new ReportColumn();
        this.stringColumnSetting.setDataFormat(FormatUtil.createFormat(7));
        this.logicColumnSetting = new ReportColumn();
        this.logicColumnSetting.setDataFormat(FormatUtil.createFormat(0));
        this.numericColumnSetting = new ReportColumn();
        this.numericColumnSetting.setDataFormat(FormatUtil.createFormat(5));
        this.timeColumnSetting = new ReportColumn();
        this.timeColumnSetting.setDataFormat(FormatUtil.createFormat(10));
        this.barcodeColumnSetting = new ReportColumn();
        this.barcodeColumnSetting.setDataFormat(FormatUtil.createBarcodeFormat(5));
        this.formula[0] = this.stringFormulaSetting;
        this.formula[1] = this.logicFormulaSetting;
        this.formula[2] = this.numericFormulaSetting;
        this.formula[3] = this.timeFormulaSetting;
        this.column[0] = this.stringColumnSetting;
        this.column[1] = this.logicColumnSetting;
        this.column[2] = this.numericColumnSetting;
        this.column[3] = this.timeColumnSetting;
        this.column[4] = this.barcodeColumnSetting;
        this.pageWidth = ServerMessage.getPageWidth();
        this.pageHeight = ServerMessage.getPageHeight();
    }

    public Vector<ReportElement> getSetting() {
        Vector<ReportElement> setting = new Vector<ReportElement>();
        setting.addElement(this.labelSetting);
        setting.addElement(this.chartSetting);
        setting.addElement(this.imageSetting);
        setting.addElement(this.stringFormulaSetting);
        setting.addElement(this.logicFormulaSetting);
        setting.addElement(this.numericFormulaSetting);
        setting.addElement(this.timeFormulaSetting);
        setting.addElement(this.stringColumnSetting);
        setting.addElement(this.logicColumnSetting);
        setting.addElement(this.numericColumnSetting);
        setting.addElement(this.timeColumnSetting);
        setting.addElement(this.barcodeColumnSetting);
        setting.addElement(this.lineSetting);
        setting.addElement(this.gridSetting);
        setting.addElement(this.columnHeaderSetting);
        setting.addElement(this.titleSetting);
        return setting;
    }

    public void setSetting(Vector setting) {
        this.labelSetting = (ReportCell)setting.elementAt(0);
        this.chartSetting = (ReportChartObject)setting.elementAt(1);
        this.imageSetting = (ReportImage)setting.elementAt(2);
        this.stringFormulaSetting = (ReportCell)setting.elementAt(3);
        this.logicFormulaSetting = (ReportCell)setting.elementAt(4);
        this.numericFormulaSetting = (ReportCell)setting.elementAt(5);
        this.timeFormulaSetting = (ReportCell)setting.elementAt(6);
        this.stringColumnSetting = (ReportColumn)setting.elementAt(7);
        this.logicColumnSetting = (ReportColumn)setting.elementAt(8);
        this.numericColumnSetting = (ReportColumn)setting.elementAt(9);
        this.timeColumnSetting = (ReportColumn)setting.elementAt(10);
        this.barcodeColumnSetting = (ReportColumn)setting.elementAt(11);
        this.lineSetting = (ReportLine)setting.elementAt(12);
        this.gridSetting = (ReportGrid)setting.elementAt(13);
        this.columnHeaderSetting = (ColumnHeader)setting.elementAt(14);
        this.titleSetting = (ReportTitle)setting.elementAt(15);
        this.formula[0] = this.stringFormulaSetting;
        this.formula[1] = this.logicFormulaSetting;
        this.formula[2] = this.numericFormulaSetting;
        this.formula[3] = this.timeFormulaSetting;
        this.column[0] = this.stringColumnSetting;
        this.column[1] = this.logicColumnSetting;
        this.column[2] = this.numericColumnSetting;
        this.column[3] = this.timeColumnSetting;
        this.column[4] = this.barcodeColumnSetting;
    }

    public void setReformatTable() {
        this.reformatTable = true;
    }

    public boolean isReformatTable() {
        return this.reformatTable;
    }

    public boolean reBuildTable() throws IllegalArgumentException {
        if (!this.remakeTable) {
            return false;
        }
        this.reCreateTable(this.reportType, this.colInfo);
        this.remakeTable = false;
        return true;
    }

    public void formatTable() throws Exception {
        this.formatTable(false);
    }

    public void formatTable(boolean isDesignMode) throws Exception {
        Vector<ReportTable> vec = this.getReportTables();
        for (int i = 0; i < vec.size(); ++i) {
            ReportTable table = vec.elementAt(i);
            if (table instanceof CrossTabTable) {
                ((CrossTabTable)table).formatTable(isDesignMode);
            } else {
                table.formatTable();
            }
            table.recalculateFormulaColumnValue(this);
            if (!(table instanceof CrossTabTable)) continue;
            for (int j = 0; j < table.getColumnCount(); ++j) {
                int colIdx = this.getColInfoIndex(table.getColumn(j));
                if (colIdx >= this.colInfo.length || !this.colInfo[colIdx].isColumnBreak() || table.getColumn(j).getDrillDownName() != null) continue;
                table.getColumn(j).setDrillDownName(this.colInfo[this.getColInfoIndex(table.getColumn(j))].getDrillDownName());
            }
        }
        TableOfContents toc = this.getTableOfContentsObject();
        if (toc != null && (this.reformatTable || toc.getBookmarks() == null)) {
            toc.generatesBookmarks(this);
        }
        this.reformatTable = false;
    }

    public TableOfContents getTableOfContentsObject() {
        TableOfContents toc = this.getReportHeader().getTOC();
        if (toc != null) {
            return toc;
        }
        toc = this.getReportTables().elementAt(0).getHeader().getTOC();
        return toc;
    }

    public boolean isTocEnabled() {
        if (this.getTableOfContentsObject() == null) {
            return false;
        }
        return this.getTableOfContentsObject().isEnabled();
    }

    public void setTocEnabled(boolean b) {
        if (this.getTableOfContentsObject() == null) {
            return;
        }
        this.getTableOfContentsObject().setEnabled(b);
    }

    public void reCreateTable(int reportType, ColInfo[] mapping) throws IllegalArgumentException {
        if (this.reportTables.size() > 0) {
            this.reportTables.removeAllElements();
        }
        this.createTable(reportType, mapping);
        this.setReformatTable();
    }

    public void createTable(int reportType, ColInfo[] mapping) throws IllegalArgumentException {
        this.createTable(reportType, mapping, true);
    }

    public void createTable(int reportType, ColInfo[] mapping, boolean formatReport) throws IllegalArgumentException {
        this.createTable(reportType, mapping, formatReport, false);
    }

    public void createTable(int reportType, ColInfo[] mapping, boolean formatReport, boolean isDesignMode) {
        this.createTable(reportType, mapping, formatReport, isDesignMode, false);
    }

    public void createTable(int reportType, ColInfo[] mapping, boolean formatReport, boolean isDesignMode, boolean createBackup) throws IllegalArgumentException {
        LOGGER.finer("Building report table started");
        long start = System.currentTimeMillis();
        try {
            this.reportType = reportType;
            this.formatColInfo(mapping, createBackup);
            ReportTable tbl = null;
            if (reportType == 0) {
                tbl = new ColumnarTable(this);
                this.reportTables.addElement(tbl);
            } else if (reportType == 4) {
                tbl = new MailingLabelsTable(this, formatReport);
                this.reportTables.addElement(tbl);
            } else if (reportType == 1) {
                tbl = new SummaryTable(this);
                this.reportTables.addElement(tbl);
                this.insertFormula(tbl);
            } else if (reportType == 2) {
                tbl = new CrossTabTable(this, isDesignMode);
                this.reportTables.addElement(tbl);
                this.insertFormula(tbl);
            } else if (reportType == 3) {
                tbl = new MasterDetailsTable(this);
                this.reportTables.addElement(tbl);
            }
            tbl.setID("", QbUtil.toArray(this.reportTables));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot create table", ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
        LOGGER.finer("Building report table finished in " + (System.currentTimeMillis() - start) + " ms");
    }

    void setID() {
        if (this.pageHeader.getID().equals("")) {
            this.pageHeader.setID("PG_HDR");
        }
        if (this.reportHeader.getID().equals("")) {
            this.reportHeader.setID("RPT_HDR");
        }
        if (this.reportFooter.getID().equals("")) {
            this.reportFooter.setID("RPT_FTR");
        }
        if (this.pageFooter.getID().equals("")) {
            this.pageFooter.setID("PG_FTR");
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            if (!tbl.getID().equals("")) continue;
            tbl.setID("", QbUtil.toArray(this.reportTables));
        }
    }

    public boolean customIDExists(String id) {
        if (this.pageHeader.customIDExists(id)) {
            return true;
        }
        if (this.reportHeader.customIDExists(id)) {
            return true;
        }
        if (this.reportFooter.customIDExists(id)) {
            return true;
        }
        if (this.pageFooter.customIDExists(id)) {
            return true;
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            if (!table.customIDExists(id)) continue;
            return true;
        }
        return false;
    }

    public boolean containsZIndex() {
        if (this.pageHeader.containsZIndex()) {
            return true;
        }
        if (this.reportHeader.containsZIndex()) {
            return true;
        }
        if (this.reportFooter.containsZIndex()) {
            return true;
        }
        if (this.pageFooter.containsZIndex()) {
            return true;
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            if (!table.containsZIndex()) continue;
            return true;
        }
        return false;
    }

    public boolean[] formulaReferenced(Formula formula) {
        int i;
        if (this.pageHeader.formulaReferenced(formula)) {
            return new boolean[]{true, false};
        }
        if (this.reportHeader.formulaReferenced(formula)) {
            return new boolean[]{true, false};
        }
        if (this.reportFooter.formulaReferenced(formula)) {
            return new boolean[]{true, false};
        }
        if (this.pageFooter.formulaReferenced(formula)) {
            return new boolean[]{true, false};
        }
        for (i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            if (table.formulaReferenced(formula)) {
                return new boolean[]{true, false};
            }
            for (int j = 0; j < table.getColumns().size(); ++j) {
                int colInfoIndex = this.getColInfoIndex(j);
                if (this.colInfo[colInfoIndex].getFormulaObj() == formula) {
                    return new boolean[]{true, !table.getColumn(j).isVisible()};
                }
                if (this.colInfo[colInfoIndex].getFormulaObj() == null || !this.colInfo[colInfoIndex].getFormulaObj().formulaReferenced(formula)) continue;
                return new boolean[]{true, !table.getColumn(j).isVisible()};
            }
        }
        for (i = 0; i < this.formulas.size(); ++i) {
            if (!this.formulas.elementAt(i).formulaReferenced(formula)) continue;
            return new boolean[]{true, false};
        }
        return new boolean[]{false, false};
    }

    public boolean scriptReferenced(Script script) {
        LOGGER.finest("Page header");
        if (this.pageHeader.scriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Report header");
        if (this.reportHeader.scriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Report footer");
        if (this.reportFooter.scriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Report footer");
        if (this.pageFooter.scriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Page footer");
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            if (!table.scriptReferenced(script)) continue;
            return true;
        }
        LOGGER.finest("Report table");
        return false;
    }

    public boolean securityScriptReferenced(Script script) {
        if (this.pageHeader.securityScriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Page header");
        if (this.reportHeader.securityScriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Report header");
        LOGGER.finest("");
        if (this.reportFooter.securityScriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Report footer");
        if (this.pageFooter.securityScriptReferenced(script)) {
            return true;
        }
        LOGGER.finest("Page footer");
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            if (!table.securityScriptReferenced(script)) continue;
            return true;
        }
        LOGGER.finest("Report table");
        return false;
    }

    public void removeScriptReferenced(Script script) {
        this.pageHeader.removeScriptReferenced(script);
        this.reportHeader.removeScriptReferenced(script);
        this.reportFooter.removeScriptReferenced(script);
        this.pageFooter.removeScriptReferenced(script);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.removeScriptReferenced(script);
        }
    }

    public void buildFormulaList() {
        this.pageHeader.createFormulaObject(this);
        this.reportHeader.createFormulaObject(this);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.createFormulaObject(this);
        }
        this.reportFooter.createFormulaObject(this);
        this.pageFooter.createFormulaObject(this);
    }

    public void createFormulaObjectFromName() {
        this.pageHeader.createFormulaObjectFromName(this);
        this.reportHeader.createFormulaObjectFromName(this);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.createFormulaObjectFromName(this);
        }
        this.reportFooter.createFormulaObjectFromName(this);
        this.pageFooter.createFormulaObjectFromName(this);
    }

    public void buildScriptList() {
        this.pageHeader.createScriptObject(this.scripts);
        this.reportHeader.createScriptObject(this.scripts);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.createScriptObject(this.scripts);
        }
        this.reportFooter.createScriptObject(this.scripts);
        this.pageFooter.createScriptObject(this.scripts);
    }

    public void useIDForColumnHeader() {
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportCell[] cells;
            ReportTable table = this.reportTables.elementAt(i);
            for (ReportCell cell : cells = table.getHeader().getData()) {
                if (!(cell instanceof ColumnHeader)) continue;
                this.replaceFormulaWithID((ColumnHeader)cell);
            }
        }
    }

    private ColumnHeader replaceFormulaWithID(ColumnHeader cell) {
        String oldFormula = cell.getFormulaObj().getText();
        if (oldFormula.startsWith("getHeader(COL(")) {
            String idx = oldFormula.substring(14);
            int endIndex = idx.indexOf(41);
            if (endIndex < 0) {
                return cell;
            }
            idx = idx.substring(0, endIndex);
            int colIdx = Integer.valueOf(idx);
            String colName = this.getDBTableName(colIdx) + "." + this.getColumnName(colIdx);
            String newFormula = "getHeader({" + colName + "})";
            this.rebuildColumnHeader(cell, newFormula);
        }
        return cell;
    }

    private void rebuildColumnHeader(ColumnHeader cell, String newFormula) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(newFormula.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
            cell.getFormulaObj().setText(newFormula);
            cell.getFormulaObj().setFormula(parser.parse(this.formulas, this.getQueryParameters(), this.getFormulaParameters(), cell.getFormulaName()));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to rebuild column header", ex);
        }
    }

    public Vector<ReportChartObject> getAllCharts() {
        Vector<ReportChartObject> charts = new Vector<ReportChartObject>();
        QbUtil.addArrayToVector(charts, this.pageHeader.getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.reportHeader.getReportChartObjects());
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            QbUtil.addArrayToVector(charts, table.getAllReportChartObjects());
        }
        QbUtil.addArrayToVector(charts, this.reportFooter.getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.pageFooter.getReportChartObjects());
        return charts;
    }

    public void createScriptObjectFromName() {
        this.pageHeader.createScriptObjectFromName(this.scripts);
        this.reportHeader.createScriptObjectFromName(this.scripts);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.createScriptObjectFromName(this.scripts);
        }
        this.reportFooter.createScriptObjectFromName(this.scripts);
        this.pageFooter.createScriptObjectFromName(this.scripts);
    }

    public void setSecurityLevelProperties(String levelName, ReportElement level) {
        this.pageHeader.setSecurityLevelProperties(levelName, level);
        this.reportHeader.setSecurityLevelProperties(levelName, level);
        this.reportFooter.setSecurityLevelProperties(levelName, level);
        this.pageFooter.setSecurityLevelProperties(levelName, level);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setSecurityLevelProperties(levelName, level);
        }
    }

    public String[] getSecurityLevels() {
        Vector<Report> drillRpt;
        Report[] subRpt;
        int i;
        String[] temp = this.pageHeader.getSecurityLevels();
        Vector<String> levels = new Vector<String>();
        for (String element : temp) {
            levels.addElement(element);
        }
        temp = this.reportHeader.getSecurityLevels();
        for (i = 0; i < temp.length; ++i) {
            if (levels.contains(temp[i])) continue;
            levels.addElement(temp[i]);
        }
        temp = this.reportFooter.getSecurityLevels();
        for (i = 0; i < temp.length; ++i) {
            if (levels.contains(temp[i])) continue;
            levels.addElement(temp[i]);
        }
        temp = this.pageFooter.getSecurityLevels();
        for (i = 0; i < temp.length; ++i) {
            if (levels.contains(temp[i])) continue;
            levels.addElement(temp[i]);
        }
        for (i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            temp = tbl.getSecurityLevels();
            for (int j = 0; j < temp.length; ++j) {
                if (levels.contains(temp[j])) continue;
                levels.addElement(temp[j]);
            }
        }
        if (this.securityQueryParameterMap != null) {
            Enumeration<String> enum1 = this.securityQueryParameterMap.keys();
            while (enum1.hasMoreElements()) {
                String obj = enum1.nextElement();
                if (obj == null || levels.contains(obj)) continue;
                levels.addElement(obj.toString());
            }
        }
        if ((subRpt = this.getSubReportArray()) != null) {
            for (Report element : subRpt) {
                if (element == null) continue;
                temp = element.getSecurityLevels();
                for (int j = 0; j < temp.length; ++j) {
                    if (levels.contains(temp[j])) continue;
                    levels.addElement(temp[j]);
                }
            }
        }
        if ((drillRpt = this.getDrillDownReportVector()) != null) {
            for (int i2 = 0; i2 < drillRpt.size(); ++i2) {
                temp = drillRpt.elementAt(i2).getSecurityLevels();
                for (int j = 0; j < temp.length; ++j) {
                    if (levels.contains(temp[j])) continue;
                    levels.addElement(temp[j]);
                }
            }
        }
        String[] ls = new String[levels.size()];
        for (int i3 = 0; i3 < ls.length; ++i3) {
            ls[i3] = (String)levels.elementAt(i3);
        }
        return ls;
    }

    public Color[] getAllColors() {
        Vector<Color> colors = new Vector<Color>();
        colors = this.getAllColors(colors);
        Color[] res = new Color[colors.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = colors.elementAt(i);
        }
        return res;
    }

    private Vector<Color> getAllColors(Vector<Color> colors) {
        if (this.backgroundColor != null) {
            colors.addElement(this.backgroundColor);
        }
        colors = this.pageHeader.getAllColors(colors);
        colors = this.reportHeader.getAllColors(colors);
        colors = this.reportFooter.getAllColors(colors);
        colors = this.pageFooter.getAllColors(colors);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            colors = tbl.getAllColors(colors);
        }
        Report[] subRpt = this.getSubReportArray();
        if (subRpt != null) {
            for (Report element : subRpt) {
                if (element == null) continue;
                colors = element.getAllColors(colors);
            }
        }
        return colors;
    }

    public String[] getSecuredScripts() {
        int i;
        String[] temp = this.pageHeader.getSecuredScripts();
        Vector<String> scripts = new Vector<String>();
        for (String element : temp) {
            scripts.addElement(element);
        }
        temp = this.reportHeader.getSecuredScripts();
        for (i = 0; i < temp.length; ++i) {
            if (scripts.contains(temp[i])) continue;
            scripts.addElement(temp[i]);
        }
        temp = this.reportFooter.getSecuredScripts();
        for (i = 0; i < temp.length; ++i) {
            if (scripts.contains(temp[i])) continue;
            scripts.addElement(temp[i]);
        }
        temp = this.pageFooter.getSecuredScripts();
        for (i = 0; i < temp.length; ++i) {
            if (scripts.contains(temp[i])) continue;
            scripts.addElement(temp[i]);
        }
        for (i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            temp = tbl.getSecuredScripts();
            for (int j = 0; j < temp.length; ++j) {
                if (scripts.contains(temp[j])) continue;
                scripts.addElement(temp[j]);
            }
        }
        String[] ls = new String[scripts.size()];
        for (int i2 = 0; i2 < ls.length; ++i2) {
            ls[i2] = (String)scripts.elementAt(i2);
        }
        return ls;
    }

    public void setReportObjectForSubReports(String filename, ISubReport rptobject) {
        int i;
        this.pageHeader.setReportObjectForSubReports(filename, rptobject);
        this.reportHeader.setReportObjectForSubReports(filename, rptobject);
        this.reportFooter.setReportObjectForSubReports(filename, rptobject);
        this.pageFooter.setReportObjectForSubReports(filename, rptobject);
        for (i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setReportObjectForSubReports(filename, rptobject);
        }
        if (this.subReports != null) {
            for (i = 0; i < this.subReports.size(); ++i) {
                SubReportObject sr = this.subReports.elementAt(i);
                if (sr.getFileName() == null || !sr.getFileName().equals(filename)) continue;
                sr.setSubReport(rptobject);
            }
        }
    }

    public void updateSubReportFileName(String oldfilename, String newfilename) {
        int i;
        this.pageHeader.updateSubReportFileName(oldfilename, newfilename);
        this.reportHeader.updateSubReportFileName(oldfilename, newfilename);
        this.reportFooter.updateSubReportFileName(oldfilename, newfilename);
        this.pageFooter.updateSubReportFileName(oldfilename, newfilename);
        for (i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.updateSubReportFileName(oldfilename, newfilename);
        }
        if (this.subReports != null) {
            for (i = 0; i < this.subReports.size(); ++i) {
                SubReportObject sr = this.subReports.elementAt(i);
                if (sr.getFileName() == null || !sr.getFileName().equals(oldfilename)) continue;
                sr.setFileName(newfilename);
            }
        }
    }

    public void setChartExportHTMLParameters(String dirLocation, String url, String fileName) {
        try {
            this.formatTable();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Cannot format table", e);
        }
        this.pageHeader.setHTMLParameters(dirLocation, url, fileName);
        this.reportHeader.setHTMLParameters(dirLocation, url, fileName);
        this.reportFooter.setHTMLParameters(dirLocation, url, fileName);
        this.pageFooter.setHTMLParameters(dirLocation, url, fileName);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setHTMLParameters(dirLocation, url, fileName);
        }
        this.setChartExportHTMLParametersHelper(this, dirLocation, url, fileName);
    }

    private void setChartExportHTMLParametersHelper(Report report, String dirLocation, String url, String fileName) {
        if (report.subReports != null && report.subReports.size() > 0) {
            Report[] subReport = report.getSubReportArray();
            for (int i = 0; i < subReport.length; ++i) {
                this.subReports.elementAt(i).setHTMLParameters(dirLocation, url, fileName);
                if (subReport[i] == null) continue;
                this.setChartExportHTMLParametersHelper(subReport[i], dirLocation, url, fileName);
            }
        }
        if (report.currentNode != null) {
            for (int i = 0; i < report.currentNode.getChildCount(); ++i) {
                DrillDownNode node = report.currentNode.getChildAt(i);
                node.setHTMLParameters(dirLocation, url);
                LoadReport lr = new LoadReport();
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                try {
                    Report r = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : lr.loadReportFromFile(node.getFileName());
                    this.setChartExportHTMLParametersHelper(r, dirLocation, url, fileName);
                    continue;
                }
                catch (Exception IOException2) {
                    LOGGER.log(Level.FINEST, "Failed to load report", IOException2);
                }
            }
        }
    }

    public void setChartPath(String path) {
        this.pageHeader.setChartPath(path);
        this.reportHeader.setChartPath(path);
        this.reportFooter.setChartPath(path);
        this.pageFooter.setChartPath(path);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setChartPath(path);
        }
        this.setChartPathHelper(this, path);
    }

    private void setChartPathHelper(Report report, String path) {
        if (report.subReports != null && report.subReports.size() > 0) {
            Report[] subReport = report.getSubReportArray(true);
            for (int i = 0; i < subReport.length; ++i) {
                report.subReports.elementAt(i).setChartPath(path);
                if (subReport[i] == null) continue;
                this.setChartPathHelper(subReport[i], path);
            }
        }
        if (report.currentNode != null) {
            this.setDrillDownChartPath(report.currentNode, path);
            for (int i = 0; i < report.currentNode.getChildCount(); ++i) {
                DrillDownNode node = report.currentNode.getChildAt(i);
                LoadReport lr = new LoadReport();
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                try {
                    Report r = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : lr.loadReportFromFile(node.getFileName());
                    this.setChartPathHelper(r, path);
                    continue;
                }
                catch (Exception IOException2) {
                    LOGGER.log(Level.FINEST, "Failed to load report", IOException2);
                }
            }
        }
    }

    private void setDrillDownChartPath(DrillDownNode node, String path) {
        node.setChartPath(path);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setDrillDownChartPath(node.getChildAt(i), path);
        }
    }

    public void setImagePath(String path) {
        this.pageHeader.setImagePath(path);
        this.reportHeader.setImagePath(path);
        this.reportFooter.setImagePath(path);
        this.pageFooter.setImagePath(path);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setImagePath(path);
        }
        this.setImagePathHelper(this, path);
    }

    private void setImagePathHelper(Report report, String path) {
        if (report.subReports != null && report.subReports.size() > 0) {
            Report[] subReport = report.getSubReportArray(true);
            for (int i = 0; i < subReport.length; ++i) {
                report.subReports.elementAt(i).setImagePath(path);
                if (subReport[i] == null) continue;
                this.setImagePathHelper(subReport[i], path);
            }
        }
        if (report.currentNode != null) {
            this.setDrillDownImagePath(report.currentNode, path);
            for (int i = 0; i < report.currentNode.getChildCount(); ++i) {
                DrillDownNode node = report.currentNode.getChildAt(i);
                LoadReport lr = new LoadReport();
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                try {
                    Report r = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : lr.loadReportFromFile(node.getFileName());
                    this.setImagePathHelper(r, path);
                    continue;
                }
                catch (Exception IOException2) {
                    LOGGER.log(Level.FINEST, "Failed to load report", IOException2);
                }
            }
        }
    }

    private void setDrillDownImagePath(DrillDownNode node, String path) {
        node.setImagePath(path);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setDrillDownImagePath(node.getChildAt(i), path);
        }
    }

    public String getSubReportPath() {
        return this.subReportPath;
    }

    public void setSubReportPath(String path) {
        if (path == null) {
            return;
        }
        this.subReportPath = path;
        this.pageHeader.setSubReportPath(path);
        this.reportHeader.setSubReportPath(path);
        this.reportFooter.setSubReportPath(path);
        this.pageFooter.setSubReportPath(path);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setSubReportPath(path);
        }
        this.setSubReportPathHelper(this, path);
        this.createSubReportArray(true);
    }

    private void setSubReportPathHelper(Report report, String path) {
        if (report.subReports != null && report.subReports.size() > 0) {
            for (int i = 0; i < this.subReports.size(); ++i) {
                Object loc = this.subReports.elementAt(i).getFileName();
                if (loc == null || ((String)loc).trim().equals("") || ((String)loc).toLowerCase().endsWith(".pak")) continue;
                loc = ((String)loc).replace('\\', '/');
                if (!(path = path.replace('\\', '/')).endsWith("/")) {
                    path = path + "/";
                }
                String fileName = QbUtil.getFileName((String)loc);
                this.subReports.elementAt(i).setFileName(path + fileName);
            }
            Report[] subReport = report.getSubReportArray(true);
            for (Report element : subReport) {
                if (element == null) continue;
                this.setSubReportPathHelper(element, path);
            }
        }
        if (report.currentNode != null) {
            this.setDrillDownSubReportPath(report.currentNode, path);
            for (int i = 0; i < report.currentNode.getChildCount(); ++i) {
                DrillDownNode node = report.currentNode.getChildAt(i);
                LoadReport lr = new LoadReport();
                lr.setSubFilesTable(this.subFilesTable);
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                try {
                    Report r = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : lr.loadReportFromFile(node.getFileName(this.subFilesTable));
                    this.setSubReportPathHelper(r, path);
                    continue;
                }
                catch (Exception IOException2) {
                    LOGGER.log(Level.FINEST, "Failed to load report", IOException2);
                }
            }
        }
    }

    private void setDrillDownSubReportPath(DrillDownNode node, String path) {
        node.setSubReportPath(path);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setDrillDownSubReportPath(node.getChildAt(i), path);
        }
    }

    public void setDrillDownPath(String path) {
        this.setDrillDownPath(path, false);
    }

    public void setDrillDownPath(String path, boolean isRoot) {
        this.setDrillDownPathHelper(this.currentNode, path, isRoot);
        this.setDrillDownPathHelper(this, path, isRoot);
    }

    private void setDrillDownPathHelper(Report report, String path, boolean isRoot) {
        if (report.subReports != null && report.subReports.size() > 0) {
            Report[] subReport;
            for (Report element : subReport = report.getSubReportArray(true)) {
                if (element == null) continue;
                this.setDrillDownPathHelper(element, path, true);
            }
        }
        if (report.currentNode != null) {
            this.setDrillDownPathHelper(report.currentNode, path, isRoot);
            for (int i = 0; i < report.currentNode.getChildCount(); ++i) {
                DrillDownNode node = report.currentNode.getChildAt(i);
                LoadReport lr = new LoadReport();
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                lr.setSubFilesTable(report.getSubFilesTable());
                try {
                    Report r = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : lr.loadReportFromFile(node.getFileName());
                    this.setDrillDownPathHelper(r, path, false);
                    continue;
                }
                catch (Exception IOException2) {
                    LOGGER.log(Level.FINEST, "Failed to load report", IOException2);
                }
            }
        }
    }

    private void setDrillDownPathHelper(DrillDownNode node, String path, boolean isRoot) {
        String loc;
        if (node == null || path == null) {
            return;
        }
        node.setDrillDownPath(path);
        if (!(isRoot || (loc = node.getFileName()) == null || loc.trim().equals("") || loc.toLowerCase().endsWith(".pak"))) {
            loc = loc.replace('\\', '/');
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
            String fileName = QbUtil.getFileName(loc);
            node.setFileName(path + fileName);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.setDrillDownPathHelper(node.getChildAt(i), path, false);
        }
    }

    public String getServletDirectory() {
        return this.servletDirectory;
    }

    public void setServletDirectory(String path) {
        this.servletDirectory = path;
    }

    @Override
    public ReportElement getData(String id) {
        ReportElement obj = this.reportHeader.getData(id);
        if (obj != null) {
            return obj;
        }
        obj = this.pageHeader.getData(id);
        if (obj != null) {
            return obj;
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            obj = tbl.getData(id);
            if (obj == null) continue;
            return obj;
        }
        obj = this.pageFooter.getData(id);
        if (obj != null) {
            return obj;
        }
        obj = this.reportFooter.getData(id);
        return obj;
    }

    public ReportTable getParentTableWithCell(String id, ReportTable table) {
        ReportCell obj = this.reportHeader.getData(id);
        if (obj != null) {
            return this.reportTables.elementAt(0);
        }
        obj = this.pageHeader.getData(id);
        if (obj != null) {
            return this.reportTables.elementAt(0);
        }
        ReportTable tbl = this.reportTables.elementAt(0).getParentTableWithCell(id, table);
        if (tbl != null) {
            return tbl;
        }
        obj = this.pageFooter.getData(id);
        if (obj != null) {
            return this.reportTables.elementAt(0);
        }
        obj = this.reportFooter.getData(id);
        if (obj != null) {
            return this.reportTables.elementAt(0);
        }
        return this.reportTables.elementAt(0);
    }

    public ReportTable getParentTable(ReportTable table) {
        return this.reportTables.elementAt(0).getParentTable(table);
    }

    public double getMinWidth() {
        double maxX = this.reportHeader.getMinWidth();
        double val = this.pageHeader.getMinWidth();
        if (val > maxX) {
            maxX = val;
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            val = tbl.getMinWidth();
            if (!(val > maxX)) continue;
            maxX = val;
        }
        val = this.pageFooter.getMinWidth();
        if (val > maxX) {
            maxX = val;
        }
        if ((val = this.reportFooter.getMinWidth()) > maxX) {
            maxX = val;
        }
        return maxX;
    }

    public void resize(double ratioX, double ratioY) {
        this.reportHeader.resize(ratioX, ratioY);
        this.pageHeader.resize(ratioX, ratioY);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.resize(ratioX, ratioY);
        }
        this.pageFooter.resize(ratioX, ratioY);
        this.reportFooter.resize(ratioX, ratioY);
    }

    public void autoFitColumns() {
        double pageW;
        double minX = this.getMinWidth();
        if (minX <= (pageW = this.getActualPageWidth())) {
            return;
        }
        this.resize(pageW / minX, 1.0);
    }

    void setGridLineLink() {
        this.reportHeader.setGridLineLink(this);
        this.pageHeader.setGridLineLink(this);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            this.reportTables.elementAt(i).setGridLineLink(this);
        }
        this.pageFooter.setGridLineLink(this);
        this.reportFooter.setGridLineLink(this);
    }

    private void formatColInfo(ColInfo[] mapping, boolean createBackup) throws Exception {
        Vector<ColInfo> breakCol = new Vector<ColInfo>();
        Vector<Integer> breakColIndex = new Vector<Integer>();
        Vector<Integer> masterIndex = new Vector<Integer>();
        Vector<Integer> colBreakIndices = new Vector<Integer>();
        Vector<Integer> colBreakValues = new Vector<Integer>();
        Vector<ColInfo> valueCol = new Vector<ColInfo>();
        Vector<ColInfo> infoCol = new Vector<ColInfo>();
        boolean aggregateColumn = false;
        this.doAggregation = this.reportType != 0 && this.reportType != 3 && this.reportType != 4;
        for (int i = 0; i < mapping.length; ++i) {
            if (mapping[i] == null) continue;
            int m = mapping[i].getMapping();
            if (m < 0 || m >= this.colData.length) {
                if (mapping[i].getFormulaObj() == null && mapping[i].getFormula() == null) continue;
                infoCol.addElement(mapping[i]);
                continue;
            }
            if (!createBackup) {
                infoCol.addElement(mapping[i]);
            } else {
                infoCol.addElement((ColInfo)mapping[i].clone());
            }
            if (this.reportType == 3 && mapping[i].isMaster()) {
                masterIndex.addElement(i);
            }
            if (this.reportType == 0 || this.reportType == 4) continue;
            if (mapping[i].isColumnBreak()) {
                colBreakIndices.addElement(i);
                if (this.isForExportOnly() && this.reportType == 2 && this.distColValue != null) {
                    this.colData[mapping[i].getMapping()].setFieldForExportOnly(this.distColValue);
                    this.colData[mapping[i].getMapping()].createHashTable();
                    continue;
                }
                this.colData[mapping[i].getMapping()].retrieveField();
                this.colData[mapping[i].getMapping()].createHashTable();
                continue;
            }
            if (mapping[i].isColumnBreakValue()) {
                colBreakValues.addElement(i);
                valueCol.addElement(mapping[i]);
                if (mapping[i].getAggregation() != 0) continue;
                this.doAggregation = false;
                continue;
            }
            if (mapping[i].isRowBreak()) {
                if (this.reportType == 3 && breakCol.size() > 0) {
                    valueCol.addElement(mapping[i]);
                    continue;
                }
                breakCol.addElement(mapping[i]);
                breakColIndex.addElement(i);
                this.colData[mapping[i].getMapping()].retrieveField();
                this.colData[mapping[i].getMapping()].createHashTable();
                continue;
            }
            valueCol.addElement(mapping[i]);
            if (mapping[i].isAggregatedColumn()) {
                aggregateColumn = true;
            }
            if (mapping[i].getAggregation() != 0 && mapping[i].isAggregatedColumn()) continue;
            this.doAggregation = false;
        }
        if (this.reportType != 0 && this.reportType != 4 && breakCol.size() == 0) {
            throw new Exception("Row break is required for summary break, cross tab and master detail report!");
        }
        if (this.reportType == 3) {
            this.doAggregation = false;
        }
        if (this.reportType == 1 && aggregateColumn && !this.doAggregation) {
            throw new Exception("Summary Break : Aggregation is required for all the NON ROW BREAK columns!");
        }
        if (this.reportType == 2) {
            int i;
            if (!this.doAggregation) {
                throw new Exception("CrossTab : Aggregation is required for all the NON COLUMN BREAK columns!");
            }
            if (colBreakIndices.size() == 0 || colBreakValues.size() == 0) {
                throw new Exception("Column break and column value are required for cross tab report!");
            }
            this.columnBreakCount = colBreakIndices.size();
            int rowVal = (Integer)colBreakValues.elementAt(0);
            for (i = 0; i < this.columnBreakCount; ++i) {
                breakCol.addElement(mapping[(Integer)colBreakIndices.elementAt(i)]);
                breakColIndex.addElement((Integer)colBreakIndices.elementAt(i));
                mapping[(Integer)colBreakIndices.elementAt(i)].setAggregation(mapping[rowVal].getAggregation());
            }
            this.columnBreakValueCount = colBreakValues.size();
            for (i = 0; i < this.columnBreakValueCount; ++i) {
                rowVal = colBreakValues.elementAt(i);
                ColInfo rowInfo = new ColInfo(mapping[rowVal].getMapping());
                rowInfo.setAggregation(mapping[rowVal].getAggregation());
                valueCol.insertElementAt(rowInfo, i);
            }
        }
        this.colInfo = this.convertVectorToColInfo(infoCol);
        this.breakColInfo = this.convertVectorToColInfo(breakCol);
        this.breakColIndex = this.convertVectorToInt(breakColIndex);
        this.breakColValueIndex = this.convertVectorToInt(colBreakValues);
        this.valColInfo = this.convertVectorToColInfo(valueCol);
        this.masterIndex = this.convertVectorToInt(masterIndex);
    }

    private int getColumnBreakValueMapping() {
        for (ColInfo element : this.valColInfo) {
            if (!element.isColumnBreakValue()) continue;
            return element.getMapping();
        }
        return -1;
    }

    private void insertFormula(ReportTable tbl) throws Exception {
        if (this.reportType == 2 && !this.showColumnAggregation) {
            return;
        }
        int colBkFooterCount = tbl.countRowBreakFooter();
        double newY = tbl.getHeader().getHeight();
        double defaultCellHeight = ReportStyle.getDefaultCellHeight(this.reportStyle);
        if (this.columnAggregationInHeader) {
            if (this.placeColumnBreakValueVertically()) {
                tbl.getHeader().setHeight(newY + defaultCellHeight * (double)this.getColumnBreakValueCount());
            } else {
                tbl.getHeader().setHeight(newY + defaultCellHeight);
            }
        } else if (this.placeColumnBreakValueVertically()) {
            tbl.getFooter().setHeight(defaultCellHeight * (double)this.getColumnBreakValueCount());
        }
        if (this.reportType == 2) {
            CrossTabTable.insertCrossTabFormula(this, tbl, colBkFooterCount, newY);
        }
        Vector<String> previousColNames = new Vector<String>();
        for (int i = 0; i < this.colInfo.length; ++i) {
            short aggr;
            if (this.colInfo[i].isColumnBreak() || this.colInfo[i].isRowBreak() || !this.isShowRowAggregationGrandTotal() && this.colInfo[i].isColumnBreakValue()) continue;
            int colIndex = this.getTableColumn(i, tbl);
            if (!this.isShowRowAggregationGrandTotal() && this.isCrossTab()) {
                ++colIndex;
            }
            if (tbl.getColumn(colIndex) == null || !tbl.getColumn(colIndex).isVisible() || !this.colInfo[i].isVisible() || (aggr = this.colInfo[i].getAggregation()) == 0) continue;
            int dataType = this.colInfo[i].getFormulaObj() != null ? this.colInfo[i].getDataType() : this.colData[this.colInfo[i].getMapping()].getOriginalDataType();
            ReportCell cell = this.createReportCell(tbl.getColumn(colIndex), colIndex, aggr, dataType, previousColNames, false);
            cell.setX(tbl.getColumn(colIndex).getX());
            if (!this.columnAggregationInHeader) {
                tbl.getFooter().addData(cell);
                cell.setY(tbl.getColumn(colIndex).getY());
            } else {
                cell.setY(newY + tbl.getColumn(colIndex).getY());
                tbl.getHeader().addData(cell);
            }
            for (int j = 0; j < colBkFooterCount; ++j) {
                cell = this.createReportCell(tbl.getColumn(colIndex), colIndex, aggr, dataType, previousColNames, false);
                cell.setX(tbl.getColumn(colIndex).getX());
                cell.setY(tbl.getColumn(colIndex).getY());
                if (!this.columnAggregationInHeader) {
                    tbl.getRowBreakFooter(j).addData(cell);
                    continue;
                }
                tbl.getRowBreakHeader(j).addData(cell);
            }
            previousColNames.add(tbl.getColumn(colIndex).getText());
        }
    }

    ReportCell createReportCell(ReportColumn column, int i, short aggr, int sqlType, Vector<String> previousColNames, boolean forFooterSection) {
        String text;
        String name;
        int dataType = DataType.mapType(sqlType);
        switch (dataType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                if (aggr > 0) break;
                aggr = 1;
                break;
            }
        }
        ReportCell cell = null;
        cell = column instanceof ColumnBreakColumn ? new CBColumnFooter(((ColumnBreakColumn)column).getColBreakValueIndex()) : (column instanceof CBAggrColumn ? new CBAggrColFooter(((CBAggrColumn)column).getColBreakLevel(), ((CBAggrColumn)column).getColBreakValueIndex()) : new ReportCell());
        if (this.reportType != 2 && !this.containsKey(column.getText(), previousColNames)) {
            name = ColInfo.AGGR[aggr] + "_" + column.getText().replaceAll(" ", "_");
            text = ColInfo.AGGR[aggr] + "({" + column.getText() + "})";
        } else {
            name = ColInfo.AGGR[aggr] + "_COL" + i;
            text = ColInfo.AGGR[aggr] + "(COL(" + i + "))";
        }
        Formula theformula = new Formula(name, text);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(text.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewFormulaParser parser = new NewFormulaParser(inputStreamReader);
            theformula.setFormula(parser.parse(this.formulas, this.getQueryParameters(), this.getFormulaParameters(), text));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to process formula: " + text, e);
        }
        if (!this.formulaExists(name)) {
            this.formulas.addElement(theformula);
        }
        theformula.getDatatype(this);
        cell.setFormulaObj(theformula);
        return cell;
    }

    private boolean containsKey(String key, Vector<String> vec) {
        if (vec == null) {
            return false;
        }
        for (int i = 0; i < vec.size(); ++i) {
            if (!key.equals(vec.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public int getTableColumn(int colInfoIndex, ReportTable tbl) {
        if (this.reportType != 2) {
            return colInfoIndex;
        }
        for (int i = 0; i < this.getColumnBreakCount(); ++i) {
            int breakRowIndex = this.breakColIndex[this.breakColIndex.length - this.getColumnBreakCount() + i];
            if (i == 0 && colInfoIndex <= breakRowIndex) {
                return colInfoIndex;
            }
            if (colInfoIndex > breakRowIndex) continue;
            return colInfoIndex + tbl.getColumnBreakColumnCount() - i;
        }
        int temp = colInfoIndex + tbl.getColumnBreakColumnCount() - this.getColumnBreakCount();
        if (!this.showRowAggregationGrandTotal) {
            temp -= this.columnBreakValueCount;
        }
        return temp;
    }

    private ColInfo[] convertVectorToColInfo(Vector<ColInfo> vec) {
        ColInfo[] temp = new ColInfo[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            temp[i] = vec.elementAt(i);
        }
        return temp;
    }

    private int[] convertVectorToInt(Vector<Integer> vec) throws Exception {
        int[] temp = new int[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            temp[i] = vec.elementAt(i);
        }
        return temp;
    }

    public ColInfo[] getNewColInfoSet(ColInfo newCol) {
        return this.getNewColInfoSet(newCol, this.colInfo.length);
    }

    public ColInfo[] getNewColInfoSet(ColInfo newCol, int index) {
        return Report.getNewColInfoSet(this.colInfo, newCol, index);
    }

    public ColInfo[] addFormulaColumn(ColInfo[] fColInfo) {
        ColInfo[] newColInfo = this.colInfo;
        for (ColInfo element : fColInfo) {
            if (element.getMapping() >= 0) continue;
            newColInfo = Report.getNewColInfoSet(newColInfo, element, newColInfo.length);
        }
        return newColInfo;
    }

    public Report addColInfo(ColInfo newCol, boolean adjustCrossTabForColumnCount) {
        return this.updateColInfo(this.getNewColInfoSet(newCol, this.colInfo.length), false, adjustCrossTabForColumnCount);
    }

    public Report addColInfo(ColInfo newCol, int index) {
        return this.updateColInfo(this.getNewColInfoSet(newCol, index), false);
    }

    public Report updateColInfo(ColInfo[] colInfo, boolean adjustColHeader) {
        return this.updateColInfo(colInfo, adjustColHeader, true);
    }

    public Report updateColInfo(ColInfo[] colInfo, boolean adjustColHeader, boolean adjustCrossTabForColumnCount) {
        Report newReport = new Report(this.colData);
        newReport.colDataSorted = this.colDataSorted;
        newReport.recIndex = this.recIndex;
        newReport.reOrderColumns = this.reOrderColumns;
        newReport.showRowAggregationGrandTotal = this.showRowAggregationGrandTotal;
        newReport.showColumnAggregation = this.showColumnAggregation;
        newReport.crossTabFreeForm = this.crossTabFreeForm;
        newReport.columnAggregationInHeader = this.columnAggregationInHeader;
        newReport.showRowAggregationSubtotal = this.showRowAggregationSubtotal;
        newReport.rowAggregationSubtotalOnLeft = this.rowAggregationSubtotalOnLeft;
        newReport.alignCrossTabColBkValHori = this.alignCrossTabColBkValHori;
        newReport.createTable(this.getReportType(), colInfo, false, true);
        newReport.copy(this, adjustColHeader, adjustCrossTabForColumnCount);
        return newReport;
    }

    private void copy(Report _report) {
        this.copy(_report, true);
    }

    private void copy(Report _report, boolean adjustColHeader) {
        this.copy(_report, adjustColHeader, true);
    }

    private void copy(Report _report, boolean adjustColHeader, boolean adjustCrossTabForColumnCount) {
        this.copy(_report, adjustColHeader, adjustCrossTabForColumnCount, true);
    }

    private void copy(Report _report, boolean adjustColHeader, boolean adjustCrossTabForColumnCount, boolean copyVisible) {
        this.isCopy = true;
        this.copyFitGroupColInfo(this.colInfo, _report.colInfo);
        this.name = _report.name;
        this.filename = _report.filename;
        this.pageHeader.copy(_report.getPageHeader());
        this.reportHeader.copy(_report.getReportHeader());
        this.reportFooter.copy(_report.getReportFooter());
        this.pageFooter.copy(_report.getPageFooter());
        this.setGridLineLink();
        this.pageWidth = _report.pageWidth;
        this.pageHeight = _report.pageHeight;
        this.leftMargin = _report.leftMargin;
        this.rightMargin = _report.rightMargin;
        this.topMargin = _report.topMargin;
        this.bottomMargin = _report.bottomMargin;
        this.orientation = _report.orientation;
        this.sourceData = _report.sourceData;
        this.originalSourceData = _report.originalSourceData;
        this.dbInfo = _report.dbInfo;
        this.parameters = _report.parameters;
        this.queryParameters = _report.getQueryParameters();
        this.formulaParameters = _report.formulaParameters;
        this.subQueryParamTable = _report.subQueryParamTable;
        this.subFormulaParamTable = _report.subFormulaParamTable;
        this.queryFilename = _report.queryFilename;
        this.queryFileInfo = _report.queryFileInfo;
        this.sourceFile = _report.sourceFile;
        this.xmlFileQueryInfo = _report.xmlFileQueryInfo;
        this.jndiName = _report.jndiName;
        this.homeName = _report.homeName;
        this.remoteName = _report.remoteName;
        this.selectedMethodName = _report.selectedMethodName;
        this.selectedMethodParamVal = _report.selectedMethodParamVal;
        this.environment = _report.environment;
        this.soapInfo = _report.soapInfo;
        this.sfQueryInfo = _report.sfQueryInfo;
        this.excelInfo = _report.excelInfo;
        this.olapRS = _report.olapRS;
        this.mondrianConnectionString = _report.mondrianConnectionString;
        this.MDXQuery = _report.MDXQuery;
        this.xmlaURI = _report.xmlaURI;
        this.xmlaDataSource = _report.xmlaDataSource;
        this.xmlaCatalog = _report.xmlaCatalog;
        this.rowBreakAggrIncluded = _report.rowBreakAggrIncluded;
        this.colBreakAggrIncluded = _report.colBreakAggrIncluded;
        this.keepDataSourceOrder = _report.keepDataSourceOrder;
        this.sourceList = _report.sourceList;
        this.sourceType = _report.sourceType;
        this.doTranspose = _report.doTranspose;
        this.transposeColList = _report.transposeColList;
        this.isTransposed = _report.isTransposed;
        this.transposeCol = _report.transposeCol;
        this.originalColDataFromMemSource = _report.originalColDataFromMemSource;
        this.timeZone = _report.timeZone;
        this.locale = _report.locale;
        this.formula = _report.formula;
        this.column = _report.column;
        this.labelSetting = _report.labelSetting;
        this.imageSetting = _report.imageSetting;
        this.chartSetting = _report.chartSetting;
        this.columnHeaderSetting = _report.columnHeaderSetting;
        this.titleSetting = _report.titleSetting;
        this.stringFormulaSetting = _report.stringFormulaSetting;
        this.logicFormulaSetting = _report.logicFormulaSetting;
        this.numericFormulaSetting = _report.numericFormulaSetting;
        this.timeFormulaSetting = _report.timeFormulaSetting;
        this.stringColumnSetting = _report.stringColumnSetting;
        this.logicColumnSetting = _report.logicColumnSetting;
        this.numericColumnSetting = _report.numericColumnSetting;
        this.timeColumnSetting = _report.timeColumnSetting;
        this.barcodeColumnSetting = _report.barcodeColumnSetting;
        this.fontMapping = _report.fontMapping;
        this.richTextFonts = _report.richTextFonts;
        this.reOrderColumns = _report.reOrderColumns;
        this.showRowAggregationGrandTotal = _report.showRowAggregationGrandTotal;
        this.showColumnAggregation = _report.showColumnAggregation;
        this.crossTabFreeForm = _report.crossTabFreeForm;
        this.columnAggregationInHeader = _report.columnAggregationInHeader;
        this.showRowAggregationSubtotal = _report.showRowAggregationSubtotal;
        this.rowAggregationSubtotalOnLeft = _report.rowAggregationSubtotalOnLeft;
        this.alignCrossTabColBkValHori = _report.alignCrossTabColBkValHori;
        this.subFilesTable = _report.subFilesTable;
        this.useBackupData = _report.useBackupData;
        ReportCell[] globalFormatTemplates = new ReportCell[]{this.stringFormulaSetting, this.columnHeaderSetting, this.logicFormulaSetting, this.numericFormulaSetting, this.timeFormulaSetting};
        int columnCountMismatch = 0;
        int separatingIndex = -1;
        Vector<ReportColumn> columns = null;
        try {
            ReportTable tbl;
            if (this.reportType == 2 && adjustCrossTabForColumnCount && (columnCountMismatch = (tbl = this.getReportTables().elementAt(0)).getColumnCount() - _report.getReportTables().elementAt(0).getColumnCount()) != 0) {
                separatingIndex = tbl.getStartOfColumnBreakColumn() + tbl.getColumnBreakColumnCount() - columnCountMismatch;
                columns = _report.getReportTables().elementAt(0).getColumns();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to load crosstab-specific parameters", ex);
            columnCountMismatch = 0;
            separatingIndex = -1;
            columns = null;
        }
        if (columns == null && this.reportType == 2 && this.isCrossTabFixedField()) {
            columns = _report.getReportTables().elementAt(0).getColumns();
        }
        int len = this.getReportTables().size() <= _report.getReportTables().size() ? this.getReportTables().size() : _report.getReportTables().size();
        for (int i = 0; i < len; ++i) {
            ReportTable reportTable;
            this.getReportTables().elementAt(i).applyGlobalFormatToColumns(this.column);
            this.getReportTables().elementAt(i).loadTable(_report.getReportTables().elementAt(i), true, separatingIndex, this.showRowAggregationGrandTotal, true, copyVisible, globalFormatTemplates, this.reportType);
            this.getReportTables().elementAt(i).adjustColumnXPos(_report.getReportTables().elementAt(i), separatingIndex, this);
            int[] fieldsCount = null;
            boolean isRowAggregationSubtotalOnLeft = false;
            boolean isShowRowAggregationSubtotal = true;
            if (this.reportType == 2) {
                fieldsCount = ((CrossTabTable)this.getReportTables().elementAt(i)).getFieldsCount();
                isRowAggregationSubtotalOnLeft = ((CrossTabTable)this.getReportTables().elementAt((int)i)).mData.report.isRowAggregationSubtotalOnLeft();
                isShowRowAggregationSubtotal = ((CrossTabTable)this.getReportTables().elementAt((int)i)).mData.report.isShowRowAggregationSubtotal();
            }
            if ((reportTable = this.getReportTables().elementAt(i)) instanceof CrossTabTable) {
                CrossTabTable crossTabTable = (CrossTabTable)reportTable;
                crossTabTable.getCrossTabHeader().copy(_report.getReportTables().elementAt(i).getHeader(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, fieldsCount, isRowAggregationSubtotalOnLeft, isShowRowAggregationSubtotal, null, this.getReportTables().elementAt(i).getColumns());
                ReportCell[] cells = crossTabTable.getCrossTabHeader().getData();
                double latestX = 0.0;
                double firstX = 0.0;
                for (ReportCell cell : cells) {
                    if (!cell.isVisible() || !(cell instanceof CBColumnHeader) && (!(cell instanceof ColumnHeader) || cell.getCustomID().endsWith("FORM0"))) continue;
                    latestX = cell.getX();
                    if (firstX != 0.0) continue;
                    firstX = cell.getX();
                }
                crossTabTable.getCrossTabFooter().copy(_report.getReportTables().elementAt(i).getFooter(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, fieldsCount, isRowAggregationSubtotalOnLeft, isShowRowAggregationSubtotal, null, this.getReportTables().elementAt(i).getColumns());
                for (ReportCell cell : cells = crossTabTable.getCrossTabFooter().getData()) {
                    if (cell.getID().contains("_FTR_FORM") && !(cell.getX() > latestX) && !(cell.getX() < firstX)) continue;
                }
            } else {
                reportTable.getHeader().copy(_report.getReportTables().elementAt(i).getHeader(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, fieldsCount, null, this.getReportTables().elementAt(i).getColumns());
                reportTable.getFooter().copy(_report.getReportTables().elementAt(i).getFooter(), columnCountMismatch, separatingIndex, columns, globalFormatTemplates, false, false, true, true, false, fieldsCount, null, this.getReportTables().elementAt(i).getColumns());
            }
            this.getReportTables().elementAt(i).copyGuideLineElts(_report);
        }
        this.nullDataOption = _report.nullDataOption;
        this.isApplyBoundSelected = _report.isApplyBoundSelected();
        this.isHeadTagIncluded = _report.isHeadTagIncluded();
        this.isBackgroundTagIncluded = _report.isBackgroundTagIncluded();
        this.stringCustomizer = _report.getStringCustomizer();
        this.currentNode = _report.currentNode;
        this.parentNode = _report.parentNode;
        this.rootNode = _report.rootNode;
        this.subReports = _report.subReports;
        this.subReportArray = _report.subReportArray;
        this.sideBySideLayout = _report.sideBySideLayout;
        this.setColumnWrap(_report.getColumnWrap());
        this.forExportOnly = _report.forExportOnly;
        this.exportToMultiPages = _report.exportToMultiPages;
        this.exportToSingleWPagination = _report.exportToSingleWPagination;
        this.isExpandAndCollapseEnabled = _report.isExpandAndCollapseEnabled;
        this.isDefaultToExpandAll = _report.isDefaultToExpandAll;
        this.usingIE55DHTMLRendering = _report.usingIE55DHTMLRendering;
        this.centerDHTMLReport = _report.centerDHTMLReport;
        this.useStyleSheet = _report.useStyleSheet;
        this.externalCSS = _report.externalCSS;
        this.exportEncoding = _report.exportEncoding;
        this.htmlCharset = _report.htmlCharset;
        this.rtfEncoding = _report.rtfEncoding;
        this.useAllColorsForRTF = _report.useAllColorsForRTF;
        this.htmlTitle = _report.htmlTitle;
        this.exportDelim = _report.exportDelim;
        this.exportNewlineDelim = _report.exportNewlineDelim;
        this.addFormulas(_report.formulas);
        this.addScripts(_report.scripts);
        this.dbSourceType = _report.dbSourceType;
        this.queryFileBytes = _report.queryFileBytes;
        this.backgroundColor = _report.backgroundColor;
        this.backgroundImage = _report.backgroundImage;
        if ((this.colInfo.length != _report.colInfo.length || columnCountMismatch != 0) && adjustColHeader) {
            this.adjustHeaderFormulas();
            this.adjustFooterFormulas();
        }
        this.topN = _report.topN;
        this.ascending = _report.ascending;
        this.hasTitle = _report.hasTitle;
        this.hasLogo = _report.hasLogo;
        this.hasPageNumber = _report.hasPageNumber;
        this.hasDate = _report.hasDate;
        this.reportTitle = _report.reportTitle;
        this.logofile = _report.logofile;
        this.logoPos = _report.logoPos;
        this.pageNumberFormat = _report.pageNumberFormat;
        this.pageNumberPos = _report.pageNumberPos;
        this.dateFormat = _report.dateFormat;
        this.datePos = _report.datePos;
        this.reportStyle = _report.reportStyle;
        this.customStyleFile = _report.customStyleFile;
        this.vGuideLines = _report.vGuideLines;
        this.hGuideLines = _report.hGuideLines;
        this.showFormulaNameSelected = _report.showFormulaNameSelected;
        this.showCellOutline = _report.showCellOutline;
        this.previewSecurityLevel = _report.previewSecurityLevel;
        this.securityQueryParameterMap = _report.securityQueryParameterMap;
        this.snapToGrid = _report.snapToGrid;
        this.gridStepSize = _report.gridStepSize;
        this.cmGridStepSize = _report.cmGridStepSize;
        this.isAdjustFont = _report.isAdjustFont;
        this.registryID = _report.registryID;
        this.dataSourceID = _report.dataSourceID;
        this.dataSourceLoc = _report.dataSourceLoc;
        this.isDynamicExport = _report.isDynamicExport;
        this.serverName = _report.serverName;
        this.servletRunnerPort = _report.servletRunnerPort;
        this.setDynamicExport(_report.isDynamicExport, _report.relativeUrlToServlets());
        this.isHttpsDynamicExport = _report.isHttpsDynamicExport;
        this.httpsServerName = _report.httpsServerName;
        this.httpsServletRunnerPort = _report.httpsServletRunnerPort;
        this.drawBeforeDisplay = _report.drawBeforeDisplay;
        this.limitSubReportQueryExecution = _report.limitSubReportQueryExecution;
        this.isPrevParamPrompt = _report.isPrevParamPrompt;
        this.drillDownConn = _report.drillDownConn;
        this.databaseInfo = _report.databaseInfo;
        this.servletDirectory = _report.servletDirectory;
        this.order_offset = _report.order_offset;
        this.backupQuery = _report.backupQuery;
        this.replaceColumnInfoURI = _report.replaceColumnInfoURI;
        if (this.reportType == 2 && adjustCrossTabForColumnCount) {
            ReportStyle style = null;
            if (this.reportStyle == 1) {
                style = new ReportStyle2();
            } else if (this.reportStyle == 3) {
                style = new ReportStyle4();
            }
            if (style != null) {
                ((ReportStyle)style).reApplyStyle(this.getReportTables().elementAt(0), this.reportStyle);
            }
        }
        this.subReportObject = _report.subReportObject;
        this.HTMLTarget = _report.HTMLTarget;
        this.isDHTMLViewerUsed = _report.isDHTMLViewerUsed;
        this.isApplyTemplateForDHTMLViewer = _report.isApplyTemplateForDHTMLViewer;
    }

    public void copyReport(Report _report) {
        this.copyReport(_report, true);
    }

    public void copyReport(Report _report, boolean applyFormula) {
        this.applyReport(_report, true, applyFormula);
    }

    private void applyReport(Report _report, boolean copyRpt, boolean applyFormula) {
        this.applyReport(_report, copyRpt, applyFormula, false);
    }

    public void applyReport(Report _report, boolean copyRpt, boolean applyFormula, boolean keepElt) {
        this.applyReport(_report, copyRpt, applyFormula, keepElt, false);
    }

    public void moveFixedFieldCrossTabFormula(int newRPTPos) {
        int NOF = -1;
        int TOP = 1;
        int BOTTOM = 0;
        int oldRPTPos = NOF;
        if (this.showColumnAggregation) {
            int n = oldRPTPos = this.columnAggregationInHeader ? TOP : BOTTOM;
        }
        if (newRPTPos != oldRPTPos) {
            if (oldRPTPos == NOF) {
                LOGGER.warning("NOT IMPLEMENTED");
            }
            Vector<ReportTable> oldTables = this.getReportTables();
            int len = oldTables.size();
            if (oldRPTPos == BOTTOM) {
                for (int i = 0; i < len; ++i) {
                    if (!(oldTables.elementAt(i) instanceof ReportMultiSectionTable)) continue;
                    ReportMultiSectionTable mTable = (ReportMultiSectionTable)oldTables.elementAt(i);
                    if (newRPTPos == TOP) {
                        this.updateFormula(mTable.getFooter(), mTable.getHeader(), false);
                        continue;
                    }
                    this.updateFormula(mTable.getFooter(), mTable.getHeader(), true);
                }
            } else if (oldRPTPos == TOP) {
                for (int i = 0; i < len; ++i) {
                    if (!(oldTables.elementAt(i) instanceof ReportMultiSectionTable)) continue;
                    ReportMultiSectionTable mTable = (ReportMultiSectionTable)oldTables.elementAt(i);
                    if (newRPTPos == BOTTOM) {
                        this.updateFormula(mTable.getHeader(), mTable.getFooter(), false);
                        continue;
                    }
                    this.updateFormula(mTable.getHeader(), mTable.getFooter(), true);
                }
            }
        }
        this.showColumnAggregation = newRPTPos != -1;
        this.columnAggregationInHeader = newRPTPos == 1;
    }

    private void updateFormula(ReportSection src, ReportSection des, boolean removeOnly) {
        Vector cellRows = src.getTextCellForHTML();
        block0: for (int i = 0; i < cellRows.size(); ++i) {
            ReportCell[] cells;
            for (ReportCell cell : cells = (ReportCell[])cellRows.elementAt(i)) {
                if (!(cell instanceof CBColumnFooter)) continue;
                this.updateFormulaRow(src, des, cells, removeOnly);
                continue block0;
            }
        }
    }

    private void updateFormulaRow(ReportSection src, ReportSection des, ReportCell[] cells, boolean removeOnly) {
        double y = des.getMinHeight();
        double h = 0.0;
        for (ReportCell cell : cells) {
            src.removeData(cell);
            if (cell.getHeight() > h) {
                h = cell.getHeight();
            }
            if (removeOnly) continue;
            cell.setY(y);
            des.addData(cell);
        }
        if (!removeOnly) {
            des.setHeight(des.getHeight() + h);
        }
        if (src.getHeight() - h > 0.0) {
            src.setHeight(src.getHeight() - h);
        }
    }

    public void applyFixedFieldStyle(Report _report, boolean copyRpt, boolean applyFormula, boolean keepElt) {
        this.applyReport(_report, copyRpt, applyFormula, keepElt, true);
    }

    private void applyReport(Report _report, boolean copyRpt, boolean applyFormula, boolean keepElt, boolean applyFixedFieldStyleOnly) {
        this.copyFitGroupColInfo(this.colInfo, _report.colInfo);
        this.name = _report.name;
        this.pageHeader.copy(_report.getPageHeader(), 0, -1, null, null, !copyRpt, false, true, applyFormula);
        this.reportHeader.copy(_report.getReportHeader(), 0, -1, null, null, !copyRpt, false, true, applyFormula);
        this.reportFooter.copy(_report.getReportFooter(), 0, -1, null, null, !copyRpt, false, true, applyFormula);
        this.pageFooter.copy(_report.getPageFooter(), 0, -1, null, null, !copyRpt, false, true, applyFormula);
        this.pageWidth = _report.pageWidth;
        this.pageHeight = _report.pageHeight;
        this.leftMargin = _report.leftMargin;
        this.rightMargin = _report.rightMargin;
        this.topMargin = _report.topMargin;
        this.bottomMargin = _report.bottomMargin;
        this.orientation = _report.orientation;
        this.sourceData = _report.sourceData;
        this.originalSourceData = _report.originalSourceData;
        this.dbInfo = _report.dbInfo;
        this.parameters = _report.parameters;
        this.queryParameters = _report.getQueryParameters();
        this.formulaParameters = _report.formulaParameters;
        this.subQueryParamTable = _report.subQueryParamTable;
        this.subFormulaParamTable = _report.subFormulaParamTable;
        this.queryFilename = _report.queryFilename;
        this.queryFileInfo = _report.queryFileInfo;
        this.sourceFile = _report.sourceFile;
        this.xmlFileQueryInfo = _report.xmlFileQueryInfo;
        this.jndiName = _report.jndiName;
        this.homeName = _report.homeName;
        this.remoteName = _report.remoteName;
        this.selectedMethodName = _report.selectedMethodName;
        this.selectedMethodParamVal = _report.selectedMethodParamVal;
        this.environment = _report.environment;
        this.soapInfo = _report.soapInfo;
        this.sfQueryInfo = _report.sfQueryInfo;
        this.excelInfo = _report.excelInfo;
        this.olapRS = _report.olapRS;
        this.mondrianConnectionString = _report.mondrianConnectionString;
        this.MDXQuery = _report.MDXQuery;
        this.xmlaURI = _report.xmlaURI;
        this.xmlaDataSource = _report.xmlaDataSource;
        this.xmlaCatalog = _report.xmlaCatalog;
        this.rowBreakAggrIncluded = _report.rowBreakAggrIncluded;
        this.colBreakAggrIncluded = _report.colBreakAggrIncluded;
        this.keepDataSourceOrder = _report.keepDataSourceOrder;
        this.sourceList = _report.sourceList;
        this.sourceType = _report.sourceType;
        this.doTranspose = _report.doTranspose;
        this.transposeColList = _report.transposeColList;
        this.originalColDataFromMemSource = _report.originalColDataFromMemSource;
        this.isTransposed = _report.isTransposed;
        this.transposeCol = _report.transposeCol;
        this.timeZone = _report.timeZone;
        this.locale = _report.locale;
        this.formula = _report.formula;
        this.column = _report.column;
        this.labelSetting = _report.labelSetting;
        this.imageSetting = _report.imageSetting;
        this.chartSetting = _report.chartSetting;
        this.columnHeaderSetting = _report.columnHeaderSetting;
        this.titleSetting = _report.titleSetting;
        this.stringFormulaSetting = _report.stringFormulaSetting;
        this.logicFormulaSetting = _report.logicFormulaSetting;
        this.numericFormulaSetting = _report.numericFormulaSetting;
        this.timeFormulaSetting = _report.timeFormulaSetting;
        this.stringColumnSetting = _report.stringColumnSetting;
        this.logicColumnSetting = _report.logicColumnSetting;
        this.numericColumnSetting = _report.numericColumnSetting;
        this.timeColumnSetting = _report.timeColumnSetting;
        this.barcodeColumnSetting = _report.barcodeColumnSetting;
        this.fontMapping = _report.fontMapping;
        this.richTextFonts = _report.richTextFonts;
        if (applyFormula) {
            this.addScripts(_report.scripts);
        }
        Vector<ReportTable> newTables = this.getReportTables();
        Vector<ReportTable> oldTables = _report.getReportTables();
        int len = newTables.size() <= oldTables.size() ? newTables.size() : oldTables.size();
        for (int i = 0; i < len; ++i) {
            ReportSection master;
            ReportTable mTable;
            if (!applyFixedFieldStyleOnly) {
                newTables.elementAt(i).applyGlobalFormatToColumns(this.column);
            }
            if (newTables.elementAt(i) instanceof ReportMultiSectionTable) {
                mTable = (ReportMultiSectionTable)newTables.elementAt(i);
                master = mTable.getMasterSection();
                ReportTable old = oldTables.elementAt(i);
                if (!applyFixedFieldStyleOnly) {
                    ((ReportMultiSectionTable)mTable).loadTable(old, applyFormula, copyRpt, keepElt, this.getReportType());
                    mTable.adjustColumnXPos(old, -1, this);
                } else {
                    ((ReportMultiSectionTable)mTable).loadFixedFieldTableStyle(old, applyFormula, copyRpt, keepElt, this.getReportType());
                }
                if (mTable instanceof CrossTabTable) {
                    CrossTabTable crossTabTable = (CrossTabTable)mTable;
                    if (applyFixedFieldStyleOnly) {
                        crossTabTable.getCrossTabHeader().applyStyleForFixedFieldSection(old.getHeader(), !this.scripts.isEmpty());
                        crossTabTable.getCrossTabFooter().applyStyleForFixedFieldSection(old.getFooter(), !this.scripts.isEmpty());
                    } else {
                        crossTabTable.getCrossTabHeader().copy(old.getHeader(), 0, -1, old.getColumns(), null, !copyRpt, false, true, applyFormula, keepElt, ((CrossTabTable)mTable).getFieldsCount(), this.isRowAggregationSubtotalOnLeft(), this.isShowRowAggregationSubtotal(), null, mTable.getColumns());
                        crossTabTable.getCrossTabFooter().copy(old.getFooter(), 0, -1, old.getColumns(), null, !copyRpt, false, true, applyFormula, keepElt, ((CrossTabTable)mTable).getFieldsCount(), this.isRowAggregationSubtotalOnLeft(), this.isShowRowAggregationSubtotal(), null, mTable.getColumns());
                    }
                } else {
                    mTable.getHeader().copy(old.getHeader(), 0, -1, null, null, !copyRpt, false, true, applyFormula, keepElt);
                    mTable.getFooter().copy(old.getFooter(), 0, -1, null, null, !copyRpt, false, true, applyFormula, keepElt);
                }
                mTable.setMasterSection(master);
                continue;
            }
            mTable = newTables.elementAt(i);
            master = mTable.getMasterSection();
            mTable.loadTable(oldTables.elementAt(i), applyFormula, copyRpt);
            mTable.setMasterSection(master);
        }
        this.nullDataOption = _report.nullDataOption;
        this.isApplyBoundSelected = _report.isApplyBoundSelected();
        this.isHeadTagIncluded = _report.isHeadTagIncluded();
        this.isBackgroundTagIncluded = _report.isBackgroundTagIncluded();
        this.stringCustomizer = _report.getStringCustomizer();
        this.currentNode = _report.currentNode;
        this.parentNode = _report.parentNode;
        this.rootNode = _report.rootNode;
        this.subReports = _report.subReports;
        this.subReportArray = _report.subReportArray;
        this.subFilesTable = _report.subFilesTable;
        this.useBackupData = _report.useBackupData;
        this.setColumnWrap(_report.getColumnWrap());
        this.forExportOnly = _report.forExportOnly;
        this.exportToMultiPages = _report.exportToMultiPages;
        this.exportToSingleWPagination = _report.exportToSingleWPagination;
        this.usingIE55DHTMLRendering = _report.usingIE55DHTMLRendering;
        this.isExpandAndCollapseEnabled = _report.isExpandAndCollapseEnabled;
        this.isDefaultToExpandAll = _report.isDefaultToExpandAll;
        this.centerDHTMLReport = _report.centerDHTMLReport;
        this.useStyleSheet = _report.useStyleSheet;
        this.externalCSS = _report.externalCSS;
        this.exportEncoding = _report.exportEncoding;
        this.htmlCharset = _report.htmlCharset;
        this.rtfEncoding = _report.rtfEncoding;
        this.useAllColorsForRTF = _report.useAllColorsForRTF;
        this.htmlTitle = _report.htmlTitle;
        this.addFormulas(_report.formulas);
        this.dbSourceType = _report.dbSourceType;
        this.queryFileBytes = _report.queryFileBytes;
        this.backgroundColor = _report.backgroundColor;
        this.backgroundImage = _report.backgroundImage;
        if (!applyFixedFieldStyleOnly) {
            boolean columnCountMismatch = false;
            try {
                if (this.reportType == 2) {
                    columnCountMismatch = this.getReportTables().elementAt(0).getColumnCount() != _report.getReportTables().elementAt(0).getColumnCount();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to set columnCountMismatch", ex);
            }
            if (this.colInfo.length != _report.colInfo.length || columnCountMismatch) {
                this.adjustHeaderFormulas();
                this.adjustFooterFormulas();
            }
        }
        this.topN = _report.topN;
        this.ascending = _report.ascending;
        this.hasTitle = _report.hasTitle;
        this.hasLogo = _report.hasLogo;
        this.hasPageNumber = _report.hasPageNumber;
        this.hasDate = _report.hasDate;
        this.reportTitle = _report.reportTitle;
        this.logofile = _report.logofile;
        this.logoPos = _report.logoPos;
        this.pageNumberFormat = _report.pageNumberFormat;
        this.pageNumberPos = _report.pageNumberPos;
        this.dateFormat = _report.dateFormat;
        this.datePos = _report.datePos;
        this.reportStyle = _report.reportStyle;
        this.customStyleFile = _report.customStyleFile;
        this.vGuideLines = _report.vGuideLines;
        this.hGuideLines = _report.hGuideLines;
        this.showFormulaNameSelected = _report.showFormulaNameSelected;
        this.showCellOutline = _report.showCellOutline;
        this.previewSecurityLevel = _report.previewSecurityLevel;
        this.securityQueryParameterMap = _report.securityQueryParameterMap;
        this.snapToGrid = _report.snapToGrid;
        this.gridStepSize = _report.gridStepSize;
        this.cmGridStepSize = _report.cmGridStepSize;
        this.isAdjustFont = _report.isAdjustFont;
        this.registryID = _report.registryID;
        this.dataSourceID = _report.dataSourceID;
        this.dataSourceLoc = _report.dataSourceLoc;
        this.limitSubReportQueryExecution = _report.limitSubReportQueryExecution;
        this.order_offset = _report.order_offset;
        this.isPrevParamPrompt = _report.isPrevParamPrompt;
    }

    public void deepCopy(Report _report) {
        this.deepCopy(_report, false);
    }

    public void deepCopy(Report _report, boolean reUseTable) {
        this.isCopy = true;
        if (!reUseTable) {
            this.copyFitGroupColInfo(this.colInfo, _report.colInfo);
            this.pageHeader.deepCopy(_report.getPageHeader());
            this.reportHeader.deepCopy(_report.getReportHeader());
            Vector<ReportTable> tables = this.getReportTables();
            int len = tables.size() <= _report.getReportTables().size() ? tables.size() : _report.getReportTables().size();
            for (int i = 0; i < len; ++i) {
                if (tables.elementAt(i) instanceof ReportMultiSectionTable) {
                    ((ReportMultiSectionTable)tables.elementAt(i)).deepCopy(_report.getReportTables().elementAt(i));
                } else {
                    tables.elementAt(i).deepCopy(_report.getReportTables().elementAt(i));
                }
                tables.elementAt(i).getHeader().deepCopy(_report.getReportTables().elementAt(i).getHeader());
                tables.elementAt(i).getFooter().deepCopy(_report.getReportTables().elementAt(i).getFooter());
            }
            this.reportFooter.deepCopy(_report.getReportFooter());
            this.pageFooter.deepCopy(_report.getPageFooter());
        }
        this.name = _report.name;
        this.filename = _report.filename;
        this.setGridLineLink();
        this.pageWidth = _report.pageWidth;
        this.pageHeight = _report.pageHeight;
        this.leftMargin = _report.leftMargin;
        this.rightMargin = _report.rightMargin;
        this.topMargin = _report.topMargin;
        this.bottomMargin = _report.bottomMargin;
        this.orientation = _report.orientation;
        this.sourceData = _report.sourceData;
        this.originalSourceData = _report.originalSourceData;
        this.dbInfo = _report.dbInfo;
        this.parameters = _report.parameters;
        this.queryParameters = _report.getQueryParameters();
        this.formulaParameters = _report.formulaParameters;
        this.subQueryParamTable = _report.subQueryParamTable;
        this.subFormulaParamTable = _report.subFormulaParamTable;
        this.queryFilename = _report.queryFilename;
        this.queryFileInfo = _report.queryFileInfo;
        this.sourceFile = _report.sourceFile;
        this.xmlFileQueryInfo = _report.xmlFileQueryInfo;
        this.jndiName = _report.jndiName;
        this.homeName = _report.homeName;
        this.remoteName = _report.remoteName;
        this.selectedMethodName = _report.selectedMethodName;
        this.selectedMethodParamVal = _report.selectedMethodParamVal;
        this.environment = _report.environment;
        this.soapInfo = _report.soapInfo;
        this.sfQueryInfo = _report.sfQueryInfo;
        this.excelInfo = _report.excelInfo;
        this.olapRS = _report.olapRS;
        this.mondrianConnectionString = _report.mondrianConnectionString;
        this.MDXQuery = _report.MDXQuery;
        this.xmlaURI = _report.xmlaURI;
        this.xmlaDataSource = _report.xmlaDataSource;
        this.xmlaCatalog = _report.xmlaCatalog;
        this.rowBreakAggrIncluded = _report.rowBreakAggrIncluded;
        this.colBreakAggrIncluded = _report.colBreakAggrIncluded;
        this.keepDataSourceOrder = _report.keepDataSourceOrder;
        this.sourceList = _report.sourceList;
        this.sourceType = _report.sourceType;
        this.doTranspose = _report.doTranspose;
        this.transposeColList = _report.transposeColList;
        this.originalColDataFromMemSource = _report.originalColDataFromMemSource;
        this.timeZone = _report.timeZone;
        this.locale = _report.locale;
        this.labelSetting.deepCopy(_report.labelSetting);
        this.chartSetting.deepCopy(_report.chartSetting);
        this.imageSetting.deepCopy(_report.imageSetting);
        this.columnHeaderSetting.deepCopy(_report.columnHeaderSetting);
        this.titleSetting.deepCopy(_report.titleSetting);
        this.stringFormulaSetting.deepCopy(_report.stringFormulaSetting);
        this.logicFormulaSetting.deepCopy(_report.logicFormulaSetting);
        this.numericFormulaSetting.deepCopy(_report.numericFormulaSetting);
        this.timeFormulaSetting.deepCopy(_report.timeFormulaSetting);
        this.stringColumnSetting.deepCopy(_report.stringColumnSetting);
        this.logicColumnSetting.deepCopy(_report.logicColumnSetting);
        this.numericColumnSetting.deepCopy(_report.numericColumnSetting);
        this.timeColumnSetting.deepCopy(_report.timeColumnSetting);
        this.barcodeColumnSetting.deepCopy(_report.barcodeColumnSetting);
        this.fontMapping = _report.fontMapping;
        this.richTextFonts = _report.richTextFonts;
        this.nullDataOption = _report.nullDataOption;
        this.isApplyBoundSelected = _report.isApplyBoundSelected();
        this.isHeadTagIncluded = _report.isHeadTagIncluded();
        this.isBackgroundTagIncluded = _report.isBackgroundTagIncluded();
        this.stringCustomizer = _report.getStringCustomizer();
        this.currentNode = _report.currentNode;
        this.parentNode = _report.parentNode;
        this.rootNode = _report.rootNode;
        this.subReports = _report.subReports;
        this.subReportArray = _report.subReportArray;
        this.subFilesTable = _report.subFilesTable;
        this.useBackupData = _report.useBackupData;
        this.sideBySideLayout = _report.sideBySideLayout;
        this.reOrderColumns = _report.reOrderColumns;
        this.showRowAggregationGrandTotal = _report.showRowAggregationGrandTotal;
        this.showColumnAggregation = _report.showColumnAggregation;
        this.crossTabFreeForm = _report.crossTabFreeForm;
        this.columnAggregationInHeader = _report.columnAggregationInHeader;
        this.alignCrossTabColBkValHori = _report.alignCrossTabColBkValHori;
        this.showRowAggregationSubtotal = _report.showRowAggregationSubtotal;
        this.rowAggregationSubtotalOnLeft = _report.rowAggregationSubtotalOnLeft;
        if (_report.getColumnWrap() != null) {
            String wrapID = _report.getColumnWrap().getID();
            this.setColumnWrap((ColumnWrap)this.getData(wrapID));
        } else {
            this.setColumnWrap(_report.getColumnWrap());
        }
        this.forExportOnly = _report.forExportOnly;
        this.exportToMultiPages = _report.exportToMultiPages;
        this.exportToSingleWPagination = _report.exportToSingleWPagination;
        this.isExpandAndCollapseEnabled = _report.isExpandAndCollapseEnabled;
        this.isDefaultToExpandAll = _report.isDefaultToExpandAll;
        this.usingIE55DHTMLRendering = _report.usingIE55DHTMLRendering;
        this.centerDHTMLReport = _report.centerDHTMLReport;
        this.useStyleSheet = _report.useStyleSheet;
        this.externalCSS = _report.externalCSS;
        this.exportEncoding = _report.exportEncoding;
        this.htmlCharset = _report.htmlCharset;
        this.rtfEncoding = _report.rtfEncoding;
        this.useAllColorsForRTF = _report.useAllColorsForRTF;
        this.htmlTitle = _report.htmlTitle;
        this.formulas = _report.formulas;
        this.scripts = _report.scripts;
        this.dbSourceType = _report.dbSourceType;
        this.queryFileBytes = _report.queryFileBytes;
        this.backgroundColor = _report.backgroundColor;
        this.backgroundImage = _report.backgroundImage;
        this.topN = _report.topN;
        this.ascending = _report.ascending;
        this.hasTitle = _report.hasTitle;
        this.hasLogo = _report.hasLogo;
        this.hasPageNumber = _report.hasPageNumber;
        this.hasDate = _report.hasDate;
        this.reportTitle = _report.reportTitle;
        this.logofile = _report.logofile;
        this.logoPos = _report.logoPos;
        this.pageNumberFormat = _report.pageNumberFormat;
        this.pageNumberPos = _report.pageNumberPos;
        this.dateFormat = _report.dateFormat;
        this.datePos = _report.datePos;
        this.reportStyle = _report.reportStyle;
        this.customStyleFile = _report.customStyleFile;
        this.showFormulaNameSelected = _report.showFormulaNameSelected;
        this.showCellOutline = _report.showCellOutline;
        this.copyGuideLines(_report);
        this.previewSecurityLevel = _report.previewSecurityLevel;
        this.securityQueryParameterMap = _report.securityQueryParameterMap;
        this.snapToGrid = _report.snapToGrid;
        this.gridStepSize = _report.gridStepSize;
        this.cmGridStepSize = _report.cmGridStepSize;
        this.isAdjustFont = _report.isAdjustFont;
        this.registryID = _report.registryID;
        this.dataSourceID = _report.dataSourceID;
        this.dataSourceLoc = _report.dataSourceLoc;
        this.isDynamicExport = _report.isDynamicExport;
        this.serverName = _report.serverName;
        this.servletRunnerPort = _report.servletRunnerPort;
        this.isHttpsDynamicExport = _report.isHttpsDynamicExport;
        this.httpsServerName = _report.httpsServerName;
        this.httpsServletRunnerPort = _report.httpsServletRunnerPort;
        this.drawBeforeDisplay = _report.drawBeforeDisplay;
        this.limitSubReportQueryExecution = _report.limitSubReportQueryExecution;
        this.isPrevParamPrompt = _report.isPrevParamPrompt;
        this.drillDownConn = _report.drillDownConn;
        this.databaseInfo = _report.databaseInfo;
        this.servletDirectory = _report.servletDirectory;
        this.order_offset = _report.order_offset;
        this.subReportObject = _report.subReportObject;
        this.HTMLTarget = _report.HTMLTarget;
        this.isDHTMLViewerUsed = _report.isDHTMLViewerUsed;
    }

    public boolean isTransposed() {
        return this.isTransposed;
    }

    public void setTransposed(boolean value, boolean[] transposeCol) {
        this.isTransposed = value;
        this.transposeCol = transposeCol;
    }

    public boolean[] getTransposeColumn() {
        return this.transposeCol;
    }

    public int getOriginalSourceData() {
        return this.originalSourceData;
    }

    public void setOriginalSourceData(int i) {
        this.originalSourceData = i;
    }

    public Report setNewData(ColData[] colData) throws Exception {
        return this.setNewData(colData, this.colInfo, this.reportType);
    }

    public Report setNewData(ColData[] colData, ColInfo[] colInfo, int reportType) throws Exception {
        return this.setNewData(colData, colInfo, true, reportType, true);
    }

    public Report setNewData(ColData[] colData, ColInfo[] colInfo, boolean adjustColHeader, int reportType, boolean adjustCrossTabForColumnCount) throws Exception {
        return this.setNewData(colData, colInfo, adjustColHeader, reportType, adjustCrossTabForColumnCount, true);
    }

    public Report setNewData(ColData[] colData, ColInfo[] colInfo, boolean adjustColHeader, int reportType, boolean adjustCrossTabForColumnCount, boolean copyVisible) throws Exception {
        return this.setNewData(colData, colInfo, adjustColHeader, reportType, adjustCrossTabForColumnCount, copyVisible, false);
    }

    public Report setNewData(ColData[] colData, ColInfo[] colInfo, boolean adjustColHeader, int reportType, boolean adjustCrossTabForColumnCount, boolean copyVisible, boolean fromDesignerDesignMode) throws Exception {
        Report report = new Report(colData);
        report.reOrderColumns = this.reOrderColumns;
        report.showRowAggregationGrandTotal = this.showRowAggregationGrandTotal;
        report.showColumnAggregation = this.showColumnAggregation;
        report.crossTabFreeForm = this.crossTabFreeForm;
        report.columnAggregationInHeader = this.columnAggregationInHeader;
        report.alignCrossTabColBkValHori = this.alignCrossTabColBkValHori;
        report.showRowAggregationSubtotal = this.showRowAggregationSubtotal;
        report.rowAggregationSubtotalOnLeft = this.rowAggregationSubtotalOnLeft;
        report.createTable(reportType, colInfo, false, fromDesignerDesignMode);
        report.copy(this, adjustColHeader, adjustCrossTabForColumnCount, copyVisible);
        report.deleteSubReportColData();
        report.deleteSubReportColDataFiles();
        report.setReformatTable();
        report.easyReportStyle = this.easyReportStyle;
        return report;
    }

    public Report setNewData(ColData[] colData, boolean sortedData) throws Exception {
        return this.setNewData(colData, this.colInfo, this.reportType, sortedData);
    }

    public Report setNewData(ColData[] colData, ColInfo[] colInfo, int reportType, boolean sortedData) throws Exception {
        return this.setNewData(colData, colInfo, reportType, sortedData, false);
    }

    public Report setNewData(ColData[] colData, ColInfo[] colInfo, int reportType, boolean sortedData, boolean fromDesignerDesignMode) throws Exception {
        Report report = new Report(colData);
        report.colDataSorted = sortedData;
        report.reOrderColumns = this.reOrderColumns;
        report.showRowAggregationGrandTotal = this.showRowAggregationGrandTotal;
        report.showColumnAggregation = this.showColumnAggregation;
        report.crossTabFreeForm = this.crossTabFreeForm;
        report.columnAggregationInHeader = this.columnAggregationInHeader;
        report.rowBreakAggrIncluded = this.rowBreakAggrIncluded;
        report.colBreakAggrIncluded = this.colBreakAggrIncluded;
        report.keepDataSourceOrder = this.keepDataSourceOrder;
        report.alignCrossTabColBkValHori = this.alignCrossTabColBkValHori;
        report.showRowAggregationSubtotal = this.showRowAggregationSubtotal;
        report.rowAggregationSubtotalOnLeft = this.rowAggregationSubtotalOnLeft;
        report.createTable(reportType, colInfo, false, fromDesignerDesignMode);
        report.copy(this);
        report.deleteSubReportColData();
        report.deleteSubReportColDataFiles();
        report.setReformatTable();
        report.easyReportStyle = this.easyReportStyle;
        return report;
    }

    public final int[] getRecordDataType() {
        int[] dtype = new int[this.colData.length - 1];
        for (int i = 0; i < dtype.length; ++i) {
            dtype[i] = this.colData[i].getOriginalDataType();
        }
        return dtype;
    }

    public Object[] getRecord(int no) {
        int nRow = this.colData[0].getSize();
        if (no >= nRow) {
            return null;
        }
        Object[] record = new Object[this.colData.length - 1];
        for (int i = 0; i < record.length; ++i) {
            record[i] = this.colData[i].getData(no);
        }
        return record;
    }

    public void addRecord(Object[] record) {
        int nRow = this.colData[0].getSize();
        int nCol = this.colData.length - 1;
        for (int i = 0; i < record.length; ++i) {
            this.colData[i].add(record[i]);
            this.colData[i].bGenUniqueName = false;
            this.colData[i].clearHashTable();
        }
        int idx = nRow != 0 ? (Integer)this.colData[nCol].getData(nRow - 1) : -1;
        this.colData[nCol].add(idx + 1);
        this.remakeTable = true;
        this.reBuildTable();
    }

    public boolean removeRecord(int no) {
        int nRow = this.colData[0].getSize();
        int nCol = this.colData.length - 1;
        if (no >= nRow || nRow == 0) {
            return false;
        }
        for (int i = 0; i <= nCol; ++i) {
            this.colData[i].removeData(no);
            this.colData[i].bGenUniqueName = false;
            this.colData[i].clearHashTable();
        }
        this.remakeTable = true;
        return true;
    }

    public void setRecord(Object[] record, int no) throws IllegalArgumentException {
        if (no >= this.colData[0].getSize()) {
            throw new IllegalArgumentException("Record no must be less than " + this.colData[0].getSize());
        }
        try {
            for (int i = 0; i < record.length; ++i) {
                this.colData[i].setData(no, record[i]);
                this.colData[i].bGenUniqueName = false;
                this.colData[i].clearHashTable();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to process colData", ex);
        }
        this.remakeTable = true;
    }

    public int getDataColumnNo() {
        return this.colData.length - 1;
    }

    public int getDataRowSize() {
        return this.colData[0].getSize();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public int getReportType() {
        return this.reportType;
    }

    public ReportSection getPageHeader() {
        return this.pageHeader;
    }

    public void setPageHeader(ReportSection sec) {
        this.pageHeader = sec;
    }

    public ReportSection getReportHeader() {
        return this.reportHeader;
    }

    public void setReportHeader(ReportSection sec) {
        this.reportHeader = sec;
    }

    public Vector<ReportTable> getReportTables() {
        return this.reportTables;
    }

    public void setReportTables(Vector<ReportTable> vec) {
        this.reportTables = vec;
    }

    public ReportSection getReportFooter() {
        return this.reportFooter;
    }

    public void setReportFooter(ReportSection sec) {
        this.reportFooter = sec;
    }

    public ReportSection getPageFooter() {
        return this.pageFooter;
    }

    public void setPageFooter(ReportSection sec) {
        this.pageFooter = sec;
    }

    public double getActualPageWidth() {
        return this.pageWidth - this.leftMargin - this.rightMargin;
    }

    public double getActualPageHeight() {
        return this.pageHeight - this.topMargin - this.bottomMargin;
    }

    public double getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(double w) {
        double margins = this.getLeftMargin() + this.getRightMargin();
        this.pageWidth = w;
        double sectionW = w - margins < 0.0 ? 0.0 : w - margins;
        this.setAllSectionsWidth(sectionW);
    }

    public double getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(double h) {
        this.pageHeight = h;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(double m) {
        this.topMargin = m;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(double m) {
        this.bottomMargin = m;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(double m) {
        this.leftMargin = m;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(double m) {
        this.rightMargin = m;
    }

    public double getDHTMLTopMargin() {
        return this.dhtmlTopMargin;
    }

    public void setDHTMLTopMargin(double m) {
        this.dhtmlTopMargin = m;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orient) {
        this.setOrientation(orient, false);
    }

    public void setOrientation(int orient, boolean swapWH) {
        this.orientation = orient;
        if (swapWH) {
            double tmp = this.pageWidth;
            this.pageWidth = this.pageHeight;
            this.pageHeight = tmp;
        }
    }

    public ColumnWrap getColumnWrap() {
        return this.columnWrap;
    }

    public void setColumnWrap(ColumnWrap wrap) {
        if (this.getReportType() == 0 || this.getReportType() == 4 || this.getReportType() == 1) {
            if (wrap == null) {
                this.resetColumnWrap();
            } else {
                this.columnWrap = wrap;
            }
        } else if (this.columnWrap != null) {
            this.resetColumnWrap();
        } else {
            this.columnWrap = wrap;
            this.resetColumnWrap();
        }
    }

    public void resetColumnWrap() {
        if (this.columnWrap == null) {
            return;
        }
        for (ColumnWrap col = (ColumnWrap)this.columnWrap.getHeadNode(); col != null; col = (ColumnWrap)col.next()) {
            for (int i = 0; i < this.reportTables.size(); ++i) {
                ReportTable tbl = this.reportTables.elementAt(i);
                tbl.removeColumnWrap(col);
            }
        }
        this.columnWrap = null;
    }

    public void addColumnWrap(double x, int repeat) {
        ColumnWrap wraph = new ColumnWrap(x);
        ColumnWrap wrap = new ColumnWrap(x);
        ColumnWrap wrapf = new ColumnWrap(x);
        wraph.setWrapCount(repeat);
        wrap.setWrapCount(repeat);
        wrapf.setWrapCount(repeat);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.getHeader().addData(wraph);
            tbl.addImage(wrap);
            tbl.getFooter().addData(wrapf);
        }
        this.columnWrap = wraph;
    }

    public boolean isHeadTagIncluded() {
        return this.isHeadTagIncluded;
    }

    public void setHeadTagIncluded(boolean b) {
        this.isHeadTagIncluded = b;
        this.isBackgroundTagIncluded = b;
    }

    public boolean isBackgroundTagIncluded() {
        return this.isBackgroundTagIncluded;
    }

    public void setBackgroundTagIncluded(boolean b) {
        this.isBackgroundTagIncluded = b;
    }

    public int getTMargin() {
        return QbUtil.toPixel(this.getTopMargin());
    }

    public int getBMargin() {
        return QbUtil.toPixel(this.getBottomMargin());
    }

    public int getLMargin() {
        return QbUtil.toPixel(this.getLeftMargin());
    }

    public int getRMargin() {
        return QbUtil.toPixel(this.getRightMargin());
    }

    public int getPWidth() {
        return QbUtil.toPixel(this.getPageWidth());
    }

    public int getPHeight() {
        return QbUtil.toPixel(this.getPageHeight());
    }

    public int getDHTMLTMargin() {
        return QbUtil.toPixel(this.getDHTMLTopMargin());
    }

    public boolean isDHTMLTopMarginRepeatOnEveryPage() {
        return this.dhtmlTopMarginRepeatOnEveryPage;
    }

    public void setDHTMLTopMarginRepeatOnEveryPage(boolean state) {
        this.dhtmlTopMarginRepeatOnEveryPage = state;
    }

    public float getTopMarginToPoints() {
        return QbUtil.toPoints(this.topMargin);
    }

    public float getBottomMarginToPoints() {
        return QbUtil.toPoints(this.bottomMargin);
    }

    public float getLeftMarginToPoints() {
        return QbUtil.toPoints(this.leftMargin);
    }

    public float getRightMarginToPoints() {
        return QbUtil.toPoints(this.rightMargin);
    }

    public float getActualPageWidthToPoints() {
        return QbUtil.toPoints(this.pageWidth - this.leftMargin - this.rightMargin);
    }

    public float getActualPageHeightToPoints() {
        return QbUtil.toPoints(this.pageHeight - this.topMargin - this.bottomMargin);
    }

    public float getPageWidthToPoints() {
        return QbUtil.toPoints(this.pageWidth);
    }

    public float getPageHeightToPoints() {
        return QbUtil.toPoints(this.pageHeight);
    }

    protected double getMaxWidthOfSections() {
        Vector<ReportTable> vec = this.getReportTables();
        ReportTable table = null;
        double maxWidthOfSections = this.getPageHeader().getWidth();
        double w = this.getReportHeader().getWidth();
        if (w > maxWidthOfSections) {
            maxWidthOfSections = w;
        }
        for (int i = 0; i < vec.size(); ++i) {
            table = vec.elementAt(i);
            w = table.getWidth();
            if (!(w > maxWidthOfSections)) continue;
            maxWidthOfSections = w;
        }
        w = this.getReportFooter().getWidth();
        if (w > maxWidthOfSections) {
            maxWidthOfSections = w;
        }
        if ((w = this.getPageFooter().getWidth()) > maxWidthOfSections) {
            maxWidthOfSections = w;
        }
        if ((w = this.getPageWidth() - this.getLeftMargin() - this.getRightMargin()) > maxWidthOfSections) {
            maxWidthOfSections = w;
        }
        return maxWidthOfSections;
    }

    private void setAllSectionsWidth(double w) {
        this.getReportHeader().setWidth(w);
        this.getPageHeader().setWidth(w);
        this.setTableSectionsWidth(w);
        this.getPageFooter().setWidth(w);
        this.getReportFooter().setWidth(w);
    }

    private void setTableSectionsWidth(double w) {
        Vector<ReportTable> tables = this.getReportTables();
        if (tables == null) {
            return;
        }
        for (int i = 0; i < tables.size(); ++i) {
            ReportTable table = tables.elementAt(i);
            table.setWidth(w);
            table.getHeader().setWidth(w);
        }
    }

    @Override
    public Report getReportInfo() {
        return this;
    }

    @Override
    public Report getReportInfo(boolean forViewer) {
        return this;
    }

    public boolean isPreCalculationRequired() {
        if (this.isTocEnabled()) {
            return true;
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            if (table instanceof ReportTreeTable) {
                ReportTable stable = ((ReportTreeTable)table).getFirstTable();
                if (stable == null) {
                    try {
                        this.formatTable();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failed to format table: pre-calculation required", ex);
                        return true;
                    }
                    table = ((ReportTreeTable)table).getFirstTable();
                } else {
                    table = stable;
                }
                if (this.checkResetPageNumber((ReportTreeTable)this.reportTables.elementAt(i))) {
                    return true;
                }
            }
            if (table == null) continue;
            for (int j = 0; j < table.getColumnCount(); ++j) {
                if (table.getColumn(j).getDualColorColInfoIndex() == null || table.getColumn(j).getDualColorColInfoIndex().length <= 0) continue;
                return true;
            }
        }
        return this.isTotalPagesRequiredInScript();
    }

    private boolean checkResetPageNumber(ReportTreeTable sTable) {
        for (int i = 0; i < sTable.countSubTable(); ++i) {
            ReportTable table = sTable.getSubTable(i);
            if (table.getHeader().isResetPageNumber()) {
                return true;
            }
            if (!this.checkResetPageNumber(table)) continue;
            return true;
        }
        return false;
    }

    private boolean checkResetPageNumber(ReportTable table) {
        if (table instanceof ReportTreeTable) {
            return this.checkResetPageNumber((ReportTreeTable)table);
        }
        return table.getHeader().isResetPageNumber();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale l) {
        this.locale = l;
        for (ColData element : this.colData) {
            FormatUtil.setLocale(element.dataFormat, this.locale);
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.setLocale(this.locale);
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone zone) {
        this.timeZone = zone;
        for (ColData element : this.colData) {
            FormatUtil.setTimeZone(element.dataFormat, zone);
        }
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                FormatUtil.setTimeZone(table.getColumn(j).getDataFormat(), zone);
            }
        }
    }

    public boolean isDHTMLViewerUsed() {
        return this.isDHTMLViewerUsed;
    }

    public void setDHTMLViewerUsed(boolean b) {
        this.isDHTMLViewerUsed = b;
    }

    public boolean isApplyTemplateForDHTMLViewer() {
        return this.isApplyTemplateForDHTMLViewer;
    }

    public void setApplyTemplateForDHTMLViewer(boolean b) {
        this.isApplyTemplateForDHTMLViewer = b;
    }

    public void export(int format, String fileName, DrillDownNode node) throws Exception {
        this.export(format, fileName, node, null, null, 3900);
    }

    public void export(int format, String fileName, DrillDownNode node, String userPass, String ownerPass, int permissions) throws Exception {
        this.export(format, fileName, node, userPass, ownerPass, permissions, false, null);
    }

    public void export(int format, String fileName, DrillDownNode node, String userPass, String ownerPass, int permissions, boolean saveAllData, IExportThreadListener expListener) throws Exception {
        this.export(format, fileName, node, userPass, ownerPass, permissions, saveAllData, expListener, null);
    }

    public void export(int format, String fileName, DrillDownNode node, String userPass, String ownerPass, int permissions, boolean saveAllData, IExportThreadListener expListener, String javaScript) throws Exception {
        this.export(format, fileName, node, -1, userPass, ownerPass, permissions, saveAllData, expListener, javaScript);
    }

    public void export(int format, String fileName, DrillDownNode node, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData, IExportThreadListener expListener, String javaScript) throws Exception {
        this.export(format, fileName, node, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScript, false);
    }

    public synchronized void export(int format, String fileName, DrillDownNode node, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData, IExportThreadListener expListener, String javaScript, boolean limitExcelCellSplit) throws Exception {
        if (staticExport != null) {
            this.setExportToMultiPages(staticExport);
        }
        if (this.isValidForExportOnly()) {
            FileOutputStream fstream = new FileOutputStream(Report.getFullName(fileName, format));
            try {
                this.export(format, fstream, fileName, node, exportPage != -1, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScript);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot export", ex);
                fstream.close();
                throw ex;
            }
            fstream.close();
            if (this.isExportToMultiPages() && format == 4 && !this.isDHTMLViewerUsed) {
                new DeleteFile(Report.getFullName(fileName, format)).delete();
                new RenameFile(Report.getFullName(Report.getPrefixFileName(fileName) + "_FIRST", format), Report.getFullName(fileName, format)).rename();
            }
            return;
        }
        QbFileOutputStream filestream = new QbFileOutputStream(Report.getFullName(fileName, format));
        try {
            filestream.setBufferSize((int)((double)Runtime.getRuntime().freeMemory() * 0.1));
            this.export(format, filestream, fileName, node, exportPage != -1, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScript, limitExcelCellSplit, false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to export", ex);
            filestream.close();
            throw ex;
        }
        filestream.close();
        if (exportPage == -1 && this.isExportToMultiPages() && (format == 4 || format == 6) && !this.isDHTMLViewerUsed()) {
            new DeleteFile(Report.getFullName(fileName, format)).delete();
            new RenameFile(Report.getFullName(Report.getPrefixFileName(fileName) + "_FIRST", format), Report.getFullName(fileName, format)).rename();
        }
    }

    public void export(int format, OutputStream out, DrillDownNode node) throws Exception {
        if (this.isExportToMultiPages()) {
            throw new Exception("Please specify the file name for exporting to multi-pages.");
        }
        this.export(format, out, null, node);
    }

    public void export(int format, OutputStream out, String fileName, DrillDownNode node) throws Exception {
        this.export(format, out, fileName, node, false, -1);
    }

    public void export(int format, OutputStream out, String fileName, DrillDownNode node, boolean exportSpecificPage, int exportPage) throws Exception {
        this.export(format, out, fileName, node, exportSpecificPage, exportPage, null, null, 3900);
    }

    public void export(int format, OutputStream out, String fileName, DrillDownNode node, boolean exportSpecificPage, int exportPage, String userPass, String ownerPass, int permissions) throws Exception {
        this.export(format, out, fileName, node, exportSpecificPage, exportPage, userPass, ownerPass, permissions, false);
    }

    public void export(int format, OutputStream out, String fileName, DrillDownNode node, boolean exportSpecificPage, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData) throws Exception {
        this.export(format, out, fileName, node, exportSpecificPage, exportPage, userPass, ownerPass, permissions, saveAllData, null);
    }

    public void export(int format, OutputStream out, String fileName, DrillDownNode node, boolean exportSpecificPage, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData, IExportThreadListener expListener) throws Exception {
        this.export(format, out, fileName, node, exportSpecificPage, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, null);
    }

    public void export(int format, OutputStream out, String fileName, DrillDownNode node, boolean exportSpecificPage, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData, IExportThreadListener expListener, String javaScript) throws Exception {
        this.export(format, out, fileName, node, exportSpecificPage, exportPage, userPass, ownerPass, permissions, saveAllData, expListener, javaScript, false, false);
    }

    public synchronized void export(int format, OutputStream out, String fileName, DrillDownNode node, boolean exportSpecificPage, int exportPage, String userPass, String ownerPass, int permissions, boolean saveAllData, IExportThreadListener expListener, String javaScript, boolean limitExcelCellSplit, boolean skipFormatTable) throws Exception {
        this.clearTriggeredAlerts();
        if (this.isForExportOnly() && format != 4 && format != 2 && format != 13 && format != 5 && format != 3 && format != 7) {
            LOGGER.warning("Optimize memory export is only for PDF/DHTML/TXT/CSV/RTF/XML_PURE_DATA!");
            return;
        }
        SaveReport sr = null;
        if (exportSpecificPage) {
            this.exportToMultiPages = true;
        }
        if (node != null) {
            if (node.getChartPath() != null) {
                this.setChartPath(node.getChartPath());
            }
            if (node.getImagePath() != null) {
                this.setImagePath(node.getImagePath());
            }
            if (node.getSubReportPath() != null) {
                this.setSubReportPath(node.getSubReportPath());
            }
            if (node.getDrillDownPath() != null) {
                this.setDrillDownPath(node.getDrillDownPath(), true);
            }
        }
        LOGGER.finer("Report export started");
        long start = System.currentTimeMillis();
        switch (format) {
            case 2: {
                if (this.isValidForExportOnly()) {
                    if (this.getReportType() == 0 || this.getReportType() == 4) {
                        new PDFReportColumnar(this).exportPDF(out, fileName, userPass, ownerPass, permissions, javaScript);
                        break;
                    }
                    if (this.getReportType() == 1) {
                        new PDFReportSummary(this).exportPDF(out, fileName, userPass, ownerPass, permissions, javaScript);
                        break;
                    }
                    if (this.getReportType() == 3) {
                        new PDFReportMasterDetails(this).exportPDF(out, fileName, userPass, ownerPass, permissions, javaScript);
                        break;
                    }
                    if (this.getReportType() != 2) break;
                    new PDFReportCrossTab(this).exportPDF(out, fileName, userPass, ownerPass, permissions, javaScript);
                    break;
                }
                new PDFReport(this, skipFormatTable).exportPDF(out, fileName, userPass, ownerPass, permissions, javaScript);
                break;
            }
            case 6: {
                new XMLReport(this, skipFormatTable).exportXML(out, fileName);
                break;
            }
            case 14: {
                new PageReport(this).export(out, fileName, this.previewSecurityLevel, expListener);
                break;
            }
            case 7: {
                if (this.isForExportOnly() && (this.sourceData == 1 || this.sourceData == 0)) {
                    new XMLReportPureDataExport(this).exportXML(out);
                    break;
                }
                new XMLReportPureData(this).exportXML(out);
                break;
            }
            case 8: {
                sr = new SaveReport(this);
                sr.generateXMLFile(true);
                sr.setDrillDownNode(node);
                sr.setSubReports(this.subReports);
                sr.setSubFilesTable(this.subFilesTable);
                sr.saveAllChartsFromTheMemoryTableToFileSystem();
                sr.exportReport(out);
                break;
            }
            case 10: 
            case 18: {
                sr = new SaveReport(this);
                sr.generatePAKFile(true);
                sr.setDrillDownNode(node);
                sr.setSubReports(this.subReports);
                sr.setSaveAllData(saveAllData || format == 18);
                sr.exportReport(out);
                break;
            }
            case 1: {
                sr = new SaveReport(this);
                sr.setDrillDownNode(node);
                sr.setSubReports(this.subReports);
                sr.setSaveAllData(saveAllData);
                sr.exportReport(out);
                break;
            }
            case 15: {
                sr = new SaveReport(this);
                sr.saveReportWithData();
                sr.setDrillDownNode(node);
                sr.setSubReports(this.subReports);
                sr.exportReport(out);
                break;
            }
            case 3: {
                if (this.isValidForExportOnly()) {
                    if (this.getReportType() == 0 || this.getReportType() == 4) {
                        new CSVReportColumnar(this).exportCSV(out);
                        break;
                    }
                    if (this.getReportType() == 1) {
                        new CSVReportSummary(this).exportCSV(out);
                        break;
                    }
                    if (this.getReportType() == 3) {
                        new CSVReportMasterDetails(this).exportCSV(out);
                        break;
                    }
                    if (this.getReportType() != 2) break;
                    new CSVReportCrossTab(this).exportCSV(out);
                    break;
                }
                new CSVReport(this, skipFormatTable).exportCSV(out);
                break;
            }
            case 9: 
            case 17: {
                new ExcelReport(this, skipFormatTable).exportExcel(out, format, limitExcelCellSplit);
                break;
            }
            case 5: {
                if (this.isValidForExportOnly()) {
                    if (this.getReportType() == 0 || this.getReportType() == 4) {
                        new CSVReportColumnar(this).exportTXT(out);
                        break;
                    }
                    if (this.getReportType() == 1) {
                        new CSVReportSummary(this).exportTXT(out);
                        break;
                    }
                    if (this.getReportType() == 3) {
                        new CSVReportMasterDetails(this).exportTXT(out);
                        break;
                    }
                    if (this.getReportType() != 2) break;
                    new CSVReportCrossTab(this).exportTXT(out);
                    break;
                }
                new CSVReport(this, skipFormatTable).exportTXT(out);
                break;
            }
            case 4: {
                if (this.isValidForExportOnly()) {
                    if (this.getReportType() == 0 || this.getReportType() == 4) {
                        new DHTMLReportColumnar(this).exportDHTML(out, fileName);
                        break;
                    }
                    if (this.getReportType() == 1) {
                        new DHTMLReportSummary(this).exportDHTML(out, fileName);
                        break;
                    }
                    if (this.getReportType() == 3) {
                        new DHTMLReportMasterDetails(this).exportDHTML(out, fileName);
                        break;
                    }
                    if (this.getReportType() != 2) break;
                    new DHTMLReportCrossTab(this).exportDHTML(out, fileName);
                    break;
                }
                if (exportSpecificPage) {
                    new DHTMLReport(this, skipFormatTable).exportDHTML(out, fileName, exportPage);
                    break;
                }
                new DHTMLReport(this, skipFormatTable).exportDHTML(out, fileName);
                break;
            }
            case 13: {
                if (this.isValidForExportOnly()) {
                    if (this.getReportType() == 0 || this.getReportType() == 4) {
                        new RTFReportColumnar(this).exportRTF(out);
                        break;
                    }
                    if (this.getReportType() == 1) {
                        new RTFReportSummary(this).exportRTF(out);
                        break;
                    }
                    if (this.getReportType() == 3) {
                        new RTFReportMasterDetails(this).exportRTF(out);
                        break;
                    }
                    if (this.getReportType() != 2) break;
                    new RTFReportCrossTab(this).exportRTF(out);
                    break;
                }
                new RTFReport(this, skipFormatTable).exportRTF(out);
            }
        }
        if (this.autoDelete) {
            this.deleteSubReportColDataFiles();
        }
        this.getReportTables().elementAt(0).releaseDiskBuffer();
        LOGGER.finer("Report export finished in " + (System.currentTimeMillis() - start) + " ms");
    }

    public boolean hasSubReportDrillDown() {
        Report[] srarray = this.getSubReportArray();
        if (srarray == null) {
            return false;
        }
        for (Report element : srarray) {
            if (element == null || element.currentNode.getChildCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setDynamicExport(boolean state, String serverName, int servletRunnerPort) {
        this.setDynamicExport(state, serverName, servletRunnerPort, -1);
    }

    public void setDynamicExport(boolean state, String serverName, int servletRunnerPort, int timeoutDuration) {
        this.isDynamicExport = state;
        this.serverName = serverName;
        this.servletRunnerPort = servletRunnerPort;
        this.dynamicExportTimeout = timeoutDuration;
    }

    public void setDynamicExport(boolean state, boolean relativeUrlToServlets) {
        this.isDynamicExport = state;
        this.relativeUrlToServlets = relativeUrlToServlets;
    }

    public boolean relativeUrlToServlets() {
        return this.relativeUrlToServlets;
    }

    public void setHttpsDynamicExport(boolean state, String serverName, int servletRunnerPort) {
        this.setHttpsDynamicExport(state, serverName, servletRunnerPort, -1);
    }

    public void setHttpsDynamicExport(boolean state, String serverName, int servletRunnerPort, int timeoutDuration) {
        this.isHttpsDynamicExport = state;
        this.httpsServerName = serverName;
        this.httpsServletRunnerPort = servletRunnerPort;
        this.dynamicExportTimeout = timeoutDuration;
    }

    public boolean isAggregationOn() {
        return this.doAggregation;
    }

    ReportColumn createColumn(int colInfoIndex, int noOfCol) {
        return new ReportColumn(this.getColumnName(colInfoIndex), this.getDBTableName(colInfoIndex), this.getDataFormat(colInfoIndex), this.getColumnDisplaySize(colInfoIndex), noOfCol, this.reportType == 1 || this.reportType == 2 || this.reportType == 3);
    }

    ReportColumn createColumn(int colInfoIndex, Hashtable<FormattedRowKey, FormattedCell> formattedCellsTable, int noOfCol) {
        return new ReportColumn(this.getColumnName(colInfoIndex), this.getDBTableName(colInfoIndex), this.getDataFormat(colInfoIndex), this.getColumnDisplaySize(colInfoIndex), formattedCellsTable, noOfCol, this.reportType == 1 || this.reportType == 2 || this.reportType == 3);
    }

    public int getSQLType(int colInfoIndex) {
        return this.getSQLType(this.colInfo[colInfoIndex]);
    }

    int getSQLType(ColInfo cInfo) {
        return this.getSQLType(cInfo, false);
    }

    private int getSQLType(ColInfo cInfo, boolean originalCrossTabType) {
        int map = cInfo.getMapping();
        if (map < 0) {
            return cInfo.getDataType();
        }
        if (cInfo.isColumnBreak() && !originalCrossTabType) {
            map = this.getColumnBreakValueMapping();
        }
        ColData cData = this.colData[map];
        if (originalCrossTabType) {
            return cData.getOriginalDataType();
        }
        if (!this.isAggregationOn()) {
            return cData.getOriginalDataType();
        }
        if (cInfo.isRowBreak()) {
            return cData.getOriginalDataType();
        }
        if (cInfo.getAggregation() == 5) {
            return 8;
        }
        if (cInfo.getAggregation() == 4) {
            return 4;
        }
        if (cInfo.getAggregation() == 11) {
            return 4;
        }
        return cData.getOriginalDataType();
    }

    public int getSQLType(int colInfoIndex, boolean originalCrossTabType) {
        return this.getSQLType(this.colInfo[colInfoIndex], originalCrossTabType);
    }

    public int getDataType(int colInfoIndex) {
        return DataType.mapType(this.getSQLType(colInfoIndex));
    }

    IFormat getDataFormat(int colInfoIndex) {
        ColInfo cInfo = this.colInfo[colInfoIndex];
        int map = cInfo.getMapping();
        if (map < 0) {
            if (cInfo.getFormulaObj() != null) {
                cInfo.getFormulaObj().getDatatype(this);
            }
            return FormatUtil.createFormat(DataType.mapType(cInfo.getDataType()));
        }
        if (cInfo.isColumnBreak()) {
            map = this.getColumnBreakValueMapping();
        }
        ColData cData = this.colData[map];
        if (!this.isAggregationOn()) {
            return cData.dataFormat;
        }
        if (cInfo.isRowBreak()) {
            return cData.dataFormat;
        }
        return this.getAggregationDataFormat(cInfo.getAggregation(), cData.dataFormat);
    }

    public String getColumnType(int colInfoIndex) {
        ColInfo cInfo = this.colInfo[colInfoIndex];
        if (cInfo.getFormula() != null) {
            return "FORMULA";
        }
        if (this.getReportType() == 3 && cInfo.isPrimaryKey()) {
            return "PRIMARY KEY";
        }
        if (this.getReportType() == 3 && cInfo.isMaster()) {
            return "MASTER";
        }
        if (this.getReportType() == 3) {
            return "DETAILS";
        }
        if (this.getReportType() == 2 && cInfo.isColumnBreakValue()) {
            return "ROW BREAK VALUE (AGGR : " + ColInfo.AGGR[cInfo.getAggregation()] + ")";
        }
        if (this.getReportType() == 2 && cInfo.isColumnBreak()) {
            return "COLUMN BREAK";
        }
        if (cInfo.isRowBreak()) {
            return "ROW BREAK";
        }
        if (this.getReportType() != 0 && this.getReportType() != 4) {
            return "DATA (AGGR : " + ColInfo.AGGR[cInfo.getAggregation()] + ")";
        }
        return "DATA";
    }

    private IFormat getAggregationDataFormat(short agg, IFormat format) {
        switch (agg) {
            case 1: {
                if (format != null && (format instanceof NumericFormat || format instanceof LocaleNumericFormat)) {
                    return format;
                }
                return FormatUtil.createFormat(4, this.locale, this.timeZone);
            }
            case 4: {
                return FormatUtil.createFormat(2, this.locale, this.timeZone);
            }
            case 5: {
                return FormatUtil.createFormat(4, this.locale, this.timeZone);
            }
        }
        return format;
    }

    private String getColumnName(int colInfoIndex) {
        String name;
        if (this.colInfo == null) {
            LOGGER.warning("COLINFO is null");
        }
        if (this.colInfo[colInfoIndex] == null) {
            LOGGER.warning("COLINFO[" + colInfoIndex + "] is null");
        }
        if ((name = this.colInfo[colInfoIndex].getName()) == null) {
            name = this.colData[this.colInfo[colInfoIndex].getMapping()].getName();
        }
        return name;
    }

    private int getColumnDisplaySize(int colInfoIndex) {
        int map;
        if (this.colInfo == null) {
            LOGGER.warning("COLINFO is null");
        }
        if (this.colInfo[colInfoIndex] == null) {
            LOGGER.warning("COLINFO[" + colInfoIndex + "] is null");
        }
        if ((map = this.colInfo[colInfoIndex].getMapping()) > 0) {
            return this.colData[map].getMaxCharForRecordFile();
        }
        return ServerMessage.getMaxFieldSize();
    }

    private String getDBTableName(int colInfoIndex) {
        String name;
        if (this.colInfo == null) {
            LOGGER.warning("COLINFO is null");
        }
        if (this.colInfo[colInfoIndex] == null) {
            LOGGER.warning("COLINFO[" + colInfoIndex + "] is null");
        }
        if ((name = this.colInfo[colInfoIndex].getDBTableName()) == null && this.colInfo[colInfoIndex].getMapping() >= 0 && this.colData.length > this.colInfo[colInfoIndex].getMapping()) {
            name = this.colData[this.colInfo[colInfoIndex].getMapping()].getTableName();
        }
        return name;
    }

    public int getColumnIndex(ReportColumn rpc) {
        if (this.reportTables == null || this.reportTables.size() == 0) {
            return -1;
        }
        ReportTable tbl = this.reportTables.elementAt(0);
        return tbl.getColumnIndex(rpc);
    }

    public int getColumnIndex(ReportColumn rpc, Vector<Integer> tree) {
        int i;
        if (this.reportTables == null || this.reportTables.size() == 0) {
            return -1;
        }
        ReportTable tbl = this.reportTables.elementAt(0);
        for (i = 0; tree != null && i < tree.size(); ++i) {
            if (!(tbl instanceof ReportTreeTable)) continue;
            tbl = ((ReportTreeTable)tbl).getSubTable(tree.elementAt(i));
        }
        for (i = 0; i < tbl.getColumnCount(); ++i) {
            if (tbl.getColumn(i) != rpc) continue;
            return i;
        }
        return -1;
    }

    public int getColInfoIndex(ReportColumn rpc) {
        return this.getColInfoIndex(this.getColumnIndex(rpc));
    }

    public int getColInfoIndex(ReportColumn rpc, Vector<Integer> tree) {
        return this.getColInfoIndex(this.getColumnIndex(rpc, tree));
    }

    public int getColumnIndex(int colInfoIndex) {
        if (colInfoIndex < 0 || this.getReportType() != 2) {
            return colInfoIndex;
        }
        ReportTable tbl = this.getReportTables().elementAt(0);
        int breakRowIndex = tbl.getStartOfColumnBreakColumn();
        if (colInfoIndex <= breakRowIndex) {
            return colInfoIndex;
        }
        int breakCount = tbl.getColumnBreakColumnCount();
        return colInfoIndex + breakCount - 1;
    }

    public int getColInfoIndex(int colIndex) {
        Vector<ReportTable> reportTbls = this.getReportTables();
        if (reportTbls == null || reportTbls.size() == 0) {
            return colIndex;
        }
        ReportTable tbl = reportTbls.elementAt(0);
        if (colIndex < 0 || !(tbl instanceof CrossTabTable)) {
            return colIndex;
        }
        int breakRowIndex = tbl.getStartOfColumnBreakColumn();
        if (colIndex <= breakRowIndex) {
            return colIndex;
        }
        int breakCount = tbl.getColumnBreakColumnCount();
        if (colIndex < breakRowIndex + breakCount) {
            return breakRowIndex;
        }
        int returnIndex = colIndex - breakCount + 1;
        if (!this.showRowAggregationGrandTotal) {
            ++returnIndex;
        }
        for (int i = this.breakColIndex.length - this.getColumnBreakCount() + 1; i < this.breakColIndex.length; ++i) {
            if (returnIndex < this.breakColIndex[i]) {
                return returnIndex;
            }
            ++returnIndex;
        }
        return returnIndex;
    }

    public int getRowCount(ReportTable tbl) {
        if (tbl instanceof ReportTreeTable) {
            int ct = 0;
            ReportTreeTable mtbl = (ReportTreeTable)tbl;
            for (int i = 0; i < mtbl.countSubTable(); ++i) {
                ct += this.getRowCount(mtbl.getSubTable(i));
            }
            return ct;
        }
        return tbl.getRowCount();
    }

    public Object[] getColumnData(int reportColumnIndex, ReportTable tbl) {
        int i;
        if (tbl instanceof ReportTreeTable) {
            Vector<Object[]> vec = new Vector<Object[]>();
            ReportTreeTable mtbl = (ReportTreeTable)tbl;
            for (int i2 = 0; i2 < mtbl.countSubTable(); ++i2) {
                vec.addElement(this.getColumnData(reportColumnIndex, mtbl.getSubTable(i2)));
            }
            return this.convertToObjectArray(vec, reportColumnIndex);
        }
        ReportColumn col = tbl.getColumn(reportColumnIndex);
        int colInfoIndex = this.getColInfoIndex(reportColumnIndex);
        Object[] data = new Object[col.getDataCount()];
        Object tmp = "";
        for (i = 0; i < data.length; ++i) {
            data[i] = col.getData(i);
            if (!this.colInfo[colInfoIndex].isRowBreak()) continue;
            if (data[i] != null && data[i].equals("")) {
                data[i] = tmp;
                continue;
            }
            tmp = data[i];
        }
        if (!this.colInfo[colInfoIndex].isRowBreak()) {
            return data;
        }
        for (i = 0; i < data.length; ++i) {
            if (data[i] == null || !data[i].equals("")) continue;
            data[i] = tmp;
        }
        return data;
    }

    private Object[] convertToObjectArray(Vector vec, int reportColumnIndex) {
        int len = 0;
        for (int i = 0; i < vec.size(); ++i) {
            len += ((Object[])vec.elementAt(i)).length;
        }
        Object[] data = new Object[len];
        int ct = 0;
        for (int i = 0; i < vec.size(); ++i) {
            Object[] obj = (Object[])vec.elementAt(i);
            System.arraycopy(obj, 0, data, ct, obj.length);
            ct += obj.length;
        }
        int colInfoIndex = this.getColInfoIndex(reportColumnIndex);
        Object tmp = "";
        if (!this.colInfo[colInfoIndex].isRowBreak()) {
            return data;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null && data[i].equals("")) {
                data[i] = tmp;
                continue;
            }
            tmp = data[i];
        }
        return data;
    }

    public IStringCustomizer getStringCustomizer() {
        return this.stringCustomizer;
    }

    public void setStringCustomizer(IStringCustomizer customizer) {
        this.stringCustomizer = customizer;
    }

    public QueryFileInfo getQueryFileInfo() {
        if (this.dbInfo instanceof QueryFileInfo) {
            return (QueryFileInfo)this.dbInfo;
        }
        return null;
    }

    public void setQueryFileInfo(QueryFileInfo queryFileInfo) {
        this.queryFileInfo = queryFileInfo;
    }

    public void setNullDataOption(String str, boolean apply) {
        this.nullDataOption = str;
        if (apply) {
            try {
                FormatUtil.setNumericNULLDataValue(str);
                FormatUtil.setDateTimeNULLDataValue(str);
                FormatUtil.setBooleanNULLDataValue(str);
                FormatUtil.setStringNULLDataValue(str);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to set NULL value", ex);
            }
        }
    }

    public String getNullDataOption() {
        return this.nullDataOption;
    }

    public void setIsApplyBoundSelected(boolean b) {
        this.isApplyBoundSelected = b;
    }

    public boolean isApplyBoundSelected() {
        return this.isApplyBoundSelected;
    }

    public boolean isColDataSorted() {
        return this.colDataSorted;
    }

    public void cleanup() throws Throwable {
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        block8: {
            try {
                if (!this.isCopy && this.colData != null) {
                    for (ColData element : this.colData) {
                        if (element == null) continue;
                        element.cleanup();
                    }
                }
                if (this.isCopy || this.getReportTables().size() <= 0) break block8;
                try {
                    if (this.getReportTables().elementAt(0) instanceof ReportTreeTable) {
                        ((ReportTreeTable)this.getReportTables().elementAt(0)).cleanup();
                        break block8;
                    }
                    this.getReportTables().elementAt(0).cleanup();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Cannot get report table", e);
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    public boolean isDynamicExport() {
        return this.isDynamicExport || this.isHttpsDynamicExport;
    }

    public boolean isSideBySideLayout() {
        return this.reportType == 3 && this.sideBySideLayout;
    }

    public void setSideBySideLayout(boolean b) {
        this.sideBySideLayout = b;
    }

    public int getColumnBreakCount() {
        return this.columnBreakCount;
    }

    public int getColumnBreakValueCount() {
        return this.columnBreakValueCount;
    }

    public boolean placeColumnBreakValueVertically() {
        return this.isCrossTabFixedField() && !this.alignCrossTabColBkValHori && this.getColumnBreakValueCount() > 1;
    }

    public IHTMLLinksProvider getHTMLLinksProvider() {
        return this.htmlLinksProvider;
    }

    public void setHTMLLinksProvider(IHTMLLinksProvider provider) {
        this.htmlLinksProvider = provider;
    }

    public Hashtable<String, byte[]> getDrillDownReportHashtable() {
        return this.drilldownReportHashTable;
    }

    public void setDrillDownReportHashtable(Hashtable<String, byte[]> table) {
        this.drilldownReportHashTable = table;
    }

    public void setSubReportParameterMap(String subReportFileName, String[] paramMap) {
        this.pageHeader.setSubReportParameterMap(subReportFileName, paramMap);
        this.reportHeader.setSubReportParameterMap(subReportFileName, paramMap);
        this.reportFooter.setSubReportParameterMap(subReportFileName, paramMap);
        this.pageFooter.setSubReportParameterMap(subReportFileName, paramMap);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setSubReportParameterMap(subReportFileName, paramMap);
        }
    }

    public void setChartParameterMap(String chartFileName, String[] paramMap) {
        this.pageHeader.setChartParameterMap(chartFileName, paramMap);
        this.reportHeader.setChartParameterMap(chartFileName, paramMap);
        this.reportFooter.setChartParameterMap(chartFileName, paramMap);
        this.pageFooter.setChartParameterMap(chartFileName, paramMap);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.setChartParameterMap(chartFileName, paramMap);
        }
    }

    public boolean formulaExists(String name) {
        for (int i = 0; i < this.formulas.size(); ++i) {
            Formula f = this.formulas.elementAt(i);
            if (f.getName() == null || !f.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean scriptExists(String name) {
        for (int i = 0; i < this.scripts.size(); ++i) {
            Script s = this.scripts.elementAt(i);
            if (!s.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public XMLFileQueryInfo getXMLFileQueryInfo() {
        return this.xmlFileQueryInfo;
    }

    public void setXMLFileQueryInfo(XMLFileQueryInfo info) {
        this.xmlFileQueryInfo = info;
    }

    public int getDBSourceType() {
        return this.dbSourceType;
    }

    public void setDBSourceType(int t) {
        this.dbSourceType = t;
    }

    public byte[][] getQueryFileBytes() {
        return this.queryFileBytes;
    }

    public void setQueryFileBytes(byte[][] bytes) {
        this.queryFileBytes = bytes;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
    }

    public ReportImage getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(ReportImage c) {
        this.backgroundImage = c;
    }

    Vector<Formula> getFormulasWithFixParameters() {
        Vector<Formula> res = new Vector<Formula>();
        Vector<Parameter> queryParam = this.sortParameter(this.queryParameters);
        Vector<Parameter> formulaParam = this.sortParameter(this.formulaParameters);
        for (int i = 0; i < this.formulas.size(); ++i) {
            res.addElement(this.cloneFormulaWithFixParameters(this.formulas.elementAt(i), queryParam, formulaParam));
        }
        return res;
    }

    private Vector<Parameter> sortParameter(Vector<Parameter> params) {
        Vector<Parameter> res = new Vector<Parameter>();
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.elementAt(i);
            int j = 0;
            for (j = 0; j < res.size(); ++j) {
                Parameter param2 = res.elementAt(j);
                if (param.name.length() > param2.name.length()) break;
            }
            res.insertElementAt(param, j);
        }
        return res;
    }

    public String cloneSQLWithFixParameters(String oldSQL) {
        Parameter param;
        int i;
        Vector<Parameter> queryParam = this.sortParameter(this.queryParameters);
        Vector<Parameter> formulaParam = this.sortParameter(this.formulaParameters);
        String text = oldSQL;
        if (queryParam != null) {
            for (i = 0; i < queryParam.size(); ++i) {
                param = queryParam.elementAt(i);
                text = this.replaceSQLWithFixParameter(text, param);
            }
        }
        if (formulaParam != null) {
            for (i = 0; i < formulaParam.size(); ++i) {
                param = formulaParam.elementAt(i);
                text = this.replaceSQLWithFixParameter(text, param);
            }
        }
        return text;
    }

    private Formula cloneFormulaWithFixParameters(Formula oldFormula, Vector<Parameter> queryParam, Vector<Parameter> formulaParam) {
        Parameter param;
        int i;
        String text = oldFormula.getText();
        if (queryParam != null) {
            for (i = 0; i < queryParam.size(); ++i) {
                param = queryParam.elementAt(i);
                text = this.replaceFormulaWithFixParameter(text, param);
            }
        }
        if (formulaParam != null) {
            for (i = 0; i < formulaParam.size(); ++i) {
                param = formulaParam.elementAt(i);
                text = this.replaceFormulaWithFixParameter(text, param);
            }
        }
        if (text.equals(oldFormula.getText())) {
            return oldFormula;
        }
        return new Formula(oldFormula.getName(), text);
    }

    private String replaceSQLWithFixParameter(String text, Parameter param) {
        String key = ":" + param.name;
        Object value = param.value;
        if (value == null) {
            value = "";
        }
        return QbUtil.replace(text, key, "'" + value.toString() + "'");
    }

    private String replaceFormulaWithFixParameter(String text, Parameter param) {
        String key = ":" + param.name;
        Object value = param.value;
        if (value == null) {
            return text;
        }
        String valStr = value.toString();
        if (value instanceof java.sql.Date) {
            valStr = new SimpleDateFormat("MM/dd/yyyy").format((Date)value);
        } else if (value instanceof Time) {
            valStr = new SimpleDateFormat("HH:mm:ss").format((Date)value);
        } else if (value instanceof Timestamp) {
            valStr = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format((Date)value);
        } else if (value instanceof String) {
            valStr = "\"" + value.toString() + "\"";
        }
        return QbUtil.replace(text, key, valStr);
    }

    public Vector<Parameter> getQueryParams() {
        return this.queryParameters;
    }

    public Vector<Parameter> getQueryParameters() {
        Vector<Parameter> temp = new Vector<Parameter>();
        if (this.dbInfo != null && this.dbInfo instanceof IQueryFileInfo) {
            quadbase.reportdesigner.util.IQueryInParam[] params = ReportUtil.getInParam(this.dbInfo);
            for (int i = 0; i < params.length; ++i) {
                Parameter param = null;
                for (int j = 0; this.queryParameters != null && j < this.queryParameters.size(); ++j) {
                    param = this.queryParameters.elementAt(j);
                    if (param.getName().equals(params[i].getParamName()) && (param.isMultiValueParam() && params[i] instanceof IQueryMultiValueInParam || !param.isMultiValueParam() && !(params[i] instanceof IQueryMultiValueInParam)) && DataType.isCompatibleSQLTypes(param.getSQLType(), params[i].getSqlType())) {
                        if (params[i] instanceof IQueryMultiValueInParam) {
                            param.setValues(((IQueryMultiValueInParam)params[i]).getValues());
                            break;
                        }
                        param.setValue(params[i].getValue());
                        break;
                    }
                    param = null;
                }
                if (param == null) {
                    param = new Parameter(params[i]);
                }
                temp.addElement(param);
            }
        }
        this.queryParameters = temp;
        return this.queryParameters;
    }

    public void setQueryParameters(Vector<Parameter> qparam) {
        this.queryParameters = qparam;
    }

    public Vector<Parameter> getFormulaParameters() {
        return this.formulaParameters;
    }

    public Vector<Parameter> getFormulaParameters(String name) {
        Vector<Parameter> vec = new Vector<Parameter>();
        for (int i = 0; i < this.formulaParameters.size(); ++i) {
            Parameter param = this.formulaParameters.elementAt(i);
            if (!param.isUsedBy(name)) continue;
            vec.addElement(param);
        }
        return vec;
    }

    public boolean paramsInitialized() {
        for (int i = 0; i < this.formulaParameters.size(); ++i) {
            Parameter param = this.formulaParameters.elementAt(i);
            if (param.isInitialized()) continue;
            return false;
        }
        return true;
    }

    public void deleteUnInitializedParam() {
        int i = 0;
        while (i < this.formulaParameters.size()) {
            Parameter param = this.formulaParameters.elementAt(i);
            if (!param.isInitialized()) {
                this.formulaParameters.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void deleteUnUsedParam() {
        int i = 0;
        while (i < this.formulaParameters.size()) {
            Parameter param = this.formulaParameters.elementAt(i);
            if (param.formulaNames == null || param.formulaNames.size() == 0) {
                this.formulaParameters.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void cloneFormulaParams(Vector<Parameter> formulaParams) {
        for (int i = 0; i < this.formulaParameters.size(); ++i) {
            formulaParams.addElement(Parameter.clone(this.formulaParameters.elementAt(i)));
        }
    }

    public void addGuideLine(GuideLine gl) {
        if (gl.isVertical()) {
            if (this.vGuideLines == null) {
                this.vGuideLines = new Vector();
            }
            this.vGuideLines.addElement(gl);
        } else {
            if (this.hGuideLines == null) {
                this.hGuideLines = new Vector();
            }
            this.hGuideLines.addElement(gl);
        }
    }

    public void replaceGuideLine(GuideLine old, GuideLine gl) {
        if (old.isVertical()) {
            for (int i = 0; i < this.vGuideLines.size(); ++i) {
                GuideLine cur = this.vGuideLines.elementAt(i);
                if (cur != old) continue;
                this.vGuideLines.remove(i);
                this.vGuideLines.insertElementAt(gl, i);
            }
        } else {
            for (int i = 0; i < this.hGuideLines.size(); ++i) {
                GuideLine cur = this.hGuideLines.elementAt(i);
                if (cur != old) continue;
                this.hGuideLines.remove(i);
                this.hGuideLines.insertElementAt(gl, i);
            }
        }
    }

    public void removeEltFromGuideLine(ReportElement elt) {
        GuideLine gl;
        int i;
        short snap = elt.getSnap();
        short vsnap = elt.getVSnap();
        if (snap > 0 && this.hGuideLines != null) {
            for (i = 0; i < this.hGuideLines.size(); ++i) {
                gl = this.hGuideLines.elementAt(i);
                gl.removeElt(elt);
            }
        }
        if (vsnap > 0 && this.vGuideLines != null) {
            for (i = 0; i < this.vGuideLines.size(); ++i) {
                gl = this.vGuideLines.elementAt(i);
                gl.removeElt(elt);
            }
        }
    }

    public void removeAllFromGuideLine(GuideLine guideline) {
        GuideLine gl;
        int i;
        guideline = (GuideLine)guideline.getHeadNode();
        if (this.hGuideLines != null) {
            for (i = 0; i < this.hGuideLines.size(); ++i) {
                gl = this.hGuideLines.elementAt(i);
                if (guideline != gl) continue;
                gl.removeAll();
            }
        }
        if (this.vGuideLines != null) {
            for (i = 0; i < this.vGuideLines.size(); ++i) {
                gl = this.vGuideLines.elementAt(i);
                if (guideline != gl) continue;
                gl.removeAll();
            }
        }
    }

    public Vector<GuideLine> getVGuideLines() {
        return this.vGuideLines;
    }

    public Vector<GuideLine> getHGuideLines() {
        return this.hGuideLines;
    }

    public GuideLine getVGuideLine(int index) {
        return this.vGuideLines.elementAt(index);
    }

    public GuideLine getHGuideLine(int index) {
        return this.hGuideLines.elementAt(index);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean b) {
        this.ascending = b;
    }

    public int getTopN() {
        return this.topN;
    }

    public void setTopN(int i) {
        this.topN = i;
    }

    public boolean isTopNReport() {
        return this.topN > 0;
    }

    void copyFitGroupColInfo(ColInfo[] dest, ColInfo[] source) {
        if (dest == null || source == null) {
            return;
        }
        int i = 0;
        int j = 0;
        while (i < dest.length && j < source.length) {
            if (dest[i] == null) {
                ++i;
                continue;
            }
            if (source[j] == null) {
                ++j;
                continue;
            }
            if (!dest[i].isRowBreak() && !source[j].isRowBreak()) {
                ++i;
                ++j;
                continue;
            }
            if (dest[i].isRowBreak() && source[j].isRowBreak()) {
                dest[i].setFitGroupOnPage(source[j].isFitGroupOnPage());
                dest[i].setSkipFirstValueForFitGroup(source[j].skipFirstValueForFitGroup());
                ++i;
                ++j;
                continue;
            }
            if (!dest[i].isRowBreak()) {
                ++i;
                continue;
            }
            if (source[j].isRowBreak()) continue;
            ++j;
        }
    }

    private void copyGuideLines(Report _report) {
        GuideLine gl;
        int i;
        this.vGuideLines = new Vector();
        if (_report.vGuideLines != null) {
            for (i = 0; i < _report.vGuideLines.size(); ++i) {
                gl = new GuideLine();
                gl.deepCopy(_report.vGuideLines.elementAt(i));
                this.vGuideLines.addElement(gl);
            }
        }
        this.hGuideLines = new Vector();
        if (_report.hGuideLines != null) {
            for (i = 0; i < _report.hGuideLines.size(); ++i) {
                gl = new GuideLine();
                gl.deepCopy(_report.hGuideLines.elementAt(i));
                this.hGuideLines.addElement(gl);
            }
        }
        this.reportHeader.copyAllGuideLineElts(this, _report, _report.getReportHeader());
        this.pageHeader.copyAllGuideLineElts(this, _report, _report.getPageHeader());
        this.getReportTables().elementAt(0).copyAllGuideLineElts(this, _report, _report.getReportTables().elementAt(0));
        this.pageFooter.copyAllGuideLineElts(this, _report, _report.getPageFooter());
        this.reportFooter.copyAllGuideLineElts(this, _report, _report.getReportFooter());
    }

    public void updateFormulas(Vector<Formula> newFormulas) {
        if (newFormulas == null) {
            return;
        }
        for (int i = 0; i < newFormulas.size(); ++i) {
            Formula formula = newFormulas.elementAt(i);
            if (formula.getName() == null) continue;
            boolean found = false;
            for (int j = 0; j < this.formulas.size(); ++j) {
                if (!formula.getName().equals(this.formulas.elementAt(j).getName())) continue;
                this.formulas.setElementAt(formula, j);
                found = true;
                break;
            }
            if (found) continue;
            this.formulas.addElement(formula);
        }
    }

    public void updateScripts(Vector<Script> newScripts) {
        if (newScripts == null) {
            return;
        }
        for (int i = 0; i < newScripts.size(); ++i) {
            Script script = newScripts.elementAt(i);
            if (script.getName() == null) continue;
            boolean found = false;
            for (int j = 0; j < this.scripts.size(); ++j) {
                if (!script.getName().equals(this.scripts.elementAt(j).getName())) continue;
                this.scripts.setElementAt(script, j);
                found = true;
                break;
            }
            if (found) continue;
            this.scripts.addElement(script);
        }
    }

    public void updateQueryParameters(Vector<Parameter> newParameters) {
        if (newParameters == null) {
            return;
        }
        for (int i = 0; i < newParameters.size(); ++i) {
            Parameter parameter = newParameters.elementAt(i);
            if (parameter.getName() == null) continue;
            boolean found = false;
            for (int j = 0; j < this.queryParameters.size(); ++j) {
                if (!parameter.getName().equals(this.queryParameters.elementAt(j).getName())) continue;
                this.queryParameters.setElementAt(parameter, j);
                found = true;
                break;
            }
            if (found) continue;
            this.queryParameters.addElement(parameter);
        }
    }

    public void updateFormulaParameters(Vector<Parameter> newParameters) {
        if (newParameters == null) {
            return;
        }
        for (int i = 0; i < newParameters.size(); ++i) {
            Parameter parameter = newParameters.elementAt(i);
            if (parameter.getName() == null) continue;
            boolean found = false;
            for (int j = 0; j < this.formulaParameters.size(); ++j) {
                if (!parameter.getName().equals(this.formulaParameters.elementAt(j).getName())) continue;
                this.formulaParameters.setElementAt(parameter, j);
                found = true;
                break;
            }
            if (found) continue;
            this.formulaParameters.addElement(parameter);
        }
    }

    public void setSnapToGrid(boolean snapToGrid, boolean metric, double stepSize) {
        this.snapToGrid = snapToGrid;
        if (metric) {
            this.cmGridStepSize = stepSize;
        } else {
            this.gridStepSize = stepSize;
        }
        this.pageHeader.setSnapToGrid(snapToGrid, metric, stepSize);
        this.reportHeader.setSnapToGrid(snapToGrid, metric, stepSize);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.setSnapToGrid(snapToGrid, metric, stepSize);
        }
        this.reportFooter.setSnapToGrid(snapToGrid, metric, stepSize);
        this.pageFooter.setSnapToGrid(snapToGrid, metric, stepSize);
    }

    public void setSnapToGrid(boolean snapToGrid, double stepSize, double cmStepSize) {
        this.snapToGrid = snapToGrid;
        this.cmGridStepSize = cmStepSize;
        this.pageHeader.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        this.reportHeader.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
        this.reportFooter.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        this.pageFooter.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
    }

    public boolean isAdjustFont() {
        return this.isAdjustFont;
    }

    public void setAdjustFont(boolean state) {
        this.isAdjustFont = state;
    }

    public boolean isValidSecurityLevel(String level) {
        String[] secLevels;
        if (level == null) {
            return true;
        }
        for (String secLevel : secLevels = this.getSecurityLevels()) {
            if (!secLevel.equals(level)) continue;
            return true;
        }
        return false;
    }

    public String getPreviewSecurityLevel() {
        return this.previewSecurityLevel;
    }

    public void setPreviewSecurityLevel(String level) {
        this.previewSecurityLevel = level;
    }

    public Hashtable<String, QueryInParam[]> getSecurityQueryParameterMap() {
        return this.securityQueryParameterMap;
    }

    public void setSecurityQueryParameterMap(Hashtable<String, QueryInParam[]> map) {
        this.securityQueryParameterMap = map;
    }

    public IDynamicImageURLGenerator getDynamicImageURLGenerator() {
        return this.dynamicImageURLGenerator;
    }

    public void setDynamicImageURLGenerator(IDynamicImageURLGenerator generator) {
        this.dynamicImageURLGenerator = generator;
    }

    public IDynamicReportKeyGenerator getDynamicReportKeyGenerator() {
        return this.dynamicReportKeyGenerator;
    }

    public void setDynamicReportKeyGenerator(IDynamicReportKeyGenerator generator) {
        this.dynamicReportKeyGenerator = generator;
    }

    public boolean isHttpsDynamicExport() {
        return this.isHttpsDynamicExport;
    }

    public String getHttpsServerName() {
        return this.httpsServerName;
    }

    public int getHttpsServletRunnerPort() {
        return this.httpsServletRunnerPort;
    }

    public ParameterPage getParameterPage(String reportLoc, String securityLevel, int format, String servletName) {
        return this.getParameterPage(reportLoc, securityLevel, format, servletName, 0);
    }

    public ParameterPage getParameterPage(String reportLoc, String securityLevel, int format, String servletName, int order) {
        this.getSubReportArray(true);
        Parameters params = order == -1 ? this.getParametersInSequence() : this.getParametersInSequence().getParamsAt(order);
        if (params.size() == 0) {
            return null;
        }
        IQueryFileInfo qfi = null;
        if (this.dbInfo != null && this.dbInfo instanceof IQueryFileInfo) {
            qfi = (IQueryFileInfo)((Object)this.dbInfo);
        }
        return new ReportParameterPage(servletName, this.paramPageExportFormats, reportLoc, format, this.paramPageResetEnabled, this.paramPageLayout, this.extraFormContent, securityLevel, this.serverName, this.servletRunnerPort, this.servletDirectory, params, order, qfi);
    }

    private IQueryInParam[][] getSubReportQueryParamSet(Vector<SubReportObject> subReports, IReport[] subreports, String securityLevel) {
        return this.getSubReportQueryParamSet(subReports, subreports, securityLevel, -1);
    }

    private IQueryInParam[][] getSubReportQueryParamSet(Vector<SubReportObject> subReports, IReport[] subreports, String securityLevel, int order) {
        if (subreports == null) {
            return null;
        }
        if (this.order_offset == null) {
            this.order_offset = new int[subreports.length];
        }
        IQueryInParam[][] result = new IQueryInParam[subreports.length][];
        for (int i = 0; i < subreports.length; ++i) {
            order -= this.order_offset[i];
            Report subreport = (Report)subreports[i];
            if (subreport == null) continue;
            Hashtable<String, Parameter> sharedParams = Report.getSharedParams(subreport);
            IQueryInParam[] queryParamSet = null;
            IQueryInParam[][] paramInSequence = null;
            IQueryInParam[] securityQueryParams = null;
            Vector<IQueryInParam> curAvailSet = new Vector<IQueryInParam>();
            if (subreport.dbInfo != null && subreport.dbInfo instanceof IQueryFileInfo) {
                queryParamSet = ReportUtil.getInParam(subreport.dbInfo);
                paramInSequence = ReportUtil.getParamInSequence(subreport.dbInfo);
            }
            if (queryParamSet == null) continue;
            if (securityLevel != null && subreport.getSecurityQueryParameterMap() != null) {
                securityQueryParams = QueryParser.verifyParameters(queryParamSet, (IQueryInParam[])subreport.getSecurityQueryParameterMap().get(securityLevel));
            }
            IQueryInParam[] unselectedParams = ReportUtil.getUnSelectedParams(queryParamSet, securityQueryParams, false);
            String[] paramMap = subReports.elementAt(i).getParameterMap();
            for (int j = 0; j < queryParamSet.length; ++j) {
                if (!ReportUtil.queryParamIsNotSelected(queryParamSet[j], unselectedParams)) continue;
                if (paramInSequence == null || order == -1) {
                    if (order > 0 || sharedParams.get(queryParamSet[j].getParamName()) != null || paramMap != null && paramMap.length > j && paramMap[j] != null) continue;
                    curAvailSet.add(queryParamSet[j]);
                    continue;
                }
                for (int k = 0; order > -1 && order < paramInSequence.length && k < paramInSequence[order].length; ++k) {
                    if (paramInSequence[order][k] == null || !paramInSequence[order][k].getParamName().equals(queryParamSet[j].getParamName())) continue;
                    if (sharedParams.get(queryParamSet[j].getParamName()) == null && (paramMap == null || paramMap.length <= j || paramMap[j] == null)) {
                        paramInSequence[order][k] = queryParamSet[j];
                        curAvailSet.add(queryParamSet[j]);
                        continue;
                    }
                    if (sharedParams.get(queryParamSet[j].getParamName()) == null) continue;
                    Parameter sharedParam = sharedParams.get(queryParamSet[j].getParamName());
                    int sharedParamOrder = this.getParameterOrder(sharedParam.getSharedReportName(), sharedParam.getSharedParamName());
                    this.order_offset[i] = sharedParamOrder - order;
                }
            }
            IQueryInParam[] curSetArray = new IQueryInParam[curAvailSet.size()];
            int j = 0;
            Enumeration e = curAvailSet.elements();
            while (e.hasMoreElements()) {
                curSetArray[j] = (IQueryInParam)e.nextElement();
                ++j;
            }
            result[i] = curSetArray;
        }
        return result;
    }

    private int getParameterOrder(String reportID, String paramName) {
        if (reportID.equals(MAIN_REPORT)) {
            return ((QueryFileInfo)this.dbInfo).getInSet().getParameterOrder(paramName);
        }
        SubReportObject[] srObjs = new SubReportObject[this.subReports.size()];
        Report subR = null;
        int index = 0;
        for (int i = 0; i < this.subReports.size(); ++i) {
            srObjs[i] = this.subReports.elementAt(i);
            if (!srObjs[i].getParamShareReportID().equals(reportID)) continue;
            index = i;
        }
        subR = this.getSubReportArray()[index];
        return ((QueryFileInfo)subR.dbInfo).getInSet().getParameterOrder(paramName);
    }

    public void renameSecurityLevel(String oldName, String newName) {
        this.pageHeader.renameSecurityLevel(oldName, newName);
        this.reportHeader.renameSecurityLevel(oldName, newName);
        this.reportFooter.renameSecurityLevel(oldName, newName);
        this.pageFooter.renameSecurityLevel(oldName, newName);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.renameSecurityLevel(oldName, newName);
        }
    }

    public void renameQueryParameterSecurityLevel(String oldName, String newName) {
        if (this.securityQueryParameterMap != null) {
            Enumeration<String> enum1 = this.securityQueryParameterMap.keys();
            while (enum1.hasMoreElements()) {
                String securityLevelName = enum1.nextElement();
                if (!securityLevelName.equals(oldName)) continue;
                QueryInParam[] level = this.securityQueryParameterMap.get(oldName);
                this.securityQueryParameterMap.remove(oldName);
                this.securityQueryParameterMap.put(newName, level);
            }
        }
    }

    public String getDescription(ReportElement elt) {
        if (elt == null) {
            return null;
        }
        String ID = elt.getID();
        return this.getDescription(elt, ID);
    }

    private String getDescription(ReportElement elt, String name) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        StringTokenizer names = new StringTokenizer(name, "_");
        StringBuffer str = new StringBuffer();
        str.append("Type : ");
        str.append(this.getElementTypeStr(elt)).append("\n");
        str.append("Location : ");
        while (names.hasMoreElements()) {
            String token = names.nextToken();
            str.append(this.getDescriptionForToken(token)).append(" ");
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString();
    }

    private String getElementTypeStr(ReportElement elt) {
        if (elt instanceof ReportTreeTable) {
            return "Report Tree Table";
        }
        if (elt instanceof ReportTable) {
            return "Report Table";
        }
        if (elt instanceof ReportSection) {
            return "Report Section";
        }
        if (elt instanceof GuideLine) {
            return "GuideLine";
        }
        if (elt instanceof ReportLine) {
            return "Report Line";
        }
        if (elt instanceof ReportGrid) {
            return "Report Rectangle";
        }
        if (elt instanceof ReportChartObject) {
            return "Report Chart Object";
        }
        if (elt instanceof ReportImage) {
            return "Report Image";
        }
        if (elt instanceof ReportDocument) {
            return "Report Document";
        }
        if (elt instanceof ColumnHeader) {
            return "Column Header";
        }
        if (elt instanceof ReportRTFObject) {
            return "Rich Text";
        }
        if (elt instanceof SubReportObject) {
            return "SubReport Object";
        }
        if (elt instanceof ReportCell) {
            return "Report Cell";
        }
        if (elt instanceof ReportColumn) {
            return "Report Column";
        }
        return "Report Element";
    }

    private String getDescriptionForToken(String token) {
        int index = 0;
        StringBuffer str = new StringBuffer();
        if (token.startsWith("PG")) {
            str.append("Page ");
            index = 2;
        } else if (token.startsWith("RPT")) {
            str.append("Report ");
            index = 3;
        } else if (token.startsWith("HDR")) {
            str.append("Header ");
            index = 3;
        } else if (token.startsWith("FTR")) {
            str.append("Footer ");
            index = 3;
        } else if (token.startsWith("CHT")) {
            str.append("ReportChart ");
            index = 3;
        } else if (token.startsWith("GRID")) {
            str.append("ReportGrid ");
            index = 3;
        } else if (token.startsWith("LINE")) {
            str.append("ReportLine ");
            index = 4;
        } else if (token.startsWith("IMG")) {
            str.append("ReportImage ");
            index = 3;
        } else if (token.startsWith("COL")) {
            str.append("ReportColumn ");
            index = 3;
        } else if (token.startsWith("FORM")) {
            str.append("Formula ");
            index = 4;
        } else if (token.startsWith("LB")) {
            str.append("Label ");
            index = 2;
        } else if (token.startsWith("SEC")) {
            str.append("ReportSection ");
            index = 3;
        } else if (token.startsWith("TBL")) {
            str.append("Table ");
            index = 3;
        } else if (token.startsWith("SRPT")) {
            str.append("Script ");
            index = 4;
        } else if (token.startsWith("H")) {
            str.append("GroupHeader ");
            index = 1;
        } else if (token.startsWith("F")) {
            str.append("GroupFooter ");
            index = 1;
        } else if (!this.tokenStartsWithNumber(token)) {
            LOGGER.warning("Invalid object type");
        }
        if (index < token.length()) {
            String substring = token.substring(index);
            str.append(substring);
        }
        return str.toString();
    }

    private boolean tokenStartsWithNumber(String token) {
        return token.startsWith("0") || token.startsWith("1") || token.startsWith("2") || token.startsWith("3") || token.startsWith("4") || token.startsWith("5") || token.startsWith("6") || token.startsWith("7") || token.startsWith("8") || token.startsWith("9");
    }

    private Vector<Report> getDrillDownReportVector() {
        if (this.drillDownReportVector == null || this.drillDownReportVector.size() != this.countDrillDownReport(this.currentNode)) {
            this.drillDownReportVector = this.createDrillDownReportVector(this.currentNode, new Vector<Report>());
        }
        return this.drillDownReportVector;
    }

    private int countDrillDownReport(DrillDownNode cNode) {
        int res = 0;
        if (cNode == null) {
            return res;
        }
        res = cNode.getChildCount();
        for (int i = 0; i < cNode.getChildCount(); ++i) {
            DrillDownNode node = cNode.getChildAt(i);
            res += this.countDrillDownReport(node);
        }
        return res;
    }

    private Vector<Report> createDrillDownReportVector(DrillDownNode cNode, Vector<Report> vec) {
        if (cNode == null) {
            return vec;
        }
        for (int i = 0; i < cNode.getChildCount(); ++i) {
            try {
                boolean isPAK;
                DrillDownNode node = cNode.getChildAt(i);
                Report rpt = null;
                LoadReport lr = new LoadReport();
                lr.setSubFilesTable(this.subFilesTable);
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(node.getDomainPath());
                boolean bl = isPAK = this.subFilesTable != null && this.subFilesTable.getTopName() != null && SaveReport.isPAKFile(this.subFilesTable.getTopName());
                if (isPAK && SaveReport.isRPTFile(node.getFileName())) {
                    node.setFileName(SaveReport.getPakFileName(node.getFileName()));
                }
                String nodeFileName = node.getFileName();
                rpt = node.getByteArray() != null ? lr.loadReportFromByteArray(node.getByteArray()) : (isPAK && this.subFilesTable.containsKey(nodeFileName) ? lr.loadReportFromByteArray(this.subFilesTable.get(nodeFileName)) : lr.loadReportFromFile(nodeFileName));
                if (rpt == null) continue;
                vec.addElement(rpt);
                this.createDrillDownReportVector(node, vec);
                continue;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to create drill-down report vector", ex);
            }
        }
        return vec;
    }

    private void createSubReportArray(boolean useBackupData) {
        if (this.subReports == null) {
            return;
        }
        try {
            int i;
            this.subReportArray = new Report[this.subReports.size()];
            for (i = 0; i < this.subReports.size(); ++i) {
                SubReportObject sro = this.subReports.elementAt(i);
                if (sro.getCachedSubReport() != null) {
                    this.subReportArray[i] = sro.getCachedSubReport().getReportInfo();
                    continue;
                }
                LoadReport lr = new LoadReport();
                lr.setSubFilesTable(this.subFilesTable);
                lr.getSubReportParameter = true;
                lr.setBackupDataUsed(useBackupData);
                lr.setRelativeDomainPath(sro.getDomainPath());
                this.subReportArray[i] = sro.getByteArray() != null && (this.currentNode.getFileName(this.subFilesTable).equals("") || this.currentNode.getFileName(this.subFilesTable).toLowerCase().endsWith(".pak")) ? lr.loadReport(new DataInputStream(new ByteArrayInputStream(sro.getByteArray())), null) : lr.loadReportFromFile(sro.getFileName());
            }
            for (i = 0; i < this.subReports.size(); ++i) {
                this.subReportArray[i].setSubReportPath(this.getSubReportPath());
                this.subReportArray[i].domainPath = this.domainPath;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Failed to create sub-report array", ex);
        }
    }

    public Report[] getSubReportArray() {
        return this.getSubReportArray(false);
    }

    public Report[] getSubReportArray(boolean useBackupData) {
        boolean create = false;
        if (this.subReportArray == null || this.subReports != null && this.subReportArray.length != this.subReports.size()) {
            create = true;
        } else {
            for (Report element : this.subReportArray) {
                if (element != null) continue;
                create = true;
            }
        }
        if (create) {
            this.createSubReportArray(useBackupData);
        }
        return this.subReportArray;
    }

    public Hashtable<String, Parameter[]> getSubQueryParamTable() {
        return this.subQueryParamTable;
    }

    public void setSubQueryParamTable(Hashtable<String, Parameter[]> table) {
        this.subQueryParamTable = table;
    }

    public Hashtable<String, Parameter[]> getSubFormulaParamTable() {
        return this.subFormulaParamTable;
    }

    public void setSubFormulaParamTable(Hashtable<String, Parameter[]> table) {
        this.subFormulaParamTable = table;
    }

    public boolean isResizeSubReportWidth() {
        if (this.subReports == null) {
            return false;
        }
        for (int i = 0; i < this.subReports.size(); ++i) {
            SubReportObject sr = this.subReports.elementAt(i);
            if (!sr.isResizeWidth()) continue;
            return true;
        }
        return false;
    }

    public void setSubReportParamValues(Param param) {
        quadbase.reportdesigner.util.IQueryInParam[] inParam = ReportUtil.getInParam(param.getQueryFileInfo());
        if (inParam == null) {
            return;
        }
        for (quadbase.reportdesigner.util.IQueryInParam element : inParam) {
            if (!element.getParamName().equals(param.name())) continue;
            if (element instanceof IQueryMultiValueInParam) {
                ((IQueryMultiValueInParam)element).setValues(param.getValues());
                continue;
            }
            element.setValue(param.getValue());
        }
        Report[] subR = this.getSubReportArray();
        if (subR == null) {
            return;
        }
        for (int i = 0; i < subR.length; ++i) {
            if (subR[i] == null) continue;
            if (subR[i] == param.getReport()) {
                SubReportObject sro = this.subReports.elementAt(i);
                String key = sro.getParamShareReportID();
                Parameter[] pArray = this.subQueryParamTable.get(key);
                for (int j = 0; pArray != null && j < pArray.length; ++j) {
                    if (!param.name().equals(pArray[j].getName())) continue;
                    if (pArray[j].isMultiValueParam()) {
                        pArray[j].setValues(param.getValues());
                        continue;
                    }
                    pArray[j].setValue(param.getValue());
                }
            }
            Vector<Parameter> params = subR[i].getQueryParameters();
            for (int j = 0; j < params.size(); ++j) {
                inParam = ReportUtil.getInParam(subR[i].dbInfo);
                Parameter theParam = params.elementAt(j);
                if (!theParam.isShared() || !theParam.getSharedParamName().equals(param.name())) continue;
                if (theParam.isMultiValueParam()) {
                    ((IQueryMultiValueInParam)inParam[j]).setValues(param.getValues());
                    continue;
                }
                inParam[j].setValue(param.getValue());
            }
        }
    }

    public void setSubReportParameters(Object httpServletRequest) {
        Object[] params = this.getNonSharedAvailableSubReportParams();
        if (params == null) {
            return;
        }
        if (params.length < 1) {
            return;
        }
        Class<?> reqClass = null;
        Method getParamValsMethod = null;
        Object returnObj = null;
        String requestName = "subParamValue_";
        try {
            reqClass = httpServletRequest.getClass();
            getParamValsMethod = reqClass.getMethod("getParameterValues", String.class);
            for (int i = 0; i < params.length; ++i) {
                returnObj = getParamValsMethod.invoke(httpServletRequest, requestName + i);
                if (returnObj == null) {
                    return;
                }
                String[] value = (String[])returnObj;
                Report.setValue(this.subParamToMappedParams.get(params[i]), params[i], value);
            }
        }
        catch (NoSuchMethodException ne) {
            LOGGER.log(Level.WARNING, "Failed to set sub-report parameters", ne);
        }
        catch (IllegalAccessException ae) {
            LOGGER.log(Level.WARNING, "Failed to set sub-report parameters", ae);
        }
        catch (InvocationTargetException ie) {
            LOGGER.log(Level.WARNING, "Failed to set sub-report parameters", ie);
        }
    }

    public Object[] getNonSharedAvailableSubReportParams() {
        int j;
        Parameter[] params;
        int i;
        if (this.subReports == null || this.subReports.size() == 0) {
            return null;
        }
        String securityLevel = this.getPreviewSecurityLevel();
        IReport[] srArr = this.getSubReportArray();
        SubReportObject[] srObjs = new SubReportObject[this.subReports.size()];
        for (int i2 = 0; i2 < this.subReports.size(); ++i2) {
            srObjs[i2] = this.subReports.elementAt(i2);
        }
        this.subParamToMappedParams = new Hashtable();
        this.setupSubReportParamMap(srArr);
        IQueryInParam[][] srAvailQParams = this.getSubReportQueryParamSet(this.subReports, srArr, securityLevel);
        Parameter[][] srFParams = Report.getSubReportFormulaParams(srArr);
        Vector<Object> result = new Vector<Object>();
        if (srAvailQParams != null) {
            for (i = 0; i < srAvailQParams.length; ++i) {
                if (srAvailQParams[i] == null) continue;
                this.paramNameToObj = new Hashtable();
                for (Parameter param : params = this.subQueryParamTable.get(srObjs[i].getParamShareReportID())) {
                    this.paramNameToObj.put(param.getName(), param);
                }
                for (j = 0; j < srAvailQParams[i].length; ++j) {
                    if (srAvailQParams[i][j] == null) continue;
                    result.add(srAvailQParams[i][j]);
                    this.subParamToMappedParams.put(srAvailQParams[i][j], this.paramNameToObj.get(srAvailQParams[i][j].getParamName()));
                }
            }
        }
        if (srFParams != null) {
            for (i = 0; i < srFParams.length; ++i) {
                if (srFParams[i] == null) continue;
                this.paramNameToObj = new Hashtable();
                for (Parameter param : params = this.subFormulaParamTable.get(srObjs[i].getParamShareReportID())) {
                    this.paramNameToObj.put(param.getName(), param);
                }
                for (j = 0; j < srFParams[i].length; ++j) {
                    if (srFParams[i][j] == null) continue;
                    result.add(srFParams[i][j]);
                    this.subParamToMappedParams.put(srFParams[i][j], this.paramNameToObj.get(srFParams[i][j].getName()));
                }
            }
        }
        return Report.toArray(result);
    }

    public Vector<Param> getNonSharedAvailableSubReportParamsAsParam() {
        return this.getNonSharedAvailableSubReportParamsAsParam(false);
    }

    public Vector<Param> getNonSharedAvailableSubReportParamsAsParam(boolean useBackupData) {
        return this.getNonSharedAvailableSubReportParamsAsParam(useBackupData, -1);
    }

    public Vector<Param> getNonSharedAvailableSubReportParamsAsParam(int order) {
        return this.getNonSharedAvailableSubReportParamsAsParam(false, order);
    }

    private Vector<Param> getNonSharedAvailableSubReportParamsAsParam(boolean useBackupData, int order) {
        int j;
        Parameter[] params;
        String subreportName;
        int i;
        if (this.subReports == null || this.subReports.size() == 0) {
            return null;
        }
        String securityLevel = this.getPreviewSecurityLevel();
        IReport[] srArr = this.getSubReportArray(useBackupData);
        SubReportObject[] srObjs = new SubReportObject[this.subReports.size()];
        for (int i2 = 0; i2 < this.subReports.size(); ++i2) {
            srObjs[i2] = this.subReports.elementAt(i2);
        }
        this.subParamToMappedParams = new Hashtable();
        this.setupSubReportParamMap(srArr);
        IQueryInParam[][] srAvailQParams = this.getSubReportQueryParamSet(this.subReports, srArr, securityLevel, order);
        Parameter[][] srFParams = Report.getSubReportFormulaParams(srArr);
        Vector<Param> result = new Vector<Param>();
        if (srAvailQParams != null) {
            for (i = 0; i < srAvailQParams.length; ++i) {
                subreportName = "Sub_Report_" + (i + 1);
                if (srAvailQParams[i] == null) continue;
                this.paramNameToObj = new Hashtable();
                for (Parameter param : params = this.subQueryParamTable.get(srObjs[i].getParamShareReportID())) {
                    this.paramNameToObj.put(param.getName(), param);
                }
                for (j = 0; j < srAvailQParams[i].length; ++j) {
                    if (srAvailQParams[i][j] == null) continue;
                    Parameter queryParam = Report.getParameterFrom(params, srAvailQParams[i][j]);
                    result.add(new QueryParam(subreportName, queryParam));
                    this.subParamToMappedParams.put(srAvailQParams[i][j], this.paramNameToObj.get(srAvailQParams[i][j].getParamName()));
                }
            }
        }
        if (srFParams != null) {
            for (i = 0; i < srFParams.length; ++i) {
                subreportName = "Sub_Report_" + (i + 1);
                if (srFParams[i] == null) continue;
                this.paramNameToObj = new Hashtable();
                for (Parameter param : params = this.subFormulaParamTable.get(srObjs[i].getParamShareReportID())) {
                    this.paramNameToObj.put(param.getName(), param);
                }
                for (j = 0; j < srFParams[i].length; ++j) {
                    if (srFParams[i][j] == null) continue;
                    result.add(new FormulaParam(subreportName, srFParams[i][j]));
                    this.subParamToMappedParams.put(srFParams[i][j], this.paramNameToObj.get(srFParams[i][j].getName()));
                }
            }
        }
        return result;
    }

    public void setupSubReportParamMap() {
        IReport[] subreports = this.getSubReportArray(true);
        if (subreports != null && subreports.length > 0) {
            this.setupSubReportParamMap(subreports);
        }
    }

    public void setupSubReportParamMap(IReport[] subreports) {
        Report subreport;
        int j;
        Hashtable<String, Parameter[]> table;
        SubReportObject[] subObjs = new SubReportObject[this.subReports.size()];
        for (int i = 0; i < this.subReports.size(); ++i) {
            subObjs[i] = this.subReports.elementAt(i);
        }
        try {
            table = new Hashtable<String, Parameter[]>();
            for (j = 0; subreports != null && j < subreports.length; ++j) {
                subreport = (Report)subreports[j];
                if (subreport == null) continue;
                String[] paramMap = subObjs[j].getParameterMap();
                String reportName = subObjs[j].getParamShareReportID();
                Vector<Parameter> queryParam = subreport.getQueryParameters();
                Vector<Parameter> params = new Vector<Parameter>();
                for (int i = 0; i < queryParam.size(); ++i) {
                    Parameter param = queryParam.elementAt(i);
                    param.setQueryFileInfo((IQueryFileInfo)((Object)subreport.dbInfo));
                    param.setReport(subreport);
                    param.setReportTitle("Sub_Report_" + (j + 1));
                    if (param.isShared() || paramMap != null && paramMap.length > i && paramMap[i] != null) continue;
                    params.addElement(param);
                }
                Parameter[] paramArray = new Parameter[params.size()];
                if (this.subQueryParamTable == null) {
                    for (int i = 0; i < params.size(); ++i) {
                        paramArray[i] = new Parameter();
                        paramArray[i].copy((Parameter)params.elementAt(i));
                    }
                } else {
                    Parameter[] oldParamArray = this.subQueryParamTable.get(reportName);
                    for (int i = 0; i < params.size(); ++i) {
                        paramArray[i] = new Parameter();
                        Parameter p = (Parameter)params.elementAt(i);
                        paramArray[i].copy(p);
                        if (oldParamArray == null || oldParamArray.length != paramArray.length || !oldParamArray[i].getName().equals(p.getName())) continue;
                        if (p.isMultiValueParam()) {
                            paramArray[i].setValues(oldParamArray[i].getValues());
                            continue;
                        }
                        paramArray[i].setValue(oldParamArray[i].getValue());
                    }
                }
                table.put(reportName, paramArray);
            }
            this.subQueryParamTable = table;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to set up sub-report mapping: 1", ex);
        }
        try {
            table = new Hashtable();
            for (j = 0; subreports != null && j < subreports.length; ++j) {
                subreport = (Report)subreports[j];
                if (subreport == null) continue;
                String reportName = subObjs[j].getParamShareReportID();
                Vector<Parameter> formulaParam = subreport.getFormulaParameters();
                Vector<Parameter> params = new Vector<Parameter>();
                for (int i = 0; i < formulaParam.size(); ++i) {
                    Parameter param = formulaParam.elementAt(i);
                    param.setReport(subreport);
                    param.setReportTitle("Sub_Report_" + (j + 1));
                    if (param.isShared()) continue;
                    params.addElement(param);
                }
                Parameter[] paramArray = new Parameter[params.size()];
                for (int i = 0; i < params.size(); ++i) {
                    paramArray[i] = (Parameter)params.elementAt(i);
                }
                table.put(reportName, paramArray);
            }
            this.subFormulaParamTable = table;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to set up sub-report mapping: 2", ex);
        }
    }

    public SubReportObject[] getSubReports() {
        Vector sreports = new Vector();
        QbUtil.addArrayToVector(sreports, this.getPageHeader().getSubReports());
        QbUtil.addArrayToVector(sreports, this.getReportHeader().getSubReports());
        QbUtil.addArrayToVector(sreports, this.getReportFooter().getSubReports());
        QbUtil.addArrayToVector(sreports, this.getPageFooter().getSubReports());
        try {
            this.formatTable();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to format table", e);
        }
        Vector<ReportTable> reportTables = this.getReportTables();
        for (int i = 0; reportTables != null && i < reportTables.size(); ++i) {
            ReportTable tbl = reportTables.elementAt(i);
            QbUtil.addArrayToVector(sreports, tbl.getAllSubReports());
        }
        SubReportObject[] temp = new SubReportObject[sreports.size()];
        for (int i = 0; i < sreports.size(); ++i) {
            temp[i] = (SubReportObject)sreports.elementAt(i);
        }
        return temp;
    }

    public void setDrawBeforeExport(boolean state) {
        this.drawBeforeDisplay = state;
    }

    private void addFormulas(Vector<Formula> _formulas) {
        for (int i = 0; i < _formulas.size(); ++i) {
            Formula f = _formulas.elementAt(i);
            if (this.formulaExists(f.getName())) continue;
            this.formulas.addElement(f);
        }
    }

    private void addScripts(Vector<Script> _scripts) {
        for (int i = 0; i < _scripts.size(); ++i) {
            Script s = _scripts.elementAt(i);
            if (this.scriptExists(s.getName())) continue;
            this.scripts.addElement(s);
        }
    }

    public void setPackedSubReportByteArray(Vector<SubReportObject> subReports) {
        if (subReports == null || subReports.size() == 0) {
            return;
        }
        this.getReportHeader().setPackedSubReportByteArray(this.subFilesTable, subReports);
        this.getPageHeader().setPackedSubReportByteArray(this.subFilesTable, subReports);
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.setPackedSubReportByteArray(this.subFilesTable, subReports);
        }
        this.getReportFooter().setPackedSubReportByteArray(this.subFilesTable, subReports);
        this.getPageFooter().setPackedSubReportByteArray(this.subFilesTable, subReports);
    }

    public void applyStyle(Report reportStyle) {
        this.getReportHeader().applyStyle(reportStyle.getSetting(), reportStyle.getReportHeader());
        this.getPageHeader().applyStyle(reportStyle.getSetting(), reportStyle.getPageHeader());
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.applyStyle(reportStyle.getSetting(), reportStyle.getReportTables().elementAt(i));
        }
        this.getReportFooter().applyStyle(reportStyle.getSetting(), reportStyle.getReportFooter());
        this.getPageFooter().applyStyle(reportStyle.getSetting(), reportStyle.getPageFooter());
        this.setBackgroundColor(reportStyle.getBackgroundColor());
        this.setBackgroundImage(reportStyle.getBackgroundImage());
    }

    public void applyStyle(String styleFile) throws Exception {
        LoadReportStyle lrs = new LoadReportStyle();
        Report reportStyle = lrs.loadReportFromFile(styleFile);
        this.getReportHeader().applyStyle(reportStyle.getSetting(), reportStyle.getReportHeader());
        this.getPageHeader().applyStyle(reportStyle.getSetting(), reportStyle.getPageHeader());
        for (int i = 0; i < this.reportTables.size(); ++i) {
            ReportTable table = this.reportTables.elementAt(i);
            table.applyStyle(reportStyle.getSetting(), reportStyle.getReportTables().elementAt(i));
        }
        this.getReportFooter().applyStyle(reportStyle.getSetting(), reportStyle.getReportFooter());
        this.getPageFooter().applyStyle(reportStyle.getSetting(), reportStyle.getPageFooter());
    }

    public void deleteSubReportColData() {
        int i;
        this.pageHeader.deleteSubReportColData();
        this.reportHeader.deleteSubReportColData();
        this.reportFooter.deleteSubReportColData();
        this.pageFooter.deleteSubReportColData();
        for (i = 0; i < this.reportTables.size(); ++i) {
            ReportTable tbl = this.reportTables.elementAt(i);
            tbl.deleteSubReportColData();
        }
        if (this.subReports != null) {
            for (i = 0; i < this.subReports.size(); ++i) {
                SubReportObject sr = this.subReports.elementAt(i);
                sr.refreshColData();
            }
        }
    }

    public void deleteSubReportColDataFiles() {
        if (this.subReports != null) {
            for (int i = 0; i < this.subReports.size(); ++i) {
                SubReportObject sr = this.subReports.elementAt(i);
                sr.deleteSubReportColDataFiles();
            }
        }
    }

    public Connection getDrillDownConnection() {
        return this.drillDownConn;
    }

    public void setDrillDownConnection(Connection conn) {
        this.drillDownConn = conn;
    }

    public String[] getDrillDownDatabaseInfo() {
        return this.databaseInfo;
    }

    public void setDrillDownDatabaseInfo(String[] info) {
        this.databaseInfo = info;
    }

    public int getMaxParameterOrder() {
        int max = this.getParametersInSequence().getOrderCount();
        if (max == 0) {
            return 0;
        }
        return max - 1;
    }

    public int[] getOrderOffset() {
        return this.order_offset;
    }

    public void setOrderOffset(int[] offset) {
        this.order_offset = offset;
    }

    public void resetSourceData() {
        if (this.sourceData == 0 && this.originalSourceData != -1) {
            this.sourceData = this.originalSourceData;
            this.originalSourceData = -1;
        }
    }

    public String getHTMLTarget() {
        return this.HTMLTarget;
    }

    public void setHTMLTarget(String target) {
        this.HTMLTarget = target;
    }

    public boolean hasSameDataSource(Report report) {
        if (this.sourceData != report.sourceData) {
            return false;
        }
        if (this.sourceData == 1) {
            return this.dbInfo.equals(report.dbInfo, false);
        }
        if (this.sourceData == 2) {
            return this.sourceFile.equals(report.sourceFile);
        }
        if (this.sourceData == 6) {
            return this.sourceFile.equals(report.sourceFile);
        }
        if (this.sourceData == 4) {
            return this.sourceFile.equals(report.sourceFile);
        }
        if (this.sourceData == 7) {
            ((QueryXMLFileInfo)this.queryFileInfo).getXMLFileQueryInfo().getFileName().equals(((QueryXMLFileInfo)report.queryFileInfo).getXMLFileQueryInfo().getFileName());
        }
        return false;
    }

    public FileInMemTable getSubFilesTable() {
        return this.subFilesTable;
    }

    public void setSubFilesTable(FileInMemTable subTbl) {
        this.subFilesTable = subTbl;
    }

    public ByteArrayInputStream getSubFileStream(String fileName) {
        return Report.getSubFileStream(this.subFilesTable, fileName);
    }

    public void mergeSubFilesTable(FileInMemTable tbl) {
        if (tbl == null) {
            return;
        }
        boolean memState = tbl.isFileInMemEnabled();
        tbl.setFileInMemEnabled(true);
        this.subFilesTable.setFileInMemEnabled(true);
        Enumeration e = this.subFilesTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            byte[] value = this.subFilesTable.get(key);
            tbl.put(key, value);
        }
        tbl.setFileInMemEnabled(memState);
        this.subFilesTable = tbl;
        this.subFilesTable.setTopName(tbl.getTopName());
    }

    public OrderedParameterSet getParametersInSequence(DrillDownNode ddnode) {
        try {
            MergeParameters mp = new MergeParameters(this, ddnode);
            return mp.getParametersInSequence();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to get parameters in sequence", e);
            return null;
        }
    }

    public OrderedParameterSet getParametersInSequence() {
        return this.getParametersInSequence(this.currentNode, false);
    }

    public OrderedParameterSet getParametersInSequence(int order) {
        return this.getParametersInSequence(order, this.currentNode, false);
    }

    public OrderedParameterSet getParametersInSequence(int order, DrillDownNode ddnode, boolean ignoreSubreports) {
        try {
            MergeParameters mp = new MergeParameters(this, ddnode, ignoreSubreports);
            return mp.getParametersInSequence(order);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to get parameters in sequence", e);
            return null;
        }
    }

    public OrderedParameterSet getParametersInSequence(boolean ignoreSubreports) {
        return this.getParametersInSequence(this.currentNode, ignoreSubreports);
    }

    public OrderedParameterSet getParametersInSequence(DrillDownNode ddnode, boolean ignoreSubreports) {
        try {
            MergeParameters mp = new MergeParameters(this, ddnode, ignoreSubreports);
            mp.fixSharedParamReferences();
            return mp.getParametersInSequence();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to get parameters in sequence", e);
            return null;
        }
    }

    public ReportChartObject[] getReportChartObjects() {
        Vector charts = new Vector();
        QbUtil.addArrayToVector(charts, this.getPageHeader().getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.getReportHeader().getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.getReportFooter().getReportChartObjects());
        QbUtil.addArrayToVector(charts, this.getPageFooter().getReportChartObjects());
        if (this.getReportTables().size() > 0) {
            try {
                this.getReportTables().elementAt(0).formatTable();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to format table", e);
            }
        }
        Vector<ReportTable> reportTables = this.getReportTables();
        for (int i = 0; reportTables != null && i < reportTables.size(); ++i) {
            ReportTable tbl = reportTables.elementAt(i);
            QbUtil.addArrayToVector(charts, tbl.getAllReportChartObjects());
        }
        ReportChartObject[] temp = new ReportChartObject[charts.size()];
        for (int i = 0; i < charts.size(); ++i) {
            temp[i] = (ReportChartObject)charts.elementAt(i);
        }
        return temp;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String fn) {
        this.filename = fn;
    }

    private void clearTriggeredAlerts() {
        if (this.triggeredAlerts != null) {
            this.triggeredAlerts.clear();
        }
    }

    public void addTriggeredAlert(ReportAlertObject alert) {
        if (this.triggeredAlerts == null) {
            this.triggeredAlerts = Collections.synchronizedSet(new HashSet());
        }
        this.triggeredAlerts.add(alert);
    }

    public void addTriggeredAlerts(Vector<ReportAlertObject> alerts, String subReportName) {
        if (alerts == null) {
            return;
        }
        if (this.triggeredAlerts == null) {
            this.triggeredAlerts = Collections.synchronizedSet(new HashSet());
        }
        for (int i = 0; i < alerts.size(); ++i) {
            ReportAlertObject rao = alerts.get(i);
            if (subReportName != null) {
                rao.setFileName(subReportName);
            }
            this.triggeredAlerts.add(rao);
        }
    }

    public void addTriggeredAlerts(Map alertDetails, String chartName) {
        Object[] alerts;
        if (alertDetails == null) {
            return;
        }
        if (this.triggeredAlerts == null) {
            this.triggeredAlerts = Collections.synchronizedSet(new HashSet());
        }
        for (Object alert : alerts = alertDetails.keySet().toArray()) {
            ReportAlertObject rao = new ReportAlertObject(null, (String)alert, (Vector)alertDetails.get(alert), chartName, true);
            this.triggeredAlerts.add(rao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ReportAlertObject> getTriggeredAlerts() {
        Vector<ReportAlertObject> temp = new Vector<ReportAlertObject>();
        if (this.triggeredAlerts == null || this.triggeredAlerts.size() == 0) {
            return null;
        }
        Set<ReportAlertObject> set = this.triggeredAlerts;
        synchronized (set) {
            temp.addAll(this.triggeredAlerts);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getTriggeredAlertIds() {
        if (this.triggeredAlerts == null || this.triggeredAlerts.size() == 0) {
            return null;
        }
        HashSet<String> temp = new HashSet<String>();
        Set<ReportAlertObject> set = this.triggeredAlerts;
        synchronized (set) {
            for (ReportAlertObject rao : this.triggeredAlerts) {
                temp.add(rao.getAlertName());
            }
        }
        String[] results = temp.toArray(new String[temp.size()]);
        if (results.length == 0) {
            return null;
        }
        return results;
    }

    @Override
    public Map<String, Vector<String>> getTriggeredAlertDetails() {
        Vector<ReportAlertObject> alerts = this.getTriggeredAlerts();
        if (alerts == null) {
            return null;
        }
        HashMap<String, Vector<String>> result = new HashMap<String, Vector<String>>(alerts.size());
        for (int i = 0; i < alerts.size(); ++i) {
            ReportAlertObject rao = alerts.get(i);
            result.put(rao.getAlertName(), rao.getDesc());
        }
        return result;
    }

    @Override
    public String[] getAllAlertIds() {
        String[] results;
        Vector<ReportChartObject> charts;
        HashSet<String> ids = new HashSet<String>();
        if (this.scripts != null) {
            for (int i = 0; i < this.scripts.size(); ++i) {
                Script script = this.scripts.get(i);
                Vector stmts = script.getStatements();
                Report.extractAlertIds(stmts, ids);
            }
        }
        if ((charts = this.getAllCharts()) != null) {
            for (int i = 0; i < charts.size(); ++i) {
                try {
                    ReportChartObject rco = charts.get(i);
                    Chart c = rco.getChartObject().setNewData(null);
                    String[] chartAlerts = c.getAllAlertIds();
                    if (chartAlerts == null) {
                        rco.setChart(null);
                        continue;
                    }
                    for (int j = 0; j < chartAlerts.length; ++j) {
                        chartAlerts[j] = new File(rco.getText()).getName() + ReportAlertObject.separator + chartAlerts[j];
                    }
                    ids.addAll(Arrays.asList(chartAlerts));
                    rco.setChart(null);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINER, "Failed to get all charts", e);
                }
            }
        }
        if (this.subReportArray != null) {
            for (Report element : this.subReportArray) {
                String[] subAlerts = element.getAllAlertIds();
                if (subAlerts == null) continue;
                for (int j = 0; j < subAlerts.length; ++j) {
                    subAlerts[j] = element.getFileNameWithoutPath() + ReportAlertObject.separator + subAlerts[j];
                }
                ids.addAll(Arrays.asList(subAlerts));
            }
        }
        if ((results = ids.toArray(new String[ids.size()])).length == 0) {
            return null;
        }
        return results;
    }

    public String getFileNameWithoutPath() {
        String filename = this.getFileName();
        if (filename == null) {
            filename = this.currentNode.getFileName(this.subFilesTable);
        }
        return new File(filename).getName();
    }

    public String getFileNameWithoutExtension() {
        return this.getFileNameWithoutPath().replaceFirst("[.][^.]+$", "");
    }

    public boolean isKeepDataSourceOrder() {
        return this.keepDataSourceOrder;
    }

    public void setKeepDataSourceOrder(boolean keepDataSourceOrder) {
        this.keepDataSourceOrder = keepDataSourceOrder;
    }

    public boolean isSubReport() {
        return this.parentNode != null;
    }

    public boolean isRootReport() {
        return this.rootNode == null && !this.isSubReport() && this.currentNode != null && this.currentNode.parent == null;
    }

    public boolean isDrillDownReport() {
        return !this.isSubReport() && !this.isRootReport();
    }

    public PaginationSettings getPaginationSettings() {
        return this.paginationSettings;
    }

    public void setPaginationSettings(PaginationSettings paginationSettings) {
        this.paginationSettings = paginationSettings;
    }

    public String getEasyReportStyle() {
        return this.easyReportStyle;
    }

    public void setEasyReportStyle(String easyReportStyle) {
        this.easyReportStyle = easyReportStyle;
    }
}

