/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.IQbGraphics;
import quadbase.common.util.internal.Java2DUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.CBAggrColumn;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.ImageMapNode;
import quadbase.reportdesigner.report.PageBufferGraphics;
import quadbase.reportdesigner.report.RTFUI;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.SubReportUI;
import quadbase.reportdesigner.report.TableOfContentsUI;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.Dimension2D;
import quadbase.reportdesigner.util.internal.BarcodeUtil;
import quadbase.reportdesigner.util.internal.ImageData;
import quadbase.reportdesigner.util.rtf.RTFUtil;

public class ReportGraphics {
    private static final Logger LOGGER = Logger.getLogger(ReportGraphics.class.getName());
    protected Graphics g;
    protected Graphics textG;
    protected double pageX;
    protected double pageY;
    protected double pageW;
    protected double pageH;
    protected double curX = 0.0;
    protected double curY = 0.0;
    private double maxH = -1.0;
    private double subReportStartY = -1.0;
    protected ReportUI reportUI;
    private ReportUI parentReportUI;
    private static final Font NOTE_FONT = new Font("Dialog", 0, 8);
    private int additionalOffset = 0;
    private double lineHeight = 1.0;
    private double charWidthMultiplier = 1.0;
    boolean drawingSubReport = false;
    boolean printMode = false;

    public ReportGraphics(Graphics g) {
        this.g = g;
    }

    public ReportGraphics(ReportUI repUI, Graphics textG) {
        this.reportUI = repUI;
        this.textG = textG;
    }

    public ReportGraphics(ReportUI repUI, Graphics g, double cX, double cY, double x, double y, double w, double h) {
        this(repUI, g);
        this.g = g;
        this.setCurrentPosition(cX, cY);
        this.setDrawablePageSection(x, y, w, h);
    }

    void setDrawablePageSection(double x, double y, double w, double h) {
        this.pageX = x;
        this.pageY = y;
        this.pageW = w;
        this.pageH = h;
    }

    void setCurrentPosition(double curX, double curY) {
        this.curX = curX;
        this.curY = curY;
    }

    void drawEvalStatement() throws Exception {
        String text = "Evaluation copy by Quadbase Systems Inc.";
        Font font = FontTable.newFont("Arial", 1, QbUtil.getAdjustedFont(16, this.reportUI.report.isAdjustFont()));
        this.setColor(IOUtil.getRandomColor());
        this.g.setFont(font);
        this.drawText(text, font, this.toPixel(this.pageX), this.toPixel(this.pageY), this.toPixel(this.reportUI.report.getPageWidth()), this.toPixel(1.0), (short)0, (short)1, false, false);
        this.setColor(IOUtil.getRandomColor());
        text = "Please contact sales@quadbase.com for purchasing information.";
        this.drawText(text, font, this.toPixel(this.pageX), this.toPixel(this.reportUI.report.getPageHeight() - 1.0), this.toPixel(this.reportUI.report.getPageWidth()), this.toPixel(1.0), (short)0, (short)1, false, false);
    }

    public void incCurY(double y) {
        this.curY += y;
    }

    boolean isDrawEnabled(double y) {
        return this.g != null && y >= this.pageY - 1.0E-4 && y < this.pageH + this.pageY - 1.0E-4;
    }

    boolean chopOffTable(double y, double h) {
        if (this.maxH == -1.0) {
            return false;
        }
        return y + h >= this.subReportStartY + this.maxH;
    }

    Dimension2D getDimension(double x, double y, double w, double h) {
        if (this.chopOffTable(y, h)) {
            return null;
        }
        if (!this.isDrawEnabled(y)) {
            return null;
        }
        if (x >= this.pageX && x < this.pageW + this.pageX - 0.001 && x + w <= this.pageW + this.pageX + 0.001) {
            double wShift = x - this.pageX;
            double hShift = 0.0;
            if (y != 0.0 && this.pageH != 0.0) {
                hShift = y % this.pageH;
            }
            if (Math.abs(wShift - this.pageW) < 0.001) {
                wShift = 0.0;
            }
            if (Math.abs(hShift - this.pageH) < 0.001) {
                hShift = 0.0;
            }
            return new Dimension2D(wShift + this.curX, hShift + this.curY);
        }
        return null;
    }

    void done() {
    }

    public void setColor(Color c) {
        if (this.g != null) {
            this.g.setColor(c);
        }
    }

    public void fillRect(double x, double y, double w, double h) {
        if (this.g == null) {
            return;
        }
        Dimension2D dim = this.getDimension(x, y, w, h);
        if (dim == null) {
            return;
        }
        int rX = this.toPixel(dim.getWidth());
        int rY = this.toPixel(dim.getHeight());
        int rW = this.toPixel(w + dim.getWidth()) - rX;
        int rH = this.toPixel(h + dim.getHeight()) - rY;
        this.g.fillRect(rX, rY, rW, rH);
    }

    public void fillRect(double x, double y, double w, double h, Color c) {
        if (this.g == null) {
            return;
        }
        Dimension2D dim = this.getDimension(x, y, w, h);
        if (dim == null) {
            return;
        }
        this.g.setColor(c);
        int rX = this.toPixel(dim.getWidth());
        int rY = this.toPixel(dim.getHeight());
        int rW = this.toPixel(w + dim.getWidth()) - rX;
        int rH = this.toPixel(h + dim.getHeight()) - rY;
        this.g.fillRect(rX, rY, rW, rH);
    }

    protected double[] drawCell(Report report, ReportTable tbl, ReportCell[] cells, ReportElement cell, double x, double y) throws Exception {
        return this.drawCell(report, tbl, cells, cell, tbl, x, y, 0);
    }

    protected double[] drawCell(Report report, ReportTable tbl, ReportCell[] cells, ReportElement cell, ReportTableElement panel, double x, double y) throws Exception {
        return this.drawCell(report, tbl, cells, cell, panel, x, y, 0);
    }

    double[] drawCell(Report report, ReportTable tbl, ReportCell[] cells, ReportElement cell, double x, double y, int row) throws Exception {
        return this.drawCell(report, tbl, cells, cell, tbl, x, y, row);
    }

    public double[] drawCell(Report report, ReportTable tbl, ReportCell[] cells, ReportElement cell, ReportTableElement panel, double x, double y, int row) throws Exception {
        int drillIndex;
        String drillUserObject;
        String drillFileName;
        byte[] drillByteArray;
        int[] mapping;
        Dimension2D dim;
        block44: {
            if (cell == null) {
                return null;
            }
            if (cell instanceof ReportCell && !((ReportCell)cell).isVisible()) {
                return null;
            }
            dim = this.getDimension(x, y, cell.getWidth(), cell.getHeight());
            if (cell instanceof TableOfContents) {
                if (report.isTocEnabled()) {
                    return this.drawTableOfContents((TableOfContents)cell, x, y);
                }
                return null;
            }
            if (cell instanceof SubReportObject) {
                return this.drawSubReport((SubReportObject)cell, x, y, tbl);
            }
            if (cell instanceof ReportRTFObject && (cell.isResizeToFitContent() || this.g != null)) {
                return this.drawRTF((ReportRTFObject)cell, x, y, tbl);
            }
            if (this.g == null) {
                return null;
            }
            if (dim == null) {
                return null;
            }
            mapping = null;
            Report drillReport = null;
            drillByteArray = null;
            drillFileName = null;
            String parentFileName = null;
            drillUserObject = null;
            drillIndex = -1;
            LOGGER.finest("cell.getText=" + cell.getText());
            if (this.reportUI.isImageMapEnabled()) {
                if (cell.getDrillDownName() != null) {
                    LOGGER.finest("cell.getDrillDownName=" + cell.getDrillDownName());
                    try {
                        LOGGER.finest("ReportGraphics CP1");
                        DrillDownNode node = null;
                        DrillDownNode parentNode = this.reportUI.report.currentNode;
                        for (int i = 0; i < parentNode.getChildCount(); ++i) {
                            LOGGER.finest("childNode: " + parentNode.getChildAt(i).getName());
                            if (!cell.getDrillDownName().equals(parentNode.getChildAt(i).getName())) continue;
                            node = parentNode.getChildAt(i);
                            i = parentNode.getChildCount();
                        }
                        LOGGER.finest("node=" + node);
                        if (node == null) {
                            this.drawCell(cell, dim);
                            double[] d = new double[2];
                            return d;
                        }
                        mapping = node.getColumnMapping();
                        if (node.getDrillDownReport() != null) {
                            drillReport = node.getDrillDownReport().getReportObj();
                        }
                        drillByteArray = node.getByteArray();
                        drillFileName = node.getFileName(report.getSubFilesTable());
                        parentFileName = parentNode.getFileName(report.getSubFilesTable());
                        drillUserObject = node.getUserObject();
                        drillIndex = parentNode.getIndex(node);
                        if (cell instanceof ReportChartObject) break block44;
                        Boolean addImageMap = true;
                        ReportTable tempTable = tbl;
                        while (tempTable instanceof ReportTreeTable) {
                            tempTable = ((ReportTreeTable)tempTable).getSubTable(0);
                        }
                        Object[] values = new Object[mapping.length];
                        for (int i = 0; i < mapping.length; ++i) {
                            block45: {
                                if (mapping[i] < 0) {
                                    values[i] = "UnMapped";
                                } else if (mapping[i] >= 1000 && mapping[i] < 2000) {
                                    values[i] = report.getQueryParameters().elementAt(mapping[i] - 1000).getValue();
                                } else if (mapping[i] >= 2000) {
                                    values[i] = report.getFormulaParameters().elementAt(mapping[i] - 2000).getValue();
                                } else if (node.isCrossTabDrillDown()) {
                                    if (report.colInfo[mapping[i]].isColumnBreak() && ((ReportCell)cell).getColumn() instanceof ColumnBreakColumn) {
                                        for (ColData element : report.colData) {
                                            if (!report.colInfo[mapping[i]].getName().equals(element.getName())) continue;
                                            for (int n = 0; n < element.getSize(); ++n) {
                                                if (!element.getData(n).toString().equalsIgnoreCase(((ColumnBreakColumn)((ReportCell)cell).getColumn()).getText(report, mapping[i]).toString())) continue;
                                                values[i] = element.getData(n);
                                                break block45;
                                            }
                                            break;
                                        }
                                    } else if (((ReportCell)cell).getColumn() instanceof CBAggrColumn || report.getColumnType(report.getColInfoIndex(((ReportCell)cell).getColumn())).equalsIgnoreCase("ROW BREAK")) {
                                        values[i] = "";
                                        addImageMap = false;
                                    } else {
                                        values[i] = tempTable.getColumn(report.getColumnIndex(mapping[i])).getData(0);
                                    }
                                } else {
                                    values[i] = tempTable.getColumn(report.getColumnIndex(mapping[i])).getDrillDownData(row);
                                }
                            }
                            if (values[i] != null) continue;
                            throw new Exception("No data available for drill-down.");
                        }
                        if (addImageMap.booleanValue()) {
                            this.reportUI.getImageMap().addElement(new ImageMapNode(new Rectangle(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight())), drillReport, drillByteArray, drillFileName, drillUserObject, values, drillIndex, parentFileName));
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Error drawing cell", e);
                    }
                } else if (!cell.getLink().equals("")) {
                    this.reportUI.getImageMap().addElement(new ImageMapNode((Object)new Rectangle(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight())), cell.getLink(), cell.getTarget(), cell.getHint()));
                } else if (((ReportCell)cell).getEntry() != null) {
                    this.reportUI.getImageMap().addElement(new ImageMapNode((Object)new Rectangle(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight())), ((ReportCell)cell).getEntry().getPageNumber(), ((ReportCell)cell).getEntry().getSection(), ((ReportCell)cell).getEntry().getYPos()));
                }
            }
        }
        if (cell instanceof ReportChartObject && IOUtil.isChartPackageExisted()) {
            this.drawChart(report, tbl, cells, cell, dim, mapping, drillByteArray, drillFileName, drillUserObject, drillIndex);
        } else if (cell instanceof ReportLine) {
            this.drawLine((ReportLine)cell, dim, ((ReportLine)cell).getLineStyle(), ((ReportLine)cell).isVertical(), panel);
        } else if (cell instanceof ReportGrid) {
            this.drawGrid((ReportGrid)cell, dim, ((ReportGrid)cell).getGridStyle(), panel);
        } else if (cell instanceof ReportImage) {
            this.drawImage(report.getSubFilesTable(), (ReportImage)cell, dim);
        } else {
            this.drawCell(cell, dim);
        }
        double[] d = new double[2];
        return d;
    }

    private void drawChart(Report report, ReportTable tbl, ReportCell[] cells, ReportElement cell, Dimension2D dim, int[] mapping, byte[] drillByteArray, String drillFileName, String drillUserObject, int drillIndex) throws Exception {
        int xOffset = this.toPixel(dim.getWidth());
        int yOffset = this.toPixel(dim.getHeight());
        this.g.translate(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()));
        try {
            Vector imageMap = null;
            if (this.reportUI.isImageMapEnabled()) {
                imageMap = this.reportUI.getImageMap();
            }
            ChartObject.draw(this.g, report, tbl, cells, (ReportChartObject)cell, this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight()), imageMap, xOffset, yOffset, mapping, drillByteArray, drillFileName, drillUserObject, drillIndex, "");
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to draw chart object", ex);
            this.g.translate(-xOffset, -yOffset);
            this.drawCell(cell, dim);
            return;
        }
        this.g.translate(-this.toPixel(dim.getWidth()), -this.toPixel(dim.getHeight()));
        if (cell.getBorderColor() != null) {
            this.setColor(cell.getBorderColor());
            int rX = this.toPixel(dim.getWidth());
            int rY = this.toPixel(dim.getHeight());
            int rW = this.toPixel(cell.getWidth() + dim.getWidth()) - rX;
            int rH = this.toPixel(cell.getHeight() + dim.getHeight()) - rY;
            this.drawRect(rX, rY, rW, rH, cell.getBorderThickness());
        }
        this.drawDashLineCellBorder(cell, dim);
    }

    static boolean isImageInMemory(FileInMemTable subFilesTable, URL imageURL) {
        byte[] obj;
        String tmp = ReportGraphics.getFilePath(imageURL);
        return subFilesTable != null && (obj = subFilesTable.get(ServerMessage.getPath(tmp))) != null;
    }

    static String getFilePath(URL imageURL) {
        String tmp = imageURL.getFile();
        while (tmp.startsWith("\\") || tmp.startsWith("/")) {
            tmp = tmp.substring(1);
        }
        return tmp;
    }

    protected void drawImage(FileInMemTable subFilesTable, ReportImage cell, Dimension2D dim) throws Exception {
        if (cell.getBgColor() != null) {
            this.setColor(cell.getBgColor());
            this.g.fillRect(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight()));
        }
        boolean isImageInMemory = false;
        if (!cell.isDBImage() && cell.getBytes() == null && !(isImageInMemory = ReportGraphics.isImageInMemory(subFilesTable, cell.getImageURL()))) {
            new ImageData(cell.getImageURL(), 1).draw(this.g, this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight()), ServerMessage.getComponent());
        } else {
            byte[] ba;
            block11: {
                int length;
                ReadDataFile rdf;
                ba = null;
                DataInputStream dis = null;
                try {
                    String ifilename = null;
                    ifilename = cell.isDBImage() ? cell.getRelativePath() : (cell.getImageURL().toString().startsWith("file:") ? cell.getImageURL().getFile() : cell.getImageURL().toString());
                    if (ifilename != null) {
                        ifilename = QbUtil.fixUrlString(ifilename);
                    }
                    rdf = new ReadDataFile();
                    dis = rdf.getInputStream(subFilesTable, ifilename);
                    length = dis.available();
                    ba = new byte[length];
                    dis.read(ba, 0, length);
                    dis.close();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Report Preview: Image file not found", ex);
                    if (cell.getBytes() != null) {
                        ba = cell.getBytes();
                    }
                    if (!isImageInMemory) break block11;
                    rdf = new ReadDataFile();
                    dis = rdf.getInputStream(subFilesTable, ReportGraphics.getFilePath(cell.getImageURL()));
                    length = dis.available();
                    ba = new byte[length];
                    dis.read(ba, 0, length);
                    dis.close();
                }
            }
            if (this.g instanceof IQbGraphics) {
                ((IQbGraphics)((Object)this.g)).drawImage(ba, 1, this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight()));
            } else {
                ImageData idata = new ImageData(new URL("http://temp"), 1);
                Image i = Toolkit.getDefaultToolkit().createImage(ba);
                idata.setImage(i);
                MediaTracker tracker = new MediaTracker(ServerMessage.getComponent());
                tracker.addImage(i, 0);
                tracker.waitForID(0);
                if (tracker.isErrorID(0)) {
                    return;
                }
                idata.draw(this.g, this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight()), ServerMessage.getComponent());
            }
        }
        if (cell.getBorderColor() != null) {
            this.setColor(cell.getBorderColor());
            int rX = this.toPixel(dim.getWidth());
            int rY = this.toPixel(dim.getHeight());
            int rW = this.toPixel(cell.getWidth() + dim.getWidth()) - rX;
            int rH = this.toPixel(cell.getHeight() + dim.getHeight()) - rY;
            this.drawRect(rX, rY, rW, rH, cell.getBorderThickness());
        }
        this.drawDashLineCellBorder(cell, dim);
    }

    private void drawLine(ReportLine cell, Dimension2D dim, int lineStyle, boolean isVertical, ReportTableElement panel) throws Exception {
        int style = lineStyle;
        this.setColor(cell.getBgColor());
        double width_inch = cell.getWidth();
        double height_inch = cell.getHeight();
        if (isVertical && width_inch > 0.02) {
            width_inch -= 0.02;
        } else if (height_inch > 0.02) {
            height_inch -= 0.02;
        }
        int width = this.toPixel(width_inch);
        int height = this.toPixel(height_inch);
        if (cell.getHeight() < 0.0) {
            ReportLine headNode = cell.getHeadNode();
            height = headNode == cell ? this.toPixel(panel.getHeight() - cell.getY()) : this.toPixel(panel.getHeight());
        }
        if (cell.getBgColor() != null) {
            if (style == 2) {
                this.g.fillRect(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), width, height);
                if (!isVertical) {
                    this.g.fillRect(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()) + 2 * height, width, height);
                } else {
                    this.g.fillRect(this.toPixel(dim.getWidth()) + 2 * width, this.toPixel(dim.getHeight()), width, height);
                }
            }
            if (style == 3) {
                this.drawDashLines(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), width, height, isVertical);
            } else {
                this.g.fillRect(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), width, height);
            }
        }
    }

    private void drawGrid(ReportGrid cell, Dimension2D dim, int gridStyle, ReportTableElement panel) throws Exception {
        this.drawCell(cell, dim, gridStyle, panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] drawRTF(ReportRTFObject rtfobject, double x, double y, ReportTable tbl) throws Exception {
        double old_pageX = this.pageX;
        double old_pageY = this.pageY;
        double old_pageW = this.pageW;
        double old_pageH = this.pageH;
        double old_curX = this.curX;
        double old_curY = this.curY;
        double[] ret = new double[2];
        try {
            Vector<Vector<Object[]>> lines = this.breakRichText(rtfobject, this.reportUI.report, tbl, this.toPixel(rtfobject.getColumnWidth()), false);
            double pageHeight = -1.0;
            if (this.pageW <= 0.0) {
                this.pageW = x + 1.0;
            }
            this.pageW = rtfobject.getWidth() + x % this.pageW;
            if (!rtfobject.isResizeToFitContent()) {
                pageHeight = rtfobject.getHeight();
            }
            RTFUI rtfUI = new RTFUI(rtfobject, lines, x, y, rtfobject.getWidth(), pageHeight, this.reportUI);
            rtfUI.report = this.reportUI.report;
            if (this instanceof PageBufferGraphics) {
                ((PageBufferGraphics)this).setReportUI(rtfUI);
            }
            rtfUI.draw(this);
            if (this instanceof PageBufferGraphics) {
                ((PageBufferGraphics)this).resetReportUI();
            }
            ret[0] = rtfUI.curY;
            ret[1] = rtfUI.pageTopY;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot draw RTF", ex);
        }
        finally {
            this.curX = old_curX;
            this.curY = old_curY;
            this.pageX = old_pageX;
            if (!(this instanceof PageBufferGraphics)) {
                this.pageY = old_pageY;
            }
            this.pageW = old_pageW;
            this.pageH = old_pageH;
        }
        return ret;
    }

    protected void drawCell(ReportElement cell, Dimension2D dim) throws Exception {
        this.drawCell(cell, dim, -1, null);
    }

    protected void drawCell(ReportElement cell, Dimension2D dim, int gridStyle, ReportTableElement panel) throws Exception {
        Color bgColor = cell.getBgColor();
        Color borderColor = cell.getBorderColor();
        int roundCornerRadius = cell.getRoundCornerRadius();
        boolean[] roundCornersArray = cell.getRoundCornersArray();
        boolean drawTop = true;
        boolean drawBottom = true;
        if (cell instanceof ReportGrid) {
            drawTop = ((ReportGrid)cell).previous() == null;
            boolean bl = drawBottom = ((ReportGrid)cell).next() == null;
            if (cell.getHeight() < 0.0 && panel != null) {
                ReportGrid headNode = ((ReportGrid)cell).getHeadNode();
                if (headNode == cell) {
                    cell.setHeight(panel.getHeight() - cell.getY());
                } else {
                    cell.setHeight(panel.getHeight());
                }
            }
        }
        int rX = this.toPixel(dim.getWidth());
        int rY = this.toPixel(dim.getHeight());
        int rW = this.toPixel(dim.getWidth() + cell.getWidth()) - rX;
        int rH = this.toPixel(dim.getHeight() + cell.getHeight()) - rY;
        float[] borderThickness = new float[]{cell.getTopBorder(), cell.getRightBorder(), cell.getBottomBorder(), cell.getLeftBorder()};
        if (this.g instanceof IQbGraphics) {
            IQbGraphics qbGraphics = (IQbGraphics)((Object)this.g);
            qbGraphics.drawCellWithRoundCornersBySegments(rX, rY, roundCornerRadius, roundCornersArray, rW, rH, borderColor, bgColor, gridStyle, drawTop, drawBottom, borderThickness);
        } else if (this.g instanceof Graphics2D) {
            Java2DUtil.drawCellWithRoundCornersBySegments((Graphics2D)this.g, rX, rY, roundCornerRadius, roundCornersArray, rW, rH, borderColor, bgColor, gridStyle, ReportElement.doesElementSupportRoundCorners(cell), drawTop, drawBottom, borderThickness);
        }
        if (!(((ReportCell)cell).getDataFormat() instanceof BarcodeFormat) || ((ReportCell)cell).getDataFormat() instanceof BarcodeFormat && !this.validBarcode(cell)) {
            if (cell.getFontColor() != null) {
                this.setColor(cell.getFontColor());
                this.drawText(cell.getText(), cell.getRefFontToDraw(this.reportUI.report.isAdjustFont()), rX, rY, this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight()), cell.getAlign(), cell.getVAlign(), cell.isNoWrap(), cell.isUnderline(), cell.getRotateAngle());
                if (this.reportUI.isDesignMode()) {
                    this.drawNote(cell, rX, rY);
                }
            }
        } else {
            this.drawBarcode(cell, new Dimension2D(rX, rY));
            if (this.reportUI.isDesignMode()) {
                this.drawNote(cell, rX, rY);
            }
        }
        this.drawDashLineCellBorder(cell, dim);
    }

    private double[] drawTableOfContents(TableOfContents toc, double x, double y) throws Exception {
        TableOfContentsUI tocUI;
        double curY;
        LOGGER.finest("drawTableOfContents");
        double[] res = new double[2];
        double pageHeight = -1.0;
        double pageWidth = toc.getWidth();
        if (!toc.isResizeToFitContent()) {
            pageHeight = toc.getHeight();
        }
        res[0] = (curY = (tocUI = new TableOfContentsUI(toc, x, y, pageWidth, pageHeight, this.reportUI)).draw(this)) > y + pageHeight ? curY : y + pageHeight;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] drawSubReport(SubReportObject subReport, double x, double y, ReportTable tbl) throws Exception {
        double old_pageX = this.pageX;
        double old_pageY = this.pageY;
        double old_pageW = this.pageW;
        double old_pageH = this.pageH;
        double old_curX = this.curX;
        double old_curY = this.curY;
        double[] ret = new double[2];
        try {
            Report sReport = null;
            if (subReport.hasUsableReport()) {
                sReport = subReport.getSubReport().getReportInfo();
                if (sReport.getQueryParams().size() != 0) {
                    sReport = subReport.reloadReportWithParameters(sReport, this.reportUI.report, tbl);
                } else if (sReport.dbInfo.getDriverName() != null) {
                    sReport = subReport.loadReport(this.reportUI.report, tbl);
                } else {
                    try {
                        Report temp = ReloadReport.reloadData(new Report(sReport), false);
                        if (temp != null) {
                            sReport = temp;
                        }
                    }
                    catch (Exception ex) {
                        sReport.getReportTables().elementAt(0).setVisible(false);
                        subReport.setHeight(0.0);
                        this.reportUI.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                    }
                }
            } else {
                sReport = subReport.loadReport(this.reportUI.report, tbl, true);
            }
            sReport.setSubFilesTable(this.reportUI.report.getSubFilesTable());
            sReport.setPreviewSecurityLevel(this.reportUI.report.getPreviewSecurityLevel());
            double pageHeight = -1.0;
            double pageWidth = -1.0;
            if (this.pageW <= 0.0) {
                this.pageW = x + 1.0;
            }
            if (!subReport.isResizeWidth() || this.reportUI.calculated) {
                pageWidth = subReport.getWidth();
                this.pageW = (subReport.getWidth() + x) % this.pageW;
            }
            if (!subReport.isResizeToFitContent()) {
                pageHeight = subReport.getHeight();
            }
            SubReportUI subReportUI = new SubReportUI(sReport, x, y, pageWidth, pageHeight, this.reportUI);
            if (this.reportUI.report.getPageHeader().containsSubReport(subReport)) {
                subReportUI.setDrawingSubReportInPageHeader(true);
            }
            this.drawingSubReport = true;
            if (this instanceof PageBufferGraphics) {
                ((PageBufferGraphics)this).setReportUI(subReportUI);
            }
            if (!subReport.isResizeToFitContent()) {
                this.maxH = pageHeight;
                this.subReportStartY = y;
            }
            this.setReportUI(subReportUI);
            subReportUI.draw(this);
            this.resetReportUI();
            this.reportUI.report.addTriggeredAlerts(sReport.getTriggeredAlerts(), subReportUI.report.getFileNameWithoutPath());
            this.maxH = -1.0;
            this.subReportStartY = -1.0;
            if (this instanceof PageBufferGraphics) {
                ((PageBufferGraphics)this).resetReportUI();
            }
            this.drawingSubReport = false;
            ret[0] = subReportUI.curY;
            ret[1] = subReportUI.shift;
            if (subReport.isResizeWidth()) {
                this.reportUI.maxX = subReportUI.maxX > this.reportUI.maxX ? subReportUI.maxX : this.reportUI.maxX;
                double temp = subReportUI.maxX - x;
                subReport.setWidth(Math.ceil(temp / sReport.gridStepSize) * sReport.gridStepSize);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot draw sub-report", ex);
        }
        finally {
            this.curX = old_curX;
            this.curY = old_curY;
            this.pageX = old_pageX;
            if (!(this instanceof PageBufferGraphics)) {
                this.pageY = old_pageY;
            }
            this.pageW = old_pageW;
            this.pageH = old_pageH;
            this.reportUI.report.setNullDataOption(this.reportUI.report.getNullDataOption(), true);
            this.drawingSubReport = false;
        }
        return ret;
    }

    void drawRect(int x, int y, int w, int h, int thickness) {
        for (int i = 0; i < thickness; ++i) {
            int dx = x - i;
            int dy = y - i;
            int dh = h + 2 * i;
            int dw = w + 2 * i;
            if (dx < 0) {
                dw += dx;
                dx = 0;
            }
            if (dy < 0) {
                dh += dy;
                dy = 0;
            }
            this.g.drawRect(dx, dy, dw, dh);
        }
    }

    private void drawDashRects(int x, int y, int w, int h, int thickness, boolean drawTop, boolean drawBottom) {
        for (int i = 0; i < thickness; ++i) {
            int dx = x - i;
            int dy = y - i;
            int dh = h + 2 * i;
            int dw = w + 2 * i;
            if (dx < 0) {
                dw += dx;
                dx = 0;
            }
            if (dy < 0) {
                dh += dy;
                dy = 0;
            }
            this.drawDashRect(dx, dy, dw, dh, drawTop, drawBottom);
        }
    }

    private void drawDashRect(int x, int y, int w, int h, boolean drawTop, boolean drawBottom) {
        int wSpan = w + x;
        int hSpan = h + y;
        int x0 = x;
        while (x < wSpan) {
            if (drawTop) {
                this.g.drawLine(x, y, x + 2, y);
            }
            if (drawBottom) {
                this.g.drawLine(x, y + h, x + 2, y + h);
            }
            x += 5;
        }
        x = x0;
        while (y < hSpan) {
            this.g.drawLine(x, y, x, y + 2);
            this.g.drawLine(x + w, y, x + w, y + 2);
            y += 5;
        }
    }

    public static void drawDashRect(int x, int y, int w, int h, Graphics g) {
        ReportGraphics.drawDashRect(x, y, w, h, null, g);
    }

    public static void drawDashRect(int x, int y, int w, int h, boolean[] corners, Graphics g) {
        ReportGraphics.drawRectHandles(x, y, w, h, corners, g);
        int wSpan = w + x;
        int hSpan = h + y;
        int x0 = x;
        while (x < wSpan) {
            g.drawLine(x, y, x + 2, y);
            g.drawLine(x, y + h, x + 2, y + h);
            x += 5;
        }
        x = x0;
        while (y < hSpan) {
            g.drawLine(x, y, x, y + 2);
            g.drawLine(x + w, y, x + w, y + 2);
            y += 5;
        }
    }

    private static void drawRectHandles(int x, int y, int w, int h, boolean[] corners, Graphics g) {
        if (corners == null || corners[0]) {
            g.fillRect(x - 1, y - 1, 5, 5);
        }
        if (corners == null || corners[1]) {
            g.fillRect(x + w / 2 - 2, y - 1, 5, 5);
        }
        if (corners == null || corners[2]) {
            g.fillRect(x + w - 3, y - 1, 5, 5);
        }
        if (corners == null || corners[3]) {
            g.fillRect(x - 1, y + h / 2 - 2, 5, 5);
        }
        if (corners == null || corners[4]) {
            g.fillRect(x + w - 3, y + h / 2 - 2, 5, 5);
        }
        if (corners == null || corners[5]) {
            g.fillRect(x - 1, y + h - 3, 5, 5);
        }
        if (corners == null || corners[6]) {
            g.fillRect(x + w / 2 - 2, y + h - 3, 5, 5);
        }
        if (corners == null || corners[7]) {
            g.fillRect(x + w - 3, y + h - 3, 5, 5);
        }
    }

    private void drawDashLines(int x, int y, int w, int h, boolean isVertical) {
        int wSpan = w + x;
        int hSpan = h + y;
        if (!isVertical) {
            while (y < hSpan) {
                this.drawDashLine(x, y, w, h, isVertical);
                ++y;
            }
        } else {
            while (x < wSpan) {
                this.drawDashLine(x, y, w, h, isVertical);
                ++x;
            }
        }
    }

    private void drawDashLine(int x, int y, int w, int h, boolean isVertical) {
        int wSpan = w + x;
        int hSpan = h + y;
        if (!isVertical) {
            while (x < wSpan) {
                this.g.drawLine(x, y, x + 2, y);
                x += 5;
            }
        } else {
            while (y < hSpan) {
                this.g.drawLine(x, y, x, y + 2);
                y += 5;
            }
        }
    }

    double getTextWidth(String text, Font font) throws Exception {
        font = this.resizeFont(font, text);
        if (this.reportUI.report.getStringCustomizer() != null) {
            text = this.reportUI.report.getStringCustomizer().encodeString(text);
        }
        FontMetrics fm = this.getFontMetrics(font);
        double width = QbUtil.toInch(fm.stringWidth(text) + 6);
        return width;
    }

    public double getTextHeight(String text, Font font, double w, short align, boolean noWrap) throws Exception {
        String[] strList;
        int ww = this.toPixel(w);
        font = this.resizeFont(font, text);
        if (this.reportUI.report.getStringCustomizer() != null) {
            text = this.reportUI.report.getStringCustomizer().encodeString(text);
        }
        FontMetrics fm = this.getFontMetrics(font);
        int charH = fm.getMaxAscent() + fm.getMaxDescent();
        charH = (int)((double)charH * this.lineHeight);
        int offset = 3;
        if (align == 1) {
            ww -= offset;
        } else if (align == 2) {
            ww -= offset;
        }
        if ((ww -= this.additionalOffset) < 1) {
            ww = 1;
        }
        if ((strList = ReportGraphics.tokenizer(text, fm, ww = (int)((double)ww / this.charWidthMultiplier), noWrap)).length == 1) {
            return this.toInch(charH);
        }
        return this.toInch(charH * strList.length + charH / 2);
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.g != null) {
            return this.g.getFontMetrics(font);
        }
        return this.textG.getFontMetrics(font);
    }

    void drawBullet(double x, double y, Color color) {
        LOGGER.finest("drawBullet");
        Dimension2D dim = this.getDimension(x, y, 0.05, 0.05);
        if (dim == null) {
            return;
        }
        this.setColor(color);
        this.g.fillOval(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(0.05), this.toPixel(0.05));
    }

    void drawText(String text, Font font, int x, int y, int w, int h, short align, short valign, boolean noWrap, boolean isUnderline) throws Exception {
        this.drawText(text, font, x, y, w, h, align, valign, noWrap, isUnderline, 0.0);
    }

    void drawText(String text, Font font, int x, int y, int w, int h, short align, short valign, boolean noWrap, boolean isUnderline, double rotation) throws Exception {
        LOGGER.finest("drawText");
        Font origFont = font;
        font = this.resizeFont(font, text);
        this.g.setFont(font);
        if (this.reportUI.report.getStringCustomizer() != null) {
            text = this.reportUI.report.getStringCustomizer().encodeString(text);
        }
        FontMetrics fm = this.g.getFontMetrics(font);
        int charH = fm.getMaxAscent() + fm.getMaxDescent();
        int offset = 3;
        if (rotation != 0.0) {
            if ((rotation %= 360.0) < 0.0) {
                rotation += 360.0;
            }
            if (align == 1 || align == 2) {
                h -= offset;
            }
        } else if (align == 1) {
            x += offset;
            w -= offset;
        } else if (align == 2) {
            w -= offset;
        }
        if ((w -= this.additionalOffset) < 1) {
            w = 1;
        }
        if (h < 1) {
            h = 1;
        }
        int origW = w;
        if (this.printMode) {
            double inchW = this.toInch(w);
            this.reportUI.setPixelPerInch(Toolkit.getDefaultToolkit().getScreenResolution());
            w = this.toPixel(inchW);
        }
        String[] strList = null;
        strList = rotation != 0.0 ? ReportGraphics.tokenizer(text, this.g.getFontMetrics(origFont), h, noWrap) : ReportGraphics.tokenizer(text, this.g.getFontMetrics(origFont), w, noWrap);
        if (this.printMode) {
            w = origW;
            this.reportUI.setPixelPerInch(72.0);
        }
        for (int i = 0; i < strList.length; ++i) {
            LOGGER.finest("strList: " + strList[i]);
            if (i != 0 && rotation == 0.0 && charH * (i + 1) > h) {
                return;
            }
            if (i != 0 && rotation != 0.0 && charH * (i + 1) > w) {
                return;
            }
            LOGGER.finest("Drawing the text");
            if (this.g instanceof IQbGraphics) {
                ((IQbGraphics)((Object)this.g)).drawRotateString2(strList[i], origFont, this.g.getColor(), x, y, w, h, align, valign, isUnderline, rotation, strList.length, i);
                continue;
            }
            Java2DUtil.drawRotateString(this.g, x, y, w, h, align, valign, isUnderline, rotation, font, strList[i], strList.length, i);
        }
    }

    private void drawNote(ReportElement cell, int x, int y) {
        if (cell.getScriptName() != null) {
            this.g.drawLine(x, y + 4, x + 4, y + 8);
            this.g.drawLine(x + 4, y + 8, x + 8, y);
            x += 12;
        }
        if (cell.isSecurityLevelDefined()) {
            this.g.setColor(Color.red);
            this.g.setFont(QbUtil.resizeViewerFont(NOTE_FONT, this.reportUI.report.isAdjustFont()));
            this.g.drawString("S", x, y + 8);
        }
    }

    private boolean validBarcode(ReportElement cell) {
        boolean flag = true;
        try {
            BarcodeFormat bf = (BarcodeFormat)((ReportCell)cell).getDataFormat();
            BarcodeUtil.getBarcodeString(cell.getText(), bf.getformat());
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to check for valid barcode", e);
            flag = false;
        }
        return flag;
    }

    private void drawBarcode(ReportElement cell, Dimension2D dim) throws Exception {
        if (cell.getText().equals("")) {
            return;
        }
        try {
            BufferedImage image = BarcodeUtil.createBarCodeImage(cell);
            int leftMargin = BarcodeUtil.getLeftMarginOfBarCode(cell.getWidthOfElement(), image.getWidth(), cell.getAlign());
            BarcodeFormat bf = (BarcodeFormat)((ReportCell)cell).getDataFormat();
            if (this.g instanceof IQbGraphics) {
                byte[] imageData = this.convertImageToByteArray(image);
                ((IQbGraphics)((Object)this.g)).drawImage(imageData, 1, (int)dim.getWidth() + leftMargin, (int)dim.getHeight(), image.getWidth(), image.getHeight() + cell.getBorder(BorderSide.TOP));
            } else if (BarcodeUtil.isBarCodeInUPCAFormat(bf.getformat())) {
                this.g.drawImage(image, this.toPixel(dim.getWidth()) + leftMargin, this.toPixel(dim.getHeight() + (double)cell.getBorder(BorderSide.TOP)), null, null);
            } else {
                this.g.drawImage(image, (int)dim.getWidth() + leftMargin, (int)dim.getHeight() + cell.getBorder(BorderSide.TOP), null, null);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Unsupported barcode format", ex);
            this.setColor(cell.getFontColor());
            this.drawText(LanguageEncoder.getText("Unsupported Barcode Format"), cell.getRefFontToDraw(this.reportUI.report.isAdjustFont()), this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(cell.getWidth()), this.toPixel(cell.getHeight()), cell.getAlign(), cell.getVAlign(), cell.isNoWrap(), cell.isUnderline());
        }
    }

    private byte[] convertImageToByteArray(BufferedImage bi) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpeg", os);
            return os.toByteArray();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Cannot convert image to byte array", ex);
            return null;
        }
    }

    public Font resizeFont(Font font, String text) {
        Font newFont = this.reportUI.getFontTable().get(font);
        if (newFont != null) {
            return newFont;
        }
        text = "mibrelts ESa";
        double printToScreenRatio = (double)this.toPixel(1.0) / (double)QbUtil.toPixel(1.0);
        if (printToScreenRatio > 1.0) {
            this.reportUI.getFontTable().put(font, font);
            return font;
        }
        FontMetrics fm = this.getFontMetrics(font);
        int orgWidth = fm.stringWidth(text);
        double newWidth = (double)orgWidth * printToScreenRatio;
        newFont = FontTable.newFont(font.getName(), font.getStyle(), font.getSize());
        while ((double)orgWidth > newWidth && newFont.getSize() > 1) {
            newFont = FontTable.newFont(newFont.getName(), newFont.getStyle(), newFont.getSize() - 1);
            fm = this.getFontMetrics(newFont);
            orgWidth = fm.stringWidth(text);
        }
        this.reportUI.getFontTable().put(font, newFont);
        return newFont;
    }

    private static int trimString(String str, FontMetrics fm, int w, int initialw, Vector<String> strList) throws Exception {
        int strLen = fm.stringWidth(str);
        if (initialw >= strLen) {
            strList.addElement(str);
            return initialw - strLen;
        }
        int noChar = ReportGraphics.countDisplayChar(str, fm, initialw);
        if (noChar <= 0) {
            strList.addElement("");
            if (w <= initialw) {
                return w;
            }
            return ReportGraphics.trimString(str, fm, w, w, strList);
        }
        int space = str.substring(0, noChar).lastIndexOf(32);
        if (space > 0) {
            strList.addElement(str.substring(0, space));
            return ReportGraphics.trimString(str.substring(space + 1), fm, w, w, strList);
        }
        strList.addElement(str.substring(0, noChar));
        return ReportGraphics.trimString(str.substring(noChar), fm, w, w, strList);
    }

    private static int countDisplayChar(String str, FontMetrics fm, int w) {
        if (w <= 0) {
            return 0;
        }
        int strWidth = fm.stringWidth(str);
        int strlen = str.length();
        if (strWidth <= w || strWidth < 1) {
            return strlen;
        }
        double ratio = (double)w / (double)strWidth;
        double subChars = ratio * (double)strlen;
        String tempStr = str.substring(0, (int)Math.floor(subChars));
        int tempstrlen = tempStr.length();
        boolean skipBig = false;
        while (tempstrlen > 0 && w < fm.stringWidth(str.substring(0, tempstrlen))) {
            if (--tempstrlen == 0) {
                return 0;
            }
            skipBig = true;
        }
        if (!skipBig) {
            while (tempstrlen < strlen && w >= fm.stringWidth(str.substring(0, tempstrlen + 1))) {
                ++tempstrlen;
            }
        }
        return tempstrlen;
    }

    private static String[] tokenizer(String str) {
        if (str == null) {
            return new String[]{"null"};
        }
        String str2 = "";
        str2 = str;
        str2 = QbUtil.replace(str2, "\r", "");
        StringTokenizer st = new StringTokenizer(str2, "\n", true);
        Vector<String> paragraphs = new Vector<String>();
        String prev = "\n";
        while (st.hasMoreTokens()) {
            String cur = st.nextToken();
            if (prev.equals("\n") && cur.equals("\n")) {
                paragraphs.addElement("");
            } else if (!cur.equals("\n")) {
                paragraphs.addElement(cur);
            }
            prev = cur;
        }
        if (prev.equals("\n")) {
            paragraphs.addElement("");
        }
        String[] list = new String[paragraphs.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = (String)paragraphs.elementAt(i);
        }
        return list;
    }

    public static String[] tokenizer(String str, FontMetrics fm, int w, boolean noWrap) throws Exception {
        String[] tmp = ReportGraphics.tokenizer(str);
        if (noWrap) {
            return tmp;
        }
        Vector<String> vec = new Vector<String>();
        for (String element : tmp) {
            Vector<String> vec1 = new Vector<String>();
            ReportGraphics.trimString(element, fm, w, w, vec1);
            for (int j = 0; j < vec1.size(); ++j) {
                vec.addElement(vec1.elementAt(j));
            }
        }
        String[] res = new String[vec.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)vec.elementAt(i);
        }
        return res;
    }

    public static Vector<Object> tokenizer(String str, FontMetrics fm, int w, int initialw, boolean noWrap) throws Exception {
        String[] tmp = ReportGraphics.tokenizer(str);
        if (noWrap) {
            Vector<Object> ret = new Vector<Object>();
            ret.addElement(tmp);
            ret.addElement(0);
            return ret;
        }
        Vector<String> vec = new Vector<String>();
        int remainingWidth = initialw;
        for (String element : tmp) {
            Vector<String> vec1 = new Vector<String>();
            remainingWidth = ReportGraphics.trimString(element, fm, w, initialw, vec1);
            initialw = w;
            for (int j = 0; j < vec1.size(); ++j) {
                vec.addElement(vec1.elementAt(j));
            }
        }
        String[] res = new String[vec.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)vec.elementAt(i);
        }
        Vector<Object> ret = new Vector<Object>();
        ret.addElement(res);
        ret.addElement(remainingWidth);
        return ret;
    }

    private boolean drawCellOutline() {
        return this.reportUI.isDesignMode() && this.reportUI.report.showCellOutline;
    }

    private Color getCellOutlineColor() {
        if (this.reportUI.isDesignMode() && this.reportUI.report.showCellOutline) {
            return Color.gray;
        }
        return null;
    }

    private int getCellOutlineThickness() {
        if (this.reportUI.isDesignMode() && this.reportUI.report.showCellOutline) {
            return 1;
        }
        return 0;
    }

    private void drawDashLineCellBorder(ReportElement cell, Dimension2D dim) {
        if (cell.getBorderColor() != null && cell.getBorderThickness() > 0) {
            return;
        }
        int style = 3;
        if (this.drawCellOutline()) {
            this.setColor(this.getCellOutlineColor());
            if (style == 3) {
                int thickness = this.getCellOutlineThickness();
                int rX = this.toPixel(dim.getWidth());
                int rY = this.toPixel(dim.getHeight());
                int rW = this.toPixel(cell.getWidth() + dim.getWidth()) - rX;
                int rH = this.toPixel(cell.getHeight() + dim.getHeight()) - rY;
                this.drawDashRects(rX, rY, rW, rH, thickness, true, true);
            }
        }
    }

    protected int toPixel(double inch) {
        return this.reportUI.toPixel(inch);
    }

    protected double toInch(int pixel) {
        return this.reportUI.toInch(pixel);
    }

    Vector<Vector<Object[]>> breakRichText(ReportRTFObject rtfobject, Report report, ReportTable table, int width, boolean forHTML) throws Exception {
        Graphics graphics = this.g;
        if (graphics == null) {
            graphics = this.textG;
        }
        return RTFUtil.breakRichText(rtfobject.getData(), rtfobject.getFormatMap(), rtfobject.getFormats(), report, table, width, graphics, forHTML, this);
    }

    public static Vector<Vector<Object[]>> breakRichText(ReportRTFObject rtfobject, Report report, ReportTable table, int width, Graphics graphics, boolean forHTML) throws Exception {
        return RTFUtil.breakRichText(rtfobject.getData(), rtfobject.getFormatMap(), rtfobject.getFormats(), report, table, width, graphics, forHTML, null);
    }

    public void setPrintMode(boolean state) {
        this.printMode = state;
    }

    void setReportUI(ReportUI rptUI) {
        LOGGER.finest("Set report UI");
        if (rptUI instanceof SubReportUI && this.parentReportUI == null) {
            this.parentReportUI = this.reportUI;
        }
        this.reportUI = rptUI;
    }

    void resetReportUI() {
        LOGGER.finest("Reset report UI");
        this.reportUI = this.parentReportUI;
        this.parentReportUI = null;
    }

    public int getAdditionalOffset() {
        return this.additionalOffset;
    }

    public void setAdditionalOffset(int additionalOffset) {
        this.additionalOffset = additionalOffset;
    }

    public void setLineHeight(double lineHeight) {
        this.lineHeight = lineHeight;
    }

    public void setCharWidthMultiplier(double charWidthMultiplier) {
        this.charWidthMultiplier = charWidthMultiplier;
    }
}

