/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.CrossTabReportSection;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.CrossTabTable;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Script;
import quadbase.reportdesigner.util.IReport;
import quadbase.reportdesigner.util.ISubReport;

public class ReportMultiSectionTable
extends ReportTreeTable {
    public static final String XMLTAG = "REPORTMULTISECIONTABLE";
    ReportSection[] dataHeader;
    ReportSection[] dataFooter;

    public ReportMultiSectionTable(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    public ReportMultiSectionTable(ReportMultiSectionTable _tbl) {
        super(_tbl);
        this.dataHeader = _tbl.dataHeader;
        this.dataFooter = _tbl.dataFooter;
    }

    public ReportMultiSectionTable() {
    }

    static ReportMultiSectionTable createMultiSectionTable(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        ReportMultiSectionTable tbl = new ReportMultiSectionTable();
        tbl.read(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        return tbl;
    }

    static ReportMultiSectionTable createMultiSectionTable(Node node, int version) throws Exception {
        if (!node.getNodeName().equalsIgnoreCase(XMLTAG)) {
            throw new Exception("'REPORTMULTISECIONTABLE' element expected, but found '" + node.getNodeName() + "' element.");
        }
        ReportMultiSectionTable tbl = new ReportMultiSectionTable();
        tbl.readXML(node, version);
        return tbl;
    }

    @Override
    public int countRowBreakHeader() {
        if (this.dataHeader == null) {
            return 0;
        }
        return this.dataHeader.length;
    }

    @Override
    public ReportSection getRowBreakHeader(int breakLevel) {
        if (breakLevel < 0 || breakLevel >= this.countRowBreakHeader()) {
            return null;
        }
        return this.dataHeader[breakLevel];
    }

    @Override
    public int countRowBreakFooter() {
        return this.dataFooter.length;
    }

    @Override
    public ReportSection getRowBreakFooter(int breakLevel) {
        if (breakLevel < 0 || breakLevel >= this.countRowBreakFooter()) {
            return null;
        }
        return this.dataFooter[breakLevel];
    }

    @Override
    public void copy(ReportTable _tbl) {
        super.copy(_tbl);
        if (_tbl instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable tmp = (ReportMultiSectionTable)_tbl;
            int len = this.countRowBreakHeader() <= tmp.countRowBreakHeader() ? this.countRowBreakHeader() : tmp.countRowBreakHeader();
            for (int i = 0; i < len; ++i) {
                this.dataHeader[i].copy(tmp.dataHeader[i]);
                this.dataFooter[i].copy(tmp.dataFooter[i]);
            }
        }
    }

    @Override
    public void loadTable(ReportTable _tbl) {
        super.loadTable(_tbl);
        this.loadTableHelper(_tbl, false, true, false, null);
    }

    @Override
    public void loadTable(ReportTable _tbl, int separatingIndex) {
        super.loadTable(_tbl, separatingIndex);
        this.loadTableHelper(_tbl, false, true, false, null);
    }

    @Override
    public void loadTable(ReportTable _tbl, boolean applyScript) {
        super.loadTable(_tbl, applyScript);
        this.loadTableHelper(_tbl, applyScript, true, false, null);
    }

    @Override
    public void loadTable(ReportTable _tbl, boolean applyScript, int separatingIndex, boolean generateCrossTabGrandTotalColumn) {
        super.loadTable(_tbl, applyScript, separatingIndex, generateCrossTabGrandTotalColumn);
        this.loadTableHelper(_tbl, applyScript, true, false, null);
    }

    public void superloadTable(ReportTable _tbl, boolean applyScript, int separatingIndex, boolean generateCrossTabGrandTotalColumn, boolean copyRpt, boolean copyVisible) {
        super.loadTable(_tbl, applyScript, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, copyVisible);
    }

    @Override
    public void loadTable(ReportTable _tbl, boolean applyScript, int separatingIndex, boolean generateCrossTabGrandTotalColumn, boolean copyRpt, boolean copyVisible) {
        super.loadTable(_tbl, applyScript, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, copyVisible);
        this.loadTableHelper(_tbl, applyScript, copyRpt, false, null);
    }

    @Override
    public void loadTable(ReportTable _tbl, boolean applyScript, int separatingIndex, boolean generateCrossTabGrandTotalColumn, boolean copyRpt, boolean copyVisible, ReportCell[] globalFormatTemplates, int dataType) {
        super.loadTable(_tbl, applyScript, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, copyVisible);
        this.loadTableHelper(_tbl, applyScript, copyRpt, false, globalFormatTemplates, dataType);
    }

    public void superloadTable(ReportTable _tbl, boolean applyScript, int separatingIndex, boolean generateCrossTabGrandTotalColumn, boolean copyRpt, boolean copyVisible, ReportCell[] globalFormatTemplates) {
        super.loadTable(_tbl, applyScript, separatingIndex, generateCrossTabGrandTotalColumn, copyRpt, copyVisible, globalFormatTemplates, -1);
    }

    @Override
    public void loadTable(ReportTable _tbl, boolean applyScript, boolean copyRpt) {
        super.loadTable(_tbl, applyScript, copyRpt);
        this.loadTableHelper(_tbl, applyScript, copyRpt, false, null);
    }

    public void loadTable(ReportTable _tbl, boolean applyScript, boolean copyRpt, boolean keepElt, int reportType) {
        super.loadTable(_tbl, applyScript, copyRpt);
        this.loadTableHelper(_tbl, applyScript, copyRpt, keepElt, null, reportType);
    }

    public void loadFixedFieldTableStyle(ReportTable _tbl, boolean applyScript, boolean copyRpt, boolean keepElt, int reportType) {
        super.applyStyleForFixedFieldTable(_tbl, applyScript);
        this.loadTableHelper(_tbl, applyScript, copyRpt, keepElt, null, reportType, true);
    }

    private void loadTableHelper(ReportTable _tbl, boolean applyScript, boolean copyRpt, boolean keepElt, ReportCell[] globalFormatTemplates) {
        this.loadTableHelper(_tbl, applyScript, copyRpt, keepElt, globalFormatTemplates, -1);
    }

    private void loadTableHelper(ReportTable _tbl, boolean applyScript, boolean copyRpt, boolean keepElt, ReportCell[] globalFormatTemplates, int dataType) {
        this.loadTableHelper(_tbl, applyScript, copyRpt, keepElt, globalFormatTemplates, dataType, false);
    }

    private void loadTableHelper(ReportTable _tbl, boolean applyScript, boolean copyRpt, boolean keepElt, ReportCell[] globalFormatTemplates, int dataType, boolean applyFixedFieldStyleOnly) {
        if (_tbl instanceof ReportMultiSectionTable) {
            int len;
            ReportMultiSectionTable tmp = (ReportMultiSectionTable)_tbl;
            int columnCountMismatch = this.getColumnCount() - _tbl.getColumnCount();
            int separatingIndex = this.getStartOfColumnBreakColumn() + this.getColumnBreakColumnCount() - columnCountMismatch;
            Vector<ReportColumn> columns = _tbl.getColumns();
            int n = len = this.countRowBreakHeader() <= tmp.countRowBreakHeader() ? this.countRowBreakHeader() : tmp.countRowBreakHeader();
            if (dataType == 3) {
                columnCountMismatch = 0;
            }
            int[] fieldsCount = null;
            boolean isCrossTabSubTotalColumnPositionLeft = false;
            boolean isAddCrossTabSubTotalColumn = true;
            if (this instanceof CrossTabTable) {
                fieldsCount = ((CrossTabTable)this).getFieldsCount();
                isCrossTabSubTotalColumnPositionLeft = ((CrossTabTable)this).mData.report.isRowAggregationSubtotalOnLeft();
                isAddCrossTabSubTotalColumn = ((CrossTabTable)this).mData.report.isShowRowAggregationSubtotal();
            }
            for (int i = 0; i < len; ++i) {
                if (applyFixedFieldStyleOnly) {
                    ((CrossTabReportSection)this.dataHeader[i]).applyStyleForFixedFieldSection(tmp.dataHeader[i], applyScript);
                    ((CrossTabReportSection)this.dataFooter[i]).applyStyleForFixedFieldSection(tmp.dataFooter[i], applyScript);
                    continue;
                }
                this.copyDataHeaderAndFooter(applyScript, copyRpt, keepElt, globalFormatTemplates, tmp, columnCountMismatch, separatingIndex, columns, fieldsCount, isCrossTabSubTotalColumnPositionLeft, isAddCrossTabSubTotalColumn, i);
            }
        }
    }

    protected void copyDataHeaderAndFooter(boolean applyScript, boolean copyRpt, boolean keepElt, ReportCell[] globalFormatTemplates, ReportMultiSectionTable tmp, int columnCountMismatch, int separatingIndex, Vector<ReportColumn> columns, int[] fieldsCount, boolean isCrossTabSubTotalColumnPositionLeft, boolean isAddCrossTabSubTotalColumn, int i) {
        this.dataHeader[i].copy(tmp.dataHeader[i], columnCountMismatch, separatingIndex, columns, globalFormatTemplates, !copyRpt, false, true, applyScript, keepElt, fieldsCount, this.getHeader(), this.getColumns());
        if (tmp.dataFooter[i] != null) {
            tmp.dataFooter[i].setNewExcelSheet(false);
        }
        this.dataFooter[i].copy(tmp.dataFooter[i], columnCountMismatch, separatingIndex, columns, globalFormatTemplates, !copyRpt, false, true, applyScript, keepElt, fieldsCount, this.getHeader(), this.getColumns());
    }

    @Override
    public void deepCopy(ReportTable _tbl) {
        super.deepCopy(_tbl);
        if (_tbl instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable tmp = (ReportMultiSectionTable)_tbl;
            int len = this.countRowBreakHeader() <= tmp.countRowBreakHeader() ? this.countRowBreakHeader() : tmp.countRowBreakHeader();
            for (int i = 0; i < len; ++i) {
                this.dataHeader[i].deepCopy(tmp.dataHeader[i]);
                this.dataFooter[i].deepCopy(tmp.dataFooter[i]);
            }
        }
    }

    @Override
    public void copyTemplate(ReportTable _tbl) {
        super.copyTemplate(_tbl);
        if (_tbl instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable tmp = (ReportMultiSectionTable)_tbl;
            int len = this.countRowBreakHeader() <= tmp.countRowBreakHeader() ? this.countRowBreakHeader() : tmp.countRowBreakHeader();
            for (int i = 0; i < len; ++i) {
                this.dataHeader[i].copyTemplate(tmp.dataHeader[i]);
                this.dataFooter[i].copyTemplate(tmp.dataFooter[i]);
            }
        }
    }

    @Override
    public void copyTemplate(ReportTable _tbl, boolean applyScript) {
        this.copyTemplate(_tbl, applyScript, false);
    }

    @Override
    public void copyTemplate(ReportTable _tbl, boolean applyScript, boolean copyEmptySection) {
        this.copyTemplate(_tbl, applyScript, copyEmptySection, false, false);
    }

    @Override
    public void copyTemplate(ReportTable _tbl, boolean applyScript, boolean copyEmptySection, boolean copyGuideLine, boolean isApplyTemplateForDHTMLViewer) {
        super.copyTemplate(_tbl, applyScript, copyEmptySection, copyGuideLine, isApplyTemplateForDHTMLViewer);
        if (_tbl instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable tmp = (ReportMultiSectionTable)_tbl;
            int len = this.countRowBreakHeader() <= tmp.countRowBreakHeader() ? this.countRowBreakHeader() : tmp.countRowBreakHeader();
            for (int i = 0; i < len; ++i) {
                this.dataHeader[i].copyTemplate(tmp.dataHeader[i], copyEmptySection);
                if (isApplyTemplateForDHTMLViewer) {
                    this.dataFooter[i].applyStyleForDHTMLViewer(tmp.dataFooter[i]);
                    continue;
                }
                this.dataFooter[i].copyTemplate(tmp.dataFooter[i], copyEmptySection);
            }
        }
    }

    @Override
    public void applyTemplate(ReportTable _tbl) {
        super.applyTemplate(_tbl);
        if (_tbl instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable tmp = (ReportMultiSectionTable)_tbl;
            int len = this.countRowBreakHeader() <= tmp.countRowBreakHeader() ? this.countRowBreakHeader() : tmp.countRowBreakHeader();
            for (int i = 0; i < len; ++i) {
                this.dataHeader[i].applyTemplate(tmp.dataHeader[i]);
                this.dataFooter[i].applyTemplate(tmp.dataFooter[i]);
            }
        }
    }

    @Override
    public void write(DataOutput out, boolean pack) throws IOException {
        super.write(out, pack);
        out.writeInt(this.dataHeader.length);
        for (int i = 0; i < this.dataHeader.length; ++i) {
            this.dataHeader[i].write(out, pack);
            this.dataFooter[i].write(out, pack);
        }
    }

    @Override
    public void writeXML(Writer out, boolean writeElementTag) throws IOException {
        if (writeElementTag) {
            out.write("<REPORTMULTISECIONTABLE>\n");
        }
        super.writeXML(out, false);
        for (int i = 0; i < this.dataHeader.length; ++i) {
            out.write("<REPORTMULTISECTIONTABLE_TABLEHEADER>\n");
            this.dataHeader[i].writeXML(out, true);
            out.write("</REPORTMULTISECTIONTABLE_TABLEHEADER>\n");
            out.write("<REPORTMULTISECTIONTABLE_TABLEFOOTER>\n");
            this.dataFooter[i].writeXML(out, true);
            out.write("</REPORTMULTISECTIONTABLE_TABLEFOOTER>\n");
        }
        if (writeElementTag) {
            out.write("</REPORTMULTISECIONTABLE>\n");
        }
    }

    @Override
    public void setID(String newID) {
        super.setID(newID);
        if (this.dataHeader == null) {
            return;
        }
        Object[] elts = this.getAllSections();
        for (int i = 0; i < this.dataHeader.length; ++i) {
            if (this.dataHeader[i].getID().equals("")) {
                this.dataHeader[i].setID(newID + "_H", elts);
            }
            if (!this.dataFooter[i].getID().equals("")) continue;
            this.dataFooter[i].setID(newID + "_F", elts);
        }
    }

    @Override
    public boolean customIDExists(String id) {
        if (this.dataHeader == null) {
            return false;
        }
        for (int i = 0; i < this.dataHeader.length; ++i) {
            if (this.dataHeader[i].customIDExists(id)) {
                return true;
            }
            if (!this.dataFooter[i].customIDExists(id)) continue;
            return true;
        }
        return super.customIDExists(id);
    }

    @Override
    public boolean containsZIndex() {
        if (this.dataHeader == null) {
            return false;
        }
        for (int i = 0; i < this.dataHeader.length; ++i) {
            if (this.dataHeader[i].containsZIndex()) {
                return true;
            }
            if (!this.dataFooter[i].containsZIndex()) continue;
            return true;
        }
        return super.containsZIndex();
    }

    @Override
    public boolean formulaReferenced(Formula formula) {
        if (this.header.formulaReferenced(formula)) {
            return true;
        }
        if (this.footer.formulaReferenced(formula)) {
            return true;
        }
        if (this.dataHeader == null) {
            return false;
        }
        for (int i = 0; i < this.dataHeader.length; ++i) {
            if (this.dataHeader[i].formulaReferenced(formula)) {
                return true;
            }
            if (!this.dataFooter[i].formulaReferenced(formula)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean scriptReferenced(Script script) {
        return this.scriptReferenced(script, false);
    }

    @Override
    public boolean scriptReferenced(Script script, boolean checkThisTableOnly) {
        if (checkThisTableOnly) {
            return super.scriptReferenced(script, true);
        }
        if (this.header.scriptReferenced(script)) {
            return true;
        }
        if (this.footer.scriptReferenced(script)) {
            return true;
        }
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                if (!element.scriptReferenced(script)) continue;
                return true;
            }
        }
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                if (!element.scriptReferenced(script)) continue;
                return true;
            }
        }
        for (int j = 0; j < this.getSubTable().size(); ++j) {
            ReportTable table = this.getSubTable(j);
            if (!table.scriptReferenced(script)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ReportElement getData(String id) {
        ReportElement tmp = null;
        tmp = super.getData(id);
        if (tmp != null) {
            return tmp;
        }
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                tmp = element.getData(id);
                if (tmp == null) continue;
                return tmp;
            }
        }
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                tmp = element.getData(id);
                if (tmp == null) continue;
                return tmp;
            }
        }
        return tmp;
    }

    public Vector getAllColors(Vector colors) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                colors = element.getAllColors(colors);
            }
        }
        colors = super.getAllColors(colors);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                colors = element.getAllColors(colors);
            }
        }
        return colors;
    }

    @Override
    public String[] getSecurityLevels() {
        int j;
        Vector<Object> levels = new Vector<Object>();
        String[] temp = null;
        if (this.dataHeader != null) {
            for (ReportSection reportSection : this.dataHeader) {
                temp = reportSection.getSecurityLevels();
                for (j = 0; j < temp.length; ++j) {
                    if (levels.contains(temp[j])) continue;
                    levels.addElement(temp[j]);
                }
            }
        }
        temp = super.getSecurityLevels();
        for (String string : temp) {
            levels.addElement(string);
        }
        if (this.dataFooter != null) {
            for (ReportSection reportSection : this.dataFooter) {
                temp = reportSection.getSecurityLevels();
                for (j = 0; j < temp.length; ++j) {
                    if (levels.contains(temp[j])) continue;
                    levels.addElement(temp[j]);
                }
            }
        }
        String[] ls = new String[levels.size()];
        for (int i = 0; i < ls.length; ++i) {
            ls[i] = (String)levels.elementAt(i);
        }
        return ls;
    }

    @Override
    public String[] getSecuredScripts() {
        int j;
        Vector<Object> scripts = new Vector<Object>();
        String[] temp = null;
        if (this.dataHeader != null) {
            for (ReportSection reportSection : this.dataHeader) {
                temp = reportSection.getSecuredScripts();
                for (j = 0; j < temp.length; ++j) {
                    if (scripts.contains(temp[j])) continue;
                    scripts.addElement(temp[j]);
                }
            }
        }
        temp = super.getSecuredScripts();
        for (String string : temp) {
            scripts.addElement(string);
        }
        if (this.dataFooter != null) {
            for (ReportSection reportSection : this.dataFooter) {
                temp = reportSection.getSecuredScripts();
                for (j = 0; j < temp.length; ++j) {
                    if (scripts.contains(temp[j])) continue;
                    scripts.addElement(temp[j]);
                }
            }
        }
        String[] ls = new String[scripts.size()];
        for (int i = 0; i < ls.length; ++i) {
            ls[i] = (String)scripts.elementAt(i);
        }
        return ls;
    }

    @Override
    public void setSecurityLevelProperties(String levelName, ReportElement level) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setSecurityLevelProperties(levelName, level);
            }
        }
        super.setSecurityLevelProperties(levelName, level);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.setSecurityLevelProperties(levelName, level);
            }
        }
    }

    @Override
    public void setReportObjectForSubReports(String filename, ISubReport rptobject) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setReportObjectForSubReports(filename, rptobject);
            }
        }
        super.setReportObjectForSubReports(filename, rptobject);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.setReportObjectForSubReports(filename, rptobject);
            }
        }
    }

    @Override
    public void updateSubReportFileName(String oldfilename, String newfilename) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.updateSubReportFileName(oldfilename, newfilename);
            }
        }
        super.updateSubReportFileName(oldfilename, newfilename);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.updateSubReportFileName(oldfilename, newfilename);
            }
        }
    }

    @Override
    public void setChartPath(String path) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setChartPath(path);
            }
        }
        super.setChartPath(path);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.setChartPath(path);
            }
        }
    }

    @Override
    public void setSubReportPath(String path) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setSubReportPath(path);
            }
        }
        super.setSubReportPath(path);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.setSubReportPath(path);
            }
        }
    }

    @Override
    public void setImagePath(String path) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setImagePath(path);
            }
        }
        super.setImagePath(path);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.setImagePath(path);
            }
        }
    }

    @Override
    public void setSubReportParameterMap(String filename, String[] params) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setSubReportParameterMap(filename, params);
            }
        }
        super.setSubReportParameterMap(filename, params);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.setSubReportParameterMap(filename, params);
            }
        }
    }

    @Override
    public void setChartParameterMap(String filename, String[] params) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setChartParameterMap(filename, params);
            }
        }
        super.setChartParameterMap(filename, params);
        if (this.dataFooter != null) {
            for (ReportSection element : this.dataFooter) {
                element.setChartParameterMap(filename, params);
            }
        }
    }

    @Override
    public double getMinWidth() {
        double val;
        double maxX = 0.0;
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                val = element.getMinWidth();
                if (!(val > maxX)) continue;
                maxX = val;
            }
        }
        if ((val = super.getMinWidth()) > maxX) {
            maxX = val;
        }
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataFooter) {
                val = element.getMinWidth();
                if (!(val > maxX)) continue;
                maxX = val;
            }
        }
        return maxX;
    }

    @Override
    public void resize(double xratio, double yratio) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.resize(xratio, yratio);
            }
        }
        super.resize(xratio, yratio);
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataFooter) {
                element.resize(xratio, yratio);
            }
        }
    }

    @Override
    public void setGridLineLink(IReport report) {
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataHeader) {
                element.setGridLineLink(report);
            }
        }
        super.setGridLineLink(report);
        if (this.dataHeader != null) {
            for (ReportSection element : this.dataFooter) {
                element.setGridLineLink(report);
            }
        }
    }

    private Object[] getAllSections() {
        Object[] elts = new Object[this.dataHeader.length * 2];
        int k = 0;
        for (int i = 0; i < this.dataHeader.length; ++i) {
            elts[k++] = this.dataHeader[i];
            elts[k++] = this.dataFooter[i];
        }
        return elts;
    }

    @Override
    public void read(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath) throws Exception {
        super.read(in, version, pack, fromReportDesigner, subFilesTable, domainPath);
        int len = in.readInt();
        this.createDataHeadersAndFooters(in, version, pack, fromReportDesigner, subFilesTable, domainPath, len);
    }

    private void createDataHeadersAndFooters(DataInput in, int version, boolean pack, boolean fromReportDesigner, FileInMemTable subFilesTable, String domainPath, int len) throws Exception {
        this.dataHeader = new ReportSection[len];
        this.dataFooter = new ReportSection[len];
        this.getReportSectionFactory(version, pack, subFilesTable, domainPath);
        for (int i = 0; i < this.dataHeader.length; ++i) {
            this.dataHeader[i] = this.reportSectionFactory.createSection(in, fromReportDesigner);
            this.dataFooter[i] = this.reportSectionFactory.createSection(in, fromReportDesigner);
        }
    }

    @Override
    public void readXML(Node node, int version) throws Exception {
        int i;
        super.readXML(node, version);
        Vector<ReportSection> headers = new Vector<ReportSection>();
        Vector<ReportSection> footers = new Vector<ReportSection>();
        NodeList nodeList = node.getChildNodes();
        for (i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equalsIgnoreCase("REPORTMULTISECTIONTABLE_TABLEHEADER")) {
                headers.addElement(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(nodeList.item(i)), version));
                continue;
            }
            if (!nodeList.item(i).getNodeName().equalsIgnoreCase("REPORTMULTISECTIONTABLE_TABLEFOOTER")) continue;
            footers.addElement(ReportSection.createSection(LoadXMLReportHelper.getFirstElement(nodeList.item(i)), version));
        }
        if (headers.size() != footers.size()) {
            throw new Exception("There must be the same number of 'TABLEHEADER' and 'TABLEFOOTER' elements in 'REPORTMULTISECTIONTABLE' element.");
        }
        this.dataHeader = new ReportSection[headers.size()];
        this.dataFooter = new ReportSection[headers.size()];
        for (i = 0; i < headers.size(); ++i) {
            this.dataHeader[i] = (ReportSection)headers.elementAt(i);
            this.dataFooter[i] = (ReportSection)footers.elementAt(i);
        }
    }

    @Override
    public void writeSTL(DataOutput out) throws Exception {
        super.writeSTL(out);
        out.writeInt(this.dataHeader.length);
        for (int i = 0; i < this.dataHeader.length; ++i) {
            this.dataHeader[i].writeSTL(out);
            this.dataFooter[i].writeSTL(out);
        }
    }

    @Override
    public void readSTL(DataInput in, int version) throws Exception {
        super.readSTL(in, version);
        int len = in.readInt();
        this.dataHeader = new ReportSection[len];
        this.dataFooter = new ReportSection[len];
        for (int i = 0; i < this.dataHeader.length; ++i) {
            this.dataHeader[i] = new ReportSection();
            this.dataHeader[i].readSTL(in, version);
            this.dataFooter[i] = new ReportSection();
            this.dataFooter[i].readSTL(in, version);
        }
    }

    @Override
    public void loadStyle(Report report, ReportTable table) {
        super.loadStyle(report, table);
        for (int i = 0; i < this.dataHeader.length; ++i) {
            this.dataHeader[i].loadStyle(report, ((ReportMultiSectionTable)table).dataHeader[i]);
            this.dataFooter[i].loadStyle(report, ((ReportMultiSectionTable)table).dataFooter[i]);
        }
    }

    @Override
    public void applyStyle(ReportTable table) {
        super.applyStyle(table);
        if (table instanceof ReportMultiSectionTable) {
            for (int i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
                if (i >= ((ReportMultiSectionTable)table).dataHeader.length) continue;
                this.dataHeader[i].applyStyle(((ReportMultiSectionTable)table).dataHeader[i]);
                this.dataFooter[i].applyStyle(((ReportMultiSectionTable)table).dataFooter[i]);
            }
        }
    }

    @Override
    public void applyStyle(Vector setting, ReportTable table) {
        super.applyStyle(setting, table);
        if (table instanceof ReportMultiSectionTable) {
            for (int i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
                if (i >= ((ReportMultiSectionTable)table).dataHeader.length) continue;
                this.dataHeader[i].applyStyle(setting, ((ReportMultiSectionTable)table).dataHeader[i]);
                this.dataFooter[i].applyStyle(setting, ((ReportMultiSectionTable)table).dataFooter[i]);
            }
        }
    }

    @Override
    public void createFormulaObject(Report report) {
        int i;
        super.createFormulaObject(report);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].createFormulaObject(report);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].createFormulaObject(report);
        }
    }

    @Override
    public void createFormulaObjectFromName(Report report) {
        int i;
        super.createFormulaObjectFromName(report);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].createFormulaObjectFromName(report);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].createFormulaObjectFromName(report);
        }
    }

    @Override
    public void createScriptObject(Vector<Script> scripts) {
        int i;
        super.createScriptObject(scripts);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].createScriptObject(scripts);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].createScriptObject(scripts);
        }
    }

    @Override
    public void createScriptObjectFromName(Vector<Script> scripts) {
        int i;
        super.createScriptObjectFromName(scripts);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].createScriptObjectFromName(scripts);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].createScriptObjectFromName(scripts);
        }
    }

    @Override
    public void copyAllGuideLineElts(Report report, Report _report, ReportTable _table) {
        super.copyAllGuideLineElts(report, _report, _table);
        for (ReportSection element : this.dataHeader) {
            element.copyAllGuideLineElts(report, _report, element);
        }
        for (ReportSection element : this.dataFooter) {
            element.copyAllGuideLineElts(report, _report, element);
        }
    }

    @Override
    public void setSnapToGrid(boolean snapToGrid, boolean metric, double stepSize) {
        int i;
        super.setSnapToGrid(snapToGrid, metric, stepSize);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].setSnapToGrid(snapToGrid, metric, stepSize);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].setSnapToGrid(snapToGrid, metric, stepSize);
        }
    }

    @Override
    public void setSnapToGrid(boolean snapToGrid, double stepSize, double cmStepSize) {
        int i;
        super.setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].setSnapToGrid(snapToGrid, stepSize, cmStepSize);
        }
    }

    @Override
    public void setLocale(Locale l) {
        int i;
        super.setLocale(l);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].setLocale(l);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].setLocale(l);
        }
    }

    @Override
    public void removeColumnWrap(ColumnWrap col) {
        int i;
        super.removeColumnWrap(col);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].removeData(col);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].removeData(col);
        }
    }

    @Override
    public void setPackedSubReportByteArray(FileInMemTable subFilesTable, Vector vec) {
        int i;
        super.setPackedSubReportByteArray(subFilesTable, vec);
        for (i = 0; this.dataHeader != null && i < this.dataHeader.length; ++i) {
            this.dataHeader[i].setPackedSubReportByteArray(subFilesTable, vec);
        }
        for (i = 0; this.dataFooter != null && i < this.dataFooter.length; ++i) {
            this.dataFooter[i].setPackedSubReportByteArray(subFilesTable, vec);
        }
    }

    @Override
    protected SubReportObject[] getSectionSubReports() {
        Vector sreports = new Vector();
        QbUtil.addArrayToVector(sreports, this.header.getSubReports());
        for (ReportSection element : this.dataHeader) {
            QbUtil.addArrayToVector(sreports, element.getSubReports());
        }
        for (ReportSection element : this.dataFooter) {
            QbUtil.addArrayToVector(sreports, element.getSubReports());
        }
        QbUtil.addArrayToVector(sreports, this.footer.getSubReports());
        SubReportObject[] tmp = new SubReportObject[sreports.size()];
        for (int i = 0; i < sreports.size(); ++i) {
            tmp[i] = (SubReportObject)sreports.elementAt(i);
        }
        return tmp;
    }

    @Override
    public void deleteSubReportColData() {
        super.deleteSubReportColData();
        for (ReportSection element : this.dataHeader) {
            element.deleteSubReportColData();
        }
        for (ReportSection element : this.dataFooter) {
            element.deleteSubReportColData();
        }
    }

    @Override
    public ReportChartObject[] getSectionReportChartObjects() {
        Vector charts = new Vector();
        QbUtil.addArrayToVector(charts, this.header.getReportChartObjects());
        for (ReportSection element : this.dataHeader) {
            QbUtil.addArrayToVector(charts, element.getReportChartObjects());
        }
        for (ReportSection element : this.dataFooter) {
            QbUtil.addArrayToVector(charts, element.getReportChartObjects());
        }
        QbUtil.addArrayToVector(charts, this.footer.getReportChartObjects());
        ReportChartObject[] tmp = new ReportChartObject[charts.size()];
        for (int i = 0; i < charts.size(); ++i) {
            tmp[i] = (ReportChartObject)charts.elementAt(i);
        }
        return tmp;
    }

    @Override
    protected ReportImage[] getSectionReportImages() {
        Vector images = new Vector();
        QbUtil.addArrayToVector(images, super.getSectionReportImages());
        for (ReportSection reportSection : this.dataHeader) {
            QbUtil.addArrayToVector(images, reportSection.getReportImages());
        }
        for (ReportSection reportSection : this.dataFooter) {
            QbUtil.addArrayToVector(images, reportSection.getReportImages());
        }
        return images.toArray(new ReportImage[images.size()]);
    }
}

