/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.CBAggrColFooter;
import quadbase.reportdesigner.ReportElements.CBColumnFooter;
import quadbase.reportdesigner.ReportElements.ColumnHeader;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.RBColumnHeader;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTitle;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.PageBufferGraphics;
import quadbase.reportdesigner.report.PageGraphics;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.SubReportUI;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.Dimension2D;
import quadbase.reportdesigner.util.ImageURLFormat;
import quadbase.reportdesigner.util.TextURLFormat;

public class ReportUI {
    private static final Logger LOGGER = Logger.getLogger(ReportUI.class.getName());
    Report report;
    double curX = 0.0;
    double curY = 0.0;
    double maxX = 0.0;
    Dimension2D pageSize;
    double pageHeight;
    Vector<ReportSection> sectionList;
    Vector<ReportTable> tableList;
    int totalPages = -1;
    int totalSections = 1;
    int page = 1;
    int section = 1;
    int pageSection = -1;
    public boolean designMode = false;
    public boolean previewEditWindow = false;
    public boolean enableImageMap = true;
    Vector imageMap;
    boolean doColumnWrap = false;
    int columnWrapCount = 0;
    int columnWrapInitialRow = 0;
    int columnWrapDisplayRow = 0;
    int lastDrawCol = 0;
    double columnWrapWidth = 0.0;
    double[] wrapInfo;
    double curMaxY;
    Graphics textGraphics;
    double pixelPerInch = -1.0;
    protected Hashtable<Font, Font> fontTable;
    private boolean forSubReport = false;
    protected Vector<Integer> treeStructure = null;
    private Vector<ReportElement> rowElements = null;
    private Hashtable<FormattedRowKey, FormattedRow> rows = null;
    private boolean rowFound = false;
    private int row = -1;
    private boolean sectionFound = false;
    private int headerFooterIndicator = -1;
    private boolean resetPageNumber = false;
    private int currentPageNumber = 1;
    private int pageCt = 1;
    private Hashtable<String, Integer> sectionTotalPagesTable = null;
    private String treeCopy = "";
    private boolean populateTable = true;
    protected int savedStartPage = 1;
    protected Vector<Integer> sectionTotalPages = null;
    protected Vector<Integer> sectionStartPage = null;
    protected Hashtable<Integer, int[]> pageLookup = null;
    Object[] previousRowValue;
    boolean[] previousRowIsBGColor2;
    boolean calculated = false;
    double pageHeaderH;
    boolean fit;
    boolean isCalcTotalSections = false;
    boolean fromPageViewer = false;
    boolean isDrawRepeatSection = false;
    boolean printMode = false;
    boolean titleAdjusted = false;
    double tableDataCellHeight = 0.3;
    int rowCount = 0;

    ReportUI() {
    }

    public ReportUI(Report report, Graphics textGraphics) throws Exception {
        this(report, textGraphics, true, false, false);
    }

    public ReportUI(Report report, Graphics textGraphics, boolean init) throws Exception {
        this(report, textGraphics, init, false, false);
    }

    public ReportUI(Report report, Graphics textGraphics, boolean init, boolean isFromPageViewer) throws Exception {
        this(report, textGraphics, init, isFromPageViewer, false);
    }

    public ReportUI(Report report, Graphics textGraphics, boolean init, boolean isFromPageViewer, boolean printMode) throws Exception {
        this.setPrintMode(printMode);
        this.report = report;
        this.textGraphics = textGraphics;
        this.resetFontTable();
        this.fromPageViewer = isFromPageViewer;
        if (init) {
            if (report != null && report.isResizeSubReportWidth()) {
                this.preCalcTotalSections();
            }
            this.init();
        }
    }

    public Object clone() {
        ReportUI reportUI = new ReportUI();
        reportUI.report = this.report;
        reportUI.curX = this.curX;
        reportUI.curY = this.curY;
        if (this.pageSize != null) {
            reportUI.pageSize = (Dimension2D)this.pageSize.clone();
        }
        reportUI.pageHeight = this.pageHeight;
        if (this.sectionList != null) {
            reportUI.sectionList = (Vector)this.sectionList.clone();
        }
        if (this.tableList != null) {
            reportUI.tableList = (Vector)this.tableList.clone();
        }
        reportUI.totalPages = this.totalPages;
        reportUI.totalSections = this.totalSections;
        reportUI.page = this.page;
        reportUI.section = this.section;
        reportUI.designMode = this.designMode;
        reportUI.enableImageMap = this.enableImageMap;
        if (this.imageMap != null) {
            reportUI.imageMap = (Vector)this.imageMap.clone();
        }
        reportUI.doColumnWrap = this.doColumnWrap;
        reportUI.columnWrapCount = this.columnWrapCount;
        reportUI.columnWrapInitialRow = this.columnWrapInitialRow;
        reportUI.columnWrapDisplayRow = this.columnWrapDisplayRow;
        reportUI.columnWrapWidth = this.columnWrapWidth;
        reportUI.textGraphics = this.textGraphics;
        reportUI.pixelPerInch = this.pixelPerInch;
        reportUI.forSubReport = this.forSubReport;
        reportUI.fontTable = this.fontTable;
        reportUI.pageHeaderH = this.pageHeaderH;
        reportUI.isDrawRepeatSection = this.isDrawRepeatSection;
        return reportUI;
    }

    public Hashtable<Font, Font> getFontTable() {
        return this.fontTable;
    }

    public void resetFontTable() {
        this.fontTable = new Hashtable();
    }

    protected int getCurrentPageNumber() {
        if (!this.resetPageNumber) {
            return this.getPage();
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.getPage())) {
            int[] pages = this.pageLookup.get(this.getPage());
            if (pages != null && pages.length == 2) {
                return pages[0];
            }
            return this.getPage();
        }
        return this.getPage();
    }

    protected int getCurrentTotalPageNumber() {
        if (!this.resetPageNumber) {
            return this.getTotalPages();
        }
        if (this.pageLookup != null && this.pageLookup.containsKey(this.getPage())) {
            int[] pages = this.pageLookup.get(this.getPage());
            if (pages != null && pages.length == 2) {
                return pages[1];
            }
            return this.getTotalPages();
        }
        return this.getTotalPages();
    }

    public int getPage() {
        return this.page;
    }

    public int getSection() {
        if (this.fromPageViewer && this.pageSection > 0) {
            return this.pageSection;
        }
        return this.section;
    }

    public void setPage(int p) {
        this.page = p;
    }

    public void setSection(int s) {
        this.section = s;
    }

    public void setPageSection(int s) {
        this.pageSection = s;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getTotalSections() {
        return this.totalSections;
    }

    public void resetPages() throws Exception {
        this.init();
    }

    public boolean isResetPageNumber() {
        return this.resetPageNumber;
    }

    private void resetSectionPages() {
        this.currentPageNumber = 1;
        this.treeCopy = "";
        this.pageCt = 1;
        this.populateTable = false;
        this.savedStartPage = 1;
    }

    public boolean preCalcTotalSections() throws Exception {
        this.setCalcTotalSections(true);
        boolean formatted = this.init();
        this.setCalcTotalSections(false);
        this.calculated = false;
        return formatted;
    }

    protected boolean init() throws Exception {
        Dimension2D reportSize;
        boolean formatted = false;
        if (!this.isDesignMode() && this.report.getInitializeReportError() != null) {
            this.pageHeaderH = 0.0;
            this.pageHeight = this.report.getPageHeight();
            this.pageSize = new Dimension2D(this.report.getActualPageWidth(), this.pageHeight);
            this.totalSections = 1;
            this.totalPages = 1;
            this.resetSectionPages();
            this.calculated = true;
            return formatted;
        }
        this.sectionTotalPagesTable = null;
        this.sectionTotalPages = null;
        this.sectionStartPage = null;
        this.populateTable = true;
        this.isDrawRepeatSection = false;
        this.report.formatTable();
        formatted = true;
        this.report.setNullDataOption(this.report.getNullDataOption(), true);
        ReportTable tbl = this.report.getReportTables().elementAt(0);
        ReportGraphics rpg = new ReportGraphics(this, this.textGraphics);
        rpg.setPrintMode(this.printMode);
        this.pageHeaderH = this.report.getPageHeader().hasNoDrawableData() ? 0.0 : this.resizeSection(rpg, this.report.getPageHeader(), tbl, this.treeStructure).getHeight();
        this.pageHeight = this.report.getPageHeight() - this.pageHeaderH - (this.report.getPageFooter().hasNoDrawableData() ? 0.0 : this.resizeSection(rpg, this.report.getPageFooter(), tbl, this.treeStructure).getHeight()) - this.report.getTopMargin() - this.report.getBottomMargin();
        this.pageSize = new Dimension2D(this.report.getActualPageWidth(), this.pageHeight);
        this.drawReport(rpg);
        if (this.report.isTocEnabled() && !this.report.getTableOfContentsObject().isUseGroups()) {
            this.drawReport(rpg);
        }
        this.totalSections = (reportSize = new Dimension2D(this.maxX, this.curY)).getWidth() - this.pageSize.getWidth() < 0.05 ? 1 : (int)Math.ceil(reportSize.getWidth() / this.pageSize.getWidth());
        if (!this.isCalcTotalSections() || this.fromPageViewer) {
            this.totalPages = (int)Math.ceil(reportSize.getHeight() / this.pageSize.getHeight());
        }
        this.currentPageNumber = 1;
        this.treeCopy = "";
        this.pageCt = 1;
        this.populateTable = false;
        this.populatePageLookupTable();
        this.resetSectionPages();
        this.calculated = true;
        return formatted;
    }

    public void initPageSize() throws Exception {
        this.sectionTotalPagesTable = null;
        this.sectionTotalPages = null;
        this.sectionStartPage = null;
        this.report.formatTable(this.isDesignMode());
        ReportTable tbl = this.report.getReportTables().elementAt(0);
        ReportGraphics rpg = new ReportGraphics(this, this.textGraphics);
        rpg.setPrintMode(this.printMode);
        this.pageHeight = this.report.getPageHeight() - (this.report.getPageHeader().hasNoDrawableData() ? 0.0 : this.resizeSection(rpg, this.report.getPageHeader(), tbl, this.treeStructure).getHeight()) - (this.report.getPageFooter().hasNoDrawableData() ? 0.0 : this.resizeSection(rpg, this.report.getPageFooter(), tbl, this.treeStructure).getHeight()) - this.report.getTopMargin() - this.report.getBottomMargin();
        this.pageSize = new Dimension2D(this.report.getActualPageWidth(), this.pageHeight);
    }

    protected void populatePageLookupTable() {
        if (this.sectionTotalPages == null || this.sectionStartPage == null) {
            return;
        }
        if (this.sectionTotalPages.size() != this.sectionStartPage.size()) {
            return;
        }
        if (this.sectionTotalPages.size() == 0) {
            return;
        }
        int count = this.sectionTotalPages.size();
        int lastSectionTotalPages = this.sectionTotalPages.elementAt(count - 1);
        int lastSectionStartPage = this.sectionStartPage.elementAt(count - 1);
        for (int i = count - 2; i >= 0; --i) {
            int nextSectionStartPage = this.sectionStartPage.elementAt(i);
            if (nextSectionStartPage == lastSectionStartPage) {
                this.sectionTotalPages.setElementAt(lastSectionTotalPages, i);
            }
            lastSectionTotalPages = this.sectionTotalPages.elementAt(i);
            lastSectionStartPage = this.sectionStartPage.elementAt(i);
        }
        this.pageLookup = new Hashtable();
        int nextStartPage = this.sectionStartPage.elementAt(0);
        int nextTotalPages = this.sectionTotalPages.elementAt(0);
        for (int i = 1; i <= this.totalPages; ++i) {
            if (i < nextStartPage) {
                this.pageLookup.put(i, new int[]{i, i});
                continue;
            }
            if (i != nextStartPage) continue;
            nextTotalPages = this.sectionTotalPages.remove(0);
            nextStartPage = this.sectionStartPage.remove(0);
            boolean flag = false;
            int j = 1;
            while (j <= nextTotalPages) {
                this.pageLookup.put(i, new int[]{j++, nextTotalPages});
                flag = true;
                ++i;
            }
            if (this.sectionTotalPages.size() > 0) {
                nextTotalPages = this.sectionTotalPages.elementAt(0);
                nextStartPage = this.sectionStartPage.elementAt(0);
            }
            if (!flag) continue;
            --i;
        }
    }

    public ReportGraphics getReportGraphics() {
        ReportGraphics rpg = new ReportGraphics(this, this.textGraphics);
        rpg.setPrintMode(this.printMode);
        return rpg;
    }

    public void drawGuideLine(PageGraphics g, ReportTable tbl, ReportElement elt) throws Exception {
        block3: {
            ReportCell[] cells;
            block2: {
                ReportImage[] chart;
                if (!(elt instanceof ReportTable)) break block2;
                for (ReportImage element : chart = ((ReportTable)elt).getImage()) {
                    if (!(element instanceof GuideLine)) continue;
                    g.drawCell(this.report, tbl, null, this.getReportCell(tbl, element), element.getX(), element.getY());
                }
                break block3;
            }
            if (!(elt instanceof ReportSection)) break block3;
            for (ReportCell cell : cells = ((ReportSection)elt).getCells()) {
                if (!(cell instanceof GuideLine)) continue;
                g.drawCell(this.report, tbl, cells, (ReportElement)this.getReportCell(tbl, cell), (ReportSection)elt, cell.getX(), cell.getY());
            }
        }
    }

    public void draw(Graphics g, int page, int section) throws Exception {
        this.setPage(page);
        this.setSection(section);
        this.resetSectionPages();
        this.draw(g);
    }

    private void draw(Graphics graphics) throws Exception {
        ReportTable table;
        if (this.report.reBuildTable() || this.report.isReformatTable()) {
            this.resetPages();
        }
        if (this.isImageMapEnabled()) {
            this.imageMap = new Vector();
        }
        PageGraphics rpg = new PageGraphics(this, graphics, this.report.getLeftMargin(), this.report.getTopMargin());
        rpg.drawPage(this.report.getSubFilesTable(), this.report.getPageWidth(), this.report.getPageHeight());
        Vector<ReportTable> vec = this.report.getReportTables();
        ReportTable reportTable = table = vec.size() > 0 ? vec.elementAt(0) : null;
        if (this.isDesignMode() || this.report.getInitializeReportError() == null) {
            this.drawPageSection(rpg, this.report.getPageHeader(), table);
            rpg.incCurY(this.curY);
        }
        try {
            ReportGraphics pgg = new ReportGraphics(this, graphics, this.report.getLeftMargin(), this.report.getTopMargin() + this.curY, (double)(this.section - 1) * this.pageSize.getWidth(), (double)(this.page - 1) * this.pageSize.getHeight(), this.pageSize.getWidth(), this.pageSize.getHeight());
            pgg.setPrintMode(this.printMode);
            this.rowFound = false;
            this.drawReport(pgg);
        }
        catch (Exception ex) {
            if (ex.getMessage().equals("finish")) {
                LOGGER.log(Level.WARNING, "Get out of draw at :" + this.currentPageNumber, ex);
            }
            LOGGER.log(Level.FINEST, "Failed to draw page content", ex);
            throw ex;
        }
        rpg.incCurY(this.pageSize.getHeight());
        if (this.isDesignMode() || this.report.getInitializeReportError() == null) {
            this.drawPageSection(rpg, this.report.getPageFooter(), table);
            if (ServerMessage.isEvalVersion()) {
                rpg.drawEvalStatement();
            }
        }
    }

    void drawPageSection(PageGraphics g, ReportSection section, ReportTable table) throws Exception {
        this.initCurrentPosition();
        this.drawSection(g, section, table);
    }

    void drawReport(ReportGraphics g) throws Exception {
        this.drawReport(g, 0);
    }

    public static ReportSection createErrorSection(double pageWidth, double pageHeight, String error) {
        ReportSection sec = new ReportSection();
        sec.setHeight(pageHeight - 0.2);
        ReportCell ops = new ReportCell("Oops...");
        ops.setFont(new Font("Dialog", 1, 15));
        ops.setAlign((short)1);
        ops.setVAlign((short)1);
        sec.addData(ops);
        ReportLine line = new ReportLine(false);
        line.setWidth(pageWidth);
        line.setY(ops.getHeight());
        sec.addData(line);
        ReportCell cell = new ReportCell(error);
        cell.setY(line.getY() + line.getHeight());
        cell.setHeight(sec.getHeight() - cell.getY() - 0.2);
        cell.setWidth(pageWidth);
        cell.setAlign((short)1);
        cell.setVAlign((short)1);
        sec.addData(cell);
        return sec;
    }

    void drawReport(ReportGraphics g, int drawPageSection) throws Exception {
        ReportTable table;
        this.initCurrentPosition();
        Vector<ReportTable> vec = this.report.getReportTables();
        ReportTable reportTable = table = vec.size() > 0 ? vec.elementAt(0) : null;
        if (!this.isDesignMode() && this.report.getInitializeReportError() != null) {
            this.drawSection(g, ReportUI.createErrorSection(this.pageSize.getWidth(), this.pageHeight, this.report.getInitializeReportError()), table);
        }
        if (drawPageSection != 0) {
            this.drawSection(g, this.report.getPageHeader(), table);
        }
        this.drawSection(g, this.report.getReportHeader(), table);
        for (int i = 0; i < vec.size(); ++i) {
            table = vec.elementAt(i);
            this.initRepeatSection();
            this.setColumnWrap();
            this.wrapInfo = new double[]{0.0, this.curY, this.curY};
            this.drawReportTable(g, table, 0, false);
            if (this.doColumnWrap && this.curY < this.curMaxY) {
                this.setCurY(this.curMaxY);
            }
            this.resetColumnWrap();
        }
        this.drawSection(g, this.report.getReportFooter(), table);
        if (drawPageSection != 0) {
            this.drawSection(g, this.report.getPageFooter(), table, drawPageSection > 0);
        }
        if (!(this instanceof SubReportUI)) {
            g.done();
        }
        this.rowCount = 0;
    }

    void setColumnWrap() {
        this.setColumnWrap(this.pageSize.getWidth());
    }

    void setColumnWrap(double pageWidth) {
        if (this.report.getReportType() != 0 && this.report.getReportType() != 4 && this.report.getReportType() != 1 || this.report.getColumnWrap() == null) {
            this.resetColumnWrap();
            return;
        }
        this.doColumnWrap = true;
        this.columnWrapWidth = this.report.getColumnWrap().getX();
        this.columnWrapCount = this.report.getColumnWrap().getWrapCount();
        int maxCt = (int)Math.floor(pageWidth / this.columnWrapWidth) - 1;
        if (this.columnWrapCount < 0 || this.columnWrapCount > maxCt) {
            this.columnWrapCount = maxCt;
        }
        if (this.columnWrapCount < 0) {
            this.columnWrapCount = 0;
        }
    }

    private void resetColumnWrap() {
        this.columnWrapWidth = 0.0;
        this.columnWrapCount = 0;
        this.doColumnWrap = false;
        this.resetColumnWrapTableUI();
    }

    private void resetColumnWrapTableUI() {
        this.columnWrapInitialRow = 0;
        this.columnWrapDisplayRow = 0;
    }

    private void drawReportTable(ReportGraphics g, ReportTable tbl, int level, boolean checkFitGroupOnPage) throws Exception {
        Bookmark entry;
        this.drawSection(g, tbl.getHeader(), tbl);
        if (this.report.isTocEnabled() && !this.calculated && !checkFitGroupOnPage && (entry = this.report.getTableOfContentsObject().getEntryByTree(this.treeStructure)) != null) {
            int page = (int)Math.ceil((this.curY + 0.001) / this.pageSize.getHeight());
            double y = this.curY % this.pageSize.getHeight();
            entry.setPageNumber(page);
            entry.setYPos(y);
            double tmp = this.getDrawablePageHeight() - this.getPageCurY();
            if (tmp < this.tableDataCellHeight) {
                entry.setPageNumber(page + 1);
                entry.setYPos(0.0);
            }
        }
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(tbl.getHeader(), tbl);
        }
        if (this.treeStructure == null) {
            this.treeStructure = new Vector();
        }
        if (tbl instanceof ReportTreeTable) {
            ReportTreeTable sTbl = (ReportTreeTable)tbl;
            for (int i = 0; i < this.countSubTable(sTbl); ++i) {
                int idx;
                this.treeStructure.addElement(i);
                int n = idx = sTbl.indexArray == null ? i : sTbl.indexArray[i];
                if (!(checkFitGroupOnPage || this.report.breakColIndex == null || this.report.breakColIndex.length <= level || this.report.colInfo[this.report.breakColIndex[level]].skipFirstValueForFitGroup() && i <= 0 || !this.report.colInfo[this.report.breakColIndex[level]].isFitGroupOnPage())) {
                    ReportGraphics rpg = new ReportGraphics(this, g.textG);
                    rpg.setPrintMode(this.printMode);
                    rpg.setDrawablePageSection(g.pageX, g.pageY, g.pageW, g.pageH);
                    rpg.setCurrentPosition(g.curX, g.curY);
                    double x = this.curX;
                    double y = this.curY;
                    this.fit = true;
                    boolean temp = this.calculated;
                    this.calculated = true;
                    this.drawReportTable(rpg, sTbl.getSubTable(idx), level + 1, true);
                    this.calculated = temp;
                    this.treeStructure.addElement(i);
                    this.curX = x;
                    this.curY = y;
                    if (!this.fit) {
                        this.pageBreak(g, null);
                    }
                }
                this.drawReportTable(g, sTbl.getSubTable(idx), level + 1, false);
            }
        } else {
            this.drawCells(g, tbl, checkFitGroupOnPage);
        }
        this.drawSection(g, tbl.getFooter(), tbl);
        this.addSectionTotalPagesTableEntry();
        if (this.treeStructure.size() > 1) {
            this.treeStructure.removeElementAt(this.treeStructure.size() - 1);
        } else {
            this.treeStructure.removeAllElements();
        }
        this.addSectionTotalPagesTableEntry();
        if (tbl.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
    }

    protected void addSectionTotalPagesTableEntry() {
        if (this.sectionTotalPagesTable != null && this.getTreeStringKey() != null && this.treeCopy.equals(this.getTreeStringKey()) && this.populateTable) {
            if (this.sectionTotalPagesTable.containsKey(this.getTreeStringKey())) {
                this.sectionTotalPages.removeElementAt(this.sectionTotalPages.size() - 1);
                this.sectionStartPage.removeElementAt(this.sectionStartPage.size() - 1);
            }
            this.sectionTotalPagesTable.put(this.getTreeStringKey(), this.currentPageNumber);
            this.sectionTotalPages.addElement(this.currentPageNumber);
            this.sectionStartPage.addElement(this.savedStartPage);
        }
    }

    private void drawCells(ReportGraphics g, ReportTable tbl, boolean checkFitGroupOnPage) throws Exception {
        this.drawCells(g, tbl, -1, this.treeStructure, -1, -1, checkFitGroupOnPage);
    }

    public int drawCells(ReportGraphics g, ReportTable tbl, int drawRow, Vector<Integer> tree, int x, int y) throws Exception {
        return this.drawCells(g, tbl, drawRow, tree, x, y, false);
    }

    public int drawCells(ReportGraphics g, ReportTable tbl, int drawRow, Vector<Integer> tree, int x, int y, boolean checkFitGroupOnPage) throws Exception {
        ReportCell sr;
        int j;
        int i;
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        if (tbl.getScriptObj() != null && !this.isDesignMode()) {
            bgColor = tbl.getBgColor();
            printOnNewPage = tbl.isPrintOnNewPage();
            visible = tbl.isVisible();
            tbl.getScriptObj().applyScript(tbl, this.getCurrentPageNumber(), this.getSection(), this.getCurrentTotalPageNumber(), this.getTotalSections(), this.report, tbl);
        }
        if (!tbl.isVisible() || tbl.isAggregationTable()) {
            return 0;
        }
        int r = -1;
        int nRow = tbl.getRowCount();
        if (this.isPrepareMode() && drawRow > -1 && nRow > drawRow) {
            nRow = drawRow + 1;
        } else if (this.isPrepareMode() && nRow >= 1) {
            nRow = 1;
        }
        ReportImage[] chart = tbl.getSortedImages();
        SubReportObject[] subReports = tbl.getSortedSubReports();
        ReportRTFObject[] rtfObjects = tbl.getSortedRTFObjects();
        double oldX = this.curX;
        double bottomYOfSection = 0.0;
        ReportSection mSection = tbl.getMasterSection();
        boolean drawMaster = mSection != null && mSection.isVisible() && mSection.getData() != null && (mSection.getCellCount() > 0 || this.isPrepareMode()) && mSection.getWidth() <= this.pageSize.getWidth() && mSection.getHeight() <= this.pageHeight;
        double wrapIndex = 0.0;
        if (this.wrapInfo != null) {
            wrapIndex = this.wrapInfo[0];
        }
        this.resetColumnWrapTableUI();
        ReportTable orgTable = tbl;
        ReportTable mainTable = this.report.getReportTables().elementAt(0);
        this.rows = drawRow == -1 ? mainTable.getFormattedRows() : orgTable.getFormattedRows();
        double temp_oldY = this.curY;
        ReportElement[] elts = tbl.getZSortedVisibleElements();
        if (elts == null) {
            return 0;
        }
        for (ReportElement elt : elts) {
            if (elt instanceof ReportColumn || elt instanceof ReportLine || elt instanceof ReportGrid) {
                elt.newArrayX(nRow);
                elt.newArrayY(nRow);
            }
            elt.setDrawAgain(false);
        }
        ReportElement[] relts = tbl.getXSortedVisibleElements();
        double[] rowShifts = null;
        double[] shifts = null;
        if (this.report.isCrossTabFixedField()) {
            relts = ReportElement.sortElement(relts, 1, true);
            Object[] objs = this.calculateRowShiftsForColumns(relts, orgTable);
            this.setCurX(oldX);
            relts = (ReportElement[])objs[0];
            rowShifts = (double[])objs[1];
            shifts = this.calculateShifts(relts, orgTable);
        } else {
            rowShifts = shifts = this.calculateShifts(relts, orgTable);
        }
        this.setCurX(oldX);
        int n = i = drawRow > -1 ? drawRow : 0;
        while (i < nRow) {
            int ii = i;
            boolean hasVisibleColumn = false;
            if (drawRow == -1 && tbl.indexArray != null) {
                ii = tbl.indexArray[i];
            }
            this.setCurX(oldX);
            if (!this.isPrepareMode()) {
                tbl = this.resizeTable(g, orgTable, ii, tree);
                chart = tbl.getSortedImages();
                subReports = tbl.getSortedSubReports();
                rtfObjects = tbl.getSortedRTFObjects();
            }
            if (this.rowElements != null || tbl.hasVisibleElements() || i <= 0) {
                int j2;
                if (!this.isPrepareMode() && tbl == orgTable) {
                    tbl = ReportUI.copySectionForSecuredInvisibleCols(tbl, this.report.getPreviewSecurityLevel());
                }
                ReportElement[] col = tbl.getSortedVisibleColumns();
                if (!this.isPrepareMode()) {
                    col = (ReportColumn[])ReportUI.takeAwaySecuredInvisibleCols(col, this.report.getPreviewSecurityLevel(), this.report.getReportType());
                }
                double tblH = tbl.getHeight();
                if (drawMaster && i == 0) {
                    double d = tblH = (mSection = this.resizeSection(g, mSection, tbl, this.treeStructure)).getHeight() + mSection.getY() > tblH ? mSection.getHeight() + mSection.getY() : tblH;
                }
                if (tbl.isPrintOnNewPage(this.rowCount)) {
                    this.pageBreak(g, null);
                } else {
                    this.pageBreak(g, tblH, i, checkFitGroupOnPage);
                }
                ++this.rowCount;
                if (i == 0) {
                    temp_oldY = this.curY;
                }
                if (this.wrapInfo != null) {
                    wrapIndex = this.wrapInfo[0];
                }
                if (this.totalPages == -1) {
                    this.lastDrawCol = (int)wrapIndex;
                }
                double delta = wrapIndex * this.columnWrapWidth;
                this.setCurX(oldX + delta);
                if (delta == 0.0) {
                    if (!(this instanceof SubReportUI)) {
                        this.drawTable(g, tbl);
                    } else {
                        ((SubReportUI)this).shift = 0.0;
                        for (double shift : shifts) {
                            ((SubReportUI)this).shift += shift;
                        }
                        this.drawTable(g, tbl);
                        ((SubReportUI)this).shift = 0.0;
                    }
                    if (mSection != null && drawMaster && (this.curY >= temp_oldY + mSection.getY() + mSection.getHeight() || i == nRow - 1)) {
                        double newY = this.curY;
                        this.setCurX(oldX);
                        this.setCurY(temp_oldY);
                        this.sectionBreak(mSection.getX(), mSection.getWidth());
                        this.drawMasterSection(g, this.report, tbl, mSection, mSection.getX() + this.curX, mSection.getY() + this.curY);
                        if (bottomYOfSection < this.curY + mSection.getY() + mSection.getHeight()) {
                            bottomYOfSection = this.curY + mSection.getY() + mSection.getHeight();
                        }
                        drawMaster = false;
                        this.setCurY(newY);
                        this.setCurX(oldX);
                    }
                }
                for (j2 = 0; j2 < relts.length; ++j2) {
                    ReportCell newCell;
                    if (!(relts[j2] instanceof ReportColumn)) continue;
                    ReportElement column = (ReportColumn)relts[j2];
                    for (ReportElement element : col) {
                        if (!column.getID().equals(element.getID())) continue;
                        column = element;
                        break;
                    }
                    double cell_X = column.getX();
                    ReportElement relt = ((ReportColumn)column).getFormatCell(ii);
                    try {
                        cell_X = relt.getX();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Invalid number", ex);
                    }
                    if (this.skipCell(column)) continue;
                    this.setCurX(oldX + delta);
                    for (int l = 0; l < j2; ++l) {
                        if (!(relts[l].getY() <= relts[j2].getY() && relts[l].getY() + relts[l].getHeight() > relts[j2].getY()) && (!(relts[l].getY() >= relts[j2].getY()) || !(relts[l].getY() < relts[j2].getY() + relts[j2].getHeight()))) continue;
                        this.incCurX(rowShifts[l]);
                    }
                    this.incCurX(rowShifts[j2]);
                    if (this instanceof SubReportUI) {
                        ((SubReportUI)this).shift += rowShifts[j2];
                    }
                    this.setPageW(cell_X);
                    if (relt instanceof ReportImage || relt instanceof ReportDocument) {
                        newCell = this.getReportCell(tbl, (ReportCell)relt, ii);
                        g.drawCell(this.report, tbl, null, newCell, newCell.getX() + this.curX, newCell.getY() + this.curY);
                        column.setDrawX(ii, newCell.getX() + this.curX);
                        column.setDrawY(ii, newCell.getY() + this.curY);
                        column.setDrawAgain(true);
                        continue;
                    }
                    newCell = tbl.formatCell((ReportColumn)column, ii, this.getCurrentPageNumber(), this.getSection(), this.getCurrentTotalPageNumber(), this.getTotalSections(), i - this.columnWrapDisplayRow * (int)wrapIndex - this.columnWrapCount * this.columnWrapInitialRow, this.report, this.isDesignMode());
                    if (newCell != null && newCell.getBookmark() != null && this.report.isTocEnabled()) {
                        Bookmark entry = this.report.getTableOfContentsObject().addBookmark(newCell.getBookmark());
                        int page = (int)Math.ceil((this.curY + newCell.getY()) / this.pageSize.getHeight());
                        double yPos = (this.curY + newCell.getY()) % this.pageSize.getHeight();
                        entry.setPageNumber(page);
                        entry.setYPos(yPos);
                    }
                    if (newCell == null) continue;
                    if (newCell.isVisible()) {
                        hasVisibleColumn = true;
                    }
                    g.drawCell(this.report, tbl, null, (ReportElement)newCell, newCell.getX() + this.curX, newCell.getY() + this.curY, ii);
                    if (newCell.getDataFormat() instanceof BarcodeFormat) {
                        column.setWidth(newCell.getWidth());
                        column.setHeight(newCell.getHeight());
                    }
                    column.setDrawX(ii, newCell.getX() + this.curX);
                    column.setDrawY(ii, newCell.getY() + this.curY);
                    column.setDrawAgain(true);
                    this.tableDataCellHeight = newCell.getHeight();
                }
                if (this.rowElements != null) {
                    for (j2 = 0; j2 < this.rowElements.size(); ++j2) {
                        ReportCell newCell;
                        ReportElement elt = this.rowElements.elementAt(j2);
                        if (drawRow > -1 && drawRow == ii) {
                            newCell = this.getReportCell(tbl, (ReportCell)elt, ii);
                            g.drawCell(this.report, tbl, null, newCell, newCell.getX(), newCell.getY());
                            continue;
                        }
                        newCell = this.getReportCell(tbl, (ReportCell)elt, ii);
                        g.drawCell(this.report, tbl, null, newCell, newCell.getX() + this.curX, newCell.getY() + this.curY);
                    }
                }
                this.setCurX(oldX + delta);
                for (j2 = 0; j2 < relts.length; ++j2) {
                    ReportCell newCell;
                    ReportImage img;
                    if (!(relts[j2] instanceof ReportImage) || this.skipCell(img = (ReportImage)relts[j2])) continue;
                    this.setCurX(oldX + delta);
                    for (int l = 0; l < j2; ++l) {
                        if (!(relts[l].getY() <= relts[j2].getY() && relts[l].getY() + relts[l].getHeight() > relts[j2].getY()) && (!(relts[l].getY() >= relts[j2].getY()) || !(relts[l].getY() < relts[j2].getY() + relts[j2].getHeight()))) continue;
                        this.incCurX(rowShifts[l]);
                    }
                    this.incCurX(rowShifts[j2]);
                    if (this instanceof SubReportUI) {
                        ((SubReportUI)this).shift += rowShifts[j2];
                    }
                    this.setPageW(img.getX());
                    int k = 0;
                    for (k = 0; k < chart.length; ++k) {
                        if (!chart[k].getID().equals(img.getID())) continue;
                        img = chart[k];
                        break;
                    }
                    if (!(img instanceof ReportLine) && !(img instanceof ReportGrid) || !this.isPrepareMode() && !tbl.drawChart(ii, k) || (newCell = this.getReportCell(tbl, img, ii)) == null) continue;
                    g.drawCell(this.report, tbl, null, newCell, newCell.getX() + this.curX, newCell.getY() + this.curY);
                    img.setDrawX(ii, newCell.getX() + this.curX);
                    img.setDrawY(ii, newCell.getY() + this.curY);
                    img.setDrawAgain(true);
                }
                double oldY = this.curY;
                if (tbl.hasVisibleElements() && hasVisibleColumn) {
                    this.incCurY(tbl.getHeight());
                }
                if ((x != -1 || y != -1) && y <= QbUtil.toPixel(this.pageSize.getHeight() * (double)this.page)) {
                    int y_old = QbUtil.toPixel(oldY);
                    int y_cur = QbUtil.toPixel(this.curY);
                    if (y < y_old) break;
                    if (y_old <= y && y < y_cur) {
                        r = ii;
                        break;
                    }
                }
            }
            ++i;
        }
        double bottomY = this.curY;
        this.setCurX(oldX);
        for (j = 0; j < relts.length; ++j) {
            if (!(relts[j] instanceof ReportImage)) continue;
            ReportImage img = (ReportImage)relts[j];
            for (ReportImage element : chart) {
                if (!element.getID().equals(img.getID())) continue;
                img = element;
                break;
            }
            this.setCurY(temp_oldY);
            this.pageBreak(g, img.getY() + img.getHeight(), null);
            if (this.skipCell(img)) continue;
            this.setCurX(oldX);
            for (int l = 0; l < j; ++l) {
                if (!(relts[l].getY() <= relts[j].getY() && relts[l].getY() + relts[l].getHeight() > relts[j].getY()) && (!(relts[l].getY() >= relts[j].getY()) || !(relts[l].getY() < relts[j].getY() + relts[j].getHeight()))) continue;
                this.incCurX(rowShifts[l]);
            }
            this.incCurX(rowShifts[j]);
            if (this instanceof SubReportUI) {
                ((SubReportUI)this).shift += rowShifts[j];
            }
            this.setPageW(img.getX());
            if (img instanceof ReportLine || img instanceof ReportGrid) continue;
            double printY = img.getY() + temp_oldY;
            if (this.curY > printY) {
                printY = this.curY;
            }
            if (!g.isDrawEnabled(printY)) continue;
            ReportCell newCell = this.getReportCell(orgTable, img);
            double[] d = g.drawCell(this.report, orgTable, null, newCell, newCell.getX() + this.curX, printY);
            img.setDrawX(newCell.getX() + this.curX);
            img.setDrawY(printY);
            img.setDrawAgain(true);
            if (d == null || !(bottomYOfSection < printY + img.getHeight())) continue;
            bottomYOfSection = printY + img.getHeight();
        }
        this.setCurX(oldX);
        for (j = 0; j < relts.length; ++j) {
            if (!(relts[j] instanceof SubReportObject)) continue;
            this.setCurY(temp_oldY);
            sr = (SubReportObject)relts[j];
            for (SubReportObject subReport : subReports) {
                if (!subReport.getID().equals(sr.getID())) continue;
                sr = subReport;
                break;
            }
            this.pageBreak(g, sr.getY() + sr.getHeight(), null);
            if (this.skipCell(sr)) continue;
            this.setCurX(oldX);
            for (int l = 0; l < j; ++l) {
                if (!(relts[l].getY() <= relts[j].getY() && relts[l].getY() + relts[l].getHeight() > relts[j].getY()) && (!(relts[l].getY() >= relts[j].getY()) || !(relts[l].getY() < relts[j].getY() + relts[j].getHeight()))) continue;
                this.incCurX(rowShifts[l]);
            }
            if (this instanceof SubReportUI) {
                ((SubReportUI)this).shift += rowShifts[j];
            }
            this.setPageW(sr.getX());
            double printY = sr.getY() + temp_oldY;
            if (this.curY > printY) {
                printY = this.curY;
            }
            double bY = printY + sr.getHeight();
            if (g.isDrawEnabled(this.curY + sr.getY()) || !this.isPrepareMode() && sr.isResizeToFitContent()) {
                ReportCell newCell = this.getReportCell(orgTable, sr);
                double[] res = g.drawCell(this.report, orgTable, null, newCell, newCell.getX() + this.curX, printY);
                if (res != null) {
                    bY = res[0];
                }
                sr.setDrawX(newCell.getX() + this.curX);
                sr.setDrawY(printY);
                sr.setDrawAgain(true);
            }
            if (bottomYOfSection < bY) {
                bottomYOfSection = bY;
            }
            this.incCurX(rowShifts[j]);
        }
        this.setCurX(oldX);
        for (j = 0; j < relts.length; ++j) {
            if (!(relts[j] instanceof ReportRTFObject)) continue;
            this.setCurY(temp_oldY);
            sr = (ReportRTFObject)relts[j];
            for (ReportRTFObject rtfObject : rtfObjects) {
                if (!rtfObject.getID().equals(sr.getID())) continue;
                sr = rtfObject;
                break;
            }
            this.pageBreak(g, sr.getY() + sr.getHeight(), null);
            if (this.skipCell(sr)) continue;
            this.setCurX(oldX);
            for (int l = 0; l < j; ++l) {
                if (!(relts[l].getY() <= relts[j].getY() && relts[l].getY() + relts[l].getHeight() > relts[j].getY()) && (!(relts[l].getY() >= relts[j].getY()) || !(relts[l].getY() < relts[j].getY() + relts[j].getHeight()))) continue;
                this.incCurX(rowShifts[l]);
            }
            this.incCurX(rowShifts[j]);
            if (this instanceof SubReportUI) {
                ((SubReportUI)this).shift += rowShifts[j];
            }
            this.setPageW(sr.getX());
            double printY = sr.getY() + temp_oldY;
            if (this.curY > printY) {
                printY = this.curY;
            }
            double bY = printY + sr.getHeight();
            if (g.isDrawEnabled(this.curY + sr.getY()) || sr.isResizeToFitContent()) {
                ReportCell newCell = this.getReportCell(orgTable, sr);
                double[] res = g.drawCell(this.report, orgTable, null, newCell, newCell.getX() + this.curX, printY);
                if (res != null) {
                    bY = res[0];
                }
                sr.setDrawX(newCell.getX() + this.curX);
                sr.setDrawY(printY);
                sr.setDrawAgain(true);
            }
            if (!(bottomYOfSection < bY)) continue;
            bottomYOfSection = bY;
        }
        if (this.doColumnWrap) {
            this.curMaxY = this.wrapInfo != null && bottomY < this.wrapInfo[2] ? this.wrapInfo[2] : bottomY;
        }
        if (this.wrapInfo != null) {
            wrapIndex = this.wrapInfo[0];
        }
        for (ReportElement elt : elts) {
            if (elt.getZ() <= 0) continue;
            if (elt instanceof ReportColumn) {
                int j3;
                ReportColumn column = (ReportColumn)elt;
                int n2 = j3 = drawRow > -1 ? drawRow : 0;
                while (j3 < nRow) {
                    ReportCell newCell;
                    ReportElement relt;
                    int ii = j3;
                    if (drawRow == -1 && tbl.indexArray != null) {
                        ii = tbl.indexArray[j3];
                    }
                    if ((relt = column.getFormatCell(ii)) instanceof ReportImage || relt instanceof ReportDocument) {
                        newCell = this.getReportCell(tbl, (ReportCell)relt, ii);
                        if (column.getDrawY(ii) != -1.0 && column.isDrawAgain()) {
                            g.drawCell(this.report, tbl, null, newCell, column.getDrawX(ii), column.getDrawY(ii));
                        }
                    } else {
                        newCell = tbl.formatCell(column, ii, j3 - this.columnWrapDisplayRow * (int)wrapIndex - this.columnWrapCount * this.columnWrapInitialRow, this.report, this.isDesignMode());
                        if (column.getDrawY(ii) != -1.0 && column.isDrawAgain()) {
                            g.drawCell(this.report, tbl, null, (ReportElement)newCell, column.getDrawX(ii), column.getDrawY(ii), ii);
                        }
                    }
                    ++j3;
                }
                continue;
            }
            if (elt instanceof ReportLine || elt instanceof ReportGrid) {
                int j4;
                int n3 = j4 = drawRow > -1 ? drawRow : 0;
                while (j4 < nRow) {
                    ReportCell newCell = this.getReportCell(tbl, (ReportCell)elt);
                    if (elt.isDrawAgain()) {
                        g.drawCell(this.report, tbl, null, newCell, elt.getDrawX(j4), elt.getDrawY(j4));
                    }
                    ++j4;
                }
                continue;
            }
            if (!(elt instanceof ReportImage) && !(elt instanceof TableOfContents) && !(elt instanceof SubReportObject) && !(elt instanceof ReportRTFObject)) continue;
            ReportCell newCell = this.getReportCell(orgTable, (ReportCell)elt);
            if (!elt.isDrawAgain()) continue;
            g.drawCell(this.report, tbl, null, newCell, elt.getDrawX(), elt.getDrawY());
        }
        this.forcePageBreak(g, bottomY, bottomYOfSection, null);
        this.rows = null;
        if (tbl.getScriptObj() != null && !this.isDesignMode()) {
            tbl.setBgColor(bgColor);
            tbl.setPrintOnNewPage(printOnNewPage);
            tbl.setVisible(visible);
        }
        this.setCurX(oldX);
        return r;
    }

    private void forcePageBreak(ReportGraphics g, double bottomY, double bottomYOfSection, ReportSection section) throws Exception {
        if (bottomY < bottomYOfSection) {
            this.setCurY(bottomY);
            while (!this.isDesignMode() && bottomYOfSection > (Math.floor(this.curY / this.getDrawablePageHeight()) + 1.0) * this.getDrawablePageHeight()) {
                double oldY = this.curY;
                while (oldY == this.curY && bottomYOfSection > (Math.floor(this.curY / this.getDrawablePageHeight()) + 1.0) * this.getDrawablePageHeight()) {
                    this.pageBreak(g, section);
                    if (oldY != this.curY) continue;
                    this.curY += 0.1;
                    oldY = this.curY;
                }
                this.curY += 0.1;
            }
            bottomY = bottomYOfSection;
        }
        this.setCurY(bottomY);
    }

    public void drawSection(ReportGraphics g, ReportSection cellArray, ReportTable tbl) throws Exception {
        this.drawSection(g, cellArray, tbl, true, -1, -1, this.treeStructure);
    }

    public void drawSection(ReportGraphics g, ReportSection cellArray, ReportTable tbl, boolean checkPageBreak) throws Exception {
        this.drawSection(g, cellArray, tbl, checkPageBreak, -1, -1, this.treeStructure);
    }

    public void drawSection(ReportGraphics g, ReportSection cellArray, ReportTable tbl, Vector<Integer> tree) throws Exception {
        this.drawSection(g, cellArray, tbl, true, -1, -1, tree);
    }

    public boolean drawSection(ReportGraphics g, ReportSection section, ReportTable tbl, boolean checkPageBreak, int x, int y, Vector<Integer> tree) throws Exception {
        if (!this.titleAdjusted) {
            this.titleAdjusted = this.adjustReportTitle(g, this.report.getReportHeader());
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        double sectionHeight = 0.0;
        if (section.getScriptObj() != null && !this.isDesignMode()) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            sectionHeight = section.getHeight();
            section.getScriptObj().applyScript(tbl, this.getCurrentPageNumber(), this.getSection(), this.getCurrentTotalPageNumber(), this.getTotalSections(), this.report, section);
        }
        boolean state = this.drawSectionHelper(g, section, tbl, checkPageBreak, x, y, tree);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            ReportSection child = section.getSection(i);
            child.setRepeatOnEveryPage(section.isRepeatOnEveryPage());
            this.drawSection(g, child, tbl, checkPageBreak, x, y, tree);
        }
        if (section.getScriptObj() != null && !this.isDesignMode()) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
            section.setHeight(sectionHeight);
        }
        return state;
    }

    private boolean isFirstValue() {
        int[] intArray;
        if (this.isPrepareMode()) {
            return false;
        }
        if (this.treeStructure == null) {
            return false;
        }
        for (int element : intArray = QbUtil.convertVectorToIntArray(this.treeStructure)) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    private boolean printOnNewPage(ReportSection section) {
        return section.isResetPageNumber() ? !(section.isPrintOnNewPage() && section.isSkipFirstValue() && this.isFirstValue() || section.isPrintOnNewPage() && section.isSkipFirstGroupValue() && this.getCurrentSectionID() == 0) : !(!section.isPrintOnNewPage() || section.isSkipFirstValue() && this.isFirstValue() || section.isSkipFirstGroupValue() && this.getCurrentSectionID() == 0);
    }

    public static ReportSection copySectionForSecuredInvisibleCols(ReportSection _sec, ReportTable _tbl, String previewSecurityLevel) {
        boolean copySection = ReportUI.containsSecuredInvisibleCols(_tbl, previewSecurityLevel, true);
        if (!copySection) {
            ReportCell[] cells;
            for (ReportCell cell : cells = _sec.getCells()) {
                ReportElement secLvl = cell.getSecurityLevel(previewSecurityLevel);
                if (secLvl == null || secLvl.isVisible() || !secLvl.isShiftSecuredColX()) continue;
                copySection = true;
                break;
            }
        }
        if (!copySection) {
            return _sec;
        }
        ReportSection sec = new ReportSection();
        sec.deepCopy(_sec);
        return sec;
    }

    private static boolean containsSecuredInvisibleCols(ReportTable tbl, String previewSecurityLevel, boolean checkHeaderAndFooter) {
        ReportTable _tbl = null;
        if (tbl instanceof ReportTreeTable) {
            _tbl = ((ReportTreeTable)tbl).getFirstTable();
        }
        if (_tbl == null) {
            _tbl = tbl;
        }
        ReportElement[] cells = _tbl.getAllTableElements();
        boolean copySection = false;
        for (ReportElement cell : cells) {
            ReportElement secLvl = cell.getSecurityLevel(previewSecurityLevel);
            if (secLvl == null || secLvl.isVisible() || !secLvl.isShiftSecuredColX() || checkHeaderAndFooter && !secLvl.isShiftSecuredColXIncludeHeaderAndFooter()) continue;
            copySection = true;
            break;
        }
        return copySection;
    }

    public static ReportTable copySectionForSecuredInvisibleCols(ReportTable _tbl, String previewSecurityLevel) {
        boolean copySection = ReportUI.containsSecuredInvisibleCols(_tbl, previewSecurityLevel, false);
        if (!copySection) {
            return _tbl;
        }
        ReportTable tbl = new ReportTable();
        for (int j = 0; j < _tbl.getColumnCount(); ++j) {
            tbl.addColumn(new ReportColumn());
        }
        tbl.deepCopy(_tbl);
        return tbl;
    }

    static double[] backupXPos(ReportElement[] cells) {
        double[] tmp = new double[cells.length];
        for (int i = 0; i < cells.length; ++i) {
            tmp[i] = cells[i].getX();
        }
        return tmp;
    }

    static void recoverXPos(ReportElement[] cells, double[] recoverXPos) {
        for (int i = 0; i < cells.length; ++i) {
            cells[i].setXX(recoverXPos[i], true);
        }
    }

    public static ReportElement[] takeAwaySecuredInvisibleCols(ReportElement[] cells, ReportTable _tbl, String previewSecurityLevel, int reportType) {
        ReportColumn[] cols;
        ReportTable newTbl = null;
        if (_tbl instanceof ReportTreeTable) {
            newTbl = ((ReportTreeTable)_tbl).getFirstTable();
        }
        if (newTbl == null) {
            newTbl = _tbl;
        }
        for (ReportColumn col : cols = _tbl.getSortedVisibleColumns()) {
            ReportElement secLvl = col.getSecurityLevel(previewSecurityLevel);
            if (secLvl == null || secLvl.isVisible() || !secLvl.isShiftSecuredColX() || !secLvl.isShiftSecuredColXIncludeHeaderAndFooter()) continue;
            for (ReportElement cell : cells) {
                if (cell.getX() == secLvl.getX() && cell.getWidth() == secLvl.getWidth()) {
                    cell.setVisible(false);
                    continue;
                }
                if (!ReportUI.greaterThan(cell.getX(), secLvl.getX() + secLvl.getWidth())) continue;
                cell.setX(cell.getX() - secLvl.getWidth());
            }
        }
        return ReportUI.takeAwaySecuredInvisibleCols(cells, previewSecurityLevel, reportType);
    }

    private static boolean greaterThan(double a, double b) {
        return a > b || Math.abs(a - b) < 1.0E-5;
    }

    public static ReportElement[] takeAwaySecuredInvisibleCols(ReportElement[] cells, String previewSecurityLevel, int reportType) {
        for (int i = 0; i < cells.length; ++i) {
            ReportElement secLvl;
            if (!cells[i].isVisible() || (secLvl = cells[i].getSecurityLevel(previewSecurityLevel)) == null || secLvl.isVisible() || !secLvl.isShiftSecuredColX()) continue;
            for (int j = i + 1; j < cells.length; ++j) {
                if (reportType == 3 && cells[j].getY() != secLvl.getY()) continue;
                cells[j].setX(cells[j].getX() - cells[i].getWidth());
            }
        }
        return cells;
    }

    public static Vector removeSecuredInvisibleCols(Vector rows, ReportTable tbl, String previewSecurityLevel) {
        Vector<ReportElement[]> res = new Vector<ReportElement[]>();
        try {
            for (int k = 0; k < rows.size(); ++k) {
                Object cells = rows.elementAt(k);
                if (cells instanceof ReportColumn[]) {
                    res.addElement(ReportUI.removeSecuredInvisibleCols((ReportColumn[])cells, previewSecurityLevel));
                    continue;
                }
                if (cells instanceof ReportCell[]) {
                    res.addElement(ReportUI.removeSecuredInvisibleCells((ReportCell[])cells, tbl, previewSecurityLevel));
                    continue;
                }
                if (!(cells instanceof ReportElement[])) continue;
                res.addElement(ReportUI.removeSecuredInvisibleElts((ReportElement[])cells, tbl, previewSecurityLevel));
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot remove invisible columns", ex);
        }
        return res;
    }

    public static ReportColumn[] removeSecuredInvisibleCols(ReportColumn[] cells, String previewSecurityLevel) {
        Vector<ReportColumn> tmp = new Vector<ReportColumn>();
        for (ReportColumn cell : cells) {
            ReportElement secLvl = cell.getSecurityLevel(previewSecurityLevel);
            if (secLvl != null && !secLvl.isVisible() && secLvl.isShiftSecuredColX()) continue;
            tmp.addElement(cell);
        }
        if (tmp.size() == cells.length) {
            return cells;
        }
        ReportColumn[] tmp2 = new ReportColumn[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            tmp2[i] = (ReportColumn)tmp.elementAt(i);
        }
        return tmp2;
    }

    private static ReportCell[] removeSecuredInvisibleCells(ReportCell[] cells, ReportTable _tbl, String previewSecurityLevel) {
        boolean[] visibleElt = null;
        if (_tbl != null) {
            ReportTable newTbl = null;
            if (_tbl instanceof ReportTreeTable) {
                newTbl = ((ReportTreeTable)_tbl).getFirstTable();
            }
            if (newTbl == null) {
                newTbl = _tbl;
            }
            ReportColumn[] cols = _tbl.getSortedVisibleColumns();
            visibleElt = new boolean[cells.length];
            for (int i = 0; i < visibleElt.length; ++i) {
                visibleElt[i] = true;
            }
            for (ReportColumn col : cols) {
                ReportElement secLvl = col.getSecurityLevel(previewSecurityLevel);
                if (secLvl == null || secLvl.isVisible() || !secLvl.isShiftSecuredColX() || !secLvl.isShiftSecuredColXIncludeHeaderAndFooter()) continue;
                for (int j = 0; j < cells.length; ++j) {
                    if (cells[j].getX() != secLvl.getX() || cells[j].getWidth() != secLvl.getWidth()) continue;
                    visibleElt[j] = false;
                }
            }
        }
        Vector<ReportCell> tmp = new Vector<ReportCell>();
        for (int i = 0; i < cells.length; ++i) {
            ReportElement secLvl;
            if (visibleElt != null && !visibleElt[i] || (secLvl = cells[i].getSecurityLevel(previewSecurityLevel)) != null && !secLvl.isVisible() && secLvl.isShiftSecuredColX()) continue;
            tmp.addElement(cells[i]);
        }
        if (tmp.size() == cells.length) {
            return cells;
        }
        ReportCell[] tmp2 = new ReportCell[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            tmp2[i] = (ReportCell)tmp.elementAt(i);
        }
        return tmp2;
    }

    private static ReportElement[] removeSecuredInvisibleElts(ReportElement[] cells, ReportTable _tbl, String previewSecurityLevel) {
        boolean[] visibleElt = null;
        if (_tbl != null) {
            ReportTable newTbl = null;
            if (_tbl instanceof ReportTreeTable) {
                newTbl = ((ReportTreeTable)_tbl).getFirstTable();
            }
            if (newTbl == null) {
                newTbl = _tbl;
            }
            ReportColumn[] cols = _tbl.getSortedVisibleColumns();
            visibleElt = new boolean[cells.length];
            for (int i = 0; i < visibleElt.length; ++i) {
                visibleElt[i] = true;
            }
            for (ReportColumn col : cols) {
                ReportElement secLvl = col.getSecurityLevel(previewSecurityLevel);
                if (secLvl == null || secLvl.isVisible() || !secLvl.isShiftSecuredColX() || !secLvl.isShiftSecuredColXIncludeHeaderAndFooter()) continue;
                for (int j = 0; j < cells.length; ++j) {
                    if (cells[j].getX() != secLvl.getX() || cells[j].getWidth() != secLvl.getWidth()) continue;
                    visibleElt[j] = false;
                }
            }
        }
        Vector<ReportElement> tmp = new Vector<ReportElement>();
        for (int i = 0; i < cells.length; ++i) {
            ReportElement secLvl;
            if (visibleElt != null && !visibleElt[i] || (secLvl = cells[i].getSecurityLevel(previewSecurityLevel)) != null && !secLvl.isVisible() && secLvl.isShiftSecuredColX()) continue;
            tmp.addElement(cells[i]);
        }
        if (tmp.size() == cells.length) {
            return cells;
        }
        ReportElement[] tmp2 = new ReportElement[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            tmp2[i] = (ReportElement)tmp.elementAt(i);
        }
        return tmp2;
    }

    private boolean drawSectionHelper(ReportGraphics g, ReportSection section, ReportTable tbl, boolean checkPageBreak, int x, int y, Vector<Integer> tree) throws Exception {
        ReportSection cellArray;
        if (this.isDesignMode()) {
            this.drawTable(g, section);
        }
        if (section == null || !section.isVisible()) {
            return false;
        }
        if (section.isResetPageNumber()) {
            this.resetPageNumber = true;
            this.treeCopy = this.getTreeStringKey();
            if (this.sectionTotalPagesTable == null) {
                this.sectionTotalPagesTable = new Hashtable();
            }
            if (this.sectionTotalPages == null) {
                this.sectionTotalPages = new Vector();
            }
            if (this.sectionStartPage == null) {
                this.sectionStartPage = new Vector();
            }
        }
        if (!this.isDrawRepeatSection && this.printOnNewPage(section)) {
            this.setPrintOnNewPage(g, section);
        }
        if (!this.isDesignMode() && (section.getData() == null || section.hasNoDrawableData(tree))) {
            return false;
        }
        boolean doColumnWrap_BAK = this.doColumnWrap;
        int totalDrawCol = this.columnWrapCount;
        boolean repeatTableHeader = false;
        if (section == this.report.getPageHeader() || section == this.report.getPageFooter() || section == this.report.getReportHeader() || section == this.report.getReportFooter() || section.getID().startsWith("RPT_HDR") || section.getID().startsWith("RPT_FTR") || section.getTOC() != null) {
            this.doColumnWrap = false;
            totalDrawCol = 0;
        } else if (section.getID().equals("TBL0_HDR")) {
            repeatTableHeader = true;
            if (this.totalPages == this.currentPageNumber) {
                totalDrawCol = this.lastDrawCol;
            }
        } else {
            totalDrawCol = 0;
        }
        if (!this.isPrepareMode()) {
            cellArray = this.resizeSection(g, section, tbl, tree);
            if (checkPageBreak) {
                this.pageBreak(g, cellArray.getHeight(), section);
            }
        } else {
            cellArray = new ReportSection();
            cellArray.copy(section);
        }
        double oldX = this.curX;
        if (!this.isPrepareMode() && cellArray == section) {
            cellArray = ReportUI.copySectionForSecuredInvisibleCols(section, tbl, this.report.getPreviewSecurityLevel());
        }
        ReportElement[] cells = cellArray.sortCell(1, true);
        if (!this.isPrepareMode()) {
            cells = (ReportCell[])ReportUI.takeAwaySecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel(), this.report.getReportType());
        }
        double[] rowShifts = null;
        double[] shifts = null;
        if (this.report.isCrossTabFixedField()) {
            cells = this.splitCells(cells);
            cells = (ReportCell[])ReportElement.sortElement(cells, 1, true);
            Object[] objectArray = this.calculateRowShifts(cells, tbl);
            this.setCurX(oldX);
            cells = (ReportCell[])objectArray[0];
            rowShifts = (double[])objectArray[1];
            shifts = this.calculateShifts(cells, tbl);
        } else {
            rowShifts = shifts = this.calculateShifts(cells, tbl);
        }
        this.setCurX(oldX);
        if (!this.isPrepareMode()) {
            if (this instanceof SubReportUI) {
                for (double shift : shifts) {
                    ((SubReportUI)this).shift += shift;
                }
                this.drawTable(g, cellArray);
                ((SubReportUI)this).shift = 0.0;
            }
            this.drawTable(g, cellArray);
        }
        double d = 0.0;
        for (int curArea = 0; curArea <= totalDrawCol; ++curArea) {
            int i;
            double delta = 0.0;
            if (repeatTableHeader) {
                delta = (double)curArea * this.columnWrapWidth;
            } else if (this.doColumnWrap && this.wrapInfo != null) {
                delta = this.wrapInfo[0] * this.columnWrapWidth;
            }
            this.setCurX(oldX + delta);
            for (int i2 = 0; i2 < cells.length; ++i2) {
                if (cells[i2] instanceof ReportLine || cells[i2] instanceof ReportGrid || this.skipCell(cells[i2])) continue;
                this.setCurX(oldX + delta);
                for (int l = 0; l < i2; ++l) {
                    if (!this.isWithIn(cells[l], cells[i2])) continue;
                    this.incCurX(rowShifts[l]);
                }
                if (!(cells[i2] instanceof SubReportObject)) {
                    this.incCurX(rowShifts[i2]);
                }
                if (this instanceof SubReportUI) {
                    ((SubReportUI)this).shift += rowShifts[i2];
                }
                this.setPageW(cells[i2].getX());
                if ((cells[i2] instanceof SubReportObject || cells[i2] instanceof ReportRTFObject || cells[i2] instanceof TableOfContents) && (cellArray.isRepeatOnEveryPage() || section == this.report.getPageHeader() || section == this.report.getPageFooter())) {
                    cells[i2].setResizeToFitContent(false);
                }
                if (!g.isDrawEnabled(this.curY) && (this.isDesignMode() || !this.report.isTocEnabled() || this.report.getTableOfContentsObject().isUseGroups() || cells[i2].getScript() == null || cells[i2].getScript().toUpperCase().indexOf("BOOKMARK") < 0) && (this.isDesignMode() || !(cells[i2] instanceof SubReportObject) && !(cells[i2] instanceof ReportRTFObject) && (!this.report.isTocEnabled() || !(cells[i2] instanceof TableOfContents)) || !cells[i2].isResizeToFitContent())) continue;
                ReportCell newCell = this.getReportCell(tbl, (ReportCell)cells[i2]);
                double[] res = g.drawCell(this.report, tbl, cellArray.getData(), newCell, newCell.getX() + this.curX, newCell.getY() + this.curY);
                double bY = 0.0;
                double bTopY = 0.0;
                if (res != null) {
                    bY = res[0];
                    if (cells[i2] instanceof ReportRTFObject) {
                        bTopY = res[1];
                    } else {
                        this.incCurX(res[1]);
                    }
                }
                cells[i2].setDrawX(newCell.getX() + this.curX);
                cells[i2].setDrawY(newCell.getY() + this.curY);
                cells[i2].setDrawAgain(true);
                if (!(d < bY) || !cells[i2].isResizeToFitContent()) continue;
                d = bY;
                if (cells[i2] instanceof ReportRTFObject) {
                    if (this instanceof SubReportUI || !(bY < this.pageHeight) || !(bY - bTopY > cellArray.getHeight())) continue;
                    cellArray.setHeight(bY - bTopY);
                    continue;
                }
                if (this.isDesignMode() || !(cells[i2] instanceof SubReportObject) || this instanceof SubReportUI) continue;
                for (ReportCell c : cellArray.getCells()) {
                    if (!(c instanceof ReportLine) || !((ReportLine)c).isVertical() || ((ReportLine)c).getHeight() != -1.0) continue;
                    if (bY > this.pageHeight) {
                        c.setHeight(this.pageHeight);
                        continue;
                    }
                    c.setHeight(bY - bTopY);
                }
            }
            this.setCurX(oldX + delta);
            ReportElement[] tmpCells = new ReportCell[cells.length];
            for (int i3 = 0; i3 < cells.length; ++i3) {
                tmpCells[i3] = cells[i3];
            }
            Vector<ReportElement[]> rows = ReportElement.sortElementHorizontally(tmpCells);
            for (i = 0; i < cells.length; ++i) {
                ReportCell newCell;
                if (!(cells[i] instanceof ReportLine) && !(cells[i] instanceof ReportGrid) || this.skipCell(cells[i])) continue;
                this.setCurX(oldX + delta);
                this.shiftImageX(rows, (ReportCell[])cells, rowShifts, (ReportCell)cells[i], i);
                this.incCurX(rowShifts[i]);
                if (cells[i] instanceof ReportLine && !((ReportLine)cells[i]).isVertical() && ((ReportLine)cells[i]).isMatchColumnWidths()) {
                    ((ReportLine)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                }
                if (cells[i] instanceof ReportGrid && ((ReportGrid)cells[i]).isMatchColumnWidths()) {
                    ((ReportGrid)cells[i]).setWidth(tbl.getColumnWidths() - cells[i].getX());
                }
                if ((newCell = this.getReportCell(tbl, (ReportCell)cells[i])) == null) continue;
                g.drawCell(this.report, tbl, cellArray.getData(), (ReportElement)newCell, cellArray, newCell.getX() + this.curX, newCell.getY() + this.curY);
                cells[i].setDrawX(newCell.getX() + this.curX);
                cells[i].setDrawY(newCell.getY() + this.curY);
                cells[i].setDrawAgain(true);
            }
            cells = cellArray.sortCell(2, true);
            for (i = 0; i < cells.length; ++i) {
                if (!g.isDrawEnabled(this.curY) || cells[i].getZ() <= 0 || !cells[i].isDrawAgain()) continue;
                ReportCell newCell = this.getReportCell(tbl, (ReportCell)cells[i]);
                g.drawCell(this.report, tbl, cellArray.getData(), (ReportElement)newCell, cellArray, newCell.getDrawX(), newCell.getDrawY());
            }
        }
        this.doColumnWrap = doColumnWrap_BAK;
        this.setCurX(oldX);
        double oldY = this.curY;
        this.incCurY(cellArray.getHeight());
        if (this.doColumnWrap && this.wrapInfo != null) {
            this.curMaxY = d < this.wrapInfo[2] ? this.wrapInfo[2] : d;
            if (repeatTableHeader) {
                this.wrapInfo[1] = this.curY;
            }
        }
        this.forcePageBreak(g, this.curY, d, section);
        int y_old = QbUtil.toPixel(oldY);
        int y_cur = QbUtil.toPixel(this.curY);
        if (x == -1 && y == -1 || y > QbUtil.toPixel(this.pageSize.getHeight() * (double)this.page)) {
            return false;
        }
        if (y < y_old) {
            return false;
        }
        return y_old <= y && y < y_cur;
    }

    boolean isWithIn(ReportElement celll, ReportElement celli) {
        double decPt = 100000.0;
        double celllY = Math.rint(celll.getY() * decPt) / decPt;
        double celllH = Math.rint(celll.getHeight() * decPt) / decPt;
        double celliY = Math.rint(celli.getY() * decPt) / decPt;
        double celliH = Math.rint(celli.getHeight() * decPt) / decPt;
        double celllYH = Math.rint((celllY + celllH) * decPt) / decPt;
        double celliYH = Math.rint((celliY + celliH) * decPt) / decPt;
        return celllY <= celliY && celllYH > celliY || celllY >= celliY && celllY < celliYH;
    }

    private void shiftImageX(Vector<ReportElement[]> rows, ReportCell[] cells, double[] rowShifts, ReportCell image, int idx) {
        boolean foundIt = false;
        for (int i = 0; i < rows.size(); ++i) {
            ReportElement[] rowElts;
            for (ReportElement rowElt : rowElts = rows.elementAt(i)) {
                if (rowElt != image) continue;
                foundIt = true;
                break;
            }
            if (!foundIt) continue;
            for (ReportElement rowElt : rowElts) {
                int itemIdx = this.getIndex(rowElt, cells);
                if (itemIdx >= idx) continue;
                this.incCurX(rowShifts[itemIdx]);
            }
            return;
        }
    }

    private int getIndex(ReportElement key, ReportCell[] data) {
        for (int j = 0; j < data.length; ++j) {
            if (data[j] != key) continue;
            return j;
        }
        return -1;
    }

    private ReportCell getReportCell(ReportTable tbl, ReportCell cell) {
        return this.getReportCell(tbl, cell, -1);
    }

    private ReportCell getReportCell(ReportTable tbl, ReportCell cell, int index) {
        if (cell instanceof ColumnHeader) {
            ReportCell newCell = tbl.formatCell(cell, index, this.getCurrentPageNumber(), this.getSection(), this.getCurrentTotalPageNumber(), this.getTotalSections(), this.report, this.isDesignMode());
            return newCell;
        }
        if (!this.isDesignMode()) {
            if (cell instanceof ColumnWrap) {
                return null;
            }
            ReportCell newCell = null;
            newCell = tbl.formatCell(cell, index, this.getCurrentPageNumber(), this.getSection(), this.getCurrentTotalPageNumber(), this.getTotalSections(), this.report, false);
            if (newCell.getBookmark() != null && this.report.isTocEnabled()) {
                Bookmark entry = this.report.getTableOfContentsObject().addBookmark(newCell.getBookmark());
                int page = (int)Math.ceil((this.curY + 0.001) / this.pageSize.getHeight());
                double y = this.curY % this.pageSize.getHeight();
                entry.setPageNumber(page);
                entry.setYPos(y);
            }
            return newCell;
        }
        if (cell.getFormula() != null || cell.getFormulaName() != null) {
            ReportCell newCell = null;
            newCell = cell instanceof CBColumnFooter ? new CBColumnFooter(((CBColumnFooter)cell).getColBreakValueIndex()) : (cell instanceof CBAggrColFooter ? new CBAggrColFooter(((CBAggrColFooter)cell).getColBreakLevel(), ((CBAggrColFooter)cell).getColBreakValueIndex()) : new ReportCell());
            if (cell.getFormula() == null) {
                cell.createFormulaObjectFromName(this.report);
            }
            newCell.copy(cell);
            if (!this.report.showFormulaNameSelected) {
                newCell.setText(newCell.getFormula());
            } else {
                newCell.setText(newCell.getFormulaName());
            }
            if (newCell.getDataFormat() instanceof ImageURLFormat || newCell.getDataFormat() instanceof TextURLFormat) {
                newCell.setBgColor(Color.lightGray);
            }
            return newCell;
        }
        if (cell instanceof ReportChartObject) {
            ReportCell newCell = new ReportCell();
            newCell.copy(cell);
            newCell.setBgColor(Color.lightGray);
            return newCell;
        }
        if (cell instanceof ReportLine) {
            ReportLine newCell = new ReportLine();
            newCell.copy((ReportLine)cell);
            return newCell;
        }
        if (cell instanceof ReportGrid) {
            ReportGrid newCell = new ReportGrid();
            newCell.copy((ReportGrid)cell);
            return newCell;
        }
        if (cell instanceof ReportImage) {
            String relativePath = ((ReportImage)cell).getImagePath();
            ReportCell newCell = new ReportCell();
            newCell.copy(cell);
            if (relativePath != null) {
                newCell.setText(relativePath);
            } else {
                URL url = ((ReportImage)cell).getImageURL();
                if (url != null) {
                    newCell.setText(url.toString());
                }
            }
            newCell.setBgColor(Color.lightGray);
            return newCell;
        }
        if (cell instanceof ReportDocument) {
            String path = ((ReportDocument)cell).getRelativePath();
            ReportCell newCell = new ReportCell();
            newCell.copy(cell);
            if (path != null) {
                newCell.setText(path);
            }
            newCell.setBgColor(Color.lightGray);
            return newCell;
        }
        if (cell instanceof SubReportObject) {
            ReportCell newCell = new ReportCell();
            newCell.copy(cell);
            newCell.setBgColor(Color.lightGray);
            return newCell;
        }
        if (cell instanceof ReportRTFObject) {
            ReportCell newCell = new ReportCell();
            newCell.copy(cell);
            newCell.setBgColor(Color.lightGray);
            return newCell;
        }
        if (cell instanceof TableOfContents) {
            ReportCell newCell = new ReportCell();
            newCell.copy(cell);
            newCell.setBgColor(Color.lightGray);
            return newCell;
        }
        return cell;
    }

    void drawTable(ReportGraphics g, ReportTableElement tbl) {
        if (g == null || tbl.getBgColor() == null) {
            return;
        }
        g.setColor(tbl.getBgColor());
        if (this.isDesignMode()) {
            g.fillRect(this.curX, this.curY, this.pageSize.getWidth() * 5.0, tbl.getHeight());
        } else if (g instanceof PageGraphics) {
            g.fillRect(this.curX, this.curY, this.pageSize.getWidth(), tbl.getHeight());
        } else {
            int i;
            double requireH = tbl.getHeight();
            double tmp = this.curY % this.pageSize.getHeight();
            if (tmp < 1.0E-7) {
                tmp = this.pageSize.getHeight();
            }
            double posY = this.curY;
            while (requireH > tmp) {
                for (i = 0; i < this.getTotalSections(); ++i) {
                    g.fillRect((double)i * this.pageSize.getWidth() + this.curX, posY, this.pageSize.getWidth(), tmp, tbl.getBgColor());
                }
                requireH -= tmp;
                if ((tmp = (posY += tmp) % this.pageSize.getHeight()) != 0.0) continue;
                tmp = this.pageSize.getHeight();
            }
            for (i = 0; i < this.getTotalSections(); ++i) {
                g.fillRect((double)i * this.pageSize.getWidth() + this.curX, posY, this.pageSize.getWidth(), requireH, tbl.getBgColor());
            }
        }
    }

    protected void initRepeatSection() {
        this.sectionList = new Vector();
        this.tableList = new Vector();
    }

    protected void addRepeatSection(ReportSection section, ReportTable tbl) {
        this.sectionList.addElement(section);
        this.tableList.addElement(tbl);
    }

    protected void drawRepeatSection(ReportGraphics g, ReportSection section) throws Exception {
        this.isDrawRepeatSection = true;
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                ReportSection drawingSection = this.sectionList.elementAt(i);
                if (drawingSection == section) {
                    return;
                }
                for (int j = 0; j < drawingSection.getSectionCount(); ++j) {
                    if (drawingSection.getSection(j) != section) continue;
                    return;
                }
                this.drawSection(g, drawingSection, this.tableList.elementAt(i), true);
            }
        }
        this.isDrawRepeatSection = false;
    }

    protected void removeRepeatSection() {
        this.sectionList.removeElementAt(this.sectionList.size() - 1);
        this.tableList.removeElementAt(this.tableList.size() - 1);
    }

    private boolean skipCell(ReportElement cell) {
        if (this.isDesignMode()) {
            return false;
        }
        if ((cell instanceof ReportLine && !((ReportLine)cell).isVertical() || cell instanceof ReportGrid) && this.betweenSections(cell)) {
            return true;
        }
        if (!this.doColumnWrap) {
            return false;
        }
        return cell.getX() + cell.getWidth() > this.columnWrapWidth;
    }

    private boolean betweenSections(ReportElement cell) {
        double w = this.pageSize.getWidth();
        double xPt = cell.getX();
        if (xPt % w == 0.0) {
            xPt += 0.001;
        }
        return Math.ceil(xPt / w) != Math.ceil((cell.getX() + cell.getWidth()) / w);
    }

    public void initCurrentPosition() {
        this.maxX = this.report.getActualPageWidth();
        this.curY = 0.0;
        this.curX = 0.0;
    }

    private void pageBreak(ReportGraphics g, double requiredHeight, int rowIndex, boolean checkFitGroupOnPage) throws Exception {
        if (this.isDesignMode()) {
            return;
        }
        double tmp = this.getDrawablePageHeight() - this.getPageCurY();
        if (this.atEndOfPage() && checkFitGroupOnPage) {
            tmp = 0.0;
        }
        if (tmp > requiredHeight) {
            return;
        }
        if (this.columnWrapCount <= 0 || this.wrapInfo[0] >= (double)this.columnWrapCount || this.curY == this.wrapInfo[1]) {
            this.setPrintOnNewPage(g, null, false);
            this.fit = false;
            this.wrapInfo[0] = 0.0;
            this.wrapInfo[1] = this.curY;
            this.columnWrapInitialRow = this.columnWrapDisplayRow + this.columnWrapInitialRow;
            this.columnWrapDisplayRow = 0;
        } else {
            this.wrapInfo[2] = this.curY;
            this.setCurY(this.wrapInfo[1]);
            if (this.columnWrapDisplayRow == 0) {
                this.columnWrapDisplayRow = rowIndex - this.columnWrapInitialRow * (this.columnWrapCount + 1);
            }
            this.wrapInfo[0] = this.wrapInfo[0] + 1.0;
            this.rowCount = 0;
        }
    }

    protected boolean pageBreak(ReportGraphics g, double requiredHeight, ReportSection section) throws Exception {
        if (this.isDesignMode()) {
            return false;
        }
        double tmp = this.getDrawablePageHeight() - this.getPageCurY();
        if (tmp > requiredHeight) {
            return false;
        }
        if (tmp == requiredHeight) {
            return true;
        }
        this.pageBreak(g, section);
        return false;
    }

    private void pageBreak(ReportGraphics g, ReportSection section) throws Exception {
        if (this.isDesignMode()) {
            return;
        }
        if (this.doColumnWrap && this.wrapInfo != null) {
            if (this.columnWrapCount <= 0 || this.wrapInfo[0] >= (double)this.columnWrapCount || this.curY == this.wrapInfo[1]) {
                this.setPrintOnNewPage(g, section);
                this.fit = false;
                this.wrapInfo[0] = 0.0;
                this.wrapInfo[1] = this.curY;
            } else {
                this.wrapInfo[2] = this.curY;
                this.setCurY(this.wrapInfo[1]);
                this.wrapInfo[0] = this.wrapInfo[0] + 1.0;
                this.rowCount = 0;
            }
        } else {
            this.setPrintOnNewPage(g, section);
            this.fit = false;
        }
    }

    protected void setPrintOnNewPage(ReportGraphics g, ReportSection section) throws Exception {
        this.setPrintOnNewPage(g, section, true);
    }

    protected void setPrintOnNewPage(ReportGraphics g, ReportSection section, boolean performRoundingCheck) throws Exception {
        if (this.isDesignMode()) {
            return;
        }
        double tmp = this.curY % this.pageSize.getHeight();
        if (performRoundingCheck && (tmp > this.pageSize.getHeight() - 0.001 || tmp < 0.001)) {
            return;
        }
        ++this.currentPageNumber;
        if (g instanceof PageBufferGraphics) {
            ++this.page;
        }
        ++this.pageCt;
        this.rowCount = 0;
        if (section != null && section.isResetPageNumber()) {
            this.currentPageNumber = 1;
            this.savedStartPage = this.pageCt;
        }
        this.incCurY(this.pageSize.getHeight() - tmp);
        if (this.sectionList != null && this.sectionList.size() > 0) {
            this.drawRepeatSection(g, section);
        }
    }

    protected void incCurY(double val) {
        this.curY += val;
    }

    private void setCurY(double val) {
        this.curY = val;
    }

    protected double getPageCurY() {
        return this.curY % this.pageSize.getHeight();
    }

    private boolean atEndOfPage() {
        return this.curY != 0.0 && this.curY % this.pageSize.getHeight() == 0.0;
    }

    protected double getDrawablePageHeight() {
        return this.pageSize.getHeight();
    }

    protected void sectionBreak(double x, double requiredWidth) {
        if (this.isDesignMode()) {
            return;
        }
        if (this.fromPageViewer) {
            this.section = (int)(x / this.pageSize.getWidth()) + 1;
        }
        if (Math.ceil((x + this.curX + requiredWidth) / this.pageSize.getWidth()) != Math.ceil((x + this.curX) / this.pageSize.getWidth()) && (x + this.curX) % this.pageSize.getWidth() != 0.0) {
            this.incCurX(this.pageSize.getWidth() - (x + this.curX) % this.pageSize.getWidth());
        }
        if (x + requiredWidth + this.curX > this.maxX) {
            this.maxX = x + requiredWidth + this.curX;
        }
    }

    protected void setPageW(double x) {
    }

    protected void incCurX(double val) {
        this.curX += val;
    }

    protected void setCurX(double val) {
        this.curX = val;
    }

    protected ReportSection resizeSection(ReportGraphics g, ReportSection _sec, ReportTable tbl, Vector<Integer> tree) throws Exception {
        int i;
        boolean shift = false;
        ReportSection sec = new ReportSection();
        boolean resize = false;
        boolean copied = false;
        if (tree != null) {
            if (_sec.hasFormattedCell(tree)) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                Hashtable<Integer, ReportCell> cellTable = sec.getFormattedCells(tree);
                ReportCell[] cell = sec.getCells();
                for (int i2 = 0; i2 < cell.length; ++i2) {
                    ReportCell formattedCell;
                    if (!cellTable.containsKey(i2)) continue;
                    cell[i2] = formattedCell = cellTable.get(i2);
                }
            }
            if (_sec.hasSectionCells(tree)) {
                Vector<ReportCell> sectionCells = _sec.getSectionCells(tree);
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                if (sectionCells != null) {
                    for (int i3 = 0; i3 < sectionCells.size(); ++i3) {
                        sec.addData(sectionCells.elementAt(i3));
                    }
                }
                resize = true;
                shift = true;
            }
            if (_sec.getHeight(tree) > 0.0) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                sec.setHeight(_sec.getHeight(tree));
                resize = true;
                shift = true;
            }
        }
        for (i = 0; i < _sec.getCellCount() && !resize; ++i) {
            if (!_sec.getData(i).isVisible() || !_sec.getData(i).isResizeToFitContent()) continue;
            if (!copied) {
                sec.deepCopy(_sec);
            }
            copied = true;
            resize = true;
        }
        if (resize) {
            for (i = 0; i < sec.getCellCount(); ++i) {
                ReportGraphics temp_rg;
                double[] res;
                ReportCell element = sec.getData(i);
                if (!element.isResizeToFitContent()) continue;
                if (element instanceof SubReportObject || element instanceof TableOfContents || element instanceof ReportRTFObject) {
                    shift = true;
                }
                ReportCell cell = this.getReportCell(tbl, element);
                double h = 0.0;
                h = cell.getRotateAngle() == 0.0 ? g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap()) : g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getHeight(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject || cell instanceof TableOfContents || cell instanceof SubReportObject) {
                    h = cell.getHeight();
                }
                if ((cell instanceof ReportRTFObject || cell instanceof TableOfContents || cell instanceof SubReportObject) && _sec.getBgColor() != null && (res = (temp_rg = this.getReportGraphics()).drawCell(this.report, tbl, null, cell, sec, 0.0, 0.0, 0)) != null) {
                    h = res[0];
                }
                if (cell.getRotateAngle() == 0.0 && h > cell.getHeight() && cell.isVisible()) {
                    shift = true;
                    ReportSection.resizeVerticallyAndShift((ReportElement)element, sec, h - cell.getHeight());
                    continue;
                }
                if (cell.getRotateAngle() == 0.0 || !(h > cell.getWidth())) continue;
                shift = true;
                ReportSection.resizeHorizontallyAndShift((ReportElement)element, sec, h - cell.getWidth());
            }
        }
        if (shift) {
            double minH = sec.getMinHeight();
            if (sec.getHeight() < minH) {
                if (sec.isResizeToFitContent()) {
                    double increase = ReportUI.getMaxIncreaseProportion(_sec, sec);
                    for (int i4 = 0; i4 < sec.getCellCount(); ++i4) {
                        if (sec.getData(i4) instanceof ReportLine && ((ReportLine)sec.getData(i4)).isVertical() && ((ReportLine)sec.getData(i4)).next() != null) {
                            sec.getData(i4).setHeight(sec.getMinHeight() - sec.getData(i4).getY());
                            continue;
                        }
                        if (sec.getData(i4) == null || sec.getData(i4) instanceof ReportLine) continue;
                        double h1 = _sec.getData(i4).getHeight() * increase;
                        double h2 = sec.getData(i4).getHeight();
                        sec.getData(i4).setHeight(h1 > h2 ? h1 : h2);
                    }
                    minH = sec.getMinHeight();
                }
                sec.setHeight(minH);
            }
            return sec;
        }
        for (i = 0; i < _sec.getCellCount(); ++i) {
            if (!(_sec.getData(i) instanceof ReportLine) || ((ReportLine)_sec.getData(i)).next() == null || !((ReportLine)_sec.getData(i)).isVertical()) continue;
            _sec.getData(i).setHeight(_sec.getHeight() - _sec.getData(i).getY());
        }
        return _sec;
    }

    public static double getMaxIncreaseProportion(ReportSection _sec, ReportSection sec) {
        double ratio = 1.0;
        for (int i = 0; i < _sec.getCellCount(); ++i) {
            ReportCell _elt = _sec.getData(i);
            ReportCell elt = sec.getData(_elt.getID());
            double newRatio = elt.getHeight() / _elt.getHeight();
            if (!(newRatio > ratio)) continue;
            ratio = newRatio;
        }
        return ratio;
    }

    private ReportTable resizeTable(ReportGraphics g, ReportTable _tbl, int rowIndex, Vector<Integer> tree) throws Exception {
        int i;
        boolean resize;
        ReportTable tbl;
        boolean shift;
        block24: {
            int i2;
            this.rowElements = null;
            double rowHeight = 0.0;
            shift = false;
            tbl = new ReportTable();
            resize = false;
            if (this.rows != null) {
                FormattedRow row;
                FormattedRowKey key;
                if (tree == null || tree.size() == 0) {
                    key = new FormattedRowKey(rowIndex, null);
                } else {
                    int[] intArray = QbUtil.convertVectorToIntArray(tree);
                    key = new FormattedRowKey(rowIndex, intArray);
                }
                if (this.rows.containsKey(key) && (row = this.rows.get(key)) != null) {
                    rowHeight = row.getRowHeight();
                    this.rowElements = row.getRowElements();
                    for (int j = 0; j < _tbl.getColumnCount(); ++j) {
                        tbl.addColumn(new ReportColumn());
                    }
                    tbl.deepCopy(_tbl);
                    tbl.setHeight(rowHeight);
                    resize = true;
                    shift = true;
                }
            }
            if (this.calculated) break block24;
            if (this.previousRowValue == null) {
                this.previousRowValue = new Object[_tbl.getColumnCount()];
                this.previousRowIsBGColor2 = new boolean[_tbl.getColumnCount()];
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
                    this.previousRowIsBGColor2[i2] = false;
                    _tbl.getColumn(i2).setIsBGColor2(rowIndex, this.previousRowIsBGColor2[i2]);
                }
            } else {
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    int[] index = _tbl.getColumn(i2).getDualColorColInfoIndex();
                    if (index == null) continue;
                    boolean different = false;
                    for (int j = 0; j < index.length; ++j) {
                        if (this.previousRowValue[index[j]] != null) {
                            if (this.previousRowValue[index[j]].equals(_tbl.getColumn(index[j]).getData(rowIndex)) || "".equals(_tbl.getColumn(index[j]).getData(rowIndex))) continue;
                            different = true;
                            break;
                        }
                        if (_tbl.getColumn(index[j]).getData(rowIndex) == null) continue;
                        different = true;
                        break;
                    }
                    if (different) {
                        this.previousRowIsBGColor2[i2] = !this.previousRowIsBGColor2[i2];
                    }
                    _tbl.getColumn(i2).setIsBGColor2(rowIndex, this.previousRowIsBGColor2[i2]);
                }
            }
            for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
            }
        }
        for (i = 0; i < _tbl.getColumnCount() && !resize; ++i) {
            if (!_tbl.getColumn(i).isVisible() || !_tbl.getColumn(i).isResizeToFitContent()) continue;
            tbl.positionCopy(_tbl);
            resize = true;
        }
        if (resize) {
            for (i = 0; i < tbl.getColumnCount(); ++i) {
                if (!tbl.getColumn(i).isResizeToFitContent()) continue;
                ReportCell cell = tbl.formatCell(tbl.getColumn(i), rowIndex, this.report, this.isDesignMode());
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if ((cell instanceof ReportRTFObject || cell instanceof TableOfContents || cell instanceof SubReportObject) && _tbl.getBgColor() != null) {
                    ReportGraphics temp_rg = this.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, tbl, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportTable.resizeVerticallyAndShift((ReportElement)tbl.getColumn(i), tbl, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = tbl.getMinHeight();
            if (tbl.getHeight() < minH) {
                double increase = ReportUI.getMaxIncreaseProportion(_tbl, tbl);
                if (tbl.isResizeToFitContent()) {
                    int i3;
                    for (i3 = 0; i3 < tbl.getColumnCount(); ++i3) {
                        double h1 = _tbl.getColumn(i3).getHeight() * increase;
                        double h2 = tbl.getColumn(i3).getHeight();
                        tbl.getColumn(i3).setHeight(h1 > h2 ? h1 : h2);
                    }
                    for (i3 = 0; i3 < tbl.getImageCount(); ++i3) {
                        ReportImage image = tbl.getImage(i3);
                        if (!(image instanceof ReportGrid) || !(((ReportGrid)image).getHeight() >= 0.0)) continue;
                        image.setHeight(image.getHeight() * increase);
                    }
                    minH = tbl.getMinHeight();
                }
                for (int i4 = 0; i4 < tbl.getImageCount(); ++i4) {
                    ReportImage image = tbl.getImage(i4);
                    if (!(image instanceof ReportLine) || !((ReportLine)image).isVertical() || ((ReportLine)image).next() == null) continue;
                    image.setHeight(image.getHeight() * increase + 0.01);
                }
                tbl.setHeight(minH);
            }
            return tbl;
        }
        for (i = 0; i < _tbl.getImageCount(); ++i) {
            if (!(_tbl.getImage(i) instanceof ReportLine) || ((ReportLine)_tbl.getImage(i)).next() == null || !((ReportLine)_tbl.getImage(i)).isVertical()) continue;
            _tbl.getImage(i).setHeight(_tbl.getHeight() - _tbl.getImage(i).getY());
        }
        return _tbl;
    }

    private static double getMaxIncreaseProportion(ReportTable _tbl, ReportTable tbl) {
        double ratio = 1.0;
        for (int i = 0; i < _tbl.getColumnCount(); ++i) {
            ReportColumn _elt = _tbl.getColumn(i);
            ReportColumn elt = tbl.getColumnByID(_elt.getID());
            double newRatio = elt.getHeight() / _elt.getHeight();
            if (!(newRatio > ratio)) continue;
            ratio = newRatio;
        }
        return ratio;
    }

    public Vector<Integer> getTreeStructure() {
        return this.treeStructure;
    }

    public boolean isRowFound() {
        return this.rowFound;
    }

    public boolean isSectionFound() {
        return this.sectionFound;
    }

    public int getHeaderFooterIndicator() {
        return this.headerFooterIndicator;
    }

    public int getRow() {
        return this.row;
    }

    protected String getTreeStringKey() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            String str = "Tree_";
            int size = this.treeStructure.size();
            for (int i = 0; i < size - 1; ++i) {
                str = str + this.treeStructure.elementAt(i) + "_";
            }
            str = str + this.treeStructure.elementAt(size - 1);
            return str;
        }
        return null;
    }

    private int getCurrentSectionID() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int lastID = this.treeStructure.size();
            return this.treeStructure.elementAt(lastID - 1);
        }
        return 0;
    }

    public void setDesignMode(boolean b) {
        this.designMode = b;
    }

    public boolean isDesignMode() {
        return this.designMode;
    }

    private int countSubTable(ReportTreeTable tree) {
        int tmp = tree.countSubTable();
        if (this.isCalcTotalSections && tmp > 0) {
            return 1;
        }
        return tmp;
    }

    public void setCalcTotalSections(boolean b) {
        this.isCalcTotalSections = b;
    }

    boolean isCalcTotalSections() {
        return this.isCalcTotalSections;
    }

    private boolean isPrepareMode() {
        return this.isCalcTotalSections() || this.isDesignMode();
    }

    public void setImageMapEnabled(boolean b) {
        this.enableImageMap = b;
        if (this.imageMap == null) {
            this.imageMap = new Vector();
        }
    }

    public boolean isImageMapEnabled() {
        boolean val;
        boolean bl = val = this.enableImageMap && !this.isPrepareMode();
        if (val && this.imageMap == null) {
            this.imageMap = new Vector();
        }
        return val;
    }

    public Vector getImageMap() {
        return this.imageMap;
    }

    public void setPixelPerInch(double pixelPerInch) {
        this.pixelPerInch = pixelPerInch;
    }

    protected int toPixel(double inch) {
        if (this.pixelPerInch < 0.0) {
            return QbUtil.toPixel(inch);
        }
        return (int)Math.rint(inch * this.pixelPerInch);
    }

    protected double toInch(int pixel) {
        if (this.pixelPerInch < 0.0) {
            return QbUtil.toInch(pixel);
        }
        return (double)pixel / this.pixelPerInch;
    }

    private void drawMasterSection(ReportGraphics g, Report report, ReportTable tbl, ReportSection mSection, double x, double y) throws Exception {
        try {
            if (!this.isDesignMode()) {
                if (g != null) {
                    ReportCell newCell;
                    ReportCell[] cells;
                    if (mSection.getBgColor() != null) {
                        g.setColor(mSection.getBgColor());
                        g.fillRect(x, y, mSection.getWidth(), mSection.getHeight());
                    }
                    for (ReportCell cell : cells = mSection.sortCell(1, true)) {
                        if (!(cell.getX() + cell.getWidth() <= mSection.getWidth()) || !(cell.getY() + cell.getHeight() <= mSection.getHeight())) continue;
                        newCell = this.getReportCell(tbl, cell);
                        g.drawCell(report, tbl, mSection.getData(), (ReportElement)newCell, mSection, newCell.getX() + x, newCell.getY() + y);
                        cell.setDrawX(newCell.getX() + x);
                        cell.setDrawY(newCell.getY() + y);
                        cell.setDrawAgain(true);
                    }
                    for (ReportCell cell : cells = mSection.sortCell(2, true)) {
                        newCell = this.getReportCell(tbl, cell);
                        g.drawCell(report, tbl, mSection.getData(), (ReportElement)newCell, mSection, newCell.getDrawX(), newCell.getDrawY());
                    }
                    if (mSection.getBorderColor() != null) {
                        g.setColor(mSection.getBorderColor());
                        Dimension2D dim = g.getDimension(x, y, mSection.getWidth(), mSection.getHeight());
                        if (dim != null) {
                            g.drawRect(this.toPixel(dim.getWidth()), this.toPixel(dim.getHeight()), this.toPixel(mSection.getWidth()), this.toPixel(mSection.getHeight()), mSection.getBorderThickness());
                        }
                    }
                }
            } else {
                ReportCell newCell = new ReportCell();
                newCell.copy(mSection);
                newCell.setBgColor(Color.lightGray);
                g.drawCell(report, tbl, mSection.getData(), newCell, x, y);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to draw master section", ex);
        }
    }

    public void setForSubReport(boolean state) {
        this.forSubReport = state;
    }

    public Object[] calculateRowShifts(ReportElement[] relts, ReportTable table) throws Exception {
        Object[] objs = this.calculateRowShiftsForColumns(relts, table);
        ReportElement[] relts2 = (ReportElement[])objs[0];
        ReportCell[] cells = new ReportCell[relts2.length];
        for (int i = 0; i < relts2.length; ++i) {
            cells[i] = (ReportCell)relts2[i];
        }
        objs[0] = cells;
        return objs;
    }

    public Object[] calculateRowShiftsForColumns(ReportElement[] relts, ReportTable table) throws Exception {
        try {
            if (!this.report.isCrossTabFixedField() || relts.length <= 0) {
                Object[] objs = new Object[]{relts, this.calculateShifts(relts, table)};
                return objs;
            }
            double oldX = this.curX;
            Vector<ReportElement[]> rows = ReportElement.sortElementHorizontally(relts);
            Vector<ReportElement[]> rows2 = new Vector<ReportElement[]>();
            Vector<double[]> shiftArr = new Vector<double[]>();
            int ctCell = 0;
            for (int i = 0; i < rows.size(); ++i) {
                this.curX = oldX;
                double[] shiftTMP = this.calculateShifts(rows.elementAt(i), table);
                ReportElement[] mergedCells = this.mergeCells(rows.elementAt(i), shiftTMP);
                this.curX = oldX;
                double[] shiftList = this.calculateShifts(mergedCells, table);
                shiftArr.addElement(shiftList);
                rows2.addElement(mergedCells);
                ctCell += mergedCells.length;
            }
            relts = new ReportElement[ctCell];
            int k = 0;
            for (int i = 0; i < rows2.size(); ++i) {
                ReportElement[] tmpArr;
                for (ReportElement element : tmpArr = (ReportElement[])rows2.elementAt(i)) {
                    relts[k++] = element;
                }
            }
            relts = ReportElement.sortElement(relts, 1, true);
            double[] res = new double[relts.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = this.findShiftValue(relts[i], rows2, shiftArr);
            }
            Object[] objs = new Object[]{relts, res};
            return objs;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "calculateRowShiftsForColumns: failed", ex);
            throw ex;
        }
    }

    private double findShiftValue(ReportElement key, Vector<ReportElement[]> rows, Vector<double[]> shiftArr) {
        for (int i = 0; i < rows.size(); ++i) {
            ReportElement[] data = rows.elementAt(i);
            for (int j = 0; j < data.length; ++j) {
                if (!data[j].getID().equals(key.getID()) || !data[j].getClass().equals(key.getClass())) continue;
                return shiftArr.elementAt(i)[j];
            }
        }
        return 0.0;
    }

    public double[] calculateShifts(ReportElement[] relts, ReportTable table) throws Exception {
        if (this.pageSize == null) {
            this.pageSize = new Dimension2D(this.report.getActualPageWidth(), this.pageHeight);
        }
        double[] shifts = new double[relts.length];
        for (int j = 0; j < relts.length; ++j) {
            if (!relts[j].isVisible()) {
                shifts[j] = 0.0;
                continue;
            }
            if (relts[j] instanceof SubReportObject) {
                ReportGraphics rg = new ReportGraphics(this, this.textGraphics);
                rg.setPrintMode(this.printMode);
                ReportCell newCell = this.getReportCell(table, (SubReportObject)relts[j]);
                double[] res = rg.drawCell(this.report, table, null, newCell, newCell.getX() + this.curX, 0.0);
                if (res != null) {
                    shifts[j] = res[1];
                }
                this.incCurX(shifts[j]);
                if (newCell.getWidth() > this.report.getActualPageWidth() && newCell instanceof ReportLine) continue;
                if (newCell.getX() + newCell.getWidth() + this.curX > this.maxX) {
                    this.maxX = newCell.getX() + newCell.getWidth() + this.curX;
                }
                if (!((SubReportObject)relts[j]).isResizeWidth()) continue;
                relts[j].setWidth(newCell.getWidth());
                continue;
            }
            if (!(relts[j] instanceof ReportLine) && !(relts[j] instanceof ReportGrid)) {
                double temp = this.curX;
                this.sectionBreak(relts[j].getX(), relts[j].getWidth());
                shifts[j] = this.curX - temp;
                continue;
            }
            if (!(relts[j].getWidth() <= this.pageSize.getWidth())) continue;
            this.sectionBreak(relts[j].getX(), relts[j].getWidth());
            shifts[j] = 0.0;
        }
        if (this instanceof SubReportUI) {
            ((SubReportUI)this).shift = 0.0;
        }
        return shifts;
    }

    public ReportCell[] splitCells(ReportElement[] relts) {
        Vector<ReportElement> newList = new Vector<ReportElement>();
        for (int i = 0; i < relts.length; ++i) {
            ReportCell[] newCells;
            if (!(relts[i] instanceof RBColumnHeader)) {
                newList.addElement(relts[i]);
                continue;
            }
            for (ReportCell newCell : newCells = ((RBColumnHeader)relts[i]).splitCell()) {
                newList.addElement(newCell);
            }
        }
        ReportCell[] nElts = new ReportCell[newList.size()];
        for (int i = 0; i < newList.size(); ++i) {
            nElts[i] = (ReportCell)newList.elementAt(i);
        }
        return nElts;
    }

    private ReportElement[] mergeCells(ReportElement[] relts, double[] shiftVal) {
        Vector<ReportElement> newList = new Vector<ReportElement>();
        double offset = 0.0;
        for (int i = 0; i < relts.length; ++i) {
            if (!(relts[i] instanceof RBColumnHeader)) {
                offset += shiftVal[i];
                newList.addElement(relts[i]);
                continue;
            }
            double[] resArr = this.mergeCell((RBColumnHeader)relts[i], relts, i + 1, newList, shiftVal, offset + shiftVal[i]);
            i = (int)resArr[0];
            offset = resArr[1];
        }
        ReportElement[] nElts = new ReportElement[newList.size()];
        for (int i = 0; i < newList.size(); ++i) {
            nElts[i] = (ReportElement)newList.elementAt(i);
        }
        return nElts;
    }

    private double[] mergeCell(RBColumnHeader cHdr, ReportElement[] relts, int i, Vector<ReportElement> newList, double[] shiftVal, double offset) {
        int sec1;
        if (i >= relts.length) {
            newList.addElement(cHdr);
            return new double[]{i - 1, offset};
        }
        if (!(relts[i] instanceof RBColumnHeader)) {
            newList.addElement(cHdr);
            return new double[]{i - 1, offset};
        }
        int idx0 = cHdr.getID().lastIndexOf("_S");
        int idx1 = relts[i].getID().lastIndexOf("_S");
        if (idx0 <= 0 || idx1 <= 0) {
            newList.addElement(cHdr);
            return new double[]{i - 1, offset};
        }
        if (!cHdr.getID().substring(0, idx0).equals(relts[i].getID().substring(0, idx1))) {
            newList.addElement(cHdr);
            return new double[]{i - 1, offset};
        }
        int sec0 = (int)((cHdr.getX() + offset) / this.report.getActualPageWidth());
        if (sec0 != (sec1 = (int)((relts[i].getX() + offset + shiftVal[i]) / this.report.getActualPageWidth()))) {
            newList.addElement(cHdr);
            return new double[]{i - 1, offset};
        }
        cHdr.setWidth(cHdr.getWidth() + relts[i].getWidth());
        return this.mergeCell(cHdr, relts, i + 1, newList, shiftVal, offset + shiftVal[i]);
    }

    public void setPrintMode(boolean state) {
        this.printMode = state;
    }

    public boolean adjustReportTitle(ReportGraphics g, ReportSection _sec) throws Exception {
        for (int i = 0; i < _sec.getCellCount(); ++i) {
            double width;
            if (!(_sec.getData(i) instanceof ReportTitle)) continue;
            ReportTitle title = (ReportTitle)_sec.getData(i);
            if (title.autoResize && (width = g.getTextWidth(title.getText(), title.getRefFontToDraw(this.report.isAdjustFont()))) > title.getWidth()) {
                if (width < this.report.getActualPageWidth()) {
                    title.setWidth(width);
                } else {
                    title.setWidth(this.report.getActualPageWidth());
                    title.setResizeToFitContent(true);
                }
            }
            if (title.position == 2) {
                title.setX((this.report.getActualPageWidth() - title.getWidth()) / 2.0);
                continue;
            }
            if (title.position == 1) {
                title.setX(0.0);
                continue;
            }
            if (title.position != 3) continue;
            title.setX(this.report.getActualPageWidth() - title.getWidth());
        }
        return true;
    }
}

