/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.wsdl.gen.Parser;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.SOAPCall;
import quadbase.common.util.internal.SOAPUtil;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.util.XMLQueryResultSet;

public class SOAPAccess {
    private static final Logger LOGGER = Logger.getLogger(SOAPAccess.class.getName());

    public static ColData[] retrieveResult(SOAPQueryFileInfo soapInfo) throws Exception {
        return ColData.getColData(new XMLQueryResultSet(SOAPAccess.getXMLStream(soapInfo), soapInfo.getXMLFieldInfo(), null, null, null));
    }

    public static InputStream getDTDSchema(SOAPQueryFileInfo soapInfo) throws Exception {
        InputStream xmlStream = SOAPAccess.getXMLStream(soapInfo);
        return SOAPUtil.generateDTD(xmlStream);
    }

    public static InputStream getXMLStream(SOAPQueryFileInfo soapInfo) throws Exception {
        return SOAPUtil.processEncodedXML(SOAPAccess.getRawXMLStream(soapInfo));
    }

    public static InputStream getRawXMLStream(SOAPQueryFileInfo soapInfo) throws Exception {
        if (ServerMessage.useServer) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            IConnection socket = null;
            try {
                int messageType = 25502;
                dout.writeShort(messageType);
                soapInfo.write(dout, (short)6612);
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to contact EspressReport server", ex);
                if (socket != null) {
                    socket.close();
                }
                throw new IOException("Failed to contact EspressReport server at " + ServerMessage.getServerInfo() + " " + ex.getMessage());
            }
            byte[] indata = null;
            try {
                DataInputStream instream = new DataInputStream(socket.getInputStream());
                int code = instream.readInt();
                if (code != 0) {
                    throw new Exception(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                }
                indata = new byte[instream.readInt()];
                instream.readFully(indata, 0, indata.length);
                instream.close();
                socket.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Cannot read data", ex);
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                throw ex;
            }
            catch (Error err) {
                LOGGER.log(Level.FINEST, "Cannot read data", err);
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                throw new SQLException(err.toString());
            }
            return new ByteArrayInputStream(indata);
        }
        return SOAPAccess.getXMLStreamFromLocal(soapInfo);
    }

    public static InputStream getXMLStreamFromLocal(SOAPQueryFileInfo soapInfo) throws Exception {
        Parser parser = new Parser();
        parser.run(soapInfo.getWsdlUri());
        SOAPCall call = new SOAPCall(parser, soapInfo.getServiceName(), soapInfo.getPortName(), soapInfo.getOperationName());
        ArrayList paramList = call.getParameters();
        Object[] parameters = new Object[paramList.size()];
        for (int i = 0; i < paramList.size(); ++i) {
            ParameterDesc paramDesc = (ParameterDesc)paramList.get(i);
            IQueryInParam param = soapInfo.getSOAPParameter(paramDesc.getName());
            if (param == null) {
                throw new IllegalArgumentException("Parameter '" + paramDesc.getName() + "' not found");
            }
            parameters[i] = param.getValue();
        }
        String result = call.invoke(parameters);
        return new ByteArrayInputStream(result.getBytes());
    }
}

