/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DataFileInput;
import quadbase.reportdesigner.report.IOUtil2;
import quadbase.reportdesigner.util.SalesForceResultSet;

public class SalesForceAccess {
    private static final Logger LOGGER = Logger.getLogger(SalesForceAccess.class.getName());

    public static ColData[] getColData(SalesForceQueryFileInfo sfQueryInfo) throws Exception {
        return ColData.getColDataWithUniqueName(SalesForceAccess.getColData(sfQueryInfo, 0, -1));
    }

    public static ColData[] getColData(SalesForceQueryFileInfo sfQueryInfo, int startIndex, int displayRow) throws Exception {
        if (ServerMessage.useServer) {
            ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
            DataOutputStream dout = new DataOutputStream(bstream);
            IConnection socket = null;
            try {
                int messageType = 11002;
                dout.writeShort(messageType);
                sfQueryInfo.write(dout);
                IOUtil.writeStr(dout, sfQueryInfo.getServerUrl());
                IOUtil.writeStr(dout, sfQueryInfo.getSessionId());
                dout.writeInt(startIndex);
                dout.writeInt(displayRow);
                dout.writeBoolean(false);
                dout.writeBoolean(false);
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length);
                socket.getOutputStream().write(array);
                socket.getOutputStream().flush();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to contact EspressReport server", ex);
                if (socket != null) {
                    socket.close();
                }
                throw new IOException("Failed to contact EspressReport server at " + ServerMessage.getServerInfo() + " " + ex.getMessage());
            }
            byte[] indata = null;
            try {
                DataInputStream instream = new DataInputStream(socket.getInputStream());
                int code = instream.readInt();
                if (code != 0) {
                    throw new SQLException(IOUtil2.getErrorString(code) + "\n" + IOUtil.readString(instream, true));
                }
                indata = new byte[instream.readInt()];
                instream.readFully(indata, 0, indata.length);
                instream.close();
                socket.close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Can't read data", ex);
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                throw ex;
            }
            catch (Error err) {
                LOGGER.log(Level.FINEST, "Can't read data", err);
                try {
                    socket.close();
                }
                catch (Exception ex2) {
                    LOGGER.log(Level.FINEST, "Can't close socket", ex2);
                }
                throw new SQLException(err.toString());
            }
            DataInputStream binput = new DataInputStream(new ByteArrayInputStream(indata));
            return ColData.getColDataWithUniqueName(DataFileInput.getColDataFromStream(binput));
        }
        return ColData.getColDataWithUniqueName(new SalesForceResultSet(sfQueryInfo).getColData(startIndex, displayRow));
    }
}

