/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.VersioningDataInput;
import quadbase.common.util.internal.VersioningDataOutput;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.designer.ReportMain;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.PaginationSettings;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SaveXMLReport;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.IReportMain;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class SaveReport {
    private static final Logger LOGGER = Logger.getLogger(SaveReport.class.getName());
    public static final int VERSION = 7004;
    public static String VERSIONNAME = "EspressReport " + ServerMessage.getProductVersion();
    public static final String UPDATE_VERSION = ServerMessage.getUpdateVersion();
    public static final int SOURCENONE = 0;
    public static final int SOURCEDB = 1;
    public static final int SOURCEFILE = 2;
    public static final int SOURCEMULTI = 3;
    public static final int SOURCEXML = 4;
    public static final int SOURCEOLAP = 10;
    public static final int SOURCEXMLFILEQUERY = 7;
    public static final int SOURCEXMLDBQUERY = 8;
    public static final int SOURCEEJB = 5;
    public static final int SOURCECLASS = 6;
    public static final int SOURCESOAP = 12;
    public static final int SOURCESALESFORCE = 11;
    public static final int SOURCESOAPOLD = 9;
    public static final int SOURCEEXCEL = 13;
    public static final String DEFAULT_CHART_FOLDER = "chart/";
    private boolean saveNoData = false;
    static final int BACKUPROWCOUNT = 2;
    protected Report report;
    protected boolean createHtml = false;
    protected boolean useSwing = false;
    protected boolean usePageViewer = false;
    protected boolean createXML = false;
    protected boolean createPAK = false;
    protected boolean saveAllData = false;
    protected DrillDownNode drillDownNode = null;
    protected Vector<SubReportObject> subReports = null;
    boolean isSubReport = false;
    protected String fullFilename = null;
    protected boolean saveReportWithData = false;
    private FileInMemTable subFilesTable = new FileInMemTable();

    public SaveReport(Report report) {
        if (report != null) {
            this.saveAllData = report.saveAllData;
            if (report.isCrossTabFixedField() && report.getReportTables().elementAt(0).getFixedFieldColumnBreakColumnCount() > 1) {
                try {
                    Report newReport;
                    this.report = newReport = report.setNewData(report.colData, report.colInfo, report.reportType, report.colDataSorted, true);
                    this.saveAllData = report.saveAllData;
                    return;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to create SaveReport", ex);
                }
            }
            this.report = report;
            this.subFilesTable = report.getSubFilesTable();
            this.subReports = report.subReports;
        }
    }

    public SaveReport(Report report, boolean isDesignMode) {
        if (report != null) {
            this.saveAllData = report.saveAllData;
            if (report.isCrossTabFixedField() && (!isDesignMode || report.getReportTables().elementAt(0).getFixedFieldColumnBreakColumnCount() > 1)) {
                try {
                    Report newReport;
                    this.report = newReport = report.setNewData(report.colData, report.colInfo, report.reportType, report.colDataSorted, true);
                    return;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to create SaveReport instance", ex);
                }
            }
        }
        this.report = report;
    }

    public SaveReport() {
    }

    public SaveReport(FileInMemTable subFilesTable) {
        this(null, subFilesTable);
    }

    public SaveReport(Report report, FileInMemTable subFilesTable) {
        this(report);
        this.subFilesTable = subFilesTable;
        if (report != null) {
            this.subReports = report.subReports;
            this.drillDownNode = report.currentNode;
        }
    }

    public void setDrillDownNode(DrillDownNode t) {
        this.drillDownNode = t;
    }

    public void setSubReports(Vector<SubReportObject> sr) {
        this.subReports = sr;
    }

    public void saveAllChartsFromTheMemoryTableToFileSystem() {
        if (this.subFilesTable != null) {
            Enumeration keys = this.subFilesTable.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (key.toLowerCase().endsWith(".rpt") || key.toLowerCase().endsWith(".pak") || key.toLowerCase().endsWith(".qrp")) continue;
                byte[] chart = this.subFilesTable.get(key);
                if (key.toLowerCase().endsWith(".xml") && !QbUtil.isXMLChart(chart)) continue;
                WriteDataFile wdfile = new WriteDataFile();
                LOGGER.finest("Saving chart file, filename= " + key + ", to file system.");
                try {
                    wdfile.output(this.subFilesTable, chart, key);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Failed to save chart file, filename= " + key + ", to file system.", e);
                }
            }
        }
    }

    public void saveAllFilesExceptRootFileFromTheMemoryTableToFileSystem(String relativeDomainPath) {
        if (this.subFilesTable != null) {
            Enumeration keys = this.subFilesTable.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                byte[] bytes = this.subFilesTable.get(key);
                String filename = key;
                if (this.subFilesTable.getTopName().equals(key)) continue;
                if (!this.createPAK && SaveReport.isPAKFile(key)) {
                    filename = SaveReport.getRptFileName(key);
                }
                if (!SaveReport.isPAKFile(key) && !SaveReport.isRPTFile(key) && relativeDomainPath != null) {
                    filename = relativeDomainPath + DEFAULT_CHART_FOLDER + QbUtil.getFileName(key);
                    ReportChartObject[] reportChartObjects = this.report.getReportChartObjects();
                    if (reportChartObjects != null) {
                        for (ReportChartObject reportChartObject : reportChartObjects) {
                            if (!reportChartObject.getText().equals(key)) continue;
                            reportChartObject.setText(DEFAULT_CHART_FOLDER + QbUtil.getFileName(key));
                            break;
                        }
                    }
                }
                WriteDataFile wdfile = new WriteDataFile();
                LOGGER.finest("Saving file, filename= " + filename + ", to file system.");
                try {
                    wdfile.output(this.subFilesTable, bytes, filename);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Failed to save file, filename= " + filename + ", to file system.", e);
                }
            }
        }
    }

    public void saveToFile(String filename) throws Exception {
        this.saveToOutput(filename, true);
    }

    public ByteArrayOutputStream saveToOutput(String filename, boolean writeToFileSystem) throws Exception {
        return this.saveToOutput(filename, writeToFileSystem, false);
    }

    public ByteArrayOutputStream saveToOutput(String filename, boolean writeFileToFileSystem, boolean onlyAddToMemory) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        if (SaveReport.isPAKFile(filename = this.getFullFilename(filename))) {
            this.createPAK = true;
        }
        filename = this.saveToFile(filename, out);
        out.close();
        fstream.close();
        if (this.createPAK) {
            this.putFileIntoMemoryTable(filename, fstream);
        }
        if (onlyAddToMemory) {
            return fstream;
        }
        if (writeFileToFileSystem) {
            this.writeFileToFileSystem(filename, fstream);
        }
        return fstream;
    }

    private void writeFileToFileSystem(String cname, ByteArrayOutputStream fstream) throws Exception {
        WriteDataFile wdfile = new WriteDataFile();
        String securityLevel = null;
        if (this.report != null) {
            securityLevel = this.report.getPreviewSecurityLevel();
        }
        LOGGER.finest("Saving file, filename= " + cname + ", to file system.");
        wdfile.generateHtmlFile(this.createHtml, this.useSwing, this.usePageViewer, this.createXML, securityLevel);
        wdfile.output(this.subFilesTable, fstream.toByteArray(), cname);
    }

    public boolean isCreateXML() {
        return this.createXML;
    }

    public ByteArrayOutputStream saveFileToMemory(String cname) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        cname = this.saveToFile(cname, out);
        out.close();
        fstream.close();
        this.putFileIntoMemoryTable(cname, fstream);
        return fstream;
    }

    private void putFileIntoMemoryTable(String cname, ByteArrayOutputStream fstream) {
        LOGGER.finest("Saving file, filename= " + cname + ", to the memory table.");
        this.subFilesTable.put(cname, fstream.toByteArray());
    }

    void saveReportWithData() {
        this.saveReportWithData = true;
        this.saveAllData = true;
    }

    public String saveToFile(String filename, DataOutputStream out) throws Exception {
        if (filename == null || filename.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        if (this.createXML || SaveReport.isXMLFile(filename)) {
            SaveXMLReport xmlreport = new SaveXMLReport(this);
            xmlreport.saveToFile(filename, out);
            this.fullFilename = xmlreport.getFullFilename(filename);
            return this.fullFilename;
        }
        this.createXML = false;
        if (this.createPAK || SaveReport.isPAKFile(filename)) {
            LoadReport loadReport;
            int i;
            if (!SaveReport.isPAKFile(filename) && !SaveReport.isRPTFile(filename)) {
                filename = filename + ".pak";
            }
            this.createPAK = true;
            if (this.subReports != null) {
                for (i = 0; i < this.subReports.size(); ++i) {
                    SubReportObject srObject = this.subReports.elementAt(i);
                    String subReportFileName = srObject.getFileName();
                    loadReport = new LoadReport();
                    loadReport.setBackupDataUsed(true);
                    loadReport.setRelativeDomainPath(srObject.getDomainPath());
                    loadReport.setSubFilesTable(this.report.getSubFilesTable());
                    Report subReport = null;
                    String pakSRFileName = SaveReport.getPakFileName(subReportFileName);
                    byte[] subReportByteArray = null;
                    if (loadReport.getSubFilesTable() != null && Report.fileExistsInMemoryTable(loadReport.getSubFilesTable(), pakSRFileName)) {
                        subReportByteArray = loadReport.getSubFilesTable().get(pakSRFileName);
                        subReport = loadReport.loadReportFromByteArray(subReportByteArray);
                    } else {
                        subReport = srObject.getByteArray() != null ? loadReport.loadReportFromByteArray(srObject.getByteArray()) : loadReport.loadReportFromFile(subReportFileName);
                    }
                    if (srObject.getChartPath() != null) {
                        subReport.setChartPath(srObject.getChartPath());
                    }
                    if (srObject.getImagePath() != null) {
                        subReport.setImagePath(srObject.getImagePath());
                    }
                    if (subReport.getOriginalSourceData() >= 0) {
                        subReport.sourceData = subReport.getOriginalSourceData();
                    }
                    SaveReport sr = new SaveReport(subReport);
                    sr.isSubReport = true;
                    sr.setDrillDownNode(loadReport.getDrillDownNode());
                    sr.setSaveAllData(this.saveAllData);
                    sr.createPAK = true;
                    String subReportPakFileName = SaveReport.getPakFileName(subReportFileName);
                    sr.subFilesTable = this.subFilesTable;
                    sr.saveToOutput(subReportPakFileName, false, true);
                    if (subReportByteArray == null) continue;
                    srObject.setFileName(pakSRFileName);
                    srObject.setByteArray(subReportByteArray);
                    srObject.setParameterMap(srObject.getParameterMap());
                    srObject.setParamShareReportID(srObject.getParamShareReportID());
                    this.subReports.set(i, srObject);
                }
            }
            if (this.report.currentNode != null) {
                for (i = 0; i < this.report.currentNode.getChildCount(); ++i) {
                    DrillDownNode ddNode = this.report.currentNode.getChildAt(i);
                    String ddFileName = ddNode.getFileName();
                    if (this.createPAK && ddFileName != null && SaveReport.isRPTFile(ddFileName) && this.isFileInTheSubFilesTable(SaveReport.getPakFileName(ddFileName))) {
                        ddNode.setFileName(SaveReport.getPakFileName(ddFileName));
                    }
                    ddFileName = LoadReport.generateFullName(ddNode.getFileName(this.subFilesTable));
                    loadReport = new LoadReport();
                    loadReport.setSubFilesTable(this.subFilesTable);
                    loadReport.setBackupDataUsed(true);
                    loadReport.setRelativeDomainPath(ddNode.getDomainPath());
                    Report ddReport = null;
                    ddReport = this.createPAK && this.subFilesTable.get(ddFileName) != null ? loadReport.loadPakReportFromByteArray(ddFileName, this.subFilesTable.get(ddFileName)) : loadReport.loadReportFromFile(ddFileName, null, null, false, false);
                    if (ddNode.getChartPath() != null) {
                        ddReport.setChartPath(ddNode.getChartPath());
                    }
                    if (ddNode.getImagePath() != null) {
                        ddReport.setImagePath(ddNode.getImagePath());
                    }
                    if (ddNode.getDrillDownPath() != null) {
                        ddReport.setDrillDownPath(ddNode.getDrillDownPath());
                    }
                    if (ddNode.getSubReportPath() != null) {
                        ddReport.setSubReportPath(ddNode.getSubReportPath());
                    }
                    SaveReport sr = new SaveReport(ddReport);
                    sr.setSubReports(ddReport.subReports);
                    sr.setSaveAllData(this.saveAllData);
                    sr.setSubFilesTable(this.subFilesTable);
                    sr.createPAK = true;
                    if (!loadReport.isPacked) {
                        for (int j = 0; j < ddNode.getChildCount(); ++j) {
                            String ddNodeChildFileName = ddNode.getChildAt(j).getFileName(this.subFilesTable);
                            if (ddNodeChildFileName.equals(ddReport.currentNode.getChildAt(j))) continue;
                            ddReport.currentNode.getChildAt(j).setFileName(ddNodeChildFileName);
                        }
                        String ddPakFileName = SaveReport.getPakFileName(ddFileName);
                        sr.saveToOutput(ddPakFileName, false, true);
                        continue;
                    }
                    sr.saveToOutput(ddFileName, false, true);
                }
            }
        } else {
            if (!SaveReport.isRPTFile(filename) && !SaveReport.isQRPFile(filename)) {
                filename = filename + ".rpt";
            }
            if (SaveReport.isRPTFile(filename)) {
                LoadReport loadReport;
                int i;
                if (this.subReports != null) {
                    for (i = 0; i < this.subReports.size(); ++i) {
                        SubReportObject srObject = this.subReports.elementAt(i);
                        String subReportFileName = srObject.getFileName();
                        loadReport = new LoadReport();
                        loadReport.setBackupDataUsed(true);
                        loadReport.setRelativeDomainPath(srObject.getDomainPath());
                        loadReport.setSubFilesTable(this.subFilesTable);
                        Report subReport = null;
                        String rptSRFileName = SaveReport.getRptFileName(subReportFileName);
                        byte[] subReportByteArray = null;
                        if (this.subFilesTable != null && Report.fileExistsInMemoryTable(this.subFilesTable, rptSRFileName)) {
                            subReportByteArray = this.subFilesTable.get(rptSRFileName);
                            subReport = loadReport.loadReportFromByteArray(subReportByteArray);
                        } else if (loadReport.getSubFilesTable() != null && Report.fileExistsInMemoryTable(this.subFilesTable, SaveReport.getPakFileName(subReportFileName))) {
                            subReportByteArray = this.subFilesTable.get(SaveReport.getPakFileName(subReportFileName));
                            subReport = loadReport.loadReportFromByteArray(subReportByteArray);
                        } else {
                            subReport = srObject.getByteArray() != null ? loadReport.loadReportFromByteArray(srObject.getByteArray()) : loadReport.loadReportFromFile(subReportFileName);
                        }
                        if (srObject.getChartPath() != null) {
                            subReport.setChartPath(srObject.getChartPath());
                        }
                        if (srObject.getImagePath() != null) {
                            subReport.setImagePath(srObject.getImagePath());
                        }
                        if (subReport.getOriginalSourceData() >= 0) {
                            subReport.sourceData = subReport.getOriginalSourceData();
                        }
                        if (srObject.getFileName() != null && !SaveReport.isRPTFile(srObject.getFileName())) {
                            srObject.setFileName(rptSRFileName);
                        }
                        SaveReport sr = new SaveReport(subReport);
                        sr.isSubReport = true;
                        DrillDownNode drillDownNode2 = loadReport.getDrillDownNode();
                        if (drillDownNode2 != null) {
                            drillDownNode2.setFileName(SaveReport.getRptFileName(drillDownNode2.getFileName()));
                            sr.setDrillDownNode(drillDownNode2);
                            if (drillDownNode2.children() != null) {
                                Enumeration<TreeNode> children = drillDownNode2.children();
                                while (children.hasMoreElements()) {
                                    DrillDownNode node = (DrillDownNode)children.nextElement();
                                    node.setFileName(SaveReport.getRptFileName(node.getFileName()));
                                }
                            }
                        }
                        sr.setSaveAllData(this.saveAllData);
                        sr.createPAK = false;
                        sr.setSubFilesTable(this.subFilesTable);
                        sr.saveToOutput(rptSRFileName, true, false);
                        if (subReportByteArray == null) continue;
                        SubReportObject subReportObj = new SubReportObject();
                        subReportObj.setFileName(rptSRFileName);
                        subReportObj.setByteArray(subReportByteArray);
                        subReportObj.setParameterMap(srObject.getParameterMap());
                        subReportObj.setParamShareReportID(srObject.getParamShareReportID());
                        this.subReports.set(i, subReportObj);
                    }
                }
                if (this.report.currentNode != null) {
                    for (i = 0; i < this.report.currentNode.getChildCount(); ++i) {
                        DrillDownNode ddNode = this.report.currentNode.getChildAt(i);
                        String ddFileName = LoadReport.generateFullName(ddNode.getFileName(this.subFilesTable));
                        loadReport = new LoadReport();
                        loadReport.setSubFilesTable(this.subFilesTable);
                        loadReport.setBackupDataUsed(true);
                        loadReport.setRelativeDomainPath(ddNode.getDomainPath());
                        Report ddReport = null;
                        ddReport = this.subFilesTable.get(ddFileName) != null ? loadReport.loadPakReportFromByteArray(ddFileName, this.subFilesTable.get(ddFileName)) : (this.subFilesTable.get(SaveReport.getPakFileName(ddFileName)) != null ? loadReport.loadPakReportFromByteArray(ddFileName, this.subFilesTable.get(SaveReport.getPakFileName(ddFileName))) : loadReport.loadReportFromFile(SaveReport.getRptFileName(ddFileName), null, null, false, false));
                        if (ddNode.getChartPath() != null) {
                            ddReport.setChartPath(ddNode.getChartPath());
                        }
                        if (ddNode.getImagePath() != null) {
                            ddReport.setImagePath(ddNode.getImagePath());
                        }
                        if (ddNode.getDrillDownPath() != null) {
                            ddReport.setDrillDownPath(ddNode.getDrillDownPath());
                        }
                        if (ddNode.getSubReportPath() != null) {
                            ddReport.setSubReportPath(ddNode.getSubReportPath());
                        }
                        SaveReport sr = new SaveReport(ddReport);
                        sr.setSubReports(ddReport.subReports);
                        sr.setSaveAllData(this.saveAllData);
                        sr.setSubFilesTable(this.subFilesTable);
                        sr.createPAK = false;
                        for (int j = 0; j < ddNode.getChildCount(); ++j) {
                            String ddNodeChildFileName = ddNode.getChildAt(j).getFileName(this.subFilesTable);
                            if (ddNodeChildFileName.equals(ddReport.currentNode.getChildAt(j))) continue;
                            ddReport.currentNode.getChildAt(j).setFileName(SaveReport.getRptFileName(ddNodeChildFileName));
                        }
                        String ddRptFileName = SaveReport.getRptFileName(ddFileName);
                        sr.saveToOutput(ddRptFileName, true, false);
                    }
                }
                this.saveAllChartsFromTheMemoryTableToFileSystem();
            }
        }
        this.saveData(out);
        this.fullFilename = filename;
        return filename;
    }

    public boolean isFileInTheSubFilesTable(String fileName) {
        return this.subFilesTable != null && this.subFilesTable.containsKey(fileName);
    }

    public void generateHtmlFile(boolean createHtml, boolean useSwing, boolean usePageViewer) {
        this.createHtml = createHtml;
        this.useSwing = useSwing;
        this.usePageViewer = usePageViewer;
    }

    public void generateXMLFile(boolean createXML) {
        this.createXML = createXML;
    }

    public void generatePAKFile(boolean createPAK) {
        this.createPAK = createPAK;
    }

    public void setSaveAllData(boolean saveAllData) {
        this.saveAllData = this.report != null && this.report.isFreeFormCrossTab() ? true : saveAllData;
    }

    public FileInMemTable getSubFilesTable() {
        return this.subFilesTable;
    }

    public void setSubFilesTable(FileInMemTable subFilesTable) {
        this.subFilesTable = subFilesTable;
    }

    void exportReport(OutputStream stream) throws Exception {
        DataOutputStream out = new DataOutputStream(stream);
        if (this.createXML) {
            SaveXMLReport xmlreport = new SaveXMLReport(this);
            xmlreport.saveData(out);
        } else {
            this.saveData(out);
        }
        out.close();
    }

    private void saveDataHeader(DataOutput out) throws Exception {
        int sourceData;
        int n = sourceData = this.report.getOriginalSourceData() > 0 && this.report.sourceData == 0 ? this.report.getOriginalSourceData() : this.report.sourceData;
        if (this.saveReportWithData) {
            sourceData = 0;
        }
        out.writeInt(sourceData);
        if (sourceData != 0) {
            if (this.saveAllData && !this.saveNoData) {
                this.saveColData(out, this.report.colData);
            } else if (this.report.getBackupQuery() != null || this.saveNoData) {
                this.saveColData(out, this.report.colData, 0);
            } else {
                this.saveColData(out, this.report.colData, 2);
            }
        }
        if (sourceData == 1) {
            DBInfoBasic dbInfo = this.report.dbInfo;
            new DBInfoBasic(dbInfo).write(out);
            boolean hasQueryFilename = this.report.queryFilename != null && !this.report.queryFilename.equals("");
            out.writeBoolean(hasQueryFilename);
            if (hasQueryFilename) {
                IOUtil.writeString(out, Coder.encode(this.report.queryFilename));
            } else {
                boolean failed = true;
                ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                DataOutput dout = new DataOutputStream(bytestream);
                dout = new VersioningDataOutput(dout);
                if (dbInfo instanceof IQueryFileInfo) {
                    try {
                        quadbase.reportdesigner.util.IQueryInParam[][] parameterInPromptSequence;
                        IQueryInParam[] params = null;
                        params = dbInfo instanceof QueryFileInfo ? ((QueryFileInfo)dbInfo).getInParam() : ReportUtil.getInParam(dbInfo);
                        if (params != null) {
                            dout.writeInt(params.length);
                            for (int i = 0; i < params.length; ++i) {
                                Object currP = null;
                                boolean multiValue = false;
                                if (params[i] instanceof IQueryMultiValueInParam) {
                                    multiValue = true;
                                    currP = new QueryMultiValueInParam((IQueryMultiValueInParam)params[i], dbInfo.getQuery());
                                } else {
                                    currP = new QueryInParam(params[i], dbInfo.getQuery());
                                }
                                if (this.report.parentNode != null) {
                                    if (multiValue) {
                                        if (params[i].getValue() != null && !params[i].getValue().equals("")) {
                                            ((QueryInParam)currP).setDefaultValue(params[i].getValue());
                                            ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)params[i]).getValues());
                                        } else {
                                            ((QueryMultiValueInParam)currP).setDefaultValue(((IQueryMultiValueInParam)params[i]).getDefaultValue());
                                            if (params[i] instanceof QueryMultiValueInParam) {
                                                ((QueryMultiValueInParam)currP).setValue(((QueryMultiValueInParam)params[i]).getDefaultValue((QueryFileInfo)dbInfo));
                                            } else {
                                                ((QueryMultiValueInParam)currP).setValue(((IQueryMultiValueInParam)params[i]).getDefaultValue());
                                            }
                                        }
                                    } else if (params[i].getValue() != null && !params[i].getValue().equals("")) {
                                        ((QueryInParam)currP).setDefaultValue(params[i].getValue());
                                        ((QueryInParam)currP).setValue(params[i].getValue());
                                    } else {
                                        ((QueryInParam)currP).setDefaultValue(params[i].getDefaultValue());
                                        if (params[i] instanceof QueryInParam) {
                                            ((QueryInParam)currP).setValue(((QueryInParam)params[i]).getDefaultValue((QueryFileInfo)dbInfo));
                                        } else {
                                            ((QueryInParam)currP).setValue(params[i].getDefaultValue());
                                        }
                                    }
                                }
                                ((QueryInParam)currP).write(dout);
                            }
                            if (dout instanceof VersioningDataOutput) {
                                ((VersioningDataOutput)dout).flush();
                            } else if (dout instanceof DataOutputStream) {
                                ((DataOutputStream)dout).flush();
                            }
                            failed = false;
                        }
                        if ((parameterInPromptSequence = ReportUtil.getParamInSequence(dbInfo)) != null) {
                            dout.writeBoolean(true);
                            dout.writeInt(parameterInPromptSequence.length);
                            for (quadbase.reportdesigner.util.IQueryInParam[] element : parameterInPromptSequence) {
                                dout.writeInt(element.length);
                                for (quadbase.reportdesigner.util.IQueryInParam element2 : element) {
                                    String paramName = null;
                                    if (element2 != null) {
                                        paramName = element2.getParamName();
                                    }
                                    IOUtil.writeString(dout, paramName);
                                }
                            }
                        } else {
                            dout.writeBoolean(false);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to write prameters", ex);
                    }
                }
                if (failed) {
                    out.writeInt(0);
                } else if (out instanceof VersioningDataOutput) {
                    ((VersioningDataOutput)out).getOriginalDataOutput().write(bytestream.toByteArray());
                } else {
                    out.write(bytestream.toByteArray());
                }
            }
        } else if (sourceData == 2 || sourceData == 4 || sourceData == 6) {
            IOUtil.writeString(out, Coder.encode(this.report.sourceFile));
            out.writeBoolean(this.report.sourceData == 6 && this.report.dbInfo != null && this.report.dbInfo instanceof QueryClassFileInfo);
        } else if (sourceData == 7) {
            XMLFileQueryInfo xmlFileQueryInfo;
            out.writeBoolean(false);
            XMLFileQueryInfo temp = xmlFileQueryInfo = this.report.xmlFileQueryInfo;
            if (this.report.dbInfo instanceof QueryXMLFileInfo) {
                QueryInParam[] params = xmlFileQueryInfo.getInSet().getParameter();
                QueryInParam[] temp_params = new QueryInParam[params.length];
                for (int i = 0; i < params.length; ++i) {
                    QueryInParam currP = null;
                    boolean multiValue = false;
                    if (params[i] instanceof IQueryMultiValueInParam) {
                        multiValue = true;
                        currP = new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)params[i]), xmlFileQueryInfo.getCondition());
                    } else {
                        currP = new QueryInParam(params[i], xmlFileQueryInfo.getCondition());
                    }
                    if (this.report.parentNode != null) {
                        if (multiValue) {
                            if (params[i].getValue() != null && !params[i].getValue().equals("")) {
                                currP.setDefaultValue(params[i].getValue());
                                ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)((Object)params[i])).getValues());
                            } else {
                                ((QueryMultiValueInParam)currP).setDefaultValue(((IQueryMultiValueInParam)((Object)params[i])).getDefaultValue());
                                ((QueryMultiValueInParam)currP).setValue(((IQueryMultiValueInParam)((Object)params[i])).getDefaultValue());
                            }
                        } else if (params[i].getValue() != null && !params[i].getValue().equals("")) {
                            currP.setDefaultValue(params[i].getValue());
                            currP.setValue(params[i].getValue());
                        } else {
                            currP.setDefaultValue(params[i].getDefaultValue());
                            currP.setValue(params[i].getDefaultValue());
                        }
                    }
                    temp_params[i] = currP;
                }
                temp = xmlFileQueryInfo.getFileName() != null ? new XMLFileQueryInfo(xmlFileQueryInfo.getFileName(), xmlFileQueryInfo.getFieldInfo(), xmlFileQueryInfo.getCondition(), xmlFileQueryInfo.getConditionInfo(), xmlFileQueryInfo.getDTDName(), xmlFileQueryInfo.isVerify(), new QueryInParamSet(temp_params, xmlFileQueryInfo.getInSet().getParameterInPromptSequence()), xmlFileQueryInfo.getDTDTreeFileName()) : new XMLFileQueryInfo((InputStream)new ByteArrayInputStream(xmlFileQueryInfo.getData()), xmlFileQueryInfo.getFieldInfo(), xmlFileQueryInfo.getCondition(), xmlFileQueryInfo.getConditionInfo(), new ByteArrayInputStream(xmlFileQueryInfo.getDTD()), xmlFileQueryInfo.isVerify(), new QueryInParamSet(temp_params, xmlFileQueryInfo.getInSet().getParameterInPromptSequence()));
            }
            temp.write(out);
            out.writeBoolean(this.report.dbInfo instanceof QueryXMLFileInfo);
        } else {
            if (sourceData == 9) {
                throw new Exception(LanguageEncoder.getText("Cannot save report with the old SOAP data source. Please update your datasource before saving."));
            }
            if (sourceData == 12) {
                this.report.soapInfo.write(out, (short)296);
            } else if (sourceData == 11) {
                this.report.sfQueryInfo.write(out);
            } else if (sourceData == 13) {
                this.report.excelInfo.write(out);
            } else if (sourceData == 10) {
                IOUtil.writeString(out, Coder.encode(this.report.mondrianConnectionString));
                IOUtil.writeString(out, Coder.encode(this.report.MDXQuery));
                IOUtil.writeString(out, Coder.encode(this.report.xmlaURI));
                IOUtil.writeString(out, Coder.encode(this.report.xmlaDataSource));
                IOUtil.writeString(out, Coder.encode(this.report.xmlaCatalog));
            } else if (sourceData == 5) {
                out.writeInt(2);
                IOUtil.writeString(out, Coder.encode(this.report.jndiName));
                IOUtil.writeString(out, Coder.encode(this.report.homeName));
                IOUtil.writeString(out, Coder.encode(this.report.remoteName));
                IOUtil.writeString(out, Coder.encode(this.report.selectedMethodName));
                Object[] vals = this.report.selectedMethodParamVal;
                out.writeInt(vals.length);
                for (Object val : vals) {
                    IOUtil.writeString(out, Coder.encode(val.getClass().getName()));
                    IOUtil.writeString(out, Coder.encode(val.toString()));
                }
                int envsize = 0;
                if (this.report.environment != null) {
                    envsize = this.report.environment.size();
                }
                out.writeInt(envsize);
                if (this.report.environment != null) {
                    Enumeration<String> e = this.report.environment.keys();
                    while (e.hasMoreElements()) {
                        String key = e.nextElement();
                        IOUtil.writeString(out, Coder.encode(key));
                        IOUtil.writeString(out, Coder.encode(this.report.environment.get(key)));
                    }
                }
            } else if (sourceData == 3) {
                out.writeInt(this.report.sourceList.length);
                for (int i = 0; i < this.report.sourceList.length; ++i) {
                    Object temp = this.report.sourceList[i];
                    if (temp instanceof DBInfoBasic) {
                        out.writeInt(1);
                        ((DBInfoBasic)temp).write(out);
                    } else if (this.report.sourceType[i] == 4) {
                        out.writeInt(4);
                        IOUtil.writeString(out, Coder.encode((String)temp));
                    } else if (this.report.sourceType[i] == 6) {
                        out.writeInt(6);
                        IOUtil.writeString(out, Coder.encode((String)temp));
                    } else if (this.report.sourceType[i] == 7) {
                        out.writeInt(7);
                        XMLFileQueryInfo xmlFileQueryInfo = (XMLFileQueryInfo)temp;
                        xmlFileQueryInfo.write(out);
                    } else if (this.report.sourceType[i] == 5) {
                        out.writeInt(5);
                        out.writeInt(2);
                        EJBInfo ejbInfo = (EJBInfo)temp;
                        IOUtil.writeString(out, Coder.encode(ejbInfo.getJNDIName()));
                        IOUtil.writeString(out, Coder.encode(ejbInfo.getHomeName()));
                        IOUtil.writeString(out, Coder.encode(ejbInfo.getRemoteName()));
                        IOUtil.writeString(out, Coder.encode(ejbInfo.getSelectedMethodName()));
                        Object[] vals = ejbInfo.getSelectedMethodParamVal();
                        out.writeInt(vals.length);
                        for (Object val : vals) {
                            IOUtil.writeString(out, Coder.encode(val.getClass().getName()));
                            IOUtil.writeString(out, Coder.encode(val.toString()));
                        }
                        Hashtable<String, String> thisEnvironment = ejbInfo.getEnvironment();
                        int envsize = 0;
                        if (thisEnvironment != null) {
                            envsize = thisEnvironment.size();
                        }
                        out.writeInt(envsize);
                        if (thisEnvironment != null) {
                            Enumeration<String> e = thisEnvironment.keys();
                            while (e.hasMoreElements()) {
                                String key = e.nextElement();
                                IOUtil.writeString(out, Coder.encode(key));
                                IOUtil.writeString(out, Coder.encode(thisEnvironment.get(key)));
                            }
                        }
                    } else {
                        out.writeInt(2);
                        IOUtil.writeString(out, Coder.encode((String)temp));
                    }
                    out.writeBoolean(this.report.doTranspose[i]);
                    IOUtil.writeBooleans(out, (boolean[])this.report.transposeColList[i]);
                }
            } else if (sourceData == 0) {
                ColData[] memDataSrc = this.report.originalColDataFromMemSource;
                if (this.saveReportWithData) {
                    memDataSrc = this.report.colData;
                }
                out.writeBoolean(memDataSrc != null);
                if (memDataSrc != null) {
                    this.saveColData(out, memDataSrc);
                }
            }
        }
        if (!this.saveReportWithData) {
            out.writeBoolean(this.report.isTransposed);
            IOUtil.writeBooleans(out, this.report.transposeCol);
        } else {
            out.writeBoolean(false);
            IOUtil.writeBooleans(out, new boolean[0]);
        }
    }

    public void saveData(DataOutput orgOut) throws Exception {
        int i;
        orgOut.writeInt(7004);
        DataOutput out = orgOut;
        if (!(orgOut instanceof VersioningDataOutput)) {
            out = new VersioningDataOutput(orgOut);
            ((VersioningDataOutput)out).setSubFilesTable(this.subFilesTable);
        }
        IOUtil.writeString(out, this.report.registryID);
        IOUtil.writeString(out, this.report.dataSourceID);
        IOUtil.writeString(out, this.report.dataSourceLoc);
        out.writeBoolean(this.createPAK);
        out.writeBoolean(this.saveAllData);
        if (!this.createPAK) {
            this.saveTree(out, this.drillDownNode);
        } else {
            this.saveDrillDownTreeByteArrays(out, this.drillDownNode);
        }
        if (!this.createPAK) {
            this.saveSubReports(out, this.subReports);
        } else {
            this.saveSubReportsByteArrays(out, this.subReports);
        }
        String newQuery = null;
        if (this.report.getBackupQuery() != null) {
            newQuery = this.report.dbInfo.getQuery();
            this.report.dbInfo.setQuery(this.report.getBackupQuery());
        }
        this.saveDataHeader(out);
        if (newQuery != null) {
            this.report.dbInfo.setQuery(newQuery);
        }
        out.writeInt(this.report.getFormulaParameters().size());
        for (int i2 = 0; i2 < this.report.getFormulaParameters().size(); ++i2) {
            this.report.getFormulaParameters().elementAt(i2).write(out, this.saveReportWithData);
        }
        Hashtable<String, QueryInParam[]> securityQueryParameterMap = this.report.getSecurityQueryParameterMap();
        if (securityQueryParameterMap != null) {
            Enumeration<String> levels = securityQueryParameterMap.keys();
            out.writeInt(securityQueryParameterMap.size());
            while (levels.hasMoreElements()) {
                String levelname = levels.nextElement();
                IOUtil.writeStr(out, levelname);
                IQueryInParam[] params = securityQueryParameterMap.get(levelname);
                if (params != null) {
                    out.writeInt(params.length);
                    IQueryInParam[] iQueryInParamArray = params;
                    int n = iQueryInParamArray.length;
                    for (int j = 0; j < n; ++j) {
                        IQueryInParam param = iQueryInParamArray[j];
                        QueryInParam currP = null;
                        if (param instanceof IQueryMultiValueInParam) {
                            currP = new QueryMultiValueInParam((IQueryMultiValueInParam)param, null);
                            ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)param).getValues());
                        } else {
                            currP = new QueryInParam(param, null);
                            currP.setValue(param.getValue());
                        }
                        currP.write(out);
                    }
                    continue;
                }
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
        }
        Vector<Parameter> queryParamVec = this.report.getQueryParameters();
        out.writeInt(queryParamVec.size());
        for (int i3 = 0; i3 < queryParamVec.size(); ++i3) {
            queryParamVec.elementAt(i3).writeShareInfo(out);
        }
        out.writeBoolean(this.report.limitSubReportQueryExecution);
        out.writeBoolean(this.report.isPrevParamPrompt);
        Vector<Formula> formulas = this.report.formulas;
        if (this.saveReportWithData) {
            formulas = this.report.getFormulasWithFixParameters();
        }
        out.writeInt(formulas.size());
        for (i = 0; i < formulas.size(); ++i) {
            formulas.elementAt(i).write(out);
        }
        out.writeInt(this.report.scripts.size());
        LOGGER.finest("Save scripts: size= " + this.report.scripts.size());
        for (i = 0; i < this.report.scripts.size(); ++i) {
            this.report.scripts.elementAt(i).write(out);
        }
        out.writeInt(this.report.colInfo.length);
        for (ColInfo element : this.report.colInfo) {
            element.write(out);
        }
        out.writeInt(this.report.getReportType());
        int fontMappingSize = 0;
        if (this.report.fontMapping != null) {
            fontMappingSize = this.report.fontMapping.size();
        }
        out.writeInt(fontMappingSize);
        if (this.report.fontMapping != null) {
            Enumeration<String> e = this.report.fontMapping.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                IOUtil.writeString(out, Coder.encode(key));
                IOUtil.writeString(out, Coder.encode(this.report.fontMapping.get(key)));
            }
        }
        out.writeInt(this.report.getTopN());
        out.writeBoolean(this.report.isAscending());
        out.writeBoolean(this.report.snapToGrid);
        out.writeDouble(this.report.gridStepSize);
        out.writeDouble(this.report.cmGridStepSize);
        out.writeBoolean(this.report.isAdjustFont);
        IOUtil.writeBooleans(out, this.report.rowBreakAggrIncluded);
        IOUtil.writeBooleans(out, this.report.colBreakAggrIncluded);
        if (out instanceof VersioningDataOutput) {
            ((VersioningDataOutput)out).writeBoolean(this.report.isKeepDataSourceOrder(), (short)6604);
        }
        out.writeBoolean(this.report.isShowRowAggregationGrandTotal());
        out.writeBoolean(this.report.crossTabFreeForm);
        out.writeBoolean(this.report.isShowRowAggregationSubtotal());
        if (out instanceof VersioningDataOutput) {
            ((VersioningDataOutput)out).writeBoolean(this.report.isRowAggregationSubtotalOnLeft(), (short)6603);
        }
        if (out instanceof VersioningDataOutput) {
            ((VersioningDataOutput)out).writeBoolean(this.report.isRowAggregationGrandTotalOnLeft(), (short)7003);
        }
        if (out instanceof VersioningDataOutput) {
            ((VersioningDataOutput)out).writeBoolean(this.report.isReOrderColumns(), (short)7004);
        }
        out.writeBoolean(this.report.isShowColumnAggregation());
        out.writeBoolean(this.report.isColumnAggregationInHeader());
        out.writeBoolean(this.report.isAlignCrossTabColBkValHori());
        this.saveColDataAttr(out, this.report.colData);
        IOUtil.writeString(out, Coder.encode(this.report.getName()));
        out.writeDouble(this.report.getPageWidth());
        out.writeDouble(this.report.getPageHeight());
        out.writeDouble(this.report.getLeftMargin());
        out.writeDouble(this.report.getRightMargin());
        out.writeDouble(this.report.getTopMargin());
        out.writeDouble(this.report.getBottomMargin());
        out.writeInt(this.report.getOrientation());
        IOUtil.writeStr(out, this.report.getColumnWrap() != null ? this.report.getColumnWrap().getID() : null);
        out.writeBoolean(this.report.hasTitle);
        out.writeBoolean(this.report.hasLogo);
        out.writeBoolean(this.report.hasPageNumber);
        out.writeBoolean(this.report.hasDate);
        IOUtil.writeStr(out, this.report.reportTitle);
        IOUtil.writeStr(out, this.report.logofile);
        out.writeInt(this.report.logoPos);
        out.writeInt(this.report.pageNumberFormat);
        out.writeInt(this.report.pageNumberPos);
        out.writeInt(this.report.dateFormat);
        out.writeInt(this.report.datePos);
        out.writeInt(this.report.reportStyle);
        IOUtil.writeStr(out, this.report.customStyleFile);
        if (this.report.getHTMLTitle() != null) {
            out.writeBoolean(true);
            IOUtil.writeStr(out, this.report.getHTMLTitle());
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.report.isUseStyleSheet());
        if (this.report.getExternalStyleSheetName() != null) {
            out.writeBoolean(true);
            IOUtil.writeStr(out, this.report.getExternalStyleSheetName());
        } else {
            out.writeBoolean(false);
        }
        if (this.report.getExportEncoding() != null) {
            out.writeBoolean(true);
            IOUtil.writeStr(out, this.report.getExportEncoding());
        } else {
            out.writeBoolean(false);
        }
        if (this.report.getHTMLCharset() != null) {
            out.writeBoolean(true);
            IOUtil.writeStr(out, this.report.getHTMLCharset());
        } else {
            out.writeBoolean(false);
        }
        if (this.report.getRTFEncoding() != null) {
            out.writeBoolean(true);
            IOUtil.writeStr(out, this.report.getRTFEncoding());
        } else {
            out.writeBoolean(false);
        }
        this.report.getPageHeader().write(out, this.createPAK);
        this.report.getReportHeader().write(out, this.createPAK);
        Vector<ReportTable> vec = this.report.getReportTables();
        out.writeInt(vec.size());
        for (int i4 = 0; i4 < vec.size(); ++i4) {
            vec.elementAt(i4).write(out, this.createPAK);
        }
        this.report.getReportFooter().write(out, this.createPAK);
        this.report.getPageFooter().write(out, this.createPAK);
        this.report.labelSetting.write(out);
        this.report.chartSetting.write(out);
        this.report.imageSetting.write(out);
        this.report.stringFormulaSetting.write(out);
        this.report.logicFormulaSetting.write(out);
        this.report.numericFormulaSetting.write(out);
        this.report.timeFormulaSetting.write(out);
        this.report.stringColumnSetting.write(out);
        this.report.logicColumnSetting.write(out);
        this.report.numericColumnSetting.write(out);
        this.report.timeColumnSetting.write(out);
        this.report.barcodeColumnSetting.write(out);
        this.report.lineSetting.write(out);
        this.report.gridSetting.write(out);
        this.report.columnHeaderSetting.write(out);
        this.report.titleSetting.write(out);
        out.writeBoolean(this.report.isApplyBoundSelected());
        this.writeDrillDownNodes(out, this.report.currentNode);
        if (this.report.parentNode == null) {
            LOGGER.finest("No parent node");
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.saveTreeNode(out, this.report.parentNode, false);
        }
        if (this.report.rootNode == null) {
            LOGGER.finest("Saving No Root Node");
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.saveTreeNode(out, this.report.rootNode, false);
        }
        out.writeBoolean(this.report.isSideBySideLayout());
        out.writeInt(this.report.getDBSourceType());
        byte[][] queryFileBytes = this.report.getQueryFileBytes();
        if (queryFileBytes == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(queryFileBytes.length);
            for (byte[] queryFileByte : queryFileBytes) {
                if (queryFileByte == null) {
                    out.writeBoolean(false);
                    continue;
                }
                out.writeBoolean(true);
                int count = queryFileByte.length;
                out.writeInt(count);
                out.write(queryFileByte);
            }
        }
        IOUtil.writeColor(out, this.report.getBackgroundColor());
        if (this.report.getBackgroundImage() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.report.getBackgroundImage().write(out, this.createPAK);
        }
        if (out instanceof VersioningDataOutput) {
            VersioningDataOutput vdo = (VersioningDataOutput)out;
            if (this.report.getPaginationSettings() != null) {
                vdo.writeBoolean(true, (short)7001);
                PaginationSettings ps = this.report.getPaginationSettings();
                vdo.writeStr(ps.getPaginationModeStr(), (short)7001);
                vdo.writeInt(ps.getSize(), (short)7001);
                if (ps.getPaginationMode().equals((Object)PaginationSettings.PaginationMode.PAGINATION)) {
                    vdo.writeStr(ps.getPaginatorPositionStr(), (short)7001);
                }
            } else {
                vdo.writeBoolean(false, (short)7001);
            }
        }
        if (out instanceof VersioningDataOutput) {
            VersioningDataOutput vdo = (VersioningDataOutput)out;
            if (this.report.getEasyReportStyle() != null) {
                vdo.writeBoolean(true, (short)7002);
                vdo.writeStr(this.report.getEasyReportStyle(), (short)7002);
            } else {
                vdo.writeBoolean(false, (short)7002);
            }
        }
        if (this.report.vGuideLines != null) {
            out.writeInt(this.report.vGuideLines.size());
            for (int i5 = 0; i5 < this.report.vGuideLines.size(); ++i5) {
                IOUtil.writeStr(out, this.report.vGuideLines.elementAt(i5).getID());
            }
        } else {
            out.writeInt(0);
        }
        if (this.report.hGuideLines != null) {
            out.writeInt(this.report.hGuideLines.size());
            for (int i6 = 0; i6 < this.report.hGuideLines.size(); ++i6) {
                IOUtil.writeStr(out, this.report.hGuideLines.elementAt(i6).getID());
            }
        } else {
            out.writeInt(0);
        }
        String nulldata = this.report.getNullDataOption();
        if (nulldata == null) {
            out.writeBytes("null");
        } else {
            out.writeBytes(nulldata);
        }
    }

    private void saveColData(DataOutput out, ColData[] colData) throws IOException {
        if (colData == null || colData.length <= 1) {
            this.saveColData(out, colData, 0, 0);
        } else {
            this.saveColData(out, colData, colData.length - 1, colData[0].getSize());
        }
    }

    private void saveColData(DataOutput out, ColData[] colData, int nRow) throws IOException {
        if (colData == null || colData.length <= 1) {
            this.saveColData(out, colData, 0, 0);
        } else {
            this.saveColData(out, colData, colData.length - 1, colData[0].getSize() >= nRow ? nRow : colData[0].getSize());
        }
    }

    private void saveColData(DataOutput out, ColData[] colData, int nCol, int nRow) throws IOException {
        ByteArrayOutputStream enstream = new ByteArrayOutputStream(2048);
        DataOutputStream enout = new DataOutputStream(enstream);
        enout.writeInt(nCol);
        enout.writeInt(nRow);
        for (int i = 0; i < nCol; ++i) {
            colData[i].save(enout, nRow);
        }
        enout.flush();
        byte[] encrypb = IOUtil.encode(enstream.toByteArray());
        out.writeInt(encrypb.length);
        out.write(encrypb, 0, encrypb.length);
    }

    private void saveColDataAttr(DataOutput out, ColData[] colData) throws IOException {
        out.writeInt(colData.length);
        for (ColData cd : colData) {
            out.writeInt(cd.getOriginalDataType());
            LOGGER.finest("saveColDataAttr, format is " + cd.dataFormat.getFormatType());
            FormatUtil.writeDataFormat(out, cd.dataFormat);
        }
    }

    private void saveTree(DataOutput out, DrillDownNode node) throws Exception {
        if (node == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        this.saveTreeNode(out, node, true);
    }

    /*
     * WARNING - void declaration
     */
    private void saveTreeNode(DataOutput out, DrillDownNode node, boolean saveChildren) throws Exception {
        IOUtil.writeString(out, node.getName());
        String fname = node.getFileName(this.subFilesTable);
        if (!(SaveReport.isPAKFile(fname) || SaveReport.isRPTFile(fname) || SaveReport.isXMLFile(fname))) {
            if (!node.isRoot()) {
                LoadReport lr = new LoadReport(true);
                lr.setSubFilesTable(this.report.getSubFilesTable());
                Report report = lr.loadReportFromFile(fname);
                SaveReport sr = new SaveReport(report);
                sr.setDrillDownNode(lr.getDrillDownNode());
                sr.setSubReports(lr.getSubReports());
                node.setFileName(node.filename.substring(0, node.filename.length() - 4) + ".rpt");
                sr.subFilesTable = this.report.getSubFilesTable();
                sr.saveToFile(node.getFileName(this.subFilesTable));
            } else if (fname.indexOf(46) > -1) {
                node.setFileName(node.filename.substring(0, node.filename.length() - 4) + ".rpt");
            } else {
                node.setFileName(node.filename + ".rpt");
            }
        }
        IOUtil.writeString(out, node.filename);
        int[] mapping = node.getColumnMapping();
        out.writeInt(mapping.length);
        for (int element : mapping) {
            out.writeInt(element);
        }
        out.writeBoolean(node.isCrossTabDrillDown());
        if (saveChildren) {
            void var6_9;
            out.writeInt(node.getChildCount());
            boolean bl = false;
            while (var6_9 < node.getChildCount()) {
                this.saveTreeNode(out, node.getChildAt((int)var6_9), true);
                ++var6_9;
            }
        }
    }

    public static void saveTree(String url, DrillDownNode node, FileInMemTable subFilesTable, boolean saveToFileSystem) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        String filename = LoadReport.generateFullName(url);
        SaveReport.saveTree(filename, node, out, subFilesTable);
        out.close();
        fstream.close();
        if (saveToFileSystem) {
            WriteDataFile wdfile = new WriteDataFile();
            wdfile.output(subFilesTable, fstream.toByteArray(), filename);
        }
        SaveReport saveReport = new SaveReport(subFilesTable);
        saveReport.putFileIntoMemoryTable(filename, fstream);
    }

    public static void saveTree(String url, DrillDownNode node, DataOutputStream out, FileInMemTable subFilesTable) throws Exception {
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream orgIn = null;
        DataInput in = null;
        int version = -1;
        String registryID = null;
        String dataSourceID = null;
        String dataSourceLoc = null;
        boolean isPacked = false;
        boolean oldversion = false;
        boolean saveData = false;
        String filename = LoadReport.generateFullName(url);
        LoadReport loadReport = null;
        if (!IOUtil.isXMLFormat(filename)) {
            orgIn = readfile.getInputStream(subFilesTable, filename);
            in = orgIn;
            version = orgIn.readInt();
            if (version >= 288) {
                in = new VersioningDataInput(orgIn, 7004);
            }
            if (version >= 135) {
                registryID = IOUtil.readString(in, true);
                dataSourceID = IOUtil.readString(in, true);
                dataSourceLoc = IOUtil.readString(in, true);
            }
            if (version >= 132) {
                isPacked = in.readBoolean();
            }
            if (version >= 179) {
                saveData = in.readBoolean();
            }
            if (!isPacked) {
                if (version > 20) {
                    loadReport = new LoadReport(version);
                    loadReport.loadTree(in);
                } else {
                    oldversion = true;
                }
            } else {
                loadReport = new LoadReport(version);
                loadReport.loadDrillDownTreeByteArrays(in);
            }
        }
        if (IOUtil.isXMLFormat(filename) || oldversion) {
            Report loadedReport = null;
            loadedReport = loadReport != null ? loadReport.loadReportFromFile(filename, true) : new LoadReport().loadReportFromFile(filename, true);
            SaveReport sr = new SaveReport(loadedReport);
            if (IOUtil.isXMLFormat(filename)) {
                sr = new SaveXMLReport(sr);
            }
            sr.setSubReports(loadedReport.subReports);
            sr.setDrillDownNode(node);
            sr.saveData(out);
            return;
        }
        out.writeInt(version);
        DataOutput vout = out;
        if (version >= 288) {
            vout = new VersioningDataOutput(out, subFilesTable);
        }
        if (version >= 135) {
            IOUtil.writeString(vout, registryID);
            IOUtil.writeString(vout, dataSourceID);
            IOUtil.writeString(vout, dataSourceLoc);
        }
        if (version >= 132) {
            vout.writeBoolean(isPacked);
        }
        if (version >= 179) {
            vout.writeBoolean(saveData);
        }
        if (!isPacked) {
            SaveReport sr = new SaveReport(subFilesTable);
            sr.saveTree(vout, node);
        } else {
            SaveReport sr = new SaveReport(subFilesTable);
            sr.saveDrillDownTreeByteArrays(vout, node);
        }
        IOUtil.copyStream(orgIn, out);
        readfile.close();
    }

    private void saveDrillDownTreeByteArrays(DataOutput out, DrillDownNode node) throws Exception {
        LOGGER.finest("save drilldown node is :" + node);
        if (node == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        this.saveDrillDownNodeByteArray(out, node, true);
    }

    private void saveDrillDownNodeByteArray(DataOutput out, DrillDownNode node, boolean saveChildren) throws Exception {
        block11: {
            IOUtil.writeString(out, node.getName());
            IOUtil.writeString(out, node.filename);
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream(2048);
            ReadDataFile readfile = new ReadDataFile();
            String filename = LoadReport.generateFullName(node.getFileName(this.subFilesTable));
            String pakFileName = SaveReport.getPakFileName(filename);
            if (Report.fileExists(this.subFilesTable, pakFileName)) {
                filename = pakFileName;
            }
            if (!node.isRoot()) {
                try {
                    DataInputStream in = readfile.getInputStream(this.subFilesTable, filename);
                    out.writeBoolean(true);
                    int c = in.read();
                    while (c != -1) {
                        bytestream.write(c);
                        c = in.read();
                    }
                    in.close();
                    bytestream.close();
                    byte[] barray = bytestream.toByteArray();
                    out.writeInt(barray.length);
                    out.write(barray);
                    node.setByteArray(barray);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINEST, "Failed to read or write data", ex);
                    if (node.getByteArray() != null) {
                        if (node.getDrillDownReport() != null) {
                            ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
                            DataOutputStream dout = new DataOutputStream(fstream);
                            node.getDrillDownReport().getReportInfo().export(10, dout, node.getFileName(), null);
                            dout.close();
                            fstream.close();
                            node.setByteArray(fstream.toByteArray());
                        }
                        out.writeBoolean(true);
                        out.writeInt(node.getByteArray().length);
                        out.write(node.getByteArray());
                        break block11;
                    }
                    out.writeBoolean(false);
                }
            } else {
                out.writeBoolean(false);
            }
        }
        int[] mapping = node.getColumnMapping();
        out.writeInt(mapping.length);
        for (int element : mapping) {
            out.writeInt(element);
        }
        out.writeBoolean(node.isCrossTabDrillDown());
        if (saveChildren) {
            out.writeInt(node.getChildCount());
            LOGGER.finest("save childrencount=" + node.getChildCount());
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.saveDrillDownNodeByteArray(out, node.getChildAt(i), true);
            }
        }
    }

    private void saveSubReports(DataOutput out, Vector<SubReportObject> subreports) throws Exception {
        if (subreports == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(subreports.size());
        String[] oldnames = new String[subreports.size()];
        String[] newnames = new String[subreports.size()];
        boolean rename = false;
        for (int i = 0; i < subreports.size(); ++i) {
            SubReportObject sro = subreports.elementAt(i);
            oldnames[i] = sro.getFileName();
            if (!sro.getFileName().endsWith(".rpt") && !sro.getFileName().endsWith(".xml")) {
                rename = true;
                LoadReport lr = new LoadReport(true);
                lr.setSubFilesTable(this.report.getSubFilesTable());
                Report subR = lr.loadReportFromFile(sro.getFileName());
                SaveReport sr = new SaveReport(subR);
                sr.subFilesTable = this.report.getSubFilesTable();
                sr.setDrillDownNode(lr.getDrillDownNode());
                newnames[i] = sro.getFileName();
                sro.setFileName(newnames[i]);
                sro.setText(newnames[i]);
                sr.saveToFile(newnames[i]);
            }
            sro.write(this.subFilesTable, out);
        }
        if (!rename) {
            return;
        }
        this.report.getReportHeader().renameSubReportFileNames(oldnames, newnames);
        this.report.getPageHeader().renameSubReportFileNames(oldnames, newnames);
        this.report.getPageFooter().renameSubReportFileNames(oldnames, newnames);
        this.report.getReportFooter().renameSubReportFileNames(oldnames, newnames);
        ReportTable table = this.report.getReportTables().elementAt(0);
        table.getHeader().renameSubReportFileNames(oldnames, newnames);
        table.getFooter().renameSubReportFileNames(oldnames, newnames);
        if (table instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable mtbl = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtbl.countRowBreakHeader(); ++i) {
                mtbl.getRowBreakHeader(i).renameSubReportFileNames(oldnames, newnames);
                mtbl.getRowBreakFooter(i).renameSubReportFileNames(oldnames, newnames);
            }
        }
        table.renameSubReportFileNames(oldnames, newnames);
    }

    private void saveSubReportsByteArrays(DataOutput out, Vector<SubReportObject> subreports) throws Exception {
        if (subreports == null) {
            out.writeBoolean(false);
            LOGGER.finest("Save sub-report byte arrays = null");
            return;
        }
        out.writeBoolean(true);
        out.writeInt(subreports.size());
        LOGGER.finest("Save sub-report byte arrays = " + subreports.size());
        for (int i = 0; i < subreports.size(); ++i) {
            subreports.elementAt(i).writeByteArray(out, this.subFilesTable);
        }
    }

    private void writeDrillDownNodes(DataOutput out, DrillDownNode node) throws Exception {
        if (node == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(node.getChildCount());
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!this.createPAK) {
                    this.saveTreeNode(out, node.getChildAt(i), false);
                    continue;
                }
                this.saveDrillDownNodeByteArray(out, node.getChildAt(i), false);
            }
        }
    }

    public String getFullFilename(String filename) {
        if (this.fullFilename != null) {
            return this.fullFilename;
        }
        if (this.createXML || filename.toLowerCase().endsWith(".xml")) {
            if (!filename.toLowerCase().endsWith(".xml")) {
                filename = filename + ".xml";
            }
            return filename;
        }
        if (this.createPAK || filename.toLowerCase().endsWith(".pak")) {
            if (!filename.toLowerCase().endsWith(".pak")) {
                filename = filename + ".pak";
            }
            return filename;
        }
        if (!filename.toUpperCase().endsWith(".RPT") && !filename.toUpperCase().endsWith(".QRP")) {
            filename = filename + ".rpt";
        }
        return filename;
    }

    public static String getPakFileName(String fileName) {
        if (SaveReport.isRPTFile(fileName) || SaveReport.isXMLFile(fileName)) {
            return fileName.substring(0, fileName.length() - 4) + ".pak";
        }
        if (SaveReport.isPAKFile(fileName)) {
            return fileName;
        }
        return fileName + ".pak";
    }

    public static String getRptFileName(String fileName) {
        if (SaveReport.isPAKFile(fileName) || SaveReport.isRPTFile(fileName) || SaveReport.isXMLFile(fileName)) {
            return fileName.substring(0, fileName.length() - 4) + ".rpt";
        }
        if (SaveReport.isRPTFile(fileName)) {
            return fileName;
        }
        return fileName + ".rpt";
    }

    public void saveColData(ColData[] colData, String fName) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        this.saveColData(out, colData);
        this.saveColDataAttr(out, colData);
        out.close();
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        wdfile.output(this.subFilesTable, fstream.toByteArray(), fName);
    }

    public static String getUpdateVersion() {
        return ServerMessage.getUpdateVersion();
    }

    public static void copyChildNodes(DrillDownNode node, String relativeDomainPath, IReportMain reportMain) {
        SaveReport.copyChildNodes(node, relativeDomainPath, reportMain, false);
    }

    public static void copyChildNodes(DrillDownNode node, String relativeDomainPath, IReportMain reportMain, boolean generatePAK) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        node.removeAllChildren();
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode oldChild = (DrillDownNode)children.elementAt(i);
            DrillDownNode newChild = node.createNewChild(oldChild.getName(), reportMain.getSubFilesTable());
            newChild.setCrossTabDrillDown(oldChild.isCrossTabDrillDown());
            newChild.setColumnMapping(oldChild.getColumnMapping());
            try {
                SaveReport sr;
                Report ddReport;
                LoadReport lr = new LoadReport(true);
                lr.setSubFilesTable(reportMain.getSubFilesTable());
                lr.loadDataHeaderOnly(oldChild.getFileName());
                Vector<SubReportObject> childSRs = lr.getSubReports();
                if (childSRs == null || childSRs.size() <= 0) {
                    lr = new LoadReport(true);
                    lr.setSubFilesTable(reportMain.getSubFilesTable());
                    lr.setRelativeDomainPath(relativeDomainPath);
                    lr.setBackupDataUsed(true);
                    ddReport = lr.loadReportFromFile(oldChild.getFileName());
                    ddReport.resetSourceData();
                    if (ddReport.rootNode != null) {
                        ddReport.rootNode.setFileName(node.getRoot().getFileName());
                    }
                    sr = new SaveReport(ddReport);
                    sr.setSubReports(childSRs);
                    SaveReport.saveToFile(sr, newChild.getFileName(), reportMain, generatePAK);
                } else {
                    lr = new LoadReport(true);
                    lr.setRelativeDomainPath(relativeDomainPath);
                    lr.setBackupDataUsed(true);
                    lr.setSubFilesTable(reportMain.getSubFilesTable());
                    ddReport = lr.loadReportFromFile(oldChild.getFileName());
                    ddReport.resetSourceData();
                    if (ddReport.rootNode != null) {
                        ddReport.rootNode.setFileName(node.getRoot().getFileName());
                    }
                    childSRs = lr.getSubReports();
                    SaveReport.copySubReports_Helper(newChild.getFileName(), ddReport, childSRs, relativeDomainPath, reportMain, generatePAK);
                    sr = new SaveReport(ddReport);
                    sr.setSubReports(childSRs);
                    SaveReport.saveToFile(sr, newChild.getFileName(), reportMain, generatePAK);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Cannot copy drill-down nodes", ex);
            }
            if (oldChild.isLeaf()) continue;
            for (int j = 0; j < oldChild.getChildCount(); ++j) {
                newChild.add(oldChild.getChildAt(j));
            }
            SaveReport.copyChildNodes(newChild, relativeDomainPath, reportMain);
        }
    }

    public static void resaveChildNodes(DrillDownNode node, String relativeDomainPath, IReportMain reportMain) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode child = (DrillDownNode)children.elementAt(i);
            try {
                LoadReport lr = new LoadReport(true);
                if (reportMain != null) {
                    lr.setSubFilesTable(reportMain.getSubFilesTable());
                }
                lr.loadDataHeaderOnly(child.getFileName());
                lr.setBackupDataUsed(true);
                lr.setRelativeDomainPath(relativeDomainPath);
                Report ddReport = lr.loadReportFromFile(child.getFileName());
                ddReport.resetSourceData();
                Vector<SubReportObject> childSRs = lr.getSubReports();
                SaveReport.copySubReports_Helper(child.getFileName(), ddReport, childSRs, relativeDomainPath, reportMain);
                if (child.getChildCount() > 0 || ddReport.currentNode.getChildCount() > 0) {
                    ddReport.currentNode.removeAllChildren();
                    for (int j = 0; j < child.getChildCount(); ++j) {
                        DrillDownNode newChild = child.getChildAt(j);
                        DrillDownNode copyNode = (DrillDownNode)newChild.clone();
                        ddReport.currentNode.add(copyNode);
                    }
                }
                SaveReport sr = new SaveReport(ddReport);
                sr.setSubReports(childSRs);
                SaveReport.saveToFile(sr, child.getFileName(), reportMain);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to re-save drill-down nodes", ex);
            }
            if (child.isLeaf()) continue;
            SaveReport.resaveChildNodes(child, relativeDomainPath, reportMain);
        }
    }

    private static void copySubReports_Helper(String newtitle, Report mainReport, Vector<SubReportObject> srVector, String relativeDomainPath, IReportMain reportMain) {
        SaveReport.copySubReports_Helper(newtitle, mainReport, srVector, relativeDomainPath, reportMain, false);
    }

    private static void copySubReports_Helper(String newtitle, Report mainReport, Vector<SubReportObject> srVector, String relativeDomainPath, IReportMain reportMain, boolean generatePAK) {
        if (srVector != null && srVector.size() > 0) {
            int i;
            String[] oldnames = new String[srVector.size()];
            String[] newnames = new String[srVector.size()];
            Vector<SubReportObject> newSubReportVector = new Vector<SubReportObject>();
            for (i = 0; i < srVector.size(); ++i) {
                String prefix_new;
                SubReportObject newcell = new SubReportObject(newtitle, srVector.elementAt(i).getParamShareReportID(), relativeDomainPath, mainReport.getSubFilesTable());
                newcell.setParameterMap(srVector.elementAt(i).getParameterMap());
                newSubReportVector.addElement(newcell);
                oldnames[i] = srVector.elementAt(i).getFileName();
                newnames[i] = newcell.getFileName();
                int index = oldnames[i].lastIndexOf("_sub");
                String prefix_old = "";
                if (index > -1) {
                    prefix_old = oldnames[i].substring(0, index);
                }
                if (prefix_old.equals(prefix_new = newnames[i].substring(0, index = newnames[i].lastIndexOf("_sub")))) {
                    newnames[i] = oldnames[i].substring(0, oldnames[i].length() - 4) + newnames[i].substring(newnames[i].length() - 4);
                    newcell.setText(newnames[i]);
                    newcell.setFileName(newnames[i]);
                }
                try {
                    LoadReport lr = new LoadReport(true);
                    if (reportMain != null) {
                        lr.setSubFilesTable(reportMain.getSubFilesTable());
                    }
                    lr.setBackupDataUsed(true);
                    lr.setRelativeDomainPath(relativeDomainPath);
                    Report subR = null;
                    try {
                        subR = lr.loadReportFromFile(oldnames[i]);
                    }
                    catch (Exception IOExceptioin) {
                        LOGGER.log(Level.FINEST, "Cannot load sub-report from file", IOExceptioin);
                        subR = mainReport.getSubReports()[i].getSubReport().getReportInfo();
                    }
                    if (subR.parentNode == null) {
                        subR.parentNode = new DrillDownNode();
                        subR.parentNode.setDomainPath(relativeDomainPath);
                    }
                    subR.parentNode.setFileName(newtitle);
                    subR.currentNode.setFileName(newnames[i]);
                    if (lr.getDrillDownNode() != null) {
                        SaveReport.copyChildNodes(lr.getDrillDownNode(), relativeDomainPath, reportMain);
                    }
                    SaveReport sr = new SaveReport(subR);
                    sr.setDrillDownNode(lr.getDrillDownNode());
                    SaveReport.saveToFile(sr, newnames[i], reportMain, generatePAK);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to save sub-report", ex);
                    if (reportMain == null) continue;
                    Report.copyFile(reportMain.getSubFilesTable(), oldnames[i], newnames[i]);
                }
            }
            srVector.removeAllElements();
            for (i = 0; i < newSubReportVector.size(); ++i) {
                srVector.addElement((SubReportObject)newSubReportVector.elementAt(i));
            }
            mainReport.getReportHeader().renameSubReportFileNames(oldnames, newnames);
            mainReport.getPageHeader().renameSubReportFileNames(oldnames, newnames);
            mainReport.getPageFooter().renameSubReportFileNames(oldnames, newnames);
            mainReport.getReportFooter().renameSubReportFileNames(oldnames, newnames);
            ReportTable table = mainReport.getReportTables().elementAt(0);
            table.getHeader().renameSubReportFileNames(oldnames, newnames);
            table.getFooter().renameSubReportFileNames(oldnames, newnames);
            if (table instanceof ReportMultiSectionTable) {
                ReportMultiSectionTable mtbl = (ReportMultiSectionTable)table;
                for (int i2 = 0; i2 < mtbl.countRowBreakHeader(); ++i2) {
                    mtbl.getRowBreakHeader(i2).renameSubReportFileNames(oldnames, newnames);
                    mtbl.getRowBreakFooter(i2).renameSubReportFileNames(oldnames, newnames);
                }
            }
            table.renameSubReportFileNames(oldnames, newnames);
        }
    }

    public static String getPakPath(String fileName) {
        return SaveReport.getPakFileName(fileName);
    }

    public static boolean isPAKFile(String filename) {
        return filename.toLowerCase().endsWith(".pak");
    }

    public static boolean isXMLFile(String filename) {
        return filename.toLowerCase().endsWith(".xml");
    }

    public static boolean isRPTFile(String filename) {
        return filename.toLowerCase().endsWith(".rpt");
    }

    public static boolean isQRPFile(String filename) {
        return filename.toLowerCase().endsWith(".qrp");
    }

    private static void saveToFile(SaveReport saveReport, String fileName, IReportMain reportMain) throws Exception {
        SaveReport.saveToFile(saveReport, fileName, reportMain, false);
    }

    private static void saveToFile(SaveReport saveReport, String fileName, IReportMain reportMain, boolean createPAK) throws Exception {
        if (reportMain != null && reportMain instanceof ReportMain) {
            ((ReportMain)reportMain).saveToFile(saveReport, fileName, createPAK);
        } else if (reportMain != null) {
            reportMain.saveToFile(saveReport, fileName);
        } else {
            saveReport.saveToOutput(fileName, true, createPAK);
        }
    }

    public boolean isSaveNoData() {
        return this.saveNoData;
    }

    public void setSaveNoData(boolean saveNoData) {
        this.saveNoData = saveNoData;
    }
}

