/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.util.ColInfo;

public class SaveReportStyle {
    public static final int VERSION = 7004;
    static final int BACKUPROWCOUNT = 2;
    protected Report report;

    public SaveReportStyle(Report report) {
        this.report = report;
    }

    public void saveToFile(String filename) throws Exception {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        String cname = this.saveToFile(filename, out);
        out.close();
        fstream.close();
        WriteDataFile wdfile = new WriteDataFile();
        wdfile.output(null, fstream.toByteArray(), cname);
    }

    public String saveToFile(String cname, DataOutputStream out) throws Exception {
        if (cname == null || cname.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        this.saveData(out);
        if (!cname.toUpperCase().endsWith(".STL")) {
            cname = cname + ".stl";
        }
        return cname;
    }

    private void saveData(DataOutput out) throws Exception {
        out.writeInt(7004);
        this.saveColData(out, this.report.colData, 2);
        out.writeInt(this.report.colInfo.length);
        for (ColInfo element : this.report.colInfo) {
            element.write(out);
        }
        out.writeInt(this.report.getReportType());
        this.report.getPageHeader().writeSTL(out);
        this.report.getReportHeader().writeSTL(out);
        Vector<ReportTable> vec = this.report.getReportTables();
        out.writeInt(vec.size());
        for (int i = 0; i < vec.size(); ++i) {
            vec.elementAt(i).writeSTL(out);
        }
        this.report.getReportFooter().writeSTL(out);
        this.report.getPageFooter().writeSTL(out);
        this.report.labelSetting.write(out);
        this.report.chartSetting.write(out);
        this.report.imageSetting.write(out);
        this.report.stringFormulaSetting.write(out);
        this.report.logicFormulaSetting.write(out);
        this.report.numericFormulaSetting.write(out);
        this.report.timeFormulaSetting.write(out);
        this.report.stringColumnSetting.write(out);
        this.report.logicColumnSetting.write(out);
        this.report.numericColumnSetting.write(out);
        this.report.timeColumnSetting.write(out);
        this.report.barcodeColumnSetting.write(out);
        this.report.lineSetting.write(out);
        this.report.gridSetting.write(out);
        this.report.columnHeaderSetting.write(out);
        this.report.titleSetting.write(out);
        IOUtil.writeColor(out, this.report.getBackgroundColor());
        if (this.report.getBackgroundImage() == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.report.getBackgroundImage().write(out, true);
        }
    }

    private void saveColData(DataOutput out, ColData[] colData, int nRow) throws IOException {
        if (colData == null || colData.length <= 1) {
            this.saveColData(out, colData, 0, 0);
        } else {
            this.saveColData(out, colData, colData.length - 1, colData[0].getSize() >= nRow ? nRow : colData[0].getSize());
        }
    }

    private void saveColData(DataOutput out, ColData[] colData, int nCol, int nRow) throws IOException {
        ByteArrayOutputStream enstream = new ByteArrayOutputStream(2048);
        DataOutputStream enout = new DataOutputStream(enstream);
        enout.writeInt(nCol);
        enout.writeInt(nRow);
        for (int i = 0; i < nCol; ++i) {
            colData[i].save(enout, nRow);
        }
        enout.flush();
        byte[] encrypb = IOUtil.encode(enstream.toByteArray());
        out.writeInt(encrypb.length);
        out.write(encrypb, 0, encrypb.length);
    }
}

