/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryMultiValueInParam;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.util.IQueryFileInfo;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.IQueryMultiValueInParam;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.EJBInfo;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.LoadReport;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.SaveReport;
import quadbase.reportdesigner.report.XMLReport;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.internal.FormatUtil;
import quadbase.reportdesigner.util.internal.ReportUtil;

public class SaveXMLReport
extends SaveReport {
    private static final Logger LOGGER = Logger.getLogger(SaveXMLReport.class.getName());
    public static final String SAVE_ALL_DATA = "SAVE_ALL_DATA";
    public static final String SHOW_ROW_AGGREGATION_GRAND_TOTAL_ON_LEFT = "ShowRowAggregationGrandTotalOnLeft";

    public SaveXMLReport(SaveReport saveReport) {
        this.report = saveReport.report;
        this.createHtml = saveReport.createHtml;
        this.useSwing = saveReport.useSwing;
        this.drillDownNode = saveReport.drillDownNode;
        this.subReports = saveReport.subReports;
        this.saveAllData = saveReport.saveAllData;
        this.createXML = true;
    }

    @Override
    public String saveToFile(String cname, DataOutputStream out) throws Exception {
        if (cname == null || cname.trim().equals("")) {
            throw new IOException("No file name selected !");
        }
        this.saveData(out);
        if (!cname.toUpperCase().endsWith(".XML")) {
            cname = cname + ".xml";
        }
        this.fullFilename = cname;
        return cname;
    }

    @Override
    public void saveData(DataOutput os) throws Exception {
        int i;
        int i2;
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)((DataOutputStream)os), ServerMessage.xmlEncoding);
        out.write("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>\n");
        String[] names = new String[]{"Name", "Type", "PageWidth", "PageHeight", "TopMargin", "BottomMargin", "LeftMargin", "RightMargin", "SideBySideLayout", "Orientation", "CrossTabRowSummaryColumn", "CrossTabFixedField", "CrossTabSummaryColumnToLeft", "CrossTabAggrFormulaIncluded", "PlaceCrossTabFormulaOnHeader", "AlignColBkValColHori", "AddCrossTabSubTotalColumn", SHOW_ROW_AGGREGATION_GRAND_TOTAL_ON_LEFT};
        String[] values = new String[names.length];
        values[0] = this.report.getName();
        values[2] = Double.toString(this.report.getPageWidth());
        values[3] = Double.toString(this.report.getPageHeight());
        values[4] = Double.toString(this.report.getTopMargin());
        values[5] = Double.toString(this.report.getBottomMargin());
        values[6] = Double.toString(this.report.getLeftMargin());
        values[7] = Double.toString(this.report.getRightMargin());
        values[8] = this.report.isSideBySideLayout() + "";
        values[9] = this.report.getOrientation() == 1 ? "LANDSCAPE" : "PORTRAIT";
        values[10] = this.report.isShowRowAggregationGrandTotal() + "";
        values[11] = !this.report.crossTabFreeForm + "";
        values[16] = this.report.isShowRowAggregationSubtotal() + "";
        values[12] = this.report.isRowAggregationSubtotalOnLeft() + "";
        values[13] = this.report.isShowColumnAggregation() + "";
        values[14] = this.report.isColumnAggregationInHeader() + "";
        values[15] = this.report.isAlignCrossTabColBkValHori() + "";
        values[17] = this.report.isShowRowAggregationGrandTotal() + "";
        switch (this.report.getReportType()) {
            case 0: {
                values[1] = "columnar";
                break;
            }
            case 1: {
                values[1] = "summary break";
                break;
            }
            case 2: {
                values[1] = "crosstab";
                break;
            }
            case 3: {
                values[1] = "master details";
                break;
            }
            case 4: {
                values[1] = "mailing labels";
            }
        }
        this.openElementTag(out, "REPORT", names, values);
        this.openElementTag(out, "VERSION", null, null);
        out.write("7004");
        this.closeElementTag(out, "VERSION");
        if (this.report.registryID != null) {
            this.openElementTag(out, "REGISTRYID", null, null);
            out.write(this.report.registryID);
            this.closeElementTag(out, "REGISTRYID");
        }
        if (this.report.dataSourceID != null) {
            this.openElementTag(out, "DATASOURCEID", null, null);
            out.write(this.report.dataSourceID);
            this.closeElementTag(out, "DATASOURCEID");
        }
        if (this.report.dataSourceLoc != null) {
            this.openElementTag(out, "DATASOURCELOC", null, null);
            out.write(this.report.dataSourceLoc);
            this.closeElementTag(out, "DATASOURCELOC");
        }
        if (this.report.getBackgroundColor() != null) {
            out.write("<BACKGROUNDCOLOR>" + this.report.getBackgroundColor().getRGB() + "</BACKGROUNDCOLOR>\n");
        }
        if (this.report.getBackgroundImage() != null) {
            out.write("<BACKGROUNDIMAGE>");
            this.report.getBackgroundImage().writeXML(out, true);
            out.write("</BACKGROUNDIMAGE>\n");
        }
        this.saveTree(out, this.drillDownNode);
        this.saveSubReports(out, this.subReports);
        int sourceData = this.report.getOriginalSourceData() > 0 ? this.report.getOriginalSourceData() : this.report.sourceData;
        out.write("<SAVE_ALL_DATA>" + this.saveAllData + "</" + SAVE_ALL_DATA + ">");
        if (sourceData != 0) {
            this.openElementTag(out, "DATABACKUP", null, null);
            if (this.saveAllData && !this.isSaveNoData()) {
                this.saveColData(out, this.report.colData);
            } else if (this.isSaveNoData()) {
                this.saveColData(out, this.report.colData, 0);
            } else {
                this.saveColData(out, this.report.colData, 2);
            }
            this.closeElementTag(out, "DATABACKUP");
        }
        if (sourceData == 1) {
            boolean hasQueryFilename;
            this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"database"});
            DBInfoBasic dbInfo = this.report.dbInfo;
            new DBInfoBasic(dbInfo).writeXML(out);
            boolean bl = hasQueryFilename = this.report.queryFilename != null && !this.report.queryFilename.equals("");
            if (!hasQueryFilename) {
                boolean failed = true;
                ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bytestream, ServerMessage.xmlEncoding);
                if (dbInfo instanceof IQueryFileInfo) {
                    try {
                        quadbase.reportdesigner.util.IQueryInParam[][] parameterInPromptSequence;
                        quadbase.reportdesigner.util.IQueryInParam[] params = ReportUtil.getInParam(dbInfo);
                        if (params != null) {
                            for (quadbase.reportdesigner.util.IQueryInParam param : params) {
                                QueryInParam currP = null;
                                boolean multiValue = false;
                                if (param instanceof IQueryMultiValueInParam) {
                                    multiValue = true;
                                    currP = new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)param), dbInfo.getQuery());
                                } else {
                                    currP = new QueryInParam(param, dbInfo.getQuery());
                                }
                                if (this.drillDownNode == null && this.subReports == null) {
                                    currP.setDefaultValue(param.getValue());
                                    if (multiValue) {
                                        ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)((Object)param)).getValues());
                                    } else {
                                        currP.setValue(param.getValue());
                                    }
                                }
                                currP.writeXML(writer);
                            }
                            writer.flush();
                            failed = false;
                        }
                        if ((parameterInPromptSequence = ReportUtil.getParamInSequence(dbInfo)) != null) {
                            for (quadbase.reportdesigner.util.IQueryInParam[] element : parameterInPromptSequence) {
                                writer.write("<PARAM_ORDER>\n");
                                for (quadbase.reportdesigner.util.IQueryInParam element2 : element) {
                                    if (element2 == null) continue;
                                    writer.write("<PARAM_NAME>" + element2.getParamName() + "</PARAM_NAME>\n");
                                }
                                writer.write("</PARAM_ORDER>\n");
                            }
                            writer.flush();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to write parameters", ex);
                    }
                }
                if (!failed) {
                    out.write(bytestream.toString(ServerMessage.xmlEncoding));
                }
            }
            this.closeElementTag(out, "DATASOURCE");
        } else if (sourceData == 2) {
            this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"file"});
            SaveXMLReport.writeCDATA(out, this.report.sourceFile);
            this.closeElementTag(out, "DATASOURCE");
        } else {
            if (sourceData == 9) {
                throw new Exception(LanguageEncoder.getText("Cannot save report with the old SOAP data source. Please update your datasource before saving."));
            }
            if (sourceData == 12) {
                this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"soap"});
                this.report.soapInfo.writeXML(out);
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 11) {
                this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"salesforce"});
                this.report.sfQueryInfo.writeXML(out);
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 13) {
                this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"excel"});
                this.report.excelInfo.writeXML(out);
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 10) {
                this.openElementTag(out, "DATASOURCE", new String[]{"Type", "MondrianConnectionString", "MDXQuery", "XmlaURI", "XmlaDataSource", "XmlaCatalog"}, new String[]{"olap", this.report.mondrianConnectionString, this.report.MDXQuery, this.report.xmlaURI, this.report.xmlaDataSource, this.report.xmlaCatalog});
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 4) {
                this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"xml"});
                SaveXMLReport.writeCDATA(out, this.report.sourceFile);
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 6) {
                boolean state = sourceData == 6 && this.report.dbInfo != null && this.report.dbInfo instanceof QueryClassFileInfo;
                this.openElementTag(out, "DATASOURCE", new String[]{"Type", "isParameterized"}, new String[]{"class", state + ""});
                SaveXMLReport.writeCDATA(out, this.report.sourceFile);
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 7) {
                XMLFileQueryInfo xmlFileQueryInfo;
                this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"xmlfilequery"});
                XMLFileQueryInfo temp = xmlFileQueryInfo = this.report.xmlFileQueryInfo;
                if (this.report.dbInfo instanceof QueryXMLFileInfo) {
                    QueryInParam[] params = xmlFileQueryInfo.getInSet().getParameter();
                    QueryInParam[] temp_params = new QueryInParam[params.length];
                    for (int i3 = 0; i3 < params.length; ++i3) {
                        Object currP = null;
                        int multiValue = 0;
                        if (params[i3] instanceof IQueryMultiValueInParam) {
                            multiValue = 1;
                            currP = new QueryMultiValueInParam((IQueryMultiValueInParam)((Object)params[i3]), xmlFileQueryInfo.getCondition());
                        } else {
                            currP = new QueryInParam(params[i3], xmlFileQueryInfo.getCondition());
                        }
                        if (this.drillDownNode == null && this.subReports == null) {
                            ((QueryInParam)currP).setDefaultValue(params[i3].getValue());
                            if (multiValue != 0) {
                                ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)((Object)params[i3])).getValues());
                            } else {
                                ((QueryInParam)currP).setValue(params[i3].getValue());
                            }
                        }
                        temp_params[i3] = currP;
                    }
                    quadbase.reportdesigner.util.IQueryInParam[][] parameterInPromptSequence = ReportUtil.getParamInSequence(this.report.dbInfo);
                    if (parameterInPromptSequence != null) {
                        for (quadbase.reportdesigner.util.IQueryInParam[] element : parameterInPromptSequence) {
                            out.write("<PARAM_ORDER>\n");
                            for (quadbase.reportdesigner.util.IQueryInParam element2 : element) {
                                if (element2 == null) continue;
                                out.write("<PARAM_NAME>" + element2.getParamName() + "</PARAM_NAME>\n");
                            }
                            out.write("</PARAM_ORDER>\n");
                        }
                    }
                    temp = new XMLFileQueryInfo(xmlFileQueryInfo.getFileName(), xmlFileQueryInfo.getFieldInfo(), xmlFileQueryInfo.getCondition(), xmlFileQueryInfo.getConditionInfo(), xmlFileQueryInfo.getDTDName(), xmlFileQueryInfo.isVerify(), new QueryInParamSet(temp_params), xmlFileQueryInfo.getDTDTreeFileName());
                }
                temp.writeXML(out);
                out.write("<ISPARAMQUERY>" + (this.report.dbInfo instanceof QueryXMLFileInfo) + "</ISPARAMQUERY>");
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 5) {
                int i4;
                Object[] vals = this.report.selectedMethodParamVal;
                int valSize = vals.length;
                Hashtable<String, String> env = this.report.environment;
                int envsize = 0;
                if (env != null) {
                    envsize = env.size();
                }
                Object[] envKeys = new Object[envsize];
                String[] envValues = new String[envsize];
                if (env != null) {
                    Enumeration<String> e = env.keys();
                    int index = 0;
                    while (e.hasMoreElements()) {
                        envKeys[index] = e.nextElement();
                        ++index;
                    }
                    for (i4 = 0; i4 < envsize; ++i4) {
                        envValues[i4] = env.get(envKeys[i4]);
                    }
                }
                String[] attrs = new String[6 + valSize * 2 + envsize * 2 + 1];
                String[] paramValues = new String[6 + valSize * 2 + envsize * 2 + 1];
                attrs[0] = "Type";
                attrs[1] = "jndiName";
                attrs[2] = "homeName";
                attrs[3] = "remoteName";
                attrs[4] = "selectedMethodName";
                attrs[5] = "paramSize";
                for (i4 = 6; i4 < 6 + valSize; ++i4) {
                    attrs[i4] = "paramValType_" + (i4 - 5);
                }
                for (i4 = 6 + valSize; i4 < 6 + valSize * 2; ++i4) {
                    attrs[i4] = "paramValValue_" + (i4 - 5 - valSize);
                }
                for (i4 = 6 + valSize * 2; i4 < 6 + valSize * 2 + envsize; ++i4) {
                    attrs[i4] = "envKey_" + (i4 - 5 - valSize * 2);
                }
                for (i4 = 6 + valSize * 2 + envsize; i4 < 6 + valSize * 2 + envsize * 2; ++i4) {
                    attrs[i4] = "envValue_" + (i4 - 5 - valSize * 2 - envsize);
                }
                attrs[6 + valSize * 2 + envsize * 2] = "envsize";
                paramValues[0] = "ejb";
                paramValues[1] = this.report.jndiName;
                paramValues[2] = this.report.homeName;
                paramValues[3] = this.report.remoteName;
                paramValues[4] = this.report.selectedMethodName;
                paramValues[5] = Integer.valueOf(valSize).toString();
                for (i4 = 6; i4 < 6 + valSize; ++i4) {
                    paramValues[i4] = vals[i4 - 6].getClass().getName();
                }
                for (i4 = 6 + valSize; i4 < 6 + valSize * 2; ++i4) {
                    paramValues[i4] = vals[i4 - 6 - valSize].toString();
                }
                for (i4 = 6 + valSize * 2; i4 < 6 + valSize * 2 + envsize; ++i4) {
                    paramValues[i4] = (String)envKeys[i4 - 6 - valSize * 2];
                }
                for (i4 = 6 + valSize * 2 + envsize; i4 < 6 + valSize * 2 + envsize * 2; ++i4) {
                    paramValues[i4] = envValues[i4 - 6 - valSize * 2 - envsize];
                }
                paramValues[6 + valSize * 2 + envsize * 2] = Integer.valueOf(envsize).toString();
                this.openElementTag(out, "DATASOURCE", attrs, paramValues);
                this.closeElementTag(out, "DATASOURCE");
            } else if (sourceData == 3) {
                for (int i5 = 0; i5 < this.report.sourceList.length; ++i5) {
                    Object[] vals;
                    Object temp = this.report.sourceList[i5];
                    if (temp instanceof DBInfoBasic) {
                        this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"database"});
                        ((DBInfoBasic)temp).writeXML(out);
                        this.closeElementTag(out, "DATASOURCE");
                    } else if (this.report.sourceType[i5] == 4) {
                        this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"xml"});
                        SaveXMLReport.writeCDATA(out, (String)temp);
                        this.closeElementTag(out, "DATASOURCE");
                    } else if (this.report.sourceType[i5] == 6) {
                        this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"class"});
                        SaveXMLReport.writeCDATA(out, (String)temp);
                        this.closeElementTag(out, "DATASOURCE");
                    } else if (this.report.sourceType[i5] == 7) {
                        this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"xmlfilequery"});
                        XMLFileQueryInfo info = (XMLFileQueryInfo)temp;
                        info.writeXML(out);
                        this.closeElementTag(out, "DATASOURCE");
                    } else if (this.report.sourceType[i5] == 5) {
                        int k;
                        EJBInfo ejbInfo = (EJBInfo)temp;
                        vals = ejbInfo.getSelectedMethodParamVal();
                        int valSize = vals.length;
                        Hashtable<String, String> env = ejbInfo.getEnvironment();
                        int envsize = 0;
                        if (env != null) {
                            envsize = env.size();
                        }
                        Object[] envKeys = new Object[envsize];
                        String[] envValues = new String[envsize];
                        if (env != null) {
                            Enumeration<String> e = env.keys();
                            int index = 0;
                            while (e.hasMoreElements()) {
                                envKeys[index] = e.nextElement();
                                ++index;
                            }
                            for (k = 0; k < envsize; ++k) {
                                envValues[k] = env.get(envKeys[k]);
                            }
                        }
                        String[] attrs = new String[6 + valSize * 2 + envsize * 2 + 1];
                        String[] paramValues = new String[6 + valSize * 2 + envsize * 2 + 1];
                        attrs[0] = "Type";
                        attrs[1] = "jndiName";
                        attrs[2] = "homeName";
                        attrs[3] = "remoteName";
                        attrs[4] = "selectedMethodName";
                        attrs[5] = "paramSize";
                        for (k = 6; k < 6 + valSize; ++k) {
                            attrs[k] = "paramValType_" + (k - 5);
                        }
                        for (k = 6 + valSize; k < 6 + valSize * 2; ++k) {
                            attrs[k] = "paramValValue_" + (k - 5 - valSize);
                        }
                        for (k = 6 + valSize * 2; k < 6 + valSize * 2 + envsize; ++k) {
                            attrs[k] = "envKey_" + (k - 5 - valSize * 2);
                        }
                        for (k = 6 + valSize * 2 + envsize; k < 6 + valSize * 2 + envsize * 2; ++k) {
                            attrs[k] = "envValue_" + (k - 5 - valSize * 2 - envsize);
                        }
                        attrs[6 + valSize * 2 + envsize * 2] = "envsize";
                        paramValues[0] = "ejb";
                        paramValues[1] = ejbInfo.getJNDIName();
                        paramValues[2] = ejbInfo.getHomeName();
                        paramValues[3] = ejbInfo.getRemoteName();
                        paramValues[4] = ejbInfo.getSelectedMethodName();
                        paramValues[5] = Integer.valueOf(valSize).toString();
                        for (k = 6; k < 6 + valSize; ++k) {
                            paramValues[k] = vals[k - 6].getClass().getName();
                        }
                        for (k = 6 + valSize; k < 6 + valSize * 2; ++k) {
                            paramValues[k] = vals[k - 6 - valSize].toString();
                        }
                        for (k = 6 + valSize * 2; k < 6 + valSize * 2 + envsize; ++k) {
                            paramValues[k] = (String)envKeys[k - 6 - valSize * 2];
                        }
                        for (k = 6 + valSize * 2 + envsize; k < 6 + valSize * 2 + envsize * 2; ++k) {
                            paramValues[k] = envValues[k - 6 - valSize * 2 - envsize];
                        }
                        paramValues[6 + valSize * 2 + envsize * 2] = Integer.valueOf(envsize).toString();
                        this.openElementTag(out, "DATASOURCE", attrs, paramValues);
                        this.closeElementTag(out, "DATASOURCE");
                    } else {
                        this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"file"});
                        SaveXMLReport.writeCDATA(out, (String)temp);
                        this.closeElementTag(out, "DATASOURCE");
                    }
                    String[] attr = new String[]{"transpose", "transposeColumn"};
                    vals = new String[]{this.report.doTranspose[i5] + "", this.printArrayIndex((boolean[])this.report.transposeColList[i5])};
                    this.openElementTag(out, "MULTI_TRANSPOSE", attr, (String[])vals);
                    this.closeElementTag(out, "MULTI_TRANSPOSE");
                }
            } else if (sourceData == 0) {
                this.openElementTag(out, "DATASOURCE", new String[]{"Type"}, new String[]{"none"});
                if (this.report.originalColDataFromMemSource != null) {
                    this.saveColData(out, this.report.originalColDataFromMemSource);
                }
                this.closeElementTag(out, "DATASOURCE");
            }
        }
        String[] attr = new String[]{"transpose", "transposeColumn"};
        String[] vals = new String[]{this.report.isTransposed + "", this.printArrayIndex(this.report.transposeCol)};
        this.openElementTag(out, "TRANSPOSE", attr, vals);
        this.closeElementTag(out, "TRANSPOSE");
        Hashtable<String, String> fontMapping = this.report.getFontMapping();
        int fontMappingSize = 0;
        if (fontMapping != null) {
            fontMappingSize = fontMapping.size();
        }
        Object[] fontMappingKeys = new Object[fontMappingSize];
        String[] fontMappingValues = new String[fontMappingSize];
        if (fontMapping != null) {
            Enumeration<String> e = fontMapping.keys();
            int index = 0;
            while (e.hasMoreElements()) {
                fontMappingKeys[index] = e.nextElement();
                ++index;
            }
            for (i2 = 0; i2 < fontMappingSize; ++i2) {
                fontMappingValues[i2] = fontMapping.get(fontMappingKeys[i2]);
            }
        }
        out.write("<PDFFONTMAPPINGTABLE>\n");
        for (int i6 = 0; i6 < fontMappingSize; ++i6) {
            String[] paramValues = new String[]{(String)fontMappingKeys[i6], fontMappingValues[i6]};
            this.openElementTag(out, "PDFFONTMAPPING", new String[]{"Key", "Value"}, paramValues);
            this.closeElementTag(out, "PDFFONTMAPPING");
        }
        out.write("</PDFFONTMAPPINGTABLE>\n");
        Hashtable<String, QueryInParam[]> securityQueryParameterMap = this.report.getSecurityQueryParameterMap();
        if (securityQueryParameterMap != null && securityQueryParameterMap.size() > 0) {
            out.write("<SECURITY_QUERY_PARAMETER_MAP>\n");
            Enumeration<String> enum1 = securityQueryParameterMap.keys();
            while (enum1.hasMoreElements()) {
                String levelname = enum1.nextElement();
                IQueryInParam[] params = securityQueryParameterMap.get(levelname);
                if (params == null) continue;
                out.write("<MAPPING LevelName=\"" + XMLReport.encodeXML(levelname) + "\">\n");
                for (int i7 = 0; i7 < params.length; ++i7) {
                    QueryInParam currP = null;
                    if (params[i7] instanceof IQueryMultiValueInParam) {
                        currP = new QueryMultiValueInParam((IQueryMultiValueInParam)params[i7], null);
                        ((QueryMultiValueInParam)currP).setValues(((IQueryMultiValueInParam)params[i7]).getValues());
                    } else {
                        currP = new QueryInParam(params[i7], null);
                        currP.setValue(params[i7].getValue());
                    }
                    currP.writeXML(out, i7);
                }
                out.write("</MAPPING>\n");
            }
            out.write("</SECURITY_QUERY_PARAMETER_MAP>\n");
        }
        for (int i8 = 0; i8 < this.report.getFormulaParameters().size(); ++i8) {
            this.report.getFormulaParameters().elementAt(i8).writeXML(out);
        }
        Vector<Parameter> queryParamVec = this.report.getQueryParameters();
        for (i2 = 0; i2 < queryParamVec.size(); ++i2) {
            queryParamVec.elementAt(i2).writeXMLShareInfo(out);
        }
        out.write("<LIMITSUBREPORTQUERYEXECUTION>" + this.report.limitSubReportQueryExecution + "</LIMITSUBREPORTQUERYEXECUTION>\n");
        out.write("<ISPREVIEWPARAMETERPROMPT>" + this.report.isPrevParamPrompt + "</ISPREVIEWPARAMETERPROMPT>\n");
        for (i2 = 0; i2 < this.report.formulas.size(); ++i2) {
            this.report.formulas.elementAt(i2).writeXML(out);
        }
        LOGGER.finest("Save scripts: size= " + this.report.scripts.size());
        for (i2 = 0; i2 < this.report.scripts.size(); ++i2) {
            this.report.scripts.elementAt(i2).writeXML(out);
        }
        for (ColInfo element : this.report.colInfo) {
            element.writeXML(out);
        }
        out.write("<TOP_N_REPORT>" + this.report.getTopN() + "</TOP_N_REPORT>\n");
        out.write("<TOP_N_ORDER>" + this.report.isAscending() + "</TOP_N_ORDER>\n");
        out.write("<SNAP_TO_GRID>" + this.report.snapToGrid + "</SNAP_TO_GRID>\n");
        out.write("<GRID_STEP_SIZE>" + this.report.gridStepSize + "</GRID_STEP_SIZE>\n");
        out.write("<CM_GRID_STEP_SIZE>" + this.report.cmGridStepSize + "</CM_GRID_STEP_SIZE>\n");
        out.write("<ADJUST_VIEWER_FONT>" + this.report.isAdjustFont + "</ADJUST_VIEWER_FONT>\n");
        out.write("<KEEP_DATA_SOURCE_ORDER>" + this.report.isKeepDataSourceOrder() + "</KEEP_DATA_SOURCE_ORDER>\n");
        this.saveColDataAttr(out, this.report.colData);
        if (this.report.getColumnWrap() != null) {
            out.write("<COLUMNWRAP_HANDLE ID=\"" + XMLReport.encodeXML(this.report.getColumnWrap().getID()) + "\" />");
        }
        out.write("<hasTitle>" + this.report.hasTitle + "</hasTitle>\n");
        out.write("<hasLogo>" + this.report.hasLogo + "</hasLogo>\n");
        out.write("<hasPageNumber>" + this.report.hasPageNumber + "</hasPageNumber>\n");
        out.write("<hasDate>" + this.report.hasDate + "</hasDate>\n");
        out.write("<reportTitle>" + XMLUtil.encodeCDATA(this.report.reportTitle) + "</reportTitle>\n");
        out.write("<logofile>" + XMLUtil.encodeCDATA(this.report.logofile) + "</logofile>\n");
        out.write("<logoPos>" + this.report.logoPos + "</logoPos>\n");
        out.write("<pageNumberFormat>" + this.report.pageNumberFormat + "</pageNumberFormat>\n");
        out.write("<pageNumberPos>" + this.report.pageNumberPos + "</pageNumberPos>\n");
        out.write("<dateFormat>" + this.report.dateFormat + "</dateFormat>\n");
        out.write("<datePos>" + this.report.datePos + "</datePos>\n");
        out.write("<reportStyle>" + this.report.reportStyle + "</reportStyle>\n");
        if (this.report.getHTMLTitle() != null) {
            out.write("<htmlTitle>" + XMLUtil.encodeCDATA(this.report.getHTMLTitle()) + "</htmlTitle>\n");
        }
        if (this.report.getExternalStyleSheetName() != null) {
            out.write("<ExternalStyleSheetName>" + XMLUtil.encodeCDATA(this.report.getExternalStyleSheetName()) + "</ExternalStyleSheetName>\n");
        }
        if (this.report.getExportEncoding() != null) {
            out.write("<ExportEncoding>" + XMLUtil.encodeCDATA(this.report.getExportEncoding()) + "</ExportEncoding>\n");
        }
        if (this.report.getHTMLCharset() != null) {
            out.write("<HTMLCharset>" + XMLUtil.encodeCDATA(this.report.getHTMLCharset()) + "</HTMLCharset>\n");
        }
        if (this.report.getRTFEncoding() != null) {
            out.write("<RTFEncoding>" + XMLUtil.encodeCDATA(this.report.getRTFEncoding()) + "</RTFEncoding>\n");
        }
        this.openElementTag(out, "PAGEHEADER", null, null);
        this.report.getPageHeader().writeXML(out, true);
        this.closeElementTag(out, "PAGEHEADER");
        this.openElementTag(out, "REPORTHEADER", null, null);
        this.report.getReportHeader().writeXML(out, true);
        this.closeElementTag(out, "REPORTHEADER");
        Vector<ReportTable> vec = this.report.getReportTables();
        for (i = 0; i < vec.size(); ++i) {
            this.openElementTag(out, "DATATABLE", null, null);
            vec.elementAt(i).writeXML(out, true);
            this.closeElementTag(out, "DATATABLE");
        }
        this.openElementTag(out, "REPORTFOOTER", null, null);
        this.report.getReportFooter().writeXML(out, true);
        this.closeElementTag(out, "REPORTFOOTER");
        this.openElementTag(out, "PAGEFOOTER", null, null);
        this.report.getPageFooter().writeXML(out, true);
        this.closeElementTag(out, "PAGEFOOTER");
        this.openElementTag(out, "LABEL_SETTING", null, null);
        this.report.labelSetting.writeXML(out, true);
        this.closeElementTag(out, "LABEL_SETTING");
        this.openElementTag(out, "CHART_SETTING", null, null);
        this.report.chartSetting.writeXML(out, true);
        this.closeElementTag(out, "CHART_SETTING");
        this.openElementTag(out, "IMAGE_SETTING", null, null);
        this.report.imageSetting.writeXML(out, true);
        this.closeElementTag(out, "IMAGE_SETTING");
        this.openElementTag(out, "COLUMNHEADER_SETTING", null, null);
        this.report.columnHeaderSetting.writeXML(out, true);
        this.closeElementTag(out, "COLUMNHEADER_SETTING");
        this.openElementTag(out, "REPORT_TITLE", null, null);
        this.report.titleSetting.writeXML(out, true);
        this.closeElementTag(out, "REPORT_TITLE");
        this.openElementTag(out, "STRING_FORMULA_SETTING", null, null);
        this.report.stringFormulaSetting.writeXML(out, true);
        this.closeElementTag(out, "STRING_FORMULA_SETTING");
        this.openElementTag(out, "LOGIC_FORMULA_SETTING", null, null);
        this.report.logicFormulaSetting.writeXML(out, true);
        this.closeElementTag(out, "LOGIC_FORMULA_SETTING");
        this.openElementTag(out, "NUMERIC_FORMULA_SETTING", null, null);
        this.report.numericFormulaSetting.writeXML(out, true);
        this.closeElementTag(out, "NUMERIC_FORMULA_SETTING");
        this.openElementTag(out, "TIME_FORMULA_SETTING", null, null);
        this.report.timeFormulaSetting.writeXML(out, true);
        this.closeElementTag(out, "TIME_FORMULA_SETTING");
        this.openElementTag(out, "STRING_COLUMN_SETTING", null, null);
        this.report.stringColumnSetting.writeXML(out, true);
        this.closeElementTag(out, "STRING_COLUMN_SETTING");
        this.openElementTag(out, "LOGIC_COLUMN_SETTING", null, null);
        this.report.logicColumnSetting.writeXML(out, true);
        this.closeElementTag(out, "LOGIC_COLUMN_SETTING");
        this.openElementTag(out, "NUMERIC_COLUMN_SETTING", null, null);
        this.report.numericColumnSetting.writeXML(out, true);
        this.closeElementTag(out, "NUMERIC_COLUMN_SETTING");
        this.openElementTag(out, "TIME_COLUMN_SETTING", null, null);
        this.report.timeColumnSetting.writeXML(out, true);
        this.closeElementTag(out, "TIME_COLUMN_SETTING");
        this.openElementTag(out, "BARCODE_COLUMN_SETTING", null, null);
        this.report.barcodeColumnSetting.writeXML(out, true);
        this.closeElementTag(out, "BARCODE_COLUMN_SETTING");
        this.openElementTag(out, "LINE_SETTING", null, null);
        this.report.lineSetting.writeXML(out, true);
        this.closeElementTag(out, "LINE_SETTING");
        this.openElementTag(out, "GRID_SETTING", null, null);
        this.report.gridSetting.writeXML(out, true);
        this.closeElementTag(out, "GRID_SETTING");
        out.write("<APPLY_BOUND>" + this.report.isApplyBoundSelected() + "</APPLY_BOUND>\n");
        this.writeDrillDownNodes(out, this.report.currentNode);
        if (this.report.parentNode != null) {
            this.openElementTag(out, "PARENT_NODE", null, null);
            this.saveTreeNode(out, this.report.parentNode, false);
            this.closeElementTag(out, "PARENT_NODE");
        }
        if (this.report.rootNode != null) {
            this.openElementTag(out, "ROOT_NODE", null, null);
            this.saveTreeNode(out, this.report.rootNode, false);
            this.closeElementTag(out, "ROOT_NODE");
        }
        if (this.report.vGuideLines != null) {
            for (i = 0; i < this.report.vGuideLines.size(); ++i) {
                out.write("<VGUIDELINE>" + this.report.vGuideLines.elementAt(i).getID() + "</VGUIDELINE>\n");
            }
        }
        if (this.report.hGuideLines != null) {
            for (i = 0; i < this.report.hGuideLines.size(); ++i) {
                out.write("<HGUIDELINE>" + this.report.hGuideLines.elementAt(i).getID() + "</HGUIDELINE>\n");
            }
        }
        out.write("<NULL_DATA_HANDLER>" + XMLUtil.encodeCDATA(this.report.getNullDataOption()) + "</NULL_DATA_HANDLER>\n");
        String[] value = new String[]{this.report.getDBSourceType() + ""};
        this.openElementTag(out, "DATASOURCE_DETAIL", new String[]{"Type"}, value);
        byte[][] bytes = this.report.getQueryFileBytes();
        if (bytes != null) {
            for (int i9 = 0; i9 < bytes.length; ++i9) {
                if (bytes[i9] == null) continue;
                value[0] = i9 + "";
                this.openElementTag(out, "FILE", new String[]{"OrderIndex"}, value);
                out.write("<![CDATA[" + IOUtil.bytesToText(bytes[i9]) + "]]>");
                this.closeElementTag(out, "FILE");
            }
        }
        this.closeElementTag(out, "DATASOURCE_DETAIL");
        this.closeElementTag(out, "REPORT");
        out.flush();
        out.close();
    }

    private void saveColData(Writer out, ColData[] colData) throws IOException {
        if (colData == null || colData.length <= 1) {
            this.saveColData(out, colData, 0, 0);
        } else {
            this.saveColData(out, colData, colData.length - 1, colData[0].getSize());
        }
    }

    private void saveColData(Writer out, ColData[] colData, int row) throws IOException {
        if (colData == null || colData.length <= 1) {
            this.saveColData(out, colData, 0, 0);
        } else {
            this.saveColData(out, colData, colData.length - 1, colData[0].getSize() >= row ? row : colData[0].getSize());
        }
    }

    private void saveColData(Writer out, ColData[] colData, int nCol, int nRow) throws IOException {
        for (int i = 0; i < nCol; ++i) {
            colData[i].saveXML(out, nRow);
        }
    }

    private void saveColDataAttr(Writer out, ColData[] colData) throws IOException {
        for (ColData cd : colData) {
            String[] names = new String[]{"Type"};
            String[] values = new String[]{DataType.getTypeName(cd.getOriginalDataType())};
            this.openElementTag(out, "COLUMN_ATTRIBUTE", names, values);
            FormatUtil.writeXMLDataFormat(out, cd.dataFormat);
            this.closeElementTag(out, "COLUMN_ATTRIBUTE");
        }
    }

    private void saveTree(Writer out, DrillDownNode node) throws Exception {
        if (node == null) {
            return;
        }
        this.openElementTag(out, "DRILLDOWNTREE", null, null);
        this.saveTreeNode(out, node, true);
        this.closeElementTag(out, "DRILLDOWNTREE");
    }

    private void saveTreeNode(Writer out, DrillDownNode node, boolean saveChildren) throws Exception {
        if (!node.getFileName().endsWith(".xml")) {
            if (!node.isRoot()) {
                LoadReport lr = new LoadReport(true);
                Report ddr = lr.loadReportFromFile(node.getFileName());
                SaveReport sr = new SaveReport(ddr);
                sr.setDrillDownNode(lr.getDrillDownNode());
                sr.setSubReports(lr.getSubReports());
                sr.generateXMLFile(true);
                node.setFileName(node.getFileName().substring(0, node.getFileName().length() - 4) + ".xml");
            } else {
                node.setFileName(node.getFileName().substring(0, node.getFileName().length() - 4) + ".xml");
            }
        }
        this.openElementTag(out, "DRILLDOWNNODE", new String[]{"Name", "Filename"}, new String[]{node.getName(), node.getFileName()});
        int[] mapping = node.getColumnMapping();
        for (Object element : (Report)mapping) {
            out.write("<MAPPING>" + (int)element + "</MAPPING>");
        }
        out.write("<CROSSTABDRILLDOWN>" + node.isCrossTabDrillDown() + "</CROSSTABDRILLDOWN>");
        if (saveChildren) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.saveTreeNode(out, node.getChildAt(i), true);
            }
        }
        this.closeElementTag(out, "DRILLDOWNNODE");
    }

    private void saveSubReports(Writer out, Vector subreports) throws Exception {
        if (subreports == null) {
            return;
        }
        this.openElementTag(out, "SUBREPORTVECTOR", null, null);
        String[] oldnames = new String[subreports.size()];
        String[] newnames = new String[subreports.size()];
        boolean rename = false;
        for (int i = 0; i < subreports.size(); ++i) {
            SubReportObject sro = (SubReportObject)subreports.elementAt(i);
            oldnames[i] = sro.getFileName();
            if (!sro.getFileName().endsWith(".xml")) {
                rename = true;
                LoadReport lr = new LoadReport(true);
                Report subR = lr.loadReportFromFile(sro.getFileName());
                SaveReport sr = new SaveReport(subR);
                sr.setDrillDownNode(lr.getDrillDownNode());
                sr.generateXMLFile(true);
                newnames[i] = sro.getFileName().substring(0, sro.getFileName().length() - 4) + ".xml";
                sro.setFileName(newnames[i]);
                sro.setText(newnames[i]);
                sr.saveToFile(newnames[i]);
            }
            sro.writeXML(out, true);
        }
        this.closeElementTag(out, "SUBREPORTVECTOR");
        if (!rename) {
            return;
        }
        this.report.getReportHeader().renameSubReportFileNames(oldnames, newnames);
        this.report.getPageHeader().renameSubReportFileNames(oldnames, newnames);
        this.report.getPageFooter().renameSubReportFileNames(oldnames, newnames);
        this.report.getReportFooter().renameSubReportFileNames(oldnames, newnames);
        ReportTable table = this.report.getReportTables().elementAt(0);
        table.getHeader().renameSubReportFileNames(oldnames, newnames);
        table.getFooter().renameSubReportFileNames(oldnames, newnames);
        if (table instanceof ReportMultiSectionTable) {
            ReportMultiSectionTable mtbl = (ReportMultiSectionTable)table;
            for (int i = 0; i < mtbl.countRowBreakHeader(); ++i) {
                mtbl.getRowBreakHeader(i).renameSubReportFileNames(oldnames, newnames);
                mtbl.getRowBreakFooter(i).renameSubReportFileNames(oldnames, newnames);
            }
        }
        table.renameSubReportFileNames(oldnames, newnames);
    }

    private void writeDrillDownNodes(Writer out, DrillDownNode node) throws Exception {
        if (node != null) {
            this.openElementTag(out, "CHILD_DRILLDOWNNODES", null, null);
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.saveTreeNode(out, node.getChildAt(i), false);
            }
            this.closeElementTag(out, "CHILD_DRILLDOWNNODES");
        }
    }

    private void openElementTag(Writer out, String tag, String[] names, String[] values) throws IOException {
        if (tag == null) {
            return;
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<").append(tag.trim());
        if (names != null && values != null && names.length == values.length) {
            for (int i = 0; i < names.length; ++i) {
                strBuf.append(" ").append(names[i]).append("=\"").append(XMLReport.encodeXML(values[i])).append("\" ");
            }
        }
        strBuf.append(">");
        out.write(strBuf.toString());
    }

    private void closeElementTag(Writer out, String name) throws IOException {
        if (name != null) {
            out.write("</" + name.trim() + ">\n");
        }
    }

    private static void writeCDATA(Writer out, String text) throws IOException {
        out.write(XMLUtil.encodeCDATA(text));
    }

    private String printArrayIndex(boolean[] array) {
        if (array == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            if (i == 0) {
                strBuf.append(i);
                continue;
            }
            strBuf.append(" ").append(i);
        }
        return strBuf.toString();
    }
}

