/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.report.ArraySet;
import quadbase.reportdesigner.report.ERStatement;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.NewScriptParser;
import quadbase.reportdesigner.report.Parameter;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Variable;
import quadbase.reportdesigner.util.IFormat;

public class Script
implements Comparable<Script> {
    private static final Logger LOGGER = Logger.getLogger(Script.class.getName());
    public static final String SCRIPTED_VALUE_SET_TO_NULL = "Q#B#S#V#S#T#N";
    String name;
    String text;
    Vector variables;
    Vector arrays;
    Vector statements;
    public static final String[] CELLATTR = new String[]{"VALUE", "BGCOLOR", "FONTCOLOR", "FONT", "ALIGN", "BORDERCOLOR", "BORDERTHICKNESS", "HYPERLINK", "BOOKMARK", "XPOSITION", "YPOSITION", "WIDTH", "HEIGHT", "ROTATION", "VISIBLE", "ALERT"};
    public static final String[] TABLEATTR = new String[]{"BGCOLOR", "PRINT_ON_NEW_PAGE", "VISIBLE"};
    public static final String[] SECTIONATTR = new String[]{"BGCOLOR", "PRINT_ON_NEW_PAGE", "RESET_PAGE_NUMBER", "VISIBLE", "HEIGHT"};
    ReportTable table = null;
    int index;
    int page;
    int section;
    int totalPages;
    int totalSections;
    Report report;
    ReportCell cell;
    ReportTableElement tableElt;
    IFormat cellFormat;
    Object dataobj;
    int datatype;

    public Script() {
    }

    public Script(String name) {
        this.name = name;
    }

    public Script(String name, String text) {
        this.name = name;
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setScript(Vector[] vec) {
        int i;
        this.variables = new Vector();
        for (i = 0; i < vec[0].size(); ++i) {
            this.addVariable((Variable)vec[0].elementAt(i));
        }
        this.arrays = new Vector();
        for (i = 0; i < vec[1].size(); ++i) {
            this.addArraySet((ArraySet)vec[1].elementAt(i));
        }
        this.statements = new Vector();
        for (i = 0; i < vec[2].size(); ++i) {
            this.addStatement((ERStatement)vec[2].elementAt(i));
        }
    }

    public Vector getVariables() {
        return this.variables;
    }

    public void setVariables(Vector variables) {
        this.variables = variables;
    }

    public Vector getArrays() {
        return this.arrays;
    }

    public void setArrays(Vector arrays) {
        this.arrays = arrays;
    }

    public Vector getStatements() {
        return this.statements;
    }

    public void setStatements(Vector statements) {
        this.statements = statements;
    }

    public boolean addVariable(Variable var) {
        if (!this.variableExists(var.getName())) {
            this.variables.addElement(var);
            return true;
        }
        return false;
    }

    public Variable getVariable(String varName) {
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable var = (Variable)this.variables.elementAt(i);
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        return null;
    }

    public boolean variableExists(String varName) {
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable var = (Variable)this.variables.elementAt(i);
            if (!var.getName().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public ArraySet getArraySet(String arrayName) {
        for (int i = 0; i < this.arrays.size(); ++i) {
            ArraySet arraySet = (ArraySet)this.arrays.elementAt(i);
            if (!arraySet.getName().equals(arrayName)) continue;
            return arraySet;
        }
        return null;
    }

    public boolean addArraySet(ArraySet arraySet) {
        if (!this.arrayExists(arraySet.getName())) {
            this.arrays.addElement(arraySet);
            return true;
        }
        return false;
    }

    public boolean arrayExists(String arrayName) {
        for (int i = 0; i < this.arrays.size(); ++i) {
            ArraySet arraySet = (ArraySet)this.arrays.elementAt(i);
            if (!arraySet.getName().equals(arrayName)) continue;
            return true;
        }
        return false;
    }

    public void addStatement(ERStatement stmt) {
        this.statements.addElement(stmt);
    }

    public ReportCell applyScript(ReportTable table, int index, int page, int section, int totalPages, int totalSections, Report report, ReportCell cell, Object dataobj, IFormat cellFormat) throws Exception {
        int i;
        this.table = table;
        this.index = index;
        this.page = page;
        this.section = section;
        this.totalPages = totalPages;
        this.totalSections = totalSections;
        this.report = report;
        this.cell = cell;
        this.dataobj = dataobj;
        this.cellFormat = cellFormat;
        this.tableElt = null;
        if (dataobj != null) {
            this.datatype = DataType.mapType(DataType.findType(dataobj));
        }
        for (i = 0; this.variables != null && i < this.variables.size(); ++i) {
            ((Variable)this.variables.elementAt(i)).init();
        }
        for (i = 0; this.arrays != null && i < this.arrays.size(); ++i) {
            ((ArraySet)this.arrays.elementAt(i)).init();
        }
        for (i = 0; this.statements != null && i < this.statements.size(); ++i) {
            ((ERStatement)this.statements.elementAt(i)).execute(this);
        }
        return this.cell;
    }

    public ReportCell testApplyScript(ReportTable table, int index, int page, int section, int totalPages, int totalSections, Report report, ReportCell cell, Object dataobj, IFormat cellFormat) throws Exception {
        int i;
        this.table = table;
        this.index = index;
        this.page = page;
        this.section = section;
        this.totalPages = totalPages;
        this.totalSections = totalSections;
        this.report = report;
        this.cell = cell;
        this.dataobj = dataobj;
        this.cellFormat = cellFormat;
        if (dataobj != null) {
            this.datatype = DataType.mapType(DataType.findType(dataobj));
        }
        this.tableElt = null;
        for (i = 0; this.variables != null && i < this.variables.size(); ++i) {
            ((Variable)this.variables.elementAt(i)).init();
        }
        for (i = 0; this.arrays != null && i < this.arrays.size(); ++i) {
            ((ArraySet)this.arrays.elementAt(i)).init();
        }
        for (i = 0; this.statements != null && i < this.statements.size(); ++i) {
            ((ERStatement)this.statements.elementAt(i)).testExecute(this);
        }
        return this.cell;
    }

    public ReportTableElement applyScript(ReportTable table, int page, int section, int totalPages, int totalSections, Report report, ReportTableElement tableElt) throws Exception {
        int i;
        this.table = table;
        this.page = page;
        this.section = section;
        this.totalPages = totalPages;
        this.totalSections = totalSections;
        this.report = report;
        this.tableElt = tableElt;
        this.cell = null;
        for (i = 0; this.variables != null && i < this.variables.size(); ++i) {
            ((Variable)this.variables.elementAt(i)).init();
        }
        for (i = 0; this.arrays != null && i < this.arrays.size(); ++i) {
            ((ArraySet)this.arrays.elementAt(i)).init();
        }
        for (i = 0; this.statements != null && i < this.statements.size(); ++i) {
            ((ERStatement)this.statements.elementAt(i)).execute(this);
        }
        return this.tableElt;
    }

    public ReportTableElement testApplyScript(ReportTable table, int page, int section, int totalPages, int totalSections, Report report, ReportTableElement tableElt) throws Exception {
        int i;
        this.table = table;
        this.page = page;
        this.section = section;
        this.totalPages = totalPages;
        this.totalSections = totalSections;
        this.report = report;
        this.tableElt = tableElt;
        this.cell = null;
        for (i = 0; this.variables != null && i < this.variables.size(); ++i) {
            ((Variable)this.variables.elementAt(i)).init();
        }
        for (i = 0; this.arrays != null && i < this.arrays.size(); ++i) {
            ((ArraySet)this.arrays.elementAt(i)).init();
        }
        for (i = 0; this.statements != null && i < this.statements.size(); ++i) {
            ((ERStatement)this.statements.elementAt(i)).testExecute(this);
        }
        return this.tableElt;
    }

    public void write(DataOutput out) throws IOException {
        IOUtil.writeStr(out, this.name);
        IOUtil.writeStr(out, this.text);
    }

    public void read(DataInput in, int version, Vector formulas, Vector queryParams, Vector formulaParams) throws Exception {
        this.name = IOUtil.readStr(in);
        this.text = IOUtil.readStr(in);
        if (version >= 71 && version <= 74) {
            int len = in.readInt();
            for (int i = 0; i < len; ++i) {
                Parameter param = new Parameter();
                param.read(in, version);
            }
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewScriptParser parser = new NewScriptParser(inputStreamReader);
            Vector[] vec = parser.parse(formulas, queryParams, formulaParams, this.name, null);
            this.variables = vec[0];
            this.arrays = vec[1];
            this.statements = vec[2];
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Cannot parse script: " + this.text, t);
        }
    }

    public void writeXML(Writer out) throws Exception {
        out.write("<SCRIPT>\n");
        out.write("<SCRIPT_NAME>" + XMLUtil.encodeCDATA(this.getName()) + "</SCRIPT_NAME>\n");
        out.write("<SCRIPT_TEXT>" + XMLUtil.encodeCDATA(this.getText()) + "</SCRIPT_TEXT>\n");
        out.write("</SCRIPT>\n");
    }

    public void readXML(Node node, int version, Vector formulas, Vector queryParams, Vector formulaParams) throws Exception {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeName().equalsIgnoreCase("SCRIPT_NAME")) {
                this.name = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (child.getNodeName().equalsIgnoreCase("SCRIPT_TEXT")) {
                this.text = LoadXMLReportHelper.readCDATA(child);
                continue;
            }
            if (!child.getNodeName().equals("PARAMETER")) continue;
            Parameter param = new Parameter();
            param.readXML(child, version);
        }
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(this.text.getBytes("UTF-8"));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            NewScriptParser parser = new NewScriptParser(inputStreamReader);
            Vector[] vec = parser.parse(formulas, queryParams, formulaParams, this.name, null);
            this.variables = vec[0];
            this.arrays = vec[1];
            this.statements = vec[2];
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Cannot parse script: " + this.text, t);
        }
    }

    public String toString() {
        return this.text;
    }

    public void setThisDataType(int datatype) {
        if (this.statements == null) {
            return;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            ((ERStatement)this.statements.elementAt(i)).setThisDataType(datatype);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getName() == null && ((Script)object).getName() == null || this.getName() != null && this.getName().equals(((Script)object).getName())) {
            if (this.getText() == null && ((Script)object).getText() == null) {
                return true;
            }
            if (this.getText() != null && this.getText().equals(((Script)object).getText())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(Script o) {
        return QbUtil.emptyStringIfNull(this.name).compareToIgnoreCase(QbUtil.emptyStringIfNull(o.name));
    }
}

