/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.common.client.ReadDatabase;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataSetREF;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.ParseException;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.Variable;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class ScriptReportElement
extends Operand {
    private static final Logger LOGGER = Logger.getLogger(ScriptReportElement.class.getName());
    ReportElement elt;
    String tableName;
    String columnName;
    int columnIndex = -1;
    Vector dbColumn;
    String id;
    boolean isThisElt;
    Operand rowIndex;
    Variable var;
    int countHelper;
    boolean useScriptedValue;
    int subReportIndex = -1;
    private Report subReport;

    public ScriptReportElement(String tableName, String columnName) {
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public ScriptReportElement(int index) {
        this.columnIndex = index;
    }

    public ScriptReportElement(String id) {
        this.id = id;
    }

    public ScriptReportElement(boolean isThisElt) {
        this.isThisElt = isThisElt;
    }

    public ScriptReportElement(Variable var) {
        this.var = var;
    }

    public void setReportElement(ReportElement elt) {
        this.elt = elt;
    }

    public ReportElement getReportElement() {
        return this.elt;
    }

    public void setColumnIndex(int index) {
        this.columnIndex = index;
    }

    public int getColumnIndex(ReportTable table) {
        if (this.columnIndex >= 0) {
            return this.columnIndex;
        }
        LOGGER.finest("table.getColumnCount=" + table.getColumnCount());
        LOGGER.finest("columnName=" + this.columnName);
        LOGGER.finest("tableName=" + this.tableName);
        for (int i = 0; i < table.getColumnCount(); ++i) {
            ReportColumn col = table.getColumn(i);
            LOGGER.finest("col.getText()=" + col.getText());
            if (this.tableName == null || col.getDBTableName() == null || col.getDBTableName().equalsIgnoreCase("")) {
                if (col.getText().trim().equalsIgnoreCase(this.columnName) || col.getText().trim().equalsIgnoreCase(this.tableName + "." + this.columnName)) {
                    this.columnIndex = i;
                    break;
                }
                if (!col.getID().equalsIgnoreCase(this.id) && (col.getCustomID() == null || !col.getCustomID().equals(this.id))) continue;
                this.columnIndex = i;
                break;
            }
            String tableAlias = this.tableName.replace(' ', '_');
            if (!this.tableName.equalsIgnoreCase(col.getDBTableName()) && !tableAlias.equalsIgnoreCase(col.getDBTableName()) || !col.getText().trim().equalsIgnoreCase(this.columnName)) continue;
            this.columnIndex = i;
            break;
        }
        return this.columnIndex;
    }

    public void setRowIndex(Operand rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Operand getRowIndex() {
        return this.rowIndex;
    }

    public void setUseScriptedValue(boolean b) {
        this.useScriptedValue = b;
    }

    public boolean isUseScriptedValue() {
        return this.useScriptedValue;
    }

    public String getHeader(ReportTable table) {
        ReportColumn column;
        if (this.columnName != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                ReportColumn col = table.getColumn(i);
                if (this.tableName == null || col.getDBTableName() == null || col.getDBTableName().equalsIgnoreCase("")) {
                    if (!col.getText().trim().equalsIgnoreCase(this.columnName)) continue;
                    this.columnIndex = i;
                    break;
                }
                if (!this.tableName.equalsIgnoreCase(col.getDBTableName()) || !col.getText().trim().equalsIgnoreCase(this.columnName)) continue;
                this.columnIndex = i;
                break;
            }
        }
        if (this.columnIndex >= 0 && (column = table.getColumn(this.columnIndex)) != null) {
            return column.getText();
        }
        return "";
    }

    @Override
    public Object getValue(ReportTable table, int row, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.getValue(table, row, page, section, totalpages, totalsections, r, cell, dataobj, secondRound, null, null);
    }

    @Override
    public Object getValue(ReportTable table, int row, int page, int section, int totalpages, int totalsections, Report report, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.getValue(table, row, page, section, totalpages, totalsections, report, cell, dataobj, secondRound, preAggCol, resultCol, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue(ReportTable table, int row, int page, int section, int totalpages, int totalsections, Report report, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        if (this.subReportIndex >= 0) {
            report = report.subReports.elementAt(this.subReportIndex).getSubReport().getReportInfo() != null ? report.subReports.elementAt(this.subReportIndex).getSubReport().getReportInfo() : report.subReports.elementAt(this.subReportIndex).loadReport(report, table);
            report.formatTable();
            table = report.getReportTables().elementAt(0);
            this.subReport = report;
        }
        if (this.var != null) {
            this.columnIndex = Double.valueOf(this.var.getValue().toString()).intValue();
        }
        if (this.elt instanceof ReportImage) {
            return null;
        }
        Object object = null;
        int rowIdx = this.rowIndex != null ? ((Double)this.rowIndex.getValue(table, row, page, section, totalpages, totalsections, report, cell, dataobj, secondRound, preAggCol, resultCol, colData)).intValue() : row;
        if (rowIdx == -1) {
            rowIdx = 0;
            if (table.indexArray != null) {
                rowIdx = table.indexArray[0];
            }
        }
        if (this.isThisElt) {
            this.elt = cell;
            object = dataobj;
        } else if (this.dbColumn != null && this.dbColumn.size() > rowIdx) {
            object = ((Vector)this.dbColumn.elementAt(rowIdx)).elementAt(0);
        } else if (this.columnName != null) {
            ReportColumn col;
            int i;
            for (i = 0; i < table.getColumnCount(); ++i) {
                col = table.getColumn(i);
                if (this.tableName == null || col.getDBTableName() == null || col.getDBTableName().equalsIgnoreCase("")) {
                    if (!col.getText().trim().equalsIgnoreCase(this.columnName)) continue;
                    this.columnIndex = i;
                    break;
                }
                if (!this.tableName.equalsIgnoreCase(col.getDBTableName()) || !col.getText().trim().equalsIgnoreCase(this.columnName)) continue;
                this.columnIndex = i;
                break;
            }
            if (this.columnIndex < 0) {
                for (i = 0; i < table.getColumnCount(); ++i) {
                    col = table.getColumn(i);
                    if (!col.getText().trim().equalsIgnoreCase(this.tableName + "." + this.columnName)) continue;
                    this.columnIndex = i;
                    break;
                }
            }
            if (this.columnIndex < 0) {
                for (i = 0; i < table.getColumnCount(); ++i) {
                    col = table.getColumn(i);
                    if (!col.getText().trim().equalsIgnoreCase(this.columnName)) continue;
                    this.columnIndex = i;
                    break;
                }
            }
            if (this.columnIndex >= 0) {
                DataSet d;
                this.elt = table.getColumn(this.columnIndex);
                if (this.elt == null) {
                    return null;
                }
                if (((ReportColumn)this.elt).getDataSet() instanceof DataSet && (d = (DataSet)((ReportColumn)this.elt).getDataSet()).getData() instanceof DataSetREF && report.isCrossTab() && rowIdx == 0 && ((DataSetREF)d.getData()).getStartIndex() > 0) {
                    rowIdx -= ((DataSetREF)d.getData()).getStartIndex();
                }
                if (colData != null) {
                    object = colData[this.columnIndex].getNonEmptyValue(rowIdx);
                } else if (rowIdx >= ((ReportColumn)this.elt).getDataCount()) {
                    this.countHelper = rowIdx;
                    object = table instanceof ReportTreeTable ? this.findObject(table) : this.findObject(report.getReportTables().elementAt(0));
                } else if (rowIdx == ((ReportColumn)this.elt).getDataCount() && rowIdx > 0) {
                    object = this.getData((ReportColumn)this.elt, rowIdx - 1);
                } else {
                    object = this.getData((ReportColumn)this.elt, rowIdx);
                    while (object == null && table instanceof ReportTreeTable && ((ReportTreeTable)table).countSubTable() > 0) {
                        int idx = 0;
                        if (table.indexArray != null) {
                            idx = table.indexArray[0];
                        }
                        table = ((ReportTreeTable)table).getSubTable(idx);
                        this.elt = table.getColumn(this.columnIndex);
                        if (this.elt == null) {
                            return null;
                        }
                        if (table.indexArray != null) {
                            rowIdx = table.indexArray[rowIdx];
                        }
                        object = this.getData((ReportColumn)this.elt, rowIdx);
                    }
                }
            } else {
                if (this.tableName == null) {
                    throw new ParseException("Column \"" + this.columnName + "\" does not exists!");
                }
                DBInfoBasic dbInfo = report.dbInfo;
                if (dbInfo != null && !report.useBackupData) {
                    ReadDatabase readDB = dbInfo.isUseJNDIDataSource() ? new ReadDatabase(dbInfo.getJNDIName(), dbInfo.getEnvProperties()) : new ReadDatabase(dbInfo.getURLString(), dbInfo.getDriverName(), dbInfo.getUserID(), dbInfo.getPassword());
                    String query = QbUtil.buildSelectQuery(readDB, this.columnName, this.tableName);
                    this.dbColumn = readDB.excuteQuery(query, 0, -1);
                    if (this.dbColumn != null && this.dbColumn.size() > rowIdx) {
                        object = ((Vector)this.dbColumn.elementAt(rowIdx)).elementAt(0);
                    }
                }
            }
        } else if (this.columnIndex >= 0) {
            this.elt = table.getColumn(this.columnIndex);
            if (this.elt == null) {
                return null;
            }
            if (colData != null) {
                object = colData[this.columnIndex].getNonEmptyValue(rowIdx);
            } else if (rowIdx > ((ReportColumn)this.elt).getDataCount()) {
                this.countHelper = rowIdx;
                object = table instanceof ReportTreeTable ? this.findObject(table) : this.findObject(report.getReportTables().elementAt(0));
            } else if (rowIdx == ((ReportColumn)this.elt).getDataCount() && rowIdx > 0) {
                object = this.getData((ReportColumn)this.elt, rowIdx - 1);
            } else {
                object = this.getData((ReportColumn)this.elt, rowIdx);
                while (object == null && table instanceof ReportTreeTable && ((ReportTreeTable)table).countSubTable() > 0) {
                    int idx = 0;
                    if (table.indexArray != null) {
                        idx = table.indexArray[0];
                    }
                    table = ((ReportTreeTable)table).getSubTable(idx);
                    this.elt = table.getColumn(this.columnIndex);
                    if (this.elt == null) {
                        return null;
                    }
                    if (table.indexArray != null) {
                        rowIdx = table.indexArray[rowIdx];
                    }
                    object = this.getData((ReportColumn)this.elt, rowIdx);
                }
            }
        } else if (this.id != null) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                if (!this.id.equalsIgnoreCase(table.getColumn(i).getID()) && !this.id.equalsIgnoreCase(table.getColumn(i).getCustomID())) continue;
                this.elt = table.getColumn(i);
                object = this.getData((ReportColumn)this.elt, rowIdx);
            }
            if (object == null) {
                this.elt = report.getData(this.id);
                if (this.elt == null) {
                    return null;
                }
                if (this.elt instanceof ReportCell && ((ReportCell)this.elt).getFormulaObj() != null) {
                    if (table.getData(this.id) != null) {
                        object = ((ReportCell)this.elt).getFormulaObj().getValue(table, row, page, section, totalpages, totalsections, report, cell, dataobj, secondRound, preAggCol, resultCol);
                    } else {
                        if (!secondRound) throw new Exception("can not calculate at this time");
                        ReportTable tbl = report.getParentTableWithCell(this.id, table);
                        object = ((ReportCell)this.elt).getFormulaObj().getValue(tbl, row, page, section, totalpages, totalsections, report, cell, dataobj, secondRound, preAggCol, resultCol);
                    }
                } else {
                    object = this.elt.getText();
                }
            }
        }
        this.mapType(object);
        if (object != null && !object.equals("") || cell == null) return object;
        IFormat format = cell.getDataFormat();
        if (format == null) {
            return object;
        }
        int type = format.getFormatType();
        Object nullString = "NULL";
        switch (type) {
            case 0: {
                nullString = FormatUtil.nullBoolean;
            }
            case 1: 
            case 2: {
                nullString = FormatUtil.nullNumeric;
            }
            case 3: 
            case 4: {
                nullString = FormatUtil.nullDateTime;
            }
            case 5: 
            case 7: 
            case 8: {
                nullString = FormatUtil.nullString;
            }
            case 6: {
                nullString = FormatUtil.nullBarCode;
            }
        }
        if (!nullString.toString().equalsIgnoreCase("NULL")) return nullString;
        return null;
    }

    private void mapType(Object object) {
        if (object instanceof Boolean) {
            this.datatype = 2;
        } else if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof BigDecimal) {
            this.datatype = 0;
        } else if (object instanceof String) {
            this.datatype = 1;
        } else if (object instanceof Time) {
            this.datatype = 4;
        } else if (object instanceof Timestamp) {
            this.datatype = 5;
        } else if (object instanceof Date) {
            this.datatype = 3;
        }
    }

    public String toString() {
        if (this.tableName != null && this.columnName != null) {
            return "{" + this.tableName + "." + this.columnName + "}";
        }
        if (this.columnName != null) {
            return "{" + this.columnName + "}";
        }
        if (this.columnIndex >= 0) {
            return "COL(" + this.columnIndex + ")";
        }
        if (this.id != null) {
            return "ID(" + this.id + ")";
        }
        if (this.isThisElt) {
            return "this()";
        }
        return null;
    }

    @Override
    public int getDatatype(Report report) {
        if (this.subReportIndex >= 0) {
            if (this.subReport != null) {
                report = this.subReport;
            } else {
                throw new IllegalStateException("Must call getValue before calling getDatatype.");
            }
        }
        if (this.columnName != null) {
            ColData[] colData;
            for (ColData element : colData = report.colData) {
                if (!element.getName().equalsIgnoreCase(this.columnName)) continue;
                this.datatype = Operand.mapToOperandType(element.originalType);
                return this.datatype;
            }
        }
        if (this.columnIndex >= 0) {
            this.datatype = Operand.mapToOperandType(report.getSQLType(report.getColInfoIndex(this.columnIndex)));
        }
        if (this.id != null) {
            ReportElement relt = report.getData(this.id);
            if (relt instanceof ReportCell) {
                this.datatype = Operand.mapToOperandType(((ReportCell)relt).getSQLType());
            } else if (relt instanceof ReportColumn) {
                this.datatype = Operand.mapToOperandType(report.getSQLType(report.getColInfoIndex((ReportColumn)relt)));
            }
        }
        return this.datatype;
    }

    @Override
    public void setThisDataType(int datatype) {
        if (this.isThisElt) {
            this.datatype = datatype;
        }
    }

    private Object findObject(ReportTable table) {
        if (table instanceof ReportTreeTable) {
            Vector<ReportTable> subTables = ((ReportTreeTable)table).getSubTable();
            for (int i = 0; i < subTables.size(); ++i) {
                Object object = this.findObject(subTables.elementAt(i));
                if (object == null || "".equals(object)) continue;
                return object;
            }
        } else {
            if (table.getColumn(this.columnIndex).getDataCount() > this.countHelper) {
                return this.getData(table.getColumn(this.columnIndex), this.countHelper);
            }
            this.countHelper -= table.getColumn(this.columnIndex).getDataCount();
        }
        return null;
    }

    public Object getData(ReportColumn col, int index) {
        if (this.useScriptedValue) {
            return col.getScriptedData(index);
        }
        return col.getData(index);
    }

    public void setSubReportIndex(int index) {
        this.subReportIndex = index;
    }

    public int getSubReportIndex() {
        return this.subReportIndex;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

