/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Vector;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.report.PageBufferGraphics;
import quadbase.reportdesigner.report.RTFUI;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.util.Dimension2D;

public class SubReportUI
extends ReportUI {
    private double offsetX = 0.0;
    private double old_offsetX = 0.0;
    protected double offsetY = 0.0;
    protected boolean multiPage = false;
    protected Vector parentTreeStructure = null;
    private double footerHeight = 0.0;
    protected Vector parentSectionList = null;
    protected Vector parentTableList = null;
    private double reportWidth;
    private double pageWidth;
    public double shift = 0.0;
    private ReportGraphics rg;
    private double leftX = 0.0;
    private boolean drawSubReportInPageHeader = false;

    SubReportUI() {
    }

    public SubReportUI(Report subreport, double x, double y, double reportWidth, double pHeight, ReportUI reportUI) throws Exception {
        super(subreport, reportUI.textGraphics, false);
        if (pHeight < 0.0) {
            this.pageHeight = reportUI.pageHeight;
            this.multiPage = true;
        } else {
            this.pageHeight = pHeight;
        }
        this.pageWidth = reportUI.pageSize != null ? reportUI.pageSize.getWidth() : reportUI.report.getActualPageWidth();
        double orgPageHeight = this.pageHeight;
        this.pageSize = new Dimension2D(this.pageWidth, this.pageHeight);
        if (!(this instanceof RTFUI)) {
            this.maxX = x;
            this.curX = 0.0;
            this.curY = y;
            this.init();
            this.pageSize = new Dimension2D(this.pageSize.getWidth(), orgPageHeight);
        }
        this.totalPages = reportUI.totalPages;
        this.totalSections = reportUI.totalSections;
        this.page = reportUI.page;
        this.section = reportUI.section;
        this.designMode = reportUI.designMode;
        this.enableImageMap = reportUI.enableImageMap;
        this.imageMap = reportUI.imageMap;
        this.parentSectionList = reportUI.sectionList;
        this.parentTableList = reportUI.tableList;
        this.parentTreeStructure = reportUI.treeStructure;
        this.pixelPerInch = reportUI.pixelPerInch;
        this.fontTable = reportUI.getFontTable();
        this.reportWidth = reportWidth;
        double availableWidth = this.pageWidth - this.curX - x % this.pageWidth;
        this.leftX = reportWidth < 0.0 || availableWidth < reportWidth ? availableWidth : reportWidth;
        this.maxX = x;
        this.curX = x;
        this.curY = y;
        this.offsetX = this.curX;
        this.old_offsetX = this.curX;
        this.offsetY = this.curY;
        this.initRepeatSection();
    }

    public void draw(ReportGraphics rGraphics) throws Exception {
        this.rg = rGraphics;
        if (this.rg.pageW > this.pageWidth) {
            this.rg.pageW = this.pageWidth;
        }
        this.report.formatTable();
        int checkBreakForPageFooter = 1;
        if (this.multiPage) {
            checkBreakForPageFooter = -1;
            ReportTable tbl = this.report.getReportTables().elementAt(0);
            this.footerHeight = this.report.getPageFooter().hasNoDrawableData() ? 0.0 : this.resizeSection(rGraphics, this.report.getPageFooter(), tbl, this.treeStructure).getHeight();
        }
        this.drawReport(rGraphics, checkBreakForPageFooter);
    }

    @Override
    void drawTable(ReportGraphics g, ReportTableElement tbl) {
        int i;
        if (g == null || tbl.getBgColor() == null) {
            return;
        }
        g.setColor(tbl.getBgColor());
        if (this.rg != null) {
            this.rg.pageW = this.old_offsetX % this.pageWidth + this.leftX;
        }
        g.fillRect(this.old_offsetX, this.curY, this.leftX, tbl.getHeight());
        int count = (int)Math.ceil((this.old_offsetX + this.reportWidth + this.shift) / this.pageWidth);
        if (count > 1 && this.rg != null) {
            this.rg.pageW = this.pageWidth;
        }
        for (i = (int)Math.floor(this.old_offsetX / this.pageWidth) + 1; i < count - 1; ++i) {
            g.fillRect((double)i * this.pageWidth, this.curY, this.pageWidth, tbl.getHeight());
        }
        if (count > 1) {
            g.fillRect((double)i * this.pageWidth, this.curY, (this.old_offsetX + this.reportWidth + this.shift) % this.pageWidth, tbl.getHeight());
        }
    }

    @Override
    void setColumnWrap() {
        super.setColumnWrap(this.pageWidth);
    }

    @Override
    public void initCurrentPosition() {
    }

    @Override
    protected void sectionBreak(double x, double requiredWidth) {
        if (this.isDesignMode()) {
            return;
        }
        if (Math.ceil((x + this.curX + requiredWidth) / this.pageWidth) != Math.ceil((x + this.curX) / this.pageWidth) && (x + this.curX) % this.pageWidth != 0.0) {
            double temp = this.pageWidth - (x + this.curX) % this.pageWidth;
            if (this.reportWidth > 0.0 && x + this.curX + temp + requiredWidth > this.old_offsetX + this.reportWidth + this.shift) {
                return;
            }
            this.incCurX(temp);
            this.shift = this.offsetX == this.old_offsetX ? temp : (this.shift += temp);
        }
        if (x + requiredWidth + this.curX > this.maxX) {
            this.maxX = x + requiredWidth + this.curX;
        }
        this.setPageW(x);
    }

    @Override
    protected void setPageW(double x) {
        if (Math.floor((x + this.curX) / this.pageWidth) == Math.floor((this.old_offsetX + this.shift) / this.pageWidth)) {
            this.offsetX = this.old_offsetX;
            if (this.rg != null) {
                this.rg.pageW = this.offsetX % this.pageWidth + this.leftX;
            }
        } else if (Math.floor((x + this.curX) / this.pageWidth) == Math.floor((this.reportWidth + this.old_offsetX + this.shift) / this.pageWidth)) {
            double d = this.reportWidth - this.leftX + this.shift - this.pageWidth * Math.floor((this.reportWidth - this.leftX + this.shift) / this.pageWidth);
            this.offsetX = this.pageWidth * Math.floor((x + this.curX) / this.pageWidth);
            if (this.rg != null) {
                this.rg.pageW = d;
            }
        } else {
            this.offsetX = this.pageWidth * Math.floor((x + this.curX) / this.pageWidth);
            if (this.rg != null) {
                this.rg.pageW = this.pageWidth;
            }
        }
    }

    @Override
    protected double getPageCurY() {
        if (this.multiPage) {
            return this.curY % this.pageSize.getHeight();
        }
        return this.curY - this.offsetY;
    }

    @Override
    protected double getDrawablePageHeight() {
        if (this.multiPage) {
            double pHeight = this.pageSize.getHeight() - this.footerHeight;
            if (pHeight <= 0.0) {
                pHeight = 0.001;
            }
            return pHeight;
        }
        return this.pageSize.getHeight();
    }

    @Override
    protected void setPrintOnNewPage(ReportGraphics g, ReportSection section) throws Exception {
        this.setPrintOnNewPage(g, section, true);
    }

    @Override
    protected void setPrintOnNewPage(ReportGraphics g, ReportSection section, boolean performRoundingCheck) throws Exception {
        double tmp = this.getPageCurY();
        if (tmp > this.pageSize.getHeight() - 0.001 || tmp < 0.001) {
            return;
        }
        boolean firstPage = false;
        if (this.curY != this.offsetY) {
            this.drawSection(g, this.report.getPageFooter(), this.report.getReportTables().elementAt(0), false);
        } else {
            firstPage = true;
        }
        tmp = this.curY % this.pageSize.getHeight();
        if (tmp <= this.pageSize.getHeight() - 0.001 && tmp >= 0.001) {
            this.incCurY(this.pageSize.getHeight() - tmp);
        }
        if (this.parentSectionList != null && this.parentSectionList.size() > 0) {
            this.drawParentRepeatSection(g, section);
        }
        if (!firstPage && !this.drawSubReportInPageHeader) {
            this.drawSection(g, this.report.getPageHeader(), this.report.getReportTables().elementAt(0), true);
        }
        this.rowCount = 0;
        if (this.sectionList != null && this.sectionList.size() > 0) {
            this.drawRepeatSection(g, section);
        }
    }

    boolean isDrawingSubReportInPageHeader() {
        return this.drawSubReportInPageHeader;
    }

    void setDrawingSubReportInPageHeader(boolean b) {
        this.drawSubReportInPageHeader = b;
    }

    protected void drawParentRepeatSection(ReportGraphics g, ReportSection section) throws Exception {
        if (this.parentSectionList != null) {
            for (int i = 0; i < this.parentSectionList.size(); ++i) {
                if (this.parentSectionList.elementAt(i) == section) {
                    return;
                }
                this.incrementYForSection(g, (ReportSection)this.parentSectionList.elementAt(i), (ReportTable)this.parentTableList.elementAt(i));
            }
        }
    }

    private void incrementYForSection(ReportGraphics g, ReportSection sec, ReportTable tbl) throws Exception {
        ReportSection section = sec;
        if (section == null || !section.isVisible()) {
            return;
        }
        if (section.isPrintOnNewPage()) {
            this.setPrintOnNewPage(g, section);
        }
        if (section.getData() == null || section.hasNoDrawableData(this.parentTreeStructure)) {
            return;
        }
        ReportSection cellArray = null;
        cellArray = this.resizeSection(g, section, tbl, this.parentTreeStructure);
        this.pageBreak(g, cellArray.getHeight(), section);
        if (g instanceof PageBufferGraphics && !(this instanceof RTFUI)) {
            this.drawSection(g, cellArray, tbl, true);
        } else {
            this.incCurY(cellArray.getHeight());
        }
        for (int i = 0; i < sec.getSectionCount(); ++i) {
            section = sec.getSection(i);
            if (section == null || !section.isVisible()) {
                return;
            }
            if (section.isPrintOnNewPage()) {
                this.setPrintOnNewPage(g, section);
            }
            if (section.getData() == null || section.hasNoDrawableData(this.parentTreeStructure)) {
                return;
            }
            cellArray = null;
            cellArray = this.resizeSection(g, section, tbl, this.parentTreeStructure);
            this.pageBreak(g, cellArray.getHeight(), section);
            if (g instanceof PageBufferGraphics && !(this instanceof RTFUI)) {
                this.drawSection(g, cellArray, tbl, true);
                continue;
            }
            this.incCurY(cellArray.getHeight());
        }
    }
}

