/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataSet;
import quadbase.common.util.internal.DataSetColumn;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.FormattedCell;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.report.Aggregation;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Formula;
import quadbase.reportdesigner.report.FormulaParser;
import quadbase.reportdesigner.report.MultiDimData;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportMultiSectionTable;

public class SummaryTable
extends ReportMultiSectionTable {
    private static final Logger LOGGER = Logger.getLogger(SummaryTable.class.getName());
    MultiDimData mData;
    int count;

    public SummaryTable(Report report) {
        super(report.getLocale(), report.getTimeZone());
        this.setWidth(report.getActualPageWidth());
        for (int i = 0; i < report.colInfo.length; ++i) {
            ReportColumn rCol = report.createColumn(i, report.colInfo.length);
            rCol.setVisible(report.colInfo[i].isVisible());
            this.addColumn(rCol);
        }
        this.formatColumn();
        this.mData = this.createMultiDimData(report);
        int sectionOffset = 0;
        if (report.isAggregationOn()) {
            sectionOffset = 1;
        }
        this.dataHeader = new ReportSection[report.breakColInfo.length - sectionOffset];
        this.dataFooter = new ReportSection[report.breakColInfo.length - sectionOffset];
        for (int i = 0; i < this.dataHeader.length; ++i) {
            this.dataHeader[i] = new ReportSection(this);
            this.dataFooter[i] = new ReportSection(this);
        }
    }

    public SummaryTable(Report report, Report oldReport) {
        super(report.getLocale(), report.getTimeZone());
        this.setWidth(report.getActualPageWidth());
        for (int i = 0; i < report.colInfo.length; ++i) {
            ReportTable table = oldReport.getReportTables().elementAt(0);
            ReportColumn rCol = report.createColumn(i, table.getColumn(i).getFormattedCellsTable(), report.colInfo.length);
            rCol.setVisible(report.colInfo[i].isVisible());
            this.addColumn(rCol);
        }
        this.formatColumn();
        this.mData = this.createMultiDimData(report);
        int sectionOffset = 0;
        if (report.isAggregationOn()) {
            sectionOffset = 1;
        }
        this.dataHeader = new ReportSection[report.breakColInfo.length - sectionOffset];
        this.dataFooter = new ReportSection[report.breakColInfo.length - sectionOffset];
        for (int i = 0; i < this.dataHeader.length; ++i) {
            this.dataHeader[i] = new ReportSection(this);
            this.dataFooter[i] = new ReportSection(this);
        }
    }

    public SummaryTable(SummaryTable _table) {
        super(_table);
        this.mData = _table.mData;
        this.count = _table.count;
        this.header = _table.header;
        this.footer = _table.footer;
        for (int i = 0; i < _table.getColumnCount(); ++i) {
            ReportColumn tcol = new ReportColumn(_table.getColumn(i));
            tcol.resetData();
            this.addColumn(tcol);
        }
    }

    private MultiDimData createMultiDimData(Report report) {
        MultiDimData mData = new MultiDimData(report);
        for (int i = 0; i < report.colData[0].getSize(); ++i) {
            mData.addRecNo(i);
        }
        mData.build(0);
        if (!report.isColDataSorted() && mData.report.recIndex == null) {
            mData.report.recIndex = new int[report.colData[0].getSize()];
            this.count = 0;
            this.traversMultiDataTree(mData, mData.report.recIndex);
            for (ColData element : mData.report.colData) {
                element.setRecIndex(report.recIndex);
            }
        }
        return mData;
    }

    private void traversMultiDataTree(MultiDimData multiData, int[] recIndex) {
        block4: {
            if (multiData == null) break block4;
            if (multiData.multiData != null) {
                for (MultiDimData element : multiData.multiData) {
                    this.traversMultiDataTree(element, recIndex);
                }
            } else {
                for (int i = 0; i < multiData.recNoVec.size(); ++i) {
                    recIndex[this.count++] = multiData.recNoVec.elementAt(i);
                }
            }
        }
    }

    @Override
    public void formatTable() throws Exception {
        Vector<ReportTable> _subTables = this.getSubTable();
        this.reformat();
        Properties treeProp2 = new Properties();
        int nCol = this.mData.report.colInfo.length;
        DataSet[] dataSetTree = new DataSet[nCol];
        for (int j = 0; j < nCol; ++j) {
            dataSetTree[j] = new DataSetColumn(SummaryTable.getColumnAddress(j), ServerMessage.getMaxFieldSize(), nCol, true, treeProp2);
        }
        this.createTable(this.mData, this, dataSetTree);
        if (this.mData.report.getTopN() > 0) {
            this.topN(this, this.mData.report, 0);
        }
        this.setTableNumber(this);
        this.copyFormattedInfo(this);
        Vector<ReportTable> subTables = this.getSubTable();
        if (_subTables.size() != subTables.size()) {
            this.releaseDiskBuffer();
            ColData.releaseDiskBuffer(this.mData.report.colData);
            return;
        }
        for (int i = 0; i < _subTables.size(); ++i) {
            ReportTable _tbl = _subTables.elementAt(i);
            ReportTable tbl = subTables.elementAt(i);
            tbl.copySortingInfo(_tbl, 0, false, this.mData.report);
            tbl.setTableNumber(_tbl.getTableNumber());
        }
        this.setTableID();
        this.releaseDiskBuffer();
        ColData.releaseDiskBuffer(this.mData.report.colData);
    }

    private ReportTable createTable(MultiDimData data, ReportTreeTable cTbl, DataSet[] dataSetTree) throws Exception {
        if (data == null) {
            return null;
        }
        if (data.report.isColDataSorted() || data.report.recIndex != null) {
            return SummaryTable.createTableFromSortedData(this, data, cTbl);
        }
        int nCol = data.report.colInfo.length;
        if (data.multiData != null) {
            for (MultiDimData element : data.multiData) {
                ReportTable subTbl = null;
                if (element != null) {
                    Properties treeProp = new Properties();
                    treeProp.put("DataSetTreeArray", dataSetTree);
                    subTbl = this.createTable(element, new ReportTreeTable(this, nCol, treeProp), dataSetTree);
                }
                if (subTbl == null) continue;
                cTbl.addSubTable(subTbl);
            }
            if (cTbl.countSubTable() == 0) {
                return null;
            }
            if (data.level <= this.dataHeader.length && data.level > 0) {
                cTbl.setHeader(this.dataHeader[data.level - 1]);
                cTbl.setFooter(this.dataFooter[data.level - 1]);
                cTbl.getFirstTable().getColumn(data.report.breakColIndex[data.level - 1]).setData(0, data.getFieldName());
                cTbl.setDrillDownData(data.report.breakColIndex[data.level - 1], data.getFieldName());
                if (data.report.colInfo[data.report.breakColIndex[data.level - 1]].isRepeatBreakField()) {
                    int columnIndex = data.report.breakColIndex[data.level - 1];
                    this.setRepeatBreakField(cTbl, columnIndex, data.getFieldName());
                }
            }
            return cTbl;
        }
        if (data.plotData == null || data.plotData.isEmpty()) {
            return null;
        }
        int nRow = data.getValueCount();
        int vIndex = 0;
        ReportTable rTbl = new ReportTable(this);
        for (int i = 0; i < nCol; ++i) {
            Properties treeProp = new Properties();
            treeProp.put("DataSetTree", dataSetTree[i]);
            ReportColumn rCol = new ReportColumn(this.getColumn(i), treeProp);
            rCol.resetData();
            Object drillDownValue = null;
            Vector<Object> aData = new Vector<Object>();
            boolean nonRowBreak = false;
            for (int j = 0; j < nRow; ++j) {
                Object tblCol = null;
                if (data.report.colInfo[i].isRowBreak()) {
                    LOGGER.finest("isRowBreak");
                    tblCol = "";
                    if (i == data.report.breakColIndex[data.level - 1]) {
                        if (j == 0) {
                            drillDownValue = tblCol = data.getFieldName();
                        } else if (data.report.colInfo[i].isRepeatBreakField()) {
                            LOGGER.finest("isRepeatBreakField");
                            tblCol = data.getFieldName();
                        }
                    }
                } else if (data.report.colInfo[i].getFormula() == null) {
                    nonRowBreak = true;
                    tblCol = data.getValue(j, vIndex);
                }
                if (data.report.colInfo[i].getMapping() < 0) continue;
                rCol.addData(tblCol);
            }
            if (nonRowBreak) {
                data.getValueList(vIndex, aData);
                ++vIndex;
            }
            int aDataSize = aData.size();
            for (int j = 0; j < aDataSize; ++j) {
                rCol.addActualData(aData.elementAt(j));
            }
            rCol.setDrillDownData(drillDownValue);
            rTbl.addColumn(rCol);
        }
        FormulaParser parser = null;
        for (int i = 0; i < nCol; ++i) {
            Object formula;
            if (data.report.colInfo[i].getFormulaObj() == null) {
                formula = data.report.colInfo[i].getFormula();
                if (formula == null) continue;
                int sqlType = data.report.colInfo[i].getDataType();
                if (parser == null) {
                    parser = new FormulaParser(rTbl, data.report);
                }
                for (int j = 0; j < nRow; ++j) {
                    rTbl.getColumn(i).addData(parser.parse((String)formula, sqlType, j));
                }
                continue;
            }
            formula = data.report.colInfo[i].getFormulaObj();
            if (formula == null) continue;
            for (int j = 0; j < nRow; ++j) {
                try {
                    rTbl.getColumn(i).addData(((Formula)formula).getValue(rTbl, j, 1, 1, 1, 1, data.report, null, null));
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINER, "Can't add formula data to report column", ex);
                    rTbl.getColumn(i).addData(null);
                }
            }
        }
        if (data.level <= this.dataHeader.length && data.level > 0) {
            rTbl.setHeader(this.dataHeader[data.level - 1]);
            rTbl.setFooter(this.dataFooter[data.level - 1]);
        }
        return rTbl;
    }

    static ReportTable createTableFromSortedData(ReportMultiSectionTable pTable, MultiDimData data, ReportTreeTable cTbl) throws Exception {
        int i;
        if (data == null || cTbl == null) {
            return null;
        }
        Report report = data.report;
        int numBreakCol = report.breakColInfo.length;
        int numTotalRow = report.colData[0].getSize();
        int nCol = report.colInfo.length;
        int numRow = 0;
        ReportTable[] currentRT = new ReportTable[numBreakCol];
        DataSet[] dataSetTree = new DataSet[nCol];
        Vector[] storedRT = new Vector[numBreakCol];
        DataSet[] cRTValues = new DataSet[nCol];
        Object[] masterValues = new Object[nCol];
        Properties treeProp2 = new Properties();
        for (int j = 0; j < nCol; ++j) {
            dataSetTree[j] = new DataSetColumn(SummaryTable.getColumnAddress(j), ServerMessage.getMaxFieldSize(), nCol, true, treeProp2);
        }
        if (numTotalRow == 0) {
            return null;
        }
        for (i = 0; i < numBreakCol; ++i) {
            if (i < numBreakCol - 1) {
                Properties treeProp = new Properties();
                treeProp.put("DataSetTreeArray", dataSetTree);
                currentRT[i] = new ReportTreeTable(pTable, nCol, treeProp);
            } else {
                currentRT[i] = new ReportTable(pTable);
                for (int j = 0; j < nCol; ++j) {
                    cRTValues[j] = new DataSet(SummaryTable.getAddress(j), ServerMessage.getMaxFieldSize(), nCol, true, null);
                    if (report.colInfo[j].getFormula() != null) continue;
                    cRTValues[j].addElement(report.colData[report.colInfo[j].getMapping()].getData(0));
                    masterValues[j] = report.colData[report.colInfo[j].getMapping()].getData(0);
                }
                ++numRow;
            }
            if (i < pTable.dataHeader.length && i >= 0) {
                currentRT[i].setHeader(pTable.dataHeader[i]);
                currentRT[i].setFooter(pTable.dataFooter[i]);
            }
            storedRT[i] = new Vector();
        }
        for (int recNo = 1; recNo < numTotalRow; ++recNo) {
            for (int i2 = 0; i2 < numBreakCol; ++i2) {
                int j;
                int cMap = report.breakColInfo[i2].getMapping();
                Object oldvalue = report.colData[cMap].getData(recNo - 1);
                Object newvalue = report.colData[cMap].getData(recNo);
                if (oldvalue == null && newvalue == null || oldvalue != null && newvalue != null && oldvalue.equals(newvalue)) {
                    if (i2 != numBreakCol - 1) continue;
                    for (j = 0; j < nCol; ++j) {
                        if (report.colInfo[j].isRowBreak() || report.colInfo[j].getFormula() != null) continue;
                        cRTValues[j].addElement(report.colData[report.colInfo[j].getMapping()].getData(recNo));
                    }
                    ++numRow;
                    continue;
                }
                for (j = i2; j < numBreakCol; ++j) {
                    if (j == i2) {
                        storedRT[j].addElement(currentRT[j]);
                    }
                    if (j < numBreakCol - 1) {
                        storedRT[j + 1].addElement(currentRT[j + 1]);
                        Vector cVect = storedRT[j + 1];
                        for (int k = 0; k < cVect.size(); ++k) {
                            ReportTable temprt = (ReportTable)cVect.elementAt(k);
                            ((ReportTreeTable)currentRT[j]).addSubTable(temprt);
                        }
                        cVect.removeAllElements();
                        Properties treeProp = new Properties();
                        treeProp.put("DataSetTreeArray", dataSetTree);
                        currentRT[j] = new ReportTreeTable(pTable, nCol, treeProp);
                    } else {
                        for (int k = 0; k < nCol; ++k) {
                            Object tblCol = null;
                            Properties treeProp = new Properties();
                            treeProp.put("DataSetTree", dataSetTree[k]);
                            ReportColumn rCol = new ReportColumn(pTable.getColumn(k), treeProp);
                            rCol.resetData();
                            Object drillDownValue = null;
                            if (report.isAggregationOn()) {
                                if (!report.colInfo[k].isRowBreak() && report.colInfo[k].getFormula() == null) {
                                    tblCol = Aggregation.getComputedValue(report.colInfo[k].getAggregation(), QbUtil.toArray(cRTValues[k]));
                                } else if (cRTValues[k].size() > 0) {
                                    tblCol = cRTValues[k].elementAt(0);
                                } else {
                                    tblCol = report.colInfo[k].isRepeatBreakField() ? masterValues[k] : "";
                                    drillDownValue = masterValues[k];
                                }
                                rCol.addData(tblCol);
                            } else {
                                for (int m = 0; m < numRow; ++m) {
                                    if (cRTValues[k].size() > m) {
                                        tblCol = cRTValues[k].elementAt(m);
                                    } else {
                                        tblCol = report.colInfo[k].isRepeatBreakField() ? masterValues[k] : "";
                                        drillDownValue = cRTValues[k].size() > 0 ? cRTValues[k].elementAt(0) : masterValues[k];
                                    }
                                    rCol.addData(tblCol);
                                }
                            }
                            int aDataSize = cRTValues[k].size();
                            for (int m = 0; m < aDataSize; ++m) {
                                rCol.addActualData(cRTValues[k].elementAt(m));
                            }
                            rCol.setDrillDownData(drillDownValue);
                            cRTValues[k].removeAllElements();
                            currentRT[j].addColumn(rCol);
                            if (report.colInfo[k].isRowBreak() && k < report.breakColIndex[i2] || report.colInfo[k].getFormula() != null) continue;
                            cRTValues[k].addElement(report.colData[report.colInfo[k].getMapping()].getData(recNo));
                            masterValues[k] = report.colData[report.colInfo[k].getMapping()].getData(recNo);
                        }
                        FormulaParser parser = null;
                        for (int k = 0; k < nCol; ++k) {
                            Object formula;
                            if (report.colInfo[k].getFormulaObj() == null) {
                                formula = report.colInfo[k].getFormula();
                                if (formula == null) continue;
                                int sqlType = report.colInfo[k].getDataType();
                                if (parser == null) {
                                    parser = new FormulaParser(currentRT[j], report);
                                }
                                if (report.isAggregationOn()) {
                                    numRow = 1;
                                }
                                Object tblCol = null;
                                currentRT[j].getColumn(k).resetData();
                                for (int m = 0; m < numRow; ++m) {
                                    tblCol = parser.parse((String)formula, sqlType, m);
                                    currentRT[j].getColumn(k).addData(tblCol);
                                }
                                continue;
                            }
                            formula = report.colInfo[k].getFormulaObj();
                            if (formula == null) continue;
                            if (report.isAggregationOn()) {
                                numRow = 1;
                            }
                            Object tblCol = null;
                            currentRT[j].getColumn(k).resetData();
                            for (int m = 0; m < numRow; ++m) {
                                try {
                                    tblCol = ((Formula)formula).getValue(currentRT[j], m, 1, 1, 1, 1, report, null, null);
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.FINER, "Can't add formula data to report column", ex);
                                    tblCol = null;
                                }
                                currentRT[j].getColumn(k).addData(tblCol);
                            }
                        }
                        numRow = 1;
                        currentRT[j] = new ReportTable(pTable);
                    }
                    if (j >= pTable.dataHeader.length || j < 0) continue;
                    currentRT[j].setHeader(pTable.dataHeader[j]);
                    currentRT[j].setFooter(pTable.dataFooter[j]);
                }
                i2 = numBreakCol;
            }
        }
        for (i = numBreakCol - 1; i >= -1; --i) {
            if (i > -1) {
                storedRT[i].addElement(currentRT[i]);
            }
            if (i < numBreakCol - 1) {
                ReportTreeTable prtt = cTbl;
                if (i > -1) {
                    prtt = (ReportTreeTable)currentRT[i];
                }
                Vector cVect = storedRT[i + 1];
                for (int k = 0; k < cVect.size(); ++k) {
                    ReportTable temprt = (ReportTable)cVect.elementAt(k);
                    prtt.addSubTable(temprt);
                }
                cVect.removeAllElements();
                continue;
            }
            for (int k = 0; k < nCol; ++k) {
                Object tblCol = null;
                Object drillDownValue = null;
                Properties treeProp = new Properties();
                treeProp.put("DataSetTree", dataSetTree[k]);
                ReportColumn rCol = new ReportColumn(pTable.getColumn(k), treeProp);
                rCol.resetData();
                if (report.isAggregationOn()) {
                    if (!report.colInfo[k].isRowBreak() && report.colInfo[k].getFormula() == null) {
                        tblCol = Aggregation.getComputedValue(report.colInfo[k].getAggregation(), QbUtil.toArray(cRTValues[k]));
                    } else if (cRTValues[k].size() > 0) {
                        tblCol = cRTValues[k].elementAt(0);
                    } else {
                        tblCol = report.colInfo[k].isRepeatBreakField() ? masterValues[k] : "";
                        drillDownValue = masterValues[k];
                    }
                    rCol.addData(tblCol);
                } else {
                    for (int m = 0; m < numRow; ++m) {
                        if (cRTValues[k].size() > m) {
                            tblCol = cRTValues[k].elementAt(m);
                        } else {
                            tblCol = report.colInfo[k].isRepeatBreakField() ? masterValues[k] : "";
                            drillDownValue = cRTValues[k].size() > 0 ? cRTValues[k].elementAt(0) : masterValues[k];
                        }
                        rCol.addData(tblCol);
                    }
                }
                rCol.setDrillDownData(drillDownValue);
                int aDataSize = cRTValues[k].size();
                for (int m = 0; m < aDataSize; ++m) {
                    rCol.addActualData(cRTValues[k].elementAt(m));
                }
                cRTValues[k].removeAllElements();
                currentRT[i].addColumn(rCol);
            }
            FormulaParser parser = null;
            for (int k = 0; k < nCol; ++k) {
                Object formula;
                if (report.colInfo[k].getFormulaObj() == null) {
                    formula = report.colInfo[k].getFormula();
                    if (formula == null) continue;
                    int sqlType = report.colInfo[k].getDataType();
                    if (parser == null) {
                        parser = new FormulaParser(currentRT[i], report);
                    }
                    if (report.isAggregationOn()) {
                        numRow = 1;
                    }
                    Object tblCol = null;
                    currentRT[i].getColumn(k).resetData();
                    for (int m = 0; m < numRow; ++m) {
                        tblCol = parser.parse((String)formula, sqlType, m);
                        currentRT[i].getColumn(k).addData(tblCol);
                    }
                    continue;
                }
                formula = report.colInfo[k].getFormulaObj();
                if (formula == null) continue;
                if (report.isAggregationOn()) {
                    numRow = 1;
                }
                Object tblCol = null;
                currentRT[i].getColumn(k).resetData();
                for (int m = 0; m < numRow; ++m) {
                    try {
                        tblCol = ((Formula)formula).getValue(currentRT[i], m, 1, 1, 1, 1, report, null, null);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINER, "Can't add formula data to report column", ex);
                        tblCol = null;
                    }
                    currentRT[i].getColumn(k).addData(tblCol);
                }
            }
        }
        return cTbl;
    }

    private static String getAddress(int j) {
        return "SUMT_" + j + "_" + QbUtil.nextNumber();
    }

    private static String getColumnAddress(int j) {
        return "SUMCOL_" + j + "_" + QbUtil.nextNumber();
    }

    private void setTableNumber(ReportTreeTable cTbl) {
        for (int i = 0; i < cTbl.getSubTable().size(); ++i) {
            cTbl.getSubTable(i).setTableNumber(i);
        }
    }

    private void setRepeatBreakField(ReportTable table, int columnIndex, Object fieldName) {
        if (table instanceof ReportTreeTable) {
            ReportTreeTable treeTable = (ReportTreeTable)table;
            for (int i = 0; i < treeTable.getSubTable().size(); ++i) {
                this.setRepeatBreakField(treeTable.getSubTable().elementAt(i), columnIndex, fieldName);
            }
        } else {
            ReportColumn column = table.getColumn(columnIndex);
            for (int i = 0; i < column.getDataCount(); ++i) {
                column.setData(i, fieldName);
            }
        }
    }

    private ReportTreeTable copyFormattedInfo(ReportTreeTable cTbl) {
        for (int i = 0; i < cTbl.getColumnCount(); ++i) {
            Hashtable<FormattedRowKey, FormattedCell> formattedCellsTable = cTbl.getColumn(i).getFormattedCellsTable();
            if (formattedCellsTable == null) continue;
            LOGGER.finest("formattedCellsTable is not null");
            Enumeration<FormattedRowKey> keys = formattedCellsTable.keys();
            while (keys.hasMoreElements()) {
                FormattedRowKey key = keys.nextElement();
                int[] tree = key.getTreeStructure();
                FormattedCell cell = formattedCellsTable.get(key);
                if (tree == null || cell == null) continue;
                ReportTable table = cTbl;
                for (int element : tree) {
                    if (!(table instanceof ReportTreeTable) || element < 0 || element >= table.countSubTable()) continue;
                    table = table.getSubTable(element);
                }
                table.getColumn(i).addFormattedCell(cell);
            }
        }
        if (cTbl.getFormattedRows() != null) {
            Enumeration<FormattedRowKey> keys = cTbl.getFormattedRows().keys();
            while (keys.hasMoreElements()) {
                FormattedRowKey key = keys.nextElement();
                int[] tree = key.getTreeStructure();
                if (tree == null) continue;
                ReportTable table = cTbl;
                for (int j = 0; j < tree.length - 1; ++j) {
                }
                for (int element : tree) {
                    if (!(table instanceof ReportTreeTable)) continue;
                    ReportTreeTable treeTable = table;
                    if (element < 0 || element >= treeTable.countSubTable()) continue;
                    table = ((ReportTreeTable)table).getSubTable(element);
                    table.addFormattedRow(key, cTbl.getFormattedRows().get(key));
                }
            }
        }
        return cTbl;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.reformat();
        super.write(out);
        try {
            this.formatTable();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Can't format table", ex);
        }
    }

    public void topN(ReportTable table, Report report, int level) {
        block12: {
            block10: {
                Vector<ReportTable> subTable;
                block11: {
                    if (!(table instanceof ReportTreeTable)) break block10;
                    subTable = ((ReportTreeTable)table).getSubTable();
                    if (!report.breakColInfo[level].isTopN()) break block11;
                    int colIndex = 0;
                    for (int i = 0; i < report.colInfo.length; ++i) {
                        if (report.colInfo[i] != report.breakColInfo[level]) continue;
                        colIndex = i;
                    }
                    int[] sortedIndex = ((ReportTreeTable)table).sort(colIndex, true);
                    if (sortedIndex == null) break block12;
                    int size = report.getTopN() < sortedIndex.length ? report.getTopN() : sortedIndex.length;
                    int[] sortedTopNIndex = new int[size];
                    for (int i = 0; i < size; ++i) {
                        sortedTopNIndex[i] = sortedIndex[i];
                    }
                    ((ReportTreeTable)table).setTopNTable(sortedTopNIndex);
                    break block12;
                }
                for (int i = 0; i < subTable.size(); ++i) {
                    this.topN(subTable.elementAt(i), report, level + 1);
                }
                break block12;
            }
            int colIndex = 0;
            for (int i = 0; i < report.colInfo.length; ++i) {
                if (!report.colInfo[i].isTopN()) continue;
                colIndex = i;
            }
            ReportColumn column = table.getColumn(colIndex);
            int[] sortedIndex = null;
            sortedIndex = !report.isAggregationOn() ? column.sort(report.isAscending()) : column.sortActualdata(report.isAscending());
            if (sortedIndex == null) {
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    table.getColumn(i).setTopNData(null, false, (short)0);
                }
            } else {
                int i;
                int size = report.getTopN() < sortedIndex.length ? report.getTopN() : sortedIndex.length;
                int[] sortedTopNIndex = new int[size];
                for (i = 0; i < size; ++i) {
                    sortedTopNIndex[i] = sortedIndex[i];
                }
                for (i = 0; i < table.getColumnCount(); ++i) {
                    short aggr = 0;
                    if (report.colInfo[i].isAggregatedColumn()) {
                        aggr = report.colInfo[i].getAggregation();
                    }
                    table.getColumn(i).setTopNData(sortedTopNIndex, report.colInfo[i].isRowBreak(), aggr);
                }
            }
        }
    }
}

