/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import quadbase.reportdesigner.ReportElements.Bookmark;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportUI;

public class TableOfContentsUI
extends ReportUI {
    TableOfContents toc;
    double offsetX = 0.0;
    double offsetY = 0.0;
    double width;
    double height;
    ReportGraphics rg;
    ReportUI reportUI;
    double entryHeight;
    double lineSpace = 0.0;
    double miniSpacer = 0.2;

    public TableOfContentsUI(TableOfContents toc, double x, double y, double width, double height, ReportUI reportUI) {
        this.toc = toc;
        this.offsetX = x;
        this.offsetY = y;
        this.width = width;
        this.height = height;
        this.reportUI = reportUI;
        this.pageSize = reportUI.pageSize;
    }

    public double draw(ReportGraphics rg) throws Exception {
        this.rg = rg;
        this.curX = this.offsetX;
        this.curY = this.offsetY;
        for (int i = 0; i < this.toc.getBookmarks().size(); ++i) {
            Bookmark entry = this.toc.getBookmarks().elementAt(i);
            double indentWidth = this.toc.getIndentInInches(entry, rg);
            ReportCell numberingElt = this.toc.getFormattedNumbering(entry, rg);
            double numberingWidth = 0.1;
            if (numberingElt != null) {
                numberingWidth = numberingElt.getWidth();
            }
            ReportCell pageNumberElt = this.toc.getFormattedPageNumber(entry, rg);
            double pageNumberWidth = pageNumberElt.getWidth();
            double maxTitleWidth = this.width - indentWidth - numberingWidth - this.miniSpacer - pageNumberWidth;
            this.entryHeight = this.toc.getEntryHeight(entry, maxTitleWidth, rg);
            if (this.height != -1.0 && this.curY + this.entryHeight > this.offsetY + this.height) break;
            this.pageBreak(rg, this.entryHeight, null);
            if (this.toc.getBgColor() != null) {
                rg.fillRect(this.curX, this.curY, this.toc.getWidth(), this.entryHeight, this.toc.getBgColor());
            }
            this.curX += indentWidth;
            if (this.toc.isShowNumbering()) {
                rg.setColor(this.toc.getFontColor(entry.getLevel()));
                this.curX += this.drawNumbering(numberingElt, this.toc.getFontColor(entry.getLevel()));
            }
            this.curX += this.drawTitle(this.toc.getFormattedTitle(entry, maxTitleWidth, rg));
            if (this.toc.isShowPageNumber()) {
                if (this.toc.isShowSpacer()) {
                    double spacerWidth = this.offsetX + this.toc.getWidth() - this.curX - pageNumberWidth;
                    this.curX += this.drawSpacer(this.toc.getSpacer(spacerWidth, this.entryHeight, entry, rg));
                }
                this.drawPageNumber(pageNumberElt);
            }
            this.curX = this.offsetX;
            this.curY = this.curY + this.entryHeight + this.lineSpace;
        }
        return this.curY;
    }

    private double drawNumbering(ReportCell cell, Color color) throws Exception {
        if (cell != null) {
            this.rg.drawCell(this.toc.getReport(), this.toc.getReport().getReportTables().elementAt(0), null, cell, this.curX, this.curY);
            return cell.getWidth();
        }
        this.rg.drawBullet(this.curX, this.curY + this.entryHeight / 3.0, color);
        return 0.1;
    }

    private double drawTitle(ReportCell cell) throws Exception {
        this.rg.drawCell(this.toc.getReport(), this.toc.getReport().getReportTables().elementAt(0), null, cell, this.curX, this.curY);
        return cell.getWidth();
    }

    private double drawSpacer(ReportCell cell) throws Exception {
        this.rg.drawCell(this.toc.getReport(), this.toc.getReport().getReportTables().elementAt(0), null, cell, this.curX, this.curY + cell.getY());
        return cell.getWidth();
    }

    private void drawPageNumber(ReportCell cell) throws Exception {
        cell.setHeight(this.entryHeight);
        this.rg.drawCell(this.toc.getReport(), this.toc.getReport().getReportTables().elementAt(0), null, cell, this.curX, this.curY);
    }
}

