/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.reportdesigner.util.ColInfo;

public class TransformQuery {
    public static String transform(String query, ColInfo[] colInfo) {
        boolean desc;
        Integer index;
        String forReadOnlyString = null;
        String sqlstr = query;
        if (query == null || colInfo == null) {
            return sqlstr;
        }
        if ((sqlstr = sqlstr.trim()).endsWith(";")) {
            sqlstr = sqlstr.substring(0, sqlstr.length() - 1);
        }
        if (sqlstr.toLowerCase().endsWith(" for read only")) {
            forReadOnlyString = sqlstr.substring(sqlstr.length() - 14);
            sqlstr = sqlstr.substring(0, sqlstr.length() - 14);
        }
        Vector orderIndices = TransformQuery.getOrderColumns(sqlstr);
        int orderbyIndex = sqlstr.toLowerCase().lastIndexOf("order by");
        if (orderbyIndex != -1) {
            sqlstr = sqlstr.substring(0, orderbyIndex);
        }
        Vector<Integer> added = new Vector<Integer>();
        for (ColInfo element : colInfo) {
            if (element == null || !element.isRowBreak()) continue;
            index = element.getMapping() + 1;
            desc = false;
            if (orderIndices.contains(-index.intValue())) {
                desc = true;
            }
            if (orderIndices.contains(element.getName())) {
                desc = true;
            }
            if (added.contains(index)) continue;
            sqlstr = added.size() == 0 ? sqlstr + " ORDER BY " + index + (desc ? " desc" : "") : sqlstr + ", " + index + (desc ? " desc" : "");
            added.addElement(index);
        }
        for (ColInfo element : colInfo) {
            if (element == null || !element.isColumnBreak()) continue;
            index = element.getMapping() + 1;
            desc = false;
            if (orderIndices.contains(-index.intValue())) {
                desc = true;
            }
            if (orderIndices.contains(element.getName())) {
                desc = true;
            }
            if (added.contains(index)) continue;
            sqlstr = added.size() == 0 ? sqlstr + " ORDER BY " + index + (desc ? " desc" : "") : sqlstr + ", " + index + (desc ? " desc" : "");
            added.addElement(index);
        }
        for (ColInfo element : colInfo) {
            if (element == null || !element.isTopN()) continue;
            index = element.getMapping() + 1;
            desc = false;
            if (orderIndices.contains(-index.intValue())) {
                desc = true;
            }
            if (orderIndices.contains(element.getName())) {
                desc = true;
            }
            if (added.contains(index)) continue;
            sqlstr = added.size() == 0 ? sqlstr + " ORDER BY " + index + (desc ? " desc" : "") : sqlstr + ", " + index + (desc ? " desc" : "");
            added.addElement(index);
        }
        for (Object orderIndex : orderIndices) {
            if (orderIndex instanceof Integer) {
                Integer index2 = (Integer)orderIndex;
                Integer unsignedIndex = Math.abs(index2);
                if (added.contains(unsignedIndex)) continue;
                String columnstring = unsignedIndex + "";
                if (index2 < 0) {
                    columnstring = columnstring + " desc";
                }
                sqlstr = added.size() == 0 ? sqlstr + " ORDER BY " + columnstring : sqlstr + ", " + columnstring;
                added.addElement(unsignedIndex);
                continue;
            }
            sqlstr = added.size() == 0 ? sqlstr + " ORDER BY " + orderIndex : sqlstr + ", " + orderIndex;
            added.addElement((Integer)orderIndex);
        }
        if (forReadOnlyString != null) {
            sqlstr = sqlstr + forReadOnlyString;
        }
        return sqlstr;
    }

    public static String transformMasterDetails(String query, ColInfo[] colInfo) {
        int orderbyIndex;
        String sqlstr = query;
        if (query == null || colInfo == null) {
            return sqlstr;
        }
        if ((sqlstr = sqlstr.trim()).lastIndexOf(59) == sqlstr.length() - 1) {
            sqlstr = sqlstr.substring(0, sqlstr.length() - 1);
        }
        if ((orderbyIndex = sqlstr.toLowerCase().lastIndexOf("order by")) != -1) {
            sqlstr = sqlstr.substring(0, orderbyIndex);
        }
        for (ColInfo element : colInfo) {
            if (element == null || !element.isPrimaryKey()) continue;
            sqlstr = sqlstr + " ORDER BY " + (element.getMapping() + 1);
        }
        return sqlstr;
    }

    public static String transformDistCol(String query, ColInfo[] colInfo) throws Exception {
        String sqlstr = query;
        if (query == null || colInfo == null) {
            return sqlstr;
        }
        if ((sqlstr = sqlstr.trim()).lastIndexOf(59) == sqlstr.length() - 1) {
            sqlstr = sqlstr.substring(0, sqlstr.length() - 1);
        }
        int fromIndex = sqlstr.toLowerCase().indexOf("from ");
        String temp = sqlstr.substring(6, fromIndex);
        int groupByIndex = sqlstr.toLowerCase().indexOf("group by ");
        int orderByIndex = sqlstr.toLowerCase().indexOf("order by ");
        String later = null;
        later = groupByIndex != -1 ? sqlstr.substring(fromIndex, groupByIndex) : (orderByIndex != -1 ? sqlstr.substring(fromIndex, orderByIndex) : sqlstr.substring(fromIndex));
        Vector<String> tokens = new Vector<String>();
        StringTokenizer token = new StringTokenizer(temp, ",");
        while (token.hasMoreTokens()) {
            tokens.addElement(token.nextToken().trim());
        }
        String former = null;
        for (ColInfo element : colInfo) {
            if (!element.isColumnBreak()) continue;
            former = "SELECT DISTINCT " + tokens.elementAt(element.getMapping()) + " ";
            break;
        }
        return former + later;
    }

    public static boolean isValidQuery(String query, ColInfo[] colInfo) {
        if (query == null || colInfo == null) {
            return false;
        }
        Vector<String> tokens = new Vector<String>();
        StringTokenizer token = new StringTokenizer(query);
        while (token.hasMoreTokens()) {
            tokens.addElement(token.nextToken().trim());
        }
        if (tokens.elementAt(1).equals("*")) {
            return false;
        }
        int rowBreakCt = 0;
        int colBreakCt = 0;
        int colBreakValueCt = 0;
        for (ColInfo element : colInfo) {
            if (element.isRowBreak()) {
                ++rowBreakCt;
                continue;
            }
            if (element.isColumnBreak()) {
                ++colBreakCt;
                continue;
            }
            if (!element.isColumnBreakValue()) continue;
            ++colBreakValueCt;
        }
        if (rowBreakCt != 1 || colBreakCt != 1 || colBreakValueCt != 1) {
            return false;
        }
        for (ColInfo element : colInfo) {
            if (!element.isRowBreak() || element.getMapping() == 0) continue;
            return false;
        }
        int groupByIndex = query.toLowerCase().indexOf("group by ");
        int orderByIndex = query.toLowerCase().indexOf("order by ");
        if (groupByIndex != -1) {
            String temp2;
            String temp;
            Vector<String> groupByTokens = new Vector<String>();
            String groupByStr = null;
            if (orderByIndex != -1 && orderByIndex > groupByIndex) {
                groupByStr = query.substring(groupByIndex + 9, orderByIndex);
            } else {
                groupByStr = query.substring(groupByIndex + 9);
                if (groupByStr.lastIndexOf(59) == groupByStr.length() - 1) {
                    groupByStr = groupByStr.substring(0, groupByStr.length() - 1);
                }
            }
            StringTokenizer groupByToken = new StringTokenizer(groupByStr.trim(), ",");
            while (groupByToken.hasMoreTokens()) {
                groupByTokens.addElement(groupByToken.nextToken().trim());
            }
            int fromIndex = query.toLowerCase().indexOf("from ");
            String former = query.substring(6, fromIndex);
            tokens = new Vector();
            token = new StringTokenizer(former, ",");
            while (token.hasMoreTokens()) {
                tokens.addElement(token.nextToken().trim());
            }
            int index = 0;
            for (ColInfo element : colInfo) {
                if (!element.isRowBreak()) continue;
                temp = (String)groupByTokens.elementAt(index);
                if (!temp.equals(temp2 = (String)tokens.elementAt(element.getMapping()))) {
                    return false;
                }
                ++index;
            }
            for (ColInfo element : colInfo) {
                if (!element.isColumnBreak()) continue;
                temp = (String)groupByTokens.elementAt(index);
                if (!temp.equals(temp2 = (String)tokens.elementAt(element.getMapping()))) {
                    return false;
                }
                ++index;
            }
        }
        return true;
    }

    public static String transformCrossTab(String query, ColInfo[] colInfo) throws Exception {
        int i;
        String sqlstr = query;
        if (query == null || colInfo == null) {
            return sqlstr;
        }
        if ((sqlstr = sqlstr.trim()).lastIndexOf(59) == sqlstr.length() - 1) {
            sqlstr = sqlstr.substring(0, sqlstr.length() - 1);
        }
        if (TransformQuery.isValidQuery(query, colInfo)) {
            int groupByIndex = sqlstr.toLowerCase().indexOf("group by ");
            int orderByIndex = sqlstr.toLowerCase().indexOf("order by ");
            if (groupByIndex != -1 && orderByIndex != -1) {
                String str1 = sqlstr.substring(groupByIndex + 9, orderByIndex).trim();
                String str2 = sqlstr.substring(0, orderByIndex);
                return str2 + " ORDER BY " + str1;
            }
            if (groupByIndex != -1) {
                String str1 = sqlstr.substring(groupByIndex + 9).trim();
                return sqlstr + " ORDER BY " + str1;
            }
            if (orderByIndex != -1) {
                sqlstr = sqlstr.substring(0, orderByIndex);
            }
        }
        int fromIndex = sqlstr.toLowerCase().indexOf("from ");
        String former = sqlstr.substring(6, fromIndex);
        String later = sqlstr.substring(fromIndex);
        Vector<String> tokens = new Vector<String>();
        StringTokenizer token = new StringTokenizer(former, ",");
        while (token.hasMoreTokens()) {
            tokens.addElement(token.nextToken().trim());
        }
        for (ColInfo element : colInfo) {
            if (element.isColumnBreak() || element.isRowBreak()) continue;
            String str = (String)tokens.elementAt(element.getMapping());
            if (str.toUpperCase().indexOf(" AS ") != -1) {
                int aliasIndex = str.toUpperCase().indexOf("AS");
                String str1 = str.substring(0, aliasIndex) + " ";
                String str2 = str.substring(aliasIndex);
                String newStr = TransformQuery.transformAggr(element.getAggregation(), str1) + str2;
                tokens.setElementAt(newStr, element.getMapping());
                continue;
            }
            String newStr = TransformQuery.transformAggr(element.getAggregation(), str);
            tokens.setElementAt(newStr, element.getMapping());
        }
        for (int i2 = 0; i2 < tokens.size(); ++i2) {
            boolean flag = false;
            for (ColInfo element : colInfo) {
                if (i2 != element.getMapping()) continue;
                flag = true;
            }
            if (flag) continue;
            String str = (String)tokens.elementAt(i2);
            if (str.toUpperCase().indexOf(" AS ") != -1) {
                int aliasIndex = str.toUpperCase().indexOf("AS");
                String str1 = str.substring(0, aliasIndex) + " ";
                String str2 = str.substring(aliasIndex);
                String newStr = TransformQuery.transformAggr((short)4, str1) + str2;
                tokens.setElementAt(newStr, i2);
                continue;
            }
            String newStr = TransformQuery.transformAggr((short)4, str);
            tokens.setElementAt(newStr, i2);
        }
        Vector groupBy = new Vector();
        for (ColInfo element : colInfo) {
            if (!element.isRowBreak()) continue;
            groupBy.addElement(tokens.elementAt(element.getMapping()));
        }
        for (ColInfo element : colInfo) {
            if (!element.isColumnBreak()) continue;
            groupBy.addElement(tokens.elementAt(element.getMapping()));
        }
        String sql = "SELECT ";
        int size = tokens.size();
        for (i = 0; i < size - 1; ++i) {
            sql = sql + tokens.elementAt(i) + ", ";
        }
        sql = sql + tokens.elementAt(size - 1) + " ";
        sql = sql + later + " GROUP BY ";
        size = groupBy.size();
        for (i = 0; i < size - 1; ++i) {
            sql = sql + groupBy.elementAt(i) + ", ";
        }
        sql = sql + groupBy.elementAt(size - 1) + " ORDER BY ";
        for (i = 0; i < size - 1; ++i) {
            sql = sql + groupBy.elementAt(i) + ", ";
        }
        sql = sql + groupBy.elementAt(size - 1);
        return sql;
    }

    private static String transformAggr(short aggr, String str) {
        String temp = null;
        switch (aggr) {
            case 1: {
                temp = "SUM(" + str + ")";
                break;
            }
            case 2: {
                temp = "MAX(" + str + ")";
                break;
            }
            case 3: {
                temp = "MIN(" + str + ")";
                break;
            }
            case 4: {
                temp = "COUNT(" + str + ")";
                break;
            }
            case 6: {
                temp = "FIRST(" + str + ")";
                break;
            }
            case 7: {
                temp = "LAST(" + str + ")";
                break;
            }
            case 5: {
                temp = "AVG(" + str + ")";
                break;
            }
            case 8: {
                temp = "SUMSQUARE(" + str + ")";
                break;
            }
            case 9: {
                temp = "VARIANCE(" + str + ")";
                break;
            }
            case 10: {
                temp = "STDDEV(" + str + ")";
                break;
            }
            case 11: {
                temp = "COUNTDISTINCT(" + str + ")";
            }
        }
        return temp;
    }

    private static List<String> tokenizeSelectClause(String select) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(select, ",");
        String tmp = "";
        while (tokenizer.hasMoreTokens()) {
            int endBracketCount;
            String token = tmp + (tmp.length() > 0 ? "," : "") + tokenizer.nextToken();
            int startBracketCount = token.length() - token.replace("(", "").length();
            if (startBracketCount > (endBracketCount = token.length() - token.replace(")", "").length())) {
                tmp = token;
                continue;
            }
            tokens.add(token);
            tmp = "";
        }
        return tokens;
    }

    private static Vector getOrderColumns(String query) {
        if (query == null || query.toLowerCase().indexOf("order by") < 0 || query.toLowerCase().indexOf("select") < 0 || query.toLowerCase().indexOf("from") < 0 || query.toLowerCase().indexOf("from") <= query.toLowerCase().indexOf("select")) {
            return new Vector();
        }
        Vector<String> orderby = new Vector<String>();
        String orderclause = query.substring(query.toLowerCase().indexOf("order by") + 8);
        if (orderclause.contains("order by")) {
            return new Vector();
        }
        StringTokenizer tokenizer = new StringTokenizer(orderclause, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ((token = token.trim()).endsWith(";")) {
                token = token.substring(0, token.length() - 1);
            }
            orderby.addElement(token);
        }
        Vector<String> select = new Vector<String>();
        Vector<String> selectAlias = new Vector<String>();
        String selectclause = query.substring(query.toLowerCase().indexOf("select") + 6, query.toLowerCase().indexOf("from")).trim();
        if (selectclause.toLowerCase().startsWith("distinct ")) {
            selectclause = selectclause.substring(9, selectclause.length());
        }
        List<String> selectLines = TransformQuery.tokenizeSelectClause(selectclause);
        for (String token : selectLines) {
            String alias = "";
            if (token.toLowerCase().lastIndexOf(" as ") >= 0) {
                alias = token.substring(token.toLowerCase().lastIndexOf(" as ") + 4, token.length());
                token = token.substring(0, token.toLowerCase().lastIndexOf(" as "));
            }
            token = token.trim();
            select.addElement(token);
            selectAlias.addElement(alias);
        }
        if (select.size() == 0) {
            return new Vector();
        }
        Vector<Object> ret = new Vector<Object>();
        for (int i = 0; i < orderby.size(); ++i) {
            if ("*".equals(select.elementAt(0))) {
                String ordercolumn = (String)orderby.elementAt(i);
                if (!ordercolumn.toLowerCase().endsWith(" desc")) continue;
                ret.addElement(ordercolumn.substring(0, ordercolumn.length() - 5));
                continue;
            }
            boolean foundIt = false;
            String ordercolumn = (String)orderby.elementAt(i);
            boolean desc = false;
            if (ordercolumn.toLowerCase().endsWith(" asc")) {
                ordercolumn = ordercolumn.substring(0, ordercolumn.length() - 4);
            }
            if (ordercolumn.toLowerCase().endsWith(" desc")) {
                ordercolumn = ordercolumn.substring(0, ordercolumn.length() - 5);
                desc = true;
            }
            for (int j = 0; j < select.size(); ++j) {
                Integer neg_index;
                Integer index;
                if (ordercolumn.equalsIgnoreCase((String)select.elementAt(j))) {
                    index = j + 1;
                    neg_index = -(j + 1);
                    if (!ret.contains(index) && !ret.contains(neg_index)) {
                        foundIt = true;
                        if (desc) {
                            ret.addElement(neg_index);
                            break;
                        }
                        ret.addElement(index);
                        break;
                    }
                }
                if (!ordercolumn.equalsIgnoreCase((String)selectAlias.elementAt(j))) continue;
                index = j + 1;
                neg_index = -(j + 1);
                if (ret.contains(index) || ret.contains(neg_index)) continue;
                foundIt = true;
                if (desc) {
                    ret.addElement(neg_index);
                    break;
                }
                ret.addElement(index);
                break;
            }
            if (foundIt) continue;
            try {
                int oCol = Integer.parseInt(ordercolumn);
                if (desc) {
                    ret.addElement(oCol * -1);
                }
                ret.addElement(oCol);
                continue;
            }
            catch (NumberFormatException ex) {
                if (desc) {
                    ret.addElement(ordercolumn + " desc");
                    continue;
                }
                ret.addElement(ordercolumn);
            }
        }
        return ret;
    }
}

