/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Date;
import java.util.Vector;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Constant;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Report;

public class Variable
extends Operand {
    String name;
    Operand expression;
    Object value;
    Object initValue;

    public Variable(String name) {
        this.name = name;
    }

    public Variable(int datatype, String name) {
        this.name = name;
        this.datatype = datatype;
        switch (datatype) {
            case 0: {
                this.value = 0.0;
                this.initValue = 0.0;
                break;
            }
            case 1: {
                this.value = "";
                this.initValue = "";
                break;
            }
            case 2: {
                this.value = Boolean.FALSE;
                this.initValue = Boolean.FALSE;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.value = new Date();
                this.initValue = new Date();
                break;
            }
            default: {
                this.value = null;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Operand getExpression() {
        return this.expression;
    }

    public void setExpression(Operand op) {
        this.expression = op;
        if (op instanceof Constant) {
            this.value = ((Constant)op).getValue();
        }
    }

    public void setInitValue(Operand op) {
        if (op instanceof Constant) {
            this.initValue = ((Constant)op).getValue();
        }
    }

    public void init() {
        if (this.initValue != null) {
            this.value = this.initValue;
        }
    }

    public void calculate(ReportTable table, int row, int page, int section, int totalPages, int totalSections, Report report, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        this.value = this.expression.getValue(table, row, page, section, totalPages, totalSections, report, cell, dataobj, secondRound);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound) throws Exception {
        return this.value;
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol) throws Exception {
        return this.value;
    }

    @Override
    public Object getValue(ReportTable table, int index, int page, int section, int totalpages, int totalsections, Report r, ReportCell cell, Object dataobj, boolean secondRound, Vector preAggCol, Vector resultCol, ColData[] colData) throws Exception {
        return this.value;
    }
}

