/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.util.Vector;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.report.ERStatement;
import quadbase.reportdesigner.report.Operand;
import quadbase.reportdesigner.report.Script;

public class WhileStatement
implements ERStatement {
    Operand condition;
    Vector doStmts;

    public WhileStatement(Operand cnd, Vector doStmts) {
        this.condition = cnd;
        this.doStmts = doStmts;
    }

    public Operand getCondition() {
        return this.condition;
    }

    public void setCondition(Operand cnd) {
        this.condition = cnd;
    }

    public Vector getDoStmts() {
        return this.doStmts;
    }

    public void setDoStmts(Vector doStmts) {
        this.doStmts = doStmts;
    }

    @Override
    public void execute(Script script) throws Exception {
        Object object = this.condition.getValue(script.table, script.index, script.page, script.section, script.totalPages, script.totalSections, script.report, script.cell, script.dataobj, true);
        if (this.condition.getDatatype(script.report) != 2) {
            throw new Exception(LanguageEncoder.getText("if condition has to have a boolean value"));
        }
        while (((Boolean)object).booleanValue()) {
            for (int i = 0; i < this.doStmts.size(); ++i) {
                ((ERStatement)this.doStmts.elementAt(i)).execute(script);
            }
            object = this.condition.getValue(script.table, script.index, script.page, script.section, script.totalPages, script.totalSections, script.report, script.cell, script.dataobj, true);
        }
    }

    @Override
    public void testExecute(Script script) throws Exception {
        this.condition.getValue(script.table, script.index, script.page, script.section, script.totalPages, script.totalSections, script.report, script.cell, script.dataobj, true);
        if (this.condition.getDatatype(script.report) != 2) {
            throw new Exception(LanguageEncoder.getText("if condition has to have a boolean value"));
        }
        if (this.doStmts != null) {
            for (int i = 0; i < this.doStmts.size(); ++i) {
                ((ERStatement)this.doStmts.elementAt(i)).execute(script);
            }
        }
    }

    @Override
    public void setThisDataType(int datatype) {
        this.condition.setThisDataType(datatype);
        for (int i = 0; this.doStmts != null && i < this.doStmts.size(); ++i) {
            ((ERStatement)this.doStmts.elementAt(i)).setThisDataType(datatype);
        }
    }
}

