/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.util.internal.FileInMemTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.report.IOUtil2;

public class WriteDataFile {
    private static final Logger LOGGER = Logger.getLogger(WriteDataFile.class.getName());
    boolean createHtml = false;
    boolean useSwing = false;
    boolean usePageViewer = false;
    boolean useXML = false;
    private String securityLevelForHTML = null;
    private static Vector<String> createdFileList = null;
    private static boolean enableCleanupFileListFromDesigner = false;
    private static boolean createFileListForPak = false;

    public void output(FileInMemTable subFilesTable, byte[] barray, String filename) throws Exception {
        this.output(subFilesTable, barray, filename, false);
    }

    public void output(FileInMemTable subFilesTable, byte[] barray, String filename, boolean isPageViewer) throws Exception {
        String fPath;
        LOGGER.finest("Write Data File output - " + filename + " subFilesTable is not  null = " + (subFilesTable != null));
        if (subFilesTable != null) {
            LOGGER.finest("Write Data File output File in Mem enabled - " + subFilesTable.isFileInMemEnabled());
        }
        if (enableCleanupFileListFromDesigner && !createdFileList.contains(fPath = ServerMessage.getPath(filename)) && createFileListForPak) {
            createdFileList.add(fPath);
        }
        filename = filename.replace('\\', '/');
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer && !isPageViewer) {
            if (filename.startsWith("http://") || filename.startsWith("https://")) {
                this.sendToServer(barray, filename, false);
            } else {
                this.sendToServer(barray, filename, (filename = filename.replace('\\', '/')).startsWith("/") || filename.indexOf(":/") >= 0);
            }
            return;
        }
        if (filename.startsWith("http://") || filename.startsWith("https://")) {
            throw new IOException("Cannot write to HTTP URL :" + filename);
        }
        QbUtil.checkExtensionsBlacklist(filename);
        FileOutputStream fstream = IOUtil.createFileOutputStream(filename);
        DataOutputStream out = new DataOutputStream(fstream);
        out.write(barray, 0, barray.length);
        fstream.flush();
        fstream.close();
    }

    void generateHtmlFile(boolean createHtml, boolean useSwing, boolean usePageViewer, boolean useXML, String securityLevel) {
        this.createHtml = createHtml;
        this.useSwing = useSwing;
        this.useXML = useXML;
        this.securityLevelForHTML = securityLevel;
        this.usePageViewer = usePageViewer;
    }

    private void sendToServer(byte[] barray, String filename, boolean absolutePath) throws Exception {
        LOGGER.finest("Write data file: send to server: " + filename);
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(1076);
        dout.writeBoolean(false);
        dout.writeInt(barray.length);
        IOUtil.writeString(dout, filename);
        dout.writeBoolean(absolutePath);
        dout.writeBoolean(this.createHtml);
        dout.writeBoolean(this.useSwing);
        dout.writeBoolean(this.usePageViewer);
        dout.writeBoolean(this.useXML);
        IOUtil.writeStr(dout, this.securityLevelForHTML);
        IConnection socket = null;
        try {
            try {
                socket = ServerMessage.createConnection();
                byte[] array = bstream.toByteArray();
                socket.setContentLength(array.length + barray.length);
                OutputStream out = socket.getOutputStream();
                out.write(array);
                out.write(barray);
                out.flush();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to connect to server", ex);
                if (socket != null) {
                    socket.close();
                }
                throw new IOException("Failed to connect to server !");
            }
            DataInputStream din = new DataInputStream(socket.getInputStream());
            String errMessage = IOUtil2.getErrorString(din.readInt());
            String reason = IOUtil.readString(din, true);
            socket.close();
            if (errMessage != null) {
                throw new IOException(errMessage + "\n" + reason);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to read data", ex);
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Can't close socket", ex2);
            }
            throw ex;
        }
    }
}

