/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.WriteDataFile;
import quadbase.reportdesigner.report.XMLReport;
import quadbase.reportdesigner.report.XMLSubReport;
import quadbase.util.internal.PNGJimiEncoder;

public class XMLRTFObject
extends XMLSubReport {
    private static final Logger LOGGER = Logger.getLogger(XMLRTFObject.class.getName());
    private Vector lines = null;
    private ReportRTFObject rtfObject = null;

    public XMLRTFObject(ReportRTFObject rtfObject, Vector l, double x, double y, double reportWidth, double reportHeight, XMLReport parent) {
        super(parent.report, x, y, reportWidth, reportHeight, parent);
        if (reportHeight < 0.0) {
            this.pageHeight = parent.pageHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
        }
        this.rtfObject = rtfObject;
        this.lines = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String dhtmlText = "";
            int textHeight = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                Object[] seg;
                int j;
                Vector segments = (Vector)this.lines.elementAt(i);
                int ascent = 0;
                int descent = 0;
                for (j = 0; j < segments.size(); ++j) {
                    seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        int iHeight = (Integer)seg[2];
                        if (iHeight <= ascent) continue;
                        ascent = iHeight;
                        continue;
                    }
                    FontMetrics fontMetrics = (FontMetrics)seg[1];
                    if (fontMetrics.getMaxAscent() <= ascent) continue;
                    ascent = fontMetrics.getMaxAscent();
                    descent = fontMetrics.getMaxDescent();
                }
                if (QbUtil.toPixel_export(this.pageHeight - this.elementYPos) < ascent + descent + textHeight) {
                    this.writeRichText(dhtmlText);
                    this.elementYPos += QbUtil.toInch_export(textHeight);
                    this.pageBreak(null);
                    dhtmlText = "";
                    textHeight = 0;
                }
                textHeight = textHeight + ascent + descent;
                for (j = 0; j < segments.size(); ++j) {
                    seg = (Object[])segments.elementAt(j);
                    if (seg[0] != null && seg[0] instanceof Image) {
                        int iWidth = (Integer)seg[1];
                        int iHeight = (Integer)seg[2];
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        if (IOUtil.isJimiIncluded()) {
                            PNGJimiEncoder.createPNGImage((Image)seg[0], bout, 0);
                            byte[] barray = bout.toByteArray();
                            String imgPath = this.rtfObject.getSavedFileLocation();
                            String imgURL = this.rtfObject.getSavedFileURL();
                            if (imgPath == null || imgURL == null) {
                                imgPath = this.imageName + this.imageCount;
                                imgURL = ChartObject.getChartName(this.imageName + this.imageCount, 10);
                            } else {
                                imgPath = imgPath + this.imageCount;
                                imgURL = ChartObject.addExtension(imgURL + this.imageCount, 10);
                            }
                            ++this.imageCount;
                            new WriteDataFile().output(null, barray, imgPath + ".png");
                            dhtmlText = dhtmlText + "<img src=\"" + imgURL + "\" width=" + iWidth + " height=" + iHeight + ">";
                        }
                        bout.close();
                        if (j != segments.size() - 1 || i >= this.lines.size() - 1) continue;
                        dhtmlText = dhtmlText + "<BR>";
                        continue;
                    }
                    FontMetrics fontMetrics = (FontMetrics)seg[1];
                    String text = (String)seg[0];
                    text = QbUtil.replace(text, "\n", "<BR>");
                    text = QbUtil.replace(text, "  ", " &nbsp;");
                    Font font = fontMetrics.getFont();
                    dhtmlText = dhtmlText + "<font STYLE=\"";
                    dhtmlText = dhtmlText + "color:" + XMLRTFObject.colorToHTML((Color)seg[2]) + "; ";
                    dhtmlText = dhtmlText + "font-family:" + font.getName() + "; ";
                    dhtmlText = dhtmlText + "font-size:" + font.getSize() + "px; ";
                    dhtmlText = dhtmlText + "font-weight:";
                    dhtmlText = font.isBold() ? dhtmlText + "bold; " : dhtmlText + "normal; ";
                    dhtmlText = dhtmlText + "font-style:";
                    dhtmlText = font.isItalic() ? dhtmlText + "italic; " : dhtmlText + "normal; ";
                    if (((Boolean)seg[3]).booleanValue()) {
                        dhtmlText = dhtmlText + "text-decoration:underline";
                    }
                    dhtmlText = dhtmlText + "\">" + text;
                    if (j == segments.size() - 1 && i < this.lines.size() - 1) {
                        dhtmlText = dhtmlText + "<BR>";
                    }
                    dhtmlText = dhtmlText + "</font>";
                }
            }
            if (dhtmlText.length() > 0) {
                this.writeRichText(dhtmlText);
            }
            this.elementYPos += QbUtil.toInch_export(textHeight);
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run XMLRTFObject", ex);
            } else {
                LOGGER.log(Level.FINEST, "XMLRTFObject: page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run XMLRTFObject", err);
        }
        finally {
            Object LOCK;
            try {
                this.closeElementTag("RICHTEXT");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to close RICHTEXT element tag", ex);
            }
            this.finish = true;
            Object object = LOCK = this.getLOCK();
            synchronized (object) {
                LOCK.notify();
            }
        }
    }

    private void writeRichText(String dhtmlText) throws Exception {
        this.out.write(XMLUtil.encodeCDATA(dhtmlText));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.checkVisibility) {
            throw new Exception("Subreport page break.");
        }
        if (this.report.isExportToMultiPages()) {
            Object LOCK;
            try {
                this.closeElementTag("RICHTEXT");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to close RICHTEXT element tag", ex);
            }
            ++this.currentPageNumber;
            Object object = LOCK = this.getLOCK();
            synchronized (object) {
                LOCK.notify();
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ReportCell cell = new ReportCell();
            cell.setWidth(this.maxWidthOfSections);
            String[] names = new String[]{"X", "Y", "Width"};
            try {
                this.openElementTag("RICHTEXT", cell, null, 0, names);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to open RICHTEXT element tag", ex);
            }
            this.elementXPos = 0.0;
        }
    }
}

