/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.ReportElements.ColumnBreakColumn;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTableElement;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.report.DHTMLReport;
import quadbase.reportdesigner.report.DrillDownNode;
import quadbase.reportdesigner.report.ISubReportExport;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.XMLRTFObject;
import quadbase.reportdesigner.report.XMLSubReport;

public class XMLReport
extends DHTMLReport {
    private static final Logger LOGGER = Logger.getLogger(XMLReport.class.getName());
    public static final String REPORT = "REPORT";
    public static final String SECTION = "SECTION";
    public static final String TABLE = "TABLE";
    public static final String CELL = "CELL";
    public static final String BARCODE = "BARCODE";
    public static final String IMAGE = "IMAGE";
    public static final String CHART = "CHART";
    public static final String LINE = "LINE";
    public static final String GRID = "GRID";
    public static final String RICHTEXT = "RICHTEXT";
    public static final String NAME = "Name";
    public static final String ID = "ID";
    public static final String FONTCOLOR = "FontColor";
    public static final String FONTTYPE = "FontType";
    public static final String FONTSTYLE = "FontStyle";
    public static final String FONTSIZE = "FontSize";
    public static final String BACKGROUNDCOLOR = "BackgroundColor";
    public static final String BORDERCOLOR = "BorderColor";
    public static final String BORDERTHICKNESS = "BorderThickness";
    public static final String ALIGNMENT = "Alignment";
    public static final String VALIGNMENT = "VerticalAlignment";
    public static final String LINK = "Link";
    public static final String HINT = "Hint";
    public static final String TARGET = "Target";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    public static final String X = "X";
    public static final String Y = "Y";
    public static final String WORDWRAP = "WordWrap";
    public static final String TOPBORDERVISIBLE = "TopBorderVisible";
    public static final String BOTTOMBORDERVISIBLE = "BottomBorderVisible";
    public static final String THICKNESS = "Thickness";
    public static final String COLOR = "Color";
    public static final String LENGTH = "Length";
    public static final String ORIENTATION = "Orientation";
    public static final String LINESTYLE = "LineStyle";
    public static final String ROW = "Row";
    public static final String PAGELINK = "PAGELINK";
    public static final String FIRST = "FIRST";
    public static final String NEXT = "NEXT";
    public static final String PREVIOUS = "PREVIOUS";
    public static final String LAST = "LAST";
    public static final String CURRENTPAGE = "CURRENTPAGE";
    public static final String TOTALPAGES = "TOTALPAGES";
    protected ReportTable inTable = null;

    public XMLReport(Report report) {
        super(report);
    }

    public XMLReport(Report report, boolean skipFormatTable) {
        super(report, skipFormatTable);
    }

    public boolean exportXML(OutputStream outstream) throws Exception {
        return this.exportDHTML(outstream, null);
    }

    public boolean exportXML(OutputStream outstream, String filename) throws Exception {
        return this.exportDHTML(outstream, filename);
    }

    @Override
    protected int openDivTag(ReportElement elt) {
        return 0;
    }

    @Override
    protected void writeReportContainerDiv(boolean open) throws Exception {
    }

    @Override
    protected String writeCloseDivTag() {
        return "";
    }

    @Override
    protected void closeSectionTag() throws Exception {
        this.closeElementTag(SECTION);
    }

    @Override
    protected void closeRowTag() throws Exception {
        this.closeElementTag(ROW);
    }

    @Override
    protected void writeSectionBgColor(ReportElement section) throws IOException {
    }

    @Override
    protected void writeSectionTag(ReportElement section) throws IOException {
        try {
            if (section instanceof ReportSection) {
                String[] names = new String[]{NAME, ID, BACKGROUNDCOLOR, BORDERTHICKNESS, BORDERCOLOR, HEIGHT};
                this.openElementTag(SECTION, section, null, 0, names);
            } else {
                String[] names = new String[]{HEIGHT};
                this.openElementTag(ROW, section, null, 0, names);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to write section tag", ex);
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        if (this.inTable != null) {
            this.closeElementTag(TABLE);
        }
        super.pageBreak(section);
        if (this.inTable != null) {
            String[] names = new String[]{ID, BACKGROUNDCOLOR, ROW};
            this.openElementTag(TABLE, this.inTable, null, 0, names);
        }
    }

    @Override
    protected void writeCells(ReportTable tbl) throws Exception {
        if (!tbl.isVisible()) {
            return;
        }
        this.inTable = tbl;
        String[] names = new String[]{ID, BACKGROUNDCOLOR, ROW};
        this.openElementTag(TABLE, tbl, null, 0, names);
        super.writeCells(tbl);
        this.closeElementTag(TABLE);
        this.inTable = null;
    }

    private ReportSection createEvalSection(String text) {
        ReportSection rs = new ReportSection("EVAL_STMT");
        rs.setText("Evaluation Statement");
        ReportCell cell = new ReportCell(text);
        cell.setWidth(this.report.getPageWidth());
        cell.setFontColor(IOUtil.getRandomColor());
        rs.addData(cell);
        return rs;
    }

    @Override
    protected String writeBarcode(ReportElement elt) throws IOException, Exception {
        int index;
        String imgURL = super.writeBarcode(elt);
        if (imgURL != null && (index = imgURL.indexOf("SRC=\"")) >= 0) {
            imgURL = imgURL.substring(index);
            index = imgURL.indexOf(34);
            imgURL = imgURL.substring(0, index);
        }
        String[] names = new String[]{ID, X, Y, WIDTH, HEIGHT, BACKGROUNDCOLOR, BORDERTHICKNESS, BORDERCOLOR, FONTSIZE, FONTTYPE, FONTSTYLE, FONTCOLOR, ALIGNMENT, VALIGNMENT, LINK, HINT, TARGET};
        this.openElementTag(BARCODE, elt, null, 0, names);
        this.writeCDATA(imgURL);
        this.closeElementTag(BARCODE);
        return "";
    }

    @Override
    protected void writeText(ReportElement elt, ReportTable tbl, int row) throws Exception {
        this.writeText(elt, tbl, row, -1);
    }

    @Override
    protected void writeText(ReportElement elt, ReportTable tbl, int row, int eltW) throws Exception {
        Font font = elt.getRefFont();
        String text = elt.getText();
        if (this.reportUI.report.getStringCustomizer() != null) {
            text = this.reportUI.report.getStringCustomizer().encodeString(text);
        }
        FontMetrics fm = this.getFontMetrics(font);
        String[] strList = ReportGraphics.tokenizer(text, fm, elt.getWidthOfElement(), elt.isNoWrap());
        String str = "";
        for (String element : strList) {
            str = str + element + "\n";
        }
        String[] names = new String[]{ID, X, Y, WIDTH, HEIGHT, BACKGROUNDCOLOR, BORDERTHICKNESS, BORDERCOLOR, FONTSIZE, FONTTYPE, FONTSTYLE, FONTCOLOR, ALIGNMENT, VALIGNMENT, LINK, HINT, TARGET};
        this.openElementTag(CELL, elt, tbl, row, names);
        this.out.write(XMLReport.encodeXML(str));
        this.closeElementTag(CELL);
    }

    @Override
    protected String writeImage(ReportImage image, ReportTable tbl, int row) throws Exception {
        int index;
        String imgURL = super.writeImage(image, tbl, row);
        if (imgURL != null && (index = imgURL.indexOf("SRC=\"")) >= 0) {
            imgURL = imgURL.substring(index);
            index = imgURL.indexOf(34);
            imgURL = imgURL.substring(0, index);
        }
        String[] names = new String[]{ID, X, Y, WIDTH, HEIGHT, BACKGROUNDCOLOR, BORDERTHICKNESS, BORDERCOLOR, ALIGNMENT, VALIGNMENT, LINK, HINT, TARGET};
        this.openElementTag(IMAGE, image, tbl, row, names);
        this.writeCDATA(imgURL);
        this.closeElementTag(IMAGE);
        return "";
    }

    @Override
    protected String writeChart(ReportChartObject chart, ReportTable tbl, ReportCell[] cells, int row) {
        try {
            int index;
            String imgURL = super.writeChart(chart, tbl, cells, row);
            if (imgURL != null && (index = imgURL.indexOf("SRC=\"")) >= 0) {
                imgURL = imgURL.substring(index);
                index = imgURL.indexOf(34);
                imgURL = imgURL.substring(0, index);
            }
            String[] names = new String[]{ID, X, Y, WIDTH, HEIGHT, BACKGROUNDCOLOR, BORDERTHICKNESS, BORDERCOLOR, ALIGNMENT, VALIGNMENT, LINK, HINT, TARGET};
            this.openElementTag(CHART, chart, tbl, row, names);
            this.writeCDATA(imgURL);
            this.closeElementTag(CHART);
            return "";
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to write chart", e);
            return "";
        }
    }

    @Override
    protected void writeReportLine(ReportLine line, ReportTableElement panel) {
        try {
            String[] names = new String[]{ID, X, Y, THICKNESS, LENGTH, LINESTYLE, COLOR, ORIENTATION};
            this.openElementTag(LINE, line, panel, 0, names);
            this.closeElementTag(LINE);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write report line", ex);
        }
    }

    @Override
    protected void writeReportGrid(ReportGrid grid, ReportTableElement panel) {
        try {
            String[] names = new String[]{ID, X, Y, WIDTH, HEIGHT, BORDERTHICKNESS, BORDERCOLOR, LINESTYLE, TOPBORDERVISIBLE, BOTTOMBORDERVISIBLE};
            this.openElementTag(GRID, grid, panel, 0, names);
            this.closeElementTag(GRID);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write report grid", ex);
        }
    }

    @Override
    protected void writeHeadTag() throws IOException {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            this.out.write("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>\n");
            String bgcolor = Color.white.getRGB() + "";
            if (this.report.getBackgroundColor() != null) {
                bgcolor = this.report.getBackgroundColor().getRGB() + "";
            }
            this.out.write("<REPORT name=\"" + XMLReport.encodeXML(this.report.getName()) + "\" TopMargin=\"" + QbUtil.toPixel_export(this.topMargin) + "\" BottomMargin=\"" + QbUtil.toPixel_export(this.bottomMargin) + "\" LeftMargin=\"" + QbUtil.toPixel_export(this.leftMargin) + "\" RightMargin=\"" + QbUtil.toPixel_export(this.rightMargin) + "\" " + WIDTH + "=\"" + QbUtil.toPixel_export(this.maxWidthOfSections) + "\" BackgroundColor=\"" + bgcolor + "\">");
        }
    }

    @Override
    protected void writeTailTag() throws IOException {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage) {
            this.out.write("</REPORT>");
        }
    }

    @Override
    protected void writeWaterMark(String text, boolean top) throws Exception {
        if (ServerMessage.isEvalVersion()) {
            double old_elementYPos = this.elementYPos;
            this.writeSection(this.createEvalSection("Evaluation copy by Quadbase Systems Inc."), this.hTable, false);
            this.elementYPos = old_elementYPos;
        }
    }

    @Override
    public void writeLinks(boolean top) throws IOException {
        if (!this.checkTotalPageNumber && !this.checkFitGroupOnPage && top) {
            try {
                this.linksHeight = 0.0;
                this.openElementTag(PAGELINK, null, null, 0, null);
                this.openElementTag(FIRST, null, null, 0, null);
                this.out.write(XMLReport.encodeXML(this.getRelativeFileName(this.originalFileName)));
                this.closeElementTag(FIRST);
                String prevString = null;
                String nextString = null;
                if (this.currentPageNumber > 2) {
                    prevString = this.getRelativeFileName(XMLReport.getFileName(this.prefix, this.currentPageNumber - 1, this.getExtension()));
                } else if (this.currentPageNumber == 2) {
                    prevString = this.getRelativeFileName(this.originalFileName);
                }
                if (this.currentPageNumber < this.totalPageNumber - 1) {
                    nextString = this.getRelativeFileName(XMLReport.getFileName(this.prefix, this.currentPageNumber + 1, this.getExtension()));
                } else if (this.currentPageNumber == this.totalPageNumber - 1) {
                    nextString = this.getRelativeFileName(this.lastFileName);
                }
                this.openElementTag(PREVIOUS, null, null, 0, null);
                if (prevString != null) {
                    this.out.write(XMLReport.encodeXML(prevString));
                }
                this.closeElementTag(PREVIOUS);
                this.openElementTag(NEXT, null, null, 0, null);
                if (nextString != null) {
                    this.out.write(XMLReport.encodeXML(nextString));
                }
                this.closeElementTag(NEXT);
                this.openElementTag(LAST, null, null, 0, null);
                if (this.totalPageNumber == 1) {
                    this.out.write(XMLReport.encodeXML(this.getRelativeFileName(this.originalFileName)));
                } else {
                    this.out.write(XMLReport.encodeXML(this.getRelativeFileName(this.lastFileName)));
                }
                this.closeElementTag(LAST);
                this.openElementTag(CURRENTPAGE, null, null, 0, null);
                this.out.write(this.currentPageNumber + "");
                this.closeElementTag(CURRENTPAGE);
                this.openElementTag(TOTALPAGES, null, null, 0, null);
                this.out.write(this.totalPageNumber + "");
                this.closeElementTag(TOTALPAGES);
                this.closeElementTag(PAGELINK);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to write links", ex);
                throw new IOException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISubReportExport writeSubReport(SubReportObject subReport, ReportTable tbl) {
        try {
            Object LOCK;
            ReportElement securityLevel = subReport.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Report sreport = null;
            if (subReport.hasUsableReport()) {
                sreport = subReport.getSubReport().getReportInfo();
                if (sreport.getQueryParams().size() != 0) {
                    sreport = subReport.reloadReportWithParameters(sreport, this.report, tbl);
                } else if (sreport.dbInfo.getDriverName() != null) {
                    sreport = subReport.loadReport(this.report, tbl);
                } else {
                    try {
                        Report temp = ReloadReport.reloadData(new Report(sreport), false);
                        if (temp != null) {
                            sreport = temp;
                        }
                    }
                    catch (Exception ex) {
                        sreport.getReportTables().elementAt(0).setVisible(false);
                        subReport.setHeight(0.0);
                        this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                    }
                }
            } else {
                sreport = subReport.loadReport(this.report, tbl);
            }
            double pageHeight = -1.0;
            if (!subReport.isResizeToFitContent()) {
                pageHeight = subReport.getHeight() + this.elementYPos + subReport.getY();
            }
            String[] names = new String[]{ID, X, Y, WIDTH};
            this.openElementTag(REPORT, subReport, null, 0, names);
            sreport.setExportToMultiPages(this.report.isExportToMultiPages());
            sreport.setDHTMLTopMargin(this.report.getDHTMLTopMargin());
            XMLSubReport dhtmlSub = new XMLSubReport(sreport, this.elementXPos + subReport.getX(), this.elementYPos + subReport.getY(), subReport.getWidth(), pageHeight, this);
            Object object = LOCK = dhtmlSub.getLOCK();
            synchronized (object) {
                new Thread(dhtmlSub).start();
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.imageCount = dhtmlSub.getImageCount();
            this.barcodeCount = dhtmlSub.getBarcodeCount();
            this.report.addTriggeredAlerts(sreport.getTriggeredAlerts(), sreport.getFileNameWithoutPath());
            return dhtmlSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write sub-report", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISubReportExport writeRTFObject(ReportRTFObject rtfObject, ReportTable tbl) {
        try {
            Object LOCK;
            ReportElement securityLevel = rtfObject.getSecurityLevel(this.report.getPreviewSecurityLevel());
            if (securityLevel != null && !securityLevel.isVisible()) {
                return null;
            }
            Vector<Vector<Object[]>> lines = this.reportGraphics.breakRichText(rtfObject, this.report, tbl, rtfObject.getWidthOfElement(), true);
            double pageHeight = -1.0;
            if (!rtfObject.isResizeToFitContent()) {
                pageHeight = rtfObject.getHeight() + this.elementYPos + rtfObject.getY();
            }
            String[] names = new String[]{ID, X, Y, WIDTH};
            this.openElementTag(RICHTEXT, rtfObject, null, 0, names);
            XMLRTFObject dhtmlSub = new XMLRTFObject(rtfObject, lines, this.elementXPos + rtfObject.getX(), this.elementYPos + rtfObject.getY(), rtfObject.getWidth(), pageHeight, this);
            Object object = LOCK = dhtmlSub.getLOCK();
            synchronized (object) {
                new Thread(dhtmlSub).start();
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.imageCount = dhtmlSub.getImageCount();
            this.barcodeCount = dhtmlSub.getBarcodeCount();
            return dhtmlSub;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to write RTF object", ex);
            return null;
        }
    }

    @Override
    protected void writeMasterSection(ReportSection masterSection, ReportTable tbl) throws Exception {
        String[] names = new String[]{NAME, ID, X, Y, WIDTH, HEIGHT, BACKGROUNDCOLOR, BORDERTHICKNESS, BORDERCOLOR};
        this.openElementTag(SECTION, masterSection, tbl, 0, names);
        super.writeMasterSection(masterSection, tbl);
        this.closeElementTag(SECTION);
    }

    public static String encodeXML(String text) {
        return XMLUtil.encodeXML(text);
    }

    protected void openElementTag(String tag, ReportElement element, ReportTableElement table, int row, String[] names) throws Exception {
        if (this.checkTotalPageNumber || tag == null || tag.trim().equals("") || this.checkFitGroupOnPage) {
            return;
        }
        String str = "<" + tag.trim();
        if (names != null) {
            for (String name2 : names) {
                str = name2 != null && name2.equals(LINK) && table instanceof ReportTable ? str + " " + LINK + "=\"" + XMLReport.encodeXML(this.getLink(element, (ReportTable)table, row)) + "\" " : str + this.getAttribute(element, name2, table);
            }
        }
        str = str + ">\n";
        this.out.write(str);
    }

    protected void closeElementTag(String element) throws Exception {
        if (this.checkTotalPageNumber || element == null || element.trim().equals("") || this.checkFitGroupOnPage) {
            return;
        }
        this.out.write("</" + XMLReport.encodeXML(element.trim()) + ">\n");
    }

    private void writeCDATA(String text) throws Exception {
        String str = QbUtil.replace(text, "\\n", "\n");
        this.out.write(XMLUtil.encodeCDATA(str));
    }

    private String getAttribute(ReportElement element, String Attr2, ReportTableElement currentPanel) {
        if (element != null) {
            if (Attr2.equals(FONTCOLOR)) {
                Color color = element.getFontColor() != null ? element.getFontColor() : Color.white;
                return " FontColor=\"" + color.getRGB() + "\" ";
            }
            if (Attr2.equals(FONTTYPE)) {
                return " FontType=\"" + XMLReport.encodeXML(element.getRefFont().getName()) + "\" ";
            }
            if (Attr2.equals(FONTSTYLE)) {
                if (element.getRefFont() == null) {
                    return " FontStyle=\"" + null + "\" ";
                }
                if (element.getRefFont().getStyle() == 1) {
                    return " FontStyle=\"bold\" ";
                }
                if (element.getRefFont().getStyle() == 2) {
                    return " FontStyle=\"italic\" ";
                }
                if (element.getRefFont().getStyle() == 3) {
                    return " FontStyle=\"italic_bold\" ";
                }
                return " FontStyle=\"plain\" ";
            }
            if (Attr2.equals(FONTSIZE)) {
                return " FontSize=\"" + XMLReport.encodeXML(Integer.toString(element.getRefFont().getSize())) + "\" ";
            }
            if (Attr2.equals(BACKGROUNDCOLOR)) {
                if (element.getBgColor() != null) {
                    return " BackgroundColor=\"" + element.getBgColor().getRGB() + "\" ";
                }
                return " BackgroundColor=\"" + null + "\" ";
            }
            if (Attr2.equals(BORDERCOLOR)) {
                if (element.getBorderColor() != null) {
                    return " BorderColor=\"" + element.getBorderColor().getRGB() + "\" ";
                }
                return "BorderColor=\"" + null + "\" ";
            }
            if (Attr2.equals(BORDERTHICKNESS)) {
                return " BorderThickness=\"" + element.getBorderThickness() + "\" ";
            }
            if (Attr2.equals(ALIGNMENT) && element.getAlign() >= 0 && element.getAlign() < ALIGN.length) {
                return " Alignment=\"" + ALIGN[element.getAlign()] + "\" ";
            }
            if (Attr2.equals(VALIGNMENT) && element.getVAlign() >= 0 && element.getVAlign() < VALIGN.length) {
                return " VerticalAlignment=\"" + VALIGN[element.getVAlign()] + "\" ";
            }
            if (Attr2.equals(WIDTH)) {
                if (element instanceof ReportGrid) {
                    ReportGrid grid = (ReportGrid)element;
                    if (grid.getGridStyle() == 2) {
                        return " Width=\"" + (grid.getWidthOfElement() + grid.getBorderThickness() * 6) + "\" ";
                    }
                    return " Width=\"" + (grid.getWidthOfElement() + grid.getBorderThickness() * 2) + "\" ";
                }
                return " Width=\"" + element.getWidthOfElement() + "\" ";
            }
            if (Attr2.equals(HEIGHT)) {
                if (element instanceof ReportGrid) {
                    ReportGrid grid = (ReportGrid)element;
                    if (grid.getHeight() < 0.0) {
                        return " Height=\"" + currentPanel.getHeightOfElement() + "\" ";
                    }
                    if (grid.getGridStyle() == 2) {
                        return " Height=\"" + (element.getHeightOfElement() + grid.getBorderThickness() * 6) + "\" ";
                    }
                    return " Height=\"" + (element.getHeightOfElement() + grid.getBorderThickness() * 2) + "\" ";
                }
                return " Height=\"" + element.getHeightOfElement() + "\" ";
            }
            if (Attr2.equals(X)) {
                if (element instanceof ReportGrid) {
                    ReportGrid grid = (ReportGrid)element;
                    if (grid.getGridStyle() == 2) {
                        return " X=\"" + (QbUtil.toPixel_export(this.getX(grid)) - grid.getBorderThickness() * 3) + "\" ";
                    }
                    return " X=\"" + (QbUtil.toPixel_export(this.getX(grid)) - grid.getBorderThickness()) + "\" ";
                }
                return " X=\"" + QbUtil.toPixel_export(this.getX(element)) + "\" ";
            }
            if (Attr2.equals(Y)) {
                if (element instanceof ReportGrid) {
                    ReportGrid grid = (ReportGrid)element;
                    if (grid.getGridStyle() == 2) {
                        return " Y=\"" + (QbUtil.toPixel_export(this.getY(grid)) - grid.getBorderThickness() * 3) + "\" ";
                    }
                    return " Y=\"" + (QbUtil.toPixel_export(this.getY(grid)) - grid.getBorderThickness()) + "\" ";
                }
                return " Y=\"" + QbUtil.toPixel_export(this.getY(element)) + "\" ";
            }
            if (Attr2.equals(ID)) {
                if (element.getID() != null && !element.getID().trim().equals("")) {
                    return " ID=\"" + XMLReport.encodeXML(element.getID()) + "\" ";
                }
                return " ID=\"\" ";
            }
            if (Attr2.equals(NAME)) {
                if (element.getText() != null && !element.getText().trim().equals("")) {
                    return " Name=\"" + XMLReport.encodeXML(element.getText()) + "\" ";
                }
                return " Name=\"\" ";
            }
            if (Attr2.equals(LINK)) {
                if (element.getLink() != null && !element.getLink().trim().equals("")) {
                    return " Link=\"" + XMLReport.encodeXML(element.getLink().trim()) + "\" ";
                }
                return " Link=\"\" ";
            }
            if (Attr2.equals(HINT)) {
                if (element.getHint() != null && !element.getHint().trim().equals("")) {
                    return " Hint=\"" + XMLReport.encodeXML(element.getHint().trim()) + "\" ";
                }
                return " Hint=\"\" ";
            }
            if (Attr2.equals(TARGET)) {
                if (element.getTarget() != null && !element.getTarget().trim().equals("")) {
                    return " Target=\"" + XMLReport.encodeXML(element.getTarget().trim()) + "\" ";
                }
                return " Target=\"\" ";
            }
            if (Attr2.equals(THICKNESS) && element instanceof ReportLine) {
                ReportLine line = (ReportLine)element;
                if (line.isVertical()) {
                    return " Thickness=\"" + (line.getWidthOfElement() - 2) + "\" ";
                }
                return " Thickness=\"" + (line.getHeightOfElement() - 2) + "\" ";
            }
            if (Attr2.equals(LENGTH) && element instanceof ReportLine) {
                ReportLine line = (ReportLine)element;
                if (line.isVertical()) {
                    int height = line.getHeightOfElement();
                    if (line.getHeight() < 0.0) {
                        height = currentPanel.getHeightOfElement();
                    }
                    return " Length=\"" + height + "\" ";
                }
                return " Length=\"" + line.getWidthOfElement() + "\" ";
            }
            if (Attr2.equals(ORIENTATION) && element instanceof ReportLine) {
                ReportLine line = (ReportLine)element;
                if (line.isVertical()) {
                    return " Orientation=\"vertical\" ";
                }
                return " Orientation=\"horizontal\" ";
            }
            if (Attr2.equals(LINESTYLE)) {
                if (element instanceof ReportLine) {
                    ReportLine line = (ReportLine)element;
                    if (line.getLineStyle() == 2) {
                        return " LineStyle=\"double\" ";
                    }
                    if (line.getLineStyle() == 3) {
                        return " LineStyle=\"dash\" ";
                    }
                    return " LineStyle=\"solid\" ";
                }
                if (element instanceof ReportGrid) {
                    ReportGrid grid = (ReportGrid)element;
                    if (grid.getGridStyle() == 2) {
                        return " LineStyle=\"double\" ";
                    }
                    if (grid.getGridStyle() == 3) {
                        return " LineStyle=\"dash\" ";
                    }
                    return " LineStyle=\"solid\" ";
                }
            } else {
                if (Attr2.equals(WORDWRAP)) {
                    return " WordWrap=\"" + !element.isNoWrap() + "\" ";
                }
                if (Attr2.equals(ROW) && element instanceof ReportTable) {
                    return " Row=\"" + ((ReportTable)element).getRowCount() + "\" ";
                }
                if (Attr2.equals(TOPBORDERVISIBLE) && element instanceof ReportGrid) {
                    ReportGrid grid = (ReportGrid)element;
                    return " TopBorderVisible=\"" + (grid.previous() == null) + "\" ";
                }
                if (Attr2.equals(BOTTOMBORDERVISIBLE) && element instanceof ReportGrid) {
                    ReportGrid grid = (ReportGrid)element;
                    return " BottomBorderVisible=\"" + (grid.next() == null) + "\" ";
                }
            }
        }
        return "";
    }

    private String getLink(ReportElement elt, ReportTable tbl, int row) {
        if (elt.getDrillDownName() == null) {
            if (elt.getLink() == null) {
                return "";
            }
            return elt.getLink().trim();
        }
        try {
            DrillDownNode node = null;
            DrillDownNode parentNode = this.report.currentNode;
            for (int i = 0; i < parentNode.getChildCount(); ++i) {
                if (!elt.getDrillDownName().equals(parentNode.getChildAt(i).getName())) continue;
                node = parentNode.getChildAt(i);
                i = parentNode.getChildCount();
            }
            int[] mapping = node.getColumnMapping();
            ReportTable tempTable = tbl;
            while (tempTable instanceof ReportTreeTable) {
                tempTable = ((ReportTreeTable)tempTable).getSubTable(0);
            }
            String parameters = "";
            for (int i = 0; i < mapping.length; ++i) {
                Object value = null;
                value = node.isCrossTabDrillDown() ? (this.report.colInfo[mapping[i]].isColumnBreak() && ((ReportCell)elt).getColumn() instanceof ColumnBreakColumn ? ((ColumnBreakColumn)((ReportCell)elt).getColumn()).getText(this.report, mapping[i]) : tempTable.getColumn(this.report.getColumnIndex(mapping[i])).getData(0)) : tempTable.getColumn(this.report.getColumnIndex(mapping[i])).getDrillDownData(row);
                if (value == null) {
                    throw new Exception("No data available for drill-down.");
                }
                parameters = parameters + "&PARAM" + i + "=" + QbUtil.urlEncode(DataType.write(value));
            }
            String servletDirectory = this.report.getServletDirectory();
            if (servletDirectory != null) {
                if (!(servletDirectory = servletDirectory.replace('\\', '/')).startsWith("/")) {
                    servletDirectory = "/" + servletDirectory;
                }
                if (!servletDirectory.endsWith("/")) {
                    servletDirectory = servletDirectory + "/";
                }
            } else {
                servletDirectory = "/servlet/";
            }
            String link = this.report.protocol + this.report.serverName + ":" + this.report.servletRunnerPort + servletDirectory + "DrillDownReportServlet?";
            if (!node.getRoot().getFileName().equals("")) {
                link = link + "ROOT_FILENAME=" + QbUtil.urlEncode(node.getRoot().getFileName() + "&");
            }
            link = link + "FILENAME=" + QbUtil.urlEncode(node.getFileName()) + "&FORMAT=" + this.getExtension() + parameters;
            return link;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Cannot get link", e);
            return "";
        }
    }

    @Override
    protected int getExtension() {
        return 6;
    }

    @Override
    protected double writeRemainingSubReports(Vector<ISubReportExport> subReports, ReportSection section) throws Exception {
        double bottomY = 0.0;
        while (subReports != null && subReports.size() > 0) {
            if (this.inTable == null) {
                this.closeSectionTag();
            }
            this.pageBreak(section);
            if (this.inTable == null) {
                this.openElementTag(SECTION, null, null, 0, null);
            }
            bottomY = this.writeOnePageOfSubReports(subReports);
        }
        return bottomY;
    }
}

