/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.XMLUtil;
import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.XMLReport;

public class XMLReportPureData {
    public static final String ESPRESSREPORTDATA = "EspressData";
    public static final String DATATYPE = "dataType";
    public static final String FIELDNAME = "fieldName";
    public static final String ROW = "row";
    public static final String DATA = "data";
    protected Writer out;
    protected Report report;
    protected boolean[] validColumn;

    public XMLReportPureData(Report report) {
        this.report = report;
    }

    public boolean exportXML(OutputStream outstream) throws Exception {
        this.out = new PrintWriter(outstream, true);
        return this.exportXML();
    }

    protected boolean exportXML() throws Exception {
        ColData[] colData = this.report.getColData();
        if (colData == null) {
            this.out.flush();
            this.out.close();
            return true;
        }
        this.writeDataHeader(colData);
        if (colData.length > 0) {
            for (int j = 0; j < colData[0].getSize(); ++j) {
                this.openElementTag(ROW);
                for (int i = 0; i < colData.length; ++i) {
                    if (!this.validColumn[i]) continue;
                    String data = null;
                    if (colData[i].getData(j) != null) {
                        data = colData[i].getData(j).toString();
                    }
                    this.writeDataElement(data);
                }
                this.closeElementTag(ROW);
            }
        }
        this.closeElementTag(ESPRESSREPORTDATA);
        this.out.flush();
        this.out.close();
        return true;
    }

    protected void writeDataHeader(ColData[] colData) throws Exception {
        int i;
        this.out.write("<?xml version=\"1.0\" encoding=\"" + ServerMessage.xmlEncoding + "\"?>\n");
        this.openElementTag(ESPRESSREPORTDATA);
        this.validColumn = new boolean[colData.length];
        for (i = 0; i < colData.length; ++i) {
            this.validColumn[i] = !DataType.getTypeName(colData[i].getOriginalDataType()).equalsIgnoreCase("binary") && !DataType.getTypeName(colData[i].getOriginalDataType()).equalsIgnoreCase("unsupport type");
        }
        this.validColumn[colData.length - 1] = false;
        for (i = 0; i < colData.length; ++i) {
            if (!this.validColumn[i]) continue;
            this.openElementTag(DATATYPE);
            this.writeCDATA(DataType.getTypeName(colData[i].getOriginalDataType()));
            this.closeElementTag(DATATYPE);
        }
        for (i = 0; i < colData.length; ++i) {
            if (!this.validColumn[i]) continue;
            this.openElementTag(FIELDNAME);
            this.writeCDATA(colData[i].getName());
            this.closeElementTag(FIELDNAME);
        }
    }

    protected void writeDataElement(String value) throws Exception {
        if (value == null) {
            this.out.write("<data value=\"[QUADBASE_XML_EXPORT_NULL]\" />\n");
        } else {
            this.out.write("<data value=\"" + XMLReport.encodeXML(value) + "\" />\n");
        }
    }

    protected void openElementTag(String tag) throws Exception {
        if (tag == null || tag.trim().equals("")) {
            return;
        }
        this.out.write("<" + tag.trim() + ">");
    }

    protected void closeElementTag(String tag) throws Exception {
        if (tag == null || tag.trim().equals("")) {
            return;
        }
        this.out.write("</" + tag.trim() + ">\n");
    }

    protected void writeCDATA(String text) throws Exception {
        this.out.write(XMLUtil.encodeCDATA(text));
    }
}

