/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import quadbase.reportdesigner.report.ColData;
import quadbase.reportdesigner.report.ColDataBuffer;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.XMLReportPureData;

public class XMLReportPureDataExport
extends XMLReportPureData {
    private ColDataBuffer colDataBuffer;

    public XMLReportPureDataExport(Report report) {
        super(report);
    }

    @Override
    protected boolean exportXML() throws Exception {
        int displayRow = Report.getInputDataBlockSize();
        int startIndex = 0;
        int nRow = 0;
        int recNo = 0;
        this.colDataBuffer = this.report.dbInfo != null ? new ColDataBuffer(this.report.dbInfo, startIndex, displayRow) : new ColDataBuffer(this.report.originalIResultSet, startIndex, displayRow);
        this.colDataBuffer.start();
        boolean init = true;
        while (true) {
            if (!this.colDataBuffer.isDataReady(startIndex)) {
                continue;
            }
            ColData[] colData = this.colDataBuffer.getData(startIndex);
            this.colDataBuffer.clearDataBuffer(startIndex);
            if (init) {
                this.writeDataHeader(colData);
                init = false;
            }
            nRow = colData[0].getSize();
            startIndex = nRow + startIndex;
            for (recNo = 0; recNo < nRow; ++recNo) {
                this.openElementTag("row");
                for (int i = 0; i < colData.length; ++i) {
                    if (!this.validColumn[i]) continue;
                    String data = null;
                    if (colData[i].getData(recNo) != null) {
                        data = colData[i].getData(recNo).toString();
                    }
                    this.writeDataElement(data);
                }
                this.closeElementTag("row");
            }
            if (displayRow != nRow) break;
        }
        this.closeElementTag("EspressData");
        this.out.flush();
        this.out.close();
        return true;
    }
}

