/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ISubReportExport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.XMLReport;

public class XMLSubReport
extends XMLReport
implements ISubReportExport {
    private static final Logger LOGGER = Logger.getLogger(XMLSubReport.class.getName());
    protected boolean finish = false;
    private Object LOCK = new Object();
    private boolean writePageFooter = false;

    public XMLSubReport(Report subreport, double x, double y, double reportWidth, double reportHeight, XMLReport parent) {
        super(subreport);
        this.imageCount = parent.imageCount;
        this.imageName = parent.imageName;
        this.barcodeCount = parent.barcodeCount;
        this.leftMargin = parent.leftMargin + x;
        this.topMargin = parent.topMargin;
        this.linksHeight = parent.linksHeight;
        this.reportGraphics = parent.reportGraphics;
        if (reportHeight < 0.0) {
            this.pageHeight = parent.pageHeight;
            double footerHeight = 0.0;
            try {
                footerHeight = this.hasNoData(this.report.getPageFooter()) ? 0.0 : this.resizeSection(this.reportGraphics, this.report.getPageFooter(), this.report.getReportTables().elementAt(this.report.getReportTables().size() - 1)).getHeight();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to set footer height", ex);
            }
            this.pageHeight -= footerHeight;
        } else {
            this.checkVisibility = true;
            this.pageHeight = reportHeight;
        }
        this.pageHeaderHeight = parent.pageHeaderHeight;
        this.maxWidthOfSections = reportWidth;
        this.elementYPos = y;
        this.elementXPos = 0.0;
        this.fontFraction = parent.fontFraction;
        this.currentPageNumber = parent.currentPageNumber;
        this.totalPageNumber = parent.totalPageNumber;
        this.reportUI = parent.reportUI;
        this.out = parent.checkFitGroupOnPage ? new StringWriter() : parent.out;
        this.checkTotalPageNumber = parent.checkTotalPageNumber;
        this.exportThread = parent.exportThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ReportTable table;
            this.formatTable();
            Vector<ReportTable> vec = this.report.getReportTables();
            this.hTable = table = vec.elementAt(0);
            this.fTable = vec.elementAt(vec.size() - 1);
            this.initRepeatSection();
            this.writeSection(this.report.getPageHeader(), table);
            this.writePageFooter = true;
            this.writeSection(this.report.getReportHeader(), table);
            for (int i = 0; i < vec.size(); ++i) {
                table = vec.elementAt(i);
                this.initRepeatSection();
                this.setColumnWrap();
                this.wrapInfo = new double[]{0.0, this.elementYPos, this.elementYPos};
                this.writeReportTable(table);
                this.resetColumnWrap();
            }
            table = vec.elementAt(vec.size() - 1);
            this.writeSection(this.report.getReportFooter(), table);
            this.writeSection(this.report.getPageFooter(), table, this.checkVisibility);
        }
        catch (Exception ex) {
            if (!"Subreport page break.".equals(ex.getMessage())) {
                LOGGER.log(Level.WARNING, "Failed to run XMLSubReport", ex);
            } else {
                LOGGER.log(Level.FINEST, "XMLSubReport: page break", ex);
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to run XMLSubReport", err);
        }
        finally {
            try {
                this.closeElementTag("REPORT");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to close REPORT element tag", ex);
            }
            this.finish = true;
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.finish;
    }

    @Override
    protected double getPageWidth() {
        return this.maxWidthOfSections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBreak(ReportSection section) throws Exception {
        if (this.checkVisibility) {
            if (this.inTable != null) {
                this.closeElementTag("TABLE");
            }
            throw new Exception("Subreport page break.");
        }
        if (this.elementYPos <= this.pageHeaderHeight) {
            return;
        }
        if (this.report.isExportToMultiPages()) {
            try {
                if (this.inTable != null) {
                    this.closeElementTag("TABLE");
                }
                if (this.writePageFooter) {
                    this.writeSection(this.report.getPageFooter(), this.fTable, false);
                }
                this.closeElementTag("REPORT");
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINER, "Failed to write multipage xml tags", ex);
            }
            ++this.currentPageNumber;
            ++this.pagebreaks;
            if (this.checkFitGroupOnPage) {
                throw new Exception("stop writing because of fit group on page");
            }
            Object ex = this.LOCK;
            synchronized (ex) {
                this.LOCK.notify();
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ReportCell cell = new ReportCell();
            cell.setWidth(this.maxWidthOfSections);
            String[] names = new String[]{"X", "Y", "Width"};
            try {
                this.openElementTag("REPORT", cell, null, 0, names);
                if (this.writePageFooter) {
                    this.writeSection(this.report.getPageHeader(), this.hTable);
                }
                this.writeRepeatSection(section);
                if (this.inTable != null) {
                    names = new String[]{"ID", "BackgroundColor", "Row"};
                    this.openElementTag("TABLE", this.inTable, null, 0, names);
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINER, "Failed to open REPORT or TABLE XML tag", ex2);
            }
            this.elementXPos = 0.0;
        }
    }

    @Override
    protected boolean isVisible(ReportElement elt) {
        if (!elt.isVisible()) {
            return false;
        }
        return !(this.elementXPos + elt.getX() + elt.getWidth() > this.maxWidthOfSections);
    }

    @Override
    public Object getLOCK() {
        return this.LOCK;
    }

    @Override
    public double getY() {
        return this.elementYPos;
    }

    @Override
    public void setY(double y) {
        this.elementYPos = y;
    }

    @Override
    public void setOut(Writer o) {
        this.out = o;
    }

    @Override
    public void setDivnameCount(int dcount) {
        this.divnameCount = dcount;
    }

    @Override
    public int getDivnameCount() {
        return this.divnameCount;
    }

    @Override
    public void setImageCount(int icount) {
        this.imageCount = icount;
    }

    @Override
    public int getImageCount() {
        return this.imageCount;
    }

    @Override
    public void setBarcodeCount(int bcount) {
        this.barcodeCount = bcount;
    }

    @Override
    public int getBarcodeCount() {
        return this.barcodeCount;
    }
}

