/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.crosstab;

import java.util.Vector;
import java.util.logging.Logger;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.designer.ColInfoMappingPanel;
import quadbase.reportdesigner.designer.ReportElementPanel;
import quadbase.reportdesigner.designer.adapter.AbstractAdapter;
import quadbase.reportdesigner.report.Report;

public class CrossTabHelper {
    private static final Logger LOGGER = Logger.getLogger(ColInfoMappingPanel.class.getName());
    public static final double MIN_CELL_WIDTH = 0.1;
    public static final double MIN_CELL_HEIGHT = 0.1;

    public static void adjustAllElementsWithGreaterX(ReportElementPanel panel, ReportElement selected, double deltaInch) {
        Vector<ReportTable> reportTables = panel.reportMain.report.getReportTables();
        for (ReportTable reportTable : reportTables) {
            CrossTabHelper.adjustReportElementsByDeltaX(deltaInch, selected, reportTable.getHeader().getData());
            CrossTabHelper.adjustReportElementsByDeltaX(deltaInch, selected, reportTable.getFooter().getData());
            ReportElement[] tableElements = reportTable.getTableElements();
            CrossTabHelper.adjustReportElementsByDeltaX(deltaInch, selected, tableElements);
        }
    }

    public static ReportElement[] getReportElementNeighbours(ReportElementPanel panel, ReportElement element) {
        Vector<ReportTable> reportTables = panel.reportMain.report.getReportTables();
        String elId = element.getID();
        ReportElement[] tableElements = null;
        for (ReportTable reportTable : reportTables) {
            tableElements = reportTable.getHeader().getData();
            if (CrossTabHelper.containsReportElement(elId, tableElements)) {
                return tableElements;
            }
            tableElements = reportTable.getFooter().getData();
            if (CrossTabHelper.containsReportElement(elId, tableElements)) {
                return tableElements;
            }
            tableElements = reportTable.getTableElementsNoGL();
            if (!CrossTabHelper.containsReportElement(elId, tableElements)) continue;
            return tableElements;
        }
        return tableElements;
    }

    public static void adjustReportElementsByDeltaY(ReportElementPanel panel, ReportElement selected, double deltaInch) {
        ReportElement[] reportElements = CrossTabHelper.getReportElementNeighbours(panel, selected);
        if (selected.getHeight() + deltaInch <= 0.0) {
            return;
        }
        for (ReportElement reportElement : reportElements) {
            if (reportElement instanceof ReportLine && !((ReportLine)reportElement).isVertical()) continue;
            if (reportElement.getY() == selected.getY()) {
                if (reportElement.getID().equals(selected.getID())) continue;
                reportElement.setHeight(reportElement.getHeight() + deltaInch);
                continue;
            }
            if (!(reportElement.getY() > selected.getY())) continue;
            reportElement.setY(reportElement.getY() + deltaInch);
        }
    }

    public static boolean containsReportElement(String elId, ReportElement[] tableElements) {
        for (ReportElement reportElement : tableElements) {
            if (!reportElement.getID().equals(elId)) continue;
            return true;
        }
        return false;
    }

    public static void adjustReportElementsByDeltaX(double deltaInch, ReportElement selectedEl, ReportElement[] tableElements) {
        if (selectedEl.getWidth() + deltaInch - 0.1 <= 0.0) {
            LOGGER.info("return " + (selectedEl.getWidth() + deltaInch));
            return;
        }
        if (tableElements != null) {
            double elX = selectedEl.getX();
            for (ReportElement reportElement : tableElements) {
                boolean line = reportElement instanceof ReportLine;
                if (reportElement.getX() > elX) {
                    if (line) {
                        reportElement.setXX(reportElement.getX() + deltaInch);
                        continue;
                    }
                    reportElement.setX(reportElement.getX() + deltaInch);
                    continue;
                }
                if (reportElement.getX() != elX || reportElement.getID().equals(selectedEl.getID()) || line) continue;
                reportElement.setWidth(reportElement.getWidth() + deltaInch);
            }
        }
    }

    public static boolean isElementFromCrossTabSection(Report report, ReportElement e) {
        return report.isCrossTab() && !AbstractAdapter.isReportHeader((ReportElement)e) && !AbstractAdapter.isReportFooter((ReportElement)e) && !AbstractAdapter.isPageHeader((ReportElement)e) && !AbstractAdapter.isPageFooter((ReportElement)e);
    }
}

