/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.excel;

import java.awt.Color;
import java.awt.Font;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import quadbase.reportdesigner.report.excel.ExcelReport;

public class ExcelCellStyle {
    private short dataFormat = 0;
    private BorderStyle borderLeft = BorderStyle.NONE;
    private BorderStyle borderRight = BorderStyle.NONE;
    private BorderStyle borderTop = BorderStyle.NONE;
    private BorderStyle borderBottom = BorderStyle.NONE;
    private HorizontalAlignment alignment = HorizontalAlignment.GENERAL;
    private VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    private short rotation = 0;
    private boolean wrapText = false;
    private Color bgColor = null;
    private Color leftBorderColor = null;
    private Color rightBorderColor = null;
    private Color topBorderColor = null;
    private Color bottomBorderColor = null;
    private boolean underline = false;
    private Color fontColor = Color.BLACK;
    private Font font = null;

    public short getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(short dataFormat) {
        this.dataFormat = dataFormat;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(BorderStyle borderLeft) {
        this.borderLeft = borderLeft;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(BorderStyle borderRight) {
        this.borderRight = borderRight;
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(BorderStyle borderTop) {
        this.borderTop = borderTop;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(BorderStyle borderBottom) {
        this.borderBottom = borderBottom;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(HorizontalAlignment alignment) {
        this.alignment = alignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public short getRotation() {
        return this.rotation;
    }

    public void setRotation(short rotation) {
        this.rotation = rotation;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public Color getRightBorderColor() {
        return this.rightBorderColor;
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    public Color getTopBorderColor() {
        return this.topBorderColor;
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.topBorderColor = topBorderColor;
    }

    public Color getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alignment == null ? 0 : this.alignment.hashCode());
        result = 31 * result + (this.bgColor == null ? 0 : this.bgColor.hashCode());
        result = 31 * result + (this.borderBottom == null ? 0 : this.borderBottom.hashCode());
        result = 31 * result + (this.borderLeft == null ? 0 : this.borderLeft.hashCode());
        result = 31 * result + (this.borderRight == null ? 0 : this.borderRight.hashCode());
        result = 31 * result + (this.borderTop == null ? 0 : this.borderTop.hashCode());
        result = 31 * result + (this.bottomBorderColor == null ? 0 : this.bottomBorderColor.hashCode());
        result = 31 * result + this.dataFormat;
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.fontColor == null ? 0 : this.fontColor.hashCode());
        result = 31 * result + (this.leftBorderColor == null ? 0 : this.leftBorderColor.hashCode());
        result = 31 * result + (this.rightBorderColor == null ? 0 : this.rightBorderColor.hashCode());
        result = 31 * result + this.rotation;
        result = 31 * result + (this.topBorderColor == null ? 0 : this.topBorderColor.hashCode());
        result = 31 * result + (this.underline ? 1231 : 1237);
        result = 31 * result + (this.verticalAlignment == null ? 0 : this.verticalAlignment.hashCode());
        result = 31 * result + (this.wrapText ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExcelCellStyle other = (ExcelCellStyle)obj;
        if (this.alignment != other.alignment) {
            return false;
        }
        if (this.bgColor == null ? other.bgColor != null : !this.bgColor.equals(other.bgColor)) {
            return false;
        }
        if (this.borderBottom != other.borderBottom) {
            return false;
        }
        if (this.borderLeft != other.borderLeft) {
            return false;
        }
        if (this.borderRight != other.borderRight) {
            return false;
        }
        if (this.borderTop != other.borderTop) {
            return false;
        }
        if (this.bottomBorderColor == null ? other.bottomBorderColor != null : !this.bottomBorderColor.equals(other.bottomBorderColor)) {
            return false;
        }
        if (this.dataFormat != other.dataFormat) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        if (this.fontColor == null ? other.fontColor != null : !this.fontColor.equals(other.fontColor)) {
            return false;
        }
        if (this.leftBorderColor == null ? other.leftBorderColor != null : !this.leftBorderColor.equals(other.leftBorderColor)) {
            return false;
        }
        if (this.rightBorderColor == null ? other.rightBorderColor != null : !this.rightBorderColor.equals(other.rightBorderColor)) {
            return false;
        }
        if (this.rotation != other.rotation) {
            return false;
        }
        if (this.topBorderColor == null ? other.topBorderColor != null : !this.topBorderColor.equals(other.topBorderColor)) {
            return false;
        }
        if (this.underline != other.underline) {
            return false;
        }
        if (this.verticalAlignment != other.verticalAlignment) {
            return false;
        }
        return this.wrapText == other.wrapText;
    }

    public void applyTo(CellStyle cellStyle, ExcelReport excel) {
        cellStyle.setDataFormat(this.dataFormat);
        cellStyle.setAlignment(this.alignment);
        cellStyle.setVerticalAlignment(this.verticalAlignment);
        cellStyle.setWrapText(this.wrapText);
        if (this.font != null) {
            cellStyle.setFont(excel.getFont(this.font, this.fontColor, this.underline));
        }
        cellStyle.setBorderLeft(this.borderLeft);
        if (this.leftBorderColor != null) {
            if (cellStyle instanceof XSSFCellStyle) {
                ((XSSFCellStyle)cellStyle).setLeftBorderColor(new XSSFColor(this.leftBorderColor, (IndexedColorMap)new DefaultIndexedColorMap()));
            } else {
                cellStyle.setLeftBorderColor(excel.getColorIndex(this.leftBorderColor));
            }
        }
        cellStyle.setBorderRight(this.borderRight);
        if (this.rightBorderColor != null) {
            if (cellStyle instanceof XSSFCellStyle) {
                ((XSSFCellStyle)cellStyle).setRightBorderColor(new XSSFColor(this.rightBorderColor, (IndexedColorMap)new DefaultIndexedColorMap()));
            } else {
                cellStyle.setRightBorderColor(excel.getColorIndex(this.rightBorderColor));
            }
        }
        cellStyle.setBorderTop(this.borderTop);
        if (this.topBorderColor != null) {
            if (cellStyle instanceof XSSFCellStyle) {
                ((XSSFCellStyle)cellStyle).setTopBorderColor(new XSSFColor(this.topBorderColor, (IndexedColorMap)new DefaultIndexedColorMap()));
            } else {
                cellStyle.setTopBorderColor(excel.getColorIndex(this.topBorderColor));
            }
        }
        cellStyle.setBorderBottom(this.borderBottom);
        if (this.bottomBorderColor != null) {
            if (cellStyle instanceof XSSFCellStyle) {
                ((XSSFCellStyle)cellStyle).setBottomBorderColor(new XSSFColor(this.bottomBorderColor, (IndexedColorMap)new DefaultIndexedColorMap()));
            } else {
                cellStyle.setBottomBorderColor(excel.getColorIndex(this.bottomBorderColor));
            }
        }
        if (this.bgColor != null) {
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            if (cellStyle instanceof XSSFCellStyle) {
                ((XSSFCellStyle)cellStyle).setFillForegroundColor(new XSSFColor(this.bgColor, (IndexedColorMap)new DefaultIndexedColorMap()));
            } else {
                cellStyle.setFillForegroundColor(excel.getColorIndex(this.bgColor));
            }
        } else {
            cellStyle.setFillPattern(FillPatternType.NO_FILL);
        }
        if (this.rotation != 0) {
            if (cellStyle instanceof XSSFCellStyle) {
                if (this.rotation > 0) {
                    ((XSSFCellStyle)cellStyle).setRotation((short)(this.rotation + 90));
                } else if (this.rotation < 0) {
                    ((XSSFCellStyle)cellStyle).setRotation(-this.rotation);
                } else {
                    ((XSSFCellStyle)cellStyle).setRotation(this.rotation);
                }
            } else {
                cellStyle.setRotation(-this.rotation);
            }
        }
    }
}

