/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.excel;

import java.awt.Color;
import java.awt.Point;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.DateFormatConverter;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import quadbase.common.util.internal.FontTable;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.FormattedRow;
import quadbase.reportdesigner.ReportElements.FormattedRowKey;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportColumn;
import quadbase.reportdesigner.ReportElements.ReportDocument;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportRTFObject;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.ReportElements.ReportTreeTable;
import quadbase.reportdesigner.ReportElements.SubReportObject;
import quadbase.reportdesigner.ReportElements.TableOfContents;
import quadbase.reportdesigner.report.PrintUtil;
import quadbase.reportdesigner.report.ReloadReport;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportGraphics;
import quadbase.reportdesigner.report.ReportMultiSectionTable;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.excel.AddableCell;
import quadbase.reportdesigner.report.excel.Cell;
import quadbase.reportdesigner.report.excel.ExcelCellStyle;
import quadbase.reportdesigner.report.excel.ExcelChartRecord;
import quadbase.reportdesigner.report.excel.ExcelSubReport;
import quadbase.reportdesigner.report.excel.MatrixGriddedSection;
import quadbase.reportdesigner.report.excel.MergedExcelRows;
import quadbase.reportdesigner.util.ColInfo;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.NumericFormat;

public class ExcelReport {
    private static final Logger LOGGER = Logger.getLogger(ExcelReport.class.getName());
    protected final double ColWidthConverter = 3510.0;
    protected Report report = null;
    protected ReportGraphics reportGraphics = null;
    protected Workbook wb = null;
    protected DataFormat dataFormat = null;
    protected HSSFPalette palette = null;
    protected Drawing patriarch = null;
    protected CreationHelper helper = null;
    protected double leftMargin = 0.0;
    protected double reportHeight = -1.0;
    protected double reportWidth = -1.0;
    protected MatrixGriddedSection globalGriddedSection = null;
    protected Vector<Color> colorMap = null;
    protected Hashtable<Vector<Object>, Font> fontMap = null;
    protected Vector<Integer> treeStructure = null;
    protected Vector<ReportElement> rowElements = null;
    protected Hashtable<FormattedRowKey, FormattedRow> rows = null;
    protected boolean isApplyExcelFormat = true;
    protected double[] xPositions = null;
    protected double ROW_MINIMUM_HEIGHT = 0.1;
    protected double COL_MINIMUM_WIDTH = 0.25;
    protected double PRECISION = 0.001;
    protected boolean checkTotalPageNumber = false;
    protected ReportTable hTable = null;
    protected ReportTable fTable = null;
    protected int currentPageNumber = 1;
    protected int totalPageNumber = 1;
    protected boolean resetPageNumber = false;
    protected int currentPage = 1;
    protected Hashtable<String, Integer> sectionTotalPagesTable = null;
    protected String treeCopy = "";
    protected boolean populateTable = true;
    protected int savedStartPage = 1;
    protected Vector<Integer> sectionTotalPages = null;
    protected Vector<Integer> sectionStartPage = null;
    protected Hashtable<Integer, int[]> pageLookup = null;
    protected int newSheetOption = 0;
    protected double columnMinXPos = -1.0;
    protected double columnMaxXPos = 0.0;
    protected Map<ReportChartObject, ExcelChartRecord> excelChartRecords = new HashMap<ReportChartObject, ExcelChartRecord>();
    boolean isWriteRepeatSection = false;
    private Sheet sheet = null;
    private int rownum = 0;
    private FormulaRange[] columnPositionMapping = null;
    private Object[] previousRowValue;
    private boolean[] previousRowIsBGColor2;
    private boolean calculated = false;
    private int sheetCt = 1;
    private Vector<ReportSection> sectionList = null;
    private Vector<ReportTable> tableList = null;
    private boolean titleAdjusted = false;
    private boolean tableDataOnly;
    private ReportUI reportUI;
    private boolean skipFormatTable = false;
    private Map<ExcelCellStyle, CellStyle> cellStyleCache = new HashMap<ExcelCellStyle, CellStyle>();
    private boolean limitExcelCellSplit = false;
    private boolean hadDrawableData = false;

    public ExcelReport(Report report) {
        this.report = report;
    }

    public ExcelReport(Report report, boolean skipFormatTable) {
        this(report);
        this.skipFormatTable = skipFormatTable;
    }

    static String toExcelCol(int num) {
        int numChars = 1;
        while ((double)num >= Math.pow(26.0, numChars)) {
            num = (int)((double)num - Math.pow(26.0, numChars));
            ++numChars;
        }
        String s = "";
        while (num > 25) {
            s = (char)(65 + num % 26) + s;
            num /= 25;
        }
        s = (char)(65 + num % 26) + s;
        while (s.length() < numChars) {
            s = 'A' + s;
        }
        return s;
    }

    public boolean exportExcel(OutputStream outstream, int format, boolean limitExcelCellSplit) throws Exception {
        this.limitExcelCellSplit = limitExcelCellSplit;
        this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
        if (this.report.hasFormulaExp("getTotalPages(") && this.populateTable) {
            this.checkTotalPageNumber = true;
            this.exportExcelHelper(null, format);
            this.totalPageNumber = this.currentPageNumber;
            this.populatePageLookupTable();
            this.init();
            this.sheetCt = 1;
        }
        this.checkTotalPageNumber = false;
        this.populateTable = false;
        this.exportExcelHelper(outstream, format);
        return true;
    }

    public boolean exportExcelHelper(OutputStream outstream, int format) throws Exception {
        try {
            this.hadDrawableData = false;
            if (this.reportUI == null) {
                this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
            }
            this.reportUI.preCalcTotalSections();
            this.reportGraphics = this.reportUI.getReportGraphics();
            this.reportGraphics.setCharWidthMultiplier(1.2);
            this.reportGraphics.setLineHeight(1.2);
            this.isApplyExcelFormat = this.report.isApplyExcelFormat();
            if (format == 17) {
                if (Report.Excel_streaming) {
                    LOGGER.info("SXSSFWorkbook: only keep " + Report.Excel_window_size + " rows in memory.");
                    this.wb = new SXSSFWorkbook(Report.Excel_window_size);
                } else {
                    this.wb = new XSSFWorkbook();
                }
            } else {
                this.wb = new HSSFWorkbook();
                this.colorMap = new Vector();
                this.colorMap.addElement(Color.black);
                this.colorMap.addElement(Color.white);
                this.palette = ((HSSFWorkbook)this.wb).getCustomPalette();
                this.palette.setColorAtIndex((short)8, (byte)0, (byte)0, (byte)0);
                this.palette.setColorAtIndex((short)9, (byte)-1, (byte)-1, (byte)-1);
            }
            this.dataFormat = this.wb.createDataFormat();
            this.helper = this.wb.getCreationHelper();
            this.fontMap = new Hashtable();
            this.sheet = this.wb.createSheet("Sheet" + this.sheetCt);
            ReportTable table = null;
            if (this.report.getInitializeReportError() == null) {
                this.formatTable();
            }
            this.init();
            ++this.sheetCt;
            Vector<ReportTable> vec = this.report.getReportTables();
            if (vec.size() <= 0) {
                throw new Exception("The report does not contain any table. Please check and try again later.");
            }
            table = vec.elementAt(0);
            this.hTable = vec.elementAt(0);
            this.fTable = vec.elementAt(vec.size() - 1);
            if (this.report.getInitializeReportError() == null) {
                int rowBreakCt = 0;
                for (ColInfo element : this.report.colInfo) {
                    if (!element.isRowBreak()) continue;
                    ++rowBreakCt;
                }
                for (int i = 0; i < rowBreakCt; ++i) {
                    ReportSection rowBreakHeader = table.getRowBreakHeader(i);
                    if (rowBreakHeader == null || !rowBreakHeader.isNewExcelSheet()) continue;
                    ++this.newSheetOption;
                }
                this.writeSection(this.report.getPageHeader(), table);
                this.writeSection(this.report.getReportHeader(), table);
                this.initRepeatSection();
                this.addRepeatSection(this.report.getPageHeader(), table);
                MergedExcelRows mergedRows = new MergedExcelRows(this);
                for (int i = 0; i < vec.size(); ++i) {
                    table = vec.elementAt(i);
                    mergedRows = this.writeReportTable(table, mergedRows);
                }
                if (mergedRows != null && mergedRows.getMergedRows() > 0) {
                    mergedRows.writeRows(table, false);
                    mergedRows.writeSupplementSections();
                }
                this.writeSection(this.report.getReportFooter(), table);
                this.writeSection(this.report.getPageFooter(), table);
            } else {
                this.writeSection(ReportUI.createErrorSection(this.report.getActualPageWidth(), this.report.getActualPageHeight(), this.report.getInitializeReportError()), table);
            }
            if (outstream != null) {
                this.wb.write(outstream);
            }
        }
        catch (Exception ex) {
            if (this.wb instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.wb).dispose();
            }
            LOGGER.log(Level.FINE, "Failed to export to Excel", ex);
            throw new Exception("Failed to export to Excel format.\n" + ex.toString());
        }
        this.calculated = true;
        if (this.wb instanceof SXSSFWorkbook) {
            ((SXSSFWorkbook)this.wb).dispose();
        }
        return true;
    }

    protected void formatTable() throws Exception {
        if (!this.skipFormatTable) {
            this.report.formatTable();
        }
    }

    private void init() {
        int i;
        this.currentPageNumber = 1;
        this.currentPage = 1;
        this.treeCopy = "";
        this.treeStructure = new Vector();
        this.savedStartPage = 1;
        this.isWriteRepeatSection = false;
        this.rownum = 0;
        this.isWriteRepeatSection = false;
        this.newSheetOption = 0;
        Vector<Double> xPoss = new Vector<Double>();
        this.tableDataOnly = true;
        this.getXPos(this.report, xPoss, 0.0, -1.0);
        this.tableDataOnly = false;
        this.getXPos(this.report, xPoss, 0.0, -1.0);
        ReportTable table = null;
        Vector<ReportTable> vec = this.report.getReportTables();
        if (vec.size() > 0) {
            table = vec.elementAt(0);
        }
        xPoss = this.groupPositions(xPoss);
        this.xPositions = new double[xPoss.size()];
        for (i = 0; i < xPoss.size(); ++i) {
            this.xPositions[i] = xPoss.elementAt(i);
        }
        this.setCurrentSheetPosition();
        if (table == null) {
            return;
        }
        if (table.getVisibleColumnCount() == 0) {
            return;
        }
        this.columnPositionMapping = new FormulaRange[table.getColumnCount()];
        for (i = 0; i < this.columnPositionMapping.length; ++i) {
            this.columnPositionMapping[i] = new FormulaRange();
        }
    }

    private void setCurrentSheetPosition() {
        for (int i = 1; i < this.xPositions.length; ++i) {
            this.sheet.setColumnWidth(i - 1, Math.min(65280, (int)Math.round((this.xPositions[i] - this.xPositions[i - 1]) * 3510.0 / 256.0 - 1.0) * 256));
        }
    }

    protected MergedExcelRows writeSection(ReportSection section, ReportTable tbl) throws Exception {
        return this.writeSection(section, tbl, null);
    }

    protected MergedExcelRows writeSection(ReportSection section, ReportTable tbl, MergedExcelRows mergedRows) throws Exception {
        if (!this.titleAdjusted) {
            if (this.reportUI == null) {
                this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
            }
            this.titleAdjusted = this.reportUI.adjustReportTitle(this.reportUI.getReportGraphics(), this.report.getReportHeader());
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        boolean resetPageNumber = false;
        if (section.getScriptObj() != null) {
            bgColor = section.getBgColor();
            printOnNewPage = section.isPrintOnNewPage();
            visible = section.isVisible();
            resetPageNumber = section.isResetPageNumber();
            section.getScriptObj().applyScript(tbl, 1, 1, 1, 1, this.report, section);
        }
        mergedRows = this.writeSectionHelper(section, tbl, mergedRows);
        for (int i = 0; i < section.getSectionCount(); ++i) {
            mergedRows = this.writeSection(section.getSection(i), tbl, mergedRows);
        }
        if (section.getScriptObj() != null) {
            section.setBgColor(bgColor);
            section.setPrintOnNewPage(printOnNewPage);
            section.setVisible(visible);
            section.setResetPageNumber(resetPageNumber);
        }
        return mergedRows;
    }

    protected void writeRepeatSection(ReportSection section) throws Exception {
        this.isWriteRepeatSection = true;
        if (this.sectionList != null) {
            for (int i = 0; i < this.sectionList.size(); ++i) {
                ReportSection drawingSection = this.sectionList.elementAt(i);
                if (drawingSection == section) {
                    return;
                }
                for (int j = 0; j < drawingSection.getSectionCount(); ++j) {
                    if (drawingSection.getSection(j) != section) continue;
                    return;
                }
                this.writeSection(drawingSection, this.tableList.elementAt(i));
            }
        }
        this.isWriteRepeatSection = false;
    }

    protected void initRepeatSection() {
        this.sectionList = new Vector();
        this.tableList = new Vector();
    }

    protected void addRepeatSection(ReportSection section, ReportTable tbl) {
        this.sectionList.addElement(section);
        this.tableList.addElement(tbl);
    }

    protected void removeRepeatSection() {
        this.sectionList.removeElementAt(this.sectionList.size() - 1);
        this.tableList.removeElementAt(this.tableList.size() - 1);
    }

    private boolean isFirstValue() {
        int[] intArray;
        for (int element : intArray = QbUtil.convertVectorToIntArray(this.treeStructure)) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    protected String getTreeStringKey() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            String str = "Tree_";
            int size = this.treeStructure.size();
            for (int i = 0; i < size - 1; ++i) {
                str = str + this.treeStructure.elementAt(i) + "_";
            }
            str = str + this.treeStructure.elementAt(size - 1);
            return str;
        }
        return null;
    }

    protected int getCurrentSectionID() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int lastID = this.treeStructure.size();
            return this.treeStructure.elementAt(lastID - 1);
        }
        return 0;
    }

    private boolean printOnNewPage(ReportSection section) {
        if (section.isNewExcelSheet()) {
            if (section.getID().contains("RPT_FTR")) {
                return true;
            }
            if (this.newSheetOption == 1) {
                return !this.isFirstValue();
            }
            return this.getCurrentSectionID() != 0;
        }
        return false;
    }

    protected int getPage() {
        return this.currentPageNumber;
    }

    protected int getTotalPageNumber() {
        return this.totalPageNumber;
    }

    private void pageBreak(ReportSection section) throws Exception {
        this.writeSection(this.report.getPageFooter(), this.fTable);
        ++this.currentPageNumber;
        ++this.currentPage;
        if (section != null && section.isResetPageNumber()) {
            this.currentPage = 1;
            this.savedStartPage = this.currentPageNumber;
        }
        this.sheet = this.wb.createSheet("Sheet" + this.sheetCt++);
        this.patriarch = null;
        this.setCurrentSheetPosition();
        this.rownum = 0;
        this.writeRepeatSection(section);
    }

    protected void populatePageLookupTable() {
        if (this.sectionTotalPages == null || this.sectionStartPage == null) {
            return;
        }
        if (this.sectionTotalPages.size() != this.sectionStartPage.size()) {
            return;
        }
        if (this.sectionTotalPages.size() == 0) {
            return;
        }
        int count = this.sectionTotalPages.size();
        int lastSectionTotalPages = this.sectionTotalPages.elementAt(count - 1);
        int lastSectionStartPage = this.sectionStartPage.elementAt(count - 1);
        for (int i = count - 2; i >= 0; --i) {
            int nextSectionStartPage = this.sectionStartPage.elementAt(i);
            if (nextSectionStartPage == lastSectionStartPage) {
                this.sectionTotalPages.setElementAt(lastSectionTotalPages, i);
            }
            lastSectionTotalPages = this.sectionTotalPages.elementAt(i);
            lastSectionStartPage = this.sectionStartPage.elementAt(i);
        }
        this.pageLookup = new Hashtable();
        int nextStartPage = this.sectionStartPage.elementAt(0);
        int nextTotalPages = this.sectionTotalPages.elementAt(0);
        for (int i = 1; i <= this.totalPageNumber; ++i) {
            if (i < nextStartPage) {
                this.pageLookup.put(i, new int[]{i, i});
                continue;
            }
            if (i != nextStartPage) continue;
            nextTotalPages = this.sectionTotalPages.remove(0);
            nextStartPage = this.sectionStartPage.remove(0);
            boolean flag = false;
            int j = 1;
            while (j <= nextTotalPages) {
                this.pageLookup.put(i, new int[]{j++, nextTotalPages});
                flag = true;
                ++i;
            }
            if (this.sectionTotalPages.size() > 0) {
                nextTotalPages = this.sectionTotalPages.elementAt(0);
                nextStartPage = this.sectionStartPage.elementAt(0);
            }
            if (!flag) continue;
            --i;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected MergedExcelRows writeSectionHelper(ReportSection section, ReportTable tbl, MergedExcelRows mergedRows) throws Exception {
        if (section == null || !section.isVisible()) {
            return mergedRows;
        }
        if (section.isResetPageNumber()) {
            this.resetPageNumber = true;
            this.treeCopy = this.getTreeStringKey();
            if (this.sectionTotalPagesTable == null) {
                this.sectionTotalPagesTable = new Hashtable();
            }
            if (this.sectionTotalPages == null) {
                this.sectionTotalPages = new Vector();
            }
            if (this.sectionStartPage == null) {
                this.sectionStartPage = new Vector();
            }
        }
        if (this.hadDrawableData && !this.isWriteRepeatSection && this.printOnNewPage(section)) {
            this.pageBreak(section);
        }
        if (section.hasNoDrawableData()) {
            return mergedRows;
        }
        this.hadDrawableData = true;
        if (this.checkTotalPageNumber) {
            return mergedRows;
        }
        ReportSection orgSection = section;
        if (orgSection == (section = this.resizeSection(this.reportGraphics, section, tbl))) {
            section = ReportUI.copySectionForSecuredInvisibleCols(section, tbl, this.report.getPreviewSecurityLevel());
        }
        ReportElement[] cells = section.sortCell(2, false);
        cells = (ReportCell[])ReportUI.takeAwaySecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel(), this.report.getReportType());
        section = this.resizeSection(this.reportGraphics, section, tbl);
        if (mergedRows == null) {
            void var11_25;
            void var11_23;
            ReportCell[] textCells;
            Vector<Cell> addableCells = new Vector<Cell>();
            Vector<Double> yPos = new Vector<Double>();
            cells = section.getCells();
            ReportCell[] reportCellArray = textCells = this.getTextAndImageCells((ReportCell[])cells);
            int n = reportCellArray.length;
            boolean bl = false;
            while (var11_23 < n) {
                ReportCell textCell = reportCellArray[var11_23];
                Cell cell = this.createCell(textCell, (ReportCell[])cells, tbl, this.report);
                if (cell != null) {
                    double y = this.getYPos(cell.element, false);
                    this.insertXPos(y, yPos);
                    y = this.getYPos(cell.element, true);
                    this.insertXPos(y, yPos);
                    addableCells.addElement(cell);
                }
                ++var11_23;
            }
            this.insertXPos(section.getHeight(), yPos);
            yPos = this.groupPositionHelper(yPos, this.ROW_MINIMUM_HEIGHT);
            double[] yPoss = new double[yPos.size()];
            for (int i = 0; i < yPos.size(); ++i) {
                yPoss[i] = yPos.elementAt(i);
            }
            MatrixGriddedSection gridSection = new MatrixGriddedSection(this, tbl, section, this.rownum, this.xPositions, yPoss);
            boolean bl2 = false;
            while (var11_25 < addableCells.size()) {
                Cell cell = (Cell)addableCells.elementAt((int)var11_25);
                gridSection.add(cell);
                ++var11_25;
            }
            for (ReportElement cell : cells) {
                ReportImage newCell;
                if (cell instanceof ReportLine) {
                    newCell = (ReportLine)tbl.formatCell((ReportCell)cell, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report);
                    if (!((ReportLine)newCell).isVisible()) continue;
                    gridSection.addReportLine((ReportLine)newCell, 0.0, 0.0);
                    continue;
                }
                if (!(cell instanceof ReportGrid) || !(newCell = (ReportGrid)tbl.formatCell((ReportCell)cell, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report)).isVisible()) continue;
                gridSection.addReportGrid((ReportGrid)newCell, 0.0, 0.0);
            }
            for (ReportElement cell : cells) {
                if (!(cell instanceof SubReportObject)) continue;
                try {
                    cell = tbl.formatCell((ReportCell)cell, 1, 1, 1, 1, this.report);
                    MatrixGriddedSection subGS = this.writeSubReport((SubReportObject)cell, tbl);
                    if (subGS == null) continue;
                    gridSection.merge(subGS);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to export sub-report", ex);
                }
            }
            this.exportGriddedSection(gridSection);
        } else {
            ReportCell[] textCells;
            cells = section.getCells();
            for (ReportCell textCell : textCells = this.getTextAndImageCells((ReportCell[])cells)) {
                Cell cell = this.createCell(textCell, (ReportCell[])cells, tbl, this.report);
                if (cell == null) continue;
                double y = this.getYPos(cell.element, false) + mergedRows.getMergedRowHeight();
                this.insertXPos(y, mergedRows.getYPos());
                y = this.getYPos(cell.element, true);
                this.insertXPos(y, mergedRows.getYPos());
                AddableCell addableCell = new AddableCell(cell);
                addableCell.setStartY(mergedRows.getMergedRowHeight());
                addableCell.setOutOfBounds(y >= section.getHeight() + mergedRows.getMergedRowHeight() + this.ROW_MINIMUM_HEIGHT);
                mergedRows.addAddableCell(addableCell);
            }
            boolean outOfSectionCell = false;
            this.insertXPos(section.getHeight() + mergedRows.getMergedRowHeight(), mergedRows.getYPos());
            for (Double yVal : mergedRows.getYPos()) {
                if (!(yVal >= section.getHeight() + mergedRows.getMergedRowHeight() + this.ROW_MINIMUM_HEIGHT)) continue;
                outOfSectionCell = true;
            }
            for (ReportElement reportElement : cells) {
                ReportImage newCell;
                if (reportElement instanceof SubReportObject) {
                    ReportCell srCell = tbl.formatCell((ReportCell)reportElement, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report);
                    if (!srCell.isVisible()) continue;
                    try {
                        MatrixGriddedSection subGS = this.writeSubReport((SubReportObject)srCell, tbl);
                        if (subGS == null) continue;
                        mergedRows.getSupplementGriddedSections().addElement(subGS);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failed to export sub-report", ex);
                    }
                    continue;
                }
                if (reportElement instanceof ReportLine) {
                    newCell = (ReportLine)tbl.formatCell((ReportCell)reportElement, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report);
                    mergedRows.addReportGridOrLine(newCell);
                    continue;
                }
                if (!(reportElement instanceof ReportGrid)) continue;
                newCell = (ReportGrid)tbl.formatCell((ReportCell)reportElement, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report);
                mergedRows.addReportGridOrLine(newCell);
            }
            mergedRows.incMergedRows();
            mergedRows.setMergedRowHeight(mergedRows.getMergedRowHeight() + section.getHeight());
            if (outOfSectionCell) {
                return mergedRows;
            }
            mergedRows.writeRows(tbl, false);
            mergedRows.resetRowData();
            if (mergedRows.getMergedRows() == 0) {
                mergedRows.writeSupplementSections();
                mergedRows = new MergedExcelRows(this);
            }
        }
        return mergedRows;
    }

    protected MergedExcelRows writeReportTable(ReportTable table, MergedExcelRows mergedRows) throws Exception {
        int[] beginPos = null;
        if (this.columnPositionMapping != null) {
            beginPos = new int[this.columnPositionMapping.length];
            for (int i = 0; i < this.columnPositionMapping.length; ++i) {
                beginPos[i] = this.columnPositionMapping[i] != null ? this.columnPositionMapping[i].getSize() : -1;
            }
        }
        if (mergedRows != null && mergedRows.getMergedRows() > 0 && table.getHeader() != null && table.getHeader().isVisible() && this.isSectionVisible(table, table.getHeader())) {
            mergedRows.writeRows(table, true);
            mergedRows.writeSupplementSections();
            mergedRows = new MergedExcelRows(this);
        }
        mergedRows = this.writeSection(table.getHeader(), table, mergedRows);
        if (table.getHeader().isRepeatOnEveryPage()) {
            this.addRepeatSection(table.getHeader(), table);
        }
        if (this.treeStructure == null) {
            this.treeStructure = new Vector();
        }
        if (table instanceof ReportTreeTable) {
            ReportTreeTable sTbl = (ReportTreeTable)table;
            for (int i = 0; i < sTbl.countSubTable(); ++i) {
                int idx;
                this.treeStructure.addElement(i);
                int n = idx = sTbl.indexArray == null ? i : sTbl.indexArray[i];
                if (sTbl.getSubTable(idx).isAggregationTable()) continue;
                mergedRows = this.writeReportTable(sTbl.getSubTable(idx), mergedRows);
            }
        } else {
            mergedRows = this.writeCells(table, mergedRows);
        }
        if (this.columnPositionMapping != null) {
            for (int i = 0; i < this.columnPositionMapping.length; ++i) {
                if (this.columnPositionMapping[i] == null) continue;
                this.columnPositionMapping[i].setStartIndex(beginPos[i]);
                this.columnPositionMapping[i].setEndIndex(this.columnPositionMapping[i].getSize());
            }
        }
        if (mergedRows == null) {
            mergedRows = new MergedExcelRows(this);
        }
        if (mergedRows.getMergedRows() > 0 && table.getFooter() != null && table.getFooter().isVisible() && this.isSectionVisible(table, table.getFooter())) {
            mergedRows.writeRows(table, true);
            mergedRows.writeSupplementSections();
            mergedRows = new MergedExcelRows(this);
        }
        mergedRows = this.writeSection(table.getFooter(), table, mergedRows);
        this.addSectionTotalPagesTableEntry();
        if (this.treeStructure.size() > 1) {
            this.treeStructure.removeElementAt(this.treeStructure.size() - 1);
        } else {
            this.treeStructure.removeAllElements();
        }
        this.addSectionTotalPagesTableEntry();
        if (table.getHeader().isRepeatOnEveryPage()) {
            this.removeRepeatSection();
        }
        return mergedRows;
    }

    private boolean isSectionVisible(ReportTable tbl, ReportSection section) {
        ReportElement[] cells = section.sortCell(2, false);
        return (cells = (ReportCell[])ReportUI.takeAwaySecuredInvisibleCols(cells, tbl, this.report.getPreviewSecurityLevel(), this.report.getReportType())).length > 0;
    }

    protected void addSectionTotalPagesTableEntry() {
        if (this.sectionTotalPagesTable != null && this.getTreeStringKey() != null && this.treeCopy.equals(this.getTreeStringKey()) && this.populateTable) {
            if (this.sectionTotalPagesTable.containsKey(this.getTreeStringKey())) {
                this.sectionTotalPages.removeElementAt(this.sectionTotalPages.size() - 1);
                this.sectionStartPage.removeElementAt(this.sectionStartPage.size() - 1);
            }
            this.sectionTotalPagesTable.put(this.getTreeStringKey(), this.currentPage);
            this.sectionTotalPages.addElement(this.currentPage);
            this.sectionStartPage.addElement(this.savedStartPage);
        }
    }

    protected MergedExcelRows writeCells(ReportTable tbl, MergedExcelRows mergedRows) throws Exception {
        MatrixGriddedSection subGS;
        double[] yPos;
        Cell cell;
        if (this.checkTotalPageNumber) {
            return null;
        }
        Color bgColor = null;
        boolean printOnNewPage = false;
        boolean visible = false;
        if (tbl.getScriptObj() != null) {
            bgColor = tbl.getBgColor();
            printOnNewPage = tbl.isPrintOnNewPage();
            visible = tbl.isVisible();
            tbl.getScriptObj().applyScript(tbl, 1, 1, 1, 1, this.report, tbl);
        }
        if (!tbl.isVisible()) {
            return mergedRows;
        }
        if (mergedRows == null) {
            mergedRows = new MergedExcelRows(this);
        }
        int nRow = tbl.getRowCount();
        ReportImage[] images = tbl.getImage();
        ReportRTFObject[] rtfObjects = tbl.getSortedRTFObjects();
        SubReportObject[] subReports = tbl.getSortedSubReports();
        ReportSection masterSection = tbl.getMasterSection();
        if (!this.hasNoData(masterSection) && (this.reportWidth < 0.0 || masterSection.getX() + masterSection.getWidth() <= this.reportWidth + this.PRECISION)) {
            MatrixGriddedSection masterGriddedSection = this.writeMasterSection(masterSection, tbl);
            if (this.reportHeight < 0.0 || this.globalGriddedSection.getTotalHeight() + masterGriddedSection.getTotalHeight() <= this.reportHeight) {
                mergedRows.getSupplementGriddedSections().addElement(masterGriddedSection);
            }
        }
        for (ReportRTFObject rtfObject : rtfObjects) {
            cell = this.createCell(rtfObject, null, tbl, this.report);
            if (cell == null) continue;
            yPos = new double[]{0.0, cell.element.getY(), cell.element.getY() + cell.element.getHeight()};
            subGS = new MatrixGriddedSection(this, tbl, null, this.rownum, this.xPositions, yPos);
            subGS.add(cell);
            if (!(this.reportHeight < 0.0) && !(this.globalGriddedSection.getTotalHeight() + subGS.getTotalHeight() <= this.reportHeight)) continue;
            mergedRows.getSupplementGriddedSections().addElement(subGS);
        }
        for (ReportImage image : images) {
            cell = this.createCell(image, null, tbl, this.report);
            if (cell == null) continue;
            yPos = new double[]{cell.element.getY(), cell.element.getY() + cell.element.getHeight()};
            subGS = new MatrixGriddedSection(this, tbl, null, this.rownum, this.xPositions, yPos);
            subGS.add(cell);
            if (!(this.reportHeight < 0.0) && !(this.globalGriddedSection.getTotalHeight() + subGS.getTotalHeight() <= this.reportHeight)) continue;
            mergedRows.getSupplementGriddedSections().addElement(subGS);
        }
        for (SubReportObject subReport : subReports) {
            MatrixGriddedSection subGS2;
            ReportCell subreportCell = tbl.formatCell(subReport, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report);
            if (subreportCell == null || !subreportCell.isVisible() || (subGS2 = this.writeSubReport(subReport, tbl)) == null || !(this.reportHeight < 0.0) && !(this.globalGriddedSection.getTotalHeight() + subGS2.getTotalHeight() <= this.reportHeight)) continue;
            mergedRows.getSupplementGriddedSections().addElement(subGS2);
        }
        if (mergedRows.getSupplementGriddedSections().size() > 0) {
            this.columnPositionMapping = null;
        }
        ReportTable orgTable = tbl;
        this.rows = orgTable.getFormattedRows();
        for (int i = 0; i < nRow; ++i) {
            ReportImage[] rptImages;
            int j;
            int ii = i;
            if (tbl.indexArray != null) {
                ii = tbl.indexArray[i];
            }
            if ((tbl = this.resizeTable(this.reportGraphics, orgTable, ii)) == orgTable) {
                tbl = ReportUI.copySectionForSecuredInvisibleCols(tbl, this.report.getPreviewSecurityLevel());
            }
            ReportElement[] columns = tbl.getSortedVisibleColumns();
            columns = (ReportColumn[])ReportUI.takeAwaySecuredInvisibleCols(columns, this.report.getPreviewSecurityLevel(), this.report.getReportType());
            if (this.rowElements == null && !tbl.hasVisibleElements() && i > 0) continue;
            int rowElementCount = 0;
            if (this.rowElements != null) {
                rowElementCount = this.rowElements.size();
            }
            ReportElement[] elements = new ReportElement[columns.length + rowElementCount];
            for (j = 0; j < columns.length; ++j) {
                elements[j] = columns[j];
            }
            if (this.rowElements != null) {
                for (j = 0; j < this.rowElements.size(); ++j) {
                    elements[j + columns.length] = this.rowElements.elementAt(j);
                }
            }
            boolean outOfSectionCell = false;
            double tblH = tbl.getHeight();
            for (ReportElement element : elements) {
                Cell cell2 = null;
                if (element instanceof ReportColumn) {
                    cell2 = this.createCell((ReportColumn)element, ii, i, tbl, this.report);
                    if (cell2 != null) {
                        cell2.columnIndex = tbl.getColumnIndex((ReportColumn)element);
                    }
                } else if (element instanceof ReportCell) {
                    cell2 = this.createCell((ReportCell)element, null, tbl, this.report);
                }
                if (cell2 == null || !cell2.element.isVisible()) continue;
                double y = this.getYPos(cell2.element, false) + mergedRows.getMergedRowHeight();
                this.insertXPos(y, mergedRows.getYPos());
                y = this.getYPos(cell2.element, true) + mergedRows.getMergedRowHeight();
                this.insertXPos(y, mergedRows.getYPos());
                AddableCell addableCell = new AddableCell(cell2);
                addableCell.setStartY(mergedRows.getMergedRowHeight());
                addableCell.setOutOfBounds(y >= tblH + mergedRows.getMergedRowHeight() + this.ROW_MINIMUM_HEIGHT);
                mergedRows.addAddableCell(addableCell);
            }
            if (mergedRows.getAddableCells().size() > 0) {
                this.insertXPos(tblH + mergedRows.getMergedRowHeight(), mergedRows.getYPos());
            }
            for (Double yVal : mergedRows.getYPos()) {
                if (!(yVal >= tblH + mergedRows.getMergedRowHeight() + this.ROW_MINIMUM_HEIGHT)) continue;
                outOfSectionCell = true;
            }
            for (ReportImage img : rptImages = tbl.getImage()) {
                if (!(img instanceof ReportLine) && !(img instanceof ReportGrid)) continue;
                ReportImage newImg = (ReportImage)tbl.formatCell(img, ii, this.getPage(), 1, this.getTotalPageNumber(), 1, this.report, false);
                mergedRows.addReportGridOrLine(newImg);
            }
            mergedRows.incMergedRows();
            mergedRows.setMergedRowHeight(mergedRows.getMergedRowHeight() + tblH);
            if (outOfSectionCell) continue;
            mergedRows.writeRows(tbl, false);
            mergedRows.resetRowData();
        }
        if (mergedRows.getMergedRows() == 0) {
            mergedRows.writeSupplementSections();
            mergedRows = new MergedExcelRows(this);
        }
        if (tbl.getScriptObj() != null) {
            tbl.setBgColor(bgColor);
            tbl.setPrintOnNewPage(printOnNewPage);
            tbl.setVisible(visible);
        }
        return mergedRows;
    }

    private boolean hasNoData(ReportSection section) {
        return section == null || section.hasNoDrawableData();
    }

    protected void exportGriddedSection(MatrixGriddedSection section) throws Exception {
        this.rownum += section.getRowCount();
        if (this.reportWidth >= 0.0) {
            if (this.reportHeight >= 0.0 && this.globalGriddedSection.getTotalHeight() + section.getTotalHeight() > this.reportHeight) {
                throw new Exception("No page break for subreport.");
            }
            this.globalGriddedSection.append(section);
        } else {
            section.export(this.sheet);
        }
    }

    protected ReportCell[] getTextCells(ReportCell[] cells) {
        Vector<ReportCell> textCells = new Vector<ReportCell>();
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i] instanceof ReportImage || cells[i] instanceof SubReportObject) continue;
            textCells.addElement(cells[i]);
        }
        ReportCell[] tmp = new ReportCell[textCells.size()];
        for (int i = 0; i < textCells.size(); ++i) {
            tmp[i] = (ReportCell)textCells.elementAt(i);
        }
        return tmp;
    }

    protected ReportCell[] getTextAndImageCells(ReportCell[] cells) {
        Vector<ReportCell> textAndImageCells = new Vector<ReportCell>();
        for (ReportCell cell : cells) {
            if (cell instanceof SubReportObject || cell instanceof ReportLine || cell instanceof ReportGrid) continue;
            textAndImageCells.addElement(cell);
        }
        ReportCell[] tmp = new ReportCell[textAndImageCells.size()];
        for (int i = 0; i < textAndImageCells.size(); ++i) {
            tmp[i] = (ReportCell)textAndImageCells.elementAt(i);
        }
        return tmp;
    }

    private void getXPos(Report report, Vector<Double> xPoss, double leftMargin, double width) {
        ReportTable table = null;
        Vector<ReportTable> vec = report.getReportTables();
        if (vec.size() > 0) {
            table = vec.elementAt(0);
        }
        this.getXPos(report.getPageHeader(), xPoss, leftMargin, width, table);
        this.getXPos(report.getReportHeader(), xPoss, leftMargin, width, table);
        this.getXPos(table, xPoss, leftMargin, width);
        this.getXPos(report.getReportFooter(), xPoss, leftMargin, width, table);
        this.getXPos(report.getPageFooter(), xPoss, leftMargin, width, table);
    }

    private void getXPos(ReportSection section, Vector<Double> xPoss, double margin, double width, ReportTable table) {
        if (section == null) {
            return;
        }
        if (section.isVisible() && !section.hasNoDrawableData()) {
            ReportCell[] cells;
            for (ReportCell cell : cells = section.getCells()) {
                int rightColumnIndex;
                if (!cell.isVisible() || !(width < 0.0) && !(cell.getX() + cell.getWidth() <= width + this.PRECISION)) continue;
                if (cell instanceof SubReportObject) {
                    try {
                        Report sreport;
                        SubReportObject subReport = (SubReportObject)cell;
                        if (subReport.hasUsableReport()) {
                            sreport = subReport.getSubReport().getReportInfo();
                            if (sreport.getQueryParams().size() != 0) {
                                sreport = subReport.reloadReportWithParameters(sreport, this.report, table);
                            } else if (sreport.dbInfo.getDriverName() != null) {
                                sreport = subReport.loadReport(this.report, table);
                            } else {
                                try {
                                    Report temp = ReloadReport.reloadData(new Report(sreport), false);
                                    if (temp != null) {
                                        sreport = temp;
                                    }
                                }
                                catch (Exception ex) {
                                    sreport.getReportTables().elementAt(0).setVisible(false);
                                    subReport.setHeight(0.0);
                                    this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                                }
                            }
                        } else {
                            sreport = subReport.loadReport(this.report, table);
                        }
                        this.getXPos(sreport, xPoss, cell.getX() + margin, cell.getWidth());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to load sub-report", ex);
                    }
                    continue;
                }
                if (!Report.Excel_fitCell && !this.limitExcelCellSplit) {
                    double x = this.getXPos(cell, false);
                    this.insertXPos(x + margin, xPoss);
                    x = this.getXPos(cell, true);
                    this.insertXPos(x + margin, xPoss);
                    continue;
                }
                if (this.tableDataOnly) continue;
                double[] temp = new double[xPoss.size()];
                for (int j = 0; j < xPoss.size(); ++j) {
                    temp[j] = xPoss.elementAt(j);
                }
                double x = this.getXPos(cell, false);
                if (x + margin < this.columnMinXPos || x + margin > this.columnMaxXPos) {
                    this.insertXPos(x + margin, xPoss);
                }
                int leftColumnIndex = this.getMatchIndexHelper(x, temp);
                double x2 = this.getXPos(cell, true);
                if (x2 + margin < this.columnMinXPos || x2 + margin > this.columnMaxXPos) {
                    this.insertXPos(x2 + margin, xPoss);
                }
                if (leftColumnIndex != (rightColumnIndex = this.getMatchIndexHelper(x2, temp))) continue;
                this.insertXPos(x + margin, xPoss);
                this.insertXPos(x2 + margin, xPoss);
            }
        }
        for (int i = 0; i < section.getSectionCount(); ++i) {
            try {
                this.getXPos(section.getSection(i), xPoss, margin, width, table);
                continue;
            }
            catch (Exception ex) {
                LOGGER.finest("Cannot get XPos");
            }
        }
    }

    private void getXPos(ReportTable table, Vector<Double> xPoss, double margin, double width) {
        if (table == null) {
            return;
        }
        if (table.isVisible()) {
            ReportElement[] cells;
            for (ReportElement cell : cells = table.getTableElements()) {
                if (!cell.isVisible() || !(width < 0.0) && !(cell.getX() + cell.getWidth() <= width + this.PRECISION)) continue;
                if (cell instanceof SubReportObject) {
                    try {
                        Report sreport = null;
                        SubReportObject subReport = (SubReportObject)cell;
                        if (subReport.hasUsableReport()) {
                            sreport = subReport.getSubReport().getReportInfo();
                            if (sreport.getQueryParams().size() != 0) {
                                sreport = subReport.reloadReportWithParameters(sreport, this.report, table);
                            } else if (sreport.dbInfo.getDriverName() != null) {
                                sreport = subReport.loadReport(this.report, table);
                            } else {
                                try {
                                    Report temp = ReloadReport.reloadData(new Report(sreport), false);
                                    if (temp != null) {
                                        sreport = temp;
                                    }
                                }
                                catch (Exception ex) {
                                    sreport.getReportTables().elementAt(0).setVisible(false);
                                    subReport.setHeight(0.0);
                                    this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                                }
                            }
                        } else {
                            sreport = subReport.loadReport(this.report, table);
                        }
                        this.getXPos(sreport, xPoss, cell.getX() + margin, cell.getWidth());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Cannot get XPos", ex);
                    }
                    continue;
                }
                double x = this.getXPos(cell, false);
                this.insertXPos(x + margin, xPoss);
                if (this.columnMinXPos == -1.0 || x + margin < this.columnMinXPos) {
                    this.columnMinXPos = x + margin;
                }
                if (x + margin > this.columnMaxXPos) {
                    this.columnMaxXPos = x + margin;
                }
                x = this.getXPos(cell, true);
                this.insertXPos(x + margin, xPoss);
                if (this.columnMinXPos == -1.0 || x + margin < this.columnMinXPos) {
                    this.columnMinXPos = x + margin;
                }
                if (!(x + margin > this.columnMaxXPos)) continue;
                this.columnMaxXPos = x + margin;
            }
        }
        if (table.getMasterSection() != null && (width < 0.0 || table.getMasterSection().getX() + table.getMasterSection().getWidth() < width)) {
            this.getXPos(table.getMasterSection(), xPoss, table.getMasterSection().getX() + margin, table.getMasterSection().getWidth(), table);
        }
        this.getXPos(table.getHeader(), xPoss, margin, width, table);
        this.getXPos(table.getFooter(), xPoss, margin, width, table);
        if (table instanceof ReportMultiSectionTable) {
            int i;
            ReportMultiSectionTable mTable = (ReportMultiSectionTable)table;
            for (i = 0; i < mTable.countRowBreakHeader(); ++i) {
                this.getXPos(mTable.getRowBreakHeader(i), xPoss, margin, width, table);
            }
            for (i = 0; i < mTable.countRowBreakFooter(); ++i) {
                this.getXPos(mTable.getRowBreakFooter(i), xPoss, margin, width, table);
            }
        }
    }

    private double getXPos(ReportElement elt, boolean withWidth) {
        if (!(elt instanceof SubReportObject)) {
            if (withWidth) {
                return elt.getX() + elt.getWidth();
            }
            return elt.getX();
        }
        return 0.0;
    }

    private double getYPos(ReportElement elt, boolean withHeight) {
        if (!(elt instanceof SubReportObject)) {
            if (withHeight) {
                return elt.getY() + elt.getHeight();
            }
            return elt.getY();
        }
        return 0.0;
    }

    protected void insertXPos(double x, Vector<Double> xPoss) {
        Double d = x;
        if (!xPoss.contains(d)) {
            for (int i = 0; i < xPoss.size(); ++i) {
                Double d1 = xPoss.elementAt(i);
                if (!(d1 > x)) continue;
                xPoss.insertElementAt(d, i);
                return;
            }
            xPoss.addElement(d);
        }
    }

    private Vector<Double> groupPositions(Vector<Double> xPoss) {
        Vector<Double> vec = new Vector<Double>();
        vec.addElement(0.0);
        if (xPoss == null) {
            return vec;
        }
        if (!Report.Excel_fitCell && !this.limitExcelCellSplit) {
            double tick = 0.5;
            double max = 0.0;
            int i = 0;
            if (xPoss.size() > 0) {
                max = xPoss.elementAt(xPoss.size() - 1) + 1.5;
            }
            while (tick < max) {
                while (i < xPoss.size() && xPoss.elementAt(i) < tick) {
                    ++i;
                }
                if (i >= xPoss.size()) {
                    xPoss.addElement(tick);
                } else {
                    xPoss.insertElementAt(tick, i);
                }
                tick += 0.5;
            }
        }
        double interval = 0.0;
        double maxColumns = this.wb instanceof HSSFWorkbook ? 256.0 : 16384.0;
        while ((double)(vec = this.groupPositionHelper(xPoss, interval += this.COL_MINIMUM_WIDTH)).size() > maxColumns) {
        }
        return vec;
    }

    protected Vector<Double> groupPositionHelper(Vector<Double> xPoss, double interval) {
        double currentMin = -1.0;
        double currentMax = -1.0;
        Vector<Double> vec = new Vector<Double>();
        vec.addElement(0.0);
        for (int i = 0; i < xPoss.size(); ++i) {
            double d = xPoss.elementAt(i);
            if (!(d > interval)) continue;
            if (currentMin == -1.0) {
                currentMin = d;
                currentMax = d;
                continue;
            }
            if (d <= currentMin + interval) {
                currentMax = d;
                continue;
            }
            vec.addElement((currentMin + currentMax) / 2.0);
            currentMin = d;
            currentMax = d;
        }
        if (currentMin != -1.0 && currentMax != -1.0) {
            vec.addElement((currentMin + currentMax) / 2.0);
        }
        return vec;
    }

    protected int getMatchIndexHelper(double x, double[] xPoss) {
        if (x < 0.0) {
            return 0;
        }
        for (int i = 0; i < xPoss.length - 1; ++i) {
            if (!(Math.abs(x - xPoss[i]) <= Math.abs(x - xPoss[i + 1]))) continue;
            return i;
        }
        return xPoss.length - 1;
    }

    protected void imposeBorderProperties(Cell dest, Cell source, boolean top, boolean left, boolean bottom, boolean right) {
        if (source.top && top) {
            dest.top = source.top;
            dest.topColor = source.topColor;
            dest.topStyle = source.topStyle;
        }
        if (source.left && left) {
            dest.left = source.left;
            dest.leftColor = source.leftColor;
            dest.leftStyle = source.leftStyle;
        }
        if (source.bottom && bottom) {
            dest.bottom = source.bottom;
            dest.bottomColor = source.bottomColor;
            dest.bottomStyle = source.bottomStyle;
        }
        if (source.right && right) {
            dest.right = source.right;
            dest.rightColor = source.rightColor;
            dest.rightStyle = source.rightStyle;
        }
    }

    public CellStyle getCellStyle(ExcelCellStyle excelCellStyle) {
        CellStyle cellStyle = this.cellStyleCache.get(excelCellStyle);
        if (cellStyle == null) {
            cellStyle = this.wb.createCellStyle();
            excelCellStyle.applyTo(cellStyle, this);
            this.cellStyleCache.put(excelCellStyle, cellStyle);
        }
        return cellStyle;
    }

    private Cell createCell(ReportCell cell, ReportCell[] cells, ReportTable table, Report report) {
        if (cell instanceof TableOfContents) {
            return null;
        }
        try {
            Object dataobj;
            if (cell instanceof ReportRTFObject) {
                ReportElement securityLevel = cell.getSecurityLevel(report.getPreviewSecurityLevel());
                if (securityLevel != null && !securityLevel.isVisible()) {
                    return null;
                }
                ReportCell clone = ReportCell.clone(cell);
                String fullText = ((ReportRTFObject)cell).getFullText(report, table);
                if (fullText == null) {
                    fullText = "";
                }
                clone.setAlign(cell.getAlign());
                if (clone.getRefFont() != null) {
                    clone.setFont(FontTable.newFont(clone.getRefFont().getName(), 0, clone.getRefFont().getSize()));
                    if (cell.isResizeToFitContent()) {
                        clone.setHeight(this.estimateRtfObjectHeight((ReportRTFObject)clone, table, null));
                    }
                }
                if (this.reportWidth >= 0.0 && clone.getX() + clone.getWidth() > this.reportWidth + this.PRECISION) {
                    return null;
                }
                return new Cell(fullText, clone);
            }
            ReportCell newCell = table.formatCell(cell, this.getPage(), 1, this.getTotalPageNumber(), 1, report);
            if (newCell.getScriptedValue() != null) {
                dataobj = newCell.getScriptedValue();
            } else if ((cell.getFormulaName() != null || cell.getFormulaObj() != null || cell.getFormula() != null) && cell.getSecurityLevel(report.getPreviewSecurityLevel()) == null) {
                dataobj = table.getValue(cell, 1, 1, 1, 1, report);
                if (dataobj != null && dataobj instanceof Date && !DateUtil.isValidExcelDate((double)DateUtil.getExcelDate((Date)((Date)dataobj)))) {
                    dataobj = "";
                }
            } else {
                dataobj = newCell.getText();
                if (newCell.getFontColor() == null) {
                    dataobj = "";
                }
            }
            if (dataobj == null || dataobj instanceof String || dataobj instanceof Boolean) {
                dataobj = newCell.getText();
                if (newCell.getFontColor() == null) {
                    dataobj = "";
                }
            }
            if (dataobj != null && dataobj.equals("Q#B#S#V#S#T#N")) {
                dataobj = null;
            }
            if (newCell instanceof ReportChartObject) {
                this.addChartRecord((ReportChartObject)newCell, new ExcelChartRecord(report, table, cells));
            }
            if (this.reportWidth >= 0.0 && newCell.getX() + newCell.getWidth() > this.reportWidth + this.PRECISION) {
                return null;
            }
            Cell c = new Cell(dataobj, newCell);
            return c;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create cell", ex);
            return null;
        }
    }

    private double estimateRtfObjectHeight(ReportRTFObject rtfObject, ReportTable table, ReportSection section) throws Exception {
        ReportGraphics temp_rg = this.reportUI.getReportGraphics();
        double[] res = temp_rg.drawCell(this.report, table, null, rtfObject, section, 0.0, 0.0, 0);
        return res[0];
    }

    private Cell createCell(ReportColumn cell, int rowIndex, int displayIndex, ReportTable table, Report report) {
        try {
            ReportCell newCell = table.formatCell(cell, rowIndex, this.getPage(), 1, this.getTotalPageNumber(), 1, displayIndex, report);
            Object dataobj = cell.getData(rowIndex);
            if (newCell.getScriptedValue() != null) {
                dataobj = newCell.getScriptedValue();
            }
            if (dataobj != null && dataobj instanceof Date && !DateUtil.isValidExcelDate((double)DateUtil.getExcelDate((Date)((Date)dataobj)))) {
                dataobj = "";
            }
            if (dataobj == null || dataobj instanceof String || dataobj instanceof Boolean || dataobj instanceof ReportDocument) {
                dataobj = newCell.getText();
                if (newCell.getFontColor() == null) {
                    dataobj = "";
                }
            }
            if (dataobj != null && dataobj.equals("Q#B#S#V#S#T#N")) {
                dataobj = null;
            }
            if (this.reportWidth >= 0.0 && newCell.getX() + newCell.getWidth() > this.reportWidth + this.PRECISION) {
                return null;
            }
            Cell c = new Cell(dataobj, newCell);
            c.isColumnCell = true;
            return c;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create cell", ex);
            return null;
        }
    }

    private MatrixGriddedSection writeSubReport(SubReportObject subReport, ReportTable tbl) throws Exception {
        if (subReport == null) {
            return null;
        }
        ReportElement securityLevel = subReport.getSecurityLevel(this.report.getPreviewSecurityLevel());
        if (securityLevel != null && !securityLevel.isVisible()) {
            return null;
        }
        Report sreport = null;
        if (subReport.hasUsableReport()) {
            sreport = subReport.getSubReport().getReportInfo();
            if (sreport.getQueryParams().size() != 0) {
                sreport = subReport.reloadReportWithParameters(sreport, this.report, tbl);
            } else if (sreport.dbInfo.getDriverName() != null) {
                sreport = subReport.loadReport(this.report, tbl);
            } else {
                try {
                    Report temp = ReloadReport.reloadData(new Report(sreport), false);
                    if (temp != null) {
                        sreport = temp;
                    }
                }
                catch (Exception ex) {
                    sreport.getReportTables().elementAt(0).setVisible(false);
                    subReport.setHeight(0.0);
                    this.report.setInitializeReportError(LanguageEncoder.getText("Subreport datasource not found!") + "\n" + IOUtil.getStackTrace(ex));
                }
            }
        } else {
            sreport = subReport.loadReport(this.report, tbl);
        }
        double sreportHeight = -1.0;
        if (!subReport.isResizeToFitContent()) {
            sreportHeight = subReport.getHeight() + subReport.getY();
        }
        ExcelSubReport excelSub = new ExcelSubReport(sreport, subReport.getX(), subReport.getY(), subReport.getWidth(), sreportHeight, this.xPositions, this);
        MatrixGriddedSection subResults = excelSub.run();
        this.report.addTriggeredAlerts(sreport.getTriggeredAlerts(), sreport.getFileNameWithoutPath());
        return subResults;
    }

    protected short toTwips(double inch) {
        return (short)((int)Math.rint(inch * 20.0 * 72.0) / 15 * 15);
    }

    protected short findFormat(Object obj, IFormat format) {
        if (format == null) {
            return 0;
        }
        if (format instanceof LocaleNumericFormat) {
            int i;
            NumberFormat f = ((LocaleNumericFormat)format).getNumberFormat();
            int minFraction = f.getMinimumFractionDigits();
            if ((obj instanceof BigDecimal || obj instanceof Double || obj instanceof Float) && f.getMaximumFractionDigits() > 0 && minFraction <= 0 && ((Number)obj).doubleValue() % 1.0 != 0.0) {
                minFraction = 1;
            }
            StringBuffer fstring = new StringBuffer();
            for (i = 0; i < f.getMinimumIntegerDigits(); ++i) {
                fstring.insert(0, "0");
                if ((i + 1) % 3 != 0 || !f.isGroupingUsed()) continue;
                fstring.insert(0, ",");
            }
            if (fstring.length() < 3 && f.isGroupingUsed()) {
                while (fstring.length() < 3) {
                    fstring.insert(0, "#");
                }
                fstring.insert(0, ",");
            }
            fstring.insert(0, "#");
            if (minFraction > 0) {
                fstring.append(".0");
                for (i = 1; i < minFraction; ++i) {
                    fstring.append("0");
                }
                for (i = minFraction; i < f.getMaximumFractionDigits(); ++i) {
                    fstring.append("#");
                }
            }
            if (((LocaleNumericFormat)format).getInstanceType() == 2) {
                fstring.append("\"%\"");
            }
            if (((LocaleNumericFormat)format).getInstanceType() == 0 && IOUtil.isJava14()) {
                fstring.insert(0, PrintUtil.getCurrency((LocaleNumericFormat)format));
            }
            return this.dataFormat.getFormat(fstring.toString() + ";-" + fstring.toString());
        }
        if (format instanceof NumericFormat) {
            NumericFormat f = (NumericFormat)format;
            if (!f.sciExp) {
                StringBuffer fstring = new StringBuffer();
                if (f.leadingZero) {
                    fstring.insert(0, "0");
                }
                if (f.thousandSep != 'N') {
                    while (fstring.length() < 3) {
                        fstring.insert(0, "#");
                    }
                    fstring.insert(0, ",");
                }
                fstring.insert(0, "#");
                if (f.decimal > 0) {
                    fstring.append(".");
                    for (int i = 0; i < f.decimal; ++i) {
                        fstring.append("0");
                    }
                }
                String currencyString = "";
                String prefix = "";
                if (f.currencySymbol != ' ') {
                    currencyString = "\"" + f.currencySymbol + "\"";
                }
                if (f.currencyPos == 0) {
                    prefix = currencyString;
                }
                String neg_prefix = prefix;
                if (f.negative == 0) {
                    neg_prefix = neg_prefix + "-";
                } else if (f.negative == 2) {
                    neg_prefix = neg_prefix + "(";
                }
                if (f.currencyPos == 1) {
                    prefix = prefix + currencyString;
                    neg_prefix = neg_prefix + currencyString;
                }
                StringBuffer neg_string = new StringBuffer(fstring.toString());
                fstring.insert(0, prefix);
                neg_string.insert(0, neg_prefix);
                prefix = "";
                neg_prefix = "";
                if (f.currencyPos == 2) {
                    prefix = currencyString;
                }
                neg_prefix = prefix;
                if (f.negative == 1) {
                    neg_prefix = neg_prefix + "-";
                } else if (f.negative == 2) {
                    neg_prefix = neg_prefix + ")";
                }
                if (f.currencyPos == 3) {
                    prefix = prefix + currencyString;
                    neg_prefix = neg_prefix + currencyString;
                }
                fstring.append(prefix);
                neg_string.append(neg_prefix);
                return this.dataFormat.getFormat(fstring.toString() + ";" + neg_string.toString());
            }
            StringBuffer fstring = new StringBuffer("0.0");
            for (int i = 1; i < f.decimal; ++i) {
                fstring.append("0");
            }
            fstring.append("E+00");
            return this.dataFormat.getFormat(fstring.toString() + ";-" + fstring.toString());
        }
        if (format instanceof DateTimeFormat) {
            boolean includeTime = false;
            boolean includeDate = false;
            DateTimeFormat f = (DateTimeFormat)format;
            if (obj instanceof Time) {
                includeTime = true;
            } else if (obj instanceof Timestamp) {
                if (!(f.hideyear && f.hidemonth && f.hidedate)) {
                    includeDate = true;
                }
                if (!f.hideTimestampTime) {
                    includeTime = true;
                }
            } else if (!(!(obj instanceof Date) || f.hideyear && f.hidemonth && f.hidedate)) {
                includeDate = true;
            }
            StringBuffer dstring = new StringBuffer();
            if (includeDate) {
                String year = "yy";
                if (f.yearSymbol == 0) {
                    year = "yyyy";
                }
                String month = "m";
                if (f.monthSymbol == 1) {
                    month = "mmm";
                } else if (f.monthSymbol == 2) {
                    month = "mmmm";
                } else if (f.fixDigitLen) {
                    month = "mm";
                }
                String day = "d";
                if (f.fixDigitLen) {
                    day = "dd";
                }
                if (f.orderSymbol == 0 && !f.hidemonth) {
                    dstring.append(month);
                } else if (f.orderSymbol == 1 && !f.hidedate) {
                    dstring.append(day);
                } else if (f.orderSymbol == 2 && !f.hideyear) {
                    dstring.append(year);
                }
                String separator = "";
                if (dstring.length() > 0) {
                    separator = "\"" + f.separator1 + "\"";
                }
                if (f.orderSymbol == 0 && !f.hidedate) {
                    dstring.append(separator).append(day);
                } else if (!(f.orderSymbol != 1 && f.orderSymbol != 2 || f.hidemonth)) {
                    dstring.append(separator).append(month);
                }
                separator = "";
                if (dstring.length() > 0) {
                    separator = "\"" + f.separator2 + "\"";
                }
                if (f.orderSymbol == 2 && !f.hidedate) {
                    dstring.append(separator).append(day);
                } else if (!(f.orderSymbol != 1 && f.orderSymbol != 0 || f.hideyear)) {
                    dstring.append(separator).append(year);
                }
            }
            StringBuffer tstring = new StringBuffer();
            if (includeTime) {
                tstring.append("h");
                if (f.fixDigitLen) {
                    tstring.append("h");
                }
                if (f.showMinute) {
                    tstring.append("\"").append(f.hourMinuteSep).append(f.fixDigitLen ? "\"mm" : "\"m");
                    if (f.showSecond) {
                        tstring.append("\"").append(f.minuteSecondSep).append(f.fixDigitLen ? "\"ss" : "\"s");
                    }
                }
                if (!f.hour24) {
                    tstring.append("AM/PM");
                }
            }
            if (includeTime || includeDate) {
                if (includeTime && includeDate) {
                    if (f.timeBeforeDate) {
                        return this.dataFormat.getFormat(tstring.toString() + "\"" + f.timeDateSep + "\"" + dstring.toString());
                    }
                    return this.dataFormat.getFormat(dstring.toString() + "\"" + f.timeDateSep + "\"" + tstring.toString());
                }
                if (includeDate) {
                    return this.dataFormat.getFormat(dstring.toString());
                }
                return this.dataFormat.getFormat(tstring.toString());
            }
        } else if (format instanceof LocaleDateTimeFormat) {
            DateFormat dateFormat = ((LocaleDateTimeFormat)format).getDateFormat();
            Locale locale = ((LocaleDateTimeFormat)format).getLocale();
            String excelFormat = DateFormatConverter.convert((Locale)locale, (DateFormat)dateFormat);
            return this.dataFormat.getFormat(excelFormat);
        }
        return 0;
    }

    protected short getColorIndex(Color color) {
        if (color == null) {
            return 8;
        }
        for (int i = 0; i < this.colorMap.size(); ++i) {
            Color sColor = this.colorMap.elementAt(i);
            if (sColor.getRed() != color.getRed() || sColor.getBlue() != color.getBlue() || sColor.getGreen() != color.getGreen()) continue;
            return (short)(i + 8);
        }
        if (this.colorMap.size() >= 56) {
            return 8;
        }
        this.palette.setColorAtIndex((short)(this.colorMap.size() + 8), (byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
        this.colorMap.addElement(color);
        return (short)(this.colorMap.size() + 7);
    }

    protected Font getFont(java.awt.Font font, Color color, boolean isUnderline) {
        Vector<Serializable> vect = new Vector<Serializable>();
        vect.addElement(font);
        vect.addElement(color);
        vect.addElement(Boolean.valueOf(isUnderline));
        Font hf = this.fontMap.get(vect);
        if (hf != null) {
            return hf;
        }
        hf = this.wb.createFont();
        String fontName = font.getName();
        if (font.getName().equalsIgnoreCase("Monospaced") || font.getName().equalsIgnoreCase("DialogInput")) {
            fontName = "Courier New";
        } else if (font.getName().equalsIgnoreCase("Serif")) {
            fontName = "Times New Roman";
        } else if (font.getName().equalsIgnoreCase("Dialog")) {
            fontName = "Arial";
        }
        hf.setFontName(fontName);
        short fontsize = (short)QbUtil.resizeExportFont(font.getSize(), this.report.isAdjustFont());
        hf.setFontHeightInPoints(fontsize);
        if (hf instanceof XSSFFont) {
            if (color == null) {
                hf.setColor((short)8);
            } else {
                ((XSSFFont)hf).setColor(new XSSFColor(color, (IndexedColorMap)new DefaultIndexedColorMap()));
            }
        } else {
            hf.setColor(this.getColorIndex(color));
        }
        boolean bold = false;
        if (font.isBold()) {
            bold = true;
        }
        hf.setBold(bold);
        hf.setItalic(font.isItalic());
        if (isUnderline) {
            hf.setUnderline((byte)1);
        }
        this.fontMap.put(vect, hf);
        return hf;
    }

    protected ReportSection resizeSection(ReportGraphics g, ReportSection _sec, ReportTable tbl) throws Exception {
        int i;
        Report temp_report = this.report;
        boolean shift = false;
        ReportSection sec = new ReportSection();
        boolean resize = false;
        boolean copied = false;
        if (this.treeStructure != null) {
            if (_sec.hasFormattedCell(this.treeStructure)) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                Hashtable<Integer, ReportCell> cellTable = sec.getFormattedCells(this.treeStructure);
                ReportCell[] cell = sec.getCells();
                for (int i2 = 0; i2 < cell.length; ++i2) {
                    ReportCell formattedCell;
                    if (!cellTable.containsKey(i2)) continue;
                    cell[i2] = formattedCell = cellTable.get(i2);
                }
                resize = true;
                shift = true;
            }
            if (_sec.hasSectionCells(this.treeStructure)) {
                Vector<ReportCell> sectionCells = _sec.getSectionCells(this.treeStructure);
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                if (sectionCells != null) {
                    for (int i3 = 0; i3 < sectionCells.size(); ++i3) {
                        sec.addData(sectionCells.elementAt(i3));
                    }
                }
                resize = true;
                shift = true;
            }
            if (_sec.getHeight(this.treeStructure) > 0.0) {
                if (!copied) {
                    sec.deepCopy(_sec);
                }
                copied = true;
                sec.setHeight(_sec.getHeight(this.treeStructure));
                resize = true;
                shift = true;
            }
        }
        for (i = 0; i < _sec.getCellCount() && !resize; ++i) {
            if (!_sec.getData(i).isVisible() || !_sec.getData(i).isResizeToFitContent()) continue;
            if (!copied) {
                sec.deepCopy(_sec);
            }
            copied = true;
            resize = true;
        }
        if (resize) {
            for (i = 0; i < sec.getCellCount(); ++i) {
                ReportCell element = sec.getData(i);
                if (!element.isResizeToFitContent()) continue;
                if (element instanceof SubReportObject || element instanceof TableOfContents || element instanceof ReportRTFObject) {
                    shift = true;
                }
                ReportCell cell = tbl.formatCell(element, this.getPage(), 1, this.getTotalPageNumber(), 1, temp_report);
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject) {
                    h = this.estimateRtfObjectHeight((ReportRTFObject)cell, tbl, sec);
                } else if (cell instanceof TableOfContents || cell instanceof SubReportObject) {
                    h = cell.getHeight();
                }
                if ((cell instanceof TableOfContents || cell instanceof SubReportObject) && _sec.getBgColor() != null) {
                    ReportGraphics temp_rg = this.reportUI.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, sec, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportSection.resizeVerticallyAndShift((ReportElement)element, sec, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = sec.getMinHeight();
            if (sec.getHeight() < minH) {
                if (sec.isResizeToFitContent()) {
                    double increase = ReportUI.getMaxIncreaseProportion(_sec, sec);
                    for (int i4 = 0; i4 < sec.getCellCount(); ++i4) {
                        if (sec.getData(i4) instanceof ReportLine && ((ReportLine)sec.getData(i4)).isVertical() && ((ReportLine)sec.getData(i4)).next() != null) {
                            sec.getData(i4).setHeight(sec.getMinHeight() - sec.getData(i4).getY());
                            continue;
                        }
                        double h1 = _sec.getData(i4).getHeight() * increase;
                        double h2 = sec.getData(i4).getHeight();
                        sec.getData(i4).setHeight(h1 > h2 ? h1 : h2);
                    }
                    minH = sec.getMinHeight();
                }
                sec.setHeight(minH);
            }
            return sec;
        }
        for (i = 0; i < _sec.getCellCount(); ++i) {
            if (!(_sec.getData(i) instanceof ReportLine) || ((ReportLine)_sec.getData(i)).next() == null || !((ReportLine)_sec.getData(i)).isVertical()) continue;
            _sec.getData(i).setHeight(_sec.getHeight() - _sec.getData(i).getY());
        }
        return _sec;
    }

    protected ReportTable resizeTable(ReportGraphics g, ReportTable _tbl, int rowIndex) throws Exception {
        int i;
        boolean resize;
        ReportTable tbl;
        boolean shift;
        Report temp_report;
        block21: {
            int i2;
            FormattedRow row;
            FormattedRowKey key;
            temp_report = this.report;
            shift = false;
            tbl = new ReportTable();
            resize = false;
            this.rowElements = null;
            double rowHeight = 0.0;
            if (this.rows != null && this.rows.containsKey(key = this.treeStructure == null || this.treeStructure.size() == 0 ? new FormattedRowKey(rowIndex, null) : new FormattedRowKey(rowIndex, this.getTreeLevel())) && (row = this.rows.get(key)) != null) {
                rowHeight = row.getRowHeight();
                this.rowElements = row.getRowElements();
                for (int j = 0; j < _tbl.getColumnCount(); ++j) {
                    tbl.addColumn(new ReportColumn());
                }
                tbl.deepCopy(_tbl);
                tbl.setHeight(rowHeight);
                resize = true;
                shift = true;
            }
            if (this.calculated) break block21;
            if (this.previousRowValue == null) {
                this.previousRowValue = new Object[_tbl.getColumnCount()];
                this.previousRowIsBGColor2 = new boolean[_tbl.getColumnCount()];
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
                    this.previousRowIsBGColor2[i2] = false;
                }
            } else {
                for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                    int[] index = _tbl.getColumn(i2).getDualColorColInfoIndex();
                    if (index == null) continue;
                    boolean different = false;
                    for (int element : index) {
                        if ((this.previousRowValue[element] != null || _tbl.getColumn(element).getData(rowIndex) == null) && (this.previousRowValue[element] == null || this.previousRowValue[element].equals(_tbl.getColumn(element).getData(rowIndex)) || "".equals(_tbl.getColumn(element).getData(rowIndex)))) continue;
                        different = true;
                        break;
                    }
                    if (different) {
                        this.previousRowIsBGColor2[i2] = !this.previousRowIsBGColor2[i2];
                    }
                    _tbl.getColumn(i2).setIsBGColor2(rowIndex, this.previousRowIsBGColor2[i2]);
                }
            }
            for (i2 = 0; i2 < _tbl.getColumnCount(); ++i2) {
                this.previousRowValue[i2] = _tbl.getColumn(i2).getData(rowIndex);
            }
        }
        for (i = 0; i < _tbl.getColumnCount() && !resize; ++i) {
            if (!_tbl.getColumn(i).isVisible() || !_tbl.getColumn(i).isResizeToFitContent()) continue;
            tbl.positionCopy(_tbl);
            resize = true;
        }
        if (resize) {
            for (i = 0; i < tbl.getColumnCount(); ++i) {
                if (!tbl.getColumn(i).isResizeToFitContent()) continue;
                ReportCell cell = tbl.formatCell(tbl.getColumn(i), rowIndex, this.getPage(), 1, this.getTotalPageNumber(), 1, temp_report);
                double h = g.getTextHeight(cell.getText(), cell.getRefFontToDraw(this.report.isAdjustFont()), cell.getWidth(), cell.getAlign(), cell.isNoWrap());
                if (cell instanceof ReportRTFObject && _tbl.getBgColor() != null) {
                    if (this.reportUI == null) {
                        this.reportUI = new ReportUI(this.report, IOUtil.getOffScreenGraphics(), false);
                    }
                    ReportGraphics temp_rg = this.reportUI.getReportGraphics();
                    double[] res = temp_rg.drawCell(this.report, tbl, null, cell, tbl, 0.0, 0.0, 0);
                    h = res[0];
                }
                if (!(h > cell.getHeight()) || !cell.isVisible()) continue;
                shift = true;
                ReportTable.resizeVerticallyAndShift((ReportElement)tbl.getColumn(i), tbl, h - cell.getHeight());
            }
        }
        if (shift) {
            double minH = tbl.getMinHeight();
            if (tbl.getHeight() < minH) {
                double increase = (minH - tbl.getHeight()) / tbl.getHeight() + 1.0;
                if (tbl.isResizeToFitContent()) {
                    int i3;
                    for (i3 = 0; i3 < tbl.getColumnCount(); ++i3) {
                        double h1 = _tbl.getColumn(i3).getHeight() * increase;
                        double h2 = tbl.getColumn(i3).getHeight();
                        tbl.getColumn(i3).setHeight(h1 > h2 ? h1 : h2);
                    }
                    for (i3 = 0; i3 < tbl.getImageCount(); ++i3) {
                        ReportImage image = tbl.getImage(i3);
                        if (!(image instanceof ReportGrid) || !(((ReportGrid)image).getHeight() >= 0.0)) continue;
                        image.setHeight(image.getHeight() * increase);
                    }
                    minH = tbl.getMinHeight();
                }
                for (int i4 = 0; i4 < tbl.getImageCount(); ++i4) {
                    ReportImage image = tbl.getImage(i4);
                    if (!(image instanceof ReportLine) || !((ReportLine)image).isVertical() || ((ReportLine)image).next() == null) continue;
                    image.setHeight(image.getHeight() * increase + 0.01);
                }
                tbl.setHeight(minH);
            }
            return tbl;
        }
        for (i = 0; i < _tbl.getImageCount(); ++i) {
            if (!(_tbl.getImage(i) instanceof ReportLine) || ((ReportLine)_tbl.getImage(i)).next() == null || !((ReportLine)_tbl.getImage(i)).isVertical()) continue;
            _tbl.getImage(i).setHeight(_tbl.getHeight() - _tbl.getImage(i).getY());
        }
        return _tbl;
    }

    protected int[] getTreeLevel() {
        if (this.treeStructure != null && this.treeStructure.size() > 0) {
            int[] values = new int[this.treeStructure.size()];
            for (int i = 0; i < this.treeStructure.size(); ++i) {
                values[i] = this.treeStructure.elementAt(i);
            }
            return values;
        }
        return null;
    }

    protected MatrixGriddedSection writeMasterSection(ReportSection masterSection, ReportTable tbl) throws Exception {
        ReportCell[] textCells;
        if (masterSection == null || !masterSection.isVisible() || masterSection.hasNoDrawableData()) {
            return null;
        }
        masterSection = this.resizeSection(this.reportGraphics, masterSection, tbl);
        Vector<Cell> addableCells = new Vector<Cell>();
        Vector<Double> yPos = new Vector<Double>();
        this.insertXPos(masterSection.getY(), yPos);
        ReportCell[] cells = masterSection.getCells();
        for (ReportCell textCell : textCells = this.getTextCells(cells)) {
            Cell cell;
            if (!(textCell.getX() + textCell.getWidth() <= masterSection.getWidth() + this.PRECISION) || !(textCell.getY() + textCell.getHeight() <= masterSection.getHeight()) || (cell = this.createCell(textCell, cells, tbl, this.report)) == null) continue;
            cell.element.setX(masterSection.getX() + cell.element.getX());
            cell.element.setY(masterSection.getY() + cell.element.getY());
            double y = this.getYPos(cell.element, false);
            this.insertXPos(y, yPos);
            y = this.getYPos(cell.element, true);
            this.insertXPos(y, yPos);
            addableCells.addElement(cell);
        }
        this.insertXPos(masterSection.getY() + masterSection.getHeight(), yPos);
        yPos = this.groupPositionHelper(yPos, this.ROW_MINIMUM_HEIGHT);
        double[] yPoss = new double[yPos.size()];
        for (int i = 0; i < yPos.size(); ++i) {
            yPoss[i] = yPos.elementAt(i);
        }
        MatrixGriddedSection gridSection = new MatrixGriddedSection(this, tbl, masterSection, this.rownum, this.xPositions, yPoss);
        for (int i = 0; i < addableCells.size(); ++i) {
            Cell cell = (Cell)addableCells.elementAt(i);
            gridSection.add(cell);
        }
        for (ReportCell cell : cells) {
            if (cell instanceof ReportLine) {
                gridSection.addReportLine((ReportLine)cell, masterSection.getX(), masterSection.getY());
                continue;
            }
            if (cell instanceof ReportGrid) {
                gridSection.addReportGrid((ReportGrid)cell, masterSection.getX(), masterSection.getY());
                continue;
            }
            if (!(cell instanceof ReportImage)) continue;
            gridSection.addReportImage((ReportImage)cell);
        }
        return gridSection;
    }

    public int getRowNum() {
        return this.rownum;
    }

    public FormulaRange[] getColumnPositionMapping() {
        return this.columnPositionMapping;
    }

    protected void addChartRecord(ReportChartObject chartObject, ExcelChartRecord record) {
        this.excelChartRecords.put(chartObject, record);
    }

    protected ExcelChartRecord getExcelChartRecord(ReportChartObject chartObject) {
        return this.excelChartRecords.get(chartObject);
    }

    public boolean isLimitExcelCellSplit() {
        return this.limitExcelCellSplit;
    }

    public void setLimitExcelCellSplit(boolean limitExcelCellSplit) {
        this.limitExcelCellSplit = limitExcelCellSplit;
    }

    protected class FormulaRange
    implements Comparator<Point> {
        private Vector<Point> points = new Vector();
        private int startIndex = -1;
        private int endIndex = -1;

        public void add(Point point) {
            this.points.addElement(point);
        }

        @Override
        public int compare(Point p1, Point p2) {
            if (p1 == null && p2 == null) {
                return 0;
            }
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            if (p1.x < p2.x) {
                return -1;
            }
            if (p1.x > p2.x) {
                return 1;
            }
            if (p1.y < p2.y) {
                return -1;
            }
            if (p1.y > p2.y) {
                return 1;
            }
            return 0;
        }

        public void setStartIndex(int si) {
            this.startIndex = si;
        }

        public void setEndIndex(int ei) {
            this.endIndex = ei;
        }

        public int getSize() {
            return this.points.size();
        }

        public boolean isReady() {
            return this.startIndex >= 0 && this.startIndex <= this.points.size() && this.endIndex >= 0 && this.endIndex <= this.points.size() && this.endIndex > this.startIndex;
        }

        public String toString() {
            if (this.startIndex < 0 || this.startIndex > this.points.size() || this.endIndex < 0 || this.endIndex > this.points.size() || this.endIndex <= this.startIndex) {
                return "";
            }
            Point[] parray = new Point[this.endIndex - this.startIndex];
            for (int i = this.startIndex; i < this.endIndex; ++i) {
                parray[i - this.startIndex] = this.points.elementAt(i);
            }
            Arrays.sort(parray, this);
            String ret = "";
            int i = 0;
            while (i < parray.length) {
                int j;
                ret = ret + ExcelReport.toExcelCol(parray[i].x) + (parray[i].y + 1);
                for (j = i + 1; j < parray.length && parray[j] != null && parray[j].x == parray[i].x && parray[j].y == parray[j - 1].y + 1; ++j) {
                }
                if (j - 1 > i) {
                    ret = ret + ":" + ExcelReport.toExcelCol(parray[j - 1].x) + (parray[j - 1].y + 1);
                }
                ret = ret + ",";
                i = j;
            }
            if (ret.length() > 0) {
                ret = ret.substring(0, ret.length() - 1);
            }
            return ret;
        }
    }
}

