/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.excel;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.ReportUI;
import quadbase.reportdesigner.report.excel.ExcelReport;
import quadbase.reportdesigner.report.excel.MatrixGriddedSection;
import quadbase.reportdesigner.report.excel.MergedExcelRows;

public class ExcelSubReport
extends ExcelReport {
    private static final Logger LOGGER = Logger.getLogger(ExcelSubReport.class.getName());

    public ExcelSubReport(Report report, double x, double y, double reportWidth, double reportHeight, double[] xPos, ExcelReport parent) {
        super(report);
        this.initRepeatSection();
        this.leftMargin = parent.leftMargin + x;
        this.reportGraphics = parent.reportGraphics;
        this.wb = parent.wb;
        this.dataFormat = parent.dataFormat;
        this.colorMap = parent.colorMap;
        this.palette = parent.palette;
        this.fontMap = parent.fontMap;
        this.excelChartRecords = parent.excelChartRecords;
        this.xPositions = xPos;
        if (reportHeight >= 0.0) {
            this.reportHeight = reportHeight;
        }
        this.reportWidth = reportWidth;
        double[] yPos = null;
        if (y > this.ROW_MINIMUM_HEIGHT) {
            yPos = new double[]{0.0, y};
            reportHeight += y;
        } else {
            yPos = new double[]{0.0};
        }
        ReportTable table = report.getReportTables().elementAt(0);
        this.globalGriddedSection = new MatrixGriddedSection(this, table, null, 0, xPos, yPos);
    }

    public MatrixGriddedSection run() throws Exception {
        try {
            ReportTable table = null;
            this.formatTable();
            Vector<ReportTable> vec = this.report.getReportTables();
            if (vec.size() > 0) {
                table = vec.elementAt(0);
            }
            if (this.report.getInitializeReportError() != null) {
                this.writeSection(ReportUI.createErrorSection(this.report.getActualPageWidth(), this.report.getActualPageHeight(), this.report.getInitializeReportError()), table);
            } else {
                this.writeSection(this.report.getPageHeader(), table);
                this.writeSection(this.report.getReportHeader(), table);
                MergedExcelRows mergedRows = new MergedExcelRows(this);
                for (int i = 0; i < vec.size(); ++i) {
                    table = vec.elementAt(i);
                    this.writeReportTable(table, mergedRows);
                }
                this.writeSection(this.report.getReportFooter(), table);
                this.writeSection(this.report.getPageFooter(), table);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Can't create sub report", ex);
        }
        return this.globalGriddedSection;
    }
}

