/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.excel;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import quadbase.common.util.internal.QbUtil;
import quadbase.reportdesigner.ReportElements.BorderSide;
import quadbase.reportdesigner.ReportElements.ColumnWrap;
import quadbase.reportdesigner.ReportElements.GuideLine;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportChartObject;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportSection;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.ChartObject;
import quadbase.reportdesigner.report.ReadDataFile;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.excel.Cell;
import quadbase.reportdesigner.report.excel.ExcelCellStyle;
import quadbase.reportdesigner.report.excel.ExcelChartRecord;
import quadbase.reportdesigner.report.excel.ExcelReport;
import quadbase.reportdesigner.util.BarcodeFormat;
import quadbase.reportdesigner.util.DateTimeFormat;
import quadbase.reportdesigner.util.LocaleDateTimeFormat;
import quadbase.reportdesigner.util.LocaleNumericFormat;
import quadbase.reportdesigner.util.LogicalFormat;
import quadbase.reportdesigner.util.NumericFormat;
import quadbase.reportdesigner.util.StringFormat;
import quadbase.reportdesigner.util.internal.BarcodeUtil;

public class MatrixGriddedSection {
    private static final Logger LOGGER = Logger.getLogger(MatrixGriddedSection.class.getName());
    protected int initialRow = 0;
    protected boolean[][] occupancyGrid = null;
    protected double[] yPos = null;
    protected Vector<Cell>[] commitedCells = null;
    private double[] xPos = null;
    private ReportTable tbl;
    private ReportSection section;
    private ExcelReport excel;

    public MatrixGriddedSection(ExcelReport excel, ReportTable tbl, ReportSection section, int initRow, double[] xP, double[] yP) {
        this.tbl = tbl;
        this.section = section;
        this.initialRow = initRow;
        this.xPos = xP;
        this.yPos = yP;
        this.occupancyGrid = new boolean[this.yPos.length][this.xPos.length];
        this.commitedCells = new Vector[this.yPos.length];
        for (int i = 0; i < this.occupancyGrid.length; ++i) {
            this.commitedCells[i] = new Vector();
            for (int j = 0; j < this.occupancyGrid[i].length; ++j) {
                this.occupancyGrid[i][j] = false;
            }
        }
        this.excel = excel;
    }

    public int getRowCount() {
        return this.yPos.length - 1;
    }

    public double getTotalHeight() {
        return this.yPos[this.yPos.length - 1];
    }

    public void append(MatrixGriddedSection nextSection) {
        int i;
        if (nextSection == null) {
            return;
        }
        double[] newYPos = new double[this.yPos.length + nextSection.yPos.length - 1];
        for (i = 0; i < this.yPos.length; ++i) {
            newYPos[i] = this.yPos[i];
        }
        for (i = 0; i < nextSection.yPos.length - 1; ++i) {
            newYPos[i + this.yPos.length] = nextSection.yPos[i + 1] + this.yPos[this.yPos.length - 1];
        }
        boolean[][] newOccupancyGrid = new boolean[newYPos.length][this.xPos.length];
        Vector[] newCommitedCells = new Vector[newYPos.length];
        for (int i2 = 0; i2 < this.yPos.length - 1; ++i2) {
            newCommitedCells[i2] = this.commitedCells[i2];
            newOccupancyGrid[i2] = this.occupancyGrid[i2];
        }
        Cell cell = null;
        for (int i3 = 0; i3 < nextSection.yPos.length; ++i3) {
            newCommitedCells[i3 + this.yPos.length - 1] = nextSection.commitedCells[i3];
            for (int j = 0; j < nextSection.commitedCells[i3].size(); ++j) {
                cell = nextSection.commitedCells[i3].elementAt(j);
                cell.endRow = i3 + this.yPos.length + (cell.endRow - cell.startRow) - 1;
                cell.startRow = i3 + this.yPos.length - 1;
            }
            newOccupancyGrid[i3 + this.yPos.length - 1] = nextSection.occupancyGrid[i3];
        }
        cell = null;
        this.yPos = newYPos;
        this.occupancyGrid = newOccupancyGrid;
        this.commitedCells = newCommitedCells;
        newCommitedCells = null;
        newOccupancyGrid = null;
        newYPos = null;
    }

    public void merge(MatrixGriddedSection nextSection) {
        int j;
        if (nextSection == null) {
            return;
        }
        Vector<Double> newYPos = new Vector<Double>();
        for (double yPo : this.yPos) {
            this.excel.insertXPos(yPo, newYPos);
        }
        for (double yPo : nextSection.yPos) {
            this.excel.insertXPos(yPo, newYPos);
        }
        newYPos = this.excel.groupPositionHelper(newYPos, this.excel.ROW_MINIMUM_HEIGHT);
        double[] yPoss = new double[newYPos.size()];
        for (int i = 0; i < newYPos.size(); ++i) {
            yPoss[i] = newYPos.elementAt(i);
        }
        ReportSection section = nextSection.section;
        ReportTable table = nextSection.tbl;
        MatrixGriddedSection matrixGrid = new MatrixGriddedSection(this.excel, table, section, this.initialRow, this.xPos, yPoss);
        Cell cell = null;
        for (Vector<Cell> rowCells : this.commitedCells) {
            for (j = 0; j < rowCells.size(); ++j) {
                cell = rowCells.elementAt(j);
                if (cell.element == null && cell.value == null) continue;
                matrixGrid.add(this.yPos[cell.startRow], this.yPos[cell.endRow], cell);
            }
        }
        for (Vector<Cell> rowCells : nextSection.commitedCells) {
            for (j = 0; j < rowCells.size(); ++j) {
                cell = rowCells.elementAt(j);
                if (cell.element == null && cell.value == null) continue;
                matrixGrid.add(nextSection.yPos[cell.startRow], nextSection.yPos[cell.endRow], cell);
            }
        }
        for (Vector<Cell> rowCells : this.commitedCells) {
            for (j = 0; j < rowCells.size(); ++j) {
                cell = rowCells.elementAt(j);
                if (cell.element != null || cell.value != null) continue;
                matrixGrid.addLine(this.yPos[cell.startRow], this.yPos[cell.endRow], cell);
            }
        }
        for (Vector<Cell> rowCells : nextSection.commitedCells) {
            for (j = 0; j < rowCells.size(); ++j) {
                cell = rowCells.elementAt(j);
                if (cell.element != null && cell.value != null) continue;
                matrixGrid.addLine(nextSection.yPos[cell.startRow], nextSection.yPos[cell.endRow], cell);
            }
        }
        cell = null;
        this.occupancyGrid = matrixGrid.occupancyGrid;
        this.yPos = matrixGrid.yPos;
        this.commitedCells = matrixGrid.commitedCells;
    }

    public void add(double startY, double endY, Cell cell) {
        LOGGER.finest("adding cell");
        if (cell == null) {
            return;
        }
        if (cell.element != null && !cell.element.isVisible()) {
            return;
        }
        int startRow = this.excel.getMatchIndexHelper(startY, this.yPos);
        int endRow = this.excel.getMatchIndexHelper(endY, this.yPos);
        int startColumn = cell.startColumn;
        int endColumn = cell.endColumn;
        LOGGER.finest(startRow + " " + endRow + " " + startColumn + " " + endColumn);
        if (startRow >= endRow || startColumn >= endColumn) {
            return;
        }
        Point[] points = this.findLargestAvailableArea(startRow, endRow, startColumn, endColumn);
        if (points != null) {
            this.setOccupancy(points[0].y, points[1].y, points[0].x, points[1].x);
            cell.startRow = points[0].y;
            cell.endRow = points[1].y;
            cell.startColumn = points[0].x;
            cell.endColumn = points[1].x;
            this.commitedCells[points[0].y].addElement(cell);
            this.addLine(startY, endY, cell);
        }
    }

    public void add(Cell cell) {
        this.add(cell, false, 0.0);
    }

    public void add(Cell cell, double startY) {
        this.add(cell, false, startY);
    }

    public void add(Cell cell, boolean empty, double startY) {
        if (cell == null) {
            return;
        }
        if (cell.element != null && !cell.element.isVisible()) {
            return;
        }
        int startRow = this.excel.getMatchIndexHelper(cell.element.getY() + startY, this.yPos);
        int endRow = this.excel.getMatchIndexHelper(cell.element.getY() + cell.element.getHeight() + startY, this.yPos);
        int startColumn = this.excel.getMatchIndexHelper(cell.element.getX() + this.excel.leftMargin, this.xPos);
        int endColumn = this.excel.getMatchIndexHelper(cell.element.getX() + cell.element.getWidth() + this.excel.leftMargin, this.xPos);
        if (empty) {
            startRow = cell.startRow;
            endRow = cell.endRow;
            startColumn = cell.startColumn;
            endColumn = cell.endColumn;
        }
        if (startRow >= endRow || startColumn >= endColumn) {
            return;
        }
        Point[] points = this.findLargestAvailableArea(startRow, endRow, startColumn, endColumn);
        if (points != null) {
            cell.startRow = points[0].y;
            cell.endRow = points[1].y;
            cell.startColumn = points[0].x;
            cell.endColumn = points[1].x;
            if ((Report.Excel_fitCell && (cell.element.getDataFormat() instanceof NumericFormat || cell.element.getDataFormat() instanceof LocaleNumericFormat) || Report.Excel_NonNumericFitCell && (cell.element.getDataFormat() instanceof StringFormat || cell.element.getDataFormat() instanceof DateTimeFormat || cell.element.getDataFormat() instanceof LocaleDateTimeFormat || cell.element.getDataFormat() instanceof LogicalFormat)) && (cell.endColumn - cell.startColumn > 1 || cell.endRow - cell.startRow > 1)) {
                int i;
                double biggest;
                if (cell.endColumn - cell.startColumn > 1) {
                    startColumn = cell.startColumn;
                    endColumn = cell.endColumn;
                    biggest = 0.0;
                    int column = 0;
                    for (i = startColumn; i < endColumn; ++i) {
                        double width = this.xPos[i + 1] - this.xPos[i];
                        if (!(width > biggest)) continue;
                        biggest = width;
                        column = i;
                    }
                    cell.startColumn = column;
                    cell.endColumn = column + 1;
                }
                if (cell.endRow - cell.startRow > 1) {
                    startRow = cell.startRow;
                    endRow = cell.endRow;
                    biggest = 0.0;
                    int row = 0;
                    for (i = startRow; i < endRow; ++i) {
                        double height = this.yPos[i + 1] - this.yPos[i];
                        if (!(height > biggest)) continue;
                        biggest = height;
                        row = i;
                    }
                    cell.startRow = row;
                    cell.endRow = row + 1;
                }
                ReportCell rc = null;
                Cell newCell = null;
                for (int i2 = startColumn; i2 < endColumn; ++i2) {
                    for (int j = startRow; j < endRow; ++j) {
                        if (i2 == cell.startColumn && j == cell.startRow) continue;
                        rc = ReportCell.clone(cell.element);
                        newCell = new Cell("", rc);
                        newCell.startColumn = i2;
                        newCell.endColumn = i2 + 1;
                        newCell.startRow = j;
                        newCell.endRow = j + 1;
                        this.add(newCell, true, startY);
                    }
                }
                rc = null;
                newCell = null;
            }
            this.setOccupancy(cell.startRow, cell.endRow, cell.startColumn, cell.endColumn);
            this.commitedCells[cell.startRow].addElement(cell);
        }
    }

    public void addReportImage(ReportImage image) {
        Cell cell = new Cell(null, image);
        this.add(cell);
    }

    public void addReportLine(ReportLine line, double leftMargin, double topMargin) {
        if (line.isVertical() && line.getWidthOfElement() <= 2 || !line.isVertical() && line.getHeightOfElement() <= 2 || line.getBgColor() == null || line instanceof ColumnWrap || line instanceof GuideLine) {
            return;
        }
        if (this.excel.reportWidth >= 0.0 && line.getX() + line.getWidth() + leftMargin > this.excel.reportWidth) {
            return;
        }
        BorderStyle style = BorderStyle.THIN;
        if (line.getLineStyle() == 3) {
            style = BorderStyle.DASHED;
        } else if (line.getLineStyle() == 2) {
            style = BorderStyle.DOUBLE;
        } else {
            int thickness = line.getWidthOfElement() - 2;
            if (!line.isVertical()) {
                thickness = line.getHeightOfElement() - 2;
            }
            if (thickness >= 5 && thickness < 9) {
                style = BorderStyle.MEDIUM;
            } else if (thickness >= 9) {
                style = BorderStyle.THICK;
            }
        }
        this.addLine(line.getX() + leftMargin + this.excel.leftMargin, line.getY() + topMargin, line.isVertical() ? line.getHeight() : line.getWidth(), line.isVertical(), line.getBgColor(), style);
    }

    public void addReportGrid(ReportGrid grid, double leftMargin, double topMargin) {
        if (grid.getBorderColor() == null || !grid.hasBorder()) {
            return;
        }
        if (this.excel.reportWidth >= 0.0 && grid.getX() + grid.getWidth() + leftMargin > this.excel.reportWidth) {
            return;
        }
        BorderStyle style = BorderStyle.THIN;
        if (grid.getGridStyle() == 3) {
            style = BorderStyle.DASHED;
        } else if (grid.getGridStyle() == 2) {
            style = BorderStyle.DOUBLE;
        } else {
            int thickness = grid.getBorderThickness();
            if (thickness >= 5 && thickness < 9) {
                style = BorderStyle.MEDIUM;
            } else if (thickness >= 9) {
                style = BorderStyle.THICK;
            }
        }
        if (grid.previous() == null) {
            this.addLine(grid.getX() + leftMargin + this.excel.leftMargin, grid.getY() + topMargin, grid.getWidth(), false, grid.getBorderColor(), style);
        }
        this.addLine(grid.getX() + leftMargin + this.excel.leftMargin, grid.getY() + topMargin, grid.getHeight(), true, grid.getBorderColor(), style);
        if (grid.next() == null) {
            this.addLine(grid.getX() + leftMargin + this.excel.leftMargin, grid.getHeight() < 0.0 ? -1.0 : grid.getY() + grid.getHeight() + topMargin, grid.getWidth(), false, grid.getBorderColor(), style);
        }
        this.addLine(grid.getX() + grid.getWidth() + this.excel.leftMargin, grid.getY() + topMargin, grid.getHeight(), true, grid.getBorderColor(), style);
    }

    private void addLine(double x, double y, double length, boolean isVertical, Color color, BorderStyle style) {
        if (isVertical) {
            int startRow = this.excel.getMatchIndexHelper(y, this.yPos);
            int endRow = 0;
            endRow = length < 0.0 ? this.yPos.length - 1 : this.excel.getMatchIndexHelper(y + length, this.yPos);
            if (endRow <= startRow) {
                return;
            }
            Vector<Cell> row = null;
            Cell cell = null;
            for (int i = startRow; i < endRow; ++i) {
                int startColumn = this.excel.getMatchIndexHelper(x, this.xPos);
                row = this.commitedCells[i];
                boolean inserted = false;
                for (int j = 0; j < row.size() && !inserted; ++j) {
                    cell = row.elementAt(j);
                    if (cell.startColumn == startColumn) {
                        cell.left = true;
                        cell.leftColor = color;
                        cell.leftStyle = style;
                        inserted = true;
                        continue;
                    }
                    if (cell.endColumn != startColumn || cell.endColumn != cell.startColumn + 1) continue;
                    cell.right = true;
                    cell.rightColor = color;
                    cell.rightStyle = style;
                    inserted = true;
                }
                if (inserted) continue;
                cell = new Cell(null, null);
                cell.startColumn = startColumn;
                cell.endColumn = startColumn + 1;
                cell.startRow = i;
                cell.endRow = i + 1;
                cell.left = true;
                cell.leftColor = color;
                cell.leftStyle = style;
                row.addElement(cell);
            }
            row = null;
            cell = null;
        } else {
            boolean top = true;
            int startColumn = this.excel.getMatchIndexHelper(x, this.xPos);
            int endColumn = this.excel.getMatchIndexHelper(x + length, this.xPos);
            int startRow = this.excel.getMatchIndexHelper(y, this.yPos);
            if (startRow == this.yPos.length - 1) {
                --startRow;
                top = false;
            }
            if (endColumn <= startColumn || startRow < 0) {
                return;
            }
            Vector<Cell> row = this.commitedCells[startRow];
            Cell cell = null;
            for (int i = startColumn; i < endColumn; ++i) {
                boolean inserted = false;
                for (int j = 0; j < row.size() && !inserted; ++j) {
                    cell = row.elementAt(j);
                    if (cell.startColumn != i) continue;
                    if (top) {
                        cell.top = true;
                        cell.topColor = color;
                        cell.topStyle = style;
                    } else {
                        cell.bottom = true;
                        cell.bottomColor = color;
                        cell.bottomStyle = style;
                    }
                    inserted = true;
                }
                if (inserted) continue;
                cell = new Cell(null, null);
                cell.startColumn = i;
                cell.endColumn = i + 1;
                cell.startRow = startRow;
                cell.endRow = startRow + 1;
                if (top) {
                    cell.top = true;
                    cell.topColor = color;
                    cell.topStyle = style;
                } else {
                    cell.bottom = true;
                    cell.bottomColor = color;
                    cell.bottomStyle = style;
                }
                row.addElement(cell);
            }
            cell = null;
        }
    }

    public void addLine(double startY, double endY, Cell cell) {
        int j;
        Cell existing;
        Vector<Cell> row;
        boolean found;
        int endRow;
        if (cell == null) {
            return;
        }
        int startRow = this.excel.getMatchIndexHelper(startY, this.yPos);
        if (startRow >= (endRow = this.excel.getMatchIndexHelper(endY, this.yPos)) || cell.startColumn >= cell.endColumn) {
            return;
        }
        if (cell.top || cell.left || cell.right) {
            found = false;
            row = this.commitedCells[startRow];
            existing = null;
            for (j = 0; j < row.size() && !found; ++j) {
                existing = row.elementAt(j);
                if (existing.startColumn != cell.startColumn) continue;
                this.excel.imposeBorderProperties(existing, cell, true, true, false, true);
                found = true;
            }
            existing = null;
            if (!found) {
                Cell c1 = new Cell(null, null);
                c1.startColumn = cell.startColumn;
                c1.endColumn = cell.startColumn + 1;
                c1.startRow = startRow;
                c1.endRow = startRow + 1;
                this.excel.imposeBorderProperties(c1, cell, true, true, false, true);
                row.addElement(c1);
            }
        }
        if (cell.left || cell.right) {
            found = false;
            row = null;
            existing = null;
            Cell c1 = null;
            for (int i = startRow + 1; i < endRow - 1; ++i) {
                found = false;
                row = this.commitedCells[i];
                for (int j2 = 0; j2 < row.size() && !found; ++j2) {
                    existing = row.elementAt(j2);
                    if (existing.startColumn != cell.startColumn) continue;
                    this.excel.imposeBorderProperties(existing, cell, false, true, false, true);
                    found = true;
                }
                if (found) continue;
                c1 = new Cell(null, null);
                c1.startColumn = cell.startColumn;
                c1.endColumn = cell.startColumn + 1;
                c1.startRow = i;
                c1.endRow = i + 1;
                this.excel.imposeBorderProperties(c1, cell, false, true, false, true);
                row.addElement(c1);
            }
            row = null;
            existing = null;
            c1 = null;
        }
        if (cell.bottom || cell.left || cell.right) {
            found = false;
            row = this.commitedCells[endRow - 1];
            existing = null;
            for (j = 0; j < row.size() && !found; ++j) {
                existing = row.elementAt(j);
                if (existing.startColumn != cell.startColumn) continue;
                this.excel.imposeBorderProperties(existing, cell, false, true, true, true);
                found = true;
            }
            existing = null;
            if (!found) {
                Cell c1 = new Cell(null, null);
                c1.startColumn = cell.startColumn;
                c1.endColumn = cell.startColumn + 1;
                c1.startRow = endRow - 1;
                c1.endRow = endRow;
                this.excel.imposeBorderProperties(c1, cell, false, true, true, true);
                row.addElement(c1);
            }
        }
    }

    private Point[] findLargestAvailableArea(int startRow, int endRow, int startColumn, int endColumn) {
        Point[] points;
        if (startRow == endRow || startColumn == endColumn) {
            return null;
        }
        Point rock = this.checkOccupancy(startRow, endRow, startColumn, endColumn);
        if (rock == null) {
            Point[] ret = new Point[]{new Point(startColumn, startRow), new Point(endColumn, endRow)};
            return ret;
        }
        Point[] ret = null;
        double maxArea = this.calculateArea(startRow, rock.y, startColumn, endColumn);
        if (maxArea > 0.0) {
            ret = new Point[]{new Point(startColumn, startRow), new Point(endColumn, rock.y)};
        }
        if ((points = this.findLargestAvailableArea(startRow, endRow, startColumn, rock.x)) != null && this.calculateArea(points[0].y, points[1].y, points[0].x, points[1].x) > maxArea) {
            ret = points;
            maxArea = this.calculateArea(points[0].y, points[1].y, points[0].x, points[1].x);
        }
        if ((points = this.findLargestAvailableArea(startRow, endRow, rock.x + 1, endColumn)) != null && this.calculateArea(points[0].y, points[1].y, points[0].x, points[1].x) > maxArea) {
            ret = points;
            maxArea = this.calculateArea(points[0].y, points[1].y, points[0].x, points[1].x);
        }
        if ((points = this.findLargestAvailableArea(rock.y + 1, endRow, startColumn, endColumn)) != null && this.calculateArea(points[0].y, points[1].y, points[0].x, points[1].x) > maxArea) {
            ret = points;
            maxArea = this.calculateArea(points[0].y, points[1].y, points[0].x, points[1].x);
        }
        return ret;
    }

    private double calculateArea(int startRow, int endRow, int startColumn, int endColumn) {
        double area = (this.yPos[endRow] - this.yPos[startRow]) * (this.xPos[endColumn] - this.xPos[startColumn]);
        if (area < 0.0) {
            return 0.0;
        }
        return area;
    }

    private Point checkOccupancy(int startRow, int endRow, int startColumn, int endColumn) {
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startColumn; j < endColumn; ++j) {
                if (!this.occupancyGrid[i][j]) continue;
                return new Point(j, i);
            }
        }
        return null;
    }

    private void setOccupancy(int startRow, int endRow, int startColumn, int endColumn) {
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startColumn; j < endColumn; ++j) {
                this.occupancyGrid[i][j] = true;
            }
        }
    }

    private void setupCellBorders() {
        for (int i = 0; i < this.commitedCells.length; ++i) {
            Vector<Cell> rowCells = this.commitedCells[i];
            Cell cell = null;
            Color color = null;
            Cell c1 = null;
            Vector<Cell> row = null;
            for (int j = 0; j < rowCells.size(); ++j) {
                int m;
                boolean inserted;
                int k;
                cell = rowCells.elementAt(j);
                if (cell.element == null || !cell.element.hasBorder() || cell.element.getBorderColor() == null) continue;
                BorderStyle topStyle = this.getBorderStyle(cell, BorderSide.TOP);
                BorderStyle leftStyle = this.getBorderStyle(cell, BorderSide.LEFT);
                BorderStyle rightStyle = this.getBorderStyle(cell, BorderSide.RIGHT);
                BorderStyle bottomStyle = this.getBorderStyle(cell, BorderSide.BOTTOM);
                color = cell.element.getBorderColor();
                for (k = cell.startColumn; k < cell.endColumn; ++k) {
                    inserted = false;
                    for (m = 0; m < rowCells.size(); ++m) {
                        c1 = rowCells.elementAt(m);
                        if (c1.startColumn != k) continue;
                        c1.top = true;
                        c1.topColor = color;
                        c1.topStyle = topStyle;
                        inserted = true;
                    }
                    if (inserted) continue;
                    c1 = new Cell(null, null);
                    c1.startColumn = k;
                    c1.endColumn = k + 1;
                    c1.startRow = i;
                    c1.endRow = i + 1;
                    c1.top = true;
                    c1.topColor = color;
                    c1.topStyle = topStyle;
                    rowCells.addElement(c1);
                }
                for (int n = 0; n < cell.endRow - cell.startRow; ++n) {
                    boolean reuseCell;
                    row = this.commitedCells[i + n];
                    boolean leftInserted = false;
                    boolean rightInserted = false;
                    for (int m2 = 0; m2 < row.size(); ++m2) {
                        c1 = row.elementAt(m2);
                        if (c1.startColumn == cell.startColumn) {
                            c1.left = true;
                            c1.leftColor = color;
                            c1.leftStyle = leftStyle;
                            leftInserted = true;
                        }
                        if (c1.endColumn != cell.endColumn || c1.endColumn - c1.startColumn != 1) continue;
                        c1.right = true;
                        c1.rightColor = color;
                        c1.rightStyle = rightStyle;
                        rightInserted = true;
                    }
                    c1 = null;
                    if (!leftInserted) {
                        c1 = new Cell(null, null);
                        c1.startColumn = cell.startColumn;
                        c1.endColumn = cell.startColumn + 1;
                        c1.startRow = i + n;
                        c1.endRow = i + 1 + n;
                        c1.left = true;
                        c1.leftColor = color;
                        c1.leftStyle = leftStyle;
                        row.addElement(c1);
                    }
                    if (rightInserted) continue;
                    if (c1 == null || c1.startColumn != cell.endColumn - 1 || c1.endColumn != cell.endColumn) {
                        c1 = new Cell(null, null);
                        reuseCell = false;
                    } else {
                        reuseCell = true;
                    }
                    c1.startColumn = cell.endColumn - 1;
                    c1.endColumn = cell.endColumn;
                    c1.startRow = i + n;
                    c1.endRow = i + 1 + n;
                    c1.right = true;
                    c1.rightColor = color;
                    c1.rightStyle = rightStyle;
                    if (reuseCell) continue;
                    row.addElement(c1);
                }
                if (row == null) {
                    row = rowCells;
                }
                for (k = cell.startColumn; k < cell.endColumn; ++k) {
                    inserted = false;
                    for (m = 0; m < row.size(); ++m) {
                        c1 = row.elementAt(m);
                        if (c1.startColumn != k) continue;
                        c1.bottom = true;
                        c1.bottomColor = color;
                        c1.bottomStyle = bottomStyle;
                        inserted = true;
                    }
                    if (inserted) continue;
                    c1 = new Cell(null, null);
                    c1.startColumn = k;
                    c1.endColumn = k + 1;
                    c1.startRow = i;
                    c1.endRow = i + 1;
                    c1.bottom = true;
                    c1.bottomColor = color;
                    c1.bottomStyle = bottomStyle;
                    row.addElement(c1);
                }
            }
            cell = null;
            color = null;
            c1 = null;
            row = null;
        }
    }

    private BorderStyle getBorderStyle(Cell cell, BorderSide borderSide) {
        int borderThickness;
        switch (borderSide) {
            case BOTTOM: {
                borderThickness = cell.element.getBottomBorder();
                break;
            }
            case LEFT: {
                borderThickness = cell.element.getLeftBorder();
                break;
            }
            case RIGHT: {
                borderThickness = cell.element.getRightBorder();
                break;
            }
            default: {
                borderThickness = cell.element.getTopBorder();
            }
        }
        BorderStyle style = borderThickness <= 0 ? BorderStyle.NONE : (borderThickness >= 5 && borderThickness < 9 ? BorderStyle.MEDIUM : (borderThickness >= 9 ? BorderStyle.THICK : BorderStyle.THIN));
        return style;
    }

    private void setPaperSize(PrintSetup page) {
        double ph = this.excel.report.getPageHeight();
        double pw = this.excel.report.getPageWidth();
        page.setLandscape(pw > ph);
        if (ph > pw) {
            double ph2 = ph;
            ph = pw;
            pw = ph2;
        }
        page.setPaperSize(this.getPaperSize(ph, pw));
    }

    private void setPageMargins(Sheet sheet) {
        sheet.setMargin((short)0, this.excel.report.getLeftMargin());
        sheet.setMargin((short)1, this.excel.report.getRightMargin());
        sheet.setMargin((short)2, this.excel.report.getTopMargin());
        sheet.setMargin((short)3, this.excel.report.getBottomMargin());
        if (sheet instanceof XSSFSheet) {
            sheet.setMargin((short)4, 0.0);
            sheet.setMargin((short)5, 0.0);
        } else if (sheet instanceof HSSFSheet) {
            sheet.getPrintSetup().setFooterMargin(0.0);
            sheet.getPrintSetup().setHeaderMargin(0.0);
        }
    }

    private short getPaperSize(double ph, double pw) {
        if (ph >= 11.69 && pw >= 16.54) {
            return 8;
        }
        if (ph >= 11.0 && pw >= 17.0) {
            return 4;
        }
        if (ph >= 8.5 && pw >= 14.0) {
            return 5;
        }
        if (ph >= 8.5 && pw >= 11.0) {
            return 1;
        }
        if (ph >= 8.27 && pw >= 11.69) {
            return 9;
        }
        return 11;
    }

    public void export(Sheet sheet) throws Exception {
        PrintSetup page = sheet.getPrintSetup();
        this.setPaperSize(page);
        this.setPageMargins(sheet);
        this.setupCellBorders();
        Vector<Cell> rowCells = null;
        Row row = null;
        Cell inCell = null;
        Object[] res = null;
        InputStream bis = null;
        byte[] ba = null;
        ByteArrayOutputStream bos = null;
        ClientAnchor anchor = null;
        String filename = null;
        ReportChartObject chart = null;
        Report temp_report = null;
        ReportCell[] cells = null;
        ExcelChartRecord chartRecord = null;
        ReadDataFile rdf = null;
        String v = null;
        org.apache.poi.ss.usermodel.Cell cell = null;
        ExcelCellStyle excelCellStyle = null;
        for (int i = 0; i < this.commitedCells.length - 1; ++i) {
            rowCells = this.commitedCells[i];
            double cRowH = this.yPos[i + 1] - this.yPos[i];
            row = sheet.createRow(this.initialRow + i);
            row.setHeight(this.excel.toTwips(cRowH));
            if (rowCells.size() > 0) {
                for (int j = 0; j < rowCells.size(); ++j) {
                    inCell = rowCells.elementAt(j);
                    if (inCell.element != null && inCell.element.getDataFormat() instanceof BarcodeFormat) {
                        int c;
                        byte[] imageData = null;
                        res = BarcodeUtil.getBarCodeImage(inCell.element, imageData);
                        imageData = (byte[])res[0];
                        bis = new ByteArrayInputStream(imageData);
                        int type = 6;
                        bos = new ByteArrayOutputStream(bis.available());
                        while ((c = bis.read()) != -1) {
                            bos.write(c);
                        }
                        bis.close();
                        int imgindex = this.excel.wb.addPicture(bos.toByteArray(), type);
                        if (this.excel.patriarch == null) {
                            this.excel.patriarch = sheet.createDrawingPatriarch();
                        }
                        anchor = this.excel.helper.createClientAnchor();
                        anchor.setDx1(0);
                        anchor.setDy1(0);
                        anchor.setDx2(0);
                        anchor.setDy2(0);
                        anchor.setCol1(inCell.startColumn);
                        anchor.setRow1(this.initialRow + inCell.startRow);
                        anchor.setCol2(inCell.endColumn);
                        anchor.setRow2(this.initialRow + inCell.endRow);
                        this.excel.patriarch.createPicture(anchor, imgindex);
                        continue;
                    }
                    if (inCell.element instanceof ReportImage && !(inCell.element instanceof ReportLine) && !(inCell.element instanceof ReportGrid)) {
                        try {
                            filename = null;
                            bis = null;
                            if (inCell.element instanceof ReportChartObject) {
                                if (!inCell.value.toString().equalsIgnoreCase("")) {
                                    chart = (ReportChartObject)inCell.element;
                                    temp_report = this.excel.report;
                                    cells = null;
                                    if (this.section != null) {
                                        cells = this.section.getData();
                                    }
                                    try {
                                        double areaWidth = 0.0;
                                        for (int k = inCell.startColumn; k < inCell.endColumn; ++k) {
                                            areaWidth += (double)sheet.getColumnWidth(k);
                                        }
                                        double areaHeight = 0.0;
                                        for (int k = inCell.startRow; k < inCell.endRow; ++k) {
                                            areaHeight += (double)this.excel.toTwips(this.yPos[k + 1] - this.yPos[k]);
                                        }
                                        int pxW = (int)(areaWidth / 256.0) * 7;
                                        int pxH = (int)(areaHeight / 15.0);
                                        chartRecord = this.excel.getExcelChartRecord(chart);
                                        byte[] chartbytes = chartRecord != null ? ChartObject.export(10, chartRecord.getReport(), chartRecord.getReportTable(), chartRecord.getReportCells(), chart, pxW, pxH, null, "")[0] : ChartObject.export(10, temp_report, this.tbl, cells, chart, pxW, pxH, null, "")[0];
                                        bis = new ByteArrayInputStream(chartbytes);
                                    }
                                    catch (Exception e) {
                                        LOGGER.log(Level.FINEST, "Failed to get chart export bytes", e);
                                    }
                                }
                            } else {
                                filename = ((ReportImage)inCell.element).getImageURL().toString();
                                if (filename.startsWith("file:")) {
                                    filename = ((ReportImage)inCell.element).getImageURL().getPath();
                                }
                                filename = QbUtil.fixUrlString(filename);
                                rdf = new ReadDataFile();
                                try {
                                    bis = rdf.getInputStream(null, filename);
                                }
                                catch (Exception ex) {
                                    LOGGER.log(Level.FINE, "Excel Export: Image file not found", ex);
                                    ba = ((ReportImage)inCell.element).getBytes();
                                }
                            }
                            if (bis != null || ba != null) {
                                int type = -1;
                                if (filename == null) {
                                    type = 6;
                                } else if (filename.toUpperCase().endsWith(".PNG")) {
                                    type = 6;
                                } else if (filename.toUpperCase().endsWith(".JPG")) {
                                    type = 5;
                                } else if (filename.toUpperCase().endsWith(".DIB")) {
                                    type = 7;
                                }
                                if (bis != null) {
                                    bos = new ByteArrayOutputStream(bis.available());
                                    if (type == -1) {
                                        BufferedImage image = ImageIO.read(bis);
                                        if (image == null) {
                                            throw new Exception("Cannot read image " + filename);
                                        }
                                        if (!ImageIO.write((RenderedImage)image, "png", bos)) {
                                            throw new Exception("Cannot convert image " + filename + " to PNG");
                                        }
                                        type = 6;
                                    } else {
                                        int c;
                                        while ((c = bis.read()) != -1) {
                                            bos.write(c);
                                        }
                                    }
                                    bis.close();
                                    ba = bos.toByteArray();
                                } else if (type == -1) {
                                    bos = new ByteArrayOutputStream();
                                    ByteArrayInputStream in = new ByteArrayInputStream(ba);
                                    BufferedImage image = ImageIO.read(in);
                                    if (image == null) {
                                        throw new Exception("Cannot read image " + filename);
                                    }
                                    if (!ImageIO.write((RenderedImage)image, "png", bos)) {
                                        throw new Exception("Cannot convert image " + filename + " to PNG");
                                    }
                                    type = 6;
                                    ba = bos.toByteArray();
                                }
                                int imgindex = this.excel.wb.addPicture(ba, type);
                                if (this.excel.patriarch == null) {
                                    this.excel.patriarch = sheet.createDrawingPatriarch();
                                }
                                anchor = this.excel.helper.createClientAnchor();
                                anchor.setDx1(0);
                                anchor.setDy1(0);
                                anchor.setDx2(0);
                                anchor.setDy2(0);
                                anchor.setCol1(inCell.startColumn);
                                anchor.setRow1(this.initialRow + inCell.startRow);
                                anchor.setCol2(inCell.endColumn);
                                anchor.setRow2(this.initialRow + inCell.endRow);
                                this.excel.patriarch.createPicture(anchor, imgindex);
                                continue;
                            }
                            if (inCell.element instanceof ReportChartObject) {
                                cell = row.createCell(inCell.startColumn);
                                v = inCell.value.toString();
                                cell.setCellValue(v);
                                cell.setCellStyle(this.excel.getCellStyle(new ExcelCellStyle()));
                                if (inCell.endRow - inCell.startRow <= 1 && inCell.endColumn - inCell.startColumn <= 1) continue;
                                sheet.addMergedRegionUnsafe(new CellRangeAddress(inCell.startRow + this.initialRow, inCell.endRow - 1 + this.initialRow, inCell.startColumn, inCell.endColumn - 1));
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.WARNING, "Export: operation failed", ex);
                        }
                    }
                    cell = row.createCell(inCell.startColumn);
                    excelCellStyle = new ExcelCellStyle();
                    if (inCell.left) {
                        excelCellStyle.setBorderLeft(inCell.leftStyle);
                        excelCellStyle.setLeftBorderColor(inCell.leftColor);
                    }
                    if (inCell.right) {
                        excelCellStyle.setBorderRight(inCell.rightStyle);
                        excelCellStyle.setRightBorderColor(inCell.rightColor);
                    }
                    if (inCell.top) {
                        excelCellStyle.setBorderTop(inCell.topStyle);
                        excelCellStyle.setTopBorderColor(inCell.topColor);
                    }
                    if (inCell.bottom) {
                        excelCellStyle.setBorderBottom(inCell.bottomStyle);
                        excelCellStyle.setBottomBorderColor(inCell.bottomColor);
                    }
                    if (inCell.element != null) {
                        short angle = (short)inCell.element.getRotateAngle();
                        HorizontalAlignment halign = HorizontalAlignment.CENTER;
                        VerticalAlignment valign = VerticalAlignment.CENTER;
                        if (angle == 0) {
                            if (inCell.element.getAlign() == 1) {
                                halign = HorizontalAlignment.LEFT;
                            } else if (inCell.element.getAlign() == 2) {
                                halign = HorizontalAlignment.RIGHT;
                            }
                            excelCellStyle.setAlignment(halign);
                        } else if (angle > 0) {
                            valign = VerticalAlignment.CENTER;
                            if (inCell.element.getAlign() == 1) {
                                valign = VerticalAlignment.TOP;
                            } else if (inCell.element.getAlign() == 2) {
                                valign = VerticalAlignment.BOTTOM;
                            }
                            excelCellStyle.setVerticalAlignment(valign);
                        } else {
                            valign = VerticalAlignment.CENTER;
                            if (inCell.element.getAlign() == 1) {
                                valign = VerticalAlignment.BOTTOM;
                            } else if (inCell.element.getAlign() == 2) {
                                valign = VerticalAlignment.TOP;
                            }
                            excelCellStyle.setVerticalAlignment(valign);
                        }
                        valign = VerticalAlignment.CENTER;
                        if (angle == 0) {
                            if (inCell.element.getVAlign() == 1) {
                                valign = VerticalAlignment.TOP;
                            } else if (inCell.element.getVAlign() == 2 || inCell.element.getVAlign() == 3) {
                                valign = VerticalAlignment.BOTTOM;
                            }
                            excelCellStyle.setVerticalAlignment(valign);
                        } else if (angle > 0) {
                            halign = HorizontalAlignment.CENTER;
                            if (inCell.element.getVAlign() == 1) {
                                halign = HorizontalAlignment.RIGHT;
                            } else if (inCell.element.getVAlign() == 2 || inCell.element.getVAlign() == 3) {
                                halign = HorizontalAlignment.LEFT;
                            }
                            excelCellStyle.setAlignment(halign);
                        } else {
                            halign = HorizontalAlignment.CENTER;
                            if (inCell.element.getVAlign() == 1) {
                                halign = HorizontalAlignment.LEFT;
                            } else if (inCell.element.getVAlign() == 2 || inCell.element.getVAlign() == 3) {
                                halign = HorizontalAlignment.RIGHT;
                            }
                            excelCellStyle.setAlignment(halign);
                        }
                        excelCellStyle.setFont(inCell.element.getRefFont());
                        excelCellStyle.setFontColor(inCell.element.getFontColor());
                        excelCellStyle.setUnderline(inCell.element.isUnderline());
                        excelCellStyle.setBgColor(inCell.element.getBgColor());
                        excelCellStyle.setRotation(angle);
                    }
                    if (inCell.value == null) {
                        cell.setCellType(CellType.BLANK);
                    } else if (inCell.value instanceof Number) {
                        double val = ((Number)inCell.value).doubleValue();
                        if (inCell.formula == null) {
                            cell.setCellValue(val);
                        } else if (this.excel.newSheetOption > 0 && inCell.formula.indexOf(44) != -1) {
                            cell.setCellFormula(null);
                            cell.setCellValue(val);
                        } else if (inCell.formula.startsWith("COUNTA(")) {
                            cell.setCellFormula(null);
                            cell.setCellValue(val);
                        } else {
                            try {
                                cell.setCellFormula(inCell.formula);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINEST, "Failed to set cell formula", e);
                                cell.setCellFormula(null);
                                cell.setCellValue(val);
                            }
                        }
                        short format = this.excel.findFormat(inCell.value, inCell.element.getDataFormat());
                        if (format > 0) {
                            excelCellStyle.setDataFormat(format);
                        }
                        if (Double.isNaN(val) || Double.isInfinite(val)) {
                            cell.setCellValue(0.0);
                        }
                    } else if (inCell.value instanceof Date) {
                        if (inCell.formula == null) {
                            cell.setCellValue((Date)inCell.value);
                        } else {
                            cell.setCellFormula(inCell.formula);
                        }
                        short format = this.excel.findFormat(inCell.value, inCell.element.getDataFormat());
                        if (format > 0) {
                            excelCellStyle.setDataFormat(format);
                        }
                    } else if (inCell.formula == null) {
                        v = inCell.value.toString();
                        cell.setCellValue(v);
                        excelCellStyle.setWrapText(true);
                        if (inCell.element != null && inCell.element.isNoWrap()) {
                            excelCellStyle.setWrapText(false);
                        }
                    } else {
                        cell.setCellFormula(inCell.formula);
                    }
                    cell.setCellStyle(this.excel.getCellStyle(excelCellStyle));
                    if (inCell.endRow - inCell.startRow <= 1 && inCell.endColumn - inCell.startColumn <= 1) continue;
                    sheet.addMergedRegionUnsafe(new CellRangeAddress(inCell.startRow + this.initialRow, inCell.endRow - 1 + this.initialRow, inCell.startColumn, inCell.endColumn - 1));
                }
                continue;
            }
            cell = row.createCell(0);
            cell.setCellType(CellType.BLANK);
        }
        rowCells = null;
        row = null;
        inCell = null;
        res = null;
        bis = null;
        bos = null;
        anchor = null;
        filename = null;
        chart = null;
        temp_report = null;
        cells = null;
        chartRecord = null;
        rdf = null;
        v = null;
        cell = null;
        excelCellStyle = null;
    }
}

