/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.excel;

import java.awt.Point;
import java.util.Vector;
import quadbase.reportdesigner.ReportElements.ReportCell;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportImage;
import quadbase.reportdesigner.ReportElements.ReportLine;
import quadbase.reportdesigner.ReportElements.ReportTable;
import quadbase.reportdesigner.report.excel.AddableCell;
import quadbase.reportdesigner.report.excel.Cell;
import quadbase.reportdesigner.report.excel.ExcelReport;
import quadbase.reportdesigner.report.excel.MatrixGriddedSection;

public class MergedExcelRows {
    private Vector<AddableCell> addableCells;
    private Vector<Double> yPos;
    private int mergedRows = 0;
    private double mergedRowHeight = 0.0;
    private Vector<MatrixGriddedSection> supplementGriddedSections;
    private MatrixGriddedSection rowGriddedSection = null;
    private ExcelReport excel;
    private Vector<ReportImage> gridsAndLines = new Vector();

    public MergedExcelRows(ExcelReport excel) {
        this.addableCells = new Vector();
        this.yPos = new Vector();
        this.supplementGriddedSections = new Vector();
        this.excel = excel;
    }

    public Vector<AddableCell> getAddableCells() {
        return this.addableCells;
    }

    public void setAddableCells(Vector<AddableCell> addableCells) {
        this.addableCells = addableCells;
    }

    public Vector<Double> getYPos() {
        return this.yPos;
    }

    public void setYPos(Vector<Double> yPos) {
        this.yPos = yPos;
    }

    public int getMergedRows() {
        return this.mergedRows;
    }

    public void incMergedRows() {
        ++this.mergedRows;
    }

    public void setMergedRows(int mergedRows) {
        this.mergedRows = mergedRows;
    }

    public double getMergedRowHeight() {
        return this.mergedRowHeight;
    }

    public void setMergedRowHeight(double mergedRowHeight) {
        this.mergedRowHeight = mergedRowHeight;
    }

    public Vector<MatrixGriddedSection> getSupplementGriddedSections() {
        return this.supplementGriddedSections;
    }

    public void setSupplementGriddedSections(Vector<MatrixGriddedSection> supplementGriddedSections) {
        this.supplementGriddedSections = supplementGriddedSections;
    }

    public MatrixGriddedSection getRowGriddedSection() {
        return this.rowGriddedSection;
    }

    public void setRowGriddedSection(MatrixGriddedSection rowGriddedSection) {
        this.rowGriddedSection = rowGriddedSection;
    }

    protected void writeSupplementSections() throws Exception {
        if (this.supplementGriddedSections.size() > 0) {
            for (int i = 0; i < this.supplementGriddedSections.size(); ++i) {
                MatrixGriddedSection subGS = this.supplementGriddedSections.elementAt(i);
                if (this.rowGriddedSection == null) {
                    this.rowGriddedSection = subGS;
                    continue;
                }
                this.rowGriddedSection.merge(subGS);
            }
            this.excel.exportGriddedSection(this.rowGriddedSection);
        }
    }

    protected void writeRows(ReportTable tbl, boolean removeLargerThanSectionHeightCells) throws Exception {
        this.setYPos(this.excel.groupPositionHelper(this.getYPos(), this.excel.ROW_MINIMUM_HEIGHT));
        if (removeLargerThanSectionHeightCells) {
            for (int i = this.getYPos().size() - 1; i >= 0; --i) {
                if (!(this.getYPos().get(i) > this.mergedRowHeight + this.excel.ROW_MINIMUM_HEIGHT)) continue;
                this.getYPos().remove(i);
            }
        }
        double[] yPoss = new double[this.getYPos().size()];
        for (int j = 0; j < this.getYPos().size(); ++j) {
            yPoss[j] = this.getYPos().elementAt(j);
        }
        MatrixGriddedSection gridSection = new MatrixGriddedSection(this.excel, tbl, null, this.excel.getRowNum(), this.excel.xPositions, yPoss);
        if (this.getMergedRows() > 0) {
            this.setAddableCells(this.rearrangeAddableCells(this.getAddableCells()));
        }
        for (int j = 0; j < this.getAddableCells().size(); ++j) {
            AddableCell addableCell = this.getAddableCells().elementAt(j);
            Cell c = addableCell.getCell();
            double startY = addableCell.getStartY();
            gridSection.add(c, startY);
            if (!c.isColumnCell) continue;
            int colIndex = c.columnIndex;
            if (this.excel.getColumnPositionMapping() == null || this.excel.getColumnPositionMapping().length <= colIndex || this.excel.getColumnPositionMapping()[colIndex] == null) continue;
            this.excel.getColumnPositionMapping()[colIndex].add(new Point(c.startColumn, c.startRow + this.excel.getRowNum()));
        }
        for (ReportCell reportCell : this.gridsAndLines) {
            if (reportCell instanceof ReportLine) {
                if (!reportCell.isVisible()) continue;
                gridSection.addReportLine((ReportLine)reportCell, 0.0, 0.0);
                continue;
            }
            if (!(reportCell instanceof ReportGrid) || !reportCell.isVisible()) continue;
            gridSection.addReportGrid((ReportGrid)reportCell, 0.0, 0.0);
        }
        this.gridsAndLines.clear();
        if (this.supplementGriddedSections.size() > 0) {
            if (this.rowGriddedSection == null) {
                this.rowGriddedSection = gridSection;
            } else {
                this.rowGriddedSection.append(gridSection);
            }
            for (int k = this.supplementGriddedSections.size() - 1; k >= 0; --k) {
                MatrixGriddedSection matrixGriddedSection = this.supplementGriddedSections.elementAt(k);
                if (!(this.rowGriddedSection.getTotalHeight() > matrixGriddedSection.getTotalHeight())) continue;
                this.rowGriddedSection.merge(matrixGriddedSection);
                this.supplementGriddedSections.removeElementAt(k);
            }
            if (this.supplementGriddedSections.size() == 0) {
                this.excel.exportGriddedSection(this.rowGriddedSection);
            }
        } else {
            this.excel.exportGriddedSection(gridSection);
        }
    }

    protected Vector<AddableCell> rearrangeAddableCells(Vector<AddableCell> addableCells) {
        Vector<AddableCell> inBoundCells = new Vector<AddableCell>();
        Vector<AddableCell> outOfBoundCells = new Vector<AddableCell>();
        for (AddableCell addableCell : addableCells) {
            if (addableCell.isOutOfBounds()) {
                outOfBoundCells.add(addableCell);
                continue;
            }
            inBoundCells.add(addableCell);
        }
        inBoundCells.addAll(outOfBoundCells);
        return inBoundCells;
    }

    public void addAddableCell(AddableCell cellV) {
        this.addableCells.add(cellV);
    }

    public void resetRowData() {
        this.addableCells = new Vector();
        this.yPos = new Vector();
        this.mergedRows = 0;
        this.mergedRowHeight = 0.0;
    }

    public void addReportGridOrLine(ReportImage cell) {
        this.gridsAndLines.add(cell);
    }

    public void addReportGridsAndLines(ReportImage[] images) {
        for (ReportImage image : images) {
            if (!(image instanceof ReportLine) && !(image instanceof ReportGrid)) continue;
            this.addReportGridOrLine(image);
        }
    }
}

