/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.message;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.report.ColMetaData;
import quadbase.reportdesigner.report.IOUtil2;

public class ReadDBqueryMeta {
    private static final Logger LOGGER = Logger.getLogger(ReadDBqueryMeta.class.getName());

    public static Vector<ColMetaData> getMeta(Vector parameters, DBInfoBasic dbInfo, boolean transposeData, boolean[] transposeCol) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDBqueryMeta.sendMessage(socket, parameters, dbInfo, transposeData, transposeCol);
        return ReadDBqueryMeta.receiveReply(socket);
    }

    private static void sendMessage(IConnection socket, Vector parameters, DBInfoBasic dbInfo, boolean transposeData, boolean[] transposeCol) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(23612);
        dbInfo.write(dout);
        boolean hasParameter = QueryFileInfo.hasParameter(parameters);
        dout.writeBoolean(hasParameter);
        if (hasParameter) {
            ReadDBqueryMeta.findInParam(parameters).write(dout);
        }
        dout.writeBoolean(false);
        dout.writeBoolean(transposeData);
        IOUtil.writeBooleans(dout, transposeCol);
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Can't write data", ex);
            socket.close();
            throw ex;
        }
    }

    private static Vector<ColMetaData> receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int nInfo = dstream.readInt();
            Vector<ColMetaData> output = new Vector<ColMetaData>();
            for (int i = 0; i < nInfo; ++i) {
                ColMetaData value = ColMetaData.read(dstream, 7004);
                output.addElement(value);
            }
            dstream.close();
            socket.close();
            return output;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to read data", ex);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Failed to read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Cannot close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
    }

    private static QueryInParamSet findInParam(Vector parameter) {
        for (int i = 0; i < parameter.size(); ++i) {
            Object target = parameter.elementAt(i);
            if (!(target instanceof QueryInParamSet)) continue;
            return (QueryInParamSet)target;
        }
        return null;
    }
}

