/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.report.message;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.util.internal.Coder;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.report.ColMetaData;
import quadbase.reportdesigner.report.IOUtil2;

public class ReadDataFileMeta {
    private static final Logger LOGGER = Logger.getLogger(ReadDataFileMeta.class.getName());

    public static Vector getMeta(String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        IConnection socket = ServerMessage.createConnection();
        ReadDataFileMeta.sendMessage(socket, dataFilename, transposeData, transposeCol, dataType, inSet);
        return ReadDataFileMeta.receiveReply(socket);
    }

    private static void sendMessage(IConnection socket, String dataFilename, boolean transposeData, boolean[] transposeCol, int dataType, QueryInParamSet inSet) throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeShort(25367);
        IOUtil.writeString(dout, Coder.encode(dataFilename));
        dout.writeBoolean(transposeData);
        IOUtil.writeBooleans(dout, transposeCol);
        dout.writeInt(dataType);
        dout.writeBoolean(inSet != null);
        if (inSet != null) {
            inSet.write(dout);
        }
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Cannot write data", ex);
            socket.close();
            throw ex;
        }
    }

    private static Vector receiveReply(IConnection socket) throws Exception {
        try {
            DataInputStream dstream = new DataInputStream(socket.getInputStream());
            int code = dstream.readInt();
            if (code != 0) {
                throw new IOException(IOUtil2.getErrorString(code) + IOUtil.readString(dstream, true));
            }
            int nInfo = dstream.readInt();
            Vector<ColMetaData> output = new Vector<ColMetaData>();
            for (int i = 0; i < nInfo; ++i) {
                ColMetaData value = ColMetaData.read(dstream, 7004);
                output.addElement(value);
            }
            dstream.close();
            socket.close();
            return output;
        }
        catch (Exception ex) {
            try {
                LOGGER.log(Level.FINEST, "Failed to read data", ex);
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
            }
            throw ex;
        }
        catch (Error err) {
            LOGGER.log(Level.FINEST, "Failed to read data", err);
            try {
                socket.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close socket", ex2);
            }
            throw new Exception(err.getMessage());
        }
    }
}

