/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import quadbase.common.util.internal.LanguageEncoder;
import quadbase.reportdesigner.util.IFormat;
import quadbase.reportdesigner.util.internal.FormatUtil;

public class BarcodeFormat
implements IFormat {
    public static final int CODE39WITHCHECKSUM = 0;
    public static final int CODE39WITHOUTCHECKSUM = 1;
    public static final int INT2OF5 = 2;
    public static final int CODE2OF7 = 3;
    public static final int CODABAR = 4;
    public static final int EAN128 = 5;
    public static final int UPCA = 6;
    public static final int STD2OF5WITHCHECKDIGIT = 7;
    public static final int STD2OF5WITHOUTCHECKDIGIT = 8;
    public static final int BOOKLAND = 9;
    public static final int EAN13 = 10;
    public static final int EAN8 = 11;
    public static final int PDF417 = 12;
    public static final int CODE128 = 13;
    public static final int CODE128A = 14;
    public static final int CODE128B = 15;
    public static final int CODE128C = 16;
    public static final int USD3WITHCHECKSUM = 17;
    public static final int USD3WITHOUTCHECKSUM = 18;
    public static final int CODE3OF9WITHCHECKSUM = 19;
    public static final int CODE3OF9WITHOUTCHECKSUM = 20;
    public static final int GLOBALTRADEITEMNUMBER = 21;
    public static final int MONARCH = 22;
    public static final int NW7 = 23;
    public static final int RANDOMWEIGHTUPCA = 24;
    public static final int SCC14SHIPPINGCODE = 25;
    public static final int SHIPMENTIDENTIFICATIONNUMBER = 26;
    public static final int SSCC18 = 27;
    public static final int USPS = 28;
    public static final int USD4 = 29;
    public static final int QRC = 30;
    public static final int DEFAULT = 0;
    public static String[] BARCODE_NAME = new String[]{LanguageEncoder.getText("Code 39 with checksum"), LanguageEncoder.getText("Code 39 without checksum"), LanguageEncoder.getText("Interleave 2 of 5"), LanguageEncoder.getText("Code 2 of 7 (Codabar)"), LanguageEncoder.getText("Codabar"), LanguageEncoder.getText("EAN 128"), LanguageEncoder.getText("UPCA"), LanguageEncoder.getText("Standard 2 of 5 with check digit"), LanguageEncoder.getText("Standard 2 of 5 without check digit"), LanguageEncoder.getText("Bookland"), LanguageEncoder.getText("EAN 13"), LanguageEncoder.getText("EAN 8"), LanguageEncoder.getText("PDF 417"), LanguageEncoder.getText("Code 128"), LanguageEncoder.getText("Code 128A"), LanguageEncoder.getText("Code 128B"), LanguageEncoder.getText("Code 128C"), LanguageEncoder.getText("USD 3 with checksum"), LanguageEncoder.getText("USD 3 without checksum"), LanguageEncoder.getText("Code 3 of 9 with checksum"), LanguageEncoder.getText("Code 3 of 9 without checksum"), LanguageEncoder.getText("Global Trade Item Number"), LanguageEncoder.getText("Monarch"), LanguageEncoder.getText("NW 7"), LanguageEncoder.getText("Random Weight UPCA"), LanguageEncoder.getText("SCC 14 Shipping Code"), LanguageEncoder.getText("Shipment Identification Number"), LanguageEncoder.getText("SSCC 18"), LanguageEncoder.getText("US Postal Service"), LanguageEncoder.getText("USD 4"), LanguageEncoder.getText("QR Code")};
    int style;

    public BarcodeFormat(int format) {
        this.setformat(format);
    }

    @Override
    public int getFormatType() {
        return 6;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            obj = FormatUtil.nullString;
        }
        String str = obj.toString();
        return str;
    }

    @Override
    public String getTextFormat() {
        return "6:" + this.style + "";
    }

    public int getformat() {
        return this.style;
    }

    public void setformat(int format) {
        if (format < 0) {
            format = 0;
        }
        this.style = format;
    }
}

