/*
 * Decompiled with CFR 0.152.
 */
package quadbase.reportdesigner.util;

import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import quadbase.reportdesigner.ReportElements.ReportElement;
import quadbase.reportdesigner.ReportElements.ReportGrid;
import quadbase.reportdesigner.ReportElements.ReportLine;

public class CSSStyle {
    private Font font = new Font("Dialog", 0, 9);
    private Color fontColor = Color.black;
    private Color bgColor = Color.white;
    private short align = 0;
    private Color borderColor = Color.black;
    private String styleName = "";
    private boolean isUnderline = false;
    private double rotation = 0.0;
    private double width = 0.0;
    private double height = 0.0;
    private int roundCornerRadius = 0;
    private boolean[] roundCornersArray = new boolean[4];
    private int borderStyle = 1;
    private int topBorder = 0;
    private int rightBorder = 0;
    private int bottomBorder = 0;
    private int leftBorder = 0;

    public CSSStyle() {
    }

    public CSSStyle(ReportElement elt) {
        this.font = elt.getFont();
        this.fontColor = elt.getFontColor();
        this.bgColor = elt.getBgColor();
        this.align = elt.getAlign();
        this.borderColor = elt.getBorderColor();
        this.styleName = elt.getStyleName();
        this.isUnderline = elt.isUnderline();
        this.rotation = elt.getRotateAngle();
        this.width = elt.getWidth();
        this.height = elt.getHeight();
        this.roundCornerRadius = elt.getRoundCornerRadius();
        this.roundCornersArray = elt.getRoundCornersArray();
        if (elt instanceof ReportGrid) {
            this.borderStyle = ((ReportGrid)elt).getGridStyle();
        } else if (elt instanceof ReportLine) {
            this.borderStyle = ((ReportLine)elt).getLineStyle();
        }
        this.topBorder = elt.getTopBorder();
        this.rightBorder = elt.getRightBorder();
        this.bottomBorder = elt.getBottomBorder();
        this.leftBorder = elt.getLeftBorder();
    }

    public CSSStyle(CSSStyle _style) {
        this.font = _style.font;
        this.fontColor = _style.fontColor;
        this.bgColor = _style.bgColor;
        this.align = _style.align;
        this.borderColor = _style.borderColor;
        this.styleName = _style.styleName;
        this.isUnderline = _style.isUnderline;
        this.rotation = _style.rotation;
        this.width = _style.width;
        this.height = _style.height;
        this.roundCornerRadius = _style.roundCornerRadius;
        this.roundCornersArray = _style.roundCornersArray;
        this.borderStyle = _style.borderStyle;
        this.topBorder = _style.topBorder;
        this.rightBorder = _style.rightBorder;
        this.bottomBorder = _style.bottomBorder;
        this.leftBorder = _style.leftBorder;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public void setBgColor(Color color) {
        this.bgColor = color;
    }

    public void setAlign(short align) {
        this.align = align;
    }

    public void setBorder(int border) {
        this.topBorder = border;
        this.leftBorder = border;
        this.rightBorder = border;
        this.bottomBorder = border;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public void setUnderline(boolean state) {
        this.isUnderline = state;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public short getAlign() {
        return this.align;
    }

    public int getBorder() {
        return this.topBorder;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public boolean isUnderline() {
        return this.isUnderline;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public int getTopBorder() {
        return this.topBorder;
    }

    public int getRightBorder() {
        return this.rightBorder;
    }

    public int getBottomBorder() {
        return this.bottomBorder;
    }

    public void setBottomBorder(int bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    public void setRightBorder(int rightBorder) {
        this.rightBorder = rightBorder;
    }

    public void setTopBorder(int topBorder) {
        this.topBorder = topBorder;
    }

    public int getLeftBorder() {
        return this.leftBorder;
    }

    public void setLeftBorder(int leftBorder) {
        this.leftBorder = leftBorder;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public int getRoundCornerRadius() {
        return this.roundCornerRadius;
    }

    public boolean[] getRoundCornersArray() {
        return this.roundCornersArray;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.align;
        result = 31 * result + (this.bgColor == null ? 0 : this.bgColor.hashCode());
        result = 31 * result + this.topBorder;
        result = 31 * result + this.leftBorder;
        result = 31 * result + this.rightBorder;
        result = 31 * result + this.bottomBorder;
        result = 31 * result + (this.borderColor == null ? 0 : this.borderColor.hashCode());
        result = 31 * result + this.borderStyle;
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.fontColor == null ? 0 : this.fontColor.hashCode());
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isUnderline ? 1231 : 1237);
        temp = Double.doubleToLongBits(this.rotation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.roundCornerRadius;
        result = 31 * result + Arrays.hashCode(this.roundCornersArray);
        result = 31 * result + (this.styleName == null ? 0 : this.styleName.hashCode());
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CSSStyle other = (CSSStyle)obj;
        if (this.align != other.align) {
            return false;
        }
        if (this.bgColor == null ? other.bgColor != null : !this.bgColor.equals(other.bgColor)) {
            return false;
        }
        if (this.topBorder != other.topBorder || this.leftBorder != other.leftBorder || this.rightBorder != other.rightBorder || this.bottomBorder != other.bottomBorder) {
            return false;
        }
        if (this.borderColor == null ? other.borderColor != null : !this.borderColor.equals(other.borderColor)) {
            return false;
        }
        if (this.borderStyle != other.borderStyle) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        if (this.fontColor == null ? other.fontColor != null : !this.fontColor.equals(other.fontColor)) {
            return false;
        }
        if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
            return false;
        }
        if (this.isUnderline != other.isUnderline) {
            return false;
        }
        if (Double.doubleToLongBits(this.rotation) != Double.doubleToLongBits(other.rotation)) {
            return false;
        }
        if (this.roundCornerRadius != other.roundCornerRadius) {
            return false;
        }
        if (!Arrays.equals(this.roundCornersArray, other.roundCornersArray)) {
            return false;
        }
        if (this.styleName == null ? other.styleName != null : !this.styleName.equals(other.styleName)) {
            return false;
        }
        return Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width);
    }

    public boolean hasBorder() {
        return this.topBorder > 0 || this.rightBorder > 0 || this.bottomBorder > 0 || this.leftBorder > 0;
    }
}

